@extends('layouts.app')
@section('title', 'Daily call Reports')
@section('content')

    <style>
        .table>thead>tr>td,
        .table>thead>tr>th {
            padding: 0.4rem;
            vertical-align: middle;
        }
    </style>
    <style>
        /* Custom style for pagination links */
        .pagination {
            margin: 0;
            /* Remove default margin */
            padding: 0;
            /* Remove default padding */
            list-style: none;
            /* Remove list bullet points */
            display: flex;
            /* Use flex layout for horizontal alignment */
        }

        .pagination li a {
            padding: 6px;
        }

        .pagination a {
            display: inline-block;
            padding: 0;
            /* Adjust the padding as needed */
            text-decoration: none;
            background-color: #f0f0f0;
            border: 1px solid #ccc;
            color: #333;
            transition: background-color 0.3s ease, color 0.3s ease;
        }

        .pagination a:hover {
            background-color: #ccc;
            color: #fff;
        }

        .pagination .active a {
            background-color: #007bff;
            color: #fff;
        }
    </style>
    <?php
    
    error_reporting(0);
    
    if (!empty(request()->input('start_date'))) {
        $startDate = request()->input('start_date');
    } else {
        $current_date = date('Y-m-d');
        //$str_date = strtotime(date("Y-m-d"));//, strtotime($current_date)) . " - day");
        $str_date = strtotime(date('Y-m-d', strtotime($current_date)) . ' -90 day');
        $startDate = date('Y-m-d', $str_date);
        $startDate = date('Y-m-d', strtotime($current_date));
        // $startDate = date('Y-m-d');//, $str_date);
    }
    
    if (!empty(request()->input('end_date'))) {
        $endDate = request()->input('end_date');
    } else {
        $endDate = date('Y-m-d');
    }
    $url_page = explode('?', str_replace('/', '', $_SERVER['REQUEST_URI']));
    $url = $url_page[0];
    ?>
    <section class="content">
        <div class="row">
            <div class="col-lg-12 col-12">
                <div class="box">
                    <div class="box-body"><!--bg-lightest-->
                        <h4 class="box-title text-info mb-0"id="show"><i class="icon-Add-user"><span
                                    class="path1"></span><span class="path2"></span></i> SMS AI daily Reports</h4>

                        <hr class="my-15">
                        <form method="post">
                            @csrf
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">Date:</label>
                                    <div class="input-group mb-3">
                                        <div class="input-group-addon">
                                            <i class="fa fa-calendar"></i>
                                        </div>
                                        <input type="text" class="form-control pull-right cdr-range" id="reservation2">
                                        <input type="hidden" id="start_date" name="start_date" value="{{ $startDate }}">
                                        <input type="hidden" id="end_date" name="end_date" value="{{ $endDate }}">
                                    </div>
                                </div>
                            </div>
                            <button type="submit" name="submit"style="float:right;" id="form_submit" value="Search"
                                class="btn btn btn-primary waves-effect waves-light"><i class="fa fa-search"
                                    aria-hidden="true"></i> Search</button>
                        </form>
                        <h4>Time Period</h4>
                        @if (isset($time_period['from']) && !empty($time_period['from']))
                            <p>From:
                                {{ \Carbon\Carbon::parse($time_period['from'])->format('d M Y, h:i A') }}

                            </p>
                            <p>To: {{ \Carbon\Carbon::parse($time_period['to'])->format('d M Y, h:i A') }}</p>
                        @else
                            <p>No Daily Call Report found</p>
                        @endif

                        <!-- <h4>Message Statistics</h4>
                                                                                                                     <ul>
                                                                                                                        <li>Total Messages:{{ $message_statistics['total_messages'] }}</li>
                                                                                                                     <li>Total Sent:{{ $message_statistics['total_sent'] }}</li>
                                                                                                                     <li>Total Received:{{ $message_statistics['total_received'] }}</li>
                                                                                                                     <li>Unique Conversations:{{ $message_statistics['unique_conversations'] }}</li>
                                                                                                                    </ul> -->
                        <!-- <h4>Conversation Analysis</h4>
                                                                                                                     <ul>
                                                                                                                        <li>Total Analyzed:{{ $conversation_analysis['total_analyzed'] }}</li>
                                                                                                                     <li>Interested:{{ $conversation_analysis['interested'] }}</li>
                                                                                                                     <li>Not Interested:{{ $conversation_analysis['not_interested'] }}</li>
                                                                                                                     <li>Undecided:{{ $conversation_analysis['undecided'] }}</li>
                                                                                                                    </ul> -->
                        <div class="table-responsive">

                            <h4>Message Statistics</h4>
                            <table id="tickets1" class="table-responsive table-bordered table  table-hover">
                                <thead>
                                    <tr>
                                        <th>Total Messages</th>
                                        <th>Total Sent</th>
                                        <th>Total Received</th>
                                        <th>Unique Conversations</th>

                                    </tr>
                                </thead>

                                <tbody>
                                    <tr>
                                        <td>{{ $message_statistics['total_messages'] }}</td>
                                        <td>{{ $message_statistics['total_sent'] }}</td>
                                        <td>{{ $message_statistics['total_received'] }}</td>
                                        <td>{{ $message_statistics['unique_conversations'] }}</td>

                                    </tr>


                                </tbody>



                            </table>
                        </div>
                        <div class="table-responsive">
                            <h4>Conversation Analysis</h4>
                            <table id="tickets1" class="table-responsive table-bordered table  table-hover">
                                <thead>
                                    <tr>
                                        <th>Total Analyzed</th>
                                        <th>Interested</th>
                                        <th>Not Interested</th>
                                        <th>Undecided</th>

                                    </tr>
                                </thead>

                                <tbody>
                                    <tr>
                                        <td>{{ $conversation_analysis['total_analyzed'] }}</td>
                                        <td>{{ $conversation_analysis['interested'] }}</td>
                                        <td>{{ $conversation_analysis['not_interested'] }}</td>
                                        <td>{{ $conversation_analysis['undecided'] }}</td>

                                    </tr>


                                </tbody>



                            </table>
                        </div>

                        <div class="table-responsive">
                            <h4>Delivery status</h4>
                            <table id="tickets1" class="table-responsive table-bordered table  table-hover">
                                <thead>
                                    <tr>
                                        <th>Status</th>
                                        <th>Count</th>

                                    </tr>
                                </thead>

                                <tbody>
                                    <tr>
                                        <td>Delivered</td>
                                        <td>{{ $delivery_status['delivered'] }} </td>
                                    </tr>
                                    <tr>
                                        <td>Queued</td>
                                        <td>{{ $delivery_status['queued'] }}</td>
                                    </tr>
                                    <tr>
                                        <td>Sent</td>
                                        <td>{{ $delivery_status['sent'] }}</td>
                                    </tr>
                                    <tr>
                                        <td>Undelivered</td>
                                        <td>{{ $delivery_status['undelivered'] }}</td>
                                    </tr>
                                    <tr>
                                        <td>Received</td>
                                        <td>{{ $delivery_status['received'] }}</td>
                                    </tr>
                                </tbody>



                            </table>
                        </div>
                        <div class="table-responsive">
                            <h4>Interested Leads</h4>
                            <table id="tickets1" class="table-responsive table-bordered table  table-hover">
                                <thead>
                                    <tr>
                                        <th>Source</th>
                                        <th>Destination</th>
                                        <th>Name</th>
                                        <th>Email</th>
                                        <th>Company</th>

                                    </tr>
                                </thead>

                                <tbody>
                                    @foreach ($interested_conversations as $conversion)
                                        <tr>
                                            <td>{{ $conversion['source'] }}</td>
                                            <td>{{ $conversion['destination'] }}</td>
                                            <td>{{ $conversion['user_details']['first_name'] }}</td>
                                            <td>{{ $conversion['user_details']['email'] }}</td>
                                            <td>{{ $conversion['user_details']['company_name'] }}</td>

                                        </tr>
                                    @endforeach
                                </tbody>



                            </table>
                        </div>


                        <div class="table-responsive">
                            <h4>Sent Numbers</h4>
                            <table id="tickets1" class="table-responsive table-bordered table  table-hover">
                                <thead>
                                    <tr>
                                        <th>Number</th>


                                    </tr>
                                </thead>

                                <tbody>
                                    @foreach ($sent_numbers as $sent_number)
                                        <tr>
                                            <td>{{ $sent_number }}</td>

                                        </tr>
                                    @endforeach
                                </tbody>



                            </table>
                        </div>

                        <div class="table-responsive">
                            <h4>Failed Numbers</h4>
                            <table id="tickets1" class="table-responsive table-bordered table  table-hover">
                                <thead>
                                    <tr>
                                        <th>Number</th>


                                    </tr>
                                </thead>

                                <tbody>
                                    @foreach ($failed_numbers as $failed_number)
                                        <tr>
                                            <td>{{ $failed_number }}</td>

                                        </tr>
                                    @endforeach
                                </tbody>



                            </table>
                        </div>

                        <div class="table-responsive">
                            <h4>Queued Numbers</h4>
                            <table id="tickets1" class="table-responsive table-bordered table  table-hover">
                                <thead>
                                    <tr>
                                        <th>Number</th>


                                    </tr>
                                </thead>

                                <tbody>
                                    @foreach ($queued_numbers as $queued_number)
                                        <tr>
                                            <td>{{ $queued_number }}</td>

                                        </tr>
                                    @endforeach
                                </tbody>



                            </table>
                        </div>


                        <div class="table-responsive">
                            <h4>Sending Numbers</h4>
                            <table id="tickets1" class="table-responsive table-bordered table  table-hover">
                                <thead>
                                    <tr>
                                        <th>Number</th>


                                    </tr>
                                </thead>

                                <tbody>
                                    @foreach ($sending_numbers as $sending_number)
                                        <tr>
                                            <td>{{ $sending_number }}</td>

                                        </tr>
                                    @endforeach
                                </tbody>



                            </table>
                        </div>



                        <div class="table-responsive">
                            <h4>Canceled Numbers</h4>
                            <table id="tickets1" class="table-responsive table-bordered table  table-hover">
                                <thead>
                                    <tr>
                                        <th>Number</th>


                                    </tr>
                                </thead>

                                <tbody>
                                    @foreach ($canceled_numbers as $canceled_number)
                                        <tr>
                                            <td>{{ $canceled_number }}</td>

                                        </tr>
                                    @endforeach
                                </tbody>



                            </table>
                        </div>


                        <div class="table-responsive">
                            <h4>Scheduled Numbers</h4>
                            <table id="tickets1" class="table-responsive table-bordered table  table-hover">
                                <thead>
                                    <tr>
                                        <th>Number</th>


                                    </tr>
                                </thead>

                                <tbody>
                                    @foreach ($scheduled_numbers as $scheduled_number)
                                        <tr>
                                            <td>{{ $scheduled_number }}</td>

                                        </tr>
                                    @endforeach
                                </tbody>



                            </table>
                        </div>

                        <div class="table-responsive">
                            <h4>Undelivered Numbers</h4>
                            <table id="tickets1" class="table-responsive table-bordered table  table-hover">
                                <thead>
                                    <tr>
                                        <th>Number</th>


                                    </tr>
                                </thead>

                                <tbody>
                                    @foreach ($undelivered_numbers as $undelivered_number)
                                        <tr>
                                            <td>{{ $undelivered_number }}</td>

                                        </tr>
                                    @endforeach
                                </tbody>



                            </table>
                        </div>
                        <div class="table-responsive">
                            <h4>Partially Delivered Numbers</h4>
                            <table id="tickets1" class="table-responsive table-bordered table  table-hover">
                                <thead>
                                    <tr>
                                        <th>Number</th>


                                    </tr>
                                </thead>

                                <tbody>
                                    @foreach ($partially_delivered_numbers as $partially_delivered_number)
                                        <tr>
                                            <td>{{ $partially_delivered_number }}</td>

                                        </tr>
                                    @endforeach
                                </tbody>



                            </table>
                        </div>



                        <div>

                        </div>

                    </div>
                </div>
            </div>


        </div>
        </div>
        </div>






    </section>
    @push('styles')
        <link rel="stylesheet" type="text/css"
            href="{{ asset('assets/plugins/dashboard_date/bootstrap-datepicker.min.css') }}">
        <link rel="stylesheet" type="text/css" href="{{ asset('assets/plugins/dashboard_date/bootstrap-datepicker.css') }}">
    @endpush

    @push('scripts')
        <!-- Vendor JS -->

        <script src="{{ asset('assets/plugins/dashboard_date/moment.min.js') }}"></script>
        <script src="{{ asset('assets/plugins/dashboard_date/bootstrap-datepicker.min.js') }}"></script>
        <script src="{{ asset('assets/plugins/dashboard_date/daterangepicker.js') }}"></script>

        <script>
            $(document).ready(function() {
                $('#reservation2').daterangepicker({
                    locale: {
                        format: 'YYYY-MM-DD'
                    },
                    "startDate": "{{ $startDate }}",
                    "endDate": "{{ $endDate }}",
                    singleDatePicker: true, // Restricts selection to a single date
                    opens: 'right'
                }, function(start) {
                    console.log('Date selected: ' + start.format('YYYY-MM-DD'));
                    $("#start_date").val(start.format('YYYY-MM-DD'));
                    $("#end_date").val(start.format('YYYY-MM-DD')); // Ensure end date is the same
                });

                // Ensure empty fields if no dates are set
                if ("{{ $startDate }}" === '') {
                    $("#start_date").val('');
                }

                if ("{{ $endDate }}" === '') {
                    $("#end_date").val('');
                }
            });
        </script>
    @endpush

@endsection
