@extends('layouts.app')
@section('title', 'SMS AI List')

@section('content')
<style>
/* Style for the active state */
.btn-toggle.active {
    background-color: #2196f3;
    /* Set to the desired green color */
    color: white;
    /* Set to the desired text color */
    border-color: green;
    /* Set to the desired border color */
}

/* Style for the inactive state */
.btn-toggle:not(.active) {
    background-color: red;
    /* Set to the desired red color */
    color: white;
    /* Set to the desired text color */
    border-color: red;
    /* Set to the desired border color */
}

.badge {
    font-size: 1rem;
    font-style: normal;
    font-weight: 400;
    font-family: "IBM Plex Sans", sans-serif;
    line-height: 1.5;
}
</style>
<style type="text/css">
.dialog-background {
    background: none repeat scroll 0 0 rgba(244, 244, 244, 0.5);
    height: 100%;
    left: 0;
    margin: 0;
    padding: 0;
    position: absolute;
    top: 0;
    width: 100%;
    z-index: 100;
}

.dialog-loading-wrapper {
    background: none repeat scroll 0 0 rgba(244, 244, 244, 0.5);
    border: 0 none;
    height: 100px;
    left: 50%;
    margin-left: -50px;
    margin-top: -50px;
    position: fixed;
    top: 50%;
    width: 100px;
    z-index: 9999999;
}
</style>

<style>
.lender-modal {
    border-radius: 10px;
    background-color: #fff;
    font-family: "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
}

.lender-modal > .modal-header {
    border-bottom: 1px solid #ddd !important;
    padding-bottom: 10px !important;
    margin-bottom: 18px !important;
}

.lender-modal .col-md-4 {
    margin-bottom: 14px;
}



.lender-modal .col-md-4 > .value-text {
    display: block !important;
    margin-left: 22px;
    width: 100%;
    clear: both;
    float: none;

}

.lender-modal .col-md-4 > label {
    display: block;
    width: 100%;
    float: none;
}



.value-text:hover {
    background-color: #2196f3;
    color: #ffffff;
    transition: 0.25s ease;
}

.lender-modal > .modal-body {
    padding-top: 2px !important;
    padding-left: 18px !important;
    padding-right: 18px !important;
}


.file-upload-box {
    border: 2px dashed #19a7ce;
    border-radius: 8px;
    background: #f9f9f9;
    text-align: center;
    padding: 40px 20px;
    cursor: pointer;
    position: relative;
    transition: 0.3s ease-in-out;
    width: 100%;
}

.file-upload-box:hover {
    background: #eefbff;
    border-color: #0d6efd;
}

.file-upload-box input[type="file"] {
    display: none;
}

.file-upload-box .upload-icon {
    font-size: 40px;
    color: #0d6efd;
    margin-bottom: 10px;
}

.file-upload-box p {
    margin: 0;
    color: #555;
}

.file-upload-box small {
    display: block;
    margin-top: 8px;
    font-size: 12px;
    color: #777;
}

.form-label {
    margin-bottom: 0.5rem;
}
</style>

<!-- Main content -->

<section class="content">

    <div class="row">




        <div class="col-12">
            <div class="box">

                <div class="box-body">
                    <h4 class="box-title text-info mb-0"><i class="fa fa-user fa-sx"></i> SMS AI List</h4>
                    <a id="openListForm" type="submit" style="float:right"
                        class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i
                            class="fa fa-plus"></i> Add SMS AI List</a>
                    <hr class="my-15">
                    <div class="table-responsive">
                        <table id="tickets" class="table mt-0 table-hover no-wrap" data-page-size="10">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Title</th>
                                    <th>Campaign Name</th>
                                    <th>Dialled Leads/Total Leads</th>
                                    <th>Created Date</th>
                                    <th>Is Dialing</th>

                                    <th>Status</th>
                                    <th>Action</th>

                                </tr>
                            </thead>
                            <tbody>
                                @foreach($list_data as $key => $lists)
                                <tr>
                                    <th scope="row">{{$key+1}}</th>
                                    <td>{{$lists->title}}</td>
                                    <td>
                                        {{ucwords($lists->campaign_name)}}

                                    </td>
                                    <td>{{$lists->sms_ai_lead_report_count}}/{{$lists->total_leads}}</td>
                                    <td>{{ \Carbon\Carbon::parse($lists->updated_at)->format('dS M Y')}}</td>
                                    <td>
                                        @if($lists->is_dialing == '0')
                                        <span class="badge badge-sm badge-warning">NO</span>
                                        @elseif($lists->is_dialing == '1')
                                        <span class="badge badge-sm badge-success">YES</span>
                                        @endif
                                    </td>
                                    <td>
                                        <button type="button" data-campaignid="{{$lists->campaign_id}}"
                                            data-listid="{{$lists->id}}"
                                            class="btn btn-sm btn-toggle  @if($lists->status == 1) active @endif"
                                            data-bs-toggle="button" aria-pressed="true" autocomplete="off">
                                            <div class="handle"></div>
                                        </button>


                                    <td class="text-center">
                                        <div class="list-icons d-inline-flex">
                                            <a type="button" style="cursor:pointer;" data-bs-toggle="modal"
                                                data-bs-target="#myModal{{$lists->id}}" class="list-icons-item me-10"><i
                                                    class="fa fa-eye fa-lg"></i></a>
                                            <div class="list-icons-item dropdown">
                                                <a href="#" class="list-icons-item dropdown-toggle"
                                                    data-bs-toggle="dropdown"><i class="fa fa-file-text"></i></a>
                                                <div class="dropdown-menu dropdown-menu-end">
                                                    <a class="dropdown-item editEG" style="cursor:pointer;"
                                                        href="/smsai/list/edit/{{$lists->id}}/{{$lists->campaign_id}}"><i
                                                            class="fa fa-edit fa-lg"></i> Edit</a>
                                                    <div class="dropdown-divider"></div>
                                                    <a class="dropdown-item deleteList" style="cursor:pointer;"
                                                        data-camid="{{$lists->campaign_id}}" data-id="{{$lists->id}}"><i
                                                            class="fa fa-trash-o fa-lg"></i> Delete</a>
                                                    <div class="dropdown-divider"></div>
                                                    <a class="dropdown-item recycleList" style="cursor:pointer;"
                                                        data-camid="{{$lists->campaign_id}}" data-id="{{$lists->id}}"><i
                                                            class="fas fa-recycle"></i> Recycle</a>
                                                    <div class="dropdown-divider"></div>

                                                    <a class="dropdown-item " style="cursor:pointer;"
                                                        href="/uploads/sms-ai/{{$lists->file_name}}"><i
                                                            class="fa fa-download fa-lg"></i> Download</a>

                                                </div>
                                            </div>
                                        </div>
                                    </td>


                                </tr>
                              <div id="myModal{{$lists->id}}" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content lender-modal border-0 shadow-none mt-0">

      <!-- Modal Header -->
  <div class="modal-header pt-2">
    <h4 class="modal-title fw-semibold mt-2">
        <i class="ti-list me-2 text-icon" style="color:black; position: relative; top: -2px;"></i> List Details
    </h4>
    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
</div>


      <!-- Modal Body -->
      <div class="modal-body pt-1 mb-0 px-2">

        <div class="row">

          <!-- Left Column -->
          <div class="col-md-6 mb-2">

            <!-- List Name -->
            <div class="form-group">
              <i class="ti-user me-1 text-icon"></i>
              <label class="form-label">List Name</label>
              <p><span class="badge badge-sm badge-primary">{{ ucwords($lists->title) }}</span></p>
            </div>

            <!-- Campaign Name -->
            <div class="form-group">
              <i class="ti-user me-1 text-icon"></i>
              <label class="form-label">Campaign Name</label>
              <p><span class="badge badge-sm badge-primary">{{ ucwords($lists->campaign_name) }}</span></p>
            </div>

            <!-- Status -->
            <div class="form-group">
              <i class="ti-info-alt me-1 text-icon"></i>
              <label class="form-label">Status</label>
              <p>
                <span class="badge badge-sm badge-@if($lists->status == '1')success @else warning @endif">
                  @if($lists->status == '1') Active @else Inactive @endif
                </span>
              </p>
            </div>

          </div>

          <!-- Right Column -->
          <div class="col-md-6 mb-2">

            <!-- Total Leads -->
            <div class="form-group">
              <i class="ti-mobile me-1 text-icon"></i>
              <label class="form-label">Total Leads</label>
              <p><span class="badge badge-sm badge-primary">{{ $lists->total_leads }}</span></p>
            </div>

            <!-- Created Date -->
            <div class="form-group">
              <i class="ti-calendar me-1 text-icon"></i>
              <label class="form-label">Created Date</label>
              <p><span class="badge badge-sm badge-primary">{{ \Carbon\Carbon::parse($lists->updated_at)->format('dS M Y') }}</span></p>
            </div>

            <!-- File Name -->
            <div class="form-group">
              <i class="ti-file me-1 text-icon"></i>
              <label class="form-label">File Name</label>
              <p>
                <span class="badge badge-sm badge-primary">
                  <a href="/uploads/sms-ai/{{$lists->file_name}}" target="_blank" style="color:#fff;">
                    {{ $lists->file_name }}
                  </a>
                </span>
              </p>
            </div>

          </div>

        </div>

      </div>
    </div>
  </div>
</div>
                                </tr>


                                @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal fade" id="delete" tabindex="-1" aria-labelledby="deleteLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="myModalLabel">Confirm Delete</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>

                    <div class="modal-body">
                        <p>You are about to delete <b><i class="title"></i></b>list.</p>
                        <p>Do you want to proceed?</p>
                        <input type="hidden" class="form-control" name="list_id" value="" id="list_id">
                        <input type="hidden" class="form-control" name="camid" value="" id="camid">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
                        <button type="submit" name="submit" class="btn btn-danger btn-sm deleteListData">Delete</button>
                    </div>

                </div>
            </div>
        </div>

        <div class="modal fade" id="recycle" tabindex="-1" aria-labelledby="deleteLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="myModalLabel">Confirm Recycle</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>

                    <div class="modal-body">
                        <p>You are about to recycle this <b><i class="title"></i></b>list.</p>
                        <p>Do you want to proceed?</p>
                        <input type="hidden" class="form-control" name="list_id_recycle" value="" id="list_id_recycle">
                        <input type="hidden" class="form-control" name="camid_recycle" value="" id="camid_recycle">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
                        <button type="submit" name="submit"
                            class="btn btn-danger btn-sm recycleListData">Delete</button>
                    </div>

                </div>
            </div>
        </div>
        <div class="modal fade" id="listModal" tabindex="-1" aria-labelledby="myModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="dialog-background" id="loadingmodal" style="display: none;">
                    <div class="dialog-loading-wrapper">
                        <img src="{{ asset('assets/images/lp.gif') }}">
                    </div>
                </div>
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="add-edit"></h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form method="post" action="" enctype="multipart/form-data" id="listForm">
                        @csrf
                        <div class="modal-body">
                            <div class="form-group">
                                <label for="inputEmail3" class="form-label">Title </label>
                                <div class="input-group mb-3">
                                    <span class="input-group-text"><i class="ti-user"></i></span>

                                    <input type="text" class="form-control closed" required name="title" id="title"
                                        placeholder="Please enter name">
                                </div>
                            </div>
                            <div class="form-group">

                                <!-- <div class="form-group">
                                    <label for="list_file" class="form-label">Select List you want to upload</label>
                                    <div class="input-group mb-3">
                                        <span class="input-group-text"><i class="ti-user"></i></span>

                                        <input type="file" class="form-control" id="list_file" name="list_file" value=""
                                            required placeholder="Select file">

                                    </div> -->
                                <!-- <div class="form-group mb-3">
                                <label  class="form-label">Upload File</label>
                                <div>
                                    <label class="file-upload-box" for="list_file">
                                        <div class="upload-icon">
                                            <i class="ti ti-cloud-upload"></i>
                                        </div>
                                        <p>Drag & drop your file here or <span class="text-primary">  <input type="file" class="form-control" id="list_file" name="list_file" value="" required/>choose file</span>
                                        </p>
                                        <small>Supported formats: XLSX, XLS, CSV | Max size: 5MB</small>
                                       
                                    </label>
                                </div>
                            </div> -->
                                <div class="form-group mb-3">
                                    <label class="form-label">Upload File</label>
                                    <div>
                                        <!-- Hidden File Input -->
                                        <input type="file" class="form-control d-none" id="list_file" name="list_file"
                                            required accept=".xlsx,.xls,.csv" />

                                        <!-- Custom Upload Box -->
                                        <label class="file-upload-box" for="list_file">
                                            <div class="upload-icon">
                                                <i class="ti ti-cloud-upload"></i>
                                            </div>
                                            <p>
                                                Drag & drop your file here or
                                                <span class="text-primary">choose file</span>
                                            </p>
                                            <small>Supported formats: XLSX, XLS, CSV | Max size: 5MB</small>
                                        </label>

                                        <!-- Selected File Name -->
                                        <div id="file-name" style="margin-top:8px; font-size:14px; color:#333;"></div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="form-group @error('list_id') has-error @enderror">
                                        <label class="form-label">Campaign</label>
                                        <div class="input-group mb-3">
                                            <span
                                                class="input-group-text @error('list_id') text-danger border-danger @enderror"><i
                                                    class="ti-list"></i></span>
                                            <select class="js-example-basic-single select2" name="campaign_id" autocomplete="off"
                                                data-placeholder="Select Campaign" placeholder="Select Campaign"
                                                required>
                                                <option value="">Select Campaign</option>
                                                <?php 
                                                    if(!empty($campaign_list))
                                                    {
                                                    foreach ($campaign_list as $key=>$value){
                                                        if(!empty($value->title) &($value->status==1)){
                                                        ?>
                                                <option value="<?php echo $value->id;?>"><?php echo $value->title;?>
                                                </option>
                                                <?php } } }?>
                                            </select>
                                        </div>
                                    </div>
                                </div>

                            </div>
                            <div class="modal-footer" style="justify-content: flex-end; padding-left: 2px !important;">
                                <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
                                <button type="submit" name="submit" class="btn btn-info btn-ok btn-sm">Save</button>
                            </div>
                    </form>
                </div>
            </div>

        </div>
    </div>
    <!-- /.row -->

</section>
<!-- /.content -->




<script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM="
    crossorigin="anonymous"></script>

<script>
const fileInput = document.getElementById("list_file");
const fileName = document.getElementById("file-name");

fileInput.addEventListener("change", function() {
    if (this.files.length > 0) {
        fileName.textContent = "Selected file: " + this.files[0].name;
    } else {
        fileName.textContent = "";
    }
});
</script>
<script>
$("#openListForm").click(function() {
    $("#listModal").modal('show');
    $("#name").val('');
    $("#status").val('1');
    $("#id").val('');
    $("#add-edit").html('Add List');
});
$("#listForm").submit(function() {
    $('#loadingmodal').show();
});
$(".deleteList").click(function() {
    var delete_id = $(this).data('id');
    var camid = $(this).data('camid');

    //alert(camid);

    $("#delete").modal('show');
    $("#list_id").val(delete_id);
    $("#camid").val(camid);


});


$(".recycleList").click(function() {
    var delete_id = $(this).data('id');
    var camid = $(this).data('camid');

    //alert(camid);

    $("#recycle").modal('show');
    $("#list_id_recycle").val(delete_id);
    $("#camid_recycle").val(camid);


});


$(document).on("click", ".recycleListData", function() {
    var list_id = $('#list_id_recycle').val();
    var camid = $('#camid_recycle').val();

    //alert(group_id);
    var el = this;
    $.ajax({
        url: '/smsai/list/recycle/' + list_id,
        type: 'get',
        success: function(response) {
            window.location.reload(1);
        }
    });
    //   window.location.reload(1);

});

$(document).on("click", ".deleteListData", function() {
    var list_id = $('#list_id').val();
    var camid = $('#camid').val();

    //alert(group_id);
    var el = this;
    $.ajax({
        url: '/smsai/list/delete/' + list_id,
        type: 'get',
        success: function(response) {
            window.location.reload(1);
        }
    });
    //   window.location.reload(1);

});
</script>


<script>
$(function() {
    $("#tickets").on("click", ".btn-toggle", function() {
        var status = $(this).hasClass('active') ? 1 : 0;
        var listid = $(this).data('listid');

        $.ajax({
            type: "GET",
            dataType: "json",
            url: '/smsai/list/update-status/' + listid + '/' + status,
            success: function(data) {
                if (data.status == 'true') {
                    toastr.success(data.message);
                } else {
                    toastr.error(data.message);
                }

                console.log(data.success);
                window.location.reload(1);
            }
        });
    });
});
</script>


<script>
$(document).ready(function() {
   
    function initializeSelect2() {
        $('.js-example-basic-single.select2').select2({
            width: '90%',
            dropdownParent: $('#listModal') 
        });
    }

   
    $('#listModal').on('shown.bs.modal', function() {
        initializeSelect2(); 
    });


    if ($('#listModal').hasClass('show')) {
        initializeSelect2();
    }
});
</script>

@endsection