@extends('layouts.app')
@section('title', 'SMS AI Template')
@section('content')
<style>
        .badge
{font-size: 1rem;
    font-style: normal;
    font-weight: 400;
    font-family: "IBM Plex Sans", sans-serif;
    line-height: 1.5;
    margin-top:5px;}

.btn-toggle.active {
    background-color: #2196f3; /* Set to the desired green color */
    color: white; /* Set to the desired text color */
    border-color: green; /* Set to the desired border color */
}

/* Style for the inactive state */
.btn-toggle:not(.active) {
    background-color: red; /* Set to the desired red color */
    color: white; /* Set to the desired text color */
    border-color: red; /* Set to the desired border color */
}
@media (max-width: 576px) {
    .d-flex {
        flex-direction: column;
        align-items: flex-start !important;
    }
    .d-flex a {
        margin-top: 10px;
    }
}

    </style>
        <link href="https://cdn.jsdelivr.net/gh/gitbrent/bootstrap4-toggle@3.6.1/css/bootstrap4-toggle.min.css" rel="stylesheet">

<!-- Main content -->

        <section class="content">

      <div class="row">

       
        
        <div class="col-12">
          <div class="box">
                     
             <div class="box-body">   
              <div class="d-flex justify-content-between align-items-center flex-wrap mb-3">
    <h4 class="box-title text-info mb-0">
        <i class="fa fa-user fa-sx"></i> SMS AI Templates List
    </h4>
    <a href="{{ url('/smsai/template/add') }}" 
       type="button" 
       class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm">
        <i class="fa fa-plus"></i> Add SMS AI Template
    </a>
</div>

              <!-- <h4 class="box-title text-info mb-0"><i class="fa fa-user fa-sx"></i> SMS AI Templates List</h4>             
               <a href="{{ url('/smsai/template/add') }}" type="button" style="float:right" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-plus"></i>  Add SMS AI Template</a>      -->
         <hr class="my-15">
              <div class="table-responsive">
                <table id="tickets" class="table mt-0 table-hover no-wrap" data-page-size="10">
                  <thead>
                    <tr>
                                    <th>#</th>
                                    <th>Title</th>
                                    <th>Introduction</th>
                                    <th>Created date</th>
                                    <th>Status</th>
                                    <th>Action</th>

                            </tr>
                  </thead>
                  <tbody>
                    @foreach($templates as $key => $template)
                                <tr>
                                  <th scope="row">{{$key+1}}</th>
                                  <td>{{$template->template_name}}</td>
                                  <td>{{$template->introduction}}</td>


                                  
                                  <td>{{date('Y-m-d H:i',strtotime($template->created_at))}}</td>
                                    <td>    
                                      <button type="button"data-templateid="{{$template->id}}" class="btn btn-sm btn-toggle  @if($template->status == '1') active @endif" data-bs-toggle="button" aria-pressed="true" autocomplete="off">
                                        <div class="handle"></div>
                                      </button>
                                    </td>
                                <td>
                                    <div class="list-icons d-inline-flex">
                                     
                                      <div class="list-icons-item dropdown">
                                        <a href="#" class="list-icons-item dropdown-toggle" data-bs-toggle="dropdown"><i class="fa fa-file-text"></i></a>
                                        <div class="dropdown-menu dropdown-menu-end">
                                          <a  class="dropdown-item" style="cursor:pointer;" href="{{url('smsai/template/view')}}/{{$template->id}}"  data-id="{{$template->id}}"><i class="fa fa-edit fa-lg"></i> Edit</a>
                                        
                                          <div class="dropdown-divider"></div>
                                          <a  class="dropdown-item openTemplateDelete" style="cursor:pointer;"data-templateid="{{$template->id}}" ><i class="fa fa-trash-o fa-lg"></i> Delete</a>


                                        </div>
                                      </div>
                                    </div>
                                </td>
                                  
                             
                                </tr>
                                
                                @endforeach
                                
                              </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      
        <div class="modal fade" id="delete" tabindex="-1" aria-labelledby="deleteLabel" aria-hidden="true">
<div class="modal-dialog">
<div class="modal-content">
<div class="modal-header">
  <h5 class="modal-title" id="myModalLabel">Confirm Delete</h5>
  <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
</div>

<div class="modal-body">
<p>You are about to delete <b><i class="title"></i></b> Template.</p>
   <p>Do you want to proceed?</p>
   <input type="hidden" class="form-control" name="
   _id" value="" id ="template_id" >
</div>
<div class="modal-footer">
  <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
  <button type="submit"name="submit" class="btn btn-danger btn-sm deleteTemplate">Delete</button>
</div>
 
</div>
</div>
      <!-- /.row -->

    </section>
        <!-- /.content -->

        <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>

<script>
   
    $(".openTemplateDelete").click(function() {
        var delete_id = $(this).data('templateid');
        $("#delete").modal('show');
        $("#template_id").val(delete_id);

    });

   
    </script>
    <script>
$(function()
{
    $("#tickets").on("click", ".btn-toggle", function ()
    {
       console.log('hi');
      var status = $(this).hasClass('active') ? 1 : 0;
        var templateid = $(this).data('templateid');    


        $.ajax({
            type: "GET",
            dataType: "json",
            url: '/smsai/template/update-status/'+templateid+ '/' +status,

            success: function(data)
            {
                if(data.status == 'true')
                {
                    toastr.success(data.message);
                }
                else
                {
                    toastr.error(data.message);

                }

                console.log(data.success);
                window.location.reload(1);
            }
        });
    })
})
$(document).on("click", ".deleteTemplate", function () {
            // if (confirm("Are you sure you want to delete this record?")) {
            var template_id = $("#template_id").val();
            //alert(campaign);
            //var account_no = $(this).data('account_no');
            //alert(account_no);
            var el = this;
            $.ajax({
                url: 'smsai/template/delete/' + template_id,
                type: 'get',
                success: function (response) {
                    toastr.success('Template has been deleted successfully');
                    window.location.reload(1);
                }
            });
        });

</script>


@endsection
