<!-- Textarea + Save Button -->
<div class="sendNotesModel" style="display: flex; gap: 12px; align-items: center; width: 100%;">
    <textarea id="noteInput" placeholder="Write Notes" style="width: 90%; padding: 8px; border: 1px solid #ccc; border-radius: 6px; resize: none; height: 80px;"></textarea>
    <button id="saveNote" style="background: #2196F3; color: white; border: none; border-radius: 6px; padding: 10px 18px; cursor: pointer; align-self: center;">Save</button>
</div>

<!-- Notes List -->
<div id="multiple_notes" style="margin-top: 12px; padding-left: 0;">

</div>

<script>
    const currentUser = '@shikha'; 

    document.getElementById('saveNote').addEventListener('click', function() {
        const noteText = document.getElementById('noteInput').value.trim();
        if (noteText === '') return;

        const userName = currentUser;
        const now = new Date();
        const dateTime = now.toLocaleDateString('en-GB') + ' ' + now.toLocaleTimeString([], {hour: '2-digit', minute:'2-digit'});

        const noteItem = `
            <div style="margin-top: 8px; width: 100%; display: flex; align-items: center; gap: 8px;">
                <span style="color: black;">•</span>
                <div style="flex: 1; display: flex; justify-content: space-between; align-items: center; width: 100%;">
                    <span style="flex: 1; text-align: left;"><strong>${userName}</strong></span>
                    <span style="flex: 2; text-align: center;">${noteText}</span>
                    <span style="flex: 1; text-align: right; font-size: 12px; color: black;">${dateTime}</span>
                </div>
            </div>
        `;

        document.getElementById('multiple_notes').insertAdjacentHTML('afterbegin', noteItem);
        document.getElementById('noteInput').value = '';
    });
</script>
