@extends('layouts.app')
@section('title', 'Inbox')
@section('content')
<meta name="csrf-token" content="{{ csrf_token() }}">

<style>
    body {
    overflow: hidden; /* modal open hone par background scroll disable */
}
#show {
    overflow: hidden;
    width: auto;
    height: 350px !important;
}
.incomingcss {
    float: left;
}

.outgoingcss {
    float: right;
}

.user_img {
    text-transform: uppercase;
    width: 42px;
    height: 42px;
    background: #2196F3;
    -moz-border-radius: 50px;
    -webkit-border-radius: 50px;
    border-radius: 50px;
    color: white;
    font-size: 27px;
    font-weight: 600;
    text-align: center;
}

.authTabs {
    cursor: pointer;
}

.loading_old {
    position: absolute;
    color: White;
    top: 50%;
    left: 45%;
}

#faxpageloader {
    background: rgba(255, 255, 255, 0.8);
    display: none;
    height: 100%;
    position: fixed;
    width: 100%;
    z-index: 9999;
}

#faxpageloader img {
    left: 19%;
    margin-left: -32px;
    margin-top: -5%;
    position: absolute;
}

.did_for_sale_msg {
    width: 97%;
    margin-left: 1%;
    text-align: center;
}

#left_box,
#right_new_msg,
#right_list_msg {
    display: none;
}

/* Adjust the z-index for the pagination links */
.page-item.active .page-link {
    z-index: 0;
    /* Remove 'px' after the numeric value */
}

.table>tbody>tr>td,
.table>tbody>tr>th {
    padding: 0.5rem;
    vertical-align: middle;
}

.chat-box-body {
    position: relative;
    /* height: 370px; */
    height: auto;
    border-bottom: 1px solid #ebedf3;
    border-top: 1px solid #ebedf3;
    overflow: hidden;
   
}
.slimScrollBar,
.slimScrollRail {
    display: none !important;
}
.chat-box {
    max-height: 100%;
    overflow-y: auto; /* only when needed */
}

.box-body {
    position: relative;
}

</style>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.1/css/all.min.css"
    integrity="sha384-wvfXpqpZZVQGK6TAh5aJSK8r/jFaMM8DO" crossorigin="anonymous">

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-12">
            <div class="box">
                <div class="box-body">
                    <div class="overlay" id="left_box">
                        <i class="fa fa-refresh fa-spin"></i>
                    </div>

               <h4 class="box-title text-info mb-0">
    <i class="fa fa-user fa-sx"></i> SMS <i class="fas fa-file-pdf" aria-hidden="true"></i>
</h4>
<a id="openNewMessage" 
   class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"
   style="float:right; position:absolute; top:10px; right:20px;">
   <i class="fa fa-plus"></i> New Message
</a>



                    <hr class="my-15">
                    <div class="table-responsive">
                        @if(!empty($sms_list))
                        <table id="tickets1" class="table mt-0 table-hover no-wrap" data-page-size="10">
                            <thead>
                                <tr>
                                    <th style="width:10px;">#</th>
                                    <th style="white-space: normal;width:100px;">Contact Name</th>
                                    <th style="white-space: nowrap;width:180px;">Number</th>
                                    <th style="width:180px;">DID</th>
                                    <th style="white-space: normal;width:180px;">Message</th>
                                    <th style="width:150px;">Date</th>


                                </tr>
                            </thead>
                            <tbody id="hiddenAfterSms">
                                <?php if(isset($sms_list->data)){ ?>
                                <?php  foreach ($sms_list->data as $key => $sms_data) { ?>
                                <tr <?php   if ($sms_data->status == '0') { ?> style="font-weight: bold;" <?php }  ?>
                                    class="authTabs"
                                    onclick="openDiv(<?php echo $sms_data->number ?>,<?php echo $sms_data->did ?>);"
                                    id="<?php echo $sms_data->number.'_'.$sms_data->did ?>">
                                    <td>{{$key+1}}</td>
                                    <td></td>
                                    <td class="mailbox-name"><?php  echo $sms_data->number ?>
                                    </td>
                                    <td class="mailbox-name"><?php  echo $sms_data->did ?>
                                    </td>
                                    <td class="mailbox-subject"><?php
                                                        $sms_detail = strlen($sms_data->message) > 50 ? substr($sms_data->message, 0, 50)."..." : $sms_data->message;
                                                                echo $sms_detail; ?>
                                    </td>

                                    <td class="utc-time" data-utc-time="{{($sms_data->date)}}">{{($sms_data->date)}}
                                    </td>
                                </tr>
                                <?php
                                                        }  }  ?>
                            </tbody>
                        </table>
                        @else
                        <div class="box-body" style="font-size: 25px;
                                                text-align: center;color:black;
                                                font-weight: bold;">
                            No SMS
                        </div>

                        @endif
                    </div>
                </div>
            </div>
        </div>





        <!-- new msg -->
        <!-- SMS Details Box -->
        <div class="chat-box" id="hide_new_message_div" style="bottom: 70px;">
            <!-- Box Header -->
            <div class="chat-box-overlay" id="right_new_msg">
                <i class="fa fa-refresh fa-spin"></i>
            </div>
            <div class="chat-box-header p-15 d-flex justify-content-between align-items-center">
                <div class="text-center flex-grow-1">
                    <div class="text-dark fs-18">New Message</div>
                    <div>

                    </div>
                </div>
                <div class="chat-box-toggle">
                    <a id="chat-box-toggle"
                        class="waves-effect waves-circle btn btn-circle btn-danger-light h-40 w-40 rounded-circle l-h-45">
                        <span class="icon-Close fs-22"><span class="path1"></span><span class="path2"></span></span>
                    </a>
                </div>
            </div>

            <!-- Box Body -->
            <div class="chat-box-body direct-chat-messages">
                <div class="form-group">
                    <label for="exampleInputEmail1" class="form-label">From</label>
                <select class="form-select" name="did" id="new_from">
    <option value="">Select To</option>
    @foreach($group as $did)
        <?php
            $cli = $did->cli; // string
            $lastTenDigits = substr($cli, -10);
            $formattedLastTenDigits = '(' . substr($lastTenDigits, 0, 3) . ') ' 
                                    . substr($lastTenDigits, 3, 3) . '-' 
                                    . substr($lastTenDigits, 6, 4);
            $formattedDid = '+' . substr($cli, 0, -10) . $formattedLastTenDigits;

            $optionLabel = $formattedDid;

            if (Session::get('role') === 'system_administrator' && !empty($did->voip_provider)) {
                $optionLabel .= "($did->voip_provider)";
            }
        ?>
        <option value="{{ $cli }}">{{ $optionLabel }}</option>
    @endforeach
</select>

                </div>
                <!-- <div class="form-group">
                    <label for="exampleInputEmail1" class="form-label">Country Code</label>
                    <select class="form-select" name="countryCode" id="countryCode">
                          <option value="+65">🇸🇬 +65</option>
                                        <option value="+91">🇮🇳 +91</option>
                                        <option value="+63">🇵🇭 +63</option>
                                        <option value="+60">🇲🇾 +60</option>
                                        <option value="+66">🇹🇭 +66</option>   
                                        <option value="+1">us +1</option>   

                    </select>
                </div>

                <div class="form-group">
                    <label for="exampleInputPassword1" class="form-label">To </label>
                    <input type="text" class="form-control" name="number" id="new_to" autocomplete="off"
                        placeholder="To">
                </div> -->
<style>
#hide_new_message_div .direct-chat-messages {
  background-color: #fff !important;
  padding: 4px 12px; 
}

#country_code {
  background-repeat: no-repeat;
  background-position: 6px center;
  padding-left: 28px;
  background-size: 20px 20px;
}
.flag-dropdown {
  position: relative;
  width: 95px;
  font-family: sans-serif;
  border: 1px solid #ccc;
  border-radius: 4px 0 0 4px;
  cursor: pointer;
}

.selected {
  display: flex;
  align-items: center;
  padding: 6px;
}

.flag-icon {
  width: 20px;
  height: 20px;
  object-fit: cover;
  margin-right: 6px;
  border-radius: 4px;
}

.options {
  position: absolute;
  top: 100%;
  left: 0;
  width: 100%;
  border: 1px solid #ccc;
  background: white;
  display: none;
  z-index: 10;
  max-height: 200px;
  overflow-y: auto;
}

.options div {
  display: flex;
  align-items: center;
  padding: 6px;
}

.options div:hover {
  background-color: #f0f0f0;
}

.dropdown-arrow {
  margin-left: auto;
  width: 0;
  height: 0;
  border-left: 5px solid transparent;
  border-right: 5px solid transparent;
  border-top: 6px solid #555;
}

#opensms{
  height: 370px !important;  
  background: #fff !important;
}


.chat-input {
  display: flex;
  align-items: center;
  background: #fff;
  border-top: 1px solid #f1f1f1;
  padding: 6px 12px;
  position: relative;
}


.chat-input .attachment-btn {
  font-size: 20px;
  color: #7a8594;
  margin-right: 10px;
  cursor: pointer;
  display: flex;
  align-items: center;
  justify-content: center;
  width: 32px;
  height: 32px;
  border-radius: 50%;
  transition: all 0.25s ease;
}

.chat-input .attachment-btn:hover {
  background: linear-gradient(135deg, #e3f2fd, #f5f9ff);
  color: #007bff;
  transform: scale(1.1); 
  box-shadow: 0 2px 4px rgba(0,0,0,0.15);
}


.chat-input .chat-submit {
  background: none;
  border: none;
  color: #007bff;
  cursor: pointer;
  display: flex;
  align-items: center;
  justify-content: center;
  padding: 4px;
  transform: translateY(-4px); 
  transition: all 0.2s ease;
}

.chat-input .chat-submit:hover {
  color: #0056b3;
  transform: translateY(-4px) scale(1.1);
}


.chat-input input[type="file"] {
  display: none;
}


</style>

                <!-- To -->
<div class="form-group mb-3">
  <label class="form-label">To</label>
  <div style="display: flex;">
    <div class="flag-dropdown" id="countryCode1">
      <div class="selected" id="selected-flag">
        <img src="https://flagcdn.com/w40/sg.png" class="flag-icon" />
        <span>+65</span>
         <span class="dropdown-arrow"></span>

      </div>
            <input type="hidden" id="countryCode" value="+1"> <!-- default -->

      <div class="options" id="flag-options">
        <div data-code="+91" data-flag="in"><img src="https://flagcdn.com/w40/in.png" class="flag-icon" /> +91</div>
        <div data-code="+63" data-flag="ph"><img src="https://flagcdn.com/w40/ph.png" class="flag-icon" /> +63</div>
        <div data-code="+60" data-flag="my"><img src="https://flagcdn.com/w40/my.png" class="flag-icon" /> +60</div>
        <div data-code="+66" data-flag="th"><img src="https://flagcdn.com/w40/th.png" class="flag-icon" /> +66</div>
        <div data-code="+1" data-flag="us"><img src="https://flagcdn.com/w40/us.png" class="flag-icon" /> +1</div>
        <div data-code="+65" data-flag="sg"><img src="https://flagcdn.com/w40/sg.png" class="flag-icon" /> +65</div>
      </div>
    </div>

      <input type="text" class="form-control" name="number" id="new_to" autocomplete="off" placeholder="Recipient number"
      style="border-top-left-radius: 0; border-bottom-left-radius: 0;">
  </div>
</div>


                <div class="form-group">
                    <label for="exampleInputPassword1" class="form-label">Message</label>
                    <textarea maxlength="160" rows="5" class="form-control" name="message" id="new_message"
                        autocomplete="off"></textarea>
                    <span id="rchars">160</span> Character(s) Remaining
                </div>
                <div class="form-group">
                    <video id="previewVideo" controls style="display:none;max-width: 100%; max-height: 200px;"></video>
                    <img id="previewImage" src="#" alt="File Preview"
                        style="display:none; max-width: 80%; max-height: 100px;">
                    <embed id="previewPDF" src="#" type="application/pdf"
                        style="display:none; max-width: 80%; max-height: 100px;">
                </div>
                <div class="form-group">
                    <label class="form-label">File</label>
                    <div class="input-group mb-3">
                        <input type="file" class="form-control" name="sms_file" id="sms_file"
                            accept="image/*,application/pdf,video/*">
                    </div>
                </div>
            </div>
            <!-- <div class="chat-input text-end" style="margin-bottom:10px;">
                <button type="button" id="sendNewSms" class="btn btn-primary btn-md">Submit</button>

            </div> -->
            
          <div class="chat-input d-flex gap-2" style="margin-bottom:10px; border-top: 1px solid #ccc; padding-top: 10px;">
    <button type="button" id="sendNewSms" class="btn btn-primary btn-sm flex-fill">
        📤 Send Message
    </button>
    <button type="button" id="cancelSms" class="btn btn-secondary btn-sm flex-fill">
      ❌ Cancel
    </button>
</div>
            <!-- /.box-body -->

        </div>
    </div>
    <!-- SMS Details Box -->
    <div class="chat-box" id="sms_list" style="bottom:70px;">
        <!-- Box Header -->
        <div class="chat-box-overlay" id="right_list_msg">
            <i class="fa fa-refresh fa-spin"></i>
        </div>
        <div class="chat-box-header p-15 d-flex justify-content-between align-items-center">
            <div class="btn-group">
                <button
                    class="waves-effect waves-circle btn btn-circle btn-primary-light h-40 w-40 rounded-circle l-h-45"
                    type="button" data-bs-toggle="dropdown">
                    <span class="icon-Add-user fs-22"><span class="path1"></span><span class="path2"></span></span>
                </button>
                <div class="dropdown-menu min-w-200">
                    <a class="dropdown-item fs-16" href="#">
                        <span class="icon-Clipboard me-15"><span class="path1"></span><span class="path2"></span><span
                                class="path3"></span><span class="path4"></span></span>
                        Add to Contacts</a>
                    <a class="dropdown-item fs-16" href="#">
                        <span class="icon-Color me-15"></span>
                        Call this lead</a>

                    <a class="dropdown-item fs-16" href="#">
                        <span class="icon-Group me-15"><span class="path1"></span><span class="path2"></span></span>
                        Lead Activity</a>

                </div>
            </div>
            <div class="text-center flex-grow-1">
                <div class="text-dark fs-18" id="chatBoxNumber"></div>

                <div>

                </div>
            </div>
            <div class="chat-box-toggle">
                <a id="chat-box-toggle"
                    class="waves-effect waves-circle btn btn-circle btn-danger-light h-40 w-40 rounded-circle l-h-45">
                    <span class="icon-Close fs-22"><span class="path1"></span><span class="path2"></span></span>
                </a>
            </div>
        </div>

        <!-- Box Body -->
        <div class="chat-box-body" id="opensms">

            <!-- Conversations are loaded here -->
            <div class="direct-chat-messages" id="show">
            </div>

        </div>
        <div class="chat-input">
            <input type="hidden" name="number" id="div_number" placeholder="Type Message s..." class="form-control">
            <input type="hidden" name="did" id="div_did" placeholder="Type Message ..." class="form-control">

            <label for="fileInput" class="attachment-btn">
            <i class="ti-clip"></i>
           </label>
            <input type="file" id="fileInput" name="sms_file" class="d-none" accept=".jpg,.jpeg,.png,.pdf,.doc,.docx,.txt,image/*,application/pdf,video/*" />
            <input type="text" id="chat-input" class="div_message" name="message" placeholder="Send a message..." />
            <span id="errorMsg"></span>

            <button type="button" class="chat-submit sendSms">
                <span class="icon-Send fs-22"></span>
            </button>
        </div>
        <!-- /.box-body -->

    </div>
    </div>



    </div>

    <!-- /.row -->
</section>
<!-- /.content -->

<script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM="
    crossorigin="anonymous"></script>
<script src="{{asset('assets/js/pages/chat-popup.js')}}"></script>
<script src="https://cdn.jsdelivr.net/npm/imask"></script>
<script>$(document).on('click', '#flag-options div', function() {
    const code = $(this).data('code'); // e.g. +91
    const flag = $(this).data('flag'); // e.g. in

    // set hidden input for SMS
    $('#countryCode').val(code);

    // optional: visually show selected flag somewhere
    $('#selected-flag-display').html(`<img src="https://flagcdn.com/w40/${flag}.png" class="flag-icon" /> ${code}`);

    console.log("Selected Country Code:", code);
});
</script>
<script>
var phoneInput = document.getElementById('new_to');
var phoneMask = new IMask(phoneInput, {
    mask: '(000) 000-0000'
});
</script>
<script>
    $('.chat-box-body').slimScroll({
    height: '420px',
    railVisible: false,
    alwaysVisible: false
});

$(document).ready(function() {
    $(".chat-box-toggle").click(function() {
      
        $("#sms_list").hide();
        $("#hide_new_message_div").hide();
        $("#openNewMessage").show();

    });

});

</script>
<script>
$(document).ready(function() {
    $('#tickets1').DataTable({
        "order": [
            [5, "desc"]
        ], // Sort by the sixth column (index 5) in descending order
        "columnDefs": [{
                "orderable": false,
                "targets": [0, 1, 2, 3, 4]
            } // Disable ordering on columns 0 to 4
        ],
        "aoColumns": [
            null, // Number column
            null, // Contact Name column
            null, // Number column
            null, // DID column
            null, // Message column
            {
                "sType": "date"
            } // Date column with type "date" for correct sorting
        ],
        "drawCallback": function() {
            $(".utc-time").each(function(i, element) {
                var utcTime = $(element).data("utc-time");
                if (utcTime) {
                    var localTime = moment.utc(utcTime).local();
                    $(element).html(localTime.format('YYYY-MM-DD HH:mm'));
                }
            });
        }
    });
});
</script>
<script src="{{ asset('assets/js/sms_view.js') }}"></script>
<script>
var maxLength = 160;
$('#new_message').keyup(function() {
    var textlen = maxLength - $(this).val().length;
    $('#rchars').text(textlen);
});
</script>

<script>
const openNewMessageButton = document.getElementById("openNewMessage");
const chatBox = document.getElementById("hide_new_message_div");

openNewMessageButton.addEventListener("click", () => {
    chatBox.style.display = "block";
    openNewMessageButton.style.display = "none";
});


$(document).ready(function() {
    // Format mobile numbers
    $('.mailbox-name').each(function() {
        const mobile = $(this).text();

        // Remove all non-numeric characters
        const numericPart = mobile.replace(/\D/g, '');

        // Check if the numeric part is longer than 10 digits
        if (numericPart.length >= 10) {
            // Extract the country code (if applicable) and last 10 digits
            const countryCode = numericPart.slice(0, -10);
            const last10Digits = numericPart.slice(-10);

            // Apply the desired format to the last 10 digits
            const formattedCountryCode = countryCode ? '+' + countryCode : '';
            const formattedMobile =
                `${formattedCountryCode} (${last10Digits.slice(0, 3)}) ${last10Digits.slice(3, 6)}-${last10Digits.slice(6)}`;

            $(this).text(formattedMobile);
        } else {
            $(this).text(numericPart); // No need for formatting
        }
    });
});
</script>
<script>
$(document).ready(function() {
    // Preview image or PDF when a file is selected
    $('#sms_file').change(function() {
        readURL(this);
    });

    function readURL(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();

            reader.onload = function(e) {
                if (input.files[0].type.startsWith('image')) {
                    // Display image preview
                    $('#previewImage').attr('src', e.target.result).show();
                    $('#previewPDF').hide();
                } else if (input.files[0].type === 'application/pdf') {
                    // Display PDF preview
                    $('#previewPDF').attr('src', e.target.result).show();
                    $('#previewImage').hide();
                } else if (file.type.startsWith('video')) {
                    // Display video preview
                    displayVideoPreview(file);
                } else {
                    // Handle other file types here
                    console.log('Unsupported file type');
                }
            };

            reader.readAsDataURL(input.files[0]);
        }
    }

    function displayVideoPreview(file) {
        const url = URL.createObjectURL(file); // Create an object URL for the video
        console.log('Generated video URL:', url);
        $('#previewVideo').attr('src', url).show(); // Set the source of the video preview
        $('#previewVideo')[0].load(); // Reload the video element
        $('#previewImage, #previewPDF').hide();
    }
});
</script>

<script>
$('#chat-box-toggle, #cancelSms').on('click', function() {
    $('#hide_new_message_div').hide(); 
    $('#openNewMessage').show();
});

document.querySelectorAll('#chat-box-toggle').forEach(btn => {
    btn.addEventListener('click', function() {
        this.closest('.chat-box').style.display = 'none';
    });
});

</script>

<script>
 const dropdown = document.querySelector('.flag-dropdown');
const selected = document.getElementById('selected-flag');
const options = document.getElementById('flag-options');

selected.addEventListener('click', () => {
  dropdown.classList.toggle('open');
  options.style.display = options.style.display === 'block' ? 'none' : 'block';
});

options.querySelectorAll('div').forEach(option => {
  option.addEventListener('click', () => {
    const flag = option.getAttribute('data-flag');
    const code = option.getAttribute('data-code');
    selected.innerHTML = `
      <img src="https://flagcdn.com/w40/${flag}.png" class="flag-icon" />
      <span>${code}</span>
      <span class="dropdown-arrow"></span>
    `;
    options.style.display = 'none';
    dropdown.classList.remove('open');
  });
});
</script>


@endsection