@extends('layouts.app')
@section('title', 'Edit SMTP')
@section('content')

<section class="content">
  <div class="row">       
    <div class="col-lg-12 col-12">
      <div class="box">
      <form method="post" name="smtpform" id="smtpform" action="">
        @csrf
          
          <div class="box-body"><!--bg-lightest-->
          
         
            <h4 class="box-title text-info mb-0"><i class="fa fa-edit me-15"></i> Edit SMTP</h4>
            <a href="{{ url('/smtps') }}" type="button" style="float:right" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-eye fa-sx"></i>Show SMTP</a>

            <hr class="my-15">
            <div class="row">
              <div class="col-md-6">
                <div class="form-group @error('name') has-error @enderror">
                  <label class="form-label">Driver Name </label> 
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('name') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                                            <select class="form-select" name="mail_driver" id="mail_driver" required>
                                                    <option value="smtp">SMTP</option>
                                            </select>
                </div>
                </div>
              </div>

              <div class="col-md-6">
                <div class="form-group @error('description') has-error @enderror">
                  <label class="form-label">Host Name</label> 
                  <div class="input-group mb-3">
                  <span class="input-group-text @error('name') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                  <input type="text" class="form-control" value="{{$smtp['mail_host']}}" name="mail_host" id="mail_host" required>

                  </div>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group @error('list_id') has-error @enderror">
                  <label class="form-label">Username</label>
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('list_id') text-danger border-danger @enderror"><i class="ti-list"></i></span>
                    <input type="text" class="form-control" name="mail_username" value="{{$smtp['mail_username']}}" id="mail_username" required>

                  </div>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group @error('list_id') has-error @enderror">
                  <label class="form-label">Password</label>
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('list_id') text-danger border-danger @enderror"><i class="ti-list"></i></span>
                    <input type="password" class="form-control" name="mail_password" value="{{$smtp['mail_password']}}" id="mail_password" required>

                  </div>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group @error('list_id') has-error @enderror">
                  <label class="form-label">Encryption Type </label>
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('list_id') text-danger border-danger @enderror"><i class="ti-list"></i></span>
                    <select class="form-select" name="mail_encryption" id="mail_encryption" required>
                                                    <option value="">Select Encryption</option>
                                                    <option @if ($smtp['mail_encryption'] == "TLS") {{ 'selected' }} @endif value="TLS">TLS</option>
                                                    <option @if ($smtp['mail_encryption'] == "SSL") {{ 'selected' }} @endif value="SSL">SSL</option>
                                                </select>
                  </div>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group @error('list_id') has-error @enderror">
                  <label class="form-label">Port No </label>
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('list_id') text-danger border-danger @enderror"><i class="ti-list"></i></span>
                    <input type="text" class="form-control" value="{{$smtp['mail_port']}}" name="mail_port" id="mail_port" required>

                  </div>
                </div>
              </div>
         
              <div class="col-md-6">
                <div class="form-group @error('list_id') has-error @enderror">
                  <label class="form-label">For Sending</label>
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('list_id') text-danger border-danger @enderror"><i class="ti-email"></i></span>
                    <select class="form-select" name="sender_type" id="sender_type" required>
                                            @if( session("level") < 7)
                                                    <option value="user">User Emails</option>
                                                @else
                                                    <option value="">Select Email Type</option>
                                                    <option @if ($smtp['sender_type'] == "system") {{ 'selected' }} @endif value="system">System Emails</option>
                                                    <option @if ($smtp['sender_type'] == "campaign") {{ 'selected' }} @endif value="campaign">Campaign Emails</option>
                                                    <option @if ($smtp['sender_type'] == "user") {{ 'selected' }} @endif value="user">User Emails</option>
                                                @endif
                                            </select>
                  </div>
                </div>
              </div>
              <div class="col-md-6"id="from-email-controls">
                <div class="form-group @error('list_id') has-error @enderror">
                  <label class="form-label">Sender Email</label>
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('list_id') text-danger border-danger @enderror"><i class="ti-email"></i></span>
                    <input type="email" class="form-control" value="{{ $smtp['from_email'] }}" name="from_email" id="from_email">

                  </div>
                </div>
              </div>

          
              <div class="col-md-6"id="from-name-controls">
                <div class="form-group @error('list_id') has-error @enderror">
                  <label class="form-label">Sender Name   </label>
                  <div class="input-group mb-3">
                    <span class="input-group-text @error('list_id') text-danger border-danger @enderror"><i class="ti-user"></i></span>
                    <input type="text" class="form-control" value="{{ $smtp['from_name'] }}" name="from_name" id="from_name">

                  </div>
                </div>
              </div>
              <div class="col-md-6"id="user-controls">
                <div class="form-group @error('list_id') has-error @enderror">
                  <label class="form-label">User </label>
                  <div class="input-group mb-3">
                    <select class="form-select select2" name="user_id" id="user_id"style="width:100%">
                    @if(session("level") >= 7)
                                                    <option value="">Select Extension Email</option>
                                                @endif
                                                @foreach($extensions as $key => $extension)
                                                    <option value={{$extension->id}} @if($smtp['user_id'] == $extension->id)  selected @endif >{{ $extension->email }} - {{ $extension->first_name }}  {{ $extension->last_name }}</option>
                                                @endforeach
                                            </select>
                  </div>
                </div>
              </div>
              <div class="col-md-6"id="campaign-controls">
                <div class="form-group @error('list_id') has-error @enderror">
                  <label class="form-label">Campaign </label>
                  <div class="input-group mb-3">
                    <select class="form-select select2" name="campaign_id" id="campaign_id"style="width:100%">
                    <option value="">Select Campaign</option>
                                                @foreach($campaigns as $key => $campaign)
                                                    <option value="{{ $campaign->id }}" @if($smtp['campaign_id'] == $campaign->id)  selected @endif >{{ $campaign->title }}</option>
                                                @endforeach
                    </select>
                  </div>
                </div>
              </div>
          
              <div class="box-footer text-end">
                                    <button type="button" name="submit" class="btn btn-info btn-warning checkSetting btn-md">Check Setting</button>
                                    <a id="smtpResponce" style="display: none;"> <img style="width:30px;" src="{{ asset('assets/images/loader.gif') }}"/></a>
                                    <button type="submit" name="submit" value="add" class="btn btn btn-primary waves-effect waves-light btn-md">Save</button>
                                </div>
    
      </div>
      <!-- /.row -->
     <!-- /.box-body -->
    </form>
    
            <!-- /.box -->      
        </div>  

    </section>


    <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>

    <script>
        $(document).ready(function() {
            $(".select2-selection--single").css('height',"32px");

            @if ($smtp['sender_type'] == "user")
            $("#campaign-controls").hide();
            $("#from-email-controls").show();
            $("#from-name-controls").show();
            @endif

            @if ($smtp['sender_type'] == "campaign")
            $("#user-controls").hide();
            @endif
            @if ($smtp['sender_type'] == "system")
            $("#user-controls").hide();
            $("#campaign-controls").hide();
            @endif

            $("#sender_type").change(function () {
                $("#from-email-controls").hide();
                $("#from-name-controls").hide();
                $("#user-controls").hide();
                $("#campaign-controls").hide();
                let selected = $(this).val();
                if (selected === 'user') {
                     $("#from-email-controls").show();
                $("#from-name-controls").show();
                    $("#user-controls").show();
                    $("#campaign_id").val('');
                } else {
                    $("#from-email-controls").show();
                    $("#from-name-controls").show();
                    $("#user_id").val('');
                    $('#user_id').trigger('change');
                    if (selected === 'campaign') {
                        $("#campaign-controls").show();
                    } else {
                        $("#campaign_id").val('');
                    }
                }
            });

            $('#smtpform').on('submit', function() {
                let sender_type = $("#sender_type").val();
                let user_id = $("#user_id").val();
                let campaign_id = $("#campaign_id").val();
                if(sender_type === "user" && user_id === "") {
                    $("#alert-errors").html("Select user");
                    $("#alert-errors").show();
                    return false;
                }
                if(sender_type === "campaign" && campaign_id === "") {
                    $("#alert-errors").html("Select campaign");
                    $("#alert-errors").show();
                    return false;
                }
            });

            $("#mail_encryption").change(function () {
                var encry = $("#mail_encryption").val();
                if (encry == 'SSL') {
                    $("#mail_port").val('465');
                } else if (encry == "TLS") {
                    $("#mail_port").val('587');
                }
            });

            $(document).on("click", ".checkSetting", function () {
                var mail_driver = $("#mail_driver").val();
                var mail_host = $("#mail_host").val();
                var mail_port = $("#mail_port").val();
                var mail_encryption = $("#mail_encryption").val();
                var mail_username = $("#mail_username").val();
                var mail_password = $("#mail_password").val();
                var from_email = $("#from_email").val();
                var from_name = $("#from_name").val();
                var sender_type = $("#sender_type").val();
                var user_id = $("#user_id").val();

                if (mail_driver == '') {
                    $("#alert-errors").html("Please enter Driver");
                    $("#alert-errors").show();
                    $("#mail_driver").focus();
                    return false;
                } else if (mail_host == '') {
                    $("#alert-errors").html("Please enter Host");
                    $("#alert-errors").show();
                    $("#mail_host").focus();
                    return false;
                } else if (mail_username == '') {
                    $("#alert-errors").html("Please enter Username");
                    $("#alert-errors").show();
                    $("#mail_username").focus();
                    return false;
                } else if (mail_password == '') {
                    $("#alert-errors").html("Please enter Password");
                    $("#alert-errors").show();
                    $("#mail_password").focus();
                    return false;
                } else if (mail_encryption == '') {
                    $("#alert-errors").html("Please select Encryption");
                    $("#alert-errors").show();
                    $("#mail_encryption").focus();
                    return false;
                } else if (mail_port == '') {
                    $("#alert-errors").html("Please select Port");
                    $("#alert-errors").show();
                    $("#mail_port").focus();
                    return false;
                } else if (sender_type == '') {
                    $("#alert-errors").html("Please select For Sending");
                    $("#alert-errors").show();
                    $("#sender_type").focus();
                    return false;
                } else if (sender_type === 'user' && user_id == '') {
                    $("#alert-errors").html("Please select User");
                    $("#alert-errors").show();
                    $("#user_id").focus();
                    return false;
                }
                $("#smtpResponce").show();

                var el = this;
                $.ajax({
                    headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
                    url: '/checkSMTPSetting',
                    data: {
                        mail_driver: mail_driver,
                        mail_host: mail_host,
                        mail_username: mail_username,
                        mail_password: mail_password,
                        mail_encryption: mail_encryption,
                        mail_port: mail_port,
                        from_email: from_email,
                        from_name: from_name,
                        sender_type: sender_type,
                        user_id: user_id
                    },
                    type: 'post',
                    dataType:"json",
                    success: function (response) {
                        if (response.success) {
                            $(".checkSetting").hide();
                            $("#smtpResponce").show();
                            $("#smtpResponce").html("<span class='btn btn-success btn-ok'>Configuration Setting Success</span>");
                        } else {
                            $(".checkSetting").show();
                            $("#smtpResponce").show();
                            $("#smtpResponce").html("<span class='btn btn-danger btn-ok'>Configuration Setting Failed</span>");
                        }
                        setTimeout(function () {
                            $("#smtpResponce").html('<img style="width:30px;" src="{{ asset('assets/images/loader.gif') }}" />');
                            $("#smtpResponce").hide();
                        }, 3000);
                    },
                    error: function (xhr, status, error) {
                        $("#smtpResponce").html('Failed to send email');
                    }
                });
            });
        });
    </script>
@endsection
