@extends('layouts.app')
@section('title', 'SMTP')

@section('content')
<style>
.badge
{font-size: 1rem;
    font-style: normal;
    font-weight: 400;
    font-family: "IBM Plex Sans", sans-serif;
    line-height: 1.5;}
    .table > tbody > tr > td, .table > tbody > tr > th {
     padding: 0.5rem; 
    vertical-align: middle;
}
.btn-toggle.active {
    background-color: #2196f3; /* Set to the desired green color */
    color: white; /* Set to the desired text color */
    border-color: green; /* Set to the desired border color */
}

/* Style for the inactive state */
.btn-toggle:not(.active) {
    background-color: red; /* Set to the desired red color */
    color: white; /* Set to the desired text color */
    border-color: red; /* Set to the desired border color */
}
    </style>
    
    <link href="https://cdn.jsdelivr.net/gh/gitbrent/bootstrap4-toggle@3.6.1/css/bootstrap4-toggle.min.css" rel="stylesheet">

<!-- Main content -->
        <section class="content">

      <div class="row">

       
        
        <div class="col-12">
          <div class="box">
      
             <div class="box-body">           
                         
              <h4 class="box-title text-info mb-0"><i class="fa fa-user fa-sx"></i> SMTP</h4>
             
              <a href="{{ url('/smtp') }}" type="submit"  style="float:right" class="waves-effect waves-light btn btn-rounded btn-primary btn-bitbucket btn-sm mb-5"><i class="fa fa-plus"></i>Add Smtp</a>
            <hr class="my-15">

         
              <div class="table-responsive">
                <table id="tickets" class="table mt-0 table-hover no-wrap" data-page-size="10">
                  <thead>
                    <tr>
                              <th>#</th>
                              <th>Type</th>
                              <th>Sender</th>                             
                              <th>Mail Driver</th>
                              <th>Host</th>
                              <th>Port</th>
                              <th>Username</th>
                              <th>Encryption</th>
                              <th>Status</th>
                              <th>Action</th>

                            </tr>
                  </thead>
                  <tbody>
                  @foreach($smtps as $key => $smtp)
                                <tr>
                                  <th scope="row">{{$key+1}}</th>
                                  <td>{{$smtp->sender_type}}</td>    
                                  <td>
                                  @if($smtp->sender_type === "system")
                                                    {{ $smtp->from_name }}
                                                @endif
                                                @if($smtp->sender_type === "campaign")
                                                    @if (isset($campaigns[$smtp->campaign_id]))
                                                        {{ $campaigns[$smtp->campaign_id] }}
                                                    @else
                                                        <span class="badge badge-sm badge-danger">Invalid Campaign</span>
                                                    @endif
                                                @endif
                                                @if($smtp->sender_type === "user")
                                                    @if (isset($users[$smtp->user_id]))
                                                        {{ $users[$smtp->user_id] }}
                                                    @else
                                                        <span class="badge badge-sm badge-danger">Invalid User</span>
                                                    @endif
                                                @endif
                                  
                                    </td>
                                    <td>{{$smtp->mail_driver}}</td>
                                    <td>{{$smtp->mail_host}}</td>
                                    <td>{{$smtp->mail_port}}</td>
                                    <td>{{$smtp->mail_username}}</td>
                                    <td>{{$smtp->mail_encryption}}</td>
                                    <td>
                                                <!-- @if($smtp->status == '1')
                                                    <span class="badge badge-sm badge-success">Active</span>
                                                @else ($smtp->status == '0')
                                                    <span class="badge badge-sm badge-danger">Inactive</span>
                                                @endif -->
                                                <button type="button"data-listid="{{$smtp->id}}" class="btn btn-sm btn-toggle  @if($smtp->status == '1') active @endif" data-bs-toggle="button" aria-pressed="true" autocomplete="off">
                                        <div class="handle"></div>
                                            </td>

                                  
                                  <td><a style="cursor:pointer;margin-right:5px;" title="Edit"href="{{url('smtp')}}/{{ $smtp->id }}" class='editEG'><i class="fa fa-edit fa-lg"></i></a> 
                                  <a style="cursor:pointer;margin-right:5px;" title="Copy" href="{{url('copy-smtp/')}}/{{$smtp->id}}" class="" data-id="{{$smtp->id}}"><i class="fa fa-copy fa-lg"></i></a>
                                   <!-- <a style="cursor:pointer;" title="Delete" href="javascript:deleteSetting({{ $smtp->id }})" id='delete-{{ $smtp->id }}'><i class="fa fa-trash-o fa-lg"></i></a></td> -->
                                   <a  class="openSmtpDelete" style="cursor:pointer;"data-smtpid="{{$smtp->id}}" ><i class="fa fa-trash-o fa-lg"></i></a>     

                             
                                </tr>

  
                            @endforeach
                         
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
        <div class="modal fade" id="delete" tabindex="-1" aria-labelledby="deleteLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="myModalLabel">Confirm Delete</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
   
      <div class="modal-body">
      <p>You are about to delete <b><i class="title"></i></b>SMTP.</p>
         <p>Do you want to proceed?</p>
         <input type="hidden" class="form-control" name="smtp_id" value="" id="smtp_id">
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
        <button type="submit"name="submit" class="btn btn-danger btn-sm deleteSmtp">Delete</button>
      </div>
    </div>
  </div>
</div>
      </div>
      <!-- /.row -->

    </section>
        <!-- /.content -->

        <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>
        <script src="https://cdn.jsdelivr.net/gh/gitbrent/bootstrap4-toggle@3.6.1/js/bootstrap4-toggle.min.js"></script>

<script>
    $(".openSmtpDelete").click(function() {
        var delete_id = $(this).data('smtpid');

        $("#delete").modal('show');
        $("#smtp_id").val(delete_id);


    });
    $(document).on("click", ".deleteSmtp", function() {
        //if(confirm("Are you sure you want to delete this record?")){
        var temp_id = $('#smtp_id').val();

        /* alert(temp_id);
         alert(status);*/

        //var account_no = $(this).data('account_no');
        //alert(account_no);
        var el = this;
        $.ajax({
            url: 'smtp-delete/' + temp_id,
            type: 'get',
            success: function(response) {
              toastr.success('SMTP has been deleted successfully');
                    window.location.reload(1);
            }
        });

    });
        // function deleteSetting(id)
        // {
        //     $("#delete-" + id).hide();
        //     postData = {
        //         "_token": "{{ csrf_token() }}"
        //     };
        //     $.ajax({
        //         type: "POST",
        //         url: "/smtp-delete/" + id,
        //         data: postData,
        //         dataType: "json",
        //         success: function (data) {
        //             console.log(data);
        //             if (data.success) {
        //                 $("#alert-success").html(data.message).show();
        //                 setTimeout(function(){
        //                     window.location.reload(1);
        //                 }, 2000);
        //             } else {
        //                 $("#alert-errors").html(data.message).show();
        //             }
        //         },
        //         error: function (xhr, status, error) {
        //             $("#alert-errors").html(error).show();
        //         }
        //     });
        // }
    </script>

<script>
$(function()
{
    $("#tickets").on("click", ".btn-toggle", function ()
    {
       console.log('hi');
      var status = $(this).hasClass('active') ? 1 : 0;
        var listid = $(this).data('listid');    


        $.ajax({
            type: "GET",
            dataType: "json",
            url: '/updateSmtpStatus/'+listid+ '/' +status,

            success: function(data)
            {
                if(data.status == 'true')
                {
                    toastr.success(data.message);
                }
                else
                {
                    toastr.error(data.message);

                }

                console.log(data.success);
                window.location.reload(1);
            }
        });
    })
})
</script>

@endsection
