@extends('layouts.app')
@section('title', 'Active Plan List')

@section('content')
<style>
  .badge
{font-size: 1rem;
    font-style: normal;
    font-weight: 400;
    font-family: "IBM Plex Sans", sans-serif;
    line-height: 1.5;}
    .table > tbody > tr > td, .table > tbody > tr > th {
     padding: 0.5rem; 
    vertical-align: middle;
}
  </style>
<!-- Main content -->
        <section class="content">

      <div class="row">
        
        <div class="col-12">
          <div class="box">
           <div class="box-body">   
                      
              <h4 class="box-title text-info mb-0"><i class="fa fa-list fa-sx"></i> Active Plan List</h4> 
                <hr class="my-15">     
              <div class="table-responsive">
                <table id="tickets"  class="table mt-0 table-hover no-wrap" >
                  <thead>
                    <tr>
                                     <th>#</th>
                                    <th>Package Name / Billing</th>
                                    @if(Session::get('level') > 7)
                                    <th>Client Name</th>
                                    @endif
                                    <th>Licenses in Use / Total License</th>
                                    <th>Start Time</th>
                                    <th>End Time</th>
                                    <th>Days Left</th>

                            </tr>
                  </thead>
                  <tbody>
                  @php
                                $i=1;
                                @endphp
                                @if(!empty($active_plans))
                                @foreach($active_plans as $key => $plan)
                                

                                @foreach($plan as $subscription)
                                @php 
                                $availableSlot = count((array)$subscription->assigned);
                                @endphp

                               

                                <tr>
                                    <td>{{ $i++ }}</td>
                                    <td>{{$subscription->package_name}} <span style="float:right;" class="badge badge-info"> {{$subscription->billed}}</span></td>
                                    @if(Session::get('level') > 7)
                                    <td>{{$subscription->client_name}}</td>
                                    @endif
                                    <td><span class="badge badge-info">{{$availableSlot}}</span> / <span class="badge badge-secondary">{{$subscription->quantity}}</span></td>
                                    <td>{{$subscription->start_time}}</td>
                                    <td>{{$subscription->end_time}}</td>
                                    <td>
                                        @php
                                        $start_time = new DateTime(date("Y-m-d"));
                                        $end_time = new DateTime($subscription->end_time);
                                        $days = $end_time->diff($start_time)->format("%a");
                                        @endphp
                                        <span class="badge badge-info">{{$days}}</span>
                                    </td>   

                                </tr>
                                @endforeach
                                @endforeach

                                @endif                      
                  </tbody>
                </table>
              
                    </div><!-- /.box-body -->
            

              </div>
     
            </div>
          </div>
        </div>
      </div>
      <!-- /.row -->
   
      <!-- Button trigger modal -->



 
        </div>
    </section>
 





@endsection
