@extends('layouts.app')
@section('title', 'History Plan List')

@section('content')
    <style>
        .badge {
            font-size: 1rem;
            font-style: normal;
            font-weight: 400;
            font-family: "IBM Plex Sans", sans-serif;
            line-height: 1.5;
        }

        .table>tbody>tr>td,
        .table>tbody>tr>th {
            padding: 0.5rem;
            vertical-align: middle;
        }
    </style>
    <!-- Main content -->
    <section class="content">

        <div class="row">

            <div class="col-12">
                <div class="box">
                    <div class="box-body">
                        <h4 class="box-title text-info mb-0"><i class="fa fa-list fa-sx"></i> History Plan List</h4>

                        <hr class="my-15">
                        <div class="table-responsive">
                            <table id="tickets" class="table mt-0 table-hover no-wrap">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Package Name</th>
                                        @if(Session::get('level') > 7)
                                            <th>Client Name</th>
                                        @endif
                                        <th>Total Licence</th>
                                        <th>Start Time</th>
                                        <th>End Time</th>
                                        <th>Expiry Time</th>

                                    </tr>
                                </thead>
                                <tbody>
                                    @if(!empty($plan_history))
                                        @foreach(array_reverse($plan_history) as $key => $plan)
                                            <tr>
                                                <td>{{$key + 1}}</td>
                                                <td>
                                                    @foreach($packages as $list)
                                                        @if($list->key == $plan->package_key)
                                                            {{$list->name}}
                                                        @endif
                                                    @endforeach
                                                </td>
                                                @if(Session::get('level') > 7)
                                                    <td>
                                                        @foreach($clients as $clt)
                                                            @if($clt->id == $plan->client_id)
                                                                {{$clt->company_name}}
                                                            @endif
                                                        @endforeach
                                                    </td>
                                                @endif
                                                <td><span class="badge badge-info">{{$plan->quantity}}</span></td>
                                                <td>{{$plan->start_time}}</td>
                                                <td>{{$plan->end_time}}</td>
                                                <td>{{$plan->expiry_time}}</td>
                                            </tr>
                                        @endforeach
                                    @endif
                                </tbody>
                            </table>

                        </div><!-- /.box-body -->


                    </div>

                </div>
            </div>
        </div>
        </div>
        <!-- /.row -->

        <!-- Button trigger modal -->




        </div>
    </section>






@endsection
