@extends('layouts.app')
@section('title', 'Upgrade Subscription')

@section('content')
<style>
  .badge
{font-size: 1rem;
    font-style: normal;
    font-weight: 400;
    font-family: "IBM Plex Sans", sans-serif;
    line-height: 1.5;}
  </style>
  <link rel="stylesheet" href="<?php echo e(asset('assets/css/subscriptions.css')); ?>">

<!-- Main content -->
<section class="content">
            <div class="row">
                @include('layouts.messaging')
                <div class="box-header with-border">            
              <h4 class="box-title text-info mb-0"><i class="fa fa-list fa-sx"></i> Upgrade Subscription</h4> 


            </div>
                <div class="price-sec-wrap"style="margin-top:10px;">
                    <div class="container upgrade-plan">
                        <div class="row ">
                            @php $intBoxSize = 3; @endphp
                            @if(isset($arrPackagesDetails))
                                @foreach($arrPackagesDetails as $strPackageName => $PackagesDetail)
                                    @if($arrTrialPackageDetails->days_remaining == 0 && $arrTrialPackageDetails->count >= 2 && strtolower($PackagesDetail->name) == 'trial')
                                        <!-- @php $intBoxSize = 4; @endphp -->
                                        @php continue; @endphp
                                    @endif
                                    <div class="col-lg-4 col-md-6 col-sm-12 mb-4 d-flex mb-3">
                                        <div class="price-box flex-fill">
                                            <div class="">
                                                <div class="price-label {{strtolower($PackagesDetail->name)}}">{{$PackagesDetail->name}} Plan</div>
                                                <div class="price"><?php if($PackagesDetail->currency_code == 'USD') echo '$'; elseif($PackagesDetail->currency_code == 'CAD') echo 'C$'; elseif($PackagesDetail->currency_code == 'INR') echo '₹'; else echo '$'; ?>{{$PackagesDetail->base_rate_monthly_billed}}</div>
                                                <div class="price-info">Per Month, Per User.</div>
                                            </div>
                                            <div class="info">
                                                @php print $PackagesDetail->description; @endphp
                                                    @if(strtolower($PackagesDetail->name) == 'trial')
                                                        @if($arrTrialPackageDetails->expired == TRUE)
                                                            <div class="no-action subscription-expired">Plan Expired!</div>
                                                        @else
                                                            <div class="no-action days-remaining">{{$arrTrialPackageDetails->days_remaining}} Days remaining</div>
                                                        @endif
                                                    @else
                                                        <select name="d_type" class="form-select billing-type">
                                                            <option value="#">Select Billing Period</option>
                                                            <option value="4">Yearly</option>
                                                            <option value="3">Half Yearly</option>
                                                            <option value="2">Quarterly</option>
                                                            <option value="1">Monthly</option>
                                                        </select>
                                                        <div class="number-of-users">
                                                            <div class="title">No. of users</div>
                                                            <span class="minus" data-page="upgrade"><span class="glyphicon glyphicon-minus"></span></span>
                                                            <input type="text" value="0"/>
                                                            <span class="plus" data-page="upgrade"><span class="glyphicon glyphicon-plus"></span></span>
                                                        </div>
                                                        <input type="hidden" class="selected-package" name="package-name" value="{{$PackagesDetail->name}}">
                                                        <a href="#" class="btn btn btn-primary waves-effect waves-light plan-btn add-to-cart">Add to cart</a>
                                                    @endif
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            @endif
                        </div>
                    </div>
                </div>
            </div>
            <!-- /.row -->
        </section>
 



        <script src="<?php echo e(asset('assets/js/pages/subscriptions.js')); ?>"></script>


@endsection
