@extends('layouts.app')
@section('title', 'Subscriptions')

@section('content')
<style>
  .badge
{font-size: 1rem;
    font-style: normal;
    font-weight: 400;
    font-family: "IBM Plex Sans", sans-serif;
    line-height: 1.5;}
    .table > tbody > tr > td, .table > tbody > tr > th {
     padding: 0.5rem; 
    vertical-align: middle;
}
  </style>
<!-- Main content -->
        <section class="content">

      <div class="row">
        
        <div class="col-12">
          <div class="box">
             <div class="box-body">   
              <h4 class="box-title text-info mb-0"><i class="fa fa-list fa-sx"></i> User Packages</h4> 
                 <hr class="my-15">    
              <div class="table-responsive">
                <table id="tickets"  class="table mt-0 table-hover no-wrap" >
                  <thead>
                    <tr>
                    <th>#</th>
                                    <th>Name</th>
                                    <th>Role</th>
                                    <th>Available Package</th>

                            </tr>
                  </thead>
                  <tbody>
                  @foreach($userPackages as $key => $userPackage)
                                    <tr>
                                        <td>{{$key+1}}</td>
                                        <td>{{$userPackage->first_name}} {{$userPackage->last_name}}</td>
                                        <td>{{$userPackage->role}}</td>
                                        <td>
                                            @if( $userPackage->package_key ) {{-- package selected --}}
                                                <select class="form-control package-control-selected" name="package" data-client="{{$userPackage->client_id}}" data-user="{{$userPackage->user_id}}">
                                                    @php
                                                        $earlier = new DateTime(date("Y-m-d"));
                                                        $later = new DateTime($userPackage->end_time);
                                                        $diff = $later->diff($earlier)->format("%a");
                                                    @endphp
                                                    <option value="{{$userPackage->package_key}}">{{$userPackage->package_name}} – {{$diff}} Days remaining</option> {{-- selected package name --}}
                                                    <option name ="package" value="{{$userPackage->package_key}}">Remove Package</option>
                                                </select>
                                            @else
                                                <select class="form-select package-control-select" name="package" data-client="{{$userPackage->client_id}}" data-user="{{$userPackage->user_id}}">
                                                    <option value="#">Assign package</option>
                                                    @foreach($availablePackages as $key => $availablePackage)
                                                        @php $availableSlot = $availablePackage->quantity - count((array)$availablePackage->assigned);
                                                        $earlier = new DateTime(date("Y-m-d"));
                                                        $later = new DateTime($availablePackage->end_time);
                                                        $diff = $later->diff($earlier)->format("%a");
                                                        @endphp
                                                                <option name ="package" value="{{$availablePackage->package_key}}">{{$availablePackage->package_name}} ({{$availableSlot}}) – {{$diff}} Days remaining</option>
                                                    @endforeach
                                                </select>
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach               
                  </tbody>
                </table>
              
                    </div><!-- /.box-body -->
            

              </div>
     
            </div>
          </div>
        </div>
      </div>
      <!-- /.row -->
   
      <!-- Button trigger modal -->



 
        </div>
    </section>
 
    <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>

    <script type="text/javascript">
    $(document).ready(function() {
        

        $(document).on('change', '.package-control-select', function(){
            var package_key = this.value;
            if ( package_key != "#" ){
                var client_id = $(this).data('client');
                var user_id = $(this).data('user');
                var csrf_token = $('meta[name="csrf-token"]').attr('content');
                $.ajax({
                    url: '/user-package/update/' + package_key,
                    type: 'POST',
                    data: {
                        user_id: user_id,
                        client_id: client_id,
                        _token: csrf_token 
                    },
                    dataType:"json",
                    success: function (response)
                    {
                        toastr.success(response);
                        location.reload();
                    }
                });
            }
        });

        $(document).on('change', '.package-control-selected', function(){
            var package_key = this.value;
                var client_id = $(this).data('client');
                var user_id = $(this).data('user');
                var csrf_token = $('meta[name="csrf-token"]').attr('content');

                $.ajax({
                    url: '/user-package/delete/' + package_key,
                    type: 'POST',
                    data: {
                        user_id: user_id,
                        client_id: client_id,
                        _token: csrf_token 

                    },
                    dataType:"json",
                    success: function (response)
                    {
                        toastr.success(response);
                        location.reload();
                    }
                });
        });
    });
    </script>



@endsection
