@extends('layouts.app')
@section('title', 'Super Admin List')

@section('content')

<!-- Main content -->
        <section class="content">

      <div class="row">


        
        <div class="col-12">
          <div class="box">
           <div class="box-body">   
                   
              <h4 class="box-title text-info mb-0"><i class="icon-Add-user"><span class="path1"></span><span class="path2"></span></i> Super Admin List</h4>


         
              
                    </form>   
                    <hr class="my-15">     
              <div class="table-responsive">
                <table  class="table mt-0 table-hover no-wrap" >
                  <thead>
                    <tr>
                    <tr>
                                    <th>#</th>
                                    <th>Extension</th>
                                    <th>Name</th>
                                    <th>Voicemail (PIN)</th>
                                    <th>Public IP</th>
                                    <th>Local IP:Port</th>
                                    <th>Call Forward</th>
                                    <th>Twinning</th>
                                    <th>Follow Me</th>


                                    <!-- <th>Status</th> -->
                                    <th>Action</th>
                                </tr>
                  </thead>
                  <tbody>
                  @php 
                                $i=1
                                @endphp    
                                @foreach($extension_list as $key => $extensions)
                                @if(($extensions->user_level == '9'))                                
                                <tr>
                                        <td>{{$i}}</td>
                                        <td>{{$extensions->extension}}</td>
                                        <td>{{$extensions->first_name}} {{$extensions->last_name}}</td>
                                        <td>
                                            @if ($extensions->voicemail_greeting != '')
                                                <span class="badge badge-success">Yes</span>
                                            @else
                                                <span class="badge badge-danger">NO</span>
                                            @endif
                                            &nbsp;&nbsp;
                                            <span class="badge badge-info">{{$extensions->vm_pin}}</span>
                                        </td>
                                        
                                        <td>
                                            @isset($extensions->ipaddr)
                                                {{$extensions->ipaddr}}
                                            @endisset
                                        </td>
                                        <td>
                                            @isset($extensions->fullcontact)
                                                @php
                                                    $udata = explode('@', substr(trim($extensions->fullcontact), 0, 30));
                                                    print_r(end($udata));
                                                @endphp
                                            @endisset
                                        </td>
                                        <td>
                                            @if ($extensions->call_forward == '1')
                                                <span class="badge badge-success">YES</span>
                                            
                                            @elseif ($extensions->call_forward == '2')
                                                <span class="badge badge-danger">NO</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if ($extensions->twinning == '1')
                                                <span class="badge badge-success">YES</span>
                                            
                                            @elseif ($extensions->twinning == '2')
                                                <span class="badge badge-danger">NO</span>
                                            @endif
                                        </td>

                                         <td>
                                            @if ($extensions->follow_me == '1')
                                                <span class="badge badge-success">YES</span>
                                            
                                            @elseif ($extensions->follow_me == '2')
                                                <span class="badge badge-danger">NO</span>
                                            @endif
                                        </td>

                                        <td>
                                            <a style="cursor:pointer;color:blue;margin-right:5px;" href="{{url('super-admin')}}/{{ $extensions->id}}" class='editEG'  title='Edit Extension'><i class="fa fa-edit fa-lg"></i></a>
                                            <a style="cursor:pointer;" class='openExtensionDelete' data-id={{$extensions->id}}><i class="fa fa-trash-o fa-lg" title='Delete Extension'></i></a></td>
                                    </tr>
                                    @php
                                    $i++
                                    @endphp
                                    @endif

                                @endforeach                      
                  </tbody>
                </table>
           
                    </div><!-- /.box-body -->


      

              </div>
     
            </div>
          </div>
        </div>
      </div>
      <!-- /.row -->
   
      <!-- Button trigger modal -->


<!-- Modal -->
<div class="modal fade" id="hangupConferencesModal" tabindex="-1" aria-labelledby="myModalExcelLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="add-edit"></h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <form method="post" name="add-ip-form" action="">
        @csrf
      <div class="modal-body">
      <label for="inputEmail3" class="form-label">Extension Number</label>
                                    <input type="text" readonly class="form-control" minlength="7" placeholder="" name="hangupConferences_id" id="hangupConferences_id">
                                    <div id="hangup-conference"></div>
       
      </div>
      <div class="modal-footer">
        <button type="button"id="hangupConferences-cancel" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
        <button type="submit" id="hangupConferences"name="submit" class="btn btn-primary btn-sm">Execute</button>
      </div>
        </form>
    </div>
  </div>
</div>
            
        
    <!-- Modal -->
<div class="modal fade" id="addIpModal" tabindex="-1" aria-labelledby="myModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="add-edit"></h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <form method="post" name="add-ip-form" action="">
                                @csrf
      <div class="modal-body">
      <input type="hidden" class="form-control" name="ext_ip_id" value="" id="ext_ip_id" required>
                                    <input type="hidden" class="form-control" name="ip_name" value="ip" id="" required>
                                    <label for="inputEmail3" class="col-form-label">Add Ip</label>
                                    <input type="text" class="form-control" minlength="7" placeholder="xxx.xxx.xxx.xxx" name="allowed_ip" id="allowed_ip">                 
                 
                          
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
                                <button type="submit"name="submit" class="btn btn-primary btn-sm">Save</button>
                            </div>
        </form>
    </div>
  </div>
</div>
<div class="modal fade" id="myModal" tabindex="-1" aria-labelledby="deleteLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="add-edit"></h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <form method="post" name="edit-extention" action="">
                                @csrf
      <div class="modal-body">
      <input type="hidden" class="form-control" name="ext_id" value="" id="ext_id" required>
                                    <label for="inputEmail3" class="form-label">New Password</label>
                                    <input type="text" class="form-control" required name="password" id="password" placeholder="Enter New Password">
       
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
        <button type="submit"name="submit" class="btn btn-primary btn-sm ">Save</button>
      </div>
      </form>

    </div>
  </div>
</div>
<div class="modal fade" id="changePermissionModal" tabindex="-1" aria-labelledby="deleteLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="change-permission-title">Change permission</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <form method="post" name="save-user-roles-form" id="save-user-roles-form" action="{{ route('saveUserRoles') }}">
      <div class="modal-body">
      <div id="role-modal-loader" style="display:none; text-align: center;">
                                        <img src="assets/images/loader.gif" alt="loading..." height=100 width=100 />
                                    </div>
                                    <input type="hidden" class="form-control" name="role_ext_id" value="" id="role_ext_id" required>
                                    <div id="change-permission-body"></div>
       
      </div>
      <div class="modal-footer">
        <button type="button" id="role-modal-close"class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
        <button type="submit"id="role-modal-save"name="submit" class="btn btn-primary btn-sm "style="display: none;" >Save</button>
      </div>
</form>
    </div>
  </div>
</div>
<div class="modal fade" id="delete" tabindex="-1" aria-labelledby="deleteLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="myModalLabel">Confirm Delete</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
      <p>You are about to delete <b><i class="title"></i></b> Extension.</p>
                                <p>Do you want to proceed?</p>
                                <input type="hidden" class="form-control" name="label_id" value="" id="extension_id">
       
      </div>
      <div class="modal-footer">
        <button type="button" id="role-modal-close"class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
        <button type="submit"id="role-modal-save"name="submit" class="btn btn-danger btn-sm deleteExtension">Delete</button>
      </div>
    </div>
  </div>
</div>

        </div>
    </section>
        <!-- /.content -->




@endsection
