@extends('layouts.app')

@section('title', 'Send Test Notification')

@section('content')
<div class="container content">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3 class="mb-0">Send Test Notification</h3>
    </div>

    <div class="card card-shadow p-3">
        <form id="sendNotificationForm">
            @csrf

            <div class="mb-3">
                <label class="form-label">Notification Title</label>
                <input type="text" id="title" name="title" class="form-control" placeholder="Enter notification title" required>
            </div>

            <div class="mb-3">
                <label class="form-label">Notification Message</label>
                <textarea id="body" name="body" class="form-control" placeholder="Enter notification message" required></textarea>
            </div>

            <div class="mb-3">
                <button type="button" id="sendNotificationBtn" class="btn btn-primary">Send Test Notification</button>
            </div>
        </form>

        <div id="responseMessage" class="mt-3" style="display:none;"></div>
    </div>
</div>

<script>
document.getElementById("sendNotificationBtn").addEventListener("click", async function() {
    const title = document.getElementById("title").value.trim();
    const body = document.getElementById("body").value.trim();
    const responseDiv = document.getElementById("responseMessage");

    responseDiv.style.display = "none";

    if (!title || !body) {
        responseDiv.style.display = "block";
        responseDiv.style.color = "red";
        responseDiv.innerText = "Please provide both title and message.";
        return;
    }

    try {
        const response = await fetch("{{ route('notification.test') }}", {
            method: "POST",
            headers: {
                "Content-Type": "application/json",
                "X-CSRF-TOKEN": "{{ csrf_token() }}"
            },
            body: JSON.stringify({ title, body })
        });

        const data = await response.json();

        responseDiv.style.display = "block";
        responseDiv.style.color = data.success ? "green" : "red";
        responseDiv.innerText = data.success
            ? "Notification sent successfully."
            : (data.message || "Failed to send notification.");
    } catch {
        responseDiv.style.display = "block";
        responseDiv.style.color = "red";
        responseDiv.innerText = "Something went wrong while sending the notification.";
    }
});
</script>
@endsection
