
{{-- enter phone modal --}}
<div class="modal fade" id="enterPhoneModal" role="dialog" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Enter Phone Number</h5>
                <button class="btn-close custom-btn-close border p-1 me-0 text-dark" data-bs-dismiss="modal" aria-label="Close">
                    <i class="ti ti-x"></i>
                </button>
            </div>

            <form method="POST" action="{{ route('submit.phone') }}">
                @csrf
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="col-form-label">Phone Number <span class="text-danger">*</span></label>
                        <div class="input-group">
                            <select class="form-select w-auto text-uppercase" id="countryCodeSelect" name="country_code" style="max-width: 110px;">
                                    <option value="+1" selected>US +1</option>
                                    <option value="+91">IN +91</option>
                                    <option value="+44">GB +44</option>
                                    <option value="+61">AU +61</option>
                                    <option value="+49">DE +49</option>
                                    <option value="+33">FR +33</option>
                                    <option value="+81">JP +81</option>
                                    <option value="+82">KR +82</option>
                                    <option value="+39">IT +39</option>
                                    <option value="+55">BR +55</option>
                                    <option value="+7">RU +7</option>
                                    <option value="+86">CN +86</option>
                                    <option value="+27">ZA +27</option>
                                    <option value="+34">ES +34</option>
                                    <option value="+46">SE +46</option>
                            </select>
                            <input type="text" name="phone" class="form-control" id="phoneInput"
                                placeholder="Enter phone number" required>
                        </div>
                        <small id="phoneError" class="text-danger d-none">Invalid phone number format.</small>
                    </div>
                </div>

                <div class="modal-footer border-top-0 pt-0">
                    <button type="button" class="btn btn-light me-2" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Send OTP</button>
                </div>
            </form>
        </div>
    </div>
</div>

@if (session('phone_modal') === 'enter_phone')
    @push('script')
        <script>
            window.addEventListener('DOMContentLoaded', () => {
                const modal = new bootstrap.Modal(document.getElementById('enterPhoneModal'));
                modal.show();
            });
        </script>
    @endpush
@endif
@if (session()->get('phone_modal') === 'verify_phone')
    {{-- verify otp modal --}}
    <div id="verifyPhoneModal" class="modal fade" tabindex="-1" aria-labelledby="verifyPhoneLabel" aria-hidden="true"
        data-bs-backdrop="static" data-bs-keyboard="false">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Verify Phone Number</h5>
                    <button id="customCloseBtn" class="btn-close custom-btn-close border p-1 me-0 text-dark" data-bs-dismiss="modal"
                        aria-label="Close">
                        <i class="ti ti-x"></i>
                    </button>
                </div>

                <form method="POST" action="{{ route('verify.phone') }}">
                    @csrf
                    <div class="modal-body px-4 pt-3">
                        <div class="mb-3">
                            <label class="form-label"><i class="ti ti-phone text-dark me-1"></i> Phone Number</label>
                            <div class="d-flex">
                                <input type="text" name="phone" class="form-control me-2"
                                    value="{{ session('verify_phone.phone') }}" readonly>
                                <a href="{{ route('edit.phone') }}" class="btn btn-success">Edit</a>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label"><i class="ti ti-lock text-dark me-1"></i> Enter OTP</label>
                            <div class="d-flex align-items-center mb-4">
                                @for ($i = 1; $i <= 6; $i++)
                                    <input type="text"
                                        class="otp-input  border rounded  py-sm-3 py-2 text-center fs-26 hw-bold me-3"style="border: 1px solid #ced4da !important;"
                                        id="digit-{{ $i }}" name="digit{{ $i }}"
                                        data-next="digit-{{ $i + 1 }}"
                                        data-previous="digit-{{ $i - 1 }}"
                                        maxlength="1" required>
                                @endfor
                            </div>
                            @error('code')
                                <small class="text-danger">{{ $message }}</small>
                            @enderror
                        </div>
                    </div>

                    <div class="modal-footer">
                        <a href="{{ route('resend.otp') }}" class="btn btn-light">Resend OTP</a>
                        <button type="submit" class="btn btn-primary">Verify</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/inputmask/5.0.8/jquery.inputmask.min.js"></script>
<script>
    $(document).ready(function(){
        $("#phoneInput").inputmask("(999) 999-9999"); 
    });
</script>

        <script>
            window.addEventListener('DOMContentLoaded', () => {
                const modal = new bootstrap.Modal(document.getElementById('verifyPhoneModal'));
                modal.show();
            });

            document.addEventListener('DOMContentLoaded', function () {
                const inputs = document.querySelectorAll('.otp-input');
                inputs.forEach((input) => {
                    input.addEventListener('input', (e) => {
                        if (e.target.value.length === 1) {
                            const next = document.getElementById(input.dataset.next);
                            if (next) next.focus();
                        }
                    });
                    input.addEventListener('keydown', (e) => {
                        if (e.key === "Backspace") {
                            const prev = document.getElementById(e.target.dataset.previous);
                            if (e.target.value !== '') {
                                e.target.value = '';
                                if (prev) prev.focus();
                                e.preventDefault();
                            } else if (prev) {
                                prev.focus();
                                prev.select();
                                e.preventDefault();
                            }
                        }
                    });
                    input.addEventListener('focus', (e) => {
                        e.target.select();
                    });
                });

                const closeBtn = document.getElementById('customCloseBtn');
                const modalElement = document.getElementById('enterPhoneModal');
                const bootstrapModal = bootstrap.Modal.getInstance(modalElement) || new bootstrap.Modal(modalElement);

                closeBtn.addEventListener('click', function () {
                    fetch("{{ route('close.modal') }}", {
                        method: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': '{{ csrf_token() }}',
                            'Accept': 'application/json',
                            'Content-Type': 'application/json',
                        }
                    }).then(response => {
                        if (response.ok) {
                            bootstrapModal.hide();
                        } else {
                            console.error("Failed to call close.modal");
                        }
                    }).catch(error => {
                        console.error("AJAX error:", error);
                    });
                });
            });
        </script>
@endif


    <script src="{{ asset('assets/js/cleave.min.js') }}"></script>
  <script>
    document.addEventListener('DOMContentLoaded', function () {
        const phoneInput = document.getElementById('phoneInput');
        const phoneError = document.getElementById('phoneError');
        const countryCodeSelect = document.getElementById('countryCodeSelect');

        let cleaveInstance;

        const initCleave = (countryCode) => {
            if (cleaveInstance) cleaveInstance.destroy();

            let formatOptions;

            switch (countryCode) {
                case '+1': // US / Canada
                    formatOptions = { 
                        blocks: [0, 3, 3, 4], 
                        delimiters: ["(", ") ", "-"], 
                        numericOnly: true 
                    };
                    break;
                case '+91': // India
                    formatOptions = { blocks: [5, 5], delimiter: ' ', numericOnly: true };
                    break;
                case '+44': // UK
                    formatOptions = { blocks: [5, 6], delimiter: ' ', numericOnly: true };
                    break;
                default:
                    formatOptions = { blocks: [3, 3, 4], delimiters: ['-', '-'], numericOnly: true };
                    break;
            }

            cleaveInstance = new Cleave(phoneInput, formatOptions);
        };

        // Initialize
        initCleave(countryCodeSelect.value);

        // On country code change
        countryCodeSelect.addEventListener('change', () => {
            phoneInput.value = '';
            initCleave(countryCodeSelect.value);
        });

        // Validation
        const form = phoneInput.closest('form');
        form.addEventListener('submit', function (e) {
            const rawValue = cleaveInstance.getRawValue();
            const code = countryCodeSelect.value;

            let valid = false;
            if (code === '+1') valid = /^\d{10}$/.test(rawValue);
            else if (code === '+91') valid = /^\d{10}$/.test(rawValue);
            else if (code === '+44') valid = /^\d{11}$/.test(rawValue);

            if (!valid) {
                e.preventDefault();
                phoneError.classList.remove('d-none');
                phoneInput.classList.add('is-invalid');
            } else {
                phoneError.classList.add('d-none');
                phoneInput.classList.remove('is-invalid');
            }
        });
    });
</script>



@push('style')
<style>
    #countryCodeSelect {
        min-width: 100px;
        text-transform: uppercase;
        font-weight: 500;
    }

    .form-select option {
        font-weight: 500;
    }

    .input-group .form-control {
        border-left: none;
    }
</style>
@endpush
