
@extends('layouts.app')
@section('content')
@section('title', 'Profile')



<?php

use \App\Http\Controllers\InheritApiController;
$userdetails = InheritApiController::headerUserDetails();
//dd($userdetails);
//echo $userdetails->data->parent_id;die;
?>
<style>
    #qr_code_container img {
    width: 180px;   /* smaller width */
    height: 180px;  /* smaller height */
    display: block;
    margin: 0 auto; /* center it */
}
.otp-input {
    width: 50px;          /* equal width */
    height: 50px;         /* square shape */
    font-size: 20px;      /* bigger text */
    text-align: center;   /* center digits */
    font-size: 22px;
    font-weight: bold;
    font-weight: bold;
    border: 2px solid #007bff;  /* blue border */
    border-radius: 8px;
    background-color: #f9f9f9;  /* light grey background */
    color: #000;                /* black text */
    box-shadow: 0 0 5px rgba(0,0,0,0.1);
    transition: all 0.2s ease-in-out;
}
.otp-input:focus {
    border-color: #0056b3;      /* darker blue on focus */
    background-color: #fff;     /* white background when typing */
    outline: none;
    box-shadow: 0 0 8px rgba(0,123,255,0.4);
}
.profile-pic-wrapper {
    width: 120px;
    height: 120px;
    border-radius: 50%;
    overflow: hidden;
    background-color: #e0e0e0;
    /* fallback color */
    display: flex;
    align-items: center;
    justify-content: center;
    margin-left: 0px;
    border: 2px solid #007bff;
    box-shadow: 0 2px 6px rgba(0, 0, 0, 0.15);
}

.profile-img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}


.btn {
    cursor: pointer;
}


.custom-toggle {
    position: relative;
    display: inline-block;
    width: 46px;
    height: 24px;
}

.custom-toggle input {
    opacity: 0;
    width: 0;
    height: 0;
}

.slider {
    position: absolute;
    cursor: pointer;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-color: #ccc;
    transition: 0.4s;
    border-radius: 34px;
}

.slider::before {
    position: absolute;
    content: "";
    height: 18px;
    width: 18px;
    left: 3px;
    bottom: 3px;
    background-color: white;
    transition: 0.4s;
    border-radius: 50%;
}

input:checked+.slider {
    background-color: #2196f3;
}

input:checked+.slider::before {
    transform: translateX(22px);
}
</style>

<style>
#voicemailCardWrapper,
#voicemailAiCardWrapper {
    display: none;
    width: 100%;
}


.visible-table {
    display: block !important;
    width: 100%;
    position: relative;
}
</style>


<style>
.card {
    border: 1px solid #dee2e6 !important;
    border-radius: 6px;
    box-shadow: none;
    height: auto !important;  
}

.card-body {
      padding: 12px 15px;
    display: block; 
    flex-direction: column;
    justify-content: flex-start;
}


.profile-pic-wrapper {
  position: relative;
  width: 70px;
  height: 70px;
  border-radius: 50%;
  overflow: hidden;
  cursor: pointer;
  flex-shrink: 0;
}

.profile-pic-wrapper img.profile-img {
  width: 100%;
  height: 100%;
  object-fit: cover;
  border-radius: 50%;
  display: block;
  transition: 0.3s ease-in-out;
}

.profile-pic-wrapper .overlay {
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  background: rgba(0, 0, 0, 0.5);
  color: #fff;
  display: flex;
  align-items: center;
  justify-content: center;
  font-size: 20px;
  opacity: 0;
  transition: opacity 0.3s ease-in-out;
}

.profile-pic-wrapper:hover .overlay {
  opacity: 1;
}


.card-body h6.fw-semibold {
    font-weight: 500 !important;   
    font-size: 14px;
    letter-spacing: 0.2px;
    margin-bottom: 6px;
    color: #111;                  
}

.card-body p {
    margin: 0;
    font-size: 13px;
    color: #444;
    line-height: 1.4;
}


.card-body .btn {
    border-radius: 4px;
    font-size: 13px;
    padding: 6px 12px;
}

.last-updated {
  font-size: 11px;     
  color: #666;         
  margin-bottom: 6px;  
  white-space: normal;   
  word-wrap: break-word; 
  line-height: 1.3;     
}

.edit-btn {
  position: absolute;
  top: 0;        
  right: 0;       
  background: #eef3ff;   
  color: #0066ff;       
  padding: 6px 10px;
  border-bottom-left-radius: 8px; 
  font-size: 20px;
  display: flex;
  align-items: center;
  justify-content: center;
}
.edit-btn:hover {
  background: #dce8ff;
  color: #0044cc;
}
.voicemail-card .add-btn,
.voicemail-card .edit-btn,
.voicemail-card .delete-btn {
  position: absolute;
  top: 0;
  background: #eef3ff;
  padding: 6px 10px;   
  font-size: 20px;    
  display: flex;
  align-items: center;
  justify-content: center;
  cursor: pointer;
}


.voicemail-card .add-btn {
  right: 0; 
  color: #0066ff;
  border-bottom-left-radius: 8px;
}

.voicemail-card .edit-btn {
  right: 32px; 
  color: #0066ff;
  border-bottom-left-radius: 8px;
}

.voicemail-card .delete-btn {
  right: 0;
  color: #dc3545;
  border-bottom-left-radius: 8px;
}

.voicemail-card .add-btn:hover,
.voicemail-card .edit-btn:hover {
  background: #dce8ff;
  color: #0044cc;
}

.voicemail-card .delete-btn:hover {
  background: #f8d7da;
  color: #a71d2a;
}



@media (min-width: 768px) and (max-width: 1024px) {
  .row .col-lg-4,
  .row .col-md-6,
  .row .col-sm-12 {
    flex: 0 0 100% !important;
    max-width: 100% !important;
  }

  .card {
    width: 100% !important;
    margin-bottom: 15px;
  }
}


@media (max-width: 375px) {
  .card {
    overflow: hidden !important;
    box-sizing: border-box;
    padding-left: 8px;
    padding-right: 8px;
  }

  .audio-wrap {
    width: 100% !important;
    max-width: 100% !important;
    display: block;
    overflow: hidden;
    box-sizing: border-box;
  }

  .audio-wrap audio {
    width: 100% !important;
    max-width: 100% !important;
    min-width: 0 !important; 
    display: block;
    box-sizing: border-box;
  }

  .audio-wrap audio::-webkit-media-controls-panel {
    width: 100% !important;
    min-width: 0 !important;
    max-width: 100% !important;
  }
}

</style>
@include('users.phone_verify')

<div class="row">
    <div class="col-12">


        <!-- Settings Info -->
        <div class="card">
            <div class="card-body pb-0">
                <!-- <h4 class="fw-semibold mb-3">Security Settings</h4> -->
                <div class="row">

            
      


         <div class="col-lg-4 col-md-6 d-flex">
  <div class="card flex-fill mb-3 position-relative" style="border: 1px solid #dee2e6 !important;">
    <div class="card-body d-flex flex-column">

      <!-- Update Icon at Top Right -->
         <a href="javascript:void(0)" data-bs-toggle="modal" data-bs-target="#profile_change"
         class="edit-btn" title="Update Personal Info">
        <i class="fa fa-edit"></i>
      </a>

      <!-- Personal Info Section -->
      <div class="d-flex align-items-center mb-3">
        
     
        <div class="profile-pic-wrapper position-relative me-3">
          <?php
            $profilePic = asset('assets/images/user-128x128.png'); 
            if (!empty($userdetails->data->profile_pic) &&
                file_exists(public_path() . '/profile-pic/' . $userdetails->data->profile_pic)) {
              $profilePic = asset('profile-pic/' . $userdetails->data->profile_pic);
            }
          ?>
          <img src="{{ $profilePic }}" alt="Profile" class="profile-img" id="profileImage">

          <!-- Overlay with upload icon -->
          <div class="overlay mb-3" onclick="document.getElementById('fileInput').click();">
            <i class="fa fa-camera fs-5"></i>
          </div>

          <!-- Hidden File Input -->
          <form id="form" action="{{ url('image-update')}}" method="POST" enctype="multipart/form-data">
            @csrf
            <input type="file" name="image" id="fileInput" style="display:none"
              onchange="document.getElementById('form').submit();">
          </form>
        </div>

        <!-- Personal Info Text (RIGHT SIDE) -->
        <div>
          <h6 class="fw-semibold">Personal Info</h6>
          <p>
            Name: {{$userdetails->data->first_name}} <br>
            Email: {{$userdetails->data->email}}
          </p>
        </div>

      </div>
    </div>
  </div>
</div>


                   <div class="col-lg-4 col-md-6 d-flex">
    <div class="card flex-fill mb-3" style="border: 1px solid #dee2e6 !important;">
        <div class="card-body d-flex justify-content-between flex-column">

            <div class="mb-3">
                <div class="d-flex align-items-center justify-content-between mb-1">
                    <h6 class="fw-semibold mb-0">Password</h6>

                    <!-- Change Password Icon -->
                    <a href="javascript:void(0)" data-bs-toggle="modal" data-bs-target="#change_password"
                              class="edit-btn" title="Change Password">
                        <i class="fa fa-edit"></i>
                    </a>
                </div>
                <p class="mb-0">
                    Last Changed:
                    {{ $userdetails->data->password_updated_at
                        ? \App\Helper\Helper::getFormattedDateTimeWithTimezone($userdetails->data->password_updated_at, $userdetails->data->timezone)
                        : 'N/A' }}
                </p>
            </div>

        </div>
    </div>
</div>

                   <div class="col-lg-4 col-md-6 d-flex">
    <div class="card flex-fill mb-3" style="border: 1px solid #dee2e6 !important;">
        <div class="card-body d-flex justify-content-between flex-column">

            <div class="mb-3">
                <div class="d-flex align-items-center justify-content-between mb-1">
                    <h6 class="fw-semibold mb-0">Time Zone</h6>

                    <!-- Update Icon -->
                    <a href="javascript:void(0)" data-bs-toggle="modal" data-bs-target="#update_time"
                        class="edit-btn" title="Update Time Zone">
                        <i class="fa fa-edit"></i>
                    </a>
                </div>

                <p class="mb-0">
                      {{ collect($timezone)->firstwhere('value', $userdetails->data->timezone)['label'] ?? '|(GMT-05:00) Eastern Time (US & Canada)|' }}
                
                </p>
            </div>

        </div>
    </div>
</div>

                    
                    <div class="col-lg-4 col-md-6 d-flex">
                        <div class="card  flex-fill mb-3" style="border: 1px solid #dee2e6 !important;">
                            <div class="card-body d-flex justify-content-between flex-column">
                                <div class="mb-3">
                                    <div class="d-flex align-items-center justify-content-between mb-1">
                                        <h6 class="fw-semibold">Two Factor</h6>

                                        <!-- Custom Toggle -->
                                        <label class="custom-toggle">
                                            <input type="checkbox" id="authToggle1"  @if ($userdetails->data->enable_2fa == 1) checked @endif
                                                onchange="updateTwoFactorStatus({{$userdetails->data->id }}, this.checked, this)">
                                            <span class="slider"></span>
                                        </label>
                                    </div>
                                    <p>Receive codes via SMS or email every time you login</p>
                                </div>

                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 d-flex">
                        <div class="card  flex-fill mb-3">
                            <div class="card-body d-flex justify-content-between flex-column">
                                <div class="mb-3">
                                    <div class="d-flex align-items-center justify-content-between mb-1">
                                        <h6 class="fw-semibold">Google Authenticator</h6>

                                        <!-- Custom Toggle -->
                                  
                                        <label class="custom-toggle">
    <input type="checkbox" id="authToggle" @if ((int) $userdetails->data->allow_google_authenticator === 1) checked @endif
                                                onchange="updateGoogleAuthStatus({{ $userdetails->data->id }}, this.checked, this)">
    <span class="slider"></span>
</label>

                                    </div>
                                    <p>Google Authenticator adds an extra layer of security to
                                        your online accounts by adding a second step of
                                        verification when you sign in.</p>
                                </div>
                                <div>
                                     @if ((int) $userdetails->data->allow_google_authenticator === 1)
                                    <span id="authStatus" class="badge bg-success">Connected</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                                        
                    {{-- phone number  --}}
<div class="col-lg-4 col-md-6 d-flex">
    <div class="card flex-fill mb-3" style="border: 1px solid #dee2e6 !important;">
        <div class="card-body d-flex justify-content-between flex-column">

            <div class="mb-3">
                <div class="d-flex align-items-center justify-content-between mb-1">
                    <h6 class="fw-semibold">Phone Number Verification
                        <i class="ti ti-square-rounded-check-filled text-success ms-1"></i>
                    </h6>

                    <!-- Phone Number Edit/Add Icon -->
                    <a href="javascript:void(0)" data-bs-toggle="modal" data-bs-target="#enterPhoneModal"
                        class="edit-btn" title="{{ $userdetails->data->mobile ? 'Change Phone Number' : 'Add Phone Number' }}">
                           @if($userdetails->data->mobile)
                                <i class="fa fa-edit"></i>
                            @else
                                <i class="fa fa-plus"></i>
                            @endif
                    </a>
                </div>

                @if ($userdetails->data->mobile != null)
                    <p>
                        Mobile Number : 
                        <span class="text-gray-9">

                                 {{ (!empty($userdetails->data->country_code) ? '+' . $userdetails->data->country_code . ' ' : '') }}
                            {{ \App\Helper\Helper::formatPhone($userdetails->data->mobile) ?? 'N/A' }}
                            @if(!empty($userdetails->data->phone_verified_at))
                                <i class="fa fa-check-circle text-success ms-1"></i>
                            @endif

                            <!-- <i class="fa fa-check-circle text-success ms-1"></i> -->
                        </span>
                    </p>
                @else
                    <p>Mobile Number : <span class="text-gray-9">Pending</span></p>
                @endif
            </div>

        </div>
    </div>
</div>

                   <div class="col-lg-4 col-md-6 d-flex">
    <div class="card flex-fill mb-3" style="border: 1px solid #dee2e6 !important;">
        <div class="card-body d-flex justify-content-between flex-column">

            <div class="mb-3">
                <div class="d-flex align-items-center justify-content-between mb-1">
                    <h6 class="fw-semibold">Email Verification
                         @if(!empty($userdetails->data->email_verified_at))
                        <i class="ti ti-square-rounded-check-filled text-success ms-1"></i>
                        @endif
                    </h6>

                    <!-- Change Email Icon -->
                    <a href="javascript:void(0)" data-bs-toggle="modal" data-bs-target="#change_email"
                         class="edit-btn" title="Change Email">
                        <i class="fa fa-edit"></i>
                    </a>
                </div>

                <p class="mb-0">
                    Email :
                    <span>
                        {{ $userdetails->data->email }}
                        <i class="fa fa-check-circle text-success ms-1"></i>
                    </span>
                </p>
            </div>

        </div>
    </div>
</div>

<style>
    audio {
        width: 100% !important;
        min-width: 350px !important; 
        display: block !important;
    }
</style>

                   <div class="col-lg-4 col-md-6 d-flex">
    <div class="card flex-fill mb-3 voicemail-card" style="border: 1px solid #dee2e6 !important;">
        <div class="card-body d-flex flex-column">
            
            <!-- Title + Action Buttons -->
            <div class="d-flex align-items-center justify-content-between mb-2">
                <h6 class="fw-semibold mb-0">Voicemail Drop</h6>
                <div class="d-flex align-items-center">

                
              @if(empty($voicemail)) 
     <a class="add-btn" data-bs-toggle="modal" data-bs-target="#addVoicemailModal" title="Add">
                <i class="fa fa-plus"></i>
            </a>
                 @else

         <a class="edit-btn" data-bs-toggle="modal" data-bs-target="#editVoicemailModal_{{$voicemail[0]->id}}" title="Edit">
    <i class="fa fa-edit"></i>
</a>

        <a class="text-danger delete-btn" data-bs-toggle="modal" data-bs-target="#delete_voicemail_{{$voicemail[0]->id}}" title="Delete">
            <i class="fa fa-trash-o"></i>
        </a>
                    @endif
                </div>
            </div>
            @if(!empty($voicemail)) 
            <p class="mb-3">Extension : {{$userdetails->data->extension}}</p>
            @endif

            {{-- Full-width Audio Players --}}
            @foreach($voicemail as $mail)
                <div class="mb-2 audio-wrap">
                       <audio controls preload="none" class="w-100">
                        <source src="{{env('FILE_UPLOAD_URL')}}{{env('IVR_FILE_UPLOAD_FOLDER_NAME')}}/{{$mail->ivr_id}}.wav" type="audio/wav">
                        Your browser does not support the audio element.
                    </audio>
                </div>

                <!-- Delete Modal -->
                <div class="modal fade" tabindex="-1" aria-labelledby="voicemailModalLabel" id="delete_voicemail_{{$mail->id}}">
                    <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content" style="border-radius: 1rem; padding: 0;">
                            <div class="modal-header">
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <hr class="mx-4" style="border-top: 1.5px solid #aaa; margin-top: 0; margin-bottom: 1rem;">
                            <div class="modal-body px-4 pt-0 pb-4">
                                <div class="text-center">
                                    <div class="avatar avatar-xl bg-danger-light rounded-circle mb-3 d-flex align-items-center justify-content-center mx-auto">
                                        <i class="fa fa-trash fs-36 text-danger"></i>
                                    </div>
                                    <form method="post" action="{{url('deleteVoiceMail')}}">
                                        @csrf
                                    <input type="hidden" name="auto_id" value="{{$userdetails->data->id}}" id="auto_id_voicemail">
                                    <input type="hidden" name="voicemail_id" value="{{$mail->id}}">
                                    <h4 class="mb-2">Remove Voicemail drop?</h4>
                                    <p class="mb-0">
                                        Are you sure you want to remove this voicemail drop?
                                    </p>
                                </div>
                                <div class="d-flex gap-3 pt-2 mt-4">
                                    <button type="button" class="btn btn-light w-75 py-2" data-bs-dismiss="modal"
                                        style="border-radius: 0.6rem;">Close</button>
                                    <button type="submit" class="btn btn-primary w-75 py-2 deleteVoiceMail" style="border-radius: 0.6rem;">
                                        Yes, Delete it
                                    </button>
                                </div>
                            </form>
                            </div>
                        </div>
                    </div>
                </div>


                           <!-- Edit Voicemail Modal -->
<div class="modal custom-modal fade editVoicemailModal" id="editVoicemailModal_{{$mail->id}}" role="dialog">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content" style="border-radius: 1rem; padding: 0;">

            <!-- Modal Header -->
            <div class="modal-header px-4 pt-4 pb-2">
                <h5 class="modal-title fw-semibold">Edit Voice Mail</h5>
                <button class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                    <i class="ti ti-x"></i>
                </button>
            </div>

            <!-- Full-Width Darker Border -->
            <hr class="mx-4" style="border-top: 1.5px solid #aaa; margin-top: 0; margin-bottom: 1rem;">

            <!-- Modal Body -->
            <div class="modal-body px-4 pt-0 pb-4">
                <form method="post" action="{{ url('profile-voice') }}" enctype="multipart/form-data" id="edit_ivr_form">
                    @csrf
                    <input type="hidden" name="id" value="{{isset($mail->id) ? $mail->id : '0'}}">
                    <input type="hidden" name="old_ann_id" value="{{isset($mail->ann_id) ? $mail->ann_id : '0'}}">

                    <!-- Description -->
                    <div class="mb-3">
                        <label class="form-label fw-semibold">Audio File Description</label>
                        <input type="text" class="form-control" name="ivr_desc"
                            value="{{isset($mail->ivr_desc) ? $mail->ivr_desc : ''}}" required>
                    </div>

                    <!-- Radio Options -->
                    <div class="row mb-3">
                        <div class="col-sm-6">
                            <input type="radio"  id="ivr_audio_option_upload_file" name="ivr_audio_option" value="upload"
                                onclick="selectIvrUploadFileOption('upload_file_div');"  {{ (int)$mail->prompt_option === 0 ? 'checked' : '' }}>
                            <label for="ivr_audio_option_upload_file">Upload File</label>
                        </div>
                        <div class="col-sm-6">
                            <input type="radio" id="ivr_audio_option_audio" name="ivr_audio_option" value="text_to_speech"
                                onclick="selectIvrUploadFileOption('text_to_speech_div');"  {{ (int)$mail->prompt_option === 1 ? 'checked' : '' }}>
                            <label for="ivr_audio_option_audio">Convert Text to Audio</label>
                        </div>
                    </div>

                    <!-- Upload File -->
                    <div class="mb-3" id="upload_file_div">
                        <label class="form-label fw-semibold">Upload File
                            <span style="color:red;">* (Only mp3 or wav)</span></label>
                        <input type="file" accept="audio/*" class="form-control" name="ann_id">
                    </div>

                    <!-- Text To Speech -->
                    <div class="mb-3" id="text_to_speech_div" style="display:none;">
                         <div class="row">
                        <div class="col-sm-6">
                            <label class="form-label fw-semibold">Language</label>
                            <select id="language_ddl" name="language" class="form-select"
                                onchange="selectVoiceNameOnLanugageChange();">
                                <option value="">--Select Language--</option>
                                @foreach($arrLang as $key => $val)
                                <option {{isset($mail->language) && $mail->language == base64_decode($key) ? 'selected' : ''}}
                                    value="{{$key}}">{{base64_decode($key)}}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-sm-6">
                            <label class="form-label fw-semibold">Voice Name</label>
                            <select id="voice_name_ddl" name="voice_name" class="form-select">
                                <option value="">--Select Voice Name--</option>
                            </select>
                        </div>
                           </div>
                       
                        <div class="mt-3">
                            <label class="form-label fw-semibold">Text</label>
                            <textarea id="speech_text" class="form-control" name="speech_text"
                                placeholder="Type message here...">{{isset($mail->speech_text) ? $mail->speech_text : ''}}</textarea>
                            <audio  id="test_audio" controls preload="none">
                                <source src="" type="audio/mp3">
                            </audio>
                            <a  class="btn btn-primary mt-2"  onclick="getAudioOnText();">Listen</a>
                        </div>
                    </div>

                                <div class="form-group row" id="record_audio" style="display: none;">
                                    <div class="col-sm-6">
                                        <button type="button" id="record" class="btn"><i class="fa fa-microphone"></i></button>
                                        <button type="button" id="stopRecord" class="btn" disabled><i class="fa fa-stop"></i></button>
                                        <span class="recording-status">Voice recording...</span>
                                        <audio id=recordedAudio></audio>
                                    </div>
                                </div>

                    <!-- Footer Buttons -->
                    <div class="d-flex gap-3 pt-3">
                        <button type="button" class="btn btn-light" data-bs-dismiss="modal">Discard</button>
                        <button type="submit" class="btn btn-primary">Update</button>
                    </div>

                </form>
            </div>

        </div>
    </div>
</div>
            @endforeach
        </div>
    </div>
</div>

<!-- <style>
    #test_audio,
    #test_audio_add {
        display: block;
        margin-top: 10px; 
    }
</style> -->



                    <!-- <div class="col-lg-3 col-md-6 d-flex">
                         <div class="card  flex-fill mb-3" style="border: 1px solid #dee2e6 !important;">
                            <div class="card-body d-flex justify-content-between flex-column">
                                <div class="mb-3">
                                    <div class="d-flex align-items-center justify-content-between mb-1">
                                        <h6 class="fw-semibold">Voicemail Ai </h6>
                                    </div>
                                    <p>Voicemail Ai :{{$userdetails->data->extension}} </p>
                                </div>
                                <div class="d-flex align-items-center">
                               <a href="" class="btn btn-primary openTableBtn" data-target="#voicemailAiCardWrapper">Open</a>
                                </div>
                            </div>
                        </div>
                    </div> -->
                   
                   <!-- Account Activity Card -->
<div class="col-lg-4 col-md-6 d-flex">
    <div class="card flex-fill mb-3" style="border: 1px solid #dee2e6 !important;">
        <div class="card-body d-flex justify-content-between flex-column">

            <div class="mb-3">
                <div class="d-flex align-items-center justify-content-between mb-1">
                    <h6 class="fw-semibold">Account Activity</h6>

                    <!-- View Icon -->
                    <a href="{{ url('user/' . $userdetails->data->id . '/' . $userdetails->data->parent_id . '/user-activity') }}" class="edit-btn" title="View Account Activity">
                        <i class="fa fa-eye"></i>
                    </a>
                </div>
                <!-- <p class="mb-0">Last Changed:</p> -->
            </div>

        </div>
    </div>
</div>

<!-- Dialing Mode Card -->
<div class="col-lg-4 col-md-6 d-flex">
    <div class="card flex-fill mb-3" style="border: 1px solid #dee2e6 !important;">
        <div class="card-body d-flex justify-content-between flex-column">

            <div class="mb-3">
                <div class="d-flex align-items-center justify-content-between mb-1">
                    <h6 class="fw-semibold">Dialing Mode</h6>

                    <!-- Select Mode Icon -->
                    <a href="javascript:void(0)" data-bs-toggle="modal" data-bs-target="#update_mode"
                        class="edit-btn" title="Select Dialing Mode">
            
                        <i class="fa fa-edit"></i>
                    </a>
                </div>
                <p class="mb-0">
    Dialing Mode :
    <span>
        @if($userdetails->data->dialer_mode == 1)
            Desk Phone
        @elseif($userdetails->data->dialer_mode == 2)
            Web Phone
        @elseif($userdetails->data->dialer_mode == 3)
            Mobile App
        @else
            Web phone
        @endif
    </span>
</p>

                <!-- Optional: Add last changed info if needed -->
            </div>

        </div>
    </div>
</div>

                </div>
            </div>
        </div>
        <!-- /Settings Info -->


<!-- Google Auth Modal -->
<div class="modal fade" id="googleAuthModal" role="dialog">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <div class="text-center">
                    <input type="hidden" id="user_id_auth" name="user_id" value="">
                    <h4 class="mb-2">Enable Google Authenticator</h4>
                    <p class="mb-0">Scan the QR code below using the Google Authenticator app.</p>
                    <div id="qr_code_container" class="my-3"></div>
                    <form id="googleAuthForm" action="{{ route('profile.verify-google_otp') }}" method="POST">
                        @csrf
                        <div class="mb-3">
                            <label for="otp" class="form-label">Enter OTP visible on the Authenticator
                                App</label>
                        
                            <div class="d-flex justify-content-between mb-4  mt-3" id="otp">
                                <input type="text"
                                    class="otp-input  form-control border rounded  py-sm-3 py-2 text-center fs-26 hw-bold me-3"
                                    id="digit-1" name="digit1" data-next="digit-2" required maxlength="1"
                                    autofocus>
                                <input type="text"
                                    class="otp-input form-control border rounded  py-sm-3 py-2 text-center fs-26 hw-bold me-3"
                                    id="digit-2" name="digit2" data-next="digit-3" required
                                    data-previous="digit-1" maxlength="1">
                                <input type="text"
                                    class="otp-input form-control border rounded  py-sm-3 py-2 text-center fs-26 hw-bold me-3"
                                    id="digit-3" name="digit3" data-next="digit-4" required
                                    data-previous="digit-2" maxlength="1">
                                <input type="text"
                                    class="otp-input form-control border rounded py-sm-3 py-2 text-center fs-26 hw-bold me-3"
                                    id="digit-4" name="digit4" data-next="digit-5" required
                                    data-previous="digit-3" maxlength="1">
                                <input type="text"
                                    class="otp-input form-control border rounded  py-sm-3 py-2 text-center fs-26 hw-bold me-3"
                                    id="digit-5" name="digit5" data-next="digit-6" required
                                    data-previous="digit-4" maxlength="1">
                                <input type="text"
                                    class="otp-input  form-control border rounded  py-sm-3 py-2 text-center fs-26 hw-bold me-3"
                                    id="digit-6" name="digit6" data-next="digit-7" required
                                    data-previous="digit-5" maxlength="1">
                            </div>
                            <div id="otp-error" class="invalid-feedback"></div>
                        </div>
                        <div class="d-flex align-items-center justify-content-end">
                            <button type="button" class="btn btn-light me-2" data-bs-dismiss="modal">Cancel</button>
                            <button type="submit" class="btn btn-primary">Verify</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>


        <!-- Personal Info -->
        <div class="modal custom-modal fade" id="profile_change" role="dialog">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content" style="border-radius: 1rem; padding: 0;">

                    <!-- Modal Header -->
                    <div class="modal-header px-4 pt-4 pb-2">
                        <h5 class="modal-title fw-semibold">Edit Info</h5>
                        <button class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                            <i class="ti ti-x"></i>
                        </button>
                    </div>

                    <!-- Full-Width Darker Border -->
                    <hr class="mx-4" style="border-top: 1.5px solid #aaa; margin-top: 0; margin-bottom: 1rem;">

                    <!-- Modal Body -->
                    <div class="modal-body px-4 pt-0 pb-4">
                         <form enctype="multipart/form-data" class="form-horizontal" method="post" action="{{url('updateProfile')}}">
                            @csrf
                            <input type="hidden" name="user_id" id="user_id" value="{{$userdetails->data->id}}" />

                            <!-- Name Input -->
                            <div class="mb-4">
                                <label class="form-label fw-semibold">First Name</label>
                                <input type="text" class="form-control"  name="first_name" value="{{$userdetails->data->first_name}}">
                            </div>
                            <div class="mb-4">
                                <label class="form-label fw-semibold">Last Name</label>
                                <input type="text" class="form-control"  name="last_name" value="{{$userdetails->data->last_name}}">
                            </div>
                            <!-- Email-->
                            <div class="mb-4">
                                <label class="form-label fw-semibold">Email</label>
                                <input type="text" class="form-control" value="{{$userdetails->data->email}}" name="email" readonly>
                            </div>
                            <div class="mb-4" style="display: none;">
                                <label class="form-label fw-semibold">Company Name</label>
                                <input type="text" class="form-control" value="{{$userdetails->data->company_name}}" name="company_name" readonly>
                            </div>

                            <!-- Email-->
                            <div class="mb-4" style="display: none;">
                                <label class="form-label fw-semibold">Address </label>
                                <input type="text" class="form-control" value="{{$userdetails->data->address_1}}" name="address" readonly>
                            </div>
                            <div class="mb-4" style="display:none;">
                                <input type="text" class="form-control" name="timezone" value="{{$userdetails->data->timezone}}">
                            </div>

                            <!-- Footer Buttons -->
                            <div class="d-flex gap-3 pt-2">
                                <button type="button" class="btn btn-light w-75 py-2" data-bs-dismiss="modal"
                                    style="border-radius: 0.6rem;">
                                    Close
                                </button>
                                <button type="submit" class="btn btn-primary w-75 py-2" style="border-radius: 0.6rem;">
                                    Update
                                </button>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>

<!-- Verify OTP Modal -->
<div class="modal fade" id="verify_otp" tabindex="-1" role="dialog" aria-labelledby="verifyOtpModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="verifyOtpModalLabel">Verify OTP</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="{{ route('profile.verify-otp') }}" method="POST">
                    @csrf
                    <div class="mb-3">
                        <label for="otp" class="form-label">Enter OTP sent on
                            {{ session('email_change.new_email') }}</label>
                        <input type="text" class="form-control" id="otp" name="otp"
                            placeholder="Enter 6-digit OTP" required pattern="\d{6}">
                        @error('otp')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>
                    <div class="d-flex align-items-center justify-content-end">
                        <button type="button" class="btn btn-light me-2" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary">Verify</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

        <!-- Password-->
        <div class="modal custom-modal fade" id="change_password" role="dialog">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content" style="border-radius: 1rem; padding: 0;">

                    <!-- Modal Header -->
                    <div class="modal-header px-4 pt-4 pb-2">
                        <h5 class="modal-title fw-semibold">Change Password</h5>
                        <button class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                            <i class="ti ti-x"></i>
                        </button>
                    </div>

                    <!-- Full-Width Darker Border -->
                    <hr class="mx-4" style="border-top: 1.5px solid #aaa; margin-top: 0; margin-bottom: 1rem;">

                    <!-- Modal Body -->
                    <div class="modal-body px-4 pt-0 pb-4">
                            <form method="post" action="{{(url('/profile'))}}">
                                @csrf
                                   <input type="hidden" name="user_id" value="{{$userdetails->data->id}}">
                                    <input type="hidden" name="tab" value="active">

                            <div class="mb-4">
                                <label class="form-label fw-semibold">Old Password<span
                                        class="text-danger">*</span></label>
                                <div class="pass-group">
                                    <input type="password" class="pass-input form-control" name="old_password" required>
                                    <span
                                        class="ti toggle-password ti-eye-off position-absolute end-0 top-50 translate-middle-y me-1"></span>
                                </div>
                            </div>
                            <!-- New Password-->
                            <div class="mb-4">
                                <label class="form-label fw-semibold">New Password<span
                                        class="text-danger">*</span></label>
                                <div class="pass-group">
                                    <input type="password" class="pass-input form-control" name="password"
                                        required>
                                    <span
                                        class="ti toggle-password ti-eye-off position-absolute end-0 top-50 translate-middle-y me-1"></span>
                                </div>
                            </div>

                            <!-- Email-->
                            <div class="mb-4">
                                <label class="form-label fw-semibold">Confirm Password<span
                                        class="text-danger">*</span></label>
                                <div class="pass-group">
                                    <input type="password"name="password_confirmation" class="pass-input form-control" name="confirm_password"
                                        required>
                                    <span
                                        class="ti toggle-password ti-eye-off position-absolute end-0 top-50 translate-middle-y me-1"></span>
                                </div>
                            </div>


                            <!-- Footer Buttons -->
                            <div class="d-flex gap-3 pt-2">
                                <button type="button" class="btn btn-light w-75 py-2" data-bs-dismiss="modal"
                                    style="border-radius: 0.6rem;">
                                    Close
                                </button>
                                <button type="submit" class="btn btn-primary w-75 py-2" style="border-radius: 0.6rem;">
                                    Update
                                </button>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>



        <!-- Time Zone-->
        <div class="modal custom-modal fade" id="update_time" role="dialog">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content" style="border-radius: 1rem; padding: 0;">

                    <!-- Modal Header -->
                    <div class="modal-header px-4 pt-4 pb-2">
                        <h5 class="modal-title fw-semibold">Edit Time Zone</h5>
                        <button class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                            <i class="ti ti-x"></i>
                        </button>
                    </div>

                    <!-- Full-Width Darker Border -->
                    <hr class="mx-4" style="border-top: 1.5px solid #aaa; margin-top: 0; margin-bottom: 1rem;">
   
                    <!-- Modal Body -->
                    <div class="modal-body px-4 pt-0 pb-4">
                            <form  method="post" action="{{url('updateProfile')}}">
                            @csrf
                            <input type="hidden" name="user_id"  value="{{$userdetails->data->id}}" />
  <div class="mb-4" style="display:none;">
                                <label class="form-label fw-semibold">First Name</label>
                                <input type="text" class="form-control"  name="first_name" value="{{$userdetails->data->first_name}}">
                            </div>
                            <div class="mb-4" style="display:none;">
                                <label class="form-label fw-semibold">Email</label>
                                <input type="text" class="form-control"  name="email" value="{{$userdetails->data->email}}">
                            </div>
                            <!-- Time Zone-->
                            <div class="mb-4">
                                <label class="form-label fw-semibold">Time Zone</label>
                              <select class="form-control" name="timezone" required>
                         
                                <option value="">Select timezone</option>
                                        @foreach ($timezone as $tz)
                                            <option value="{{ $tz['value'] }}"
                                                {{$userdetails->data->timezone == $tz['value'] ? 'selected' : '' }}>
                                                {{ $tz['label'] }}
                                            </option>
                                        @endforeach

                                    <!-- <option @if($userdetails->data->timezone == 'Etc/GMT-12') selected @endif value="Etc/GMT-12">(GMT+12:00) Fiji, Kamchatka, Marshall Is.</option>

                                    <option @if($userdetails->data->timezone == 'Pacific/Chatham') selected @endif value="Pacific/Chatham">(GMT+12:45) Chatham Islands</option>

                                    <option @if($userdetails->data->timezone == 'Pacific/Tongatapu') selected @endif value="Pacific/Tongatapu">(GMT+13:00) Nuku'alofa</option>

                                    <option @if($userdetails->data->timezone == 'Pacific/Kiritimati') selected @endif value="Pacific/Kiritimati">(GMT+14:00) Kiritimati</option> -->

                                   </select>
                            </div>



                            <!-- Footer Buttons -->
                            <div class="d-flex gap-3 pt-2">
                                <button type="button" class="btn btn-light w-75 py-2" data-bs-dismiss="modal"
                                    style="border-radius: 0.6rem;">
                                    Close
                                </button>
                                <button type="submit" class="btn btn-primary w-75 py-2" style="border-radius: 0.6rem;">
                                    Update
                                </button>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>





        <!-- Dialing Mode-->
        <div class="modal custom-modal fade" id="update_mode" role="dialog">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content" style="border-radius: 1rem; padding: 0;">

                    <!-- Modal Header -->
                    <div class="modal-header px-4 pt-4 pb-2">
                        <h5 class="modal-title fw-semibold">Dialing Option</h5>
                        <button class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                            <i class="ti ti-x"></i>
                        </button>
                    </div>

                    <!-- Full-Width Darker Border -->
                    <hr class="mx-4" style="border-top: 1.5px solid #aaa; margin-top: 0; margin-bottom: 1rem;">

                    <!-- Modal Body -->
                    <div class="modal-body px-4 pt-0 pb-4">
                        <form method="post" action="{{ url('/update/dialer-mode') }}">
                        @csrf
                            <!-- Time Zone-->
                            <div class="mb-4">
                                <label class="form-label fw-semibold">Select Mode</label>
                                    <select name="dialer_mode"  class="form-select" required="" id="dialer_mode">
                                               <option @if($userdetails->data->dialer_mode == '1') selected @endif value="1">Desk Phone</option>    
                                                <option @if($userdetails->data->dialer_mode == '2') selected @endif value="2">Web Phone</option>    
                                                <option @if($userdetails->data->dialer_mode == '3') selected @endif value="3">Mobile App</option>  
                                            </select>
                            </div>



                            <!-- Footer Buttons -->
                            <div class="d-flex gap-3 pt-2">
                                <button type="button" class="btn btn-light w-75 py-2" data-bs-dismiss="modal"
                                    style="border-radius: 0.6rem;">
                                    Close
                                </button>
                                <button type="submit" class="btn btn-primary w-75 py-2" style="border-radius: 0.6rem;">
                                    Update
                                </button>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>



     


        <!-- Email-->
        <div class="modal custom-modal fade" id="change_email" role="dialog">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content" style="border-radius: 1rem; padding: 0;">

                    <!-- Modal Header -->
                    <div class="modal-header px-4 pt-4 pb-2">
                        <h5 class="modal-title fw-semibold">Change Email Address</h5>
                        <button class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                            <i class="ti ti-x"></i>
                        </button>
                    </div>

                    <!-- Full-Width Darker Border -->
                    <hr class="mx-4" style="border-top: 1.5px solid #aaa; margin-top: 0; margin-bottom: 1rem;">

                    <!-- Modal Body -->
                    <div class="modal-body px-4 pt-0 pb-4">
                          <form action="{{ route('profile.change-email') }}" method="POST" id="changeEmailForm">
                    @csrf

                            <!-- Time Zone-->
                            <div class="mb-4">
                                
                                    <label for="new_email" class="form-label  fw-semibold">New Email Address</label>
                                    <input type="email" class="form-control" id="new_email" name="new_email"
                                        placeholder="Enter new email" required>
                                @error('new_email')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>



                            <!-- Footer Buttons -->
                            <div class="d-flex gap-3 pt-2">
                                <button type="button" class="btn btn-light w-75 py-2" data-bs-dismiss="modal"
                                    style="border-radius: 0.6rem;">
                                    Close
                                </button>
                                <button type="submit" class="btn btn-primary w-75 py-2" style="border-radius: 0.6rem;">
                                    Send OTP
                                </button>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>



        <!-- Delete Admin -->
        <div class="modal custom-modal fade" id="deactive_account" role="dialog">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content" style="border-radius: 1rem; padding: 0;">


                    <hr class="mx-4" style="border-top: 1.5px solid #aaa; margin-top: 0; margin-bottom: 1rem;">
                    <div class="modal-body px-4 pt-0 pb-4">
                        <form action="#">

                            <div class="text-center">

                                <div class="avatar avatar-xl bg-danger-light rounded-circle mb-3">
                                    <i class="ti ti-trash-x fs-36 text-danger"></i>
                                </div>
                                <h4 class="mb-2">Remove your Account?</h4>
                                <p class="mb-0">
                                    Are you sure you want to remove your Account. <br />

                                </p>
                            </div>

                            <!-- Footer Buttons -->
                            <div class="d-flex gap-3 pt-2 mt-4">
                                <button type="button" class="btn btn-light w-75 py-2" data-bs-dismiss="modal"
                                    style="border-radius: 0.6rem;">
                                    Close
                                </button>
                                <button type="submit" class="btn btn-primary w-75 py-2" style="border-radius: 0.6rem;">
                                    Yes, Delete it
                                </button>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- /Delete Admin -->

        <!-- Update Voicemail Drop Modal -->
        <!-- <div class="modal fade" id="update_voicemail_drop" tabindex="-1" aria-labelledby="voicemailModalLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-lg modal-dialog-centered"> -->

<style>
.editVoicemailModal .modal-dialog {
    max-width: 600px;   
    margin: auto;
}

.editVoicemailModal .modal-content {
    border-radius: 1rem;
}


.editVoicemailModal .modal-body .d-flex button {
    width: 50% !important;
    border-radius: 0.6rem;
}

</style>


<style>
#addVoicemailModal .modal-dialog {
    max-width: 600px;   
    margin: auto;
}

#addVoicemailModal .modal-content {
    border-radius: 1rem;
}


#addVoicemailModal .modal-body .d-flex button {
    width: 50% !important;
    border-radius: 0.6rem;
}

</style>

 
<!-- Add Voicemail Modal -->
<div class="modal custom-modal fade" id="addVoicemailModal" role="dialog">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content" style="border-radius: 1rem; padding: 0;">

            <!-- Modal Header -->
            <div class="modal-header px-4 pt-4 pb-2">
                <h5 class="modal-title fw-semibold">Add Voice Mail</h5>
                <button class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                    <i class="ti ti-x"></i>
                </button>
            </div>

            <!-- Full-Width Darker Border -->
            <hr class="mx-4" style="border-top: 1.5px solid #aaa; margin-top: 0; margin-bottom: 1rem;">

            <!-- Modal Body -->
            <div class="modal-body px-4 pt-0 pb-4">
            <form method="post" action="{{ route('voice.mail.post') }}" class="add_ivr_form" id="add_ivr_form">
                @csrf
                <!-- Description -->
                <div class="mb-3">
                    <label class="form-label fw-semibold">Audio File Description</label>
                    <input type="text" class="form-control" placeholder="Enter description" name="ivr_desc">
                </div>

                <!-- Radio Options -->
                <div class="row mb-3">
                    <div class="col-sm-6">
                    <input type="radio"  checked id="audio_option_upload_file_add" name="ivr_audio_option" value="upload"
       onclick="selectIvrUploadFileOptionAdd('upload_file_div');">
                        <label for="audio_option_upload_file_add">Upload File</label>
                    </div>
                    <div class="col-sm-6">
                     <input type="radio" id="audio_option_audio_add" 
      name="ivr_audio_option" value="text_to_speech"
       onclick="selectIvrUploadFileOptionAdd('text_to_speech_div');">
                        <label for="audio_option_audio_add">Convert Text to Audio</label>
                    </div>
                </div>

                <!-- Upload File -->
                <div class="mb-3" id="upload_file_div_add">
                    <label class="form-label fw-semibold">Upload File
                        <span style="color:red;">* (Only mp3 or wav)</span></label>
                    <input type="file" accept="audio/*" class="form-control" name="ann_id">
                </div>

              
                <!-- Text To Speech -->
<div class="mb-3" id="text_to_speech_div_add" style="display:none;">
    <div class="row">
        <div class="col-sm-6">
            <label class="form-label fw-semibold">Language</label>
          <select id="add_language_ddl" class="form-select" onchange="selectVoiceNameOnLanugageChangeAdd();" name="language">
                <option value="">--Select Language--</option>
                     @foreach($arrLang as $key => $val)
                                <option value="{{$key}}">{{base64_decode($key)}}</option>
                                @endforeach
                <!-- dynamic options -->
            </select>
        </div>
        <div class="col-sm-6">
            <label class="form-label fw-semibold">Voice Name</label>
            <select id="add_voice_name_ddl" class="form-select" name="voice_name">
                <option value="">--Select Voice Name--</option>
            </select>
        </div>
    </div>

    <div class="mt-3">
        <label class="form-label fw-semibold">Text</label>
        <textarea id="speech_text_add" class="form-control" placeholder="Type message here..." name="speech_text"></textarea>
        <audio  id="test_audio_add" controls preload="none">
            <source src="" type="audio/mp3">
        </audio>
        <a   class="btn btn-primary mt-2"  onclick="getAudioOnTextAdd();">Listen</a>
    </div>
</div>


                <!-- Record Audio -->
                <div class="form-group row" id="record_audio_add" style="display: none;">
                    <div class="col-sm-6">
                        <button type="button" id="recordAdd" class="btn"><i class="fa fa-microphone"></i></button>
                        <button type="button" id="stopRecordAdd" class="btn" disabled><i class="fa fa-stop"></i></button>
                        <span class="recording-status">Voice recording...</span>
                        <audio id="recordedAudioAdd"></audio>
                    </div>
                </div>

                <!-- Footer Buttons -->
                <div class="d-flex gap-3 pt-3">
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">Discard</button>
                    <button type="submit" class="btn btn-primary">Save</button>
                </div>
            </form>
            </div>

        </div>
    </div>
</div>







<div id="voicemailAiCardWrapper" style="display:none;"> 
            <div class="row">
                 <div class="col-12">
                <!-- modal-lg for wide modal -->
                   <div class="card">
                    <div class="card-header">
                    <h5 class="card-title" id="voicemailAiLabel">Voicemail Ai Details</h5>
                  <button type="button" class="btn-close closeTableBtn" data-target="#voicemailAiCardWrapper"></button>
                    </div>
                         
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <thead class="table-light">
                                    <tr>
                                        <th>#</th>
                                        <th>Extension</th>
                                        <th>File Name</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                        @foreach($voice_ai as $mail)
                                    <tr>
                                        <td>1</td>
                                        <td>{{$userdetails->data->extension}}</td>
                                      <td>
                                        <audio controls preload ='none'><source src="{{env('FILE_UPLOAD_URL')}}voice_ai_users/{{Session::get('extension')}}.wav" type='audio/wav'></audio>
                                        </td> 

                                        <td> 
                                            <a href="/profile/edit-voiceai/{{$mail->id}}" style="cursor:pointer;color:blue;"  ><i class="fa fa-edit fa-lg"></i></a> 
                                            <!-- <a style="cursor:pointer;color:red;"id="voiceaiDelete" class='voiceaiDelete' data-voicemailid = "{{$mail->id}}" data-id="{{$userdetails->data->id}}" ><i class="fa fa-trash-o fa-lg"></i></a> -->
                                             <a class="text-danger"  data-bs-toggle="modal"
                                        data-bs-target="#delete_voiceai_{{$mail->id}}"><i class="fa fa-trash-o "></i></a>
                                        </td>
                                        
                                    </tr>
                                       <!-- Delete Voiceai -->
        <div  class="modal fade"  tabindex="-1" aria-labelledby="voicemailModalLabel" id="delete_voiceai_{{$mail->id}}">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content" style="border-radius: 1rem; padding: 0;">

    <div class="modal-header">
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <hr class="mx-4" style="border-top: 1.5px solid #aaa; margin-top: 0; margin-bottom: 1rem;">
                    <div class="modal-body px-4 pt-0 pb-4">
                        <!-- <form action="#"> -->

                    <div class="text-center">
     <div class="avatar avatar-xl bg-danger-light rounded-circle mb-3 d-flex align-items-center justify-content-center mx-auto">
      <i class="fa fa-trash fs-36 text-danger"></i>
    </div>



                                   <input type="hidden" class="form-control" name="auto_id" value="{{$userdetails->data->id}}" id="auto_id_voiceai">
                                   <input type="hidden" class="form-control" name="voicemail_id" value="{{$mail->id}}" id="voicemail_id">
    
                                <h4 class="mb-2">Remove Voiceai?</h4>
                                <p class="mb-0">
                                    Are you sure you want to remove voiceai.. <br />

                                </p>
                            </div>

                            <!-- Footer Buttons -->
                            <div class="d-flex gap-3 pt-2 mt-4">
                                <button type="button" class="btn btn-light w-75 py-2" data-bs-dismiss="modal"
                                    style="border-radius: 0.6rem;">
                                    Close
                                </button>
                                <button type="submit" class="btn btn-primary w-75 py-2 deleteVoiceAi" style="border-radius: 0.6rem;">
                                    Yes, Delete it
                                </button>
                            </div>

                        <!-- </form> -->
                    </div>
                </div>
            </div>
        </div>
        <!-- /Delete Voiceai -->
                                    @endforeach

                                
                                </tbody>
                            </table>
                        </div>
                    </div>
                        </form>
                </div>
              
            </div>
        </div>
 

    </div>

<!-- /Page Wrapper -->
<script>
    document.addEventListener('DOMContentLoaded', function() {
        let modalType = "{{ session('modal') }}";
        if (modalType === 'verify_otp') {
            new bootstrap.Modal(document.getElementById('verify_otp')).show();
        } else if (modalType === 'change_email') {
            new bootstrap.Modal(document.getElementById('change_email')).show();
        }
    });
</script>

</script>
<script>
    // Listen when user selects a file
    document.getElementById('fileInput').addEventListener('change', function () {
        if (this.files.length > 0) {
            document.getElementById('form').submit();
        }
    });
</script>
<script>
document.addEventListener("DOMContentLoaded", function() {
    const toggleIcons = document.querySelectorAll(".toggle-password");

    toggleIcons.forEach(function(icon) {
        icon.addEventListener("click", function() {
            const input = this.previousElementSibling;
            const isPassword = input.type === "password";
            input.type = isPassword ? "text" : "password";
            this.classList.toggle("ti-eye");
            this.classList.toggle("ti-eye-off");
        });
    });
});

function toggleAuth() {
    const toggle = document.getElementById('authToggle');
    const badge = document.getElementById('authStatus');

    if (toggle.checked) {
        badge.classList.remove('bg-danger');
        badge.classList.add('bg-success');
        badge.textContent = 'Connected';
    } else {
        badge.classList.remove('bg-success');
        badge.classList.add('bg-danger');
        badge.textContent = 'Disconnected';
    }
}

function toggleAuth1() {
    const toggle = document.getElementById('authToggle1');


    if (toggle.checked) {
        badge.classList.remove('bg-danger');
        badge.classList.add('bg-success');

    } else {
        badge.classList.remove('bg-success');
        badge.classList.add('bg-danger');

    }
}

document.getElementById("fileInput").addEventListener("change", function(e) {
    const file = e.target.files[0];
    if (file && file.type.startsWith("image/")) {
        const reader = new FileReader();
        reader.onload = function(event) {
            document.getElementById("profileImage").src = event.target.result;
        };
        reader.readAsDataURL(file);
    }
});



</script>

<!-- <script>
    $(document).on("click", ".deleteVoiceMail", function () {
        var auto_id = $("#auto_id_voicemail").val();
        var voicemail_id = $("#voicemail_id").val();
       //alert(auto_id);
        //var el = this;
        $.ajax({
            url: 'deleteVoiceMail/' + auto_id+'/'+voicemail_id,
            type: 'get',
            success: function (response) {
                console.log(response);
                toastr.success('VoiceMail deleted successfully')
                window.location.reload(1);
            }
        });
    });
</script> -->

<script>
function updateGoogleAuthStatus(userId, status, toggleElement) {
    if (!userId || typeof userId !== 'number') {
        console.error('Invalid or missing user ID:', userId);
        showBootstrapToast("danger", "Invalid user ID provided.", "Error");
        return;
    }

    // Temporarily revert toggle until success confirmed
    toggleElement.checked = !status;

    let allow_google_authenticator_status = status ? 1 : 0;

    // Send AJAX request to frontend controller
    $.ajax({
        url: '/profile/update-google-auth',
        method: 'POST',
        data: {
            allow_google_authenticator: allow_google_authenticator_status,
            _token: '{{ csrf_token() }}'
        },
        success: function(response) {
            if (response.success) {
                if (response.show === 1) {
                    // Need to show QR + OTP modal
                    const userIdInput = document.getElementById('user_id_auth');
                    const qrCodeContainer = document.getElementById('qr_code_container');

                    if (userIdInput && qrCodeContainer) {
                        userIdInput.value = userId;
                        qrCodeContainer.innerHTML = response.qr_code 
                        
                    

                    } else {
                        console.error('Modal elements not found');
                        toastr.error( "Unable to display verification modal.");
                        return;
                    }

                    const modalElement = document.getElementById('googleAuthModal');
                    if (!modalElement) {
                        console.error('Google Auth modal not found');
                        toastr.error("Unable to display verification modal.");
                        return;
                    }

                    const modal = new bootstrap.Modal(modalElement);
                    modal.show();

                    // Handle OTP form submit
                    $('#googleAuthForm').off('submit').on('submit', function(e) {
                        e.preventDefault();
                        $('#otp').removeClass('is-invalid');
                        $('#otp-error').text('');

                        const formData = $(this).serialize();
                        $.ajax({
                            url: '{{ route('profile.verify-google_otp') }}',
                            method: 'POST',
                            data: formData,
                            success: function(response) {
                                if (response.success) {
                                    toggleElement.checked = status;
                                    modal.hide();
                                    toastr.success(response.message);

                                    const badgeContainer = document.getElementById('authStatus');
                                    if (badgeContainer) {
                                        badgeContainer.innerHTML =
                                            '<span class="badge bg-success>Connected</span>';
                                    }
                                } else {
                                    $('#otp').addClass('is-invalid');
                                    $('#otp-error').text(response.message || 'Invalid OTP. Please try again.');
                                }
                            },
                            error: function() {
                                $('#otp').addClass('is-invalid');
                                $('#otp-error').text('Invalid OTP. Please try again.');
                            }
                        });
                    });

                } else {
                    // Just enable/disable without modal
                    toggleElement.checked = status;
                    toastr.success(response.message);

                    const badgeContainer = document.getElementById('connectedBadge');
                    if (badgeContainer) {
                        badgeContainer.innerHTML = status
                            ? '<span class="badge badge-soft-success">Connected</span>'
                            : '';
                    }
                }
            } else {
                 toastr.error( response.message || "Failed to update Google Auth status.");
            }
        },
  error: function(xhr) {
    console.error('AJAX error:', xhr.responseText);

    let errorMessage = "Invalid Otp Please try again later.";

    // If backend sent a JSON response with a message, show it
    if (xhr.responseJSON && xhr.responseJSON.message) {
        errorMessage = xhr.responseJSON.message;
    }

    toastr.error(errorMessage, "Error");
}

    });
}

</script>
<script>document.querySelectorAll('.otp-input').forEach((input, index, inputs) => {
    input.addEventListener('input', function () {
        if (this.value.length === 1 && index < inputs.length - 1) {
            inputs[index + 1].focus();
        }
    });

    input.addEventListener('keydown', function (e) {
        if (e.key === "Backspace" && !this.value && index > 0) {
            inputs[index - 1].focus();
        }
    });
});
</script>
<script>  
function updateTwoFactorStatus(userId, status, checkboxElement)
 {
        const originalState = checkboxElement.checked;
        checkboxElement.disabled = true;
        let allow_two_factor_status = status ? 1 : 0;

        $.ajax({
            url: '/profile/update-two-factor',
            method: 'POST',
            data: {
                id: userId,
                allow_two_factor_status: allow_two_factor_status,
                _token: $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                if (response.success) {
                    toastr.success(response.message);
                } else {
                    checkboxElement.checked = !status;
                    toastr.error(response.message);
                }
                if (response.modal == 'show') {
                    const enterPhoneModal = new bootstrap.Modal(document.getElementById('enterPhoneModal'));
                    enterPhoneModal.show();
                }
            },
          error: function(xhr) {
        checkboxElement.checked = !status;
        console.error('AJAX error:', xhr);

        // ✅ read JSON properly
        if (xhr.responseJSON && xhr.responseJSON.message) {
            toastr.error(xhr.responseJSON.message);
        } else {
            toastr.error('Unexpected error occurred.');
        }
    },
            complete: function() {
                checkboxElement.disabled = false;
            }
        });
    }
</script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const wrappers = ['#voicemailCardWrapper', '#voicemailAiCardWrapper'];

    document.querySelectorAll('.openTableBtn').forEach(btn => {
        btn.addEventListener('click', function(e) {
            e.preventDefault(); 

            const targetId = btn.getAttribute('data-target');
            const target = document.querySelector(targetId);

           
            wrappers.forEach(id => {
                const el = document.querySelector(id);
                if (el) el.style.display = "none";
            });

          
            if (target) target.style.display = "block";
        });
    });

    document.querySelectorAll('.closeTableBtn').forEach(btn => {
        btn.addEventListener('click', function(e) {
            e.preventDefault(); 

            const targetId = btn.getAttribute('data-target');
            const target = document.querySelector(targetId);
            if (target) target.style.display = "none";
        });
    });
});
</script>



<!-- Edit-Voicemail Scripts -->

<script>
    var isLocal = @json(app()->isLocal());
</script>

<script>
    document.addEventListener("DOMContentLoaded", function () {
        // Run the function based on the pre-checked radio button
        var selected = document.querySelector('input[name="ivr_audio_option"]:checked');
        if (selected) {
            if (selected.value === "upload") {
                selectIvrUploadFileOption('upload_file_div');
            } else if (selected.value === "text_to_speech") {
                selectIvrUploadFileOption('text_to_speech_div');
            }
        }
    });
</script>
<script>

$(document).ready(function () {
    setTimeout(function() {
        selectVoiceNameOnLanugageChange();
    }, 1000);
    // if (!isLocal) {
    // $("#edit_ivr_form").submit(function () {
    //     if ($("#ivr_audio_option_audio").prop("checked") && !$("#test_audio").attr("src")) {
    //         toastr.info("Please listen to the audio before submitting");
    //         return false;
    //     }
    // });
    // }
    // var prompt_option = @if(isset($ivr_data->prompt_option)) @php echo $ivr_data->prompt_option @endphp @else"0"@endif;
    // var voice_name = "@if(isset($ivr_data->voice_name))@php echo $ivr_data->voice_name @endphp@else 0 @endif";

    // if(prompt_option == 2){
    //     $("#ivr_audio_option_audio_record").prop("checked", true);
    //     $("#upload_file_div").hide();
    //     $("#text_to_speech_div").hide();
    //     $("#record_audio").show();
    // } else if(prompt_option == 1){
    //     $("#ivr_audio_option_audio").prop("checked", true);
    //     $("#upload_file_div").hide();
    //     $("#record_audio").hide();
    //     $("#text_to_speech_div").show();

    //     setTimeout(function() {
    //         selectVoiceNameOnLanugageChange(voice_name);
    //     }, 2000);
    // } else{
    //     $("#ivr_audio_option_upload_file").prop("checked", true);
    //     $("#record_audio").hide();
    //     $("#upload_file_div").show();
    //     $("#text_to_speech_div").hide();
    // }


// Add Modal
     setTimeout(function() {
        selectAddVoiceNameOnLanugageChange();
    }, 1000);

   //if (!isLocal) {
    // $("#edit_ivr_form").submit(function () {
    //     if ($("#ivr_audio_option_audio").prop("checked") && !$("#test_audio").attr("src")) {
    //         toastr.info("Please listen to the audio before submitting");
    //         return false;
    //     }
    // });
    //}
    //var prompt_option = @if(isset($ivr_data->prompt_option)) @php echo $ivr_data->prompt_option @endphp @else"0"@endif;
    //var voice_name = "@if(isset($ivr_data->voice_name))@php echo $ivr_data->voice_name @endphp@else 0 @endif";

    // if(prompt_option == 2){
    //     $("#ivr_audio_option_audio_record").prop("checked", true);
    //     $("#upload_file_div").hide();
    //     $("#text_to_speech_div").hide();
    //     $("#record_audio").show();
    // } else if(prompt_option == 1){
    //     $("#ivr_audio_option_audio").prop("checked", true);
    //     $("#upload_file_div").hide();
    //     $("#record_audio").hide();
    //     $("#text_to_speech_div").show();

    //     setTimeout(function() {
    //         selectVoiceNameOnLanugageChange(voice_name);
    //     }, 2000);
    // } else{
    //     $("#ivr_audio_option_upload_file").prop("checked", true);
    //     $("#record_audio").hide();
    //     $("#upload_file_div").show();
    //     $("#text_to_speech_div").hide();
    // }


});



function selectIvrUploadFileOption(option) {
    if (option == 'text_to_speech_div') {
        $("#text_to_speech_div").show();
        $("#upload_file_div").hide();
        $("#record_audio").hide();
    } else if(option == 'audio_record') {
        getAudioRecordPermission();
        $("#record_audio").show();
        $("#upload_file_div").hide();
        $("#text_to_speech_div").hide();
    } else {
        $("#upload_file_div").show();
        $("#text_to_speech_div").hide();
        $("#record_audio").hide();
    }
}

function selectVoiceNameOnLanugageChange(defaultSelected = null) {
    $.ajax({
        url: '/get-voice-name-on-lanugage',
        type: 'post',
        data: {'language': $('#language_ddl').val(),
            "_token": "{{ csrf_token() }}" },
        success: function (response) {
            var html = '';
            $.each(response, function (index, value) {
                var optionValue = value.language_code + " ## " + value.voice_name + " ## " + value.ssml_gender;
                html += '<option value="'+ optionValue +'" ';
                html += (defaultSelected == optionValue) ? 'selected >' : '>';
                html += optionValue + '</option>';
            });
            $("#voice_name_ddl").html('');
            $("#voice_name_ddl").html(html);
        }
    });

}

function getAudioOnText() {
    if ($('#speech_text').val() == '') {
        toastr.error("Please Type Text");
        return;
    }
    if ($('#language_ddl').val() == '') {
        toastr.error("Please Select Language");
        return;
    }
    if ($('#voice_name_ddl').val() == '' || $('#voice_name_ddl').val() == null) {
        toastr.error("Please Select Voice Name");
        return;
    }

    $("#test_audio").attr('src', "");
    $.ajax({
        url: '/get-audio-on-text',
        type: 'post',
        data: {'language': $('#language_ddl').val(),
            'voice_name_ddl': $('#voice_name_ddl').val(),
            'speech_text': $('#speech_text').val(),
            "_token": "{{ csrf_token() }}"},
        success: function (response) {
               //alert(JSON.stringify(response));
           if (typeof (response.file) != 'undefined') {
        var file = "{{ env('FILE_UPLOAD_URL') }}" + "{{ env('IVR_FILE_UPLOAD_FOLDER_NAME') }}" + "/" + response.file;
        var d = new Date();
        var finalUrl = file + "?" + d.getTime();

        // Update both <audio> and <source>
        $("#test_audio").attr('src', finalUrl);
        $("#test_audio source").attr('src', finalUrl);

        var x = document.getElementById("test_audio");
        x.load();  // reload after updating source
        x.play();  // then play
    }
        }
    });
}

function getAudioRecordPermission(){
    navigator.mediaDevices.getUserMedia({audio:true})
        .then(stream => {handlerFunction(stream)});
}

function handlerFunction(stream) {
    rec = new MediaRecorder(stream);
    rec.ondataavailable = e => {
        audioChunks.push(e.data);
        if (rec.state == "inactive"){
            let blob = new Blob(audioChunks,{type:'audio/wav'});
            recordedAudio.src = URL.createObjectURL(blob);
            recordedAudio.controls=true;
            recordedAudio.autoplay=true;
            sendData(blob)
        }
    }
}

function sendData(data) {
    var fd = new FormData();
    fd.append('data', data);

    $.ajax({
        url: '/save-recorded-audio',
        type: 'POST',
        data: fd,
        processData: false,
        contentType: false,
        success: function (response){
            // console.log(response);
        },
        error: function (response) {
            console.log(response);
        }
    });
}

record.onclick = e => {
    record.disabled = true;
    $(".recording-status").show();
    stopRecord.disabled=false;
    audioChunks = [];
    rec.start();
}
stopRecord.onclick = e => {
    record.disabled = false;
    stop.disabled=true;
    $(".recording-status").hide();
    rec.stop();
}
</script>


<script>
    $(document).ready(function () {
    setTimeout(function() {
        selectVoiceNameOnLanugageChangeAdd();
    }, 1000);
    // if (!isLocal) {
    // $("#add_ivr_form").submit(function () {
    //     if ($("#ivr_audio_option_audio_add").prop("checked") && !$("#test_audio_add").attr("src")) {
    //         toastr.info("Please listen to the audio before submitting");
    //         return false;
    //     }
    // });
    // }

});



function selectIvrUploadFileOptionAdd(option) {
    if (option == 'text_to_speech_div') {
        $("#text_to_speech_div_add").show();
        $("#upload_file_div_add").hide();
        $("#record_audio_add").hide();
    } else if(option == 'audio_record') {
        getAudioRecordPermissionAdd();
        $("#record_audio_add").show();
        $("#upload_file_div_add").hide();
        $("#text_to_speech_div_add").hide();
    } else {
        $("#upload_file_div_add").show();
        $("#text_to_speech_div_add").hide();
        $("#record_audio_add").hide();
    }
}

function selectVoiceNameOnLanugageChangeAdd(defaultSelected = null) {
    $.ajax({
        url: '/get-voice-name-on-lanugage',
        type: 'post',
        data: {'language': $('#add_language_ddl').val(),
            "_token": "{{ csrf_token() }}" },
        success: function (response) {
            var html = '';
            $.each(response, function (index, value) {
                var optionValue = value.language_code + " ## " + value.voice_name + " ## " + value.ssml_gender;
                html += '<option value="'+ optionValue +'" ';
                html += (defaultSelected == optionValue) ? 'selected >' : '>';
                html += optionValue + '</option>';
            });
            $("#add_voice_name_ddl").html('');
            $("#add_voice_name_ddl").html(html);
        }
    });

}

function getAudioOnTextAdd() {
    if ($('#speech_text_add').val() == '') {
        toastr.error("Please Type Text");
        return;
    }
    if ($('#add_language_ddl').val() == '') {
        toastr.error("Please Select Language");
        return;
    }
    if ($('#add_voice_name_ddl').val() == '' || $('#add_voice_name_ddl').val() == null) {
        toastr.error("Please Select Voice Name");
        return;
    }

    $("#test_audio_add").attr('src', "");
    $.ajax({
        url: '/get-audio-on-text',
        type: 'post',
        data: {'language': $('#add_language_ddl').val(),
            'voice_name_ddl': $('#add_voice_name_ddl').val(),
            'speech_text': $('#speech_text_add').val(),
            "_token": "{{ csrf_token() }}"},
        success: function (response) {
            if (typeof (response.file) != 'undefined') {
                var file = "{{env('FILE_UPLOAD_URL')}}" + "{{env('IVR_FILE_UPLOAD_FOLDER_NAME')}}" + "/" + response.file;
                 var d = new Date();
                $("#test_audio_add").attr('src', file+"?"+d.getTime());
                var x = document.getElementById("test_audio_add");
                x.play();
            } else {

            }
        }
    });
}
   
function getAudioRecordPermissionAdd(){
    navigator.mediaDevices.getUserMedia({audio:true})
        .then(stream => {handlerFunction(stream)});
}
function handlerFunctionAdd(stream) {
    rec = new MediaRecorder(stream);
    rec.ondataavailable = e => {
        audioChunks.push(e.data);
        if (rec.state == "inactive"){
            let blob = new Blob(audioChunks,{type:'audio/wav'});
            recordedAudio.src = URL.createObjectURL(blob);
            recordedAudio.controls=true;
            recordedAudio.autoplay=true;
            sendDataAdd(blob)
        }
    }
}
function sendDataAdd(data) {
    var fd = new FormData();
    fd.append('data', data);

    $.ajax({
        url: '/save-recorded-audio',
        type: 'POST',
        data: fd,
        processData: false,
        contentType: false,
        success: function (response){
            // console.log(response);
        },
        error: function (response) {
            console.log(response);
        }
    });
}


</script>



@endsection