@extends('layouts.app')
@section('title', 'VoIP Configurations')

@section('content')
<style>
    .voip-header {
    display: flex;
    flex-direction: column;   /* mobile: stack */
    align-items: flex-start;
    gap: 10px;                /* space between heading & button */
    margin-bottom: 15px;
}

.voip-header .add-btn {
    align-self: flex-start;   /* button normal width on mobile */
}

/* Tablet & Desktop */
@media (min-width: 768px) {
    .voip-header {
        flex-direction: row;         /* same row */
        justify-content: space-between;
        align-items: center;
    }

    .voip-header .add-btn {
        align-self: center;          /* button right */
    }
}

    </style>
<!-- Main content -->
    <section class="content">

            <div class="row">       
                <div class="col-12">
                <div class="box">
                   <div class="box-body">           
               <div class="voip-header">
    <h4 class="box-title text-info mb-0">
        <i class="fa fa-user fa-sx"></i> VoIP Configurations
    </h4>

    <a href="{{ url('/voip-configuration') }}" 
       class="btn btn-primary btn-rounded btn-sm add-btn">
        <i class="fa fa-plus"></i> Add VoIP Configuration
    </a>
</div>

                   <hr class="my-15">
                
                    <div class="table-responsive">
                        <table id="tickets" class="table mt-0 table-hover no-wrap" data-page-size="10">
                        <thead>
                                    <tr>
                                    <th>#</th>
                                    <th>Name</th>
                                    <th>Host</th>
                                    <th>Username</th>
                                    <th>Password</th>                           
                                    <th>Action</th>

                                    </tr>
                        </thead>
                            <tbody>
                                    @if(!empty($voip_configurations))
                                        @foreach($voip_configurations as $key => $voip)
                                        @php
                                        $data = explode('_',$voip->name);
                                        @endphp
                                        <tr>
                                        <th scope="row">{{$key+1}}</th>
                                        <td>{{str_replace('-',' ',$data[0])}}</td>
                                    
                                            <td>{{$voip->host}}</td>                            
                                        <td>{{str_replace('-',' ',$voip->username)}}</td>
                                        <td>{{$voip->secret}}</td>                                                                             
                                        <td><a style="cursor:pointer;margin-right:5px;" title="Edit"  href="{{ url('/voip-configuration/') }}/{{$voip->id}}" class='editLabel'><i class="fa fa-edit fa-lg"></i></a> 
                                        <a  style="cursor:pointer;"title="Delete" class='openLabelDelete' data-id="{{$voip->id}}"><i class="fa fa-trash-o fa-lg"></i></a>
                                        </td>
                                        
                                    
                                        </tr>

        
                                    @endforeach
                                    @endif
                            </tbody>
                        </table>
                    </div>
                    </div>
                </div>
                </div>
        

                    <div class="modal fade" id="delete" tabindex="-1" aria-labelledby="deleteLabel" aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="myModalLabel">Confirm Delete</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <p>You are about to delete <b><i class="title"></i></b>List.</p>
                            <p>Do you want to proceed?</p>
                            <input type="hidden" class="form-control" name="label_id" value="" id="label_id">
                        
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-danger btn-sm deleteLabel">Delete</button>
                        </div>
                        </div>
                    </div>
                    </div>
            </div>
      <!-- /.row -->

    </section>
        <!-- /.content -->
        <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>

<script>
    
    $(".openLabelDelete").click(function() {
        var delete_id = $(this).data('id');
        $("#delete").modal('show');
        $("#label_id").val(delete_id);

    });

    

    $(document).on("click", ".deleteLabel", function()
    {
        var delete_id = $("#label_id").val();
        var el = this;
        $.ajax({
            url: 'delete-voip-configuration/' + delete_id,
            type: 'get',
            success: function(response) {
                toastr.success('Voip Configuration has been deleted successfully');
                window.location.reload(1);
            }
        });
    });
</script>








@endsection
