 @extends('website.layout')

@section('meta')
<title>About Us – Leadmine AI Voice & Call Automation Platform</title>

<meta name="description" content="Discover Leadmine’s mission to simplify customer communication using AI voice and call automation for sales, support, and operations.">

<meta name="keywords" content="About Leadmine, AI voice automation, call automation platform, AI customer communication, voice AI solutions">

{{-- Open Graph --}}
<meta property="og:title" content="About Us – Leadmine AI Voice & Call Automation Platform">
<meta property="og:description" content="Discover Leadmine’s mission to simplify customer communication using AI voice and call automation for sales, support, and operations.">
<meta property="og:image" content="{{ asset('web/assets/images/ai-recep.webp') }}">
<meta property="og:type" content="website">
<meta property="og:url" content="{{ url()->current() }}">

{{-- Twitter / X --}}
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="About Us – Leadmine AI Voice & Call Automation Platform">
<meta name="twitter:description" content="Discover Leadmine’s mission to simplify customer communication using AI voice and call automation for sales, support, and operations.">
<meta name="twitter:image" content="{{ asset('web/assets/images/ai-recep.webp') }}">

@endsection






<link
  rel="stylesheet"
  href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css"
/>





 @section('content')
<style>
.custom-img {
  margin-top: 180px;
}

 .paragraph-style {
  font-weight: 400;
  font-size: 18px;
}

.custom-heading {
  font-weight: 400;  
}

.max-width-40 {
  max-width: 40%;
}

@media (max-width: 768px) {
  .custom-img {
    margin-top: 50px;
  }
}
.pt-40 {
  padding-top: 40px;
}
.img-auto-warranty {
  max-height: 500px;
  width: 100%;
  object-fit: contain;
}

.img-deal-maxwidth{
  max-width: 35%;
}
.custom-padding-100 {
  padding: 100px 0;
}
.img-pitch-maxwidth {
  max-width: 30%;
}
.visually-hidden {
    position: absolute;
    width: 1px;
    height: 1px;
    padding: 0;
    margin: -1px;
    overflow: hidden;
    clip: rect(0, 0, 0, 0);
    white-space: nowrap;
    border: 0;
}
.as-h2 {
 font-size: clamp(1.5rem, 0.5569rem + 1.444vw, 1.875rem);
 }

.tw-mb-1{
 font-size: clamp(1.125rem, 1.2rem + 0.722vw, 1.5rem);
 }
</style>
 <!-- <section class="section-bg-two pb-50 overflow-hidden pt-40">
     <div class="container max-w-1290-px">
         <div class="row gy-5 align-items-center justify-content-center text-center">
             <div class="col-xl-12">
                 <div>
                     <div class="mx-auto tw-mb-12">
                          <h1 class="visually-hidden">Real Estate & Mortgage Intelligence</h1>
                         <h3 class="splitTextStyleOne text-heading heading-medium">
                             Real Estate & Mortgage Intelligence
                         </h3>
                         <p class="text-neutral-500 tw-mt-2 splitTextStyleOne max-w-770-px tw-text-lg mx-auto">
                             With real-time dashboards and performance scorecards, managers get a clear view of which
                             agents are driving deals—and who needs coaching.
                         </p>
                         <div class="tw-mt-2" data-aos="fade-up" data-aos-anchor-placement="top-bottom"
                             data-aos-duration="900">
                             <a href="{{ route('register') }}"
                                 class="hover--translate-y-1 active--translate-y-scale-9 btn button--stroke tw-gap-5 group active--translate-y-2 tw-rounded-xl text-capitalize tw-px-8 tw-py-505 fw-medium btn-main hover-style-one"
                                 data-block="button">
                                 <span class="button__flair"></span>
                                 <span class="button__label">Get started</span>
                             </a>
                         </div>
                     </div>
                 </div>
             </div>
         </div>
     </div>
 </section> -->
<section class="hero-section">
  <div class="hero-content">
    <h1>
      Let's <span class="gradient-text">{{ config('app.site') }}</span><br />
      Your Best Career Move
    </h1>
    <p>
      Here fierce ambitions move fast, ownership runs deep,<br />
      and titles don't get in the way.
    </p>
    <a href="{{ route('register') }}" class="cta-btn">Get Started</a>
  </div>

  <div class="wave-left"></div>
<div class="wave-bottom"></div>
</section>

<style>
.hero-section {
  position: relative;
  overflow: hidden;
 background: linear-gradient(135deg, #0c1234 0%, #1c1e52 30%, #26185a 60%, #4b23b0 90%, #6f3de9 100%);
  min-height: 70vh;
  display: flex;
  align-items: center;
  justify-content: center;
  text-align: center;
  font-family: "Inter", sans-serif;
  padding: 80px 20px;
}


.hero-section::before {
  content: "";
  position: absolute;
  inset: 0;
  background: 
  linear-gradient(rgba(255,255,255,0.05) 1px, transparent 1px),
  linear-gradient(90deg, rgba(255,255,255,0.05) 1px, transparent 1px);
  background-size: 80px 80px;
  z-index: 0;
}


.hero-section::after {
  content: "";
  position: absolute;
  top: -100px;
  left: -200px;
  width: 600px;
  height: 600px;
  background: radial-gradient(circle at center, rgba(0, 183, 255, 0.2) 0%, transparent 70%);
  border-radius: 50%;
  z-index: 0;
  filter: blur(60px);
}


.hero-section .wave-left,
.hero-section .wave-bottom {
  position: absolute;
  width: 600px;
  height: 600px;
  border-radius: 50%;
  filter: blur(60px);
  z-index: 1;
  pointer-events: none;
}

.hero-section .wave-left {
  top: 0;
  left: 0;
  background: radial-gradient(circle at center, rgba(0, 255, 183, 0.4) 0%, transparent 70%);
}

.hero-section .wave-bottom {
  bottom: 0;
  right: 0;
  background: radial-gradient(circle at center, rgba(160, 80, 255, 0.4) 0%, transparent 70%);
}

.hero-content {
  position: relative;
  z-index: 2;
  color: #fff;
  max-width: 850px;
}

.hero-content h1 {
  font-size: 44px; 
  font-weight: 800;
  line-height: 1.2;
  margin-bottom: 25px;
}

.gradient-text {
  background: linear-gradient(90deg, #00b3ff, #8b6df2);
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
}

.hero-content p {
  font-size: 18px;
  color: #d1d1d1;
  line-height: 1.7;
  margin-bottom: 45px;
}

.cta-btn {
  display: inline-block;
  background: #1760ff;
  color: #fff;
  font-weight: 600;
  font-size: 18px;
  padding: 14px 38px;
  border-radius: 10px;
  text-decoration: none;
  transition: all 0.3s ease;
  box-shadow: 0 4px 15px rgba(23, 96, 255, 0.3);
}

.cta-btn:hover {
  background: #0049e0;
  transform: translateY(-2px);
}

/* Responsive Design */
@media (max-width: 768px) {
  .hero-content h1 {
    font-size: 34px;
  }
  .hero-content p {
    font-size: 16px;
  }
  .cta-btn {
    font-size: 16px;
    padding: 12px 28px;
  }
}



.about-badge {
  font-size: 0.9rem;
}


.icon-size {
  font-size: 2.2rem;
}


.about-img {
  max-width: 100%;
  height: auto;
  border-radius: 12px;
}

.switch-card {
  transition: all 0.3s ease;
}

.switch-card:hover {
  transform: translateY(-4px);
}

</style>


<section class="switch-section py-5">
  <div class="container">
    <div class="tw-mb-13 text-center">
      <span class="tw-py-1 tw-px-705 bg-main-50 text-main-600 tw-text-sm fw-bold text-capitalize rounded-pill tw-mb-205 about-badge">
        About {{ config('app.site') }}
      </span>

      <h3 class="splitTextStyleOne custom-perspective">
        <div class="split-line custom-centered-title">
          We Believe in Humanizing Every Conversation
        </div>
      </h3>
    </div>

    <div class="row align-items-center g-5">
      <!-- Left Content -->
      <div class="col-lg-7">
        <div class="about-content">
          <p>
            We believe every business deserves to sound smart — not robotic. Yet today, phone interactions are painfully outdated. Customers wait through endless menus, repeat themselves to agents, and walk away feeling unheard.
          </p>

          <p>
            Our voice AI doesn’t just answer calls — it listens, understands, and acts with empathy. From the first “hello” to the final resolution, we help businesses sound more human, even when no human is on the line. Because in every call, there’s a chance to connect — and we’re here to make it count.
          </p>

          <div class="row g-4 mt-4">
            <!-- Mission -->
            <div class="col-md-6">
              <div class="switch-card">
                <div class="icon mb-3">
                  <i class="bi bi-bullseye text-main-600 icon-size"></i>
                </div>
                <h5>Mission Statement</h5>
                <p>
                  Our mission is to make every business call smarter, warmer, and more human — through AI that speaks, acts, and delivers value in every conversation.
                </p>
              </div>
            </div>

            <!-- Vision -->
            <div class="col-md-6">
              <div class="switch-card">
                <div class="icon mb-3">
                  <i class="bi bi-eye text-main-600 icon-size"></i>
                </div>
                <h5>Vision Statement</h5>
                <p>
                  To transform voice communication globally — where every call is answered by intelligent AI that sounds human and scales trust.
                </p>
              </div>
            </div>
          </div>
        </div>
      </div>

      <!-- Right Image -->
      <div class="col-lg-5 text-center">
        <img src="web/assets/images/ai-recep.webp"  alt="AI receptionist virtual assistant for customer service"  class="img-fluid about-img">
      </div>
    </div>
  </div>
</section>


<style>
.switch-section {
  background: #fff;
  font-family: 'Poppins', sans-serif;
}

.about-content p {
  color: #4f5b7d;
  font-size: 1.05rem;
  line-height: 1.8;
  margin-bottom: 1.5rem;
  text-align: justify;
}

.switch-card {
  background: #fff;
  border: 1px solid #e6e6e6;
  border-radius: 16px;
  padding: 28px 22px;
  height: 100%;
  transition: all 0.3s ease;
}

.switch-card:hover {
  box-shadow: 0 8px 20px rgba(0, 0, 0, 0.05);
  transform: translateY(-3px);
}

.switch-card .icon {
  width: 55px;
  height: 55px;
  background: #f0f4ff;
  border-radius: 12px;
  padding: 10px;
  display: flex;
  align-items: center;
  justify-content: center;
}

.switch-card h5 {
  font-weight: 700;
  color: #0b1b4f;
  margin-bottom: 12px;
  font-size: 1.1rem;
}

.switch-card p {
  color: #4f5b7d;
  font-size: 0.95rem;
  line-height: 1.7;
}

.about-img {
  max-width: 100%;
  border-radius: 16px;
  box-shadow: 0 10px 25px rgba(0, 0, 0, 0.05);
  transition: transform 0.4s ease;
}

.about-img:hover {
  transform: scale(1.03);
}

@media (max-width: 992px) {
  .about-content {
    text-align: center;
  }

  .about-content p {
    text-align: center;
  }

  .switch-card {
    text-align: left;
  }

  .about-img {
    margin-top: 30px;
  }
}



.ind-badge {
  font-size: 0.9rem;
}


.icon-size {
  font-size: 2.2rem;
}


.cta-text {
  font-family: 'Poppins', sans-serif;
  font-size: 1.1rem;
}

.cta-link {
  color: #0d6efd;
  text-decoration: none;
  font-weight: 600;
}

.cta-link:hover {
  text-decoration: underline;
}


</style>


<section class="switch-section py-5">
  <div class="container text-center">
    <div class="tw-mb-13 text-center">
      <span class="tw-py-1 tw-px-705 bg-main-50 text-main-600 tw-text-sm fw-bold text-capitalize rounded-pill tw-mb-205 ind-badge">
        Industries We Serve
      </span>

      <h3 class="splitTextStyleOne custom-perspective">
        <div class="split-line custom-centered-title">
          Transforming Industries Worldwide
        </div>
      </h3>

      <p class="text-gray-600 tw-max-w-[700px] mx-auto mt-3">
        From healthcare to education, {{ config('app.site') }} AI Answering Service is revolutionizing how businesses serve their customers across every sector.
      </p>
    </div>

    <div class="row g-4 justify-content-center">
      <!-- Card 1 -->
      <div class="col-lg-4 col-md-6 col-sm-6">
        <div class="switch-card">
          <div class="icon mb-3">
            <i class="bi bi-heart-pulse text-main-600 icon-size"></i>
          </div>
          <h5>Healthcare</h5>
          <p>
            24/7 patient support, appointment scheduling, and medical information assistance without overwhelming staff.
          </p>
        </div>
      </div>

      <!-- Card 2 -->
      <div class="col-lg-4 col-md-6 col-sm-6">
        <div class="switch-card">
          <div class="icon mb-3">
            <i class="bi bi-briefcase text-main-600 icon-size"></i>
          </div>
          <h5>Legal Services</h5>
          <p>
            Instant case status updates, consultation scheduling, and legal process guidance while lawyers focus on complex cases.
          </p>
        </div>
      </div>

      <!-- Card 3 -->
      <div class="col-lg-4 col-md-6 col-sm-6">
        <div class="switch-card">
          <div class="icon mb-3">
            <i class="bi bi-cart-check text-main-600 icon-size"></i>
          </div>
          <h5>E-commerce</h5>
          <p>
            Order tracking, product information, and customer support that scales with your business growth.
          </p>
        </div>
      </div>

      <!-- Card 4 -->
      <div class="col-lg-4 col-md-6 col-sm-6">
        <div class="switch-card">
          <div class="icon mb-3">
            <i class="bi bi-building text-main-600 icon-size"></i>
          </div>
          <h5>Real Estate</h5>
          <p>
            Property inquiries, showing schedules, and market information available round-the-clock for potential buyers.
          </p>
        </div>
      </div>

      <!-- Card 5 -->
      <div class="col-lg-4 col-md-6 col-sm-6">
        <div class="switch-card">
          <div class="icon mb-3">
            <i class="bi bi-mortarboard text-main-600 icon-size"></i>
          </div>
          <h5>Education</h5>
          <p>
            Student enrollment support, course information, and administrative assistance that never sleeps.
          </p>
        </div>
      </div>

      <!-- Card 6 -->
      <div class="col-lg-4 col-md-6 col-sm-6">
        <div class="switch-card">
          <div class="icon mb-3">
            <i class="bi bi-car-front text-main-600 icon-size"></i>
          </div>
          <h5>Automotive</h5>
          <p>
            Service appointments, parts availability, and technical support while mechanics focus on repairs.
          </p>
        </div>
      </div>
    </div>

    <!-- CTA -->
    <div class="text-center mt-5 cta-text">
      🚀 Ready to experience the transformation?
      <a href="{{ route('register') }}" class="cta-link">
        Get Started Now
      </a>
    </div>
  </div>
</section>



<style>
.switch-section {
  background: #fff;
}

.switch-card {
  background: #fff;
  border: 1px solid #e6e6e6;
  border-radius: 16px;
  padding: 30px 20px;
  height: 100%;
  text-align: left;
  transition: all 0.3s ease;
}

.switch-card:hover {
  box-shadow: 0 8px 20px rgba(0, 0, 0, 0.05);
  transform: translateY(-3px);
}

.switch-card .icon {
  width: 55px;
  height: 55px;
  background: #f0f4ff;
  border-radius: 12px;
  padding: 10px;
  margin-bottom: 20px;
}

.switch-card h5 {
  font-weight: 700;
  color: #0b1b4f;
  margin-bottom: 12px;
  font-size: 1.05rem;
}

.switch-card p {
  color: #4f5b7d;
  font-size: 0.9rem;
  line-height: 1.6;
}

@media (max-width: 992px) {
  .switch-card {
    padding: 25px 18px;
  }
}

@media (max-width: 768px) {
  .switch-card {
    text-align: center;
  }
  .switch-card .icon {
    margin: 0 auto 15px;
  }
}



.impact-bg {
  background-color: #f8f9fb;
}


.impact-title {
  font-size: 2.2rem;
  font-family: 'Poppins', sans-serif;
}


.impact-subtitle {
  max-width: 800px;
  margin: 0 auto;
  font-size: 1.1rem;
  font-family: 'Jost', sans-serif;
}


.impact-stats-font {
  font-family: 'Jost', sans-serif;
}


.impact-number {
  color: #1351d8;
  font-size: 3rem;
  font-weight: 700;
}


.impact-label {
  font-size: 1rem;
}

</style>

<!-- Proven Impact Section -->
<section class="callchex-section py-50 impact-bg">
  <div class="container max-w-1200-px">
    
   
    <div class="text-center mb-5">
      <h2 class="fw-bold impact-title">
        Every Customer Deserves the Right Information
      </h2>
      <p class="lead text-muted mt-3 impact-subtitle">
        Ensure accurate answers and instant support—anytime they call.
      </p>
    </div>

   
    <div class="row text-center justify-content-center impact-stats-font">
      <div class="col-lg-4 col-md-6 mb-4">
        <h3 class="impact-number">24/7</h3>
        <p class="text-muted impact-label">Availability</p>
      </div>

      <div class="col-lg-4 col-md-6 mb-4">
        <h3 class="impact-number">100%</h3>
        <p class="text-muted impact-label">Consistent Answers</p>
      </div>

      <div class="col-lg-4 col-md-6 mb-4">
        <h3 class="impact-number">100%</h3>
        <p class="text-muted impact-label">Reduced Employee Burden</p>
      </div>
    </div>

  </div>
</section>



 <section class="faq-two py-50 bg-aliceblue">
  <div class="container">
    <div class="row gy-4">
      <div class="col-lg-12 d-flex">
        <div class="m-auto">
          <h2 class="visually-hidden">Frequently Asked Questions</h2>
          <h3 class="splitTextStyleOne text-heading text-capitalize heading-medium">
            Frequently Asked Questions
          </h3>
        </div>
      </div>

      <div class="col-lg-12">
        <div class="ps-xl-5">
          <div class="accordion common-accordion style-two arrow-bg-orange" id="accordionExample">

            <!-- Q1 -->
            <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-transparent border-0 mb-0">
              <h3 class="accordion-header">
                <button class="accordion-button shadow-none p-0 bg-transparent h5" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="true">
                  What is {{ config('app.site') }}?
                </button>
              </h3>
              <div id="collapseOne" class="accordion-collapse collapse show" data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 heading-medium">
                    {{ config('app.site') }} is an AI-powered call management platform that helps automate phone answering, analyze conversations, and deliver 24/7 customer support without overloading your team.
                  </p>
                </div>
              </div>
            </div>

            <!-- Q2 -->
            <div class="accordion-item tw-py-8 tw-px-40-px bg-transparent border-0 mb-0">
              <h3 class="accordion-header">
                <button class="accordion-button shadow-none p-0 bg-transparent h5 collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo">
                  How does the AI Receptionist work in {{ config('app.site') }}?
                </button>
              </h3>
              <div id="collapseTwo" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 heading-medium">
                    The AI Receptionist in {{ config('app.site') }} instantly answers incoming calls — even after hours — to schedule appointments, take messages, and route calls intelligently so you never miss an opportunity.
                  </p>
                </div>
              </div>
            </div>

            <!-- Q3 -->
            <div class="accordion-item tw-py-8 tw-px-40-px bg-transparent border-0 mb-0">
              <h3 class="accordion-header">
                <button class="accordion-button shadow-none p-0 bg-transparent h5 collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree">
                  How does {{ config('app.site') }} reduce staff workload?
                </button>
              </h3>
              <div id="collapseThree" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 heading-medium">
                    By handling repetitive calls and inquiries, {{ config('app.site') }} frees your staff from constant interruptions so they can focus on meaningful work while AI handles the rest.
                  </p>
                </div>
              </div>
            </div>

            <!-- Q4 -->
            <div class="accordion-item tw-py-8 tw-px-40-px bg-transparent border-0 mb-0">
              <h3 class="accordion-header">
                <button class="accordion-button shadow-none p-0 bg-transparent h5 collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFour">
                  What is the AI Call Analytics dashboard?
                </button>
              </h3>
              <div id="collapseFour" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 heading-medium">
                    {{ config('app.site') }} includes a powerful AI Call Analytics dashboard that monitors every conversation, tracks sentiment, evaluates call outcomes, and gives you clear insights into customer experience and team performance.
                  </p>
                </div>
              </div>
            </div>

            <!-- Q5 -->
            <div class="accordion-item tw-py-8 tw-px-40-px bg-transparent border-0 mb-0">
              <h3 class="accordion-header">
                <button class="accordion-button shadow-none p-0 bg-transparent h5 collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFive">
                  Can {{ config('app.site') }} answer calls in multiple languages?
                </button>
              </h3>
              <div id="collapseFive" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 heading-medium">
                    Yes! The AI Voice Agents in {{ config('app.site') }} can speak and understand over 50 languages, providing natural, human-like communication for global customers.
                  </p>
                </div>
              </div>
            </div>

            <!-- Q6 -->
            <div class="accordion-item tw-py-8 tw-px-40-px bg-transparent border-0 mb-0">
              <h3 class="accordion-header">
                <button class="accordion-button shadow-none p-0 bg-transparent h5 collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseSix">
                  Does {{ config('app.site') }} handle after-hours calls?
                </button>
              </h3>
              <div id="collapseSix" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 heading-medium">
                    Absolutely. {{ config('app.site') }}’s AI Receptionist works 24/7 — answering calls, capturing details, and ensuring follow-ups so you never miss an opportunity, even outside business hours.
                  </p>
                </div>
              </div>
            </div>

            <!-- Q7 -->
            <div class="accordion-item tw-py-8 tw-px-40-px bg-transparent border-0 mb-0">
              <h3 class="accordion-header">
                <button class="accordion-button shadow-none p-0 bg-transparent h5 collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseSeven">
                  How does {{ config('app.site') }} improve customer experience?
                </button>
              </h3>
              <div id="collapseSeven" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 heading-medium">
                    {{ config('app.site') }} analyzes tone, intent, and satisfaction in real time to give you actionable insights — helping your business deliver faster, smarter, and more empathetic phone support.
                  </p>
                </div>
              </div>
            </div>

            <!-- Q8 -->
            <div class="accordion-item tw-py-8 tw-px-40-px bg-transparent border-0 mb-0">
              <h3 class="accordion-header">
                <button class="accordion-button shadow-none p-0 bg-transparent h5 collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseEight">
                  Do I need technical knowledge to use {{ config('app.site') }}?
                </button>
              </h3>
              <div id="collapseEight" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 heading-medium">
                    Not at all. {{ config('app.site') }} is designed to work out-of-the-box with your existing phone system or CRM — no coding or technical setup required.
                  </p>
                </div>
              </div>
            </div>

            <!-- Q9 -->
            <div class="accordion-item tw-py-8 tw-px-40-px bg-transparent border-0 mb-0">
              <h3 class="accordion-header">
                <button class="accordion-button shadow-none p-0 bg-transparent h5 collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseNine">
                  Is my call data secure with {{ config('app.site') }}?
                </button>
              </h3>
              <div id="collapseNine" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 heading-medium">
                    Yes, security is a top priority. {{ config('app.site') }} uses end-to-end encryption and strict compliance protocols to keep your business and customer data safe.
                  </p>
                </div>
              </div>
            </div>

            <!-- Q10 -->
            <div class="accordion-item tw-py-8 tw-px-40-px bg-transparent border-0 mb-0">
              <h3 class="accordion-header">
                <button class="accordion-button shadow-none p-0 bg-transparent h5 collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTen">
                  Can {{ config('app.site') }} help train my team?
                </button>
              </h3>
              <div id="collapseTen" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 heading-medium">
                    Definitely. {{ config('app.site') }} identifies performance patterns from real calls and provides insights that make employee training faster, smarter, and data-driven.
                  </p>
                </div>
              </div>
            </div>

          </div>
        </div>
      </div>
    </div>
  </div>
</section>



<!-- ================== Driven section Start ====================== -->
        <section class="py-50">
            <div class="container">
                <div class="">
                    <img src="web/assets/images/thumbs/driven-img.webp" alt="driven-img" loading="lazy">
                    <div class="max-w-780-px text-center mx-auto tw-mb-13">
                        <h3 class="splitTextStyleOne text-heading text-capitalize text-capitalize heading-medium">
                            Driven your business today next level by {{ config('app.site') }}
                        </h3>
                        <!-- <div class="d-flex align-items-center tw-gap-4 justify-content-center tw-mt-10">
                            <a href="{{ route('register') }}" class="hover--translate-y-1 active--translate-y-scale-9 btn button--stroke tw-gap-5 group active--translate-y-2 tw-rounded-xl text-capitalize tw-px-8 tw-py-505 fw-medium btn btn-main hover-style-one" data-block="button">
                                <span class="button__flair"></span>
                                <span class="button__label">get started </span>
                            </a>

                        </div> -->
                    </div>
                </div>
            </div>
        </section>
        <!-- ================== Driven section End ====================== -->



 <section class="py-50">
    <div class="container">
        <div class="text-center">
            <h3 class="main-heading text-capitalize mb-4">
              Transform Every Call Into a Growth Opportunity?
            </h3>
            <p class="max-w-780-px mx-auto tw-mb-6">
             Empower your team with Leadmine.pro — the AI-driven platform that analyzes every call, scores leads automatically, and helps you close deals faster.
            </p>

            <div class="d-flex flex-column align-items-center">
                <p class="fw-semibold tw-mb-4">
                    🔥 Don’t wait — start transforming your calls today. 
                    <a href="{{ route('register') }}"
                       class="btn btn-main hover-style-one tw-rounded-xl tw-px-4 tw-py-2 fw-medium text-capitalize ms-2">
                        👉 Join Us Now
                    </a>
                </p>
                <p class="fw-semibold mt-3">Follow us on <a href="https://www.instagram.com/leadmine.pro/">Instagram</a>🔥</p>
                <p class="fw-semibold mt-3">Connect with us on <a href="https://www.linkedin.com/in/leadminepro/">LinkedIn</a>🔥</p>
            </div>
        </div>
    </div>
</section>


 @endsection