@extends('website.layout')

@section('meta')

<title>Automated AI Answering System for Business</title>

<meta name="description" content="Use an AI answering system to manage calls, respond instantly, and free your team to focus on high-value work with seamless automation.">

<meta name="keywords" content="AI answering system, voice AI for business, automated call answering, AI phone agent">

{{-- Open Graph --}}
<meta property="og:title" content="Automated AI Answering System for Business">
<meta property="og:description" content="Use an AI answering system to manage calls, respond instantly, and free your team to focus on high-value work with seamless automation.">
<meta property="og:image" content="{{ asset('web/assets/images/ai-answer.webp') }}">
<meta property="og:type" content="website">
<meta property="og:url" content="{{ url()->current() }}">

{{-- Twitter / X --}}
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Automated AI Answering System for Business">
<meta name="twitter:description" content="Use an AI answering system to manage calls, respond instantly, and free your team to focus on high-value work with seamless automation.">
<meta name="twitter:image" content="{{ asset('web/assets/images/ai-answer.webp') }}">

@endsection





 @section('content')
<style>
.custom-img {
  margin-top: 180px;
}

 .paragraph-style {
  font-weight: 400;
  font-size: 18px;
}

.custom-heading {
  font-weight: 400;  
}

.max-width-40 {
  max-width: 40%;
}

@media (max-width: 768px) {
  .custom-img {
    margin-top: 50px;
  }
}
.pt-40 {
  padding-top: 40px;
}
.img-auto-warranty {
  max-height: 500px;
  width: 100%;
  object-fit: contain;
}

.img-deal-maxwidth{
  max-width: 35%;
}
.custom-padding-100 {
  padding: 100px 0;
}
.img-pitch-maxwidth {
  max-width: 30%;
}
.visually-hidden {
    position: absolute;
    width: 1px;
    height: 1px;
    padding: 0;
    margin: -1px;
    overflow: hidden;
    clip: rect(0, 0, 0, 0);
    white-space: nowrap;
    border: 0;
}
.as-h2 {
 font-size: clamp(1.5rem, 0.5569rem + 1.444vw, 1.875rem);
 }

.tw-mb-1{
 font-size: clamp(1.125rem, 1.2rem + 0.722vw, 1.5rem);
 }
</style>
 <!-- <section class="section-bg-two pb-50 overflow-hidden pt-40">
     <div class="container max-w-1290-px">
         <div class="row gy-5 align-items-center justify-content-center text-center">
             <div class="col-xl-12">
                 <div>
                     <div class="mx-auto tw-mb-12">
                          <h1 class="visually-hidden">Real Estate & Mortgage Intelligence</h1>
                         <h3 class="splitTextStyleOne text-heading heading-medium">
                             Real Estate & Mortgage Intelligence
                         </h3>
                         <p class="text-neutral-500 tw-mt-2 splitTextStyleOne max-w-770-px tw-text-lg mx-auto">
                             With real-time dashboards and performance scorecards, managers get a clear view of which
                             agents are driving deals—and who needs coaching.
                         </p>
                         <div class="tw-mt-2" data-aos="fade-up" data-aos-anchor-placement="top-bottom"
                             data-aos-duration="900">
                             <a href="{{ route('register') }}"
                                 class="hover--translate-y-1 active--translate-y-scale-9 btn button--stroke tw-gap-5 group active--translate-y-2 tw-rounded-xl text-capitalize tw-px-8 tw-py-505 fw-medium btn-main hover-style-one"
                                 data-block="button">
                                 <span class="button__flair"></span>
                                 <span class="button__label">Get started</span>
                             </a>
                         </div>
                     </div>
                 </div>
             </div>
         </div>
     </div>
 </section> -->
<section class="hero-section">
  <div class="hero-container">
    <div class="hero-left">
      <h1 class="text-white">
       AI Answering Service for 24/7 Calls and Bookings
      </h1>
      <p class="text-white">
       Leadmine.pro AI answering service turns missed calls into opportunities by answering instantly, qualifying leads, and scaling without extra staff.
      </p>
      <div class="hero-badges">
        <span class="text-white"><i class="fa fa-check-circle"></i> No credit card required</span>
        <span class="text-white"><i class="fa fa-check-circle"></i> 14 days of AI tools on us</span>
      </div>
    </div>

    <div class="hero-right">
      <div class="hero-image-wrapper">
        <img src="web/assets/images/ai-answer.webp" alt="AI answering assistant handling customer calls">

    
      </div>
    </div>
  </div>
</section>

<style>
.hero-section {
 background: linear-gradient(103deg, #160A33 28.21%, #261258 58.12%, #4B23B0 84.04%, #9677E4 105.97%, #CABBF2 131.89%);
  padding: 100px 0;
  font-family: "Inter", sans-serif;
}

.hero-container {
  max-width: 1250px;
  margin: auto;
  display: flex;
  align-items: center;
  justify-content: space-between;
  flex-wrap: wrap;
  gap: 70px;
}

.hero-left {
  flex: 1 1 520px;
}

.hero-left h1 {
  font-size: 46px;
  font-weight: 800;
  color: #1b1f3b;
  line-height: 1.25;
  margin-bottom: 25px;
  max-width: 500px;
}

.hero-left p {
  font-size: 18px;
  line-height: 1.7;
  color: #2b2b2b;
  margin-bottom: 35px;
  max-width: 520px;
  font-family: "Poppins", sans-serif; 
}

.hero-badges {
  display: flex;
  flex-wrap: wrap;
  gap: 20px;
  font-size: 16px;
  color: #1b1f3b;
}

.hero-badges i {
  color: #3b82f6;
  margin-right: 8px;
}

/* Right Side */
.hero-right {
  flex: 1 1 520px;
  display: flex;
  justify-content: center;
  position: relative;
}

.hero-image-wrapper {
  position: relative;
  width: 100%;
  max-width: 540px;
  border-radius: 20px;
  overflow: hidden;
  box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
}

.hero-image-wrapper img {
  width: 100%;
  display: block;
  object-fit: cover;
}

/* Agent Card */
.agent-card {
  position: absolute;
  top: 30px;
  left: 30px;
  background: #fff;
  border-radius: 16px;
  box-shadow: 0 6px 18px rgba(0, 0, 0, 0.1);
  padding: 16px 18px;
  max-width: 280px;
  border: 1px solid #e5e9ff;
}

.agent-card h4 {
  font-size: 15px;
  font-weight: 700;
  color: #1c2250;
  margin-bottom: 10px;
}

.agent-tabs {
  display: flex;
  gap: 6px;
  margin-bottom: 10px;
}

.agent-tabs .tab {
  flex: 1;
  font-size: 13px;
  text-align: center;
  padding: 6px 0;
  border-radius: 6px;
  background: #eef1ff;
  color: #4a4e74;
  font-weight: 600;
}

.agent-tabs .tab.active {
  background: #3b82f6;
  color: #fff;
}

.agent-message {
  font-size: 14px;
  color: #2b2b2b;
  background: #f9faff;
  padding: 12px;
  border-radius: 10px;
  line-height: 1.5;
  margin-bottom: 10px;
}

.agent-feedback {
  display: flex;
  justify-content: space-between;
  font-size: 13px;
  color: #3b82f6;
  font-weight: 600;
}

/* Responsive */
@media (max-width: 992px) {
  .hero-container {
    flex-direction: column;
    text-align: center;
  }

  .hero-left h1 {
    font-size: 36px;
    max-width: 100%;
  }

  .hero-left p {
    margin: 0 auto 30px;
  }

  .hero-badges {
    justify-content: center;
  }

  .hero-image-wrapper {
    margin-top: 40px;
  }

  .agent-card {
    position: static;
    margin: 20px auto 0;
  }
}

.secure-section {
  background: linear-gradient(180deg, #f2f4ff 0%, #ffffff 100%);
  padding: 100px 0;
  font-family: "Poppins", sans-serif; 
}

.secure-container {
  max-width: 1250px;
  margin: auto;
  display: flex;
  align-items: center;
  justify-content: space-between;
  flex-wrap: wrap;
  gap: 70px;
}

.secure-left {
  flex: 1 1 520px;
}

.secure-left h1 {
  font-size: 42px;
  font-weight: 800;
  color: #1b1f3b;
  line-height: 1.25;
  margin-bottom: 25px;
  max-width: 500px;
}

.secure-left p {
  font-size: 18px;
  line-height: 1.8;
  color: #2b2b2b;
  margin: 20px 0 30px 0; 
  max-width: 520px;
}

.secure-badges {
  display: flex;
  flex-wrap: wrap;
  gap: 20px;
  font-size: 16px;
  color: #1b1f3b;
}

.secure-badges i {
  color: #3b82f6;
  margin-right: 8px;
}

/* Right Side */
.secure-right {
  flex: 1 1 520px;
  display: flex;
  justify-content: center;
  position: relative;
}

.secure-image-wrapper {
  position: relative;
  width: 100%;
  max-width: 540px;
  border-radius: 20px;
  overflow: hidden;
  box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
  background: #fff;
}

.secure-image-wrapper img {
  width: 100%;
  display: block;
  object-fit: cover;
}


@media (max-width: 992px) {
  .secure-container {
    flex-direction: column;
    text-align: center;
  }

  .secure-left h1 {
    font-size: 34px;
    max-width: 100%;
  }

  .secure-left p {
    margin: 20px auto 30px; 
  }

  .secure-badges {
    justify-content: center;
  }

  .secure-image-wrapper {
    margin-top: 40px;
  }
}

</style>


     <section class="integrations-section">
  <div class="container">
    <h2 class="section-title">Fits seamlessly into your tech stack</h2>

    <div class="integration-logos">
      <div class="logo-box">
        <img src="web/assets/images/hubspot.svg" alt="HubSpot">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/salesforce.svg" alt="Salesforce">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/pipedrive.svg" alt="Pipedrive">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/slack.svg" alt="Slack">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/intercom.svg" alt="Intercom">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/zendesk-icon.svg" alt="Zendesk">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/zoho.svg" alt="Zoho">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/outreach.webp" alt="Outreach">
      </div>
    </div>

    <!-- <div class="btn-wrapper">
      <a href="{{ route('register') }}" class="view-btn">Start free trial</a>
    </div> -->
  </div>
</section>


<style>
.integrations-section {
  text-align: center;
  padding: 80px 20px;
  background-color: #fff;
}

.integrations-section .section-title {
  font-size: 32px;
  font-weight: 700;
  color: #0b0c2a;
  margin-bottom: 50px;
}

.integration-logos {
  display: flex;
  flex-wrap: wrap;
  justify-content: center;
  gap: 25px;
  margin-bottom: 50px;
}

.logo-box {
  width: 140px;
  height: 140px;
  background: #fff;
  border-radius: 20px;
  box-shadow: 0 0 0 1px #e5e7eb;
  display: flex;
  align-items: center;
  justify-content: center;
  transition: all 0.3s ease;
}

.logo-box img {
  width: 60px;
  height: auto;
  transition: transform 0.3s ease;
}

.logo-box:hover {
  transform: translateY(-8px);
  box-shadow: 0 8px 25px rgba(0, 0, 0, 0.08);
}

.logo-box:hover img {
  transform: scale(1.1);
}

.view-btn {
  display: inline-block;
  background-color: #0052ff;
  color: #fff;
  font-weight: 600;
  padding: 14px 28px;
  border-radius: 8px;
  text-decoration: none;
  transition: background 0.3s ease;
}

.view-btn:hover {
  background-color: #003ed6;
}

.btn-wrapper {
  margin-top: 20px;
}

.as-h2{
  font-size: 2rem;
}
</style>


<!-- ================== Why Businesses Choose Section Start ====================== -->
<section class="why-choose-ai py-2">
  <div class="container">

    <!-- Section Title -->
    <h2 class="text-center fw-bold mb-5 as-h2">
      Why businesses choose Leadmine.pro’s AI Voice Agent
    </h2>

    <!-- Card Grid -->
    <div class="row g-4">

      <!-- Card 1 -->
      <div class="col-md-6">
        <div class="feature-card h-100 p-4 rounded-4 shadow-sm">
          <h4 class="fw-bold mb-2 text-dark">Hassle-free setup with quick returns</h4>
          <p class="text-muted mb-4">
            Sets up in minutes with no coding required — just answer a few questions about your
            business and your AI answering service is ready to capture opportunities.
          </p>
          <img src="web/assets/images/ai-answer1.webp" alt="Hassle free setup" class="img-fluid rounded-3">
        </div>
      </div>

      <!-- Card 2 -->
      <div class="col-md-6">
        <div class="feature-card h-100 p-4 rounded-4 shadow-sm">
          <h4 class="fw-bold mb-2 text-dark">Instant answers, happier customers</h4>
          <p class="text-muted mb-4">
            Understands intent and urgency in real-time – just like your best rep. Routes complex or
            critical questions to live agents, ensuring every valuable inquiry becomes a potential sale.
          </p>
          <img src="web/assets/images/ai-answer2.webp" alt="Instant answers" class="img-fluid rounded-3">
        </div>
      </div>

      <!-- Card 3 -->
      <div class="col-md-6">
        <div class="feature-card h-100 p-4 rounded-4 shadow-sm">
          <h4 class="fw-bold mb-2 text-dark">Industry fluency that builds trust</h4>
          <p class="text-muted mb-4">
            Speaks the exact language your customers expect. LeadMine.pro AI Voice Agent
            understands inquiries perfectly and qualifies leads based on your business standards.
          </p>
          <img src="web/assets/images/ai-answer3.webp" alt="Industry fluency" class="img-fluid rounded-3">
        </div>
      </div>

      <!-- Card 4 -->
      <div class="col-md-6">
        <div class="feature-card h-100 p-4 rounded-4 shadow-sm">
          <h4 class="fw-bold mb-2 text-dark">Never miss a call, any time of the day</h4>
          <p class="text-muted mb-4">
            Manages everything from 3 AM emergencies to 20 concurrent peak-hour calls with immediate,
            professional attention – no overtime costs, no hold times, no missed opportunities.
          </p>
          <img src="web/assets/images/ai-answer4.webp" alt="Never miss a call" class="img-fluid rounded-3">
        </div>
      </div>

    </div>
  </div>
</section>
<!-- ================== Why Businesses Choose Section End ====================== -->

<!-- Optional Custom CSS -->
<style>
  .why-choose-ai {
    background: #fafbff;
  }

  .feature-card {
    background: #fff;
    border: 1px solid #e5e7eb;
    transition: all 0.3s ease;
  }

  .feature-card:hover {
    transform: translateY(-4px);
    box-shadow: 0 8px 20px rgba(0, 0, 0, 0.06);
  }

  .feature-card h4 {
    font-size: 1.25rem;
    color: #101828;
  }

  .feature-card p {
    font-size: 1rem;
    line-height: 1.6;
  }
</style>


<section class="faq-two py-50 bg-aliceblue">
  <div class="container">
    <div class="row gy-4">
      <div class="col-lg-12 d-flex">
        <div class="m-auto">
          <h2 class="visually-hidden">Frequently Asked Questions</h2>
          <h3 class="splitTextStyleOne text-heading text-capitalize heading-medium">
            Understand Answering Services before you decide
          </h3>
        </div>
      </div>

      <div class="col-lg-12">
        <div class="ps-xl-5">
          <div class="accordion common-accordion style-two arrow-bg-orange" id="accordionExample">

            <!-- Q1 -->
            <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-blue border-0 mb-0" data-aos="fade-up">
              <h3 class="accordion-header d-flex align-items-center justify-content-between tw-gap-3">
                <button class="accordion-button shadow-none p-0 bg-transparent h5" type="button"
                  data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="true"
                  aria-controls="collapseOne">
                  What is an AI answering service?
                </button>
              </h3>
              <div id="collapseOne" class="accordion-collapse collapse show" data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 tw-leading-212 heading-medium">
                    An AI answering service is software that answers customer calls automatically when you or your team can’t. Instead of sending callers to voicemail, it answers common questions, books appointments, takes notes, or routes the call to a human agent (if available).
                  </p>
                  <p class="text-neutral-500 tw-leading-212 heading-medium">
                    These systems are trained on real business data, which allows them to sound natural, handle multiple calls at once, and even speak multiple languages.
                  </p>
                  <p class="text-neutral-500 tw-leading-212 heading-medium">
                    What makes AI answering services different from older auto-attendants is the combination of speech recognition, natural language processing (NLP), and CRM/calendar integration.
                  </p>
                  <p class="text-neutral-500 tw-leading-212 heading-medium">
                    The AI not only understands what customers are saying but also acts on it by updating records, scheduling callbacks, or routing the call to a human agent with full context. In short, it replaces voicemail with a real-time service that works 24/7.
                  </p>
                  <p class="text-neutral-500 tw-leading-212 heading-medium">
                    <strong>Did you know?</strong> 73% of customers say valuing their time is the most important part of good service (Forrester). AI lets you answer calls instantly, no matter what time or day it is.
                  </p>
                </div>
              </div>
            </div>

            <!-- Q2 -->
            <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-blue border-0 mb-0" data-aos="fade-up">
              <h3 class="accordion-header d-flex align-items-center justify-content-between tw-gap-3">
                <button class="accordion-button shadow-none p-0 bg-transparent h5 collapsed" type="button"
                  data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="false"
                  aria-controls="collapseTwo">
                  Why businesses use AI answering services
                </button>
              </h3>
              <div id="collapseTwo" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 tw-leading-212 heading-medium">
                    AI answering services are becoming a staple because they save money, keep businesses available 24/7, and reduce interruptions for staff. Here are the top reasons companies of all sizes rely on them:
                  </p>
                  <ul class="text-neutral-500 tw-leading-212 heading-medium">
                    <li><strong>Save money on staffing:</strong> The median cost of a US receptionist is over $37,000/year. An AI answering service provides consistent coverage at a fraction of that cost.</li>
                    <li><strong>Capture every call and lead:</strong> Studies show small businesses miss up to 60% of calls. AI ensures every opportunity is captured, even after hours.</li>
                    <li><strong>Respond faster than voicemail:</strong> Customers don’t want to leave voicemails—AI answers instantly and routes calls intelligently.</li>
                    <li><strong>Boost productivity for your team:</strong> Offloading routine calls allows staff to focus on higher-value work instead of constant interruptions.</li>
                    <li><strong>Provide consistent, reliable coverage:</strong> Unlike humans, AI doesn’t need breaks or vacations—it’s always available.</li>
                  </ul>
                </div>
              </div>
            </div>

            <!-- Q3 -->
            <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-blue border-0 mb-0" data-aos="fade-up">
              <h3 class="accordion-header d-flex align-items-center justify-content-between tw-gap-3">
                <button class="accordion-button shadow-none p-0 bg-transparent h5 collapsed" type="button"
                  data-bs-toggle="collapse" data-bs-target="#collapseThree" aria-expanded="false"
                  aria-controls="collapseThree">
                  Core features that drive results
                </button>
              </h3>
              <div id="collapseThree" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <ul class="text-neutral-500 tw-leading-212 heading-medium">
                    <li><strong>Always on:</strong> AI answering services work 24/7, including weekends and holidays, supporting multiple languages and maintaining 99.9% uptime.</li>
                    <li><strong>Smarter calls:</strong> NLP allows AI to understand natural conversation, qualify leads, schedule appointments, and route calls intelligently.</li>
                    <li><strong>Connected workflows:</strong> AI integrates with CRMs, calendars, and phone systems for accurate data and seamless workflows.</li>
                    <li><strong>Insights and compliance:</strong> Calls are transcribed, analyzed for sentiment and intent, and stored securely under GDPR, HIPAA, and SOC 2 standards.</li>
                    <li><strong>Human + AI collaboration:</strong> AI handles 70–80% of calls while escalating complex ones to humans with full context.</li>
                  </ul>
                </div>
              </div>
            </div>

            <!-- Q4 -->
            <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-blue border-0 mb-0" data-aos="fade-up">
              <h3 class="accordion-header d-flex align-items-center justify-content-between tw-gap-3">
                <button class="accordion-button shadow-none p-0 bg-transparent h5 collapsed" type="button"
                  data-bs-toggle="collapse" data-bs-target="#collapseFour" aria-expanded="false"
                  aria-controls="collapseFour">
                  Use cases by industry
                </button>
              </h3>
              <div id="collapseFour" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 tw-leading-212 heading-medium">AI answering services adapt across industries where missed calls mean lost opportunities:</p>
                  <ul class="text-neutral-500 tw-leading-212 heading-medium">
                    <li><strong>Healthcare:</strong> Handles appointment booking, insurance queries, urgent routing, and HIPAA-compliant data.</li>
                    <li><strong>Legal firms:</strong> Captures after-hours calls, urgent cases, and multilingual intake for clients.</li>
                    <li><strong>Real estate:</strong> Responds to property inquiries, books viewings, qualifies buyers, and routes hot leads.</li>
                    <li><strong>E-commerce:</strong> Manages product questions, returns, and order updates even during peak seasons.</li>
                  </ul>
                </div>
              </div>
            </div>

            <!-- Q5 -->
            <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-blue border-0 mb-0" data-aos="fade-up">
              <h3 class="accordion-header d-flex align-items-center justify-content-between tw-gap-3">
                <button class="accordion-button shadow-none p-0 bg-transparent h5 collapsed" type="button"
                  data-bs-toggle="collapse" data-bs-target="#collapseFive" aria-expanded="false"
                  aria-controls="collapseFive">
                  AI vs. manual answering & live receptionists
                </button>
              </h3>
              <div id="collapseFive" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 tw-leading-212 heading-medium">
                    Businesses comparing AI answering services often weigh them against voicemail or live receptionists. Here’s how they differ:
                  </p>
                  <table class="table text-neutral-500 tw-leading-212 heading-medium">
                    <thead>
                      <tr>
                        <th>Factor</th>
                        <th>AI Answering Service</th>
                        <th>Voicemail</th>
                        <th>Human Receptionist</th>
                      </tr>
                    </thead>
                    <tbody>
                      <tr><td>Cost</td><td>$0.99/min with LeadMine.pro</td><td>Free but often loses leads</td><td>Avg. $38K/year + overhead</td></tr>
                      <tr><td>Availability</td><td>24/7, all year</td><td>24/7 (no response)</td><td>Business hours only</td></tr>
                      <tr><td>Scalability</td><td>Handles 100s of calls</td><td>One caller at a time</td><td>Limited to staff capacity</td></tr>
                      <tr><td>Consistency</td><td>Uniform responses</td><td>Inconsistent follow-up</td><td>Varies by agent</td></tr>
                    </tbody>
                  </table>
                  <p class="text-neutral-500 tw-leading-212 heading-medium">
                    <strong>LeadMine.pro advantage:</strong> Hybrid AI + human model ensures AI handles routine calls while complex cases go to humans — giving businesses the best of both worlds.
                  </p>
                </div>
              </div>
            </div>

            <!-- Q6 -->
            <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-blue border-0 mb-0" data-aos="fade-up">
              <h3 class="accordion-header d-flex align-items-center justify-content-between tw-gap-3">
                <button class="accordion-button shadow-none p-0 bg-transparent h5 collapsed" type="button"
                  data-bs-toggle="collapse" data-bs-target="#collapseSix" aria-expanded="false"
                  aria-controls="collapseSix">
                  Why choose LeadMine.pro’s AI answering service
                </button>
              </h3>
              <div id="collapseSix" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 tw-leading-212 heading-medium">
                    Not all AI answering tools are equal. LeadMine.pro combines AI-first responsiveness with human backup when needed.
                  </p>
                  <ul class="text-neutral-500 tw-leading-212 heading-medium">
                    <li>Always-on AI Voice Agent with 24/7 availability</li>
                    <li>Smart scheduling and calendar sync</li>
                    <li>Customizable call flows that fit your brand</li>
                    <li>Multilingual support in 14+ languages</li>
                    <li>Human escalation with full context</li>
                    <li>Rich CRM and calendar integration</li>
                    <li>Instant summaries, transcripts, and analytics</li>
                    <li>Actionable insights and coaching tools</li>
                  </ul>
                </div>
              </div>
            </div>

            <!-- Q7 -->
            <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-transparent border-0 mb-0" data-aos="fade-up">
              <h3 class="accordion-header d-flex align-items-center justify-content-between tw-gap-3">
                <button class="accordion-button shadow-none p-0 bg-transparent h5 collapsed" type="button"
                  data-bs-toggle="collapse" data-bs-target="#collapseSeven" aria-expanded="false"
                  aria-controls="collapseSeven">
                  How to maximize ROI and business impact?
                </button>
              </h3>
              <div id="collapseSeven" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <ul class="text-neutral-500 tw-leading-212 heading-medium">
                    <li><strong>Lower costs than hiring staff:</strong> A full-time receptionist costs $38K/year, while LeadMine.pro provides 24/7 coverage at a fraction of that.</li>
                    <li><strong>More calls answered = more revenue:</strong> Companies using AI answering saw 35% fewer missed calls and 22% higher satisfaction (HBR).</li>
                    <li><strong>Scalable without hiring:</strong> AI scales instantly, handling hundreds of calls consistently.</li>
                  </ul>
                  <p class="text-neutral-500 tw-leading-212 heading-medium">
                    Gartner projects that by 2026, 60% of all customer service interactions will be AI-handled — making early adoption key to long-term growth.
                  </p>
                </div>
              </div>
            </div>

          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<style>
.faq-two .accordion-body {
  max-width: 100%;
}
.faq-two .accordion {
  width: 100%;
}
.faq-two .accordion-item {
  width: 100%;
}
</style>


<section class="toolkit-section py-5">
  <div class="container">
    <h4 class="text-center mb-5 fw-bold">Platform designed to accelerate your growth</h4>

    <div class="toolkit-grid">
      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-chart-line"></i></div>
        <h4>AI Analytics</h4>
        <p>Assess every customer call with instant, AI-generated intelligence and derive actionable insights.</p>
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-link"></i></div>
        <h4>CRM Integrations</h4>
        <p>No more app-switching with seamless integrations into popular CRM and Helpdesk tools.</p>
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-phone"></i></div>
        <h4>IVR</h4>
        <p>Set up an interactive menu. Allow digit-based customer inputs to route calls to respective teams.</p>
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-user-shield"></i></div>
        <h4>Roles and Permissions</h4>
        <p>Set up roles, control user access, and limit it to key functions. Prevent accidental data changes.</p>
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-route"></i></div>
        <h4>Intelligent Routing</h4>
        <p>Automatically route calls to the customer's contact owner in the CRM.</p>
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-user-clock"></i></div>
        <h4>Agent Availability</h4>
        <p>Monitor your team’s status and see the real-time availability of your agents in one place.</p>
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-headset"></i></div>
        <h4>After Call Work</h4>
        <p>Clearly mark the outcome of a call with call disposition. Let AI take care of the manual note-taking.</p>
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-phone-volume"></i></div>
        <h4>Dialers</h4>
        <p>Upload contact lists & automate number dialing. Connect agents only when the call is answered.</p>
      </div>
    </div>
  </div>
</section>

<!-- Font Awesome -->
<script src="https://kit.fontawesome.com/a2d9a67a2b.js" crossorigin="anonymous"></script>

<style>
.toolkit-section {
  background: #f7f7f9; 
  font-family: 'Poppins', sans-serif;
}

.toolkit-grid {
  display: grid;
  grid-template-columns: repeat(auto-fit, minmax(270px, 1fr));
  gap: 25px;
}

.toolkit-item {
  background: #fff;
  border: 1px solid #e5e7eb;
  border-radius: 12px;
  padding: 28px 24px;
  box-shadow: 0 4px 12px rgba(0,0,0,0.04);
  transition: all 0.3s ease;
  cursor: pointer;
}

.toolkit-item:hover {
  border-color: #3b82f6;
  box-shadow: 0 8px 22px rgba(59,130,246,0.1);
  transform: translateY(-4px);
}


.toolkit-item .icon {
  font-size: 30px;
  color: #0a5bff;
  margin-bottom: 18px;
}


.toolkit-item h4 {
  font-size: 18px;
  font-weight: 600;
  margin-bottom: 10px;
  color: #000;
}

.toolkit-item p {
  font-size: 15px;
  color: #444;
  line-height: 1.6;
}

@media (max-width: 768px) {
  .toolkit-item {
    padding: 22px 18px;
  }
}
</style>


<section class="secure-section py-50 bg-aliceblue">
  <div class="secure-container">

    <!-- Left Text -->
    <div class="secure-left">
      <div class="secure-icon mb-3">
                <i class="fa fa-user-tie"></i>
        <span>Agent</span>
      </div>
      <h3 class="mb-3">Traditional call answering services falling short?</h3>
      <p>
        Those late-night calls, weekend questions, and peak-hour inquiries aren’t just missed—they’re lost customers who needed answers and found no one there.
      </p>
    </div>

    <!-- Center Divider -->
    <div class="secure-divider"></div>

    <!-- Right Text -->
    <div class="secure-right">
      <div class="secure-icon mb-3">
        <i class="fa fa-robot"></i>
        <span>AI Receptionist</span>
      </div>
      <h3 class="mb-3">Meet Leadmine.pro’s AI Voice Agent – your force multiplier</h3>
      <p>
        Make every call count, 24/7. From capturing leads to booking appointments and answering routine questions, stay on top of it all — no matter the time.
      </p>
    </div>

  </div>
</section>


<style>
.secure-section {
  padding: 60px 0;
  background-color: #f4f8fb;
}

.secure-container {
  display: flex;
  justify-content: space-between;
  align-items: flex-start;
  gap: 50px;
  max-width: 1100px;
  margin: 0 auto;
}

.secure-left,
.secure-right {
  flex: 1;
  text-align: left;
  display: flex;
  flex-direction: column;
  justify-content: flex-start;
}

.secure-icon {
  display: flex;
  align-items: center;
  gap: 10px;
  font-weight: 600;
  color: #007bff;
  font-size: 1rem;
}

.secure-icon i {
  font-size: 1.5rem;
}

.secure-left h3,
.secure-right h3 {
  font-size: 1.5rem;
  font-weight: 600;
  margin-bottom: 15px;
  color: #1a1a1a;
}

.secure-left p,
.secure-right p {
  color: #555;
  margin: 0;
  line-height: 1.7;
}

.secure-divider {
  width: 2px;
  background-color: #ccc;
  flex-shrink: 0;
  height: auto; 
   align-self: stretch; 
}

@media (max-width: 768px) {
  .secure-container {
    flex-direction: column;
    align-items: center;
    text-align: center;
  }

  .secure-divider {
    width: 60%;
    height: 2px;
    margin: 25px 0;
  }

  .secure-left,
  .secure-right {
    text-align: center;
    align-items: center;
  }
}

</style>


    
 


 <!-- ================== Pricing Plan one End ====================== -->



 @endsection