 @extends('website.layout')

@section('meta')
<title>AI Receptionist Software | Automated Voice & Call Handling</title>

<meta name="description" content="Boost efficiency with AI receptionist software that automates calls, messages, scheduling, and customer engagement for your business.">

<meta name="keywords" content="AI receptionist software, automated call handling, AI virtual receptionist, voice AI for business, AI call automation">

{{-- Open Graph --}}
<meta property="og:title" content="AI Receptionist Software | Automated Voice & Call Handling">
<meta property="og:description" content="Boost efficiency with AI receptionist software that automates calls, messages, scheduling, and customer engagement for your business.">
<meta property="og:image" content="{{ asset('web/assets/images/ai-recep.webp') }}">
<meta property="og:type" content="website">
<meta property="og:url" content="{{ url()->current() }}">

{{-- Twitter / X --}}
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="AI Receptionist Software | Automated Voice & Call Handling">
<meta name="twitter:description" content="Boost efficiency with AI receptionist software that automates calls, messages, scheduling, and customer engagement for your business.">
<meta name="twitter:image" content="{{ asset('web/assets/images/ai-recep.webp') }}">

@endsection




 @section('content')
<style>
.custom-img {
  margin-top: 180px;
}

 .paragraph-style {
  font-weight: 400;
  font-size: 18px;
}

.custom-heading {
  font-weight: 400;  
}

.max-width-40 {
  max-width: 40%;
}

@media (max-width: 768px) {
  .custom-img {
    margin-top: 50px;
  }
}
.pt-40 {
  padding-top: 40px;
}
.img-auto-warranty {
  max-height: 500px;
  width: 100%;
  object-fit: contain;
}

.img-deal-maxwidth{
  max-width: 35%;
}
.custom-padding-100 {
  padding: 100px 0;
}
.img-pitch-maxwidth {
  max-width: 30%;
}
.visually-hidden {
    position: absolute;
    width: 1px;
    height: 1px;
    padding: 0;
    margin: -1px;
    overflow: hidden;
    clip: rect(0, 0, 0, 0);
    white-space: nowrap;
    border: 0;
}
.as-h2 {
 font-size: clamp(1.5rem, 0.5569rem + 1.444vw, 1.875rem);
 }

.tw-mb-1{
 font-size: clamp(1.125rem, 1.2rem + 0.722vw, 1.5rem);
 }
</style>
 <!-- <section class="section-bg-two pb-50 overflow-hidden pt-40">
     <div class="container max-w-1290-px">
         <div class="row gy-5 align-items-center justify-content-center text-center">
             <div class="col-xl-12">
                 <div>
                     <div class="mx-auto tw-mb-12">
                          <h1 class="visually-hidden">Real Estate & Mortgage Intelligence</h1>
                         <h3 class="splitTextStyleOne text-heading heading-medium">
                             Real Estate & Mortgage Intelligence
                         </h3>
                         <p class="text-neutral-500 tw-mt-2 splitTextStyleOne max-w-770-px tw-text-lg mx-auto">
                             With real-time dashboards and performance scorecards, managers get a clear view of which
                             agents are driving deals—and who needs coaching.
                         </p>
                         <div class="tw-mt-2" data-aos="fade-up" data-aos-anchor-placement="top-bottom"
                             data-aos-duration="900">
                             <a href="{{ route('register') }}"
                                 class="hover--translate-y-1 active--translate-y-scale-9 btn button--stroke tw-gap-5 group active--translate-y-2 tw-rounded-xl text-capitalize tw-px-8 tw-py-505 fw-medium btn-main hover-style-one"
                                 data-block="button">
                                 <span class="button__flair"></span>
                                 <span class="button__label">Get started</span>
                             </a>
                         </div>
                     </div>
                 </div>
             </div>
         </div>
     </div>
 </section> -->
<section class="hero-section">
  <div class="hero-container">
    <div class="hero-left">
      <h1 class="text-white">
      24/7 AI Receptionist For Bookings and Routing
      </h1>
      <p class="text-white">
       Leadmine.pro AI receptionist manages calls, bookings, and lead capture 24/7 at a fraction of a $37K+ hire, cutting costs while automating scheduling, FAQs, and peak-time scaling.
      </p>
      <div class="hero-badges">
        <span class="text-white"><i class="fa fa-check-circle"></i> No credit card required</span>
        <span class="text-white"><i class="fa fa-check-circle"></i> 14 days of AI tools on us</span>
      </div>
    </div>

    <div class="hero-right mb-6">
      <div class="hero-image-wrapper">
        <img src="web/assets/images/ai-recep.webp" alt="AI receptionist virtual assistant for customer service">

    
      </div>
    </div>
  </div>
</section>

<style>
.hero-section {
 background: linear-gradient(103deg, #160A33 28.21%, #261258 58.12%, #4B23B0 84.04%, #9677E4 105.97%, #CABBF2 131.89%);
  padding: 100px 0;
  font-family: "Inter", sans-serif;
}

.hero-container {
  max-width: 1250px;
  margin: auto;
  display: flex;
  align-items: center;
  justify-content: space-between;
  flex-wrap: wrap;
  gap: 70px;
}

.hero-left {
  flex: 1 1 520px;
}

.hero-left h1 {
  font-size: 42px;
  font-weight: 800;
  color: #1b1f3b;
  line-height: 1.25;
  margin-bottom: 25px;
  max-width: 500px;
}

.hero-left p {
  font-size: 18px;
  line-height: 1.7;
  color: #2b2b2b;
  margin-bottom: 35px;
  max-width: 520px;
  font-family: "Poppins", sans-serif; 
}

.hero-badges {
  display: flex;
  flex-wrap: wrap;
  gap: 20px;
  font-size: 16px;
  color: #1b1f3b;
}

.hero-badges i {
  color: #3b82f6;
  margin-right: 8px;
}

/* Right Side */
.hero-right {
  flex: 1 1 520px;
  display: flex;
  justify-content: center;
  position: relative;
}

.hero-image-wrapper {
  position: relative;
  width: 100%;
  max-width: 540px;
  border-radius: 20px;
  overflow: hidden;
  box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
}

.hero-image-wrapper img {
  width: 100%;
  display: block;
  object-fit: cover;
}

/* Agent Card */
.agent-card {
  position: absolute;
  top: 30px;
  left: 30px;
  background: #fff;
  border-radius: 16px;
  box-shadow: 0 6px 18px rgba(0, 0, 0, 0.1);
  padding: 16px 18px;
  max-width: 280px;
  border: 1px solid #e5e9ff;
}

.agent-card h4 {
  font-size: 15px;
  font-weight: 700;
  color: #1c2250;
  margin-bottom: 10px;
}

.agent-tabs {
  display: flex;
  gap: 6px;
  margin-bottom: 10px;
}

.agent-tabs .tab {
  flex: 1;
  font-size: 13px;
  text-align: center;
  padding: 6px 0;
  border-radius: 6px;
  background: #eef1ff;
  color: #4a4e74;
  font-weight: 600;
}

.agent-tabs .tab.active {
  background: #3b82f6;
  color: #fff;
}

.agent-message {
  font-size: 14px;
  color: #2b2b2b;
  background: #f9faff;
  padding: 12px;
  border-radius: 10px;
  line-height: 1.5;
  margin-bottom: 10px;
}

.agent-feedback {
  display: flex;
  justify-content: space-between;
  font-size: 13px;
  color: #3b82f6;
  font-weight: 600;
}

/* Responsive */
@media (max-width: 992px) {
  .hero-container {
    flex-direction: column;
    text-align: center;
  }

  .hero-left h1 {
    font-size: 36px;
    max-width: 100%;
  }

  .hero-left p {
    margin: 0 auto 30px;
  }

  .hero-badges {
    justify-content: center;
  }

  .hero-image-wrapper {
    margin-top: 40px;
  }

  .agent-card {
    position: static;
    margin: 20px auto 0;
  }
}

.secure-section {
  background: linear-gradient(180deg, #f2f4ff 0%, #ffffff 100%);
  padding: 100px 0;
  font-family: "Poppins", sans-serif; 
}

.secure-container {
  max-width: 1250px;
  margin: auto;
  display: flex;
  align-items: center;
  justify-content: space-between;
  flex-wrap: wrap;
  gap: 70px;
}

.secure-left {
  flex: 1 1 520px;
}

.secure-left h1 {
  font-size: 42px;
  font-weight: 800;
  color: #1b1f3b;
  line-height: 1.25;
  margin-bottom: 25px;
  max-width: 500px;
}

.secure-left p {
  font-size: 18px;
  line-height: 1.8;
  color: #2b2b2b;
  margin: 20px 0 30px 0; 
  max-width: 520px;
}

.secure-badges {
  display: flex;
  flex-wrap: wrap;
  gap: 20px;
  font-size: 16px;
  color: #1b1f3b;
}

.secure-badges i {
  color: #3b82f6;
  margin-right: 8px;
}

/* Right Side */
.secure-right {
  flex: 1 1 520px;
  display: flex;
  justify-content: center;
  position: relative;
}

.secure-image-wrapper {
  position: relative;
  width: 100%;
  max-width: 540px;
  border-radius: 20px;
  overflow: hidden;
  box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
  background: #fff;
}

.secure-image-wrapper img {
  width: 100%;
  display: block;
  object-fit: cover;
}


@media (max-width: 992px) {
  .secure-container {
    flex-direction: column;
    text-align: center;
  }

  .secure-left h1 {
    font-size: 34px;
    max-width: 100%;
  }

  .secure-left p {
    margin: 20px auto 30px; 
  }

  .secure-badges {
    justify-content: center;
  }

  .secure-image-wrapper {
    margin-top: 40px;
  }
}

</style>



<section class="secure-section py-50 bg-aliceblue">
  <div class="secure-container">

    <!-- Left Text -->
    <div class="secure-left">
      <div class="secure-icon mb-3">
        <i class="fa fa-phone"></i>
        <span>Without AI Receptionist</span>
      </div>
      <h3 class="mb-3">Missed calls often lead to lost leads and lower revenue</h3>
      <ul>
        <li>Unanswered after-hours inquiries until the next day</li>
        <li>Precious hours lost in answering repetitive questions</li>
        <li>Back-and-forth delays with manual scheduling</li>
        <li>No visibility into call quality or performance data</li>
      </ul>
    </div>

    <!-- Center Divider -->
    <div class="secure-divider"></div>

    <!-- Right Text -->
    <div class="secure-right">
      <div class="secure-icon mb-3">
        <i class="fa fa-robot"></i>
        <span>With Leadmine.pro AI Receptionist</span>
      </div>
      <h3 class="mb-3">Instantly answers every call without any delays</h3>
      <ul>
        <li>24/7 availability even during off-hours and holidays</li>
        <li>Handles unlimited routine calls while agents focus on high-value ones</li>
        <li>Automated appointment scheduling for both teams and customers</li>
        <li>Real-time analytics show areas of improvement</li>
      </ul>
    </div>

  </div>
</section>

<style>
.secure-section {
  padding: 60px 0;
  background-color: #f4f8fb;
}

.secure-container {
  display: flex;
  justify-content: space-between;
  align-items: flex-start;
  gap: 50px;
  max-width: 1100px;
  margin: 0 auto;
}

.secure-left,
.secure-right {
  flex: 1;
  text-align: left;
  display: flex;
  flex-direction: column;
  justify-content: flex-start;
}


.secure-left ul,
.secure-right ul {
  list-style-type: disc;
  margin-left: 20px;
  padding-left: 10px;
  color: #333;
}

.secure-left li,
.secure-right li {
  margin-bottom: 10px;
  line-height: 1.7;
  font-size: 1rem;
}

.secure-icon {
  display: flex;
  align-items: center;
  gap: 10px;
  font-weight: 600;
  color: #007bff;
  font-size: 1rem;
}

.secure-icon i {
  font-size: 1.5rem;
}

.secure-left h3,
.secure-right h3 {
  font-size: 1.5rem;
  font-weight: 600;
  margin-bottom: 15px;
  color: #1a1a1a;
}

.secure-divider {
  width: 2px;
  background-color: #ccc;
  flex-shrink: 0;
  align-self: stretch;
}

/* Responsive */
@media (max-width: 768px) {
  .secure-container {
    flex-direction: column;
    align-items: center;
    text-align: center;
  }

  .secure-divider {
    width: 60%;
    height: 2px;
    margin: 25px 0;
  }

  .secure-left,
  .secure-right {
    text-align: center;
    align-items: center;
  }

  .secure-left ul,
  .secure-right ul {
    list-style-position: inside;
    padding-left: 0;
    margin-left: 0;
    text-align: left;
  }
}

.orchid-bg {
    background-color: orchid;
}

.burlywood-bg {
    background-color: burlywood;
}

.cadetblue-bg {
    background-color: cadetblue;
}
</style>

 





<!-- =============================== Offer section start ============================== -->
<section class="offer py-50 overflow-hidden" id="ai-coach">
    <div class="container">
        <div class="tw-mb-13 text-center">
            <span
                class="tw-py-1 tw-px-705 bg-main-50 text-main-600 tw-text-sm fw-bold text-capitalize rounded-pill tw-mb-205">
                Why front desks rely on {{ config('app.site') }}’s AI Receptionist
            </span>

            <h3 class="splitTextStyleOne custom-perspective">
                <div class="split-line custom-centered-title">
                    24/7 Call Handling with Qualification Logic
                </div>
            </h3>
        </div>

        <div class="row gy-4">
            <div class="col-lg-4">
                <div class="row gy-4">
                    <!-- 24/7 call handling -->
                    <div class="col-lg-12 col-sm-6" data-aos="fade-up" data-aos-anchor-placement="top-bottom"
                        data-aos-duration="600">
                        <div
                            class="group-item position-relative tw-rounded-3xl overflow-hidden z-1 h-100 tw-pt-15 bg-pink-dark tw-px-40-px tw-pb-84-px tw-duration-300">
                            <span class="tw-text-base fw-semibold tw-mb-2 text-pink">Always On</span>
                            <p class="splitTextStyleOne tw-mb-3 max-w-218-px custom-header small-heading">
                                Answer Every Call Instantly
                            </p>
                            <p class="tw-mb-5">
                                Answer right away, ask the right questions, and qualify every caller based on your rules — even when your team is offline.
                            </p>
                            <a href="#"
                                class="tw-w-15 tw-h-15 d-flex justify-content-center align-items-center rounded-circle tw-text-2xl text-white hover--translate-y-1 active--translate-y-scale-9 orchid-bg"
                                aria-label="Learn more about 24/7 call handling">
                                <i class="ph-bold ph-arrow-up-right"></i>
                            </a>
                            <img src="web/assets/images/EasyIntegration.webp" alt="24/7 Call Handling" loading="lazy"
                                class="tw-duration-300 position-absolute bottom-0 tw-end-0 z-n1 tw-w-100 tw-h-auto half-width">
                        </div>
                    </div>

                    <!-- Instant appointment scheduling -->
                    <div class="col-lg-12 col-sm-6" data-aos="fade-up" data-aos-anchor-placement="top-bottom"
                        data-aos-duration="600">
                        <div
                            class="group-item position-relative tw-rounded-3xl overflow-hidden z-1 h-100 tw-pt-15 bg-pink-lighter tw-px-40-px tw-pb-136-px tw-duration-300">
                            <span class="tw-text-base fw-semibold tw-mb-2 text-pink">No Missed Leads</span>
                            <p class="splitTextStyleOne tw-mb-5 max-w-330-px custom-header small-heading">
                                Instant Appointment Scheduling
                            </p>
                            <p class="tw-mb-5">
                                Sync with Google or Outlook and book meetings directly into your calendars — even on holidays, no back-and-forth required.
                            </p>
                            <a href="#"
                                class="tw-w-15 tw-h-15 d-flex justify-content-center align-items-center rounded-circle bg-pink-light tw-text-2xl text-white hover--translate-y-1 active--translate-y-scale-9">
                                <i class="ph-bold ph-arrow-up-right"></i>
                            </a>
                            <img src="web/assets/images/AI-PoweredInsights.webp" alt="Instant Appointment Scheduling" loading="lazy"
                                class="tw-duration-300 position-absolute bottom-0 tw-end-0 z-n1 max-width-40">
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-4" data-aos="fade-up" data-aos-anchor-placement="top-bottom"
                data-aos-duration="600">
                <div class="row gy-4">
                    <!-- Route calls smartly -->
                    <div class="col-lg-12 col-sm-6">
                        <div
                            class="group-item position-relative tw-rounded-3xl overflow-hidden z-1 tw-pt-15 bg-main-50 tw-px-40-px tw-pb-84-px tw-duration-300 h-100">
                            <span class="text-main-600 fw-semibold tw-mb-2">Understands Every Caller</span>
                            <p class="splitTextStyleOne tw-mb-5 max-w-318-px custom-header small-heading">
                                Route Calls with Context
                            </p>
                            <p class="tw-mb-5">
                                Send every call to the right person, fast. Your AI receptionist knows who’s calling and why — connecting them instantly.
                            </p>
                            <a href="#"
                                class="tw-w-15 tw-h-15 d-flex justify-content-center align-items-center rounded-circle text-white tw-text-2xl bg-main-600 hover-text-white hover--translate-y-1 active--translate-y-scale-9">
                                <i class="ph-bold ph-arrow-up-right"></i>
                            </a>
                            <img src="web/assets/images/Real-Time-Monitoring.webp" alt="Route Calls with Context" loading="lazy"
                                class="tw-duration-300 position-absolute bottom-0 tw-end-0 z-n1 half-width">
                        </div>
                    </div>

                    <!-- Voice customization -->
                    <div class="col-lg-12 col-sm-6">
                        <div
                            class="group-item position-relative tw-rounded-3xl overflow-hidden z-1 tw-pt-15 h-100 bg-yellow-light tw-px-40-px tw-pb-136-px tw-duration-300 beige-bg">
                            <span class="tw-text-base fw-semibold tw-mb-2 text-pink">Human-like Conversations</span>
                            <p class="splitTextStyleOne tw-mb-5 max-w-330-px custom-header small-heading">
                                Voice Customization
                            </p>
                            <p class="tw-mb-5">
                                Give your brand a voice that fits — customize tone, language, or even clone your own voice for a familiar experience.
                            </p>
                            <a href="#"
                                class="tw-w-15 tw-h-15 d-flex justify-content-center align-items-center rounded-circle tw-text-2xl text-white cadetblue-bg hover--translate-y-1 active--translate-y-scale-9">
                                <i class="ph-bold ph-arrow-up-right"></i>
                            </a>
                            <img src="web/assets/images/continuous-learning.webp" alt="Voice Customization" loading="lazy"
                                class="tw-duration-300 position-absolute bottom-0 tw-end-0 z-n1 half-width">
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <div class="row gy-4">
                    <!-- Automated follow-ups -->
                    <div class="col-lg-12 col-sm-6" data-aos="fade-up" data-aos-anchor-placement="top-bottom"
                        data-aos-duration="600">
                        <div
                            class="group-item position-relative tw-rounded-3xl overflow-hidden z-1 tw-pt-15 h-100 bg-purple-light tw-px-40-px tw-pb-84-px tw-duration-300">
                            <span class="tw-text-base fw-semibold tw-mb-2 text-purple">Stay Connected</span>
                            <p class="splitTextStyleOne tw-mb-5 max-w-318-px custom-header small-heading">
                                Automated Follow-Ups
                            </p>
                            <p class="tw-mb-5">
                                After every call, automatically send texts, reminders, and confirmations to build customer relationships early.
                            </p>
                            <a href="#"
                                class="tw-w-15 tw-h-15 d-flex justify-content-center align-items-center rounded-circle tw-text-2xl text-white burlywood-bg hover--translate-y-1 active--translate-y-scale-9">
                                <i class="ph-bold ph-arrow-up-right"></i>
                            </a>
                            <img src="web/assets/images/dashboard.webp" alt="Automated Follow-Ups" loading="lazy"
                                class="tw-duration-300 position-absolute bottom-0 tw-end-0 z-n1 half-width">
                        </div>
                    </div>

                    <!-- Multi-channel support -->
                    <div class="col-lg-12 col-sm-6" data-aos="fade-up" data-aos-anchor-placement="top-bottom"
                        data-aos-duration="600">
                        <div
                            class="group-item position-relative tw-rounded-3xl overflow-hidden z-1 tw-pt-15 h-100 bg-paste-light tw-px-40-px tw-pb-136-px tw-duration-300">
                            <span class="tw-text-base fw-semibold tw-mb-2 text-pink">Personalized Service</span>
                            <p class="splitTextStyleOne tw-mb-5 max-w-330-px custom-header small-heading">
                                Omnichannel Experience
                            </p>
                            <p class="tw-mb-5">
                                Give customers the same quick, friendly experience across calls, texts, and WhatsApp — all handled by {{ config('app.site') }}.
                            </p>
                            <a href="#"
                                class="tw-w-15 tw-h-15 d-flex justify-content-center align-items-center rounded-circle bg-paste tw-text-2xl text-white hover--translate-y-1 active--translate-y-scale-9">
                                <i class="ph-bold ph-arrow-up-right"></i>
                            </a>
                            <img src="web/assets/images/Scalable-Solution.webp" alt="Omnichannel Experience" loading="lazy"
                                class="tw-duration-300 position-absolute bottom-0 tw-end-0 z-n1 max-width-40">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>



<section class="toolkit-section py-5">
  <div class="container text-center">
    <h4 class="fw-bold mb-3">Let Humans Focus on What AI Can't Do</h4>
    <p class="mb-5">
      While AI handles routine inquiries perfectly, your team can focus on creative problem-solving,
      relationship building, and strategic thinking that truly drives your business forward.
    </p>

    <div class="toolkit-grid">
      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-bolt"></i></div>
        <h4>Boost Productivity</h4>
        <p>Free your team from repetitive questions so they can focus on complex tasks that drive business growth.</p>
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-dollar-sign"></i></div>
        <h4>Reduce Costs</h4>
        <p>Eliminate the need for round-the-clock staffing while providing better customer service than ever before.</p>
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-smile"></i></div>
        <h4>Improve Satisfaction</h4>
        <p>Customers love getting instant, accurate answers. Build loyalty with consistent, helpful service.</p>
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-layer-group"></i></div>
        <h4>Scale Effortlessly</h4>
        <p>Handle thousands of calls simultaneously without hiring additional staff or compromising quality.</p>
      </div>
    </div>
  </div>
</section>


<!-- Font Awesome -->
<script src="https://kit.fontawesome.com/a2d9a67a2b.js" crossorigin="anonymous"></script>

<style>
.toolkit-section {
  background: #f7f7f9; 
  font-family: 'Poppins', sans-serif;
}

.toolkit-grid {
  display: grid;
  grid-template-columns: repeat(auto-fit, minmax(270px, 1fr));
  gap: 25px;
}

.toolkit-item {
  background: #fff;
  border: 1px solid #e5e7eb;
  border-radius: 12px;
  padding: 28px 24px;
  box-shadow: 0 4px 12px rgba(0,0,0,0.04);
  transition: all 0.3s ease;
  cursor: pointer;
}

.toolkit-item:hover {
  border-color: #3b82f6;
  box-shadow: 0 8px 22px rgba(59,130,246,0.1);
  transform: translateY(-4px);
}


.toolkit-item .icon {
  font-size: 30px;
  color: #0a5bff;
  margin-bottom: 18px;
}


.toolkit-item h4 {
  font-size: 18px;
  font-weight: 600;
  margin-bottom: 10px;
  color: #000;
}

.toolkit-item p {
  font-size: 15px;
  color: #444;
  line-height: 1.6;
}

@media (max-width: 768px) {
  .toolkit-item {
    padding: 22px 18px;
  }
}
</style>





<section class="faq-two py-50 bg-aliceblue">
  <div class="container">
    <div class="row gy-4">
      <div class="col-lg-12 text-center">
        <h3 class="splitTextStyleOne text-heading text-capitalize heading-medium">
          Understand AI Receptionist before you decide
        </h3>
      </div>

      <div class="col-lg-12">
        <div class="accordion common-accordion style-two arrow-bg-orange" id="accordionExample">

          <!-- Q1 -->
          <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-blue border-0 mb-3" data-aos="fade-up">
            <h3 class="accordion-header">
              <button class="accordion-button shadow-none bg-transparent h5 fw-bold" type="button"
                data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="true"
                aria-controls="collapseOne">
                Key features of AI receptionist
              </button>
            </h3>
            <div id="collapseOne" class="accordion-collapse collapse show" data-bs-parent="#accordionExample">
              <div class="accordion-body tw-mt-605 text-start">
                <ul class="list-unstyled tw-space-y-3">
                  <li><strong>24/7 call answering and lead capture, no matter the volume:</strong>  
                    An AI receptionist never sleeps. Whether it’s 2 AM or during holidays, all inbound calls are answered immediately — no missed opportunities. It listens, asks follow-up questions, and logs details directly to your CRM.
                  </li>
                  <li><strong>AI appointment scheduling and automated reminders:</strong>  
                    LeadMine.pro’s AI syncs with Google Calendar, Microsoft 365, and others. It checks real-time availability, prevents double bookings, and sends branded SMS/email reminders.
                  </li>
                  <li><strong>Intelligent call routing and escalation:</strong>  
                    Routes calls using sentiment and intent detection, ensuring urgent clients reach the right person instantly.
                  </li>
                  <li><strong>Multi-language and local dialect support:</strong>  
                    Auto-detects language, accent, and dialect for natural multilingual communication.
                  </li>
                  <li><strong>Analytics, reporting, insights:</strong>  
                    Dashboards show total calls, peak hours, sentiment trends, and ROI.
                  </li>
                  <li><strong>Personalization and brand consistency:</strong>  
                    Custom AI voices greet customers by name with consistent tone and quality.
                  </li>
                </ul>
              </div>
            </div>
          </div>

          <!-- Q2 -->
          <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-blue border-0 mb-3" data-aos="fade-up">
            <h3 class="accordion-header">
              <button class="accordion-button shadow-none bg-transparent h5 fw-bold collapsed" type="button"
                data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="false"
                aria-controls="collapseTwo">
                Benefits of AI receptionist
              </button>
            </h3>
            <div id="collapseTwo" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
              <div class="accordion-body tw-mt-605 text-start">
                <ul class="list-unstyled tw-space-y-3">
                  <li><strong>Immediate lead capture:</strong> Qualifies prospects and updates CRM instantly.</li>
                  <li><strong>Lower staffing overhead:</strong> Costs <em>80% less</em> than hiring in-house receptionists.</li>
                  <li><strong>Scalability:</strong> Handles surge traffic automatically during busy seasons.</li>
                  <li><strong>Instant, human-like conversation:</strong> No robotic menus, just natural dialogue.</li>
                  <li><strong>Faster resolutions:</strong> Pulls client data from CRM for instant context.</li>
                  <li><strong>Standardized quality:</strong> Maintains consistent tone and response accuracy.</li>
                </ul>
                <p class="mt-3"><strong>Example:</strong> MegaShop’s switch to LeadMine.pro’s AI receptionist boosted customer satisfaction by 18% within 4 weeks.</p>
              </div>
            </div>
          </div>

          <!-- Q3 -->
          <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-blue border-0 mb-3" data-aos="fade-up">
            <h3 class="accordion-header">
              <button class="accordion-button shadow-none bg-transparent h5 fw-bold collapsed" type="button"
                data-bs-toggle="collapse" data-bs-target="#collapseThree" aria-expanded="false"
                aria-controls="collapseThree">
                Industry use cases of AI receptionists
              </button>
            </h3>
            <div id="collapseThree" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
              <div class="accordion-body tw-mt-605 text-start">
                <ul class="list-unstyled tw-space-y-3">
                  <li><strong>Healthcare & Dental:</strong> HIPAA-compliant 24/7 appointment and follow-up handling.</li>
                  <li><strong>Home Services:</strong> Instantly captures emergency requests and routes jobs.</li>
                  <li><strong>Car Services:</strong> Schedules repairs, test drives, and breakdown support.</li>
                  <li><strong>Legal & Accounting:</strong> Manages consultations and sensitive data securely.</li>
                  <li><strong>Hospitality:</strong> Handles reservations, guest inquiries, and upgrades.</li>
                  <li><strong>Insurance & Finance:</strong> Processes claims, renewals, and fraud escalations automatically.</li>
                </ul>
              </div>
            </div>
          </div>

          <!-- Q4 -->
          <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-blue border-0 mb-3" data-aos="fade-up">
            <h3 class="accordion-header">
              <button class="accordion-button shadow-none bg-transparent h5 fw-bold collapsed" type="button"
                data-bs-toggle="collapse" data-bs-target="#collapseFour" aria-expanded="false"
                aria-controls="collapseFour">
                Real-life case studies
              </button>
            </h3>
            <div id="collapseFour" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
              <div class="accordion-body tw-mt-605 text-start">
                <ul class="list-unstyled tw-space-y-3">
                  <li><strong>Claro Insurance:</strong> Boosted support team efficiency with LeadMine.pro’s analytics and integrations.</li>
                  <li><strong>GoStudent:</strong> Reduced lead response time by 12% using automated workflows.</li>
                  <li><strong>Avalon Pharmacy:</strong> Decreased inbound call volume by 40% and saved 2+ hours daily per agent.</li>
                </ul>
              </div>
            </div>
          </div>

          <!-- Q5 -->
          <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-blue border-0 mb-3" data-aos="fade-up">
            <h3 class="accordion-header">
              <button class="accordion-button shadow-none bg-transparent h5 fw-bold collapsed" type="button"
                data-bs-toggle="collapse" data-bs-target="#collapseFive" aria-expanded="false"
                aria-controls="collapseFive">
                What is the best AI receptionist in the market?
              </button>
            </h3>
            <div id="collapseFive" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
              <div class="accordion-body tw-mt-605 text-start">
                <p>The best AI receptionist depends on your business type. Here’s a quick comparison:</p>
                <ul class="list-unstyled tw-space-y-2 mt-2">
                  <li><strong>LeadMine.pro AI Voice Agent:</strong> 24/7 support, CRM integrations, multilingual, analytics, and custom voice options.</li>
                  <li><strong>OpenPhone Sona:</strong> Simple, affordable unified inbox with API automation.</li>
                  <li><strong>Smith.ai:</strong> Hybrid AI + human agents, bilingual, strong CRM support.</li>
                  <li><strong>TrueLark:</strong> Healthcare-focused automation with EHR integrations.</li>
                  <li><strong>Air.ai:</strong> Customizable voice and flow options for tech-driven teams.</li>
                </ul>
              </div>
            </div>
          </div>

          <!-- Q6 -->
          <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-blue border-0 mb-3" data-aos="fade-up">
            <h3 class="accordion-header">
              <button class="accordion-button shadow-none bg-transparent h5 fw-bold collapsed" type="button"
                data-bs-toggle="collapse" data-bs-target="#collapseSix" aria-expanded="false"
                aria-controls="collapseSix">
                How to set up an AI receptionist for your business
              </button>
            </h3>
            <div id="collapseSix" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
              <div class="accordion-body tw-mt-605 text-start">
                <ol class="list-decimal tw-space-y-2 ps-4">
                  <li><strong>Create an account:</strong> Sign up with LeadMine.pro and connect your phone number.</li>
                  <li><strong>Set up basics:</strong> Define hours, departments, and call flow.</li>
                  <li><strong>Define rules:</strong> Decide which calls AI handles vs. human routing.</li>
                  <li><strong>Integrate calendars & CRMs:</strong> Sync Google/Outlook and CRM tools.</li>
                  <li><strong>Customize voices & scripts:</strong> Match tone to your brand identity.</li>
                  <li><strong>Test & train:</strong> Run simulations before full deployment.</li>
                  <li><strong>Go live & optimize:</strong> Monitor reports, refine triggers, and scale.</li>
                </ol>
              </div>
            </div>
          </div>

          <!-- Q7 -->
          <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-transparent border-0" data-aos="fade-up">
            <h3 class="accordion-header">
              <button class="accordion-button shadow-none bg-transparent h5 fw-bold collapsed" type="button"
                data-bs-toggle="collapse" data-bs-target="#collapseSeven" aria-expanded="false"
                aria-controls="collapseSeven">
                Summary
              </button>
            </h3>
            <div id="collapseSeven" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
              <div class="accordion-body tw-mt-605 text-start">
                <p>
                  LeadMine.pro’s AI receptionist automates call answering, scheduling, and lead management —
                  ensuring every inquiry is handled efficiently. Combining natural conversation with integrations
                  and analytics, it helps businesses reduce missed calls, improve customer experience, and scale
                  effortlessly.
                </p>
              </div>
            </div>
          </div>

        </div>
      </div>
    </div>
  </div>
</section>

<style>
.faq-two .accordion-body {
  margin-top: 0 !important;   
  padding-top: 10px !important; 
  font-size: 17px;
  line-height: 1.9;
  color: #333;
  text-align: left;
}


.faq-two .accordion-button {
  font-size: 22px;
  font-weight: 700;
  color: #0b1727;
  text-align: left;
  letter-spacing: 0.3px;
  padding: 10px 0;              
}


.faq-two .accordion-button:not(.collapsed) {
  color: #0056d6;
}


.faq-two ul {
  padding-left: 1.5rem;
  list-style-type: disc;
}
.faq-two ol {
  padding-left: 1.5rem;
  list-style-type: decimal;
}
.faq-two li {
  margin-bottom: 0.6rem;
}


.faq-two .accordion-item {
  background: #fff;
  border-radius: 14px;
  margin-bottom: 12px;       
  transition: all 0.3s ease;
}


.faq-two .accordion-body.tw-mt-605 {
  margin-top: 0 !important;
}
</style>






 


 
     <section class="integrations-section">
  <div class="container">
    <h2 class="section-title">Fits seamlessly into your tech stack</h2>

    <div class="integration-logos">
      <div class="logo-box">
        <img src="web/assets/images/hubspot.svg" alt="HubSpot">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/salesforce.svg" alt="Salesforce">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/pipedrive.svg" alt="Pipedrive">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/slack.svg" alt="Slack">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/intercom.svg" alt="Intercom">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/zendesk-icon.svg" alt="Zendesk">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/zoho.svg" alt="Zoho">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/outreach.webp" alt="Outreach">
      </div>
    </div>

    <!-- <div class="btn-wrapper">
      <a href="{{ route('register') }}" class="view-btn">Start free trial</a>
    </div> -->
  </div>
</section>


<style>
.integrations-section {
  text-align: center;
  padding: 80px 20px;
  background-color: #fff;
}

.integrations-section .section-title {
  font-size: 32px;
  font-weight: 700;
  color: #0b0c2a;
  margin-bottom: 50px;
}

.integration-logos {
  display: flex;
  flex-wrap: wrap;
  justify-content: center;
  gap: 25px;
  margin-bottom: 50px;
}

.logo-box {
  width: 140px;
  height: 140px;
  background: #fff;
  border-radius: 20px;
  box-shadow: 0 0 0 1px #e5e7eb;
  display: flex;
  align-items: center;
  justify-content: center;
  transition: all 0.3s ease;
}

.logo-box img {
  width: 60px;
  height: auto;
  transition: transform 0.3s ease;
}

.logo-box:hover {
  transform: translateY(-8px);
  box-shadow: 0 8px 25px rgba(0, 0, 0, 0.08);
}

.logo-box:hover img {
  transform: scale(1.1);
}

.view-btn {
  display: inline-block;
  background-color: #0052ff;
  color: #fff;
  font-weight: 600;
  padding: 14px 28px;
  border-radius: 8px;
  text-decoration: none;
  transition: background 0.3s ease;
}

.view-btn:hover {
  background-color: #003ed6;
}

.btn-wrapper {
  margin-top: 20px;
}



#ai-coach .splitTextStyleOne.custom-centered-title,
#ai-coach .custom-header.small-heading {
    font-weight: 700; 
}


#ai-coach .splitTextStyleOne.custom-centered-title {
    font-size: 1.5rem; 
    line-height: 1.2;
}

#ai-coach .custom-header.small-heading {
    font-size: 1.06rem;  
    line-height: 1.4;
}

</style>




 @endsection