@extends('website.layout')

@section('meta')
<title>Best AI Call Scoring Tool | {{ config('app.site') }}</title>
<meta name="description"
    content="{{ config('app.site') }} offers the Best AI Call Scoring Tool to evaluate 100% of calls, track compliance, measure sentiment, and improve customer experience.">
<meta name="keywords"
    content="AI call scoring tool, Best AI call scoring tool, AI call scoring">

{{-- Open Graph --}}
<meta property="og:title" content="Best AI Call Scoring Tool | {{ config('app.site') }}">
<meta property="og:description"
    content="{{ config('app.site') }} offers the Best AI Call Scoring Tool to evaluate 100% of calls, track compliance, measure sentiment, and improve customer experience.">
<meta property="og:image" content="{{ asset('assets/images/ai-call-scoring-tool.webp') }}">
<meta property="og:type" content="website">
<meta property="og:url" content="{{ url()->current() }}">

{{-- Twitter / X --}}
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Best AI Call Scoring Tool | {{ config('app.site') }}">
<meta name="twitter:description"
    content="{{ config('app.site') }} offers the Best AI Call Scoring Tool to evaluate 100% of calls, track compliance, measure sentiment, and improve customer experience.">
<meta name="twitter:image" content="{{ asset('assets/images/ai-call-scoring-tool.webp') }}">

{{-- Extra Tags --}}
<meta name="tags"
    content="AI call scoring tool, Best AI call scoring tool, AI call scoring software, AI call analytics, {{ config('app.site') }} AI call scoring">


{{-- Blog Schema --}}
<script type="application/ld+json">
{
    "@context": "https://schema.org",
    "@type": "WebPage",
    "name": "Best AI Call Scoring Tool | CallChex",
    "url": "https://callchex.com/best-ai-call-scoring-tool",
    "description": "CallChex offers the Best AI Call Scoring Tool to evaluate 100% of calls, track compliance, measure sentiment, and improve customer experience.",
    "image": "https://callchex.com/assets/images/ai-call-scoring-tool.webp",
    "publisher": {
        "@type": "Organization",
        "name": "CallChex",
        "logo": {
            "@type": "ImageObject",
            "url": "https://callchex.com/assets/img/logo.webp"
        }
    }
}
</script>



{{-- Organization Schema --}}
<script type="application/ld+json">
{
    "@context": "https://schema.org",
    "@type": "Organization",
    "name": "Callchex",
    "url": "https://callchex.com",
    "logo": "https://callchex.com/assets/img/logo.webp",
    "contactPoint": {
        "@type": "ContactPoint",
        "telephone": "+1 (902) 441-2385",
        "contactType": "customer service",
        "areaServed": "US",
        "availableLanguage": "en"
    },
    "sameAs": [
        "https://www.linkedin.com/company/callchex/about/?viewAsMember=true",
        "https://www.instagram.com/callchex/",
        "https://www.facebook.com/photo/?fbid=122187799220363616&set=a.122187296186363616",
        "https://callchex.com"
    ]
}
</script>
@endsection



@section('content')


<style>
    
.ai-section {
  background: #0b0b0b; 
  color: #fff;
  padding: 50px 0;
}

.sub-heading {
  font-size: 1.4rem;
  font-weight: 600;
  margin-bottom: 6px; 
}

.section-text {
  font-size: 1rem;
  line-height: 1.6;
  margin-bottom: 8px;
  max-width: 440px;  
  text-align: left; 
}


.section-list {
  padding-left: 18px;
  margin-bottom: 8px;
}

.section-list li {
  margin-bottom: 5px;
  list-style: disc;
}

.section-link {
  color: #4e9eff;
  font-weight: 600;
  text-decoration: none;
}

.section-link:hover {
  text-decoration: underline;
}


.section-img {
  max-width: 490px;
  width: 100%;
  height: auto;
  border-radius: 6px;
  box-shadow: 0 3px 12px rgba(0,0,0,0.25);
  margin: 0 auto;
}


.tab-container {
    display: flex;
    /* max-width: 1000px; */
    padding: 40px;
    margin: auto;
    /* background: #fff; */
    /* border-radius: 8px; */
    overflow: hidden;
    /* box-shadow: 0 2px 8px rgba(0,0,0,0.1); */
}

.tab-buttons {
    width: 35%;
    border: 1px solid #ddd;
    background: #f4f6f8;
    border-radius: 10px;
}

.tab-buttons button {
    display: block;
    width: 100%;
    padding: 15px;
    border: none;
    background: none;
    text-align: left;
    cursor: pointer;
    font-size: 15px;
    border-bottom: 1px solid #ddd;
    color: #333;
    transition: background 0.2s, color 0.2s;
}

.tab-buttons button:hover {
    background: #eaeef3;
}

.tab-buttons button.active {
    background: #fff;
    color: #007bff;
    font-weight: bold;
}

.tab-content {
    width: 65%;
    padding: 20px;
}

.tab-content h2 {
    font-size: 20px;
    margin-bottom: 12px;
}

.tab-content p {
    line-height: 1.6;
    color: #444;
    white-space: pre-line;
}

.tab-content ul {
    margin: 10px 0 0 20px;
}

.custom-paragraph {
    margin-left: auto;
    margin-right: auto;
}

.paragraph-style {
    font-weight: 400;
    font-size: 18px;
}

.centered-small-paragraph {
    font-weight: 400;
    font-size: 16px;
    max-width: 228px;
    margin-left: auto;
    margin-right: auto;
}

.pt-40 {
    padding-top: 40px;
}

.bg-aliceblue {
    background-color: aliceblue;
}

.visually-hidden {
    position: absolute;
    width: 1px;
    height: 1px;
    padding: 0;
    margin: -1px;
    overflow: hidden;
    clip: rect(0, 0, 0, 0);
    white-space: nowrap;
    border: 0;
}

.content-box h1 {
    font-size: 2.5rem;
    color: #0d3c7d;
    line-height: 1.3;
}

.content-box p.lead {
    font-size: 1.1rem;
    color: #444;
}

.subheadline {
    font-size: 1rem;
    color: #666;
}

.btn-main {
    background: linear-gradient(90deg, #9333EA, #3B82F6);
    color: #fff;
    border: none;
    transition: 0.3s;
}

.btn-main:hover {
    opacity: 0.9;
}

.hero-image {
    max-width: 100%;
    width: 500px;
    height: auto;
}


</style>

<div id="smooth-content">
    <!-- ================================ Distraction page start ====================================== -->
    <section class="section-bg-two  overflow-hidden" style="padding:40px;">
        <div class="container max-w-1290-px">
            <div class="row gy-5 align-items-center">

                <!-- Left Content -->
                <div class="col-xl-6 col-lg-6 col-md-12">
                    <div class="content-box">

                        <!-- Main Heading -->
                        <h2 class="fw-bold mb-3" style="font-size:2.2rem; line-height:1.3;">
                            Save Hundreds of Coaching Hours with the Best AI Call Scoring Tool.
                        </h2>

                        <!-- Subheading Paragraph -->
                        <p class="text-secondary mb-4" style="font-size:1.05rem;">
                            Get instant AI-generated scores for every call. Automatically evaluate agent performance
                            based on skills, compliance, sentiment, and brand process adherence. Skip lengthy manual
                            reviews assess performance instantly with {{ config('app.site') }}, the best AI call scoring tool for
                            growing teams. </p>

                        <!-- Button -->
                        <a href="{{ route('register') }}" class="btn btn-main px-5 py-3 rounded-pill fw-semibold">
                            Register Today
                        </a>
                    </div>
                </div>



                <!-- Right Hero Image -->
                <div class="col-xl-6 col-lg-6 col-md-12 text-center">
                    <img src="{{ asset('assets/images/ai-call-scoring-tool.webp') }}"
                        alt="AI Call Analytics for Real Estate in USA dashboard view" class="hero-image">
                </div>


            </div>
        </div>
    </section>


  <style>
    body {
      font-family: Arial, sans-serif;
      background: #f9fafb;
      margin: 0;
      padding: 0;
    }

    .testimonial-section {
      max-width: 1100px;
      margin: 0 auto;
      padding: 50px 20px;
      text-align: center;
    }

    .testimonial-section h2 {
      font-size: 28px;
      font-weight: bold;
      color: #333;
      margin-bottom: 40px;
    }

    .testimonial-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
      gap: 20px;
    }

    .testimonial-card {
      background: #fff;
      border-radius: 12px;
      padding: 20px;
      box-shadow: 0 4px 12px rgba(0,0,0,0.08);
      text-align: left;
      transition: transform 0.3s;
    }

    .testimonial-card:hover {
      transform: translateY(-5px);
    }

    .testimonial-header {
      display: flex;
      align-items: center;
      margin-bottom: 15px;
    }

    .avatar {
      width: 50px;
      height: 50px;
      border-radius: 50%;
      background: #6c63ff;
      color: #fff;
      font-weight: bold;
      font-size: 18px;
      display: flex;
      align-items: center;
      justify-content: center;
    }

    .user-info {
      margin-left: 12px;
    }

    .user-info h3 {
      margin: 0;
      font-size: 16px;
      font-weight: 600;
      color: #222;
    }

    .user-info p {
      margin: 0;
      font-size: 13px;
      color: #777;
    }

    .testimonial-text {
      font-size: 15px;
      line-height: 1.6;
      color: #555;
    }
  </style>


  <section class="testimonial-section">
    <h2>Here’s what our customers have to say</h2>
    <div class="testimonial-grid">

      <!-- Card 1 -->
      <div class="testimonial-card">
        <div class="testimonial-header">
          <div class="avatar">A</div>
          <div class="user-info">
            <h3>Ananya Sharma</h3>
            <p>Customer</p>
          </div>
        </div>
        <p class="testimonial-text">
          “With {{ config('app.site') }}, we finally found the best AI call scoring tool.
          It saves us hours of manual QA every week while giving us deeper insights into customer sentiment.”
        </p>
      </div>

      <!-- Card 2 -->
      <div class="testimonial-card">
        <div class="testimonial-header">
          <div class="avatar" style="background:#3b82f6;">D</div>
          <div class="user-info">
            <h3>David Miller</h3>
            <p>Customer</p>
          </div>
        </div>
        <p class="testimonial-text">
          “Before {{ config('app.site') }}, our coaches were drowning in call recordings.
          Now, every call is scored instantly, and we can focus only on the areas that matter.
          The improvement in agent performance is unbelievable.”
        </p>
      </div>

      <!-- Card 3 -->
      <div class="testimonial-card">
        <div class="testimonial-header">
          <div class="avatar" style="background:#10b981;">P</div>
          <div class="user-info">
            <h3>Priya Nair</h3>
            <p>Customer</p>
          </div>
        </div>
        <p class="testimonial-text">
          “Compliance was always our biggest concern. {{ config('app.site') }} not only flagged issues instantly
          but also helped us reduce compliance risks by over 40% in just a few months.
          Truly the best AI call scoring tool for regulated industries.”
        </p>
      </div>

    </div>
  </section>




    <!-- ================== Driven section Start ====================== -->


    <section class="ai-section py-5">
        <div class="container">


            <h3 class="sub-heading text-center mb-3">

                Advanced Scoring Metrics for Unmatched Insights

            </h3>

            <!-- Section 1: Lead Qualification -->
            <div class="row align-items-center mb-5 custom-gap-fix">
                <!-- Left Content -->
                <div class="col-lg-6">
                    <p class="section-text">
                        Evaluate every single call and assign it a score based on multiple factors skills, sentiment,
                        compliance, and brand adherence. With {{ config('app.site') }}, administrators can effortlessly measure and
                        improve agent performance at scale.
                    </p>
                    <ul class="section-list">
                        <li>Empathy & sentiment detection</li>
                        <li>Silence and dead air tracking</li>
                        <li>Talk–listen ratio</li>
                        <li>Script adherence & compliance keywords</li>
                        <li>Filler word usage and monologue behavior</li>
                        <li>Customer satisfaction & tone analysis</li>
                    </ul>
                    <a href="https://callchex.com/blogs/call-quality-monitoring-tool" class="section-link">
                        🔗Learn more in our guide on call quality monitoring tools.
                    </a>
                </div>

                <!-- Right Image -->
                <div class="col-lg-6 text-center">
                    <img src="{{ asset('assets/images/ai-call-scoring-tool.webp') }}"
                        alt="AI software identifying high-intent real estate buyers from calls"
                        class="img-fluid section-img">
                </div>
            </div>

            <!-- Section 2: Agent Performance -->
            <h3 class="sub-heading text-center mb-3">Customized Coaching Plans</h3>
            <div class="row align-items-center mb-5 flex-row-reverse">
                <div class="col-lg-6">
                    <p class="section-text">
                        Build personalized coaching plans
                        Coach with intention, not intuition. Use AI-generated call scores from the best AI call scoring
                        tool to design coaching programs that target real performance gaps.

                    </p>
                    <ul class="section-list">
                        <li>Identify each agent’s strengths and weaknesses instantly</li>
                        <li>Align coaching goals with business KPIs</li>
                        <li>Deliver personalized guidance that drives measurable improvement</li>

                    </ul>
                    <a href="https://callchex.com/blogs/agent-coaching-ai" class="section-link">🔗
                        Check out how AI enables better agent coaching.</a>
                </div>
                <div class="col-lg-6 text-center">
                    <img src="{{ asset('assets/images/ai-call-scoring-1.webp') }}"
                        alt="Real estate call center agents improving performance with AI insights"
                        class="img-fluid section-img">
                </div>
            </div>



        </div>
    </section>

    <!-- ================== Driven section End ====================== -->

    <style>
    .tab-container {
        display: flex;
        max-width: 1200px;
        margin: 50px auto;
        background: #fff;
        border-radius: 12px;
        box-shadow: 0 2px 12px rgba(0, 0, 0, 0.1);
        overflow: hidden;
    }

    .tab-buttons {
        flex: 0 0 280px;
        background: #f4f5f7;
        display: flex;
        flex-direction: column;
        border-right: 1px solid #e5e7eb;
    }

    .tab-buttons button {
        padding: 18px;
        border: none;
        background: transparent;
        text-align: left;
        font-size: 15px;
        cursor: pointer;
        border-left: 4px solid transparent;
        transition: all 0.3s ease;
    }

    .tab-buttons button.active {
        background: #fff;
        font-weight: 600;
        border-left: 4px solid #6366f1;
        color: #111827;
    }

    .tab-buttons button:hover {
        background: #e0e7ff;
    }

    .tab-content {
        flex: 1;
        padding: 30px;
    }

    .tab-content h2 {
        font-size: 22px;
        margin-bottom: 15px;
        color: #111827;
    }

    .tab-content p,
    .tab-content li {
        font-size: 15px;
        line-height: 1.6;
        color: #374151;
    }

    .tab-content ul {
        padding-left: 18px;
    }

    @media (max-width: 768px) {
        .tab-container {
            flex-direction: column;
        }

        .tab-buttons {
            flex-direction: row;
            overflow-x: auto;
        }

        .tab-buttons button {
            flex: 1;
            text-align: center;
            border-left: none;
            border-bottom: 3px solid transparent;
        }

        .tab-buttons button.active {
            border-left: none;
            border-bottom: 3px solid #6366f1;
        }
    }
    </style>

    <section>
        <div class="tab-container">
            <div class="tab-buttons">
             
                <button class="active" >Benefits of AI Call Scoring</button>
                <button onclick="showTab(1)">Five Tips to Benefit</button>
                <button onclick="showTab(2)">Improve Sales Performance</button>
                <button onclick="showTab(3)">Personalized Coaching</button>
                <button onclick="showTab(4)">How It Works</button>
            </div>

            <div class="tab-content" id="tab-content">
                <!-- Dynamic content will load here -->
            </div>
        </div>

        <script>
        const tabData = [
            {
                title: "Benefits of AI Call Scoring",
                content: `
      <p>With {{ config('app.site') }}, the best AI call scoring tool, businesses can finally eliminate the guesswork in quality monitoring. Instead of spending hours reviewing random calls, managers get instant visibility into every single conversation. AI automatically evaluates performance, sentiment, empathy, and compliance, allowing leaders to focus on actionable improvements rather than tedious manual reviews. This not only saves time but also ensures consistent, unbiased scoring across the entire team.</p>
    `
            },
            {
                title: "Five Tips on How to Fully Benefit from Call Scoring",
                content: `
      <p>To maximize benefits from AI call scoring:</p>
      <ul>
        <li>1.To get the most out of AI call scoring, it’s important to use the insights regularly and with intention. </li>
        <li>2.Managers should consistently review the scores and dashboards to identify patterns in agent behavior.</li>
        <li>3.Instead of treating scores as criticism, positioning them as tools for growth encourages a positive learning environment. </li>
        <li>4.Real-time AI prompts during calls help agents adjust on the spot, improving customer interactions immediately rather than days later. </li>
        <li>5.At the same time, celebrating high-performing agents motivates the team and reinforces best practices, ensuring that improvements are sustained over time.</li>
      </ul>
      <p>👉 Discover more about <a href="https://callchex.com/blogs/conversation-analytics-software"> conversation analytics software.</a></p>
    `
            },
            {
                title: "How Can Managers Use Auto Call Scoring to Improve Sales Performance?",
                content: `
      <p>Managers can use automatic call scoring to gain clarity into which sales behaviors drive results. By analyzing objection handling, tone, and closing techniques across top-performing agents, {{ config('app.site') }} highlights exactly what leads to successful outcomes. These insights allow managers to refine scripts, provide focused coaching, and replicate winning strategies across the team. Because feedback is instant, managers no longer need to wait for lengthy review cycles; they can help agents adapt during live calls and improve sales performance in real time.</p>
     
      <p>👉Read more about <a href="https://callchex.com/blogs/sales-call-analysis-software">sales performance insights.</a></p>
    `
            },
            {
                title: "How to Find Personalized Coaching Opportunities with AI Call Scoring?",
                content: `
      <p>One of the biggest advantages of the <strong>best AI call scoring tool</strong> is its ability to highlight personalized coaching opportunities. Instead of generic training sessions, managers can focus on the exact areas where an agent struggles whether it’s empathy, listening balance, filler words, or compliance adherence.</p><p> Over time, progress is tracked through improved scores, making coaching measurable and targeted. This level of personalization creates a stronger learning culture and accelerates agent development far more effectively than traditional coaching methods.</p>
    `
            },
            {
                title: "How Does {{ config('app.site') }} AI Call Scoring Work?",
                content: `
      <p>{{ config('app.site') }} makes AI call scoring simple and powerful. Once integrated with your telephony or CRM system, the platform automatically listens to and analyzes every conversation. Within seconds, each call is transcribed, scored, and flagged for key insights such as sentiment shifts, compliance issues, or script adherence. Agents and managers receive instant feedback through live prompts and post-call dashboards, ensuring that improvements can be made immediately. With this continuous cycle of evaluation and coaching, {{ config('app.site') }} empowers teams to deliver better conversations, stronger compliance, and higher conversions making it the best AI call scoring tool for modern businesses.</p>
      <ul>
       <li> 👉<a href="https://callchex.com/blogs/real-time-monitoring-call-center">Real-time monitoring</a></li>
        <li>👉<a href="https://callchex.com/blogs/call-center-analytics-software">Call center analytics software</a></li>
        <li>👉<a href="https://callchex.com/blogs/speech-analytics-software-for-call-centers">Speech analytics for call centers</a></li>
      </ul>
      
    `
            }
        ];

        function showTab(index) {
            const buttons = document.querySelectorAll('.tab-buttons button');
            buttons.forEach(btn => btn.classList.remove('active'));
            buttons[index].classList.add('active');

            const content = document.getElementById('tab-content');
            content.innerHTML = `
    <h2>${tabData[index].title}</h2>
    ${tabData[index].content}
  `;
        }

        // Initialize first tab
        showTab(0);
        </script>
    </section>



    <!-- ================================ Distraction page End ====================================== -->

    <section class="callchex-section py-50">
        <div class="container max-w-1200-px">
            <!-- Heading -->
            <div class="text-center mb-5">
                <h2 class="fw-bold" style="font-size:2.2rem; font-family:'Poppins', sans-serif;">
                    Turn AI Scores into Agent Success Stories
                </h2>
                <!-- <p class="lead text-muted mt-3"
                    style="max-width:800px; margin:0 auto; font-size:1.1rem; font-family:'Jost', sans-serif;">
                    Real estate call centers handle high volumes of inquiries every day—buyers, sellers,
                    and tenants looking for quick answers. With {{ config('app.site') }}, you can turn these
                    conversations
                    into opportunities using AI Call Analytics for Real Estate.
                </p> -->
            </div>

            <!-- Cards -->
            <div class="row g-4">
                <div class=" col-md-6">
                    <div class="info-card">
                        <h3 class="info-title">Boost agent communication skills with AI call analytics</h3>
                        <p class="info-text">
                            Every conversation holds insights. With AI call analytics, you can evaluate tone, sentiment,
                            empathy, filler words, and dead air to identify strengths and weaknesses. This helps agents
                            refine their communication style and build stronger client relationships.
                        </p>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="info-card">
                        <h3 class="info-title">Ensure brand consistency with call quality monitoring</h3>
                        <p class="info-text">
                            Maintaining a consistent brand voice is critical for customer trust. Our advanced call
                            quality monitoring checks script adherence, speaking pace, and message clarity while
                            ensuring agents deliver your brand’s values in every interaction.
                        </p>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="info-card">
                        <h3 class="info-title">Personalized agent training with sales call analysis</h3>
                        <p class="info-text">
                            AI-powered sales call analysis highlights top-performing conversations, giving managers
                            data-backed insights to design personalized coaching sessions. Agents learn faster, improve
                            productivity, and close more deals with targeted guidance.
                        </p>
                    </div>
                </div>
                <div class=" col-md-6">
                    <div class="info-card">
                        <h3 class="info-title">Save time with AI-driven call scoring</h3>
                        <p class="info-text">
                            Manual evaluations take hours. With AI-driven call scoring, you can automatically review
                            hundreds of calls in minutes. Managers get accurate performance metrics, making it easier to
                            manage large teams and focus on strategic improvements.
                        </p>
                    </div>
                </div>



            </div>



        </div>
    </section>

    <style>
    .callchex-section {
        background: #fff;
    }

    .info-card {
        background: #fff;
        border-radius: 12px;
        padding: 25px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        height: 100%;
        text-align: center;
        transition: all 0.3s ease;
    }

    .info-card:hover {
        box-shadow: 0 6px 16px rgba(0, 0, 0, 0.12);
        transform: translateY(-4px);
    }

    .info-title {
        font-family: 'Poppins', sans-serif;
        font-weight: 600;
        font-size: 1.1rem;
        margin-bottom: 12px;
        background: linear-gradient(90deg, #e91e63, #3f51b5);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
    }

    .info-text {
        font-family: 'Jost', sans-serif;
        font-size: 0.95rem;
        color: #444;
        line-height: 1.6;
    }
    </style>

    <section class="faq-two py-50 bg-aliceblue">
        <div class="container">
            <div class="row gy-4">
                <div class="col-lg-12 d-flex">
                    <div class="m-auto ">
                        <h1 class="visually-hidden">Frequently ask Questions</h1>
                        <h3 class="splitTextStyleOne text-heading text-capitalize heading-medium">
                            Frequently ask Questions

                        </h3>



                    </div>
                </div>
                <div class="col-lg-12">
                    <div class="ps-xl-5">
                        <div class="accordion common-accordion style-two arrow-bg-orange" id="accordionExample">

                            <!-- Q1 -->
                            <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-transparent border-0 mb-0"
                                data-aos="fade-up">
                                <h3 class="accordion-header d-flex align-items-center justify-content-between tw-gap-3">
                                    <button class="accordion-button shadow-none p-0 line-clamp-3 bg-transparent h5"
                                        type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne"
                                        aria-expanded="true" aria-controls="collapseOne">
                                        What is call scoring in sales?
                                    </button>
                                </h3>
                                <div id="collapseOne" class="accordion-collapse collapse show"
                                    data-bs-parent="#accordionExample">
                                    <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                                        <p class="text-neutral-500 tw-leading-212 heading-medium">
                                            Call scoring helps evaluate agent performance and customer interactions.
                                            With {{ config('app.site') }} AI call scoring, businesses can easily track quality,
                                            compliance, and sales effectiveness.</p>
                                    </div>
                                </div>
                            </div>

                            <!-- Q2 -->
                            <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-transparent border-0 mb-0"
                                data-aos="fade-up">
                                <h3 class="accordion-header d-flex align-items-center justify-content-between tw-gap-3">
                                    <button
                                        class="accordion-button shadow-none p-0 line-clamp-3 bg-transparent h5 collapsed"
                                        type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo"
                                        aria-expanded="false" aria-controls="collapseTwo">
                                        How does AI improve call monitoring?
                                    </button>
                                </h3>
                                <div id="collapseTwo" class="accordion-collapse collapse"
                                    data-bs-parent="#accordionExample">
                                    <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                                        <p class="text-neutral-500 tw-leading-212 heading-medium">AI automates call
                                            analysis. {{ config('app.site') }} AI call monitoring provides accurate insights, saves
                                            time, and ensures unbiased evaluation.
                                        </p>
                                    </div>
                                </div>
                            </div>

                            <!-- Q3 -->
                            <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-transparent border-0 mb-0"
                                data-aos="fade-up">
                                <h3 class="accordion-header d-flex align-items-center justify-content-between tw-gap-3">
                                    <button
                                        class="accordion-button shadow-none p-0 line-clamp-3 bg-transparent h5 collapsed"
                                        type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree"
                                        aria-expanded="false" aria-controls="collapseThree">
                                        Can call scoring help with agent training?
                                    </button>
                                </h3>
                                <div id="collapseThree" class="accordion-collapse collapse"
                                    data-bs-parent="#accordionExample">
                                    <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                                        <p class="text-neutral-500 tw-leading-212 heading-medium">Yes. {{ config('app.site') }} call
                                            scoring software identifies coaching opportunities and helps managers
                                            improve team performance.</p>
                                    </div>
                                </div>
                            </div>

                            <!-- Q4 -->
                            <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-transparent border-0 mb-0"
                                data-aos="fade-up">
                                <h3 class="accordion-header d-flex align-items-center justify-content-between tw-gap-3">
                                    <button
                                        class="accordion-button shadow-none p-0 line-clamp-3 bg-transparent h5 collapsed"
                                        type="button" data-bs-toggle="collapse" data-bs-target="#collapseFour"
                                        aria-expanded="false" aria-controls="collapseFour">
                                        Why should businesses use automated call scoring?
                                    </button>
                                </h3>
                                <div id="collapseFour" class="accordion-collapse collapse"
                                    data-bs-parent="#accordionExample">
                                    <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                                        <p class="text-neutral-500 tw-leading-212 heading-medium">Automated scoring
                                            saves hours of manual work. {{ config('app.site') }} auto call scoring ensures consistent,
                                            real-time feedback for better sales outcomes.</p>
                                    </div>
                                </div>
                            </div>

                            <!-- Q5 -->
                            <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-transparent border-0 mb-0"
                                data-aos="fade-up">
                                <h3 class="accordion-header d-flex align-items-center justify-content-between tw-gap-3">
                                    <button
                                        class="accordion-button shadow-none p-0 line-clamp-3 bg-transparent h5 collapsed"
                                        type="button" data-bs-toggle="collapse" data-bs-target="#collapseFive"
                                        aria-expanded="false" aria-controls="collapseFive">
                                        Is call scoring accurate with AI?
                                    </button>
                                </h3>
                                <div id="collapseFive" class="accordion-collapse collapse"
                                    data-bs-parent="#accordionExample">
                                    <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                                        <p class="text-neutral-500 tw-leading-212 heading-medium">Yes, AI increases
                                            accuracy. {{ config('app.site') }} AI call scoring evaluates tone, keywords, and compliance
                                            for reliable results.</p>
                                    </div>
                                </div>
                            </div>

                            <!-- Q6 -->
                            <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-transparent border-0 mb-0"
                                data-aos="fade-up">
                                <h3 class="accordion-header d-flex align-items-center justify-content-between tw-gap-3">
                                    <button
                                        class="accordion-button shadow-none p-0 line-clamp-3 bg-transparent h5 collapsed"
                                        type="button" data-bs-toggle="collapse" data-bs-target="#collapseSix"
                                        aria-expanded="false" aria-controls="collapseSix">
                                        What is the main goal of call scoring?
                                    </button>
                                </h3>
                                <div id="collapseSix" class="accordion-collapse collapse"
                                    data-bs-parent="#accordionExample">
                                    <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                                        <p class="text-neutral-500 tw-leading-212 heading-medium">To improve customer
                                            service and agent performance.</p>
                                    </div>
                                </div>
                            </div>

                            <!-- Q7 -->
                            <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-transparent border-0 mb-0"
                                data-aos="fade-up">
                                <h3 class="accordion-header d-flex align-items-center justify-content-between tw-gap-3">
                                    <button
                                        class="accordion-button shadow-none p-0 line-clamp-3 bg-transparent h5 collapsed"
                                        type="button" data-bs-toggle="collapse" data-bs-target="#collapseSeven"
                                        aria-expanded="false" aria-controls="collapseSeven">
                                        How often should calls be scored?
                                    </button>
                                </h3>
                                <div id="collapseSeven" class="accordion-collapse collapse"
                                    data-bs-parent="#accordionExample">
                                    <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                                        <p class="text-neutral-500 tw-leading-212 heading-medium">It depends on call
                                            volume, but regular scoring ensures consistent quality.</p>
                                    </div>
                                </div>
                            </div>

                            <!-- Q8 -->
                            <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-transparent border-0 mb-0"
                                data-aos="fade-up">
                                <h3 class="accordion-header d-flex align-items-center justify-content-between tw-gap-3">
                                    <button
                                        class="accordion-button shadow-none p-0 line-clamp-3 bg-transparent h5 collapsed"
                                        type="button" data-bs-toggle="collapse" data-bs-target="#collapseEight"
                                        aria-expanded="false" aria-controls="collapseEight">
                                        Do small businesses need call scoring?
                                    </button>
                                </h3>
                                <div id="collapseEight" class="accordion-collapse collapse"
                                    data-bs-parent="#accordionExample">
                                    <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                                        <p class="text-neutral-500 tw-leading-212 heading-medium">Yes, even small teams
                                            benefit from better call insights.</p>
                                    </div>
                                </div>
                            </div>

                            <!-- Q9 -->
                            <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-transparent border-0 mb-0"
                                data-aos="fade-up">
                                <h3 class="accordion-header d-flex align-items-center justify-content-between tw-gap-3">
                                    <button
                                        class="accordion-button shadow-none p-0 line-clamp-3 bg-transparent h5 collapsed"
                                        type="button" data-bs-toggle="collapse" data-bs-target="#collapseNine"
                                        aria-expanded="false" aria-controls="collapseNine">
                                        Can call scoring work for remote teams?
                                    </button>
                                </h3>
                                <div id="collapseNine" class="accordion-collapse collapse"
                                    data-bs-parent="#accordionExample">
                                    <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                                        <p class="text-neutral-500 tw-leading-212 heading-medium">Absolutely, managers
                                            can monitor and coach remote agents effectively.</p>
                                    </div>
                                </div>
                            </div>

                            <!-- Q10 -->
                            <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-transparent border-0 mb-0"
                                data-aos="fade-up">
                                <h3 class="accordion-header d-flex align-items-center justify-content-between tw-gap-3">
                                    <button
                                        class="accordion-button shadow-none p-0 line-clamp-3 bg-transparent h5 collapsed"
                                        type="button" data-bs-toggle="collapse" data-bs-target="#collapseTen"
                                        aria-expanded="false" aria-controls="collapseTen">
                                        Is call scoring only for sales teams?
                                    </button>
                                </h3>
                                <div id="collapseTen" class="accordion-collapse collapse"
                                    data-bs-parent="#accordionExample">
                                    <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                                        <p class="text-neutral-500 tw-leading-212 heading-medium">No, it also helps
                                            support teams and customer service improve interactions.</p>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>

                </div>

            </div>
        </div>
    </section>


<section class="py-50">
    <div class="container">
        <div class="text-center">
            <h3 class="main-heading text-capitalize mb-4">
               Transform Every Call Into a Growth Opportunity?
            </h3>
            <p class="max-w-780-px mx-auto tw-mb-6">
             Enhance your sales performance with the best AI call scoring tool trusted by leading businesses.
            </p>

            <div class="d-flex flex-column align-items-center">
                <p class="fw-semibold tw-mb-4">
                    🔥 Don’t wait — start transforming your calls today. 
                    <a href="{{ route('register') }}" 
                       class="btn btn-main hover-style-one tw-rounded-xl tw-px-4 tw-py-2 fw-medium text-capitalize ms-2">
                        👉 Register Today
                    </a>
                </p>
                <p class="fw-semibold mt-3">Follow us on <a href="https://www.instagram.com/callchex/">Instagram</a>🚀</p>
                <p class="fw-semibold mt-3">Connect with us on <a href="https://www.linkedin.com/company/callchex/about/?viewAsMember=true">LinkedIn</a>🚀</p>
            </div>
        </div>
    </div>
</section>
    
</div>
@endsection