@extends('website.layout')

@section('meta')
    <title> Call Center Quality Assurance Software | {{ config('app.site') }} </title>
    <meta name="description" content="Boost sales and customer experience with {{ config('app.site') }} Call Center Quality Assurance Software. Monitor calls, analyze conversations, and improve conversions.">
   <meta name="keywords" content="Call Center Quality Assurance Software">

    {{-- Open Graph --}}
    <meta property="og:title" content="Call Center Quality Assurance Software | {{ config('app.site') }} ">
    <meta property="og:description" content="Boost sales and customer experience with {{ config('app.site') }} Call Center Quality Assurance Software. Monitor calls, analyze conversations, and improve conversions.">
    <meta property="og:image" content="{{ asset('assets/images/call-center-quality-assurance.webp') }}">
    <meta property="og:type" content="website">
    <meta property="og:url" content="{{ url()->current() }}">

    {{-- Twitter / X --}}
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Call Center Quality Assurance Software | {{ config('app.site') }} ">
    <meta name="twitter:description" content="Boost sales and customer experience with {{ config('app.site') }} Call Center Quality Assurance Software. Monitor calls, analyze conversations, and improve conversions.">
    <meta name="twitter:image" content="{{ asset('assets/images/call-center-quality-assurance.webp') }}">

    {{-- Extra Tags --}}
    <meta name="tags" content="Call Center Quality Assurance Software">


{{-- Blog Schema --}}
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "WebPage",
  "name": "Call Center Quality Assurance Software | CallChex ",
  "url": "https://callchex.com/call-center-quality-assurance-software",
  "description": "Boost sales and customer experience with CallChex Call Center Quality Assurance Software. Monitor calls, analyze conversations, and improve conversions.",
  "image": "https://callchex.com/assets/images/call-center-quality-assurance.webp",
  "publisher": {
    "@type": "Organization",
    "name": "Callchex",
    "logo": {
      "@type": "ImageObject",
      "url": "https://callchex.com/assets/img/logo.webp"
    }
  }
}
</script>


{{-- Organization Schema --}}
    <script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Organization",
  "name": "Callchex",
  "url": "https://callchex.com",
  "logo": "https://callchex.com/assets/img/logo.webp",
  "contactPoint": {
    "@type": "ContactPoint",
    "telephone": "+1 (902) 441-2385",
    "contactType": "customer service",
    "areaServed": "US",
    "availableLanguage": "en"
  },
  "sameAs": [
    "https://www.linkedin.com/company/callchex/about/",
    "https://callchex.com"
  ]
}
</script>
@endsection



@section('content')


<style>
.custom-paragraph {
  margin-left: auto;
  margin-right: auto;
}

.paragraph-style {
  font-weight: 400;
  font-size: 18px;
}

.centered-small-paragraph {
  font-weight: 400;
  font-size: 16px;
  max-width: 228px;
  margin-left: auto;
  margin-right: auto;
}

.pt-40 {
  padding-top: 40px;
}

.bg-aliceblue {
  background-color: aliceblue;
}

.visually-hidden {
    position: absolute;
    width: 1px;
    height: 1px;
    padding: 0;
    margin: -1px;
    overflow: hidden;
    clip: rect(0, 0, 0, 0);
    white-space: nowrap;
    border: 0;
}

.content-box h1 {
  font-size: 2.5rem;
  color: #0d3c7d;
  line-height: 1.3;
}

.content-box p.lead {
  font-size: 1.1rem;
  color: #444;
}

.subheadline {
  font-size: 1rem;
  color: #666;
}

.btn-main {
  background: linear-gradient(90deg, #9333EA, #3B82F6);
  color: #fff;
  border: none;
  transition: 0.3s;
}
.btn-main:hover {
  opacity: 0.9;
}

.hero-image {
  max-width: 100%;      
  width: 500px;        
  height: auto;        
}

</style>

<div id="smooth-content">
        <!-- ================================ Distraction page start ====================================== -->
     <section class="section-bg-two pb-50 overflow-hidden pt-40">
  <div class="container max-w-1290-px">
    <div class="row gy-5 align-items-center">
      
<!-- Left Content -->
<div class="col-xl-6 col-lg-6 col-md-12">
  <div class="content-box">
    
    <!-- Small Top Text -->
<h1 class="d-block mb-2"
      style="text-transform:uppercase; font-size:14px; font-weight:600; 
             letter-spacing:1px; 
             background: linear-gradient(90deg, #2563eb, #3b82f6);
             -webkit-background-clip: text; 
             -webkit-text-fill-color: transparent; 
             display:inline-block;">
    Call Center Quality Assurance Software
</h1>



    <!-- Main Heading -->
    <h2 class="fw-bold mb-3" style="font-size:2.2rem; line-height:1.3;">
      Unlock smarter conversation insights that drive conversions for real estate teams across the USA.
    </h2>

    <!-- Subheading Paragraph -->
    <p class="text-secondary mb-4" style="font-size:1.05rem;">
      Intelligent real-time call intelligence tailored to agencies, brokers, and property managers — no jargon, just sharper results.
    </p>

    <!-- Button -->
    <a href="{{ route('register') }}" 
       class="btn btn-main px-5 py-3 rounded-pill fw-semibold">
       Register Today
    </a>
  </div>
</div>

      
 
      <!-- Right Hero Image -->
     <div class="col-xl-6 col-lg-6 col-md-12 text-center">
      <img src="{{ asset('assets/images/call-center-quality-assurance.webp') }}" 
       alt="AI Call Analytics for Real Estate in USA dashboard view" 
       class="hero-image">
     </div>


    </div>
  </div>
</section>


        <!-- ================================ Distraction page End ====================================== -->

<section class="callchex-section py-50">
  <div class="container max-w-1200-px">
    <!-- Heading -->
    <div class="text-center mb-5">
      <h2 class="fw-bold" style="font-size:2.2rem; font-family:'Poppins', sans-serif;">
        How {{ config('app.site') }} Helps Real Estate Call Centers with AI Call Analytics
      </h2>
      <p class="lead text-muted mt-3" style="max-width:800px; margin:0 auto; font-size:1.1rem; font-family:'Jost', sans-serif;">
        Real estate call centers handle high volumes of inquiries every day—buyers, sellers, 
        and tenants looking for quick answers. With {{ config('app.site') }}, you can turn these conversations 
        into opportunities using AI Call Analytics for Real Estate.
      </p>
    </div>

    <!-- Cards -->
    <div class="row g-4">
      <div class="col-lg-4 col-md-6">
        <div class="info-card">
          <h3 class="info-title">Qualify Leads Faster</h3>
          <p class="info-text">
            AI automatically identifies serious buyers and high-intent callers, helping agents prioritize the right opportunities.
          </p>
        </div>
      </div>
      <div class="col-lg-4 col-md-6">
        <div class="info-card">
          <h3 class="info-title">Boost Agent Performance</h3>
          <p class="info-text">
            Track every conversation with AI-driven insights. Pinpoint what top-performing agents do differently and guide the rest of your team to success.
          </p>
        </div>
      </div>
      <div class="col-lg-4 col-md-6">
        <div class="info-card">
          <h3 class="info-title">Ensure Call Quality & Compliance</h3>
          <p class="info-text">
            No more manual auditing. {{ config('app.site') }} audits 100% of calls, ensuring every conversation meets compliance and quality standards.
          </p>
        </div>
      </div>
<div class="col-lg-4 col-md-6">
  <div class="info-card">
    <h3 class="info-title">Engage Customers Better</h3>
    <p class="info-text">
      Leverage 
      <a href="https://callchex.com/blogs/conversation-analytics-software" target="_blank" style="text-decoration:none; color:#17a2b8; font-weight:500;">
        conversation analytics
      </a> 
      and 
      <a href="https://callchex.com/blogs/speech-analysis" target="_blank" style="text-decoration:none; color:#17a2b8; font-weight:500;">
        speech analysis
      </a> 
      to understand customer sentiment and improve responses.
    </p>
  </div>
</div>

  <div class="col-lg-4 col-md-6">
  <div class="info-card">
    <h3 class="info-title">Handle High Call Volumes with Ease</h3>
    <p class="info-text">
      With 
      <a href="https://callchex.com/blogs/real-time-monitoring-call-center" target="_blank" style="text-decoration:none; color:#17a2b8; font-weight:500;">
        real-time monitoring
      </a>, supervisors can instantly intervene when needed, ensuring no lead slips away.
    </p>
  </div>
</div>

 <div class="col-lg-4 col-md-6">
  <div class="info-card">
    <h3 class="info-title">Data-Driven Decisions</h3>
    <p class="info-text">
      Use 
      <a href="https://callchex.com/blogs/call-center-analytics-software" target="_blank" style="text-decoration:none; color:#17a2b8; font-weight:500;">
        call center analytics
      </a> 
      to identify trends, optimize campaigns, and measure ROI from calls.
    </p>
  </div>
</div>

    </div>

<!-- CTA -->
<div class="text-center mt-5" style="font-family:'Poppins', sans-serif; font-size:1.1rem;">
  👉 Ready to give your real estate call center a competitive edge? 
  <a href="{{ route('register') }}"  style="color:#0d6efd; text-decoration:none; font-weight:600;">
    Register Today
  </a>
</div>

  </div>
</section>

<style>
.callchex-section {
  background: #fff;
}
.info-card {
  background: #fff;
  border-radius: 12px;
  padding: 25px;
  box-shadow: 0 2px 8px rgba(0,0,0,0.08);
  height: 100%;
  text-align: center;
  transition: all 0.3s ease;
}
.info-card:hover {
  box-shadow: 0 6px 16px rgba(0,0,0,0.12);
  transform: translateY(-4px);
}
.info-title {
  font-family: 'Poppins', sans-serif;
  font-weight: 600;
  font-size: 1.1rem;
  margin-bottom: 12px;
  background: linear-gradient(90deg, #e91e63, #3f51b5);
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
}
.info-text {
  font-family: 'Jost', sans-serif;
  font-size: 0.95rem;
  color: #444;
  line-height: 1.6;
}
</style>



<!-- ================== Driven section Start ====================== -->


<h2 class="main-heading text-center mb-4 mt-2">
  Invest in an AI-powered Speech Analytics Solution
</h2>

<section class="ai-section py-5">
  <div class="container">

  
   <h3 class="sub-heading text-center mb-2">
      Eliminate miscommunication and improve call quality
    </h3> 

    <!-- Section 1: Lead Qualification -->
    <div class="row align-items-center mb-4 custom-gap-fix">
      <!-- Left Content -->
      <div class="col-lg-6">
        <p class="section-text">
         {{ config('app.site') }}’s AI Call Analytics ensures every conversation is accurate and high-quality.
          With automated QA, your team reduces miscommunication and qualifies leads effectively.
        </p>
        <ul class="section-list">
          <li>100% automated call audits for compliance</li>
          <li>AI feedback to improve agent performance</li>
          <li>Eliminate mis-selling and miscommunication</li>
          <li>Consistent conversations across every interaction</li>
        </ul>
        <a href="https://callchex.com/blogs/call-center-analytics-software" class="section-link">
          🔗 Learn more about Call Center Analytics Software
        </a>
      </div>

      <!-- Right Image -->
      <div class="col-lg-6 text-center">
        <img src="{{ asset('assets/images/call-center-lead-qualification-with-ai.webp') }}" 
             alt="AI software identifying high-intent real estate buyers from calls"
             class="img-fluid section-img">
      </div>
    </div>

    <!-- Section 2: Agent Performance -->
    <h3 class="sub-heading text-center mb-2">Identify high-intent real estate customers</h3>
    <div class="row align-items-center mb-4 flex-row-reverse">
      <div class="col-lg-6">
        <p class="section-text">
          With AI Call Analytics, {{ config('app.site') }} identifies valuable buyers and tenants using sentiment,
          keywords, and voice pattern analysis.
        </p>
        <ul class="section-list">
          <li>Detect high-intent customers instantly</li>
          <li>Prioritize leads that matter most</li>
          <li>Save time by focusing on genuine prospects</li>
          <li>Improve deal closures with data-driven targeting</li>
        </ul>
        <a href="https://callchex.com/blogs/real-time-monitoring-call-center" class="section-link">🔗 See how Real-Time Monitoring helps your team</a>
      </div>
      <div class="col-lg-6 text-center">
        <img src="{{ asset('assets/images/ai-call-analytics-for-call-center-agents.webp') }}" 
             alt="Real estate call center agents improving performance with AI insights"
             class="img-fluid section-img">
      </div>
    </div>

    <!-- Section 3: Call Quality & Compliance -->
    <h3 class="sub-heading text-center mb-2">Earn trust with winning agent behavior</h3>
    <div class="row align-items-center mb-4 custom-gap-fix">
      <div class="col-lg-6">
        <p class="section-text">
          Conversation Behavior Analysis uncovers patterns that drive real estate sales 
          and helps replicate strategies of top agents.
        </p>
        <ul class="section-list">
          <li>Understand which conversations lead to site visits</li>
          <li>Replicate strategies of top-performing agents</li>
          <li>Eliminate weak behaviors that cause drop-offs</li>
          <li>Build stronger relationships with clients</li>
        </ul>
        <a href="https://callchex.com/blogs/conversation-analytics-software" class="section-link">🔗 Explore Conversation Analytics</a>
      </div>
      <div class="col-lg-6 text-center">
        <img src="{{ asset('assets/images/call-center-quality-monitoring-ai.webp') }}" 
             alt="AI monitoring call quality and compliance for real estate companies"
             class="img-fluid section-img">
      </div>
    </div>

    <!-- Section 4: Customer Engagement -->
    <h3 class="sub-heading text-center mb-2">Improve conversation quality with AI coaching</h3>
    <div class="row align-items-center mb-4 flex-row-reverse">
      <div class="col-lg-6">
        <p class="section-text">
          With automated, personalized coaching, {{ config('app.site') }} upgrades agent skills at scale 
          and helps close performance gaps faster.
        </p>
        <ul class="section-list">
          <li>AI-driven coaching tailored to each agent</li>
          <li>Continuous learning via training & feedback</li>
          <li>Close performance gaps faster</li>
          <li>Boost conversion rates with smarter conversations</li>
        </ul>
        <a href="https://callchex.com/blogs/speech-analysis" class="section-link">🔗 Check out Speech Analysis for coaching insights</a>
      </div>
      <div class="col-lg-6 text-center">
        <img src="{{ asset('assets/images/call-center-customer-engagement-ai.webp') }}" 
             alt="Real estate agents engaging customers using AI conversation analytics"
             class="img-fluid section-img">
      </div>
    </div>

    <!-- Section 5: Real-Time Agent Assist -->
    <h3 class="sub-heading text-center mb-2">Real-time guidance for every situation</h3>
    <div class="row align-items-center custom-gap-fix">
      <div class="col-lg-6">
        <p class="section-text">
          Real-Time Agent Assist provides live suggestions during calls, ensuring agents 
          handle objections and client queries effectively.
        </p>
        <ul class="section-list">
          <li>Instant prompts during live calls</li>
          <li>Objection handling made easier</li>
          <li>Access knowledge base in real time</li>
          <li>Higher success rates in client interactions</li>
        </ul>
        <a href="https://linkedin.com/company/callchex" class="section-link">🔗 Connect with us on LinkedIn</a>
      </div>
      <div class="col-lg-6 text-center">
        <img src="{{ asset('assets/images/real-time-agent-assist-for-real-estate.webp') }}" 
             alt="AI-powered real-time guidance for real estate agents on live calls"
             class="img-fluid section-img">
      </div>
    </div>

  </div>
</section>

<!-- ================== Driven section End ====================== -->


<!-- CSS -->
<style>
.main-heading {
  font-size: 2.2rem;
  font-weight: 700;
  color: #000; 
}

.ai-section {
  background: #0b0b0b; 
  color: #fff;
  padding: 50px 0;
}

.sub-heading {
  font-size: 1.4rem;
  font-weight: 600;
  margin-bottom: 6px; 
}

.section-text {
  font-size: 1rem;
  line-height: 1.6;
  margin-bottom: 8px;
  max-width: 440px;  
  text-align: left; 
}


.section-list {
  padding-left: 18px;
  margin-bottom: 8px;
}

.section-list li {
  margin-bottom: 5px;
  list-style: disc;
}

.section-link {
  color: #4e9eff;
  font-weight: 600;
  text-decoration: none;
}

.section-link:hover {
  text-decoration: underline;
}


.section-img {
  max-width: 390px;
  width: 100%;
  height: auto;
  border-radius: 6px;
  box-shadow: 0 3px 12px rgba(0,0,0,0.25);
  margin: 0 auto;
}


.row.align-items-center {
  display: flex;
  justify-content: space-between;  
  align-items: center;
  margin: 0;  
}



.row.align-items-center .col-lg-6 {
  flex: 0 0 auto;
  width: 50%;
  max-width: 50%;
  padding: 0 15px;  
}


.custom-gap-fix .col-lg-6:first-child {
  padding-left: 200px !important;
}


@media (max-width: 991px) {
  .custom-gap-fix .col-lg-6:first-child {
    padding-left: 0 !important;
  }
}




.row.align-items-center.flex-row-reverse {
  flex-direction: row-reverse;
}


@media (max-width: 991px) {
  .row.align-items-center,
  .row.align-items-center.flex-row-reverse {
    flex-direction: column;
  }

  .row.align-items-center .col-lg-6 {
    width: 100%;
    max-width: 100%;
    padding: 0;  
  }

  .section-img {
    margin-top: 12px;
    max-width: 100%;
  }
}

/* Tablet only (768px - 991px) */
@media (min-width: 768px) and (max-width: 991px) {
  .section-img {
    max-width: 65%;
    margin: 15px auto;
    display: block;
  }

  .section-text {
    max-width: 80%;
    margin: 0 auto 12px;
    font-size: 0.95rem;
    line-height: 1.5;
    text-align: center;
  }

  .section-list {
    max-width: 80%;
    margin: 0 auto 12px;
    padding-left: 0;
    list-style-position: inside;
    text-align: center; 
  }

  .section-list li {
    display: block;
    text-align: center;
    margin: 6px 0;
  }

  .section-link {
    display: block;
    text-align: center;
    margin-top: 10px;
    font-size: 0.95rem;
    word-break: break-word;
  }

  .sub-heading {
    font-size: 1.2rem;
    text-align: center;
    margin-bottom: 10px;
  }

  .main-heading {
    font-size: 1.8rem;
    text-align: center;
    margin-bottom: 12px;
  }

}


</style>

<!-- ================== Driven section Start ====================== -->
<section class="py-50">
    <div class="container">
        <div class="text-center">
            <h2 class="main-heading text-capitalize mb-4">
                Ready to Elevate Your Real Estate Call Center?
            </h2>
            <p class="max-w-780-px mx-auto tw-mb-6">
                Stop losing valuable leads. With <strong>{{ config('app.site') }} AI Call Analytics</strong> for Real Estate in USA, 
                every call becomes an opportunity to close more deals, train smarter agents, 
                and deliver exceptional customer experiences.
            </p>

            <div class="d-flex flex-column align-items-center">
                <p class="fw-semibold tw-mb-4">
                    🔥 Don’t wait — start transforming your calls today. 
                    <a href="{{ route('register') }}" 
                       class="btn btn-main hover-style-one tw-rounded-xl tw-px-4 tw-py-2 fw-medium text-capitalize ms-2">
                        👉 Register Today
                    </a>
                </p>
                <p class="fw-semibold mt-3">Let’s make every conversation count. 🚀</p>
            </div>
        </div>
    </div>
</section>
<!-- ================== Driven section End ====================== -->



<style>
.contact-section {
    background: linear-gradient(to right, #dbe9f4, #e3f2f4);
    padding: 60px 20px;
}
.contact-card {
    max-width: 1100px;
    margin: 0 auto;
    background: white;
    border-radius: 20px;
    display: flex;
    overflow: hidden;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
    flex-wrap: wrap;
}


.form-side {
    flex: 1 1 60%;
    padding: 50px;
}
.form-side h2 {
    font-size: 26px;
    color: #2c3e50;
    margin-bottom: 30px;
}
.form-group {
    margin-bottom: 25px;
}
.form-group label {
    display: block;
    margin-bottom: 8px;
    font-weight: 600;
    color: #444;
}
.form-group input,
.form-group textarea {
    width: 100%;
    padding: 12px 16px;
    border: 1px solid #ccc;
    border-radius: 8px;
    font-size: 15px;
}
textarea {
    resize: vertical;
}
.captcha-wrapper {
    margin-bottom: 20px;
}
.submit-btn {
    background-color: #2c3e50;
    color: white;
    padding: 14px 28px;
    border: none;
    border-radius: 8px;
    font-weight: 600;
    font-size: 16px;
    cursor: pointer;
    transition: 0.3s;
}
.submit-btn:hover {
    background-color: #1f2a38;
}


.info-side {
    flex: 1 1 40%;
    background-color: #2c3e74;
    color: white;
    padding: 50px;
    display: flex;
    flex-direction: column;
    justify-content: center;
}
.info-side h2 {
    font-size: 22px;
    margin-bottom: 15px;
}
.info-side p,
.info-side .info-item {
    font-size: 16px;
    margin-bottom: 18px;
}
.info-item i {
    margin-right: 10px;
    color: #aadfff;
}

.visually-hidden {
    position: absolute;
    width: 1px;
    height: 1px;
    padding: 0;
    margin: -1px;
    overflow: hidden;
    clip: rect(0, 0, 0, 0);
    white-space: nowrap;
    border: 0;
}


@media (max-width: 768px) {
    .form-side, 
    .info-side {
        padding: 30px;
        flex: 1 1 100%;
    }
}

@media (max-width: 480px) {
    .form-side, 
    .info-side {
        padding: 20px 15px; 
    }

    .form-group input,
    .form-group textarea {
        width: 100%;
        box-sizing: border-box; 
    }

    .submit-btn {
        width: 100%; 
    }
}

@media (max-width: 360px) {
    .contact-section {
        padding: 20px 12px;
        box-sizing: border-box;
    }

    .contact-card {
        width: 100%;
        max-width: 100%;
        margin: 0 auto;
        border-radius: 12px;
        padding: 0;
        box-sizing: border-box;
    }

    .form-side, 
    .info-side {
        flex: 1 1 100%;
        padding: 0;
        box-sizing: border-box;
    }

    .form-group {
        margin-bottom: 15px;
        padding: 0 10px;
        box-sizing: border-box;
    }

    .form-group input,
    .form-group textarea {
        width: 100%;
        display: block;
        box-sizing: border-box;
        font-size: 14px;
        padding: 10px 12px;
    }

    .submit-btn {
        display: block;
        width: calc(100% - 20px);
        margin: 10px auto 20px auto;
        padding: 12px;
        font-size: 15px;
        text-align: center;
        box-sizing: border-box;
    }

    .form-side h2,
    .info-side h2 {
        font-size: 18px;
        text-align: center;
        padding: 0 10px;
        word-break: break-word;
    }
}

</style>

<section class="contact-section">
    <div class="contact-card">
        <!-- Contact Form -->
        <div class="form-side">
            <h1 class="visually-hidden">Send Us a Message</h1>
            <h2>Send Us a Message</h2>

            <!-- Display Success Message -->
            @if (session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
            @endif

            <!-- Display Error Message -->
            @if (session('error'))
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                {{ session('error') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
            @endif

            <!-- Display Validation Errors -->
            @if ($errors->any())
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <ul class="mb-0">
                    @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                    @endforeach
                </ul>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
            @endif

            <form action="{{ route('save-contact') }}" method="POST">
                @csrf
                <div class="form-group">
                    <label for="name">Name <span class="text-danger">*</span></label>
                    <input type="text" name="name" id="name" placeholder="John Doe" value="{{ old('name') }}" required>
                </div>

                <div class="form-group">
                    <label for="email">Email <span class="text-danger">*</span></label>
                    <input type="email" name="email" id="email" placeholder="you@example.com" value="{{ old('email') }}" required>
                </div>

                <div class="form-group">
                    <label for="message">Message <span class="text-danger">*</span></label>
                    <textarea name="message" id="message" rows="4" placeholder="Your message here..." required>{{ old('message') }}</textarea>
                </div>

                <div class="captcha-wrapper">
                    {!! NoCaptcha::display() !!}
                </div>

                <button type="submit" class="submit-btn">Submit Message</button>
            </form>
        </div>

        <!-- Contact Info -->
        <div class="info-side">
            <h2>Get in Touch</h2>
            <p>We’d love to hear from you. Contact us via:</p>
            <div class="info-item"><i>📞</i>{{ config('app.phone_number') }}</div>
            <div class="info-item"><i>📧</i>{{ config('app.email_id') }}</div>
        </div>
    </div>

</section>

{!! NoCaptcha::renderJs() !!}

@push('scripts')
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "ContactPage",
  "mainEntity": {
    "@type": "Organization",
    "name": "{{ config('app.site') }}",
    "url": "{{ url('/') }}",
    "email": "{{ config('app.email_id') }}",
    "telephone": "{{ config('app.phone_number') }}",
    "contactPoint": {
      "@type": "ContactPoint",
      "telephone": "{{ config('app.phone_number') }}",
      "contactType": "Customer Support",
      "email": "{{ config('app.email_id') }}",
      "availableLanguage": "English",
      "areaServed": "IN"
    }
  }
}
</script>
@endpush

  </div>
  @endsection
