@forelse ($blogs as $blog)
    <div class="col-lg-4 col-md-6 mb-5" data-aos="fade-up" data-aos-duration="800">
        <div class="h-100 shadow-sm border tw-rounded-3xl overflow-hidden d-flex flex-column">
            <div class="position-relative">
                <a href="{{ route('blogs.public.show', $blog->slug) }}" class="d-block">
                    <img src="{{ asset($blog->image) }}" alt="{{ $blog->title }}" class="tw-rounded-0 w-100 h-100"
                        style="max-height: 250px; object-fit: cover;">
                </a>
            </div>
            <div class="p-4 d-flex flex-column justify-content-between h-100">
                <div class="tw-mb-3">
                    <h5 class="tw-mb-2">
                        <a href="{{ route('blogs.public.show', $blog->slug) }}" class="text-dark fw-medium">
                            {!! Str::limit($blog->title, 60) !!}
                        </a>
                    </h5>
                    <p class="tw-text-sm text-neutral-600">
                        {!! Str::limit(strip_tags($blog->content), 100) !!}
                    </p>
                </div>
                <a href="{{ route('blogs.public.show', $blog->slug) }}"
                    class=" tw-text-sm text-main-two-600 fw-bold hover-text-main-600 d-inline-flex align-items-center tw-gap-2 mt-auto">
                    Read More
                    <img src="{{ asset('assets/images/icons/arrow-long.svg') }}" alt="arrow">
                </a>
            </div>
        </div>
    </div>

@empty
    <div class="col-12 text-center text-muted">No blogs found.</div>
@endforelse
