@extends('website.layout')
@section('title', 'Blog')
@section('content')
    <div class="container py-5">
        <!-- Header -->
        <div class="text-center mb-5 animate__animated animate__fadeIn">
            <h1 class="display-4 fw-bold text-dark">Our Blog</h1>
            <p class="lead text-muted">Explore our latest articles and insights</p>
        </div>

        <!-- Search Bar -->
        <div class="row justify-content-center mb-4">
            <div class="col-md-6 col-12">
                <form method="GET" action="{{ route('blogs.public.index') }}">
                    <div class="input-group animate__animated animate__fadeInUp">
                        <input type="text" name="search" class="form-control rounded-pill-start"
                            placeholder="Search blogs..." value="{{ request('search') }}">
                        <button type="submit" class="btn btn-primary rounded-pill-end">
                            <i class="ti ti-search"></i>
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <!-- Blog Grid -->
        <div class="row g-4">
            @forelse ($blogs as $blog)
                <div class="col-lg-4 col-md-6 col-12 animate__animated animate__fadeInUp"
                    style="animation-delay: {{ $loop->index * 0.1 }}s;">
                    <div class="card h-100 border-0 shadow-sm blog-card rounded-4">
                        @if ($blog->image)
                            <img src="{{ asset('storage/' . $blog->image) }}" class="card-img-top rounded-top-4"
                                alt="{{ $blog->title }}" style="height: 250px; object-fit: cover;">
                        @else
                            <div class="card-img-top bg-light rounded-top-4" style="height: 250px;"></div>
                        @endif
                        <div class="card-body">
                            <h5 class="card-title fw-bold">{{ Str::limit($blog->title, 50) }}</h5>
                            <p class="card-text text-muted">{{ Str::limit(strip_tags($blog->content), 100) }}</p>
                            <div class="d-flex justify-content-between align-items-center">
                                <small class="text-muted">By {{ $blog->user->name }} on
                                    {{ $blog->created_at->format('M d, Y') }}</small>
                            </div>
                        </div>
                        <a href="{{ route('blogs.public.show', $blog->slug) }}" class="stretched-link"></a>
                    </div>
                </div>
            @empty
                <div class="col-12 text-center">
                    <p class="text-muted">No blogs found.</p>
                </div>
            @endforelse
        </div>

        <!-- Pagination -->
        <div class="mt-5">
            {{ $blogs->appends(request()->except('page'))->links('pagination::bootstrap-5') }}
        </div>
    </div>

    <style>
        .blog-card {
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            border-radius: 1.5rem !important;
        }

        .blog-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.15) !important;
        }

        .card-img-top,
        .card-img-top.bg-light {
            border-top-left-radius: 1.5rem !important;
            border-top-right-radius: 1.5rem !important;
        }

        .rounded-pill-start {
            border-top-right-radius: 0 !important;
            border-bottom-right-radius: 0 !important;
        }

        .rounded-pill-end {
            border-top-left-radius: 0 !important;
            border-bottom-left-radius: 0 !important;
        }

        @media (max-width: 576px) {
            .blog-card {
                margin-left: auto;
                margin-right: auto;
                max-width: 90%;
            }

            .card-img-top,
            .card-img-top.bg-light {
                height: 200px !important;
            }

            .input-group {
                flex-direction: column;
            }

            .rounded-pill-start,
            .rounded-pill-end {
                border-radius: 50rem !important;
                width: 100%;
            }

            .rounded-pill-end {
                margin-top: 0.5rem;
            }
        }
    </style>
@endsection
