@extends('website.layout')

@section('meta')
    <title>{{ config('app.site') }} Blog | AI Automation, Tips & Business Insights</title>

    <meta name="description" content="Explore the {{ config('app.site') }} blog for AI automation tips, how-tos, industry insights, and strategies to grow your business with smarter communication and automation.">

    <meta name="keywords" content="AI automation blog, business automation tips, AI communication insights, voice AI blog, {{ config('app.site') }} blog">

    {{-- Open Graph --}}
    <meta property="og:title" content="{{ config('app.site') }} Blog | AI Automation, Tips & Business Insights">
    <meta property="og:description" content="Explore the {{ config('app.site') }} blog for AI automation tips, how-tos, industry insights, and strategies to grow your business with smarter communication and automation.">
    <meta property="og:type" content="website">
    <meta property="og:url" content="{{ url()->current() }}">

    {{-- Twitter / X --}}
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="{{ config('app.site') }} Blog | AI Automation, Tips & Business Insights">
    <meta name="twitter:description" content="Explore the {{ config('app.site') }} blog for AI automation tips, how-tos, industry insights, and strategies to grow your business with smarter communication and automation.">
    
@endsection


<style>
.visually-hidden {
    position: absolute;
    width: 1px;
    height: 1px;
    padding: 0;
    margin: -1px;
    overflow: hidden;
    clip: rect(0, 0, 0, 0);
    white-space: nowrap;
    border: 0;
}

.tw-mb-2{
     font-size: clamp(1.125rem, 1.2rem + 0.722vw, 1.5rem);
     font-weight: 500 !important;
}

.social-icon-img {
    display: flex;
    gap: 10px;         
    justify-content: center; 
    align-items: center;
    margin-top: 10px;  
    margin-left: 10px; 
}
</style>

@section('content')
    <div id="smooth-wrapper">
        <div id="smooth-content">
            <!-- ==================== Breadcrumb Start Here ==================== -->
            <section class="py-5 bg-light mb-0">
                <div class="container">
                    <div class="row justify-content-center">
                        <div class="col-lg-6 text-center">
                            <!-- Logo -->
                            <div class="mb-4">
                                <img src="{{ asset('web/assets/images/favicon-two.webp') }}" alt="Favicon Two"
                                    style="height: 50px;">
                            </div>

                            <!-- Title -->
                              <h1 class="visually-hidden">Blog Page</h1>
                            <h3 class="mb-5 fw-normal text-capitalize">Blog Page</h3>

                            <!-- Search Bar -->
                            <form id="search-form">
                                <div class="input-group animate__animated animate__fadeInUp">
                                    <input type="text" name="search" id="search"
                                        class="form-control rounded-pill-start" placeholder="Search blogs..."
                                        value="{{ request('search') }}">
                                    <button type="button" class="btn btn-primary rounded-pill-end">
                                       <i class="fa fa-search"></i>
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </section>
            <!-- ==================== Breadcrumb End Here ==================== -->

            <!-- ========================= Blog Start ============================ -->


            <section class="py-50">
                {{-- <div class="container">

                    <div id="blog-list" class="row">
                        @include('website.blogs.partials.blog-cards', ['blogs' => $blogs])
                    </div>
                    <div id="loader" style="display: none; text-align: center;">
                        <img src="{{ asset('images/loader.gif') }}" alt="Loading..." />
                    </div>
                </div> --}}
                <div class="container">
                    <div id="blog-list" class="row">
                        {{-- Initial blog cards will be inserted here --}}
                    </div>

                    <div id="scroll-sentinel" class="py-2"></div>
                    <div id="loading-spinner" class="text-center py-4" style="display: none;">
                        <p>Loading blogs...</p>
                    </div>

                    <div id="end-message" class="text-center py-4" style="display: none;">
                        <p>No more blogs to load.</p>
                    </div>
                </div>
            </section>
            <!-- ========================= Blog End ============================ -->
        </div>
    </div>
@endsection



@push('scripts')
    <script>
        let page = 1;
        let isLoading = false;
        let hasMore = true;
        let searchData = document.getElementById('search').value;

        document.addEventListener("DOMContentLoaded", function() {
            loadBlogs();

            window.addEventListener("scroll", () => {
                if (isLoading || !hasMore) return;

                searchData = document.getElementById('search').value;

                // Scroll trigger: 100px before bottom
                if ((window.innerHeight + window.scrollY) >= document.body.offsetHeight - 500) {
                    //loadBlogs();

                    if (searchData.length < 1) {
                        // page = 1;
                        // isLoading = false;
                        // hasMore = true;
                        loadBlogs(); // Initial load
                    }
                }

            });
        });

        function loadBlogs() {
            isLoading = true;
            document.getElementById('loading-spinner').style.display = 'block';
            let excerpt = "";
            fetch(`/load-more-blogs?page=${page}`)
                .then(response => response.json())
                .then(data => {
                    const blogList = document.getElementById('blog-list');
                    data.blogs.forEach(blog => {
                        excerpt = blog.content.replace(/<\/?[^>]+(>|$)/g, '').substring(0, 100) + '...';
                        const blogHTML = `
                        <div class="col-lg-4 col-md-6 mb-5" data-aos="fade-up" data-aos-duration="800">
                            <div class="h-100 shadow-sm border tw-rounded-3xl overflow-hidden d-flex flex-column">
                                <div class="position-relative">
                                    <a href="/blogs/${blog.slug}" class="d-block">
                                        <img src="${blog.image}" alt="${blog.title}" class="tw-rounded-0 w-100 h-100"
                                            style="max-height: 250px; object-fit: cover;">
                                    </a>
                                </div>
                                <div class="p-4 d-flex flex-column justify-content-between h-100">
                                    <div class="tw-mb-3">
                                        <h2 class="tw-mb-2">
                                            <a href="/blogs/${blog.slug}" class="text-dark fw-medium">
                                                ${blog.title}
                                            </a>
                                        </h2>
                                        <p class="tw-text-sm text-neutral-600">
                                            ${excerpt}
                                        </p>
                                    </div>
                                    <a href="/blogs/${blog.slug}"
                                        class="tw-text-sm text-main-two-600 fw-bold hover-text-main-600 d-inline-flex align-items-center tw-gap-2 mt-auto">
                                        Read More
                                        <img src="{{asset('assets/images/icons/arrow-long.svg')}}" alt="arrow">
                                    </a>
                                </div>
                            </div>
                        </div>
                    `;
                        blogList.insertAdjacentHTML('beforeend', blogHTML);
                    });

                    page++;
                    hasMore = data.has_more;

                    if (!hasMore) {
                        document.getElementById('end-message').style.display = 'block';
                    }

                    isLoading = false;
                    document.getElementById('loading-spinner').style.display = 'none';
                })
                .catch(error => {
                    console.error('Error loading blogs:', error);
                    isLoading = false;
                    document.getElementById('loading-spinner').style.display = 'none';
                });
        }
    </script>
@endpush


<script>
    document.addEventListener('DOMContentLoaded', function() {
        document.getElementById('search').addEventListener('input', function() {
            const value = this.value.trim();
            const length = value.length;

            console.log("Search Value:", value);
            console.log("Length:", length);

            if (length >= 3) {
                // Call your search function
                searchBlogs(value);
            }
            if (length < 1) {
                // Call your search function
                page = 1;
                isLoading = false;
                hasMore = true;
                const blogList = document.getElementById('blog-list');
                blogList.innerHTML = ''; // clear previous results
                loadBlogs();
            }
        });
    });


    function searchBlogs(query) {
        console.log("Searching blogs for:", query);
        let excerpt = "";
        fetch(`/search-blogs?search=${encodeURIComponent(query)}`)
            .then(response => response.json())
            .then(data => {
                const blogList = document.getElementById('blog-list');
                blogList.innerHTML = ''; // clear previous results
                document.getElementById('end-message').style.display = 'none';

                if (data.blogs.length === 0) {
                    blogList.innerHTML = `<div class="col-12 text-center text-muted py-4">${data.message}</div>`;
                    return;
                }
                data.blogs.forEach(blog => {
                    excerpt = blog.content.replace(/<\/?[^>]+(>|$)/g, '').substring(0, 100) + '...';

                    const blogHTML = `
                    <div class="col-lg-4 col-md-6 mb-5" data-aos="fade-up" data-aos-duration="800">
                        <div class="h-100 shadow-sm border tw-rounded-3xl overflow-hidden d-flex flex-column">
                            <div class="position-relative">
                                <a href="/blogs/${blog.slug}" class="d-block">
                                    <img src="/${blog.image}" alt="${blog.title}" class="tw-rounded-0 w-100 h-100"
                                        style="max-height: 250px; object-fit: cover;">
                                </a>
                            </div>
                            <div class="p-4 d-flex flex-column justify-content-between h-100">
                                <div class="tw-mb-3">
                                    <h2 class="tw-mb-2">
                                        <a href="/blogs/${blog.slug}" class="text-dark fw-medium">
                                            ${blog.title}
                                        </a>
                                    </h2>
                                    <p class="tw-text-sm text-neutral-600">
                                        ${excerpt}
                                    </p>
                                </div>
                                <a href="/blogs/${blog.slug}"
                                    class="tw-text-sm text-main-two-600 fw-bold hover-text-main-600 d-inline-flex align-items-center tw-gap-2 mt-auto">
                                    Read More
                                    <img src="/assets/images/icons/arrow-long.svg" alt="arrow">
                                </a>
                            </div>
                        </div>
                    </div>
                `;
                    blogList.insertAdjacentHTML('beforeend', blogHTML);
                });
            })
            .catch(error => {
                console.error('Search failed:', error);
            });
    }
</script>

