@extends('website.layout')


@section('meta')
    <title>{{ $blog->seo_title }}</title>
    <meta name="description" content="{{ $blog->seo_description }}">
    <meta name="keywords" content="{{ $blog->seo_keywords }}">

    {{-- Open Graph --}}
    <meta property="og:title" content="{{ $blog->seo_title }}">
    <meta property="og:description" content="{{ $blog->seo_description }}">
    @if ($blog->image)
        <meta property="og:image" content="{{ url($blog->image) }}">
    @endif
    <meta property="og:type" content="article">
    <meta property="og:url" content="{{ url()->current() }}">

    {{-- Twitter / X --}}
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="{{ $blog->seo_title }}">
    <meta name="twitter:description" content="{{ $blog->seo_description }}">
    @if ($blog->image)
        <meta name="twitter:image" content="{{ url($blog->image) }}">
    @endif


{{-- Blog Schema --}}
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "BlogPosting",
  "mainEntityOfPage": {
    "@type": "WebPage",
    "@id": "{{ url()->current() }}"
  },
  "headline": "{{ $blog->title }}",
  "description": "{{ $blog->seo_description }}",
  "image": "{{ $blog->image ? url($blog->image) : '' }}",
  "author": {
    "@type": "Organization",
    "name": "Leadmine.pro",
    "url": "https://leadmine.pro"
  },
  "publisher": {
    "@type": "Organization",
    "name": "Leadmine.pro",
    "logo": {
      "@type": "ImageObject",
      "url": "https://leadmine.pro/web/assets/images/headlogo.webp"
    }
  },
  "datePublished": "{{ date('Y-m-d', strtotime($blog->created_at)) }}",
  "dateModified": "{{ date('Y-m-d', strtotime($blog->updated_at)) }}"
}

</script>



{{-- Breadcrumb Schema --}}

<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "BreadcrumbList",
  "itemListElement": [
    {
      "@type": "ListItem",
      "position": 1,
      "name": "Home",
      "item": "https://leadmine.pro"
    },
    {
      "@type": "ListItem",
      "position": 2,
      "name": "Blogs",
      "item": "https://leadmine.pro/blogs"
    },
    {
      "@type": "ListItem",
      "position": 3,
      "name": "{{ $blog->title }}",
      "item": "{{ url()->current() }}"
    }
  ]
}
</script>





    <style>
        body {
            font-family: 'Poppins', sans-serif !important;
            color: #444 !important;
        }


        .blog-title {
            font-size: 40px;
            color: #2c3e50;
            font-weight: 700;
            margin-bottom: 24px;
        }

        .blog-content {
            font-size: 18px;
            line-height: 1.7;
            color: #444;
        }

        .blog-content strong {
            font-weight: 600;
        }

        .blog-content ul,
        .blog-content ol {
            margin-left: 1.5rem;
            padding-left: 1.5rem;
        }

        .blog-content li {
            margin-bottom: 0.6rem;
        }

        /* .blog-content h2 strong {
            font-weight: 300 !important;
            font-size: 30px !important;
        }

        h2,
        .h2 {
            font-weight: 500 !important;
            font-size: 40px !important;
        }

        .blog-content h3 strong {
            font-weight: 400 !important;
            font-size: 28px !important;
        }

        .blog-content p strong {
            font-weight: 300 !important;
            font-size: 20px !important;
        } */


.blog-content h1 { font-size: 32px; font-weight: 600; margin-bottom: 20px; }
.blog-content h2 { font-size: 28px; font-weight: 500; margin-bottom: 18px; }
.blog-content h3 { font-size: 24px; font-weight: 500; margin-bottom: 16px; }
.blog-content h4 { font-size: 20px; font-weight: 500; margin-top: 20px; margin-bottom: 8px; }
.blog-content h5 { font-size: 18px; font-weight: 500; margin-top: 16px; margin-bottom: 6px; }
.blog-content h6 { font-size: 16px; font-weight: 500; margin-top: 14px; margin-bottom: 6px; }


.blog-content p,
.blog-content li {
    font-size: 16px;
    line-height: 1.7;
    margin-bottom: 16px;  
}


.blog-content strong {
    font-weight: 600 !important;
    font-size: inherit !important;
}



        .blog-content a {
            color: #2f74c0;
            text-decoration: underline;
        }

        .blog-content a:hover {
            color: #1a4e80;
        }

        .blog-content ul {
            list-style-type: disc;
            margin-left: 1.5rem;
            padding-left: 1.5rem;
        }

        .blog-content ol {
            list-style-type: decimal;
            margin-left: 1.5rem;
            padding-left: 1.5rem;
        }


        .widget h2 {
            font-weight: bold;
            border-bottom: 2px solid #c00;
            /* red underline */
            padding-bottom: 5px;
            margin-bottom: 15px;
        }

        .widget ul li a:hover {
            color: #c00;
            /* highlight on hover */
        }

        .tags-widget {
            padding: 20px 0;
        }

        .tag-title {
            font-weight: 700;
            text-transform: uppercase;
            margin-bottom: 10px;
            border-bottom: 2px solid #e31e25;
            display: inline-block;
        }

        .tag-list {
            display: flex;
            flex-wrap: wrap;
            gap: 10px;
        }

        .tag-item {
            display: inline-block;
            padding: 6px 14px;
            border: 1px solid #e4e4e4;
            border-radius: 30px;
            font-size: 14px;
            color: #333;
            background-color: #fff;
            text-decoration: none;
            transition: all 0.3s ease;
        }

        .tag-item:hover {
            background-color: #1d72f2;
            ;
            color: #fff;
            border-color: #1d72f2;
            ;
        }

         .tw-mb-6{
            font-size: clamp(1.125rem, 1.2rem + 0.722vw, 1.5rem);
         }

         .tw-mt-2{
         font-size: 1rem;
         }
    </style>
@endsection

@section('content')


@php
$categoryId = $blog->category;
@endphp
    <div id="smooth-wrapper">
        <div id="smooth-content">
            <!-- Breadcrumb Section -->
            <section class="section-bg-two mb-0" style="padding:100px 0">
                <div class="container">
                    <div class="row justify-content-center">
                        <div class="col-lg-8">
                            <div class="text-center">
                                <span class="tw-mb-4">
                                    <img src="{{ asset('web/assets/images/logo/favicon-two.png') }}" alt="favicon">
                                </span>
                                <h3 class="mb-0 splitTextStyleOne text-capitalize">Blog Detail</h3>
                                <h1 class="blog-title">{{ $blog->title }}</h1>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

            <!-- Blog Content -->
            <section class="py-60">
                <div class="container">
                    <div class="row gy-4">
                        <!-- Blog Main Column -->
                        <div class="col-lg-8">
                            <div data-aos="fade-up" data-aos-duration="800">
                                <div class="position-relative">
                                    @if ($blog->image)
                                        <img src="{{ asset($blog->image) }}" alt="{{ $blog->title }}"
                                            style="width: 100%; max-height: 500px; object-fit: cover;">
                                    @endif
                                </div>

                                <div class="tw-mt-10">
                                    <div class="tw-mb-4 d-flex align-items-center tw-gap-205 flex-wrap">
                                        <span class="tw-w-205 border border-neutral-200"></span>
                                        <span class="tw-w-205 border border-neutral-200"></span>
                                    </div>

                                    {{-- Blog Tags --}}
                                    <div class="mb-3">
                                        @foreach ($blog->tags as $tag)
                                            <a href="{{ route('blogs.tags', [$tag->name, $tag->id]) }}"
                                                class="badge bg-primary me-1">
                                                {{ $tag->name }}
                                            </a>
                                        @endforeach
                                    </div>

                                    <!-- Optional: Remove this if already shown above -->
                                    <h1 class="tw-mb-4 splitTextStyleOne" style="font-size:38px;">{{ $blog->title }}</h1>

                                    <!-- Blog Body Content with corrected headings -->

                                    <div class="tw-text-base text-neutral-600 tw-my-9 blog-content">
                                        {!! $blog->content !!}
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Sidebar Column -->
                        <div class="col-lg-4 ps-xl-5 ps-lg-4">
                            <div class="d-flex flex-column tw-gap-8">

                                @if (count($recentBlogs) > 0)

                                    <div class="bg-neutral-100 tw-px-8 tw-py-8" data-aos="fade-up">
                                        <h2
                                            class="border-start border-4 border-main-600 text-main-two-600 tw-ps-2 splitTextStyleOne tw-mb-6">
                                            Recent News</h2>
                                        <div class="d-flex flex-column tw-gap-8">
                                            @foreach ($recentBlogs as $blog)
                                                <div class="d-flex align-items-center tw-gap-6">
                                                    <a href="{{ route('blogs.public.show', $blog->slug) }}"
                                                        class="tw-rounded-md overflow-hidden flex-shrink-0">
                                                        <img src="{{ asset($blog->image ?? 'assets/images/thumbs/recent-post-img1.png') }}"
                                                            width="100" alt="{{ $blog->title }}">
                                                    </a>
                                                    <div>
                                                        <div class="d-flex align-items-center tw-gap-2">
                                                            <span class="text-main-600 tw-text-lg">
                                                                <i class="ph-bold ph-calendar-dots"></i>
                                                            </span>
                                                            <span class="text-main-two-600 fw-medium tw-text-sm">
                                                                {{ \Carbon\Carbon::parse($blog->updated_at)->format('M d, Y') }}

                                                            </span>
                                                        </div>
                                                        <h3 class="tw-mt-2">
                                                            <a href="{{ route('blogs.public.show', $blog->slug) }}"
                                                                class="tw-text-base line-clamp-2 text-main-two-600 hover-text-main-600 splitTextStyleOne">
                                                                {{ $blog->title }}
                                                            </a>
                                                        </h3>
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                @endif

                            </div>

                            <div class="d-flex flex-column tw-gap-8 mt-4">

                                @if (count($industries) > 0)

                                    <div class="widget border p-4">
                                        <h2 class="fw-bold border-bottom pb-2 mb-3 tw-mb-6">Category</h2>
                                        <ul class="list-unstyled mb-0">
                                            @foreach ($industries as $industry)

                                            @if($categoryId == $industry->id)
                                                <li class="border-bottom py-2">

                                                    @php
                                                        $decoded = urldecode($industry->name); // Decode '%20%26%20' etc.
                                                        $slug = Str::slug($decoded); // Convert to slug format
                                                    @endphp
                                                    <a href="{{ route('blogs.industry', Str::lower($slug)) }}"
                                                        class="text-decoration-none text-dark d-flex align-items-center">
                                                        <span class="me-2 text-muted">›</span> {{-- Arrow symbol --}}
                                                        <span>{{ $industry->name }}</span>
                                                    </a>
                                                </li>
                                                @endif
                                            @endforeach
                                        </ul>
                                    </div>
                                @endif

                            </div>
                            <div class="d-flex flex-column tw-gap-8 mt-4">

                            </div>
                            <div class="tags-widget">
                                <h2 class="tag-title tw-mb-6">TAGS</h2>
                                <div class="tag-list">
                                    @foreach ($tags as $tag)
                                        {{-- <a href="" class="tag-item"> --}}

                                        <a href="{{ route('blogs.tags', $tag->name) }}" class="tag-item">
                                            {{ $tag->name }}
                                        </a>
                                    @endforeach
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
@endsection
