 @extends('website.layout')

@section('meta')
<title>AI Customer Service Automation & Support | {{ config('app.site') }}</title>

<meta name="description" content="Transform your AI customer service with {{ config('app.site') }} — automate support calls, messaging, ticketing, and improve satisfaction with smart workflows.">

<meta name="keywords" content="AI customer service automation, automated customer support, AI support calls, AI messaging and ticketing, customer service workflows">

{{-- Open Graph --}}
<meta property="og:title" content="AI Customer Service Automation & Support | {{ config('app.site') }}">
<meta property="og:description" content="Transform your AI customer service with {{ config('app.site') }} — automate support calls, messaging, ticketing, and improve satisfaction with smart workflows.">
<meta property="og:image" content="{{ asset('web/assets/images/customer.webp') }}">
<meta property="og:type" content="website">
<meta property="og:url" content="{{ url()->current() }}">

{{-- Twitter / X --}}
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="AI Customer Service Automation & Support | {{ config('app.site') }}">
<meta name="twitter:description" content="Transform your AI customer service with {{ config('app.site') }} — automate support calls, messaging, ticketing, and improve satisfaction with smart workflows.">
<meta name="twitter:image" content="{{ asset('web/assets/images/customer.webp') }}">

@endsection







 @section('content')
<style>
.custom-img {
  margin-top: 180px;
}

 .paragraph-style {
  font-weight: 400;
  font-size: 18px;
}

.custom-heading {
  font-weight: 400;  
}

.max-width-40 {
  max-width: 40%;
}

@media (max-width: 768px) {
  .custom-img {
    margin-top: 50px;
  }
}
.pt-40 {
  padding-top: 40px;
}
.img-auto-warranty {
  max-height: 500px;
  width: 100%;
  object-fit: contain;
}

.img-deal-maxwidth{
  max-width: 35%;
}
.custom-padding-100 {
  padding: 100px 0;
}
.img-pitch-maxwidth {
  max-width: 30%;
}
.visually-hidden {
    position: absolute;
    width: 1px;
    height: 1px;
    padding: 0;
    margin: -1px;
    overflow: hidden;
    clip: rect(0, 0, 0, 0);
    white-space: nowrap;
    border: 0;
}
.as-h2 {
 font-size: clamp(1.5rem, 0.5569rem + 1.444vw, 1.875rem);
 }

.tw-mb-1{
 font-size: clamp(1.125rem, 1.2rem + 0.722vw, 1.5rem);
 }
</style>
 <!-- <section class="section-bg-two pb-50 overflow-hidden pt-40">
     <div class="container max-w-1290-px">
         <div class="row gy-5 align-items-center justify-content-center text-center">
             <div class="col-xl-12">
                 <div>
                     <div class="mx-auto tw-mb-12">
                          <h1 class="visually-hidden">Real Estate & Mortgage Intelligence</h1>
                         <h3 class="splitTextStyleOne text-heading heading-medium">
                             Real Estate & Mortgage Intelligence
                         </h3>
                         <p class="text-neutral-500 tw-mt-2 splitTextStyleOne max-w-770-px tw-text-lg mx-auto">
                             With real-time dashboards and performance scorecards, managers get a clear view of which
                             agents are driving deals—and who needs coaching.
                         </p>
                         <div class="tw-mt-2" data-aos="fade-up" data-aos-anchor-placement="top-bottom"
                             data-aos-duration="900">
                             <a href="{{ route('register') }}"
                                 class="hover--translate-y-1 active--translate-y-scale-9 btn button--stroke tw-gap-5 group active--translate-y-2 tw-rounded-xl text-capitalize tw-px-8 tw-py-505 fw-medium btn-main hover-style-one"
                                 data-block="button">
                                 <span class="button__flair"></span>
                                 <span class="button__label">Get started</span>
                             </a>
                         </div>
                     </div>
                 </div>
             </div>
         </div>
     </div>
 </section> -->
<section class="hero-section">
  <div class="hero-container">
    <div class="hero-left">
      <h1 class="text-white">
     Transform Customer Support with Leadmine.pro
      </h1>
      <p class="text-white">
     Deliver delightful customer support and handle complex situations using intelligent call routing, real-time assistance, AI-based call scores, and help desk integrations.
      <div class="hero-badges">
        <span class="text-white"><i class="fa fa-check-circle"></i> No credit card required</span>
        <span class="text-white"><i class="fa fa-check-circle"></i> 14 days of AI tools on us</span>
      </div>
    </div>

    <div class="hero-right mb-6">
      <div class="hero-image-wrapper">
        <img src="web/assets/images/customer.webp" alt="Customer support interaction with AI virtual assistant">

    
      </div>
    </div>
  </div>
</section>

<style>
.hero-section {
 background: linear-gradient(103deg, #160A33 28.21%, #261258 58.12%, #4B23B0 84.04%, #9677E4 105.97%, #CABBF2 131.89%);
  padding: 100px 0;
  font-family: "Inter", sans-serif;
}

.hero-container {
  max-width: 1250px;
  margin: auto;
  display: flex;
  align-items: center;
  justify-content: space-between;
  flex-wrap: wrap;
  gap: 70px;
}

.hero-left {
  flex: 1 1 520px;
}

.hero-left h1 {
  font-size: 42px;
  font-weight: 800;
  color: #1b1f3b;
  line-height: 1.25;
  margin-bottom: 25px;
  max-width: 500px;
}

.hero-left p {
  font-size: 18px;
  line-height: 1.7;
  color: #2b2b2b;
  margin-bottom: 35px;
  max-width: 520px;
  font-family: "Poppins", sans-serif; 
}

.hero-badges {
  display: flex;
  flex-wrap: wrap;
  gap: 20px;
  font-size: 16px;
  color: #1b1f3b;
}

.hero-badges i {
  color: #3b82f6;
  margin-right: 8px;
}

/* Right Side */
.hero-right {
  flex: 1 1 520px;
  display: flex;
  justify-content: center;
  position: relative;
}

.hero-image-wrapper {
  position: relative;
  width: 100%;
  max-width: 540px;
  border-radius: 20px;
  overflow: hidden;
  box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
}

.hero-image-wrapper img {
  width: 100%;
  display: block;
  object-fit: cover;
}

/* Agent Card */
.agent-card {
  position: absolute;
  top: 30px;
  left: 30px;
  background: #fff;
  border-radius: 16px;
  box-shadow: 0 6px 18px rgba(0, 0, 0, 0.1);
  padding: 16px 18px;
  max-width: 280px;
  border: 1px solid #e5e9ff;
}

.agent-card h4 {
  font-size: 15px;
  font-weight: 700;
  color: #1c2250;
  margin-bottom: 10px;
}

.agent-tabs {
  display: flex;
  gap: 6px;
  margin-bottom: 10px;
}

.agent-tabs .tab {
  flex: 1;
  font-size: 13px;
  text-align: center;
  padding: 6px 0;
  border-radius: 6px;
  background: #eef1ff;
  color: #4a4e74;
  font-weight: 600;
}

.agent-tabs .tab.active {
  background: #3b82f6;
  color: #fff;
}

.agent-message {
  font-size: 14px;
  color: #2b2b2b;
  background: #f9faff;
  padding: 12px;
  border-radius: 10px;
  line-height: 1.5;
  margin-bottom: 10px;
}

.agent-feedback {
  display: flex;
  justify-content: space-between;
  font-size: 13px;
  color: #3b82f6;
  font-weight: 600;
}

/* Responsive */
@media (max-width: 992px) {
  .hero-container {
    flex-direction: column;
    text-align: center;
  }

  .hero-left h1 {
    font-size: 36px;
    max-width: 100%;
  }

  .hero-left p {
    margin: 0 auto 30px;
  }

  .hero-badges {
    justify-content: center;
  }

  .hero-image-wrapper {
    margin-top: 40px;
  }

  .agent-card {
    position: static;
    margin: 20px auto 0;
  }
}

.secure-section {
  background: linear-gradient(180deg, #f2f4ff 0%, #ffffff 100%);
  padding: 100px 0;
  font-family: "Poppins", sans-serif; 
}

.secure-container {
  max-width: 1250px;
  margin: auto;
  display: flex;
  align-items: center;
  justify-content: space-between;
  flex-wrap: wrap;
  gap: 70px;
}

.secure-left {
  flex: 1 1 520px;
}

.secure-left h1 {
  font-size: 42px;
  font-weight: 800;
  color: #1b1f3b;
  line-height: 1.25;
  margin-bottom: 25px;
  max-width: 500px;
}

.secure-left p {
  font-size: 18px;
  line-height: 1.8;
  color: #2b2b2b;
  margin: 20px 0 30px 0; 
  max-width: 520px;
}

.secure-badges {
  display: flex;
  flex-wrap: wrap;
  gap: 20px;
  font-size: 16px;
  color: #1b1f3b;
}

.secure-badges i {
  color: #3b82f6;
  margin-right: 8px;
}

/* Right Side */
.secure-right {
  flex: 1 1 520px;
  display: flex;
  justify-content: center;
  position: relative;
}

.secure-image-wrapper {
  position: relative;
  width: 100%;
  max-width: 540px;
  border-radius: 20px;
  overflow: hidden;
  box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
  background: #fff;
}

.secure-image-wrapper img {
  width: 100%;
  display: block;
  object-fit: cover;
}


@media (max-width: 992px) {
  .secure-container {
    flex-direction: column;
    text-align: center;
  }

  .secure-left h1 {
    font-size: 34px;
    max-width: 100%;
  }

  .secure-left p {
    margin: 20px auto 30px; 
  }

  .secure-badges {
    justify-content: center;
  }

  .secure-image-wrapper {
    margin-top: 40px;
  }
}

</style>



<section class="switch-section py-5">
  <div class="container text-center">
    <div class="tw-mb-13 text-center">
      <span
        class="tw-py-1 tw-px-705 bg-main-50 text-main-600 tw-text-sm fw-bold text-capitalize rounded-pill tw-mb-205">
        Why {{ config('app.site') }}?
      </span>

      <h3 class="splitTextStyleOne custom-perspective">
        <div class="split-line custom-centered-title">
          Customer Service Challenges Companies Face
        </div>
      </h3>

      <p class="text-gray-600 tw-max-w-[700px] mx-auto mt-3">
        Traditional customer support struggles with efficiency, cost, and consistency. These challenges directly impact
        customer satisfaction and business growth.
      </p>
    </div>

    <div class="row g-4">
      <!-- Card 1 -->
      <div class="col-md-4">
        <div class="switch-card">
          <img src="web/assets/images/call.svg" alt="Long Wait Times" class="icon">
          <h5>Long Wait Times</h5>
          <p>
            Customers wait 5–15 minutes on average, leading to frustration and abandoned calls.
          </p>
        </div>
      </div>

      <!-- Card 2 -->
      <div class="col-md-4">
        <div class="switch-card">
          <img src="web/assets/images/chart.svg" alt="High Operational Costs" class="icon">
          <h5>High Operational Costs</h5>
          <p>
            Hiring, training, and maintaining large support teams is expensive and time-consuming.
          </p>
        </div>
      </div>

      <!-- Card 3 -->
      <div class="col-md-4">
        <div class="switch-card">
          <img src="web/assets/images/thumbs-down.svg" alt="Inconsistent Service Quality" class="icon">
          <h5>Inconsistent Service Quality</h5>
          <p>
            Verbal orders on the phone can lead to mistakes — especially with accents, background noise, or fast talkers.
          </p>
        </div>
      </div>

      <!-- Card 4 -->
      <div class="col-md-4">
        <div class="switch-card">
          <img src="web/assets/images/time.svg" alt="Limited Availability" class="icon">
          <h5>Limited Availability</h5>
          <p>
            Traditional support operates during business hours, missing global customer needs.
          </p>
        </div>
      </div>

      <!-- Card 5 -->
      <div class="col-md-4">
        <div class="switch-card">
          <img src="web/assets/images/User.svg" alt="High Employee Turnover" class="icon">
          <h5>High Employee Turnover</h5>
          <p>
            Support roles have a 75% annual turnover rate, causing constant training and knowledge loss.
          </p>
        </div>
      </div>

      <!-- Card 6 -->
      <div class="col-md-4">
        <div class="switch-card">
          <img src="web/assets/images/block.svg" alt="Failed Outsourcing Attempts" class="icon">
          <h5>Failed Outsourcing Attempts</h5>
          <p>
            Companies outsource phone support to reduce costs but often get poor service, language barriers, and disconnected customer experiences.
          </p>
        </div>
      </div>
    </div>

    <!-- CTA -->
<div class="cta-text text-center mt-5">
  🚀 Ready to eliminate these challenges? 
  <a href="{{ route('register') }}" class="cta-link">
    Try Leadmine.pro Today
  </a>
</div>

  </div>
</section>



<style>
.cta-text {
  font-family: 'Poppins', sans-serif;
  font-size: 1.1rem;
}

.cta-text .cta-link {
  color: #0d6efd;
  text-decoration: none;
  font-weight: 600;
}

.cta-text .cta-link:hover {
  text-decoration: underline;
}

.switch-section {
  background: #fff;
}

.switch-card {
  background: #fff;
  border: 1px solid #e6e6e6;
  border-radius: 16px;
  padding: 40px 25px;
  height: 100%;
  text-align: left;
  transition: all 0.3s ease;
}

.switch-card:hover {
  box-shadow: 0 8px 20px rgba(0, 0, 0, 0.05);
  transform: translateY(-3px);
}

.switch-card .icon {
  width: 60px;
  height: 60px;
  background: #f0f4ff;
  border-radius: 12px;
  padding: 10px;
  margin-bottom: 20px;
}

.switch-card h5 {
  font-weight: 700;
  color: #0b1b4f;
  margin-bottom: 15px;
  font-size: 1.15rem;
}

.switch-card p {
  color: #4f5b7d;
  font-size: 0.95rem;
  line-height: 1.6;
}


.callchex-section {
  background: #fff;
}
.info-card {
  background: #fff;
  border-radius: 12px;
  padding: 25px;
  box-shadow: 0 2px 8px rgba(0,0,0,0.08);
  height: 100%;
  text-align: center;
  transition: all 0.3s ease;
}
.info-card:hover {
  box-shadow: 0 6px 16px rgba(0,0,0,0.12);
  transform: translateY(-4px);
}
.info-title {
  font-family: 'Poppins', sans-serif;
  font-weight: 600;
  font-size: 1.1rem;
  margin-bottom: 12px;
  background: linear-gradient(90deg, #e91e63, #3f51b5);
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
}
.info-text {
  font-family: 'Jost', sans-serif;
  font-size: 0.95rem;
  color: #444;
  line-height: 1.6;
}
</style>


 



<!-- ================== Driven section Start ====================== -->

<h2 class="main-heading text-center mb-4 mt-2">
  Deliver exceptional customer support with AI-powered efficiency
</h2>

<section class="ai-section py-5">
  <div class="container">

    <!-- Section 1 -->
    <h3 class="sub-heading text-center mb-3">
      Intelligent call routing for efficient support
    </h3>
    <div class="row align-items-center mb-5 custom-gap-fix">
      <div class="col-lg-6">
        <p class="section-text">
          Ensure every customer connects with the right agent. Automatically direct callers to the most appropriate agent with intelligent inbound call flows and advanced IVR menus, delivering resolution at the first touchpoint.
        </p>
        <ul class="section-list">
          <li>AI-powered call routing to the right agents</li>
          <li>Custom IVR menus for seamless navigation</li>
          <li>Instant connections for faster resolutions</li>
          <li>Improved first-contact resolution rates</li>
        </ul>
      </div>

      <div class="col-lg-6 text-center">
        <img src="{{ asset('web/assets/images/support3.webp') }}" 
             alt="Intelligent call routing for efficient support"
             class="img-fluid section-img">
      </div>
    </div>

    <!-- Section 2 -->
    <h3 class="sub-heading text-center mb-3">
      AI-Driven training & coaching
    </h3>
    <div class="row align-items-center mb-5 flex-row-reverse">
      <div class="col-lg-6">
        <p class="section-text">
          Fast-track the onboarding of your customer support agents with {{ config('app.site') }}’s advanced call coaching. Leverage real-time feeds, AI-enhanced call insights, and versatile in-call modes to guide, assist, and ensure your team delivers top-notch support.
        </p>
        <ul class="section-list">
          <li>AI-assisted call coaching in real time</li>
          <li>Whisper and barge-in modes for live training</li>
          <li>Actionable call analytics for continuous improvement</li>
          <li>Faster onboarding with interactive guidance</li>
        </ul>
      </div>
      <div class="col-lg-6 text-center">
        <img src="{{ asset('web/assets/images/support1.webp') }}" 
             alt="AI-driven training and coaching for support agents"
             class="img-fluid section-img">
      </div>
    </div>

    <!-- Section 3 -->
    <h3 class="sub-heading text-center mb-3">
      Conversation intelligence
    </h3>
    <div class="row align-items-center mb-5 custom-gap-fix">
      <div class="col-lg-6">
        <p class="section-text">
          Harness the power of real-time agent assistance and prompts to deliver superior support. Capture every detail with live call transcripts and summaries, ensuring quality assurance and precise call scoring.
        </p>
        <ul class="section-list">
          <li>Real-time call transcription and summaries</li>
          <li>AI prompts and cues during live interactions</li>
          <li>Comprehensive call scoring and feedback</li>
          <li>Improved QA and agent performance insights</li>
        </ul>
      </div>
      <div class="col-lg-6 text-center">
        <img src="{{ asset('web/assets/images/support2.webp') }}" 
             alt="Conversation intelligence for superior support"
             class="img-fluid section-img">
      </div>
    </div>

    <div class="text-center mt-4">
      <a href="{{ route('register') }}" class="btn btn-primary px-4 py-2 rounded-pill">Start Free Trial</a>
    </div>

  </div>
</section>

<!-- ================== Driven section End ====================== -->

<style>
.main-heading {
  font-size: 2.2rem;
  font-weight: 700;
  color: #000; 
}

.ai-section {
  background: #0b1a33;
  color: #fff;
  padding: 50px 0;
}

.sub-heading {
  font-size: 1.4rem;
  font-weight: 600;
  margin-bottom: 6px; 
}

.section-text {
  font-size: 1rem;
  line-height: 1.6;
  margin-bottom: 8px;
  max-width: 440px;  
  text-align: left; 
}


.section-list {
  padding-left: 18px;
  margin-bottom: 8px;
}

.section-list li {
  margin-bottom: 5px;
  list-style: disc;
}

.section-link {
  color: #4e9eff;
  font-weight: 600;
  text-decoration: none;
}

.section-link:hover {
  text-decoration: underline;
}


.section-img {
  max-width: 390px;
  width: 100%;
  height: auto;
  border-radius: 6px;
  box-shadow: 0 3px 12px rgba(0,0,0,0.25);
  margin: 0 auto;
}


.row.align-items-center {
  display: flex;
  justify-content: space-between;  
  align-items: center;
  margin: 0;  
}



.row.align-items-center .col-lg-6 {
  flex: 0 0 auto;
  width: 50%;
  max-width: 50%;
  padding: 0 15px;  
}


.custom-gap-fix .col-lg-6:first-child {
  padding-left: 200px !important;
}


@media (max-width: 991px) {
  .custom-gap-fix .col-lg-6:first-child {
    padding-left: 0 !important;
  }
}




.row.align-items-center.flex-row-reverse {
  flex-direction: row-reverse;
}


@media (max-width: 991px) {
  .row.align-items-center,
  .row.align-items-center.flex-row-reverse {
    flex-direction: column;
  }

  .row.align-items-center .col-lg-6 {
    width: 100%;
    max-width: 100%;
    padding: 0;  
  }

  .section-img {
    margin-top: 12px;
    max-width: 100%;
  }
}

/* Tablet only (768px - 991px) */
@media (min-width: 768px) and (max-width: 991px) {
  .section-img {
    max-width: 65%;
    margin: 15px auto;
    display: block;
  }

  .section-text {
    max-width: 80%;
    margin: 0 auto 12px;
    font-size: 0.95rem;
    line-height: 1.5;
    text-align: center;
  }

  .section-list {
    max-width: 80%;
    margin: 0 auto 12px;
    padding-left: 0;
    list-style-position: inside;
    text-align: center; 
  }

  .section-list li {
    display: block;
    text-align: center;
    margin: 6px 0;
  }

  .section-link {
    display: block;
    text-align: center;
    margin-top: 10px;
    font-size: 0.95rem;
    word-break: break-word;
  }

  .sub-heading {
    font-size: 1.2rem;
    text-align: center;
    margin-bottom: 10px;
  }

  .main-heading {
    font-size: 1.8rem;
    text-align: center;
    margin-bottom: 12px;
  }

}

.callchex-section{
  background-color:#fff;
}

.as-h2{
  font-size:2.2rem; 
  font-family:'Poppins', sans-serif;
}

.lead{
  max-width:800px; 
  margin:0 auto; 
  font-size:1.1rem;
  font-family:'Jost', sans-serif;
}

.new-text{
  font-size:1rem;
}

.as-h3{
  color:#1351d8; 
  font-size:3rem; 
  font-weight:700;
}

.callchex-row{
  font-family:'Jost', sans-serif;
}
</style>




<!-- Proven Impact Section -->
<section class="callchex-section py-50">
  <div class="container max-w-1200-px">
    <!-- Heading -->
    <div class="text-center mb-5">
      <h2 class="fw-bold as-h2">
        Proven Impact. Real Results
      </h2>
      <p class="lead text-muted mt-3">
        Healthcare practices using our AI voice reminders see dramatic improvements in attendance rates.
      </p>
    </div>

    <!-- Stats -->
    <div class="row text-center callchex-row justify-content-center">
      <div class="col-lg-3 col-md-6 mb-4">
        <h3 class="as-h3">70%</h3>
        <p class="text-muted new-text">Reduction in No-Shows</p>
      </div>

      <div class="col-lg-3 col-md-6 mb-4">
        <h3 class="as-h3">95%</h3>
        <p class="text-muted new-text">Call Answer Rate</p>
      </div>

      <div class="col-lg-3 col-md-6 mb-4">
        <h3 class="as-h3">$180K</h3>
        <p class="text-muted new-text">Annual Revenue Recovery</p>
      </div>

      <div class="col-lg-3 col-md-6 mb-4">
        <h3 class="as-h3">85%</h3>
        <p class="text-muted new-text">Slot Fill Rate</p>
      </div>
    </div>
  </div>
</section>




<section class="faq-two py-50 bg-aliceblue">
  <div class="container">
    <div class="row gy-4">
      <div class="col-lg-12 d-flex">
        <div class="m-auto">
          <h2 class="visually-hidden">Frequently Asked Questions</h2>
          <h3 class="splitTextStyleOne text-heading text-capitalize heading-medium">
            Frequently Asked Questions
          </h3>
        </div>
      </div>

      <div class="col-lg-12">
        <div class="ps-xl-5">
          <div class="accordion common-accordion style-two arrow-bg-orange" id="accordionExample">

            <!-- Q1 -->
            <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-blue border-0 mb-0"
              data-aos="fade-up">
              <h3 class="accordion-header d-flex align-items-center justify-content-between tw-gap-3">
                <button class="accordion-button shadow-none p-0 line-clamp-3 bg-transparent h5"
                  type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne"
                  aria-expanded="true" aria-controls="collapseOne">
                  What is customer service and support software?
                </button>
              </h3>
              <div id="collapseOne" class="accordion-collapse collapse show"
                data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 tw-leading-212 heading-medium">
                    Customer service and customer support software is a technology designed to streamline support requests, issues, and customer queries. It collects, analyzes, and reports customer happiness data. Some of the top features are ticket management tools, knowledge base, live chat, email management, various reporting capabilities and analytics, and CRM integration.
                  </p>
                </div>
              </div>
            </div>

            <!-- Q2 -->
            <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-blue border-0 mb-0"
              data-aos="fade-up">
              <h3 class="accordion-header d-flex align-items-center justify-content-between tw-gap-3">
                <button class="accordion-button shadow-none p-0 line-clamp-3 bg-transparent h5 collapsed"
                  type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo"
                  aria-expanded="false" aria-controls="collapseTwo">
                  How much does customer service software cost?
                </button>
              </h3>
              <div id="collapseTwo" class="accordion-collapse collapse"
                data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 tw-leading-212 heading-medium">
                    The cost of customer service tools depends on how many users access the platform, type of software, and the volume of tickets handled. CRM software can range from $30–$100 per month for small and medium-sized businesses. Help desk software can cost $60 per agent per month. Before locking a plan, try a free trial or demo to assess whether that tool is a good fit for your business.
                  </p>
                </div>
              </div>
            </div>

            <!-- Q3 -->
            <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-blue border-0 mb-0"
              data-aos="fade-up">
              <h3 class="accordion-header d-flex align-items-center justify-content-between tw-gap-3">
                <button class="accordion-button shadow-none p-0 line-clamp-3 bg-transparent h5 collapsed"
                  type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree"
                  aria-expanded="false" aria-controls="collapseThree">
                  What is the difference between customer service and customer support?
                </button>
              </h3>
              <div id="collapseThree" class="accordion-collapse collapse"
                data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 tw-leading-212 heading-medium">
                    Customer service is a broader term that includes all aspects of customer experience—right from initial contact to post-purchase support. It aims to improve customer satisfaction and loyalty by exceeding their expectations. Customer support is a specific type of customer service that focuses on providing assistance and resolving issues related to a product or service. It often involves technical problem-solving and troubleshooting.
                  </p>
                </div>
              </div>
            </div>

            <!-- Q4 -->
            <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-transparent border-0 mb-0"
              data-aos="fade-up">
              <h3 class="accordion-header d-flex align-items-center justify-content-between tw-gap-3">
                <button class="accordion-button shadow-none p-0 line-clamp-3 bg-transparent h5 collapsed"
                  type="button" data-bs-toggle="collapse" data-bs-target="#collapseFour"
                  aria-expanded="false" aria-controls="collapseFour">
                  Can I use a CRM for customer service?
                </button>
              </h3>
              <div id="collapseFour" class="accordion-collapse collapse"
                data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 tw-leading-212 heading-medium">
                    Yes, you can use a CRM system for customer service. CRMs help your customer service agents track customer conversations and access a record of all incoming messages and past issues so they can use real-time insights to give more informed answers.
                  </p>
                </div>
              </div>
            </div>

            <!-- Q5 -->
            <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-transparent border-0 mb-0"
              data-aos="fade-up">
              <h3 class="accordion-header d-flex align-items-center justify-content-between tw-gap-3">
                <button class="accordion-button shadow-none p-0 line-clamp-3 bg-transparent h5 collapsed"
                  type="button" data-bs-toggle="collapse" data-bs-target="#collapseFive"
                  aria-expanded="false" aria-controls="collapseFive">
                  What is the difference between CRM and customer service software?
                </button>
              </h3>
              <div id="collapseFive" class="accordion-collapse collapse"
                data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 tw-leading-212 heading-medium">
                    CRM helps manage all aspects of customer experience, including sales and data management, and includes features for salesforce automation like lead management, opportunity tracking, and pipeline management. Customer service software focuses on managing customer inquiries, complaints, and support requests. Help desk software often includes ticketing systems and built-in knowledge bases for storing FAQs and other helpful information. These tools integrate with live chat and email platforms to facilitate customer communication.
                  </p>
                </div>
              </div>
            </div>

            <!-- Q6 -->
            <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-transparent border-0 mb-0"
              data-aos="fade-up">
              <h3 class="accordion-header d-flex align-items-center justify-content-between tw-gap-3">
                <button class="accordion-button shadow-none p-0 line-clamp-3 bg-transparent h5 collapsed"
                  type="button" data-bs-toggle="collapse" data-bs-target="#collapseSix"
                  aria-expanded="false" aria-controls="collapseSix">
                  Is it easy to implement customer service software?
                </button>
              </h3>
              <div id="collapseSix" class="accordion-collapse collapse"
                data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 tw-leading-212 heading-medium">
                    Yes, it is easy to implement a customer service software depending upon its features, structure of your organization, and vendor support. Clearly define your goals, create timelines for resource allocation, get buy-in from key stakeholders, make the most of vendor resources such as training materials, and conduct thorough testing to address any issues.
                  </p>
                </div>
              </div>
            </div>

            <!-- Q7 -->
            <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-transparent border-0 mb-0"
              data-aos="fade-up">
              <h3 class="accordion-header d-flex align-items-center justify-content-between tw-gap-3">
                <button class="accordion-button shadow-none p-0 line-clamp-3 bg-transparent h5 collapsed"
                  type="button" data-bs-toggle="collapse" data-bs-target="#collapseSeven"
                  aria-expanded="false" aria-controls="collapseSeven">
                  How do you migrate data while switching to customer service software?
                </button>
              </h3>
              <div id="collapseSeven" class="accordion-collapse collapse"
                data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 tw-leading-212 heading-medium">
                    To migrate your data to a new customer service software, first assess what data you need—old user records, customer health scores, and knowledge base articles. Export this data from your existing system in a compatible CSV or XML format and clean it up. Then, import the data into the new system. Check that the data is correct and test the new system to make sure all workflows are working as expected.
                  </p>
                </div>
              </div>
            </div>

            <!-- Q8 -->
            <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-transparent border-0 mb-0"
              data-aos="fade-up">
              <h3 class="accordion-header d-flex align-items-center justify-content-between tw-gap-3">
                <button class="accordion-button shadow-none p-0 line-clamp-3 bg-transparent h5 collapsed"
                  type="button" data-bs-toggle="collapse" data-bs-target="#collapseEight"
                  aria-expanded="false" aria-controls="collapseEight">
                  How to manage customers’ data securely through customer service software?
                </button>
              </h3>
              <div id="collapseEight" class="accordion-collapse collapse"
                data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 tw-leading-212 heading-medium">
                    To keep customer data safe on a customer service software, choose a provider with data security certifications such as ISO 27001 or SOC 2. Restrict employee access to sensitive customer data. Use encryption to protect data while it’s stored and transmitted to other platforms. Keep the infrastructure updated and train your employees on best practices like password management, phishing prevention, and handling sensitive information.
                  </p>
                </div>
              </div>
            </div>

          </div> <!-- accordion end -->
        </div>
      </div>
    </div>
  </div>
</section>


<section class="py-50">
    <div class="container">
        <div class="text-center">
            <h3 class="main-heading text-capitalize mb-4">
              Transform Every Call Into a Growth Opportunity?
            </h3>
            <p class="max-w-780-px mx-auto tw-mb-6">
             Empower your team with Leadmine.pro — the AI-driven platform that analyzes every call, scores leads automatically, and helps you close deals faster.
            </p>

            <div class="d-flex flex-column align-items-center">
                <p class="fw-semibold tw-mb-4">
                    🔥 Don’t wait — start transforming your calls today. 
                    <a href="{{ route('register') }}"
                       class="btn btn-main hover-style-one tw-rounded-xl tw-px-4 tw-py-2 fw-medium text-capitalize ms-2">
                        👉 Get Started Now
                    </a>
                </p>
                   <p class="fw-semibold mt-3">Follow us on <a href="https://www.instagram.com/leadmine.pro/">Instagram</a>🔥</p>
                <p class="fw-semibold mt-3">Connect with us on <a href="https://www.linkedin.com/in/leadminepro/">LinkedIn</a>🔥</p>
            </div>
        </div>
    </div>
</section>


 


 @endsection