@extends('website.layout')

@section('meta')
   <title>Education Automation & Student Engagement | {{ config('app.site') }}</title>
<meta name="description" content="Enhance student engagement, automate reminders, and streamline academic workflows with AI-powered education solutions from {{ config('app.site') }}.">

<meta name="keywords" content="AI education assistant, AI solutions for education, Education enquiry handling">

{{-- Open Graph --}}
<meta property="og:title" content="Education Automation & Student Engagement | {{ config('app.site') }}">
<meta property="og:description" content="Enhance student engagement, automate reminders, and streamline academic workflows with AI-powered education solutions from {{ config('app.site') }}.">
<meta property="og:image" content="{{ asset('web/assets/images/education.webp') }}">
<meta property="og:type" content="website">
<meta property="og:url" content="{{ url()->current() }}">

{{-- Twitter / X --}}
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Education Automation & Student Engagement | {{ config('app.site') }}">
<meta name="twitter:description" content="Enhance student engagement, automate reminders, and streamline academic workflows with AI-powered education solutions from {{ config('app.site') }}.">
<meta name="twitter:image" content="{{ asset('web/assets/images/education.webp') }}">

@endsection





 @section('content')
<style>
.custom-img {
  margin-top: 180px;
}

 .paragraph-style {
  font-weight: 400;
  font-size: 18px;
}

.custom-heading {
  font-weight: 400;  
}

.max-width-40 {
  max-width: 40%;
}

@media (max-width: 768px) {
  .custom-img {
    margin-top: 50px;
  }
}
.pt-40 {
  padding-top: 40px;
}
.img-auto-warranty {
  max-height: 500px;
  width: 100%;
  object-fit: contain;
}

.img-deal-maxwidth{
  max-width: 35%;
}
.custom-padding-100 {
  padding: 100px 0;
}
.img-pitch-maxwidth {
  max-width: 30%;
}
.visually-hidden {
    position: absolute;
    width: 1px;
    height: 1px;
    padding: 0;
    margin: -1px;
    overflow: hidden;
    clip: rect(0, 0, 0, 0);
    white-space: nowrap;
    border: 0;
}
.as-h2 {
 font-size: clamp(1.5rem, 0.5569rem + 1.444vw, 1.875rem);
 }

.tw-mb-1{
 font-size: clamp(1.125rem, 1.2rem + 0.722vw, 1.5rem);
 }
</style>
 <!-- <section class="section-bg-two pb-50 overflow-hidden pt-40">
     <div class="container max-w-1290-px">
         <div class="row gy-5 align-items-center justify-content-center text-center">
             <div class="col-xl-12">
                 <div>
                     <div class="mx-auto tw-mb-12">
                          <h1 class="visually-hidden">Real Estate & Mortgage Intelligence</h1>
                         <h3 class="splitTextStyleOne text-heading heading-medium">
                             Real Estate & Mortgage Intelligence
                         </h3>
                         <p class="text-neutral-500 tw-mt-2 splitTextStyleOne max-w-770-px tw-text-lg mx-auto">
                             With real-time dashboards and performance scorecards, managers get a clear view of which
                             agents are driving deals—and who needs coaching.
                         </p>
                         <div class="tw-mt-2" data-aos="fade-up" data-aos-anchor-placement="top-bottom"
                             data-aos-duration="900">
                             <a href="{{ route('register') }}"
                                 class="hover--translate-y-1 active--translate-y-scale-9 btn button--stroke tw-gap-5 group active--translate-y-2 tw-rounded-xl text-capitalize tw-px-8 tw-py-505 fw-medium btn-main hover-style-one"
                                 data-block="button">
                                 <span class="button__flair"></span>
                                 <span class="button__label">Get started</span>
                             </a>
                         </div>
                     </div>
                 </div>
             </div>
         </div>
     </div>
 </section> -->
<section class="hero-section">
  <div class="hero-container">
    <div class="hero-left">
       <h1>Modern Communication Platform For Education</h1>
         <p>
       From prospects to graduates, deliver a unified experience with advanced call handling & SMS capabilities. Connect learners with the right consultants for seamless support and personalized learning journeys.
      </p>
      <div class="hero-badges">
      <span><i class="fa fa-check-circle"></i> No credit card required</span>
        <span><i class="fa fa-check-circle"></i> 14 days of {{ config('app.site') }} AI on us</span>
      </div>
    </div>

    <div class="hero-right">
      <div class="hero-image-wrapper">
        <img src="web/assets/images/education.webp" alt="Modern communication platform for education with AI call and SMS support">

    
      </div>
    </div>
  </div>
</section>

<style>
.hero-section {
  background: linear-gradient(180deg, rgba(72, 240, 175, .3882352941) 16.14%, rgba(154, 255, 216, .14) 100%);
  padding: 100px 0;
  font-family: "Inter", sans-serif;
}

.hero-container {
  max-width: 1250px;
  margin: auto;
  display: flex;
  align-items: center;
  justify-content: space-between;
  flex-wrap: wrap;
  gap: 70px;
}

.hero-left {
  flex: 1 1 520px;
}

.hero-left h1 {
  font-size: 40px;
  font-weight: 700;
  color: #1b1f3b;
  line-height: 1.25;
  margin-bottom: 25px;
  max-width: 500px;
}

.hero-left p {
  font-size: 18px;
  line-height: 1.7;
  color: #2b2b2b;
  margin-bottom: 35px;
  max-width: 520px;
  font-family: "Poppins", sans-serif; 
}

.hero-badges {
  display: flex;
  flex-wrap: wrap;
  gap: 20px;
  font-size: 16px;
  color: #1b1f3b;
}

.hero-badges i {
  color: #3b82f6;
  margin-right: 8px;
}

/* Right Side */
.hero-right {
  flex: 1 1 520px;
  display: flex;
  justify-content: center;
  position: relative;
}

.hero-image-wrapper {
  position: relative;
  width: 100%;
  max-width: 540px;
  border-radius: 20px;
  overflow: hidden;
  box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
}

.hero-image-wrapper img {
  width: 100%;
  display: block;
  object-fit: cover;
}

/* Agent Card */
.agent-card {
  position: absolute;
  top: 30px;
  left: 30px;
  background: #fff;
  border-radius: 16px;
  box-shadow: 0 6px 18px rgba(0, 0, 0, 0.1);
  padding: 16px 18px;
  max-width: 280px;
  border: 1px solid #e5e9ff;
}

.agent-card h4 {
  font-size: 15px;
  font-weight: 700;
  color: #1c2250;
  margin-bottom: 10px;
}

.agent-tabs {
  display: flex;
  gap: 6px;
  margin-bottom: 10px;
}

.agent-tabs .tab {
  flex: 1;
  font-size: 13px;
  text-align: center;
  padding: 6px 0;
  border-radius: 6px;
  background: #eef1ff;
  color: #4a4e74;
  font-weight: 600;
}

.agent-tabs .tab.active {
  background: #3b82f6;
  color: #fff;
}

.agent-message {
  font-size: 14px;
  color: #2b2b2b;
  background: #f9faff;
  padding: 12px;
  border-radius: 10px;
  line-height: 1.5;
  margin-bottom: 10px;
}

.agent-feedback {
  display: flex;
  justify-content: space-between;
  font-size: 13px;
  color: #3b82f6;
  font-weight: 600;
}

/* Responsive */
@media (max-width: 992px) {
  .hero-container {
    flex-direction: column;
    text-align: center;
  }

  .hero-left h1 {
    font-size: 36px;
    max-width: 100%;
  }

  .hero-left p {
    margin: 0 auto 30px;
  }

  .hero-badges {
    justify-content: center;
  }

  .hero-image-wrapper {
    margin-top: 40px;
  }

  .agent-card {
    position: static;
    margin: 20px auto 0;
  }
}

.secure-section {
  background: linear-gradient(180deg, #f2f4ff 0%, #ffffff 100%);
  padding: 100px 0;
  font-family: "Poppins", sans-serif; 
}

.secure-container {
  max-width: 1250px;
  margin: auto;
  display: flex;
  align-items: center;
  justify-content: space-between;
  flex-wrap: wrap;
  gap: 70px;
}

.secure-left {
  flex: 1 1 520px;
}

.secure-left h1 {
  font-size: 42px;
  font-weight: 800;
  color: #1b1f3b;
  line-height: 1.25;
  margin-bottom: 25px;
  max-width: 500px;
}

.secure-left p {
  font-size: 18px;
  line-height: 1.8;
  color: #2b2b2b;
  margin: 20px 0 30px 0; 
  max-width: 520px;
}

.secure-badges {
  display: flex;
  flex-wrap: wrap;
  gap: 20px;
  font-size: 16px;
  color: #1b1f3b;
}

.secure-badges i {
  color: #3b82f6;
  margin-right: 8px;
}

/* Right Side */
.secure-right {
  flex: 1 1 520px;
  display: flex;
  justify-content: center;
  position: relative;
}

.secure-image-wrapper {
  position: relative;
  width: 100%;
  max-width: 540px;
  border-radius: 20px;
  overflow: hidden;
  box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
  background: #fff;
}

.secure-image-wrapper img {
  width: 100%;
  display: block;
  object-fit: cover;
}


@media (max-width: 992px) {
  .secure-container {
    flex-direction: column;
    text-align: center;
  }

  .secure-left h1 {
    font-size: 34px;
    max-width: 100%;
  }

  .secure-left p {
    margin: 20px auto 30px; 
  }

  .secure-badges {
    justify-content: center;
  }

  .secure-image-wrapper {
    margin-top: 40px;
  }
}

</style>
<section class="toolkit-section py-5 bg-white">
  <div class="container">
    <h4 class="text-center mb-5 fw-bold">Modern communication platform for education and e-learning</h4>

    <div class="toolkit-grid">

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-route"></i></div>
        <h4>Call Routing</h4>
        <p>Streamline call routing and direct candidates to the correct department or agent to reduce wait time.</p>
        
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-list-ol"></i></div>
        <h4>Call Queues</h4>
        <p>Manage incoming calls through customized caller queues until the next team member is available.</p>
     
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-phone-volume"></i></div>
        <h4>Outbound Dialer</h4>
        <p>Accelerate your sales process with automated dialing, optimizing outreach and sealing deals faster.</p>
        
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-chalkboard-teacher"></i></div>
        <h4>Intelligent Coaching</h4>
        <p>Ensure quick onboarding with AI-powered call coaching, real-time assistance, and call monitoring.</p>
        
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-clipboard-check"></i></div>
        <h4>After-call Work</h4>
        <p>Automate after-call work with call disposition & automated note-taking.</p>
        
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-file-circle-check"></i></div>
        <h4>Automated Logging</h4>
        <p>Minimize manual tasks with automatic data logging post-call, ensuring accuracy and saving time with detailed call records.</p>
        
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-chart-line"></i></div>
        <h4>Analytics</h4>
        <p>Track team and call activity with a comprehensive dashboard identifying peak call hours, allocating team capacity, quality assurance, and deal closures.</p>
        
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-link"></i></div>
        <h4>Seamless Integrations</h4>
        <p>Centralize candidate information and past communication records across all tools with CRM and helpdesk integrations.</p>
       
      </div>

    </div>
  </div>
</section>



<!-- Font Awesome -->
<script src="https://kit.fontawesome.com/a2d9a67a2b.js" crossorigin="anonymous"></script>

<style>
.toolkit-section {
  background: #f7f7f9; 
  font-family: 'Poppins', sans-serif;
}

.toolkit-grid {
  display: grid;
  grid-template-columns: repeat(auto-fit, minmax(270px, 1fr));
  gap: 25px;
}

.toolkit-item {
  background: #fff;
  border: 1px solid #e5e7eb;
  border-radius: 12px;
  padding: 28px 24px;
  box-shadow: 0 4px 12px rgba(0,0,0,0.04);
  transition: all 0.3s ease;
  cursor: pointer;
  text-align: left;
}

.toolkit-item:hover {
  border-color: #3b82f6;
  box-shadow: 0 8px 22px rgba(59,130,246,0.1);
  transform: translateY(-4px);
}

.toolkit-item .icon {
  font-size: 30px;
  color: #0a5bff;
  margin-bottom: 18px;
}

.toolkit-item h4 {
  font-size: 18px;
  font-weight: 600;
  margin-bottom: 10px;
  color: #000;
}

.toolkit-item p {
  font-size: 15px;
  color: #444;
  line-height: 1.6;
  margin-bottom: 10px;
}

.learn-more {
  color: #0a5bff;
  font-weight: 500;
  font-size: 14px;
  text-decoration: none;
  transition: color 0.2s ease;
}

.learn-more:hover {
  color: #0044cc;
  text-decoration: underline;
}

@media (max-width: 768px) {
  .toolkit-item {
    padding: 22px 18px;
  }
}

.section-lg{
  background-color: #f7f8fa;
}

.as-h2{
  font-weight: 700; 
  font-size: 2.2rem; 
  color: #1b1c4d; 
  line-height: 1.3;
}

.nav-tabs{
  border-bottom: 1px solid #dce0e5;
}
</style>


<!-- ================== Driven section Start ====================== -->

<!-- Business Communication Section -->
<section class="section-lg py-5">
  <div class="container">
    <!-- Heading -->
    <div class="text-center mb-5">
      <h2 class="as-h2">
        Deliver high-quality customer experiences on the go
      </h2>
    </div>

    <!-- Tabs -->
    <ul class="nav nav-tabs justify-content-center border-0" id="businessTabs" role="tablist">
      <li class="nav-item" role="presentation">
        <button class="nav-link active" id="sales-tab" data-bs-toggle="tab" data-bs-target="#sales" type="button" role="tab">Sales & support</button>
      </li>
      <li class="nav-item" role="presentation">
        <button class="nav-link" id="workflow-tab" data-bs-toggle="tab" data-bs-target="#workflow" type="button" role="tab">Workflow automation</button>
      </li>
      <li class="nav-item" role="presentation">
        <button class="nav-link" id="analytics-tab" data-bs-toggle="tab" data-bs-target="#analytics" type="button" role="tab">Analytics & insights</button>
      </li>
      <li class="nav-item" role="presentation">
        <button class="nav-link" id="coaching-tab" data-bs-toggle="tab" data-bs-target="#coaching" type="button" role="tab">Coaching & training</button>
      </li>
    </ul>

    <style>
      .nav-tabs .nav-link {
        font-weight: 600;
        font-size: 1.05rem;
        color: #2e2e48;
        border: none;
        background: none;
        margin: 0 12px;
        padding: 10px 5px;
        position: relative;
      }

      .nav-tabs .nav-link.active {
        color: #1b1c4d;
        font-weight: 700;
      }

      .nav-tabs .nav-link.active::after {
        content: "";
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        height: 3px;
        background-color: #4154f1;
        border-radius: 2px;
      }

      .tab-content h5 {
        color: #1b1c4d;
        font-size: 1.1rem;
        font-weight: 500;
        margin-bottom: 20px;
        line-height: 1.6;
      }

      .tab-content ul {
        padding-left: 0;
        list-style: none;
      }

      .tab-content ul li {
        position: relative;
        padding-left: 28px;
        margin-bottom: 12px;
        font-size: 1rem;
        color: #3d3d5c;
        line-height: 1.7;
      }

      .tab-content ul li::before {
        content: "✔";
        position: absolute;
        left: 0;
        top: 0;
        color: #4154f1;
        font-size: 1rem;
      }

      .tab-content strong {
        font-weight: 700;
        color: #1b1c4d;
      }

      .cta-btn {
        display: inline-block;
        background-color: #1b53f0;
        color: #fff;
        font-weight: 600;
        border: none;
        border-radius: 8px;
        padding: 12px 28px;
        margin-top: 24px;
        text-decoration: none;
        transition: 0.3s;
      }

      .cta-btn:hover {
        background-color: #0f3ec9;
        color: #fff;
      }

      .img-fluid{
        max-width: 90%;
      }
    </style>

    <!-- Tab Content -->
    <div class="tab-content mt-5 bg-neutral-50" id="businessTabsContent">

      <!-- Sales & Support -->
      <div class="tab-pane fade show active" id="sales" role="tabpanel">
        <div class="row align-items-center">
          <div class="col-lg-6">
            <h5>Automate call scoring to train your team members to field queries from prospective and existing candidates.</h5>
            <ul>
              <li>Reach more prospective candidates with an <strong>outbound dialer.</strong></li>
              <li>Gauge candidate sentiment and identify needs with <strong>sentiment analysis</strong> and <strong>call moments.</strong></li>
              <li>Deliver streamlined and personalized experiences with <strong>IVR, intelligent call routing,</strong> and <strong>call queues.</strong></li>
            </ul>
            <a href="{{ route('register') }}" class="cta-btn">Start Free Trial</a>
          </div>
          <div class="col-lg-6 text-center">
            <img src="web/assets/images/education-sales.webp" alt="Sales and Support AI" class="img-fluid rounded-3">
          </div>
        </div>
      </div>

      <!-- Workflow Automation -->
      <div class="tab-pane fade" id="workflow" role="tabpanel">
        <div class="row align-items-center">
          <div class="col-lg-6">
            <h5>Connect and automate your business workflows to boost productivity and save time.</h5>
            <ul>
              <li>Connect with your business tools to <strong>centralize data</strong> and automate alerts and announcements.</li>
              <li>Reach out to prospective learners faster with <strong>automated SMS workflows.</strong></li>
              <li>Tag calls based on dispositions and automate <strong>post-call note-taking</strong> and <strong>follow-ups</strong> for improved efficiency.</li>
            </ul>
            <a href="{{ route('register') }}" class="cta-btn">Start Free Trial</a>
          </div>
          <div class="col-lg-6 text-center">
            <img src="web/assets/images/live-calls.webp" alt="Workflow Automation AI" class="img-fluid rounded-3">
          </div>
        </div>
      </div>

      <!-- Analytics & Insights -->
      <div class="tab-pane fade" id="analytics" role="tabpanel">
        <div class="row align-items-center">
          <div class="col-lg-6">
            <h5>Gain actionable insights into every conversation and make data-backed decisions.</h5>
            <ul>
              <li>Gain insight into team performance by tracking <strong>KPI metrics</strong> like calls per agent, average handling times, and call scores.</li>
              <li>Identify <strong>peak call hours</strong> to plan team capacity and distribute workload efficiently.</li>
              <li>Understand how conversations lead to <strong>bookings and decisions</strong> with in-depth analytics.</li>
            </ul>
            <a href="{{ route('register') }}" class="cta-btn">Start Free Trial</a>
          </div>
          <div class="col-lg-6 text-center">
            <img src="web/assets/images/education-analytics.webp" alt="Analytics and Insights AI" class="img-fluid rounded-3">
          </div>
        </div>
      </div>

      <!-- Coaching & Training -->
      <div class="tab-pane fade" id="coaching" role="tabpanel">
        <div class="row align-items-center">
          <div class="col-lg-6">
            <h5>Help your managers coach smarter and onboard faster with AI-driven call intelligence.</h5>
            <ul>
              <li>Help managers coach by accessing <strong>recordings</strong> and listening live to admissions and customer service calls.</li>
              <li>Assist your team with displaying <strong>real-time scripts</strong> and providing an FAQ repository.</li>
              <li>Onboard and ramp up new team members faster with <strong>call scoring</strong> and detailed <strong>call summaries.</strong></li>
            </ul>
            <a href="{{ route('register') }}" class="cta-btn">Start Free Trial</a>
          </div>
          <div class="col-lg-6 text-center">
            <img src="web/assets/images/education-coaching.webp" alt="Coaching and Training AI" class="img-fluid rounded-3">
          </div>
        </div>
      </div>

    </div>
  </div>
</section>




<!-- CSS -->
<style>
.main-heading {
  font-size: 2.2rem;
  font-weight: 700;
  color: #000; 
}

.ai-section {
  background: #0b1a33;
  color: #fff;
  padding: 50px 0;
}

.sub-heading {
  font-size: 1.4rem;
  font-weight: 600;
  margin-bottom: 6px; 
}

.section-text {
  font-size: 1rem;
  line-height: 1.6;
  margin-bottom: 8px;
  max-width: 440px;  
  text-align: left; 
}


.section-list {
  padding-left: 18px;
  margin-bottom: 8px;
}

.section-list li {
  margin-bottom: 5px;
  list-style: disc;
}

.section-link {
  color: #4e9eff;
  font-weight: 600;
  text-decoration: none;
}

.section-link:hover {
  text-decoration: underline;
}


.section-img {
  max-width: 390px;
  width: 100%;
  height: auto;
  border-radius: 6px;
  box-shadow: 0 3px 12px rgba(0,0,0,0.25);
  margin: 0 auto;
}


.row.align-items-center {
  display: flex;
  justify-content: space-between;  
  align-items: center;
  margin: 0;  
}



.row.align-items-center .col-lg-6 {
  flex: 0 0 auto;
  width: 50%;
  max-width: 50%;
  padding: 0 15px;  
}


.custom-gap-fix .col-lg-6:first-child {
  padding-left: 200px !important;
}


@media (max-width: 991px) {
  .custom-gap-fix .col-lg-6:first-child {
    padding-left: 0 !important;
  }
}




.row.align-items-center.flex-row-reverse {
  flex-direction: row-reverse;
}


@media (max-width: 991px) {
  .row.align-items-center,
  .row.align-items-center.flex-row-reverse {
    flex-direction: column;
  }

  .row.align-items-center .col-lg-6 {
    width: 100%;
    max-width: 100%;
    padding: 0;  
  }

  .section-img {
    margin-top: 12px;
    max-width: 100%;
  }
}

/* Tablet only (768px - 991px) */
@media (min-width: 768px) and (max-width: 991px) {
  .section-img {
    max-width: 65%;
    margin: 15px auto;
    display: block;
  }

  .section-text {
    max-width: 80%;
    margin: 0 auto 12px;
    font-size: 0.95rem;
    line-height: 1.5;
    text-align: center;
  }

  .section-list {
    max-width: 80%;
    margin: 0 auto 12px;
    padding-left: 0;
    list-style-position: inside;
    text-align: center; 
  }

  .section-list li {
    display: block;
    text-align: center;
    margin: 6px 0;
  }

  .section-link {
    display: block;
    text-align: center;
    margin-top: 10px;
    font-size: 0.95rem;
    word-break: break-word;
  }

  .sub-heading {
    font-size: 1.2rem;
    text-align: center;
    margin-bottom: 10px;
  }

  .main-heading {
    font-size: 1.8rem;
    text-align: center;
    margin-bottom: 12px;
  }

}


</style>




<!-- Font Awesome -->
<script src="https://kit.fontawesome.com/a2d9a67a2b.js" crossorigin="anonymous"></script>

<style>
.toolkit-section {
  background: #f7f7f9; 
  font-family: 'Poppins', sans-serif;
}

.toolkit-grid {
  display: grid;
  grid-template-columns: repeat(auto-fit, minmax(270px, 1fr));
  gap: 25px;
}

.toolkit-item {
  background: #fff;
  border: 1px solid #e5e7eb;
  border-radius: 12px;
  padding: 28px 24px;
  box-shadow: 0 4px 12px rgba(0,0,0,0.04);
  transition: all 0.3s ease;
  cursor: pointer;
}

.toolkit-item:hover {
  border-color: #3b82f6;
  box-shadow: 0 8px 22px rgba(59,130,246,0.1);
  transform: translateY(-4px);
}


.toolkit-item .icon {
  font-size: 30px;
  color: #0a5bff;
  margin-bottom: 18px;
}


.toolkit-item h4 {
  font-size: 18px;
  font-weight: 600;
  margin-bottom: 10px;
  color: #000;
}

.toolkit-item p {
  font-size: 15px;
  color: #444;
  line-height: 1.6;
}

@media (max-width: 768px) {
  .toolkit-item {
    padding: 22px 18px;
  }
}
</style>


<section class="faq-two py-50 bg-aliceblue">
  <div class="container">
    <div class="row gy-4">
      <div class="col-lg-12 d-flex">
        <div class="m-auto">
          <h2 class="visually-hidden">Frequently Asked Questions</h2>
          <h3 class="splitTextStyleOne text-heading text-capitalize heading-medium">
            Frequently Asked Questions
          </h3>
        </div>
      </div>

      <div class="col-lg-12">
        <div class="ps-xl-5">
          <div class="accordion common-accordion style-two arrow-bg-orange" id="accordionExample">

            <!-- Q1 -->
            <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-blue border-0 mb-0"
              data-aos="fade-up">
              <h3 class="accordion-header d-flex align-items-center justify-content-between tw-gap-3">
                <button class="accordion-button shadow-none p-0 line-clamp-3 bg-transparent h5"
                  type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne"
                  aria-expanded="true" aria-controls="collapseOne">
                  What is {{ config('app.site') }}?
                </button>
              </h3>
              <div id="collapseOne" class="accordion-collapse collapse show"
                data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 tw-leading-212 heading-medium">
                    {{ config('app.site') }} is an AI-powered call management platform that helps automate phone answering, analyze conversations, and deliver 24/7 customer support without overloading your team.
                  </p>
                </div>
              </div>
            </div>

            <!-- Q2 -->
            <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-blue border-0 mb-0"
              data-aos="fade-up">
              <h3 class="accordion-header d-flex align-items-center justify-content-between tw-gap-3">
                <button class="accordion-button shadow-none p-0 line-clamp-3 bg-transparent h5 collapsed"
                  type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo"
                  aria-expanded="false" aria-controls="collapseTwo">
                  How does the AI Receptionist work in {{ config('app.site') }}?
                </button>
              </h3>
              <div id="collapseTwo" class="accordion-collapse collapse"
                data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 tw-leading-212 heading-medium">
                    The AI Receptionist in {{ config('app.site') }} instantly answers incoming calls — even after hours — to schedule appointments, take messages, and route calls intelligently so you never miss an opportunity.
                  </p>
                </div>
              </div>
            </div>

            <!-- Q3 -->
            <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-blue border-0 mb-0"
              data-aos="fade-up">
              <h3 class="accordion-header d-flex align-items-center justify-content-between tw-gap-3">
                <button class="accordion-button shadow-none p-0 line-clamp-3 bg-transparent h5 collapsed"
                  type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree"
                  aria-expanded="false" aria-controls="collapseThree">
                  How does {{ config('app.site') }} reduce staff workload?
                </button>
              </h3>
              <div id="collapseThree" class="accordion-collapse collapse"
                data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 tw-leading-212 heading-medium">
                    By handling repetitive calls and inquiries, {{ config('app.site') }} frees your staff from constant interruptions so they can focus on meaningful work while AI handles the rest.
                  </p>
                </div>
              </div>
            </div>

            <!-- Q4 -->
            <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-transparent border-0 mb-0"
              data-aos="fade-up">
              <h3 class="accordion-header d-flex align-items-center justify-content-between tw-gap-3">
                <button class="accordion-button shadow-none p-0 line-clamp-3 bg-transparent h5 collapsed"
                  type="button" data-bs-toggle="collapse" data-bs-target="#collapseFour"
                  aria-expanded="false" aria-controls="collapseFour">
                  What is the AI Call Analytics dashboard?
                </button>
              </h3>
              <div id="collapseFour" class="accordion-collapse collapse"
                data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 tw-leading-212 heading-medium">
                    {{ config('app.site') }} includes a powerful AI Call Analytics dashboard that monitors every conversation, tracks sentiment, evaluates call outcomes, and gives you clear insights into customer experience and team performance.
                  </p>
                </div>
              </div>
            </div>

            <!-- Q5 -->
            <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-transparent border-0 mb-0"
              data-aos="fade-up">
              <h3 class="accordion-header d-flex align-items-center justify-content-between tw-gap-3">
                <button class="accordion-button shadow-none p-0 line-clamp-3 bg-transparent h5 collapsed"
                  type="button" data-bs-toggle="collapse" data-bs-target="#collapseFive"
                  aria-expanded="false" aria-controls="collapseFive">
                  Can {{ config('app.site') }} answer calls in multiple languages?
                </button>
              </h3>
              <div id="collapseFive" class="accordion-collapse collapse"
                data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 tw-leading-212 heading-medium">
                    Yes! The AI Voice Agents in {{ config('app.site') }} can speak and understand over 50 languages, providing natural, human-like communication for global customers.
                  </p>
                </div>
              </div>
            </div>

            <!-- Q6 -->
            <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-transparent border-0 mb-0"
              data-aos="fade-up">
              <h3 class="accordion-header d-flex align-items-center justify-content-between tw-gap-3">
                <button class="accordion-button shadow-none p-0 line-clamp-3 bg-transparent h5 collapsed"
                  type="button" data-bs-toggle="collapse" data-bs-target="#collapseSix"
                  aria-expanded="false" aria-controls="collapseSix">
                  Does {{ config('app.site') }} handle after-hours calls?
                </button>
              </h3>
              <div id="collapseSix" class="accordion-collapse collapse"
                data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 tw-leading-212 heading-medium">
                    Absolutely. {{ config('app.site') }}’s AI Receptionist works 24/7 — answering calls, capturing details, and ensuring follow-ups so you never miss an opportunity, even outside business hours.
                  </p>
                </div>
              </div>
            </div>

            <!-- Q7 -->
            <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-transparent border-0 mb-0"
              data-aos="fade-up">
              <h3 class="accordion-header d-flex align-items-center justify-content-between tw-gap-3">
                <button class="accordion-button shadow-none p-0 line-clamp-3 bg-transparent h5 collapsed"
                  type="button" data-bs-toggle="collapse" data-bs-target="#collapseSeven"
                  aria-expanded="false" aria-controls="collapseSeven">
                  How does {{ config('app.site') }} improve customer experience?
                </button>
              </h3>
              <div id="collapseSeven" class="accordion-collapse collapse"
                data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 tw-leading-212 heading-medium">
                    {{ config('app.site') }} analyzes tone, intent, and satisfaction in real time to give you actionable insights — helping your business deliver faster, smarter, and more empathetic phone support.
                  </p>
                </div>
              </div>
            </div>

            <!-- Q8 -->
            <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-transparent border-0 mb-0"
              data-aos="fade-up">
              <h3 class="accordion-header d-flex align-items-center justify-content-between tw-gap-3">
                <button class="accordion-button shadow-none p-0 line-clamp-3 bg-transparent h5 collapsed"
                  type="button" data-bs-toggle="collapse" data-bs-target="#collapseEight"
                  aria-expanded="false" aria-controls="collapseEight">
                  Do I need technical knowledge to use {{ config('app.site') }}?
                </button>
              </h3>
              <div id="collapseEight" class="accordion-collapse collapse"
                data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 tw-leading-212 heading-medium">
                    Not at all. {{ config('app.site') }} is designed to work out-of-the-box with your existing phone system or CRM — no coding or technical setup required.
                  </p>
                </div>
              </div>
            </div>

            <!-- Q9 -->
            <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-transparent border-0 mb-0"
              data-aos="fade-up">
              <h3 class="accordion-header d-flex align-items-center justify-content-between tw-gap-3">
                <button class="accordion-button shadow-none p-0 line-clamp-3 bg-transparent h5 collapsed"
                  type="button" data-bs-toggle="collapse" data-bs-target="#collapseNine"
                  aria-expanded="false" aria-controls="collapseNine">
                  Is my call data secure with {{ config('app.site') }}?
                </button>
              </h3>
              <div id="collapseNine" class="accordion-collapse collapse"
                data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 tw-leading-212 heading-medium">
                    Yes, security is a top priority. {{ config('app.site') }} uses end-to-end encryption and strict compliance protocols to keep your business and customer data safe.
                  </p>
                </div>
              </div>
            </div>

            <!-- Q10 -->
            <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-transparent border-0 mb-0"
              data-aos="fade-up">
              <h3 class="accordion-header d-flex align-items-center justify-content-between tw-gap-3">
                <button class="accordion-button shadow-none p-0 line-clamp-3 bg-transparent h5 collapsed"
                  type="button" data-bs-toggle="collapse" data-bs-target="#collapseTen"
                  aria-expanded="false" aria-controls="collapseTen">
                  Can {{ config('app.site') }} help train my team?
                </button>
              </h3>
              <div id="collapseTen" class="accordion-collapse collapse"
                data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 tw-leading-212 heading-medium">
                    Definitely. {{ config('app.site') }} identifies performance patterns from real calls and provides insights that make employee training faster, smarter, and data-driven.
                  </p>
                </div>
              </div>
            </div>

          </div>
        </div>
      </div>
    </div>
  </div>
</section>


  <section class="integrations-section">
  <div class="container">
    <h2 class="section-title">Fits seamlessly into your tech stack</h2>

    <div class="integration-logos">
      <div class="logo-box">
        <img src="web/assets/images/hubspot.svg" alt="HubSpot">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/salesforce.svg" alt="Salesforce">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/pipedrive.svg" alt="Pipedrive">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/slack.svg" alt="Slack">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/intercom.svg" alt="Intercom">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/zendesk-icon.svg" alt="Zendesk">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/zoho.svg" alt="Zoho">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/outreach.webp" alt="Outreach">
      </div>
    </div>

    <div class="btn-wrapper">
      <a href="{{ route('register') }}" class="view-btn">Start free trial</a>
    </div>
  </div>
</section>


<style>
.integrations-section {
  text-align: center;
  padding: 80px 20px;
  background-color: #fff;
}

.integrations-section .section-title {
  font-size: 32px;
  font-weight: 700;
  color: #0b0c2a;
  margin-bottom: 50px;
}

.integration-logos {
  display: flex;
  flex-wrap: wrap;
  justify-content: center;
  gap: 25px;
  margin-bottom: 50px;
}

.logo-box {
  width: 140px;
  height: 140px;
  background: #fff;
  border-radius: 20px;
  box-shadow: 0 0 0 1px #e5e7eb;
  display: flex;
  align-items: center;
  justify-content: center;
  transition: all 0.3s ease;
}

.logo-box img {
  width: 60px;
  height: auto;
  transition: transform 0.3s ease;
}

.logo-box:hover {
  transform: translateY(-8px);
  box-shadow: 0 8px 25px rgba(0, 0, 0, 0.08);
}

.logo-box:hover img {
  transform: scale(1.1);
}

.view-btn {
  display: inline-block;
  background-color: #0052ff;
  color: #fff;
  font-weight: 600;
  padding: 14px 28px;
  border-radius: 8px;
  text-decoration: none;
  transition: background 0.3s ease;
}

.view-btn:hover {
  background-color: #003ed6;
}

.btn-wrapper {
  margin-top: 20px;
}
</style>



 @endsection