@extends('website.layout')

@section('meta')
    <title>{{ config('app.site') }} FAQ | Frequently Asked Questions</title>
    <meta name="description" content="Find answers to common questions about {{ config('app.site') }} features, pricing, support, and account management.">

      <meta name="keywords" content="Customer support questions, AI service FAQs, AI assistant troubleshooting">

    {{-- Open Graph --}}
    <meta property="og:title" content="{{ config('app.site') }} FAQ | Frequently Asked Questions">
    <meta property="og:description" content="Find answers to common questions about {{ config('app.site') }} features, pricing, support, and account management.">
    <meta property="og:type" content="website">
    <meta property="og:url" content="{{ url()->current() }}">

    {{-- Twitter / X --}}
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="{{ config('app.site') }} FAQ | Frequently Asked Questions">
    <meta name="twitter:description" content="Find answers to common questions about {{ config('app.site') }} features, pricing, support, and account management.">
 
@endsection



@section('content')

<style>
.bg-aliceblue {
  background-color: aliceblue;
}

.visually-hidden {
    position: absolute;
    width: 1px;
    height: 1px;
    padding: 0;
    margin: -1px;
    overflow: hidden;
    clip: rect(0, 0, 0, 0);
    white-space: nowrap;
    border: 0;
}
</style>

<div id="smooth-content">



        <!-- ============================== Faq Two Section Start ============================== -->
    <section class="faq-two py-50 bg-aliceblue">
  <div class="container">
    <div class="row gy-4">
      <div class="col-lg-12 d-flex">
        <div class="m-auto">
          <h1 class="visually-hidden">Frequently Asked Questions</h1>
          <h3 class="splitTextStyleOne text-heading text-capitalize heading-medium">
            Frequently Asked Questions
          </h3>
        </div>
      </div>

      <div class="col-lg-12">
        <div class="ps-xl-5">
          <div class="accordion common-accordion style-two arrow-bg-orange" id="accordionExample">

            <!-- Q1 -->
            <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-transparent border-0 mb-0">
              <h3 class="accordion-header">
                <button class="accordion-button shadow-none p-0 bg-transparent h5" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="true">
                  What is {{ config('app.site') }}?
                </button>
              </h3>
              <div id="collapseOne" class="accordion-collapse collapse show" data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 heading-medium">
                    {{ config('app.site') }} is an AI-powered call management platform that helps automate phone answering, analyze conversations, and deliver 24/7 customer support without overloading your team.
                  </p>
                </div>
              </div>
            </div>

            <!-- Q2 -->
            <div class="accordion-item tw-py-8 tw-px-40-px bg-transparent border-0 mb-0">
              <h3 class="accordion-header">
                <button class="accordion-button shadow-none p-0 bg-transparent h5 collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo">
                  How does the AI Receptionist work in {{ config('app.site') }}?
                </button>
              </h3>
              <div id="collapseTwo" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 heading-medium">
                    The AI Receptionist in {{ config('app.site') }} instantly answers incoming calls — even after hours — to schedule appointments, take messages, and route calls intelligently so you never miss an opportunity.
                  </p>
                </div>
              </div>
            </div>

            <!-- Q3 -->
            <div class="accordion-item tw-py-8 tw-px-40-px bg-transparent border-0 mb-0">
              <h3 class="accordion-header">
                <button class="accordion-button shadow-none p-0 bg-transparent h5 collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree">
                  How does {{ config('app.site') }} reduce staff workload?
                </button>
              </h3>
              <div id="collapseThree" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 heading-medium">
                    By handling repetitive calls and inquiries, {{ config('app.site') }} frees your staff from constant interruptions so they can focus on meaningful work while AI handles the rest.
                  </p>
                </div>
              </div>
            </div>

            <!-- Q4 -->
            <div class="accordion-item tw-py-8 tw-px-40-px bg-transparent border-0 mb-0">
              <h3 class="accordion-header">
                <button class="accordion-button shadow-none p-0 bg-transparent h5 collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFour">
                  What is the AI Call Analytics dashboard?
                </button>
              </h3>
              <div id="collapseFour" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 heading-medium">
                    {{ config('app.site') }} includes a powerful AI Call Analytics dashboard that monitors every conversation, tracks sentiment, evaluates call outcomes, and gives you clear insights into customer experience and team performance.
                  </p>
                </div>
              </div>
            </div>

            <!-- Q5 -->
            <div class="accordion-item tw-py-8 tw-px-40-px bg-transparent border-0 mb-0">
              <h3 class="accordion-header">
                <button class="accordion-button shadow-none p-0 bg-transparent h5 collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFive">
                  Can {{ config('app.site') }} answer calls in multiple languages?
                </button>
              </h3>
              <div id="collapseFive" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 heading-medium">
                    Yes! The AI Voice Agents in {{ config('app.site') }} can speak and understand over 50 languages, providing natural, human-like communication for global customers.
                  </p>
                </div>
              </div>
            </div>

            <!-- Q6 -->
            <div class="accordion-item tw-py-8 tw-px-40-px bg-transparent border-0 mb-0">
              <h3 class="accordion-header">
                <button class="accordion-button shadow-none p-0 bg-transparent h5 collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseSix">
                  Does {{ config('app.site') }} handle after-hours calls?
                </button>
              </h3>
              <div id="collapseSix" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 heading-medium">
                    Absolutely. {{ config('app.site') }}’s AI Receptionist works 24/7 — answering calls, capturing details, and ensuring follow-ups so you never miss an opportunity, even outside business hours.
                  </p>
                </div>
              </div>
            </div>

            <!-- Q7 -->
            <div class="accordion-item tw-py-8 tw-px-40-px bg-transparent border-0 mb-0">
              <h3 class="accordion-header">
                <button class="accordion-button shadow-none p-0 bg-transparent h5 collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseSeven">
                  How does {{ config('app.site') }} improve customer experience?
                </button>
              </h3>
              <div id="collapseSeven" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 heading-medium">
                    {{ config('app.site') }} analyzes tone, intent, and satisfaction in real time to give you actionable insights — helping your business deliver faster, smarter, and more empathetic phone support.
                  </p>
                </div>
              </div>
            </div>

            <!-- Q8 -->
            <div class="accordion-item tw-py-8 tw-px-40-px bg-transparent border-0 mb-0">
              <h3 class="accordion-header">
                <button class="accordion-button shadow-none p-0 bg-transparent h5 collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseEight">
                  Do I need technical knowledge to use {{ config('app.site') }}?
                </button>
              </h3>
              <div id="collapseEight" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 heading-medium">
                    Not at all. {{ config('app.site') }} is designed to work out-of-the-box with your existing phone system or CRM — no coding or technical setup required.
                  </p>
                </div>
              </div>
            </div>

            <!-- Q9 -->
            <div class="accordion-item tw-py-8 tw-px-40-px bg-transparent border-0 mb-0">
              <h3 class="accordion-header">
                <button class="accordion-button shadow-none p-0 bg-transparent h5 collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseNine">
                  Is my call data secure with {{ config('app.site') }}?
                </button>
              </h3>
              <div id="collapseNine" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 heading-medium">
                    Yes, security is a top priority. {{ config('app.site') }} uses end-to-end encryption and strict compliance protocols to keep your business and customer data safe.
                  </p>
                </div>
              </div>
            </div>

            <!-- Q10 -->
            <div class="accordion-item tw-py-8 tw-px-40-px bg-transparent border-0 mb-0">
              <h3 class="accordion-header">
                <button class="accordion-button shadow-none p-0 bg-transparent h5 collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTen">
                  Can {{ config('app.site') }} help train my team?
                </button>
              </h3>
              <div id="collapseTen" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 heading-medium">
                    Definitely. {{ config('app.site') }} identifies performance patterns from real calls and provides insights that make employee training faster, smarter, and data-driven.
                  </p>
                </div>
              </div>
            </div>

          </div>
        </div>
      </div>
    </div>
  </div>
</section>

        <!-- ============================== Faq Two Section End ============================== -->


</div>


@push('scripts')
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "FAQPage",
  "mainEntity": [
    {
      "@type": "Question",
      "name": "What is {{ config('app.site') }}?",
      "acceptedAnswer": {
        "@type": "Answer",
        "text": "{{ config('app.site') }} is an AI-powered call management platform that helps automate phone answering, analyze conversations, and deliver 24/7 customer support without overloading your team."
      }
    },
    {
      "@type": "Question",
      "name": "How does the AI Receptionist work in {{ config('app.site') }}?",
      "acceptedAnswer": {
        "@type": "Answer",
        "text": "The AI Receptionist in {{ config('app.site') }} instantly answers incoming calls, schedules appointments, takes messages, and routes calls intelligently so you never miss an opportunity."
      }
    },
    {
      "@type": "Question",
      "name": "How does {{ config('app.site') }} reduce staff workload?",
      "acceptedAnswer": {
        "@type": "Answer",
        "text": "By handling repetitive calls and inquiries, {{ config('app.site') }} reduces interruptions for your staff and allows them to focus on higher-value work while AI handles routine conversations."
      }
    },
    {
      "@type": "Question",
      "name": "What is the AI Call Analytics dashboard?",
      "acceptedAnswer": {
        "@type": "Answer",
        "text": "{{ config('app.site') }} includes an AI Call Analytics dashboard that tracks conversations, analyzes sentiment, evaluates call outcomes, and provides insights into customer experience and team performance."
      }
    },
    {
      "@type": "Question",
      "name": "Can {{ config('app.site') }} answer calls in multiple languages?",
      "acceptedAnswer": {
        "@type": "Answer",
        "text": "Yes, the AI Voice Agents in {{ config('app.site') }} can understand and speak over 50 languages, enabling natural conversations with customers worldwide."
      }
    },
    {
      "@type": "Question",
      "name": "Does {{ config('app.site') }} handle after-hours calls?",
      "acceptedAnswer": {
        "@type": "Answer",
        "text": "{{ config('app.site') }} works 24/7, answering calls, capturing details, and ensuring follow-ups even outside normal business hours."
      }
    },
    {
      "@type": "Question",
      "name": "How does {{ config('app.site') }} improve customer experience?",
      "acceptedAnswer": {
        "@type": "Answer",
        "text": "{{ config('app.site') }} analyzes tone, intent, and satisfaction in real time to provide insights that help businesses deliver faster, smarter, and more empathetic phone support."
      }
    },
    {
      "@type": "Question",
      "name": "Do I need technical knowledge to use {{ config('app.site') }}?",
      "acceptedAnswer": {
        "@type": "Answer",
        "text": "Not at all. {{ config('app.site') }} works out of the box with your existing phone system or CRM and requires no coding or technical expertise."
      }
    },
    {
      "@type": "Question",
      "name": "Is my call data secure with {{ config('app.site') }}?",
      "acceptedAnswer": {
        "@type": "Answer",
        "text": "Yes. {{ config('app.site') }} uses strong encryption and strict security practices to protect your call data and maintain compliance."
      }
    },
    {
      "@type": "Question",
      "name": "Can {{ config('app.site') }} help train my team?",
      "acceptedAnswer": {
        "@type": "Answer",
        "text": "{{ config('app.site') }} analyzes real conversations to identify performance patterns and provides insights that help train teams faster and more effectively."
      }
    }
  ]
}
</script>

@endpush

@endsection
