@extends('website.layout')

@section('meta')
<title>Last-Minute Appointment Available | AI Booking Automation</title>

<meta name="description" content="Increase bookings and fill last-minute openings with AI booking automation that reaches out to clients and keeps your schedule busy.">

<meta name="keywords" content="last minute appointment booking, AI booking automation, fill cancellations, smart scheduling">

{{-- Open Graph --}}
<meta property="og:title" content="Last-Minute Appointment Available | AI Booking Automation">
<meta property="og:description" content="Increase bookings and fill last-minute openings with AI booking automation that reaches out to clients and keeps your schedule busy.">
<meta property="og:image" content="{{ asset('web/assets/images/no-missed.webp') }}">
<meta property="og:type" content="website">
<meta property="og:url" content="{{ url()->current() }}">

{{-- Twitter / X --}}
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Last-Minute Appointment Available | AI Booking Automation">
<meta name="twitter:description" content="Increase bookings and fill last-minute openings with AI booking automation that reaches out to clients and keeps your schedule busy.">
<meta name="twitter:image" content="{{ asset('web/assets/images/no-missed.webp') }}">

@endsection




<link
  rel="stylesheet"
  href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css"
/>





 @section('content')
<style>
.custom-img {
  margin-top: 180px;
}

 .paragraph-style {
  font-weight: 400;
  font-size: 18px;
}

.custom-heading {
  font-weight: 400;  
}

.max-width-40 {
  max-width: 40%;
}

@media (max-width: 768px) {
  .custom-img {
    margin-top: 50px;
  }
}
.pt-40 {
  padding-top: 40px;
}
.img-auto-warranty {
  max-height: 500px;
  width: 100%;
  object-fit: contain;
}

.img-deal-maxwidth{
  max-width: 35%;
}
.custom-padding-100 {
  padding: 100px 0;
}
.img-pitch-maxwidth {
  max-width: 30%;
}
.visually-hidden {
    position: absolute;
    width: 1px;
    height: 1px;
    padding: 0;
    margin: -1px;
    overflow: hidden;
    clip: rect(0, 0, 0, 0);
    white-space: nowrap;
    border: 0;
}
.as-h2 {
 font-size: clamp(1.5rem, 0.5569rem + 1.444vw, 1.875rem);
 }

.tw-mb-1{
 font-size: clamp(1.125rem, 1.2rem + 0.722vw, 1.5rem);
 }
</style>
 <!-- <section class="section-bg-two pb-50 overflow-hidden pt-40">
     <div class="container max-w-1290-px">
         <div class="row gy-5 align-items-center justify-content-center text-center">
             <div class="col-xl-12">
                 <div>
                     <div class="mx-auto tw-mb-12">
                          <h1 class="visually-hidden">Real Estate & Mortgage Intelligence</h1>
                         <h3 class="splitTextStyleOne text-heading heading-medium">
                             Real Estate & Mortgage Intelligence
                         </h3>
                         <p class="text-neutral-500 tw-mt-2 splitTextStyleOne max-w-770-px tw-text-lg mx-auto">
                             With real-time dashboards and performance scorecards, managers get a clear view of which
                             agents are driving deals—and who needs coaching.
                         </p>
                         <div class="tw-mt-2" data-aos="fade-up" data-aos-anchor-placement="top-bottom"
                             data-aos-duration="900">
                             <a href="{{ route('register') }}"
                                 class="hover--translate-y-1 active--translate-y-scale-9 btn button--stroke tw-gap-5 group active--translate-y-2 tw-rounded-xl text-capitalize tw-px-8 tw-py-505 fw-medium btn-main hover-style-one"
                                 data-block="button">
                                 <span class="button__flair"></span>
                                 <span class="button__label">Get started</span>
                             </a>
                         </div>
                     </div>
                 </div>
             </div>
         </div>
     </div>
 </section> -->
<section class="hero-section">
  <div class="hero-container">
    <div class="hero-left">
      <h1 class="text-white">
       Fill Last-Minute Appointments Automatically
      </h1>
      <p class="text-white">
       Transform empty appointment slots into revenue opportunities. Our AI proactively reaches out to waitlisted patients to fill available appointments throughout the day.
      <div class="hero-badges">
        <span class="text-white"><i class="fa fa-check-circle"></i> No credit card required</span>
        <span class="text-white"><i class="fa fa-check-circle"></i> 14 days of AI tools on us</span>
      </div>
    </div>

    <div class="hero-right mb-6">
      <div class="hero-image-wrapper">
        <img src="web/assets/images/no-missed.webp" alt="AI system automatically filling last minute appointment slots">

    
      </div>
    </div>
  </div>
</section>

<style>
.hero-section {
 background: linear-gradient(103deg, #160A33 28.21%, #261258 58.12%, #4B23B0 84.04%, #9677E4 105.97%, #CABBF2 131.89%);
  padding: 100px 0;
  font-family: "Inter", sans-serif;
}

.hero-container {
  max-width: 1250px;
  margin: auto;
  display: flex;
  align-items: center;
  justify-content: space-between;
  flex-wrap: wrap;
  gap: 70px;
}

.hero-left {
  flex: 1 1 520px;
}

.hero-left h1 {
  font-size: 42px;
  font-weight: 800;
  color: #1b1f3b;
  line-height: 1.25;
  margin-bottom: 25px;
  max-width: 500px;
}

.hero-left p {
  font-size: 18px;
  line-height: 1.7;
  color: #2b2b2b;
  margin-bottom: 35px;
  max-width: 520px;
  font-family: "Poppins", sans-serif; 
}

.hero-badges {
  display: flex;
  flex-wrap: wrap;
  gap: 20px;
  font-size: 16px;
  color: #1b1f3b;
}

.hero-badges i {
  color: #3b82f6;
  margin-right: 8px;
}

/* Right Side */
.hero-right {
  flex: 1 1 520px;
  display: flex;
  justify-content: center;
  position: relative;
}

.hero-image-wrapper {
  position: relative;
  width: 100%;
  max-width: 540px;
  border-radius: 20px;
  overflow: hidden;
  box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
}

.hero-image-wrapper img {
  width: 100%;
  display: block;
  object-fit: cover;
}

/* Agent Card */
.agent-card {
  position: absolute;
  top: 30px;
  left: 30px;
  background: #fff;
  border-radius: 16px;
  box-shadow: 0 6px 18px rgba(0, 0, 0, 0.1);
  padding: 16px 18px;
  max-width: 280px;
  border: 1px solid #e5e9ff;
}

.agent-card h4 {
  font-size: 15px;
  font-weight: 700;
  color: #1c2250;
  margin-bottom: 10px;
}

.agent-tabs {
  display: flex;
  gap: 6px;
  margin-bottom: 10px;
}

.agent-tabs .tab {
  flex: 1;
  font-size: 13px;
  text-align: center;
  padding: 6px 0;
  border-radius: 6px;
  background: #eef1ff;
  color: #4a4e74;
  font-weight: 600;
}

.agent-tabs .tab.active {
  background: #3b82f6;
  color: #fff;
}

.agent-message {
  font-size: 14px;
  color: #2b2b2b;
  background: #f9faff;
  padding: 12px;
  border-radius: 10px;
  line-height: 1.5;
  margin-bottom: 10px;
}

.agent-feedback {
  display: flex;
  justify-content: space-between;
  font-size: 13px;
  color: #3b82f6;
  font-weight: 600;
}

/* Responsive */
@media (max-width: 992px) {
  .hero-container {
    flex-direction: column;
    text-align: center;
  }

  .hero-left h1 {
    font-size: 36px;
    max-width: 100%;
  }

  .hero-left p {
    margin: 0 auto 30px;
  }

  .hero-badges {
    justify-content: center;
  }

  .hero-image-wrapper {
    margin-top: 40px;
  }

  .agent-card {
    position: static;
    margin: 20px auto 0;
  }
}

.secure-section {
  background: linear-gradient(180deg, #f2f4ff 0%, #ffffff 100%);
  padding: 100px 0;
  font-family: "Poppins", sans-serif; 
}

.secure-container {
  max-width: 1250px;
  margin: auto;
  display: flex;
  align-items: center;
  justify-content: space-between;
  flex-wrap: wrap;
  gap: 70px;
}

.secure-left {
  flex: 1 1 520px;
}

.secure-left h1 {
  font-size: 42px;
  font-weight: 800;
  color: #1b1f3b;
  line-height: 1.25;
  margin-bottom: 25px;
  max-width: 500px;
}

.secure-left p {
  font-size: 18px;
  line-height: 1.8;
  color: #2b2b2b;
  margin: 20px 0 30px 0; 
  max-width: 520px;
}

.secure-badges {
  display: flex;
  flex-wrap: wrap;
  gap: 20px;
  font-size: 16px;
  color: #1b1f3b;
}

.secure-badges i {
  color: #3b82f6;
  margin-right: 8px;
}

/* Right Side */
.secure-right {
  flex: 1 1 520px;
  display: flex;
  justify-content: center;
  position: relative;
}

.secure-image-wrapper {
  position: relative;
  width: 100%;
  max-width: 540px;
  border-radius: 20px;
  overflow: hidden;
  box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
  background: #fff;
}

.secure-image-wrapper img {
  width: 100%;
  display: block;
  object-fit: cover;
}


@media (max-width: 992px) {
  .secure-container {
    flex-direction: column;
    text-align: center;
  }

  .secure-left h1 {
    font-size: 34px;
    max-width: 100%;
  }

  .secure-left p {
    margin: 20px auto 30px; 
  }

  .secure-badges {
    justify-content: center;
  }

  .secure-image-wrapper {
    margin-top: 40px;
  }
}


.icon-22 {
  font-size: 2.2rem;
}

.cta-text {
  font-family: 'Poppins', sans-serif;
  font-size: 1.1rem;
}

.cta-link {
  color: #0d6efd;
  text-decoration: none;
  font-weight: 600;
}

</style>

<section class="switch-section py-5">
  <div class="container text-center">
    <div class="tw-mb-13 text-center">
      <span
        class="tw-py-1 tw-px-705 bg-main-50 text-main-600 tw-text-sm fw-bold text-capitalize rounded-pill tw-mb-205">
        Why {{ config('app.site') }}?
      </span>

      <h3 class="splitTextStyleOne custom-perspective">
        <div class="split-line custom-centered-title">
          Empty Slots Equal Lost Revenue
        </div>
      </h3>

      <p class="text-gray-600 tw-max-w-[700px] mx-auto mt-3">
        Healthcare practices often struggle to fill last-minute cancellations, leaving valuable revenue behind.
      </p>
    </div>

    <div class="row g-4 justify-content-center">
      <!-- Card 1 -->
      <div class="col-lg-3 col-md-6 col-sm-6">
        <div class="switch-card">
          <div class="icon mb-3">
            <i class="bi bi-calendar-x text-main-600 icon-22"></i>
          </div>
          <h5>Last-Minute Cancellations</h5>
          <p>
            Patients often cancel due to emergencies, feeling better, or simply forgetting — leaving open slots that go unfilled.
          </p>
        </div>
      </div>

      <!-- Card 2 -->
      <div class="col-lg-3 col-md-6 col-sm-6">
        <div class="switch-card">
          <div class="icon mb-3">
            <i class="bi bi-person-dash text-main-600 icon-22"></i>
          </div>
          <h5>No-Shows Hurt Your Schedule</h5>
          <p>
            Missed appointments disrupt workflow, waste staff time, and reduce overall efficiency for the day.
          </p>
        </div>
      </div>

      <!-- Card 3 -->
      <div class="col-lg-3 col-md-6 col-sm-6">
        <div class="switch-card">
          <div class="icon mb-3">
            <i class="bi bi-hourglass-split text-main-600 icon-22"></i>
          </div>
          <h5>Manual Outreach is Too Slow</h5>
          <p>
            By the time your team reaches out to reschedule or fill an opening, the opportunity — and revenue — is already lost.
          </p>
        </div>
      </div>

      <!-- Card 4 -->
      <div class="col-lg-3 col-md-6 col-sm-6">
        <div class="switch-card">
          <div class="icon mb-3">
            <i class="bi bi-cash-stack text-main-600 icon-22"></i>
          </div>
          <h5>Lost Revenue Adds Up</h5>
          <p>
            Every unfilled appointment means missed income and lost chances to deliver care to patients who need it.
          </p>
        </div>
      </div>
    </div>

    <!-- CTA -->
    <div class="text-center mt-5 cta-text">
      🚀 Ready to stop losing revenue? 
      <a href="{{ route('register') }}" class="cta-link">
        Get Started Now
      </a>
    </div>
  </div>
</section>


<style>
.switch-section {
  background: #fff;
}

.switch-card {
  background: #fff;
  border: 1px solid #e6e6e6;
  border-radius: 16px;
  padding: 30px 20px;
  height: 100%;
  text-align: left;
  transition: all 0.3s ease;
}

.switch-card:hover {
  box-shadow: 0 8px 20px rgba(0, 0, 0, 0.05);
  transform: translateY(-3px);
}

.switch-card .icon {
  width: 55px;
  height: 55px;
  background: #f0f4ff;
  border-radius: 12px;
  padding: 10px;
  margin-bottom: 20px;
}

.switch-card h5 {
  font-weight: 700;
  color: #0b1b4f;
  margin-bottom: 12px;
  font-size: 1.05rem;
}

.switch-card p {
  color: #4f5b7d;
  font-size: 0.9rem;
  line-height: 1.6;
}

@media (max-width: 992px) {
  .switch-card {
    padding: 25px 18px;
  }
}

@media (max-width: 768px) {
  .switch-card {
    text-align: center;
  }
  .switch-card .icon {
    margin: 0 auto 15px;
  }
}
</style>



<section class="cancellation-section">
  <div class="content">
    <div class="text-side">
      <h2>AI That Converts Cancellations Into Confirmations</h2>
      <p class="sub-text">
        Every open slot becomes an opportunity — not a loss.
      </p>

      <ul class="features">
        <li>
          <span class="icon">⚡</span>
          <div>
            <h4>Instant Cancellation Detection</h4>
            <p>Detect cancellations the moment they happen.</p>
          </div>
        </li>
        <li>
          <span class="icon">👥</span>
          <div>
            <h4>Smart Waitlist Matching</h4>
            <p>Automatically match open slots with the most suitable patients on the waitlist.</p>
          </div>
        </li>
        <li>
          <span class="icon">🤖</span>
          <div>
            <h4>Automated Patient Outreach</h4>
            <p>Notify matched patients via call — instantly, reducing empty appointment slots.</p>
          </div>
        </li>
        <li>
          <span class="icon">📞</span>
          <div>
            <h4>Real-Time Booking Confirmation</h4>
            <p>Let patients confirm appointments in real time, filling open slots within minutes.</p>
          </div>
        </li>
      </ul>

      <a href="{{ route('register') }}" class="btn">Learn More</a>
    </div>

    <div class="image-side">
      <img src="web/assets/images/ai-recep.webp" alt="AI That Converts Cancellations Into Confirmations" />
    </div>
  </div>
</section>


<style>
.cancellation-section {
  background: #f8f9fb;
  padding: 80px 5%;
  font-family: "Poppins", sans-serif;
  margin-top: -20px !important;
}

.cancellation-section .content {
  display: flex;
  align-items: flex-start;
  justify-content: space-between;
  gap: 60px;
  max-width: 1200px;
  margin: 0 auto;
}

.cancellation-section .text-side {
  flex: 1;
}

.cancellation-section h2 {
  font-size: 42px;
  font-weight: 700;
  margin-bottom: 12px;
  color: #111;
}

.cancellation-section .sub-text {
  color: #555;
  font-size: 17px;
  line-height: 1.6;
  margin-bottom: 40px;
}

.cancellation-section .features {
  list-style: none;
  margin: 0;
  padding: 0;
  display: flex;
  flex-direction: column;
  gap: 25px;
}

.cancellation-section .features li {
  display: flex;
  align-items: flex-start;
  gap: 15px;
}

.cancellation-section .features .icon {
  font-size: 22px;
  color: #0b6cff;
  background: rgba(11, 108, 255, 0.1);
  border-radius: 50%;
  width: 42px;
  height: 42px;
  display: flex;
  align-items: center;
  justify-content: center;
}

.cancellation-section .features h4 {
  margin: 0;
  font-size: 18px;
  font-weight: 600;
  color: #222;
}

.cancellation-section .features p {
  margin: 4px 0 0;
  color: #666;
  font-size: 15px;
  line-height: 1.5;
}

.cancellation-section .btn {
  display: inline-block;
  margin-top: 40px;
  padding: 12px 26px;
  background: #0b6cff;
  color: #fff;
  font-weight: 600;
  border-radius: 30px;
  text-decoration: none;
  transition: 0.3s;
}

.cancellation-section .btn:hover {
  background: #0456cc;
}

.cancellation-section .image-side {
  flex: 0 0 40%;
  text-align: center;
}

.cancellation-section .image-side img {
  width: 100%;
  max-width: 400px;
  border-radius: 12px;
  box-shadow: 0 6px 20px rgba(0, 0, 0, 0.08);
}

/* Responsive */
@media (max-width: 900px) {
  .cancellation-section .content {
    flex-direction: column;
    text-align: left;
  }
  .cancellation-section .image-side {
    order: -1;
    margin-bottom: 30px;
  }
}



.section-white-bg {
    background-color: #fff;
}


.impact-heading {
    font-size: 2.2rem;
    font-family: 'Poppins', sans-serif;
}


.impact-subtext {
    max-width: 800px;
    margin: 0 auto;
    font-size: 1.1rem;
    font-family: 'Jost', sans-serif;
}


.impact-stats-font {
    font-family: 'Jost', sans-serif;
}


.impact-number {
    color: #1351d8;
    font-size: 3rem;
    font-weight: 700;
}


.impact-stat-text {
    font-size: 1rem;
}
</style>


<!-- Proven Impact Section -->
<section class="callchex-section py-50 section-white-bg">
  <div class="container max-w-1200-px">
    <!-- Heading -->
    <div class="text-center mb-5">
      <h2 class="fw-bold impact-heading">
        Proven Impact. Real Results
      </h2>
      <p class="lead text-muted mt-3 impact-subtext">
        Voice AI takes precise orders—no more misheard items or missed customizations.
      </p>
    </div>

    <!-- Stats -->
    <div class="row text-center justify-content-center impact-stats-font">
      <div class="col-lg-3 col-md-6 mb-4">
        <h3 class="impact-number">92%</h3>
        <p class="text-muted impact-stat-text">Maximum appointment density</p>
      </div>

      <div class="col-lg-3 col-md-6 mb-4">
        <h3 class="impact-number">78%</h3>
        <p class="text-muted impact-stat-text">Same-day appointments filled</p>
      </div>

      <div class="col-lg-3 col-md-6 mb-4">
        <h3 class="impact-number">15 min</h3>
        <p class="text-muted impact-stat-text">From availability to booking</p>
      </div>

      <div class="col-lg-3 col-md-6 mb-4">
        <h3 class="impact-number">$50K</h3>
        <p class="text-muted impact-stat-text">Per month from filled slots</p>
      </div>
    </div>
  </div>
</section>




<!-- ================== Driven section Start ====================== -->
        <section class="py-50">
            <div class="container">
                <div class="">
                    <img src="web/assets/images/thumbs/driven-img.webp" alt="driven-img" loading="lazy">
                    <div class="max-w-780-px text-center mx-auto tw-mb-13">
                        <h3 class="splitTextStyleOne text-heading text-capitalize text-capitalize heading-medium">
                            Driven your business today next level by {{ config('app.site') }}
                        </h3>
                        <!-- <div class="d-flex align-items-center tw-gap-4 justify-content-center tw-mt-10">
                            <a href="{{ route('register') }}" class="hover--translate-y-1 active--translate-y-scale-9 btn button--stroke tw-gap-5 group active--translate-y-2 tw-rounded-xl text-capitalize tw-px-8 tw-py-505 fw-medium btn btn-main hover-style-one" data-block="button">
                                <span class="button__flair"></span>
                                <span class="button__label">get started </span>
                            </a>

                        </div> -->
                    </div>
                </div>
            </div>
        </section>
        <!-- ================== Driven section End ====================== -->



 


 @endsection