@extends('website.layout')

@section('meta')
    <title>How {{ config('app.site') }} Works | Smart AI Call Scoring Process</title>
    <meta name="description" content="See how {{ config('app.site') }} uses AI to score calls, improve sales performance, and boost customer satisfaction through a step-by-step quality process.">
    <meta name="keywords" content="how {{ config('app.site') }} works">

    {{-- Open Graph --}}
    <meta property="og:title" content="How {{ config('app.site') }} Works | Smart AI Call Scoring Process">
    <meta property="og:description" content="See how {{ config('app.site') }} uses AI to score calls, improve sales performance, and boost customer satisfaction through a step-by-step quality process.">
    <meta property="og:image" content="{{ asset('assets/images/shapes/net-shape.png') }}">
    <meta property="og:type" content="website">
    <meta property="og:url" content="{{ url()->current() }}">

    {{-- Twitter / X --}}
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="How {{ config('app.site') }} Works | Smart AI Call Scoring Process">
    <meta name="twitter:description" content="See how {{ config('app.site') }} uses AI to score calls, improve sales performance, and boost customer satisfaction through a step-by-step quality process.">
    <meta name="twitter:image" content="{{ asset('assets/images/shapes/net-shape.png') }}">
@endsection


@section('content')

<style>
 .paragraph-style {
  font-weight: 400;
  font-size: 18px;
}

.custom-heading {
  font-weight: 400;  
}

.max-width-40 {
  max-width: 40%;
}

.max-width-35{
  max-width: 35%;
}

.pt-40 {
  padding-top: 40px;
}

.img-deal-maxwidth {
  max-width: 35%;
}

.custom-bg-padding {
  background-color: antiquewhite;
  padding: 20px;
}

.img-how-it-works {
  max-height: 500px;
  width: 100%;
  margin-top: 80px;
  object-fit: contain;
}

.visually-hidden {
    position: absolute;
    width: 1px;
    height: 1px;
    padding: 0;
    margin: -1px;
    overflow: hidden;
    clip: rect(0, 0, 0, 0);
    white-space: nowrap;
    border: 0;
}

.as-h2 {
  font-size: clamp(1.5rem, 0.5569rem + 1.444vw, 1.875rem)
}

@media (max-width: 576px) {
  .img-how-it-works {
    margin-top: 50px;
  }
}
</style>


   <section class="section-bg-two pb-50 pt-40">
            <div class="container max-w-1290-px">
                <div class="position-relative distraction__inner">
                    <div class="max-w-602-px w-100 text-center mx-auto position-absolute z-1 tw-start-50 translate-middle-x top-0 mt-5 pt-lg-5 pt-4">
                        <h1 class="visually-hidden">How {{ config('app.domain') }} works?</h1>
                        <h3 class="splitTextStyleOne text-heading h3 text-capitalize heading-medium">
                        How {{ config('app.domain') }} works?
                        </h3>
                        <p class=" tw-mt-5 splitTextStyleOne max-w-500-px mx-auto paragraph-style">Create tasks with various custom statuses to focus more on your keep track of the progress of each. </p>
                    </div>

                    <div class="">
                        <img src="assets/images/shapes/net-shape.png" alt="Net Shape" data-aos="zoom-in" data-aos-duration="1500">
                    </div>
                    <div class="">
                        <div class="distraction-icon one position-absolute z-1 animation-scalation">
                            <img src="assets/images/thumbs/distraction-icon1.webp" alt="icon-image">
                        </div>
                        <div class="distraction-icon two position-absolute z-1 animation-upDown">
                            <img src="assets/images/thumbs/distraction-icon2.webp" alt="icon-image">
                        </div>
                        <div class="distraction-icon three position-absolute z-1 animation-upDown animation-delay-1">
                            <img src="assets/images/thumbs/distraction-icon3.webp" alt="icon-image">
                        </div>
                        <div class="distraction-icon four position-absolute z-1 animation-upDown animation-delay-2">
                            <img src="assets/images/thumbs/distraction-icon4.webp" alt="icon-image">
                        </div>
                        <div class="distraction-icon five position-absolute z-1 animation-scalation animation-delay-1">
                            <img src="assets/images/thumbs/distraction-icon5.webp" alt="icon-image">
                        </div>
                        <div class="distraction-icon six position-absolute z-1 animation-scalation animation-delay-2">
                            <img src="assets/images/thumbs/distraction-icon6.webp" alt="icon-image">
                        </div>
                        <div class="distraction-icon seven position-absolute z-1">
                            <img src="assets/images/thumbs/distraction-icon7.webp" alt="icon-image" class="">
                        </div>
                    </div>

                </div>
            </div>
        </section>
<section class="features-four">
    <div class="py-50 tw-mx-48-px position-relative">
        <img src="assets/images/bg/mash-gradient-bg2.webp" alt="Mash Gradient BG" class="w-100 h-100 position-absolute top-0 tw-start-0 z-n1">

        <div class="max-w-1820-px mx-auto">
            <div class="container">
                <div class="tw-mb-12 max-w-770-px">
                    <h2 class="tw-mb-4 line-clamp-1 font-caveat text-crm custom-heading as-h2">AI call monitoring software </h2>
                    
                </div>

                <div class="row g-32-px">
                    <!-- Call Integration -->
                    <div class="col-lg-6 col-md-12" data-aos="fade-up" data-aos-duration="1000">
                        <div class="features-four-item bg-white tw-rounded-40-px tw-px-54-px tw-pt-16 tw-pb-180-px position-relative h-100">
                            <h3 class="tw-mb-4 custom-heading">🔌 Seamless Call Integration</h3>
                            <p class="text-neutral-600 tw-text-lg fw-medium">{{ config('app.site') }} connects to your existing phone or dialer system effortlessly.</p>
                            <ul class="text-neutral-600 tw-text-base tw-mt-4">
                                <li>• Works with Twilio, RingCentral, etc.</li>
                                <li>• Real-time call access via API or webhooks</li>
                                <li>• No major setup or disruptions</li>
                            </ul>
                            <img src="assets/images/thumbs/mca.webp" alt="call integration" loading="lazy" class="position-absolute bottom-0 tw-end-0 tw-me-8 tw-rounded-2xl img-deal-maxwidth">
                        </div>
                    </div>

                    <!-- Real-Time Transcription -->
                    <div class="col-lg-6 col-md-12" data-aos="fade-up" data-aos-duration="1200">
                        <div class="features-four-item bg-white tw-rounded-40-px tw-px-54-px tw-pt-16 tw-pb-180-px position-relative h-100">
                            <h3 class="tw-mb-4 custom-heading">📝 Real-Time Transcription</h3>
                            <p class="text-neutral-600 tw-text-lg fw-medium">Crystal-clear AI transcription of every word — instantly.</p>
                            <ul class="text-neutral-600 tw-text-base tw-mt-4">
                                <li>• Accurate speech-to-text engine</li>
                                <li>• Identifies speakers and sentiment</li>
                                <li>• Enables keyword-based scoring</li>
                            </ul>
                            <img src="assets/images/thumbs/sales-pitch.webp" alt="transcription" loading="lazy" class="position-absolute bottom-0 tw-end-0 tw-me-8 tw-rounded-2xl max-width-40">
                        </div>
                    </div>

                    <!-- Smart Scoring Engine -->
                    <div class="col-lg-6 col-md-12" data-aos="fade-up" data-aos-duration="1000">
                        <div class="features-four-item bg-white tw-rounded-40-px tw-px-54-px tw-pt-16 tw-pb-180-px position-relative h-100">
                            <h3 class="tw-mb-4 custom-heading">📊 AI Scoring Engine</h3>
                            <p class="text-neutral-600 tw-text-lg fw-medium">Calls are scored automatically based on sales performance criteria.</p>
                            <ul class="text-neutral-600 tw-text-base tw-mt-4">
                                <li>• Lead qualification & script adherence</li>
                                <li>• Objection handling & tone analysis</li>
                                <li>• Deal advancement cues</li>
                            </ul>
                            <img src="assets/images/thumbs/ai-credit-scoring.webp" alt="scoring" loading="lazy" class="position-absolute bottom-0 tw-end-0 tw-me-8 tw-rounded-2xl max-width-35">
                        </div>
                    </div>

                    <!-- Actionable Insights -->
                    <div class="col-lg-6 col-md-12" data-aos="fade-up" data-aos-duration="1200">
                        <div class="features-four-item bg-white tw-rounded-40-px tw-px-54-px tw-pt-16 tw-pb-180-px position-relative h-100">
                            <h3 class="tw-mb-4 custom-heading">📈 Actionable Coaching Insights</h3>
                            <p class="text-neutral-600 tw-text-lg fw-medium">{{ config('app.site') }} flags coaching moments, issues, and wins automatically.</p>
                            <ul class="text-neutral-600 tw-text-base tw-mt-4">
                                <li>• Review top/bottom calls fast</li>
                                <li>• Spot training gaps and friction points</li>
                                <li>• Align QA and agent improvement</li>
                            </ul>
                            <img src="assets/images/thumbs/action.webp" alt="insights" loading="lazy" class="position-absolute bottom-0 tw-end-0 tw-me-8 tw-rounded-2xl max-width-35">
                        </div>
                    </div>

                    <!-- Dashboards & Tracking -->
                    <div class="col-lg-6 col-md-12" data-aos="fade-up" data-aos-duration="1000">
                        <div class="features-four-item bg-white tw-rounded-40-px tw-px-54-px tw-pt-16 tw-pb-180-px position-relative h-100">
                            <h3 class="tw-mb-4 custom-heading">📊 Smart Dashboards & Reports</h3>
                            <p class="text-neutral-600 tw-text-lg fw-medium">Track trends, agent performance, and QA audits — all in one place.</p>
                            <ul class="text-neutral-600 tw-text-base tw-mt-4">
                                <li>• Score breakdowns by team or campaign</li>
                                <li>• Exportable reports & audit trails</li>
                                <li>• Continuous performance improvement</li>
                            </ul>
                            <img src="assets/images/bg/dashboard.webp" alt="dashboard" loading="lazy" class="position-absolute bottom-0 tw-end-0 tw-me-8 tw-rounded-2xl max-width-40">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="about-two py-50 position-relative z-1 overflow-hidden " >
    <img src="assets/images/bg/mash-gradient-bg3.webp" alt="Gradient" class="position-absolute tw-start-0 top-0 z-n1">

    <div class="container">
        <div class="row gy-4 flex-wrap-reverse">
            <div class="col-lg-6 custom-bg-padding">
                <img src="assets/images/thumbs/how-it-works.webp" alt="mca" loading="lazy" class="img-fluid img-how-it-works">
            </div>

            <div class="col-lg-6">
                <div class="ps-xl-5">
                    <div class="tw-mb-6">
                        <h2 class="tw-mb-2 line-clamp-1 font-caveat text-crm heading-medium as-h2">
                            How {{ config('app.site') }} Works?
                        </h2>
                        <p class="splitTextStyleOne text-neutral-500 tw-mt-2 max-w-570-px paragraph-style">
                            Automate and optimize your sales process with {{ config('app.site') }}. Here’s how it supports MCA teams every step of the way.
                        </p>
                    </div>

                    <div class="accordion common-accordion" id="callScoreAccordion">
                        <!-- Customize Your Playbook -->
                        <div class="accordion-item tw-px-40-px tw-rounded-xl section-bg-one border-0 tw-mb-2">
                            <h3 class="accordion-header">
                                <button class="accordion-button tw-py-6 shadow-none px-0 bg-transparent h5"
                                    type="button" data-bs-toggle="collapse" data-bs-target="#playbook"
                                    aria-expanded="true" aria-controls="playbook">
                                    Customize Your Playbook
                                </button>
                            </h3>
                            <div id="playbook" class="accordion-collapse collapse show"
                                data-bs-parent="#callScoreAccordion">
                                <div class="accordion-body ps-0 pt-0 pe-0 tw-pb-6">
                                    <p class="mb-0">Define the perfect sales call using our intuitive editor. Outline expected outcomes and set detailed analysis criteria for every stage of your sales cycle.</p>
                                </div>
                            </div>
                        </div>

                        <!-- Automate Call Analysis -->
                        <div class="accordion-item tw-px-40-px tw-rounded-xl section-bg-one border-0 tw-mb-2">
                            <h3 class="accordion-header">
                                <button class="accordion-button tw-py-6 shadow-none px-0 bg-transparent h5 collapsed"
                                    type="button" data-bs-toggle="collapse" data-bs-target="#automate"
                                    aria-expanded="false" aria-controls="automate">
                                    Automate Call Analysis
                                </button>
                            </h3>
                            <div id="automate" class="accordion-collapse collapse"
                                data-bs-parent="#callScoreAccordion">
                                <div class="accordion-body ps-0 pt-0 pe-0 tw-pb-6">
                                    <p class="mb-0">Let AI and science do the heavy lifting. CallAnalyzer.AI analyzes 100% of your calls and generates deep actionable insights with 95% accuracy – no manual review required.</p>
                                </div>
                            </div>
                        </div>

                        <!-- Optimize for More Wins -->
                        <div class="accordion-item tw-px-40-px tw-rounded-xl section-bg-one border-0 tw-mb-2">
                            <h3 class="accordion-header">
                                <button class="accordion-button tw-py-6 shadow-none px-0 bg-transparent h5 collapsed"
                                    type="button" data-bs-toggle="collapse" data-bs-target="#optimize"
                                    aria-expanded="false" aria-controls="optimize">
                                    Optimize for More Wins
                                </button>
                            </h3>
                            <div id="optimize" class="accordion-collapse collapse"
                                data-bs-parent="#callScoreAccordion">
                                <div class="accordion-body ps-0 pt-0 pe-0 tw-pb-6">
                                    <p class="mb-0">Systematically coach and improve every rep on your team with a few clicks. Driving continuous improvement in win rate through collaborative experimentation and validated learning at scale.</p>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>

        </div>
    </div>
</section>

@endsection
