<!DOCTYPE html>
<html lang="en" class="home-one">


<head>

    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">

    @if (Request::is('/')) {{-- Home page --}}
<title>Leadmine.pro | AI-Powered Sales & Lead Automation Platform</title>
<meta name="description" content="Leadmine brings AI voice automation to your business—automate calls, reminders, customer engagement, and workflows with smart tools.">
<meta name="keywords" content="AI sales automation, lead generation software, real estate CRM, AI call tracking, lead scoring platform">
<meta property="og:title" content="Leadmine.pro | AI-Powered Sales & Lead Automation Platform">
<meta property="og:description" content="Leadmine brings AI voice automation to your business—automate calls, reminders, customer engagement, and workflows with smart tools.">
<meta property="og:keyword" content="AI sales automation, lead generation software">

    @else
    @yield('meta')
    
    @endif

    <meta name="robots" content="INDEX,FOLLOW">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <meta name="google-site-verification" content="dQBJY5FGf1e6HJ8hgO5YAP4ihqxab-fWIOGqe8bI3zs" />

    
    <!-- Canonical Tag -->
   <link rel="canonical" href="https://leadmine.pro{{ request()->getPathInfo() }}">


    <!-- Title -->

   <script src="https://analytics.ahrefs.com/analytics.js" 
        data-key="HjC+3NNtpjAScoFTnBuy2A" async></script>

   <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

    

 
  
@php
   $dashboardImage = url(config('app.dashboard_image'));
@endphp

<!-- <link rel="preload"
      as="image"
      href="{{ $dashboardImage }}"
      type="image/webp"
      imagesrcset="{{ $dashboardImage }}"
      fetchpriority="high"> -->


<style>
  body { visibility: hidden; }
</style>
<script>
  let css = document.createElement("link");
  css.rel = "stylesheet";
  css.href = "https://leadmine.pro/web/assets/css/combined.min.css";

  css.onload = function () {
    if (document.body) {
      document.body.style.visibility = "visible";
    } else {
      document.addEventListener("DOMContentLoaded", function () {
        document.body.style.visibility = "visible";
      });
    }
  };

  document.head.appendChild(css);
</script>




<!-- Favicon -->
<link rel="shortcut icon"  type="image/png" href="{{ asset('favicon.png') }}">
<link rel="apple-touch-icon" sizes="180x180" href="{{ asset('favicon.png') }}">
<!-- <link rel="icon" type="image/x-icon" href="{{ asset('favicon.ico') }}"> -->

<link rel="preload" as="style" href="{{ asset('web/assets/css/combined.min.css') }}" onload="this.onload=null;this.rel='stylesheet'">
<noscript><link rel="stylesheet" href="{{ asset('web/assets/css/combined.min.css') }}"></noscript>


{{-- Organization Schema --}}
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Organization",
  "name": "Leadmine",
  "url": "https://leadmine.pro",
  "logo": "https://leadmine.pro/web/assets/images/headlogo.webp",
  "contactPoint": {
    "@type": "ContactPoint",
    "telephone": "+1 (902) 441-2385",
    "contactType": "customer service",
    "areaServed": "US",
    "availableLanguage": "en"
  },
  "sameAs": [
    "https://www.instagram.com/leadmine.pro/",
    "https://www.linkedin.com/in/leadminepro/"
  ]
}
</script>



    <style>
        .logo-img {
            max-height: 115px;
            width: auto;
            height: auto;
        }

        .logo {
          margin-left: -50px;
        }

        .footer{
          margin-left: -20px;
        }

        .vertical-divider {
           width: 2px;
           height: 20px;
           background-color: rgba(0, 0, 0, 0.2);
        }

        .custom-footer {
         background-color: #0d031d;
         color: white;
         padding: 30px 40px;
         font-family: Arial, sans-serif;
        }

        .custom-heading-xl {
           perspective: 100px;
           line-height: normal;
        }

        .bg-primary-hsl {
           background-color: hsl(221 73% 60% / 1);
        }

        .flair-transform-effect {
            transform: translate(116.279%, -20%) scale(0, 0);
        }

        .container-flex-wrap {
            display: flex;
            flex-wrap: wrap;
            justify-content: space-between;
            max-width: 1200px;
            margin: 0 auto;
        }

        .flex-item-grow-shrink {
           flex: 1 1 200px;
        }

        .flex-item-custom {
           flex: 1 1 200px;
           min-width: 150px;
           margin-top: 20px;
        }

        .flex-item2 {
           flex: 1 1 200px;
           min-width: 180px;
           margin-top: 20px;
        }

          .flex-item3 {
           flex: 1 1 200px;
           min-width: 100px;
           margin-top: 20px;
        }

        .footer-logo-img {
           margin-left: -29px !important;
           margin-bottom: 12px;
        }

        .text-muted-small {
           color: #a8a8b3;
           font-size: 14px;
           line-height: 1.5;
        }

        .mt-20px {
            margin-top: 20px;
        }

.social-icon-link {
  display: inline-block;
  width: 40px;
  height: 40px;
  background: #1c1b2b;
  margin-right: 10px;
  border-radius: 6px;
  text-align: center;
  line-height: 40px;
}

.social-icon-img {
  width: 20px;
  vertical-align: middle;
}

.section-heading {
  font-size: 16px;
  margin-bottom: 12px;
}

.list-reset {
  list-style: none;
  padding: 0;
  margin: 0;
}

.list-link {
  color: #a8a8b3;
  text-decoration: none;
  display: block;
  margin: 6px 0;
}

.footer-bottom {
  border-top: 1px solid rgb(115, 107, 127);
  margin-top: 40px;
  padding-top: 20px;
  text-align: center;
  font-size: 13px;
  color: #a8a8b3;
}

.flex-column-wrapper {
  display: flex;
  flex-direction: column;
  max-width: 1200px;
  margin: 0 auto;
  gap: 10px;
}

.flex-row-wrap {
  display: flex;
  justify-content: space-between;
  flex-wrap: wrap;
  row-gap: 15px;
}

.heading-medium {
  font-weight: 500;
}
.section-heading{
    font-weight: 700;
}



.hero-section {
  position: relative;
  z-index: 0 !important;
  overflow: visible !important;
}


.solutions-megamenu {
  position: fixed !important;
  top: 90px !important;  
  left: 50% !important;
  transform: translateX(-50%) !important;
  width: 880px !important;
  background: #fff !important;
  z-index: 999999 !important;
  opacity: 0;
  visibility: hidden;
  transition: all 0.3s ease;
  padding: 25px 45px 30px 45px !important; 
  border-radius: 14px !important;
  box-shadow: 0 25px 60px rgba(0, 0, 0, 0.08) !important;
}


.solutions-megamenu.open {
  display: block !important;
  opacity: 1 !important;
  visibility: visible !important;
}


.solutions-tabs {
  display: flex;
  gap: 30px;
  border-bottom: 1px solid #e5e7eb;
    margin-top: 0 !important;
  margin-bottom: 25px !important;

}

.solutions-tabs .tab-link {
  background: none;
  border: none;
  font-size: 15px;
  font-weight: 500;
  color: #374151;
  cursor: pointer;
  padding-bottom: 8px;
  position: relative;
  transition: color 0.3s ease;
}

.solutions-tabs .tab-link:hover {
  color: #2563eb;
}

.solutions-tabs .tab-link.active {
  color: #2563eb;
  font-weight: 600;
}

.solutions-tabs .tab-link.active::after {
  content: "";
  position: absolute;
  bottom: -8px;
  left: 0;
  width: 100%;
  height: 2px;
  background: #2563eb;
  border-radius: 2px;
}

.solutions-content {
  padding-top: 5px;
}

.solutions-megamenu .tab-content { display: none; } 
.solutions-megamenu .tab-content.active { display: block; }

.solutions-grid {
  display: grid;
  grid-template-columns: repeat(2, 1fr);
   gap: 20px 35px !important;
}

.solution-item {
  display: flex;
  gap: 14px;
  padding: 14px 16px;
  border-radius: 10px;
  text-decoration: none;
  transition: all 0.3s ease;
}

.solution-item:hover {
  background-color: #eef4ff;
}

.solution-item .icon {
  background: #f0f6ff;
  color: #2563eb;
  width: 40px;
  height: 40px;
  border-radius: 10px;
  display: flex;
  align-items: center;
  justify-content: center;
  font-size: 18px;
}

.solution-item .content h4 {
  font-size: 15px;
  font-weight: 600;
  color: #111827;
  margin: 0;
}

.solution-item .content p {
  font-size: 13px;
  color: #6b7280;
  margin-top: 3px;
  line-height: 1.4;
}

.see-more {
  border-top: 1px solid #e5e7eb;
  margin-top: 30px !important;
  padding-top: 18px !important;
}

.see-more a {
  color: #2563eb;
  font-weight: 600;
  font-size: 14px;
  text-decoration: none;
}


.megamenu-li > a {
  font-weight: 600 !important;
  color: inherit !important;
}

.megamenu-li > a i {
  font-weight: 600 !important;
  color: inherit !important;
}


</style>

  <script>
  window.addEventListener('scroll', function loadGtag() {
    var s = document.createElement('script');
    s.src = "https://www.googletagmanager.com/gtag/js?id=G-FMVPG3SE23";
    s.async = true;
    document.head.appendChild(s);

    s.onload = function () {
      window.dataLayer = window.dataLayer || [];
      function gtag(){ dataLayer.push(arguments); }
      gtag('js', new Date());
      gtag('config', 'G-FMVPG3SE23');
    };

    window.removeEventListener('scroll', loadGtag);
  });
</script>


</head>


<body>

    <!--==================== Preloader Start ====================-->
    <div class="preloader">
        <div class="cssload-loading"><i></i><i></i><i></i><i></i></div>
    </div>
    <!--==================== Preloader End ====================-->

    <!--==================== Overlay Start ====================-->
    <div class="overlay"></div>
    <!--==================== Overlay End ====================-->

    <!--==================== Sidebar Overlay End ====================-->
    <div class="side-overlay"></div>
    <!--==================== Sidebar Overlay End ====================-->

    <!-- Custom Toast Message start -->
    <div id="toast-container"></div>
    <!-- Custom Toast Message End -->

    <!-- ==================== Scroll to Top End Here ==================== -->
    <div class="progress-wrap">
        <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
            <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" />
        </svg>
    </div>
    <!-- ==================== Scroll to Top End Here ==================== -->

    <!-- Custom Cursor Start -->
    <div class="cursor-pointer"></div>
    <!-- <span class="dot"></span> -->
    <!-- Custom Cursor End -->

    <!-- ==================== Mobile Menu Start Here ==================== -->
    <div
        class="mobile-menu d-lg-none d-block scroll-sm position-fixed bg-white tw-w-300-px tw-h-screen overflow-y-auto tw-p-6 tw-z-999 tw--translate-x-full tw-pb-68 ">

        <button type="button"
            class="close-button position-absolute tw-end-0 top-0 tw-me-2 tw-mt-2 tw-w-605 tw-h-605 rounded-circle d-flex justify-content-center align-items-center text-neutral-900 bg-neutral-200 hover-bg-neutral-900 hover-text-white">
            <i class="ph ph-x"></i>
        </button>

        <div class="mobile-menu__inner">

            <div class="mobile-menu__menu">
                <!-- Nav menu Start -->
                <ul class="nav-menu d-lg-flex align-items-center nav-menu--mobile d-block tw-mt-8">
                    <li class="nav-menu__item  position-relative activePage">
                        <a href="{{ url('/') }}"
                            class="nav-menu__link hover--translate-y-1 tw-pe-5 text-heading tw-py-9 fw-semibold w-100">Home</a>

                    </li>

                
                    <li class="nav-menu__item">
                        <a href="{{ url('/price-plan') }}"
                            class="nav-menu__link hover--translate-y-1 text-heading tw-py-9 fw-semibold w-100">Price
                            plan</a>
                    </li>
                    <li class="nav-menu__item">
                        <a href="{{ url('/contact-us') }}"
                            class="nav-menu__link hover--translate-y-1 text-heading tw-py-9 fw-semibold w-100">Contact
                            us</a>
                    </li>
                    <li class="nav-menu__item">
                        <a href="{{ url('/faq') }}"
                            class="nav-menu__link hover--translate-y-1 text-heading tw-py-9 fw-semibold w-100"> FAQ</a>
                    </li>
                    <li class="nav-menu__item">
                        <a href="{{ route('login') }}"
                            class="nav-menu__link hover--translate-y-1 text-heading tw-py-9 fw-semibold w-100"> Sign
                            In</a>
                    </li>
                </ul>
                <!-- Nav menu End  -->

            </div>

            <a href="{{ route('register') }}"
                class="btn btn-main-two hover-style-two button--stroke d-sm-none d-inline-flex align-items-center justify-content-center tw-gap-5 group active--translate-y-2 tw-px-8 rounded-pill tw-mt-6"
                data-block="button">
                <span class="button__flair"></span>
                <span class="button__label">Register</span>
            </a>
        </div>
    </div>
    <!-- ==================== Mobile Menu End Here ==================== -->



    <div id="smooth-wrapper">

        <!-- ========================== Top Header Start ============================== -->
        <div class="bg-main-600 tw-py-205 d-sm-block d-none">
            <div class="container">

            </div>
        </div>
        <!-- ========================== Top Header End ============================== -->

        <!-- ==================== Header Start Here ==================== -->
        <header class="header bg-white transition-all">
            <div class="container container-two">
                <nav class="d-flex align-items-center justify-content-between">
                    <!-- Logo Start -->
                    <div class="logo">

                        <a href="{{ url('/') }}">
                            <img src="{{url('/')}}{{ config('app.logo') }}?v={{ time() }}"
                                alt="{{ config('app.site') }}" class="logo-img">

                                  <!-- <img src="assets/images/headlogo.png"
                                alt="{{ config('app.site') }}" class="logo-img"> -->

                        </a>
                    </div>
                    <!-- Logo End  -->

                    <!-- Menu Start  -->
                    <div class="header-menu d-lg-block d-none">
                        <!-- Nav menu Start -->
                        <ul class="nav-menu d-lg-flex align-items-center tw-gap-14">
                            <li class="nav-menu__item position-relative activePage">
                                <a href="{{ url('/') }}"
                                    class="nav-menu__link hover--translate-y-1 tw-pe-5 text-heading tw-py-9 fw-semibold w-100">Home</a>


                            </li>
<li class="megamenu-li">
  <a href="#">Solutions <i class="fa-solid fa-angle-down"></i></a>

  <ul class="submenu solutions-megamenu">
    <li>
      <div class="solutions-wrapper">

        <!-- Tabs on top -->
        <div class="solutions-tabs">
          <button class="tab-link active" data-tab="usecases">Use Cases</button>
          <button class="tab-link" data-tab="industry">Industry</button>
        </div>

        <!-- Tab Content -->
        <div class="solutions-content">

          <!-- Use Cases -->
          <div class="tab-content active" id="usecases">
          <div class="solutions-grid">
  <a href="/ai-answering" class="solution-item">
    <div class="icon"><i class="fa-solid fa-robot"></i></div>
    <div class="content">
      <h4>AI Answering</h4>
      <p>Automate inbound queries and manage responses efficiently</p>
    </div>
  </a>

  <a href="/customer-services" class="solution-item">
    <div class="icon"><i class="fa-solid fa-headset"></i></div>
    <div class="content">
      <h4>Customer Service</h4>
      <p>Deliver 24/7 intelligent support and improve satisfaction</p>
    </div>
  </a>

  <a href="/ai-receptionist" class="solution-item">
    <div class="icon"><i class="fa-solid fa-user-tie"></i></div>
    <div class="content">
      <h4>AI Receptionist</h4>
      <p>Handle calls, schedule meetings, and manage guests smartly</p>
    </div>
  </a>

  <a href="/order-taker" class="solution-item">
    <div class="icon"><i class="fa-solid fa-box-open"></i></div>
    <div class="content">
      <h4>Order Taker</h4>
      <p>Take orders seamlessly through voice or chat automation</p>
    </div>
  </a>

  <a href="/reduce-appointment-no-shows" class="solution-item">
    <div class="icon"><i class="fa-solid fa-user-clock"></i></div>
    <div class="content">
      <h4>Reduce Appt. No-Shows</h4>
      <p>Send automated reminders to minimize missed appointments</p>
    </div>
  </a>

  <a href="/ai-voice-recall-reminder-to-patients" class="solution-item">
    <div class="icon"><i class="fa-solid fa-bell"></i></div>
    <div class="content">
      <h4>Patient Recall Reminder</h4>
      <p>Automatically remind patients for regular checkups and follow-ups</p>
    </div>
  </a>

  <a href="/fill-last-minute-appointments" class="solution-item">
    <div class="icon"><i class="fa-solid fa-calendar-check"></i></div>
    <div class="content">
      <h4>Fill Last Minute Appointment</h4>
      <p>Quickly fill canceled slots with automated last-minute notifications</p>
    </div>
  </a>
</div>

            <!-- <div class="see-more">
              <a href="#">See all use cases →</a>
            </div> -->
          </div>

          <!-- Industry -->
          <div class="tab-content" id="industry">
            <div class="solutions-grid">
              <a href="/real-estate-mortgage-intelligence" class="solution-item">
                <div class="icon"><i class="fa-solid fa-building"></i></div>
                <div class="content">
                  <h4>Real Estate</h4>
                  <p>Accelerate property deals by handling calls and showings efficiently</p>
                </div>
              </a>
              <a href="/healthcare" class="solution-item">
                <div class="icon"><i class="fa-solid fa-user-doctor"></i></div>
                <div class="content">
                  <h4>Healthcare</h4>
                  <p>Offer contextual and reliable support to your patients and providers</p>
                </div>
              </a>
              <a href="/technology" class="solution-item">
                <div class="icon"><i class="fa-solid fa-globe"></i></div>
                <div class="content">
                  <h4>Technology</h4>
                  <p>Offer the best-in-class customer communication platform to your team</p>
                </div>
              </a>
              <a href="/education" class="solution-item">
                <div class="icon"><i class="fa-solid fa-graduation-cap"></i></div>
                <div class="content">
                  <h4>Education</h4>
                  <p>Manage workflows for admissions, enrollment, and counselling in one place</p>
                </div>
              </a>
              <a href="/financial-services" class="solution-item">
                <div class="icon"><i class="fa-solid fa-sack-dollar"></i></div>
                <div class="content">
                  <h4>Financial Services</h4>
                  <p>Deliver secure conversations with your customers and build trust</p>
                </div>
              </a>
              <a href="/retail" class="solution-item">
                <div class="icon"><i class="fa-solid fa-cart-shopping"></i></div>
                <div class="content">
                  <h4>Retail</h4>
                  <p>Enhance retail customer engagement and service</p>
                </div>
              </a>
              <a href="/fitness-wellness" class="solution-item">
                <div class="icon"><i class="fa-solid fa-dumbbell"></i></div>
                <div class="content">
                  <h4>Fitness & Wellness</h4>
                  <p>Grow bookings and memberships, deliver great client experiences</p>
                </div>
              </a>
            </div>
            <div class="see-more">
              <a href="/all-industries">See all industries →</a>
            </div>
          </div>

        </div>
      </div>
    </li>
  </ul>
</li>



                            <li class="nav-menu__item">
                                <a href="{{ url('/price-plan') }}"
                                    class="nav-menu__link hover--translate-y-1 text-heading tw-py-9 fw-semibold w-100">Price
                                    Plan</a>
                            </li>
                            <li class="nav-menu__item">
                                <a href="{{ url('/contact-us') }}"
                                    class="nav-menu__link hover--translate-y-1 text-heading tw-py-9 fw-semibold w-100">Contact
                                    us</a>
                            </li>
                            <li class="nav-menu__item">
                                <a href="{{ url('/faq') }}"
                                    class="nav-menu__link hover--translate-y-1 text-heading tw-py-9 fw-semibold w-100">
                                    FAQ</a>
                            </li>

                    </li>
                        </ul>
                        <!-- Nav menu End  -->

                    </div>
                    <!-- Menu End  -->

                    <!-- Header Right start -->

                    <div class="d-flex align-items-center tw-gap-6">

                        <div> <a href="{{ url('login') }}"
                                class="nav-menu__link hover--translate-y-1 text-heading tw-py-9 fw-semibold w-100 d-lg-block d-none">
                                Sign In
                            </a></div>
                        <!-- Vertical Divider -->
                        <div class="vertical-divider d-lg-block d-none"></div>

                        <a href="{{ route('register') }}"
                            class="hover--translate-y-1 active--translate-y-scale-9 btn btn-main-two hover-style-two button--stroke d-sm-inline-flex d-none align-items-center justify-content-center tw-gap-5 group active--translate-y-2 tw-px-9 rounded-pill tw-py-4 fw-semibold"
                            data-block="button">
                            <span class="button__flair"></span>
                            <span class="button__label">Sign Up for a free trial</span>
                        </a>
                        <button type="button"
                            class="toggle-mobileMenu leading-none d-lg-none text-neutral-800 tw-text-9">
                            <i class="ph ph-list"></i>
                        </button>
                    </div>
                    <!-- Header Right End  -->
                </nav>
            </div>
        </header>
        <!-- ==================== Header End Here ==================== -->

        <div id="smooth-content">



            @yield('content')


            <section class="footer-five mt-3 mb-3">
                <div class="tw-mx-48-px position-relative  z-1 rounded-top-30-px">

                    <div class="row justify-content-center ">
                        <div class="col-xxl-12">
                            <div class=" tw-rounded-28-px tw-py-40-px bg-primary-hsl">
                                <div class="text-center mx-auto max-w-724-px">
                                    <div class="bg-white-13 tw-py-2 tw-px-7 rounded-pill text-white fw-semibold text-capitalize tw-leading-none d-inline-flex align-items-center tw-gap-2 tw-mb-405 min-w-max common-shadow-twentyNine aos-init aos-animate"
                                        data-aos="fade-up" data-aos-anchor-placement="top-bottom"
                                        data-aos-duration="600">
                                        Get Started Today
                                    </div>
                                    <h2 class="text-44-px splitTextStyleOne text-white text-capitalize  fw-medium custom-heading-xl">
                                        Ready to Add AI Voice to Your Business with {{ config('app.site') }}!?

                                        <!-- {{ config('app.site') }}! -->
                                    </h2>
                                    <div class="tw-mt-9 aos-init aos-animate" data-aos="fade-up"
                                        data-aos-anchor-placement="top-bottom" data-aos-duration="1200">
                                        <a href="{{ route('register') }}"
                                            class="hover--translate-y-1 active--translate-y-scale-9 btn btn-white hover-style-one button--stroke d-sm-inline-flex d-none align-items-center justify-content-center tw-gap-5 group active--translate-y-2 tw-px-14 rounded-pill tw-py-505 fw-semibold common-shadow-inset-one"
                                            data-block="button">
                                            <span class="button__flair flair-transform-effect"></span>
                                            <span class="button__label">Sign up Now</span>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


                </div>
            </section>
            <!-- ==================== Footer Start Here ==================== -->
            <footer class="custom-footer">
                <div class="container-flex-wrap">

                    <!-- Logo and Description -->
                    <div class="flex-item-grow-shrink">
                        <div class="logo">

                            <a href="{{ url('/') }}"><img src="{{url('/')}}{{ config('app.portal_logo') }}?v={{ time() }}"
                                    alt="{{ config('app.site') }}" class="footer-logo-img"></a>

                                          <!-- <a href="{{ url('/') }}"><img src="assets/images/headlogo.png"
                                    alt="{{ config('app.site') }}" class="footer-logo-img"></a> -->

                        </div>
                  <div class="footer">
    <p class="text-muted-small">
        Leadmine.pro builds AI-powered voice solutions that automate calls, enhance customer experience, and alert you instantly to compliance risks or critical events.
    </p>

    <div class="mt-20px">
        <a href="https://www.linkedin.com/in/leadminepro/" class="social-icon-link">
            <img src="{{ asset('web/assets/images/icons/linkedin.svg') }}" alt="LinkedIn" class="social-icon-img">
        </a>
        <a href="https://www.instagram.com/leadmine.pro/" class="social-icon-link">
            <img src="{{ asset('web/assets/images/icons/instagram.svg') }}" alt="Instagram" class="social-icon-img">
        </a>
        <a href="#" class="social-icon-link">
            <img src="{{ asset('web/assets/images/icons/calendar.svg') }}" alt="Calendar" class="social-icon-img">
        </a>
        <a href="#" class="social-icon-link">
            <img src="{{ asset('web/assets/images/icons/mail.svg') }}" alt="Email" class="social-icon-img">
        </a>
    </div>
</div>


                    </div>

                    <!-- Column 1 - Company -->
                    <div class="flex-item-custom">
                        <div class="section-heading">Company</div>
                        <ul class="list-reset">
                            <li><a href="{{ url('/') }}"
                                    class="list-link">Home</a>
                            </li>

                            <li><a href="{{ url('/contact-us') }}"
                                     class="list-link">Contact
                                    Us</a></li>
                                     <li><a href="{{ url('/about-us') }}"
                                        class="list-link">About
                                    Us</a></li>
                                   
                                    <li > 
                        <a href="{{ route('login') }}"
                             class="list-link"> Sign
                            In</a>
                            <li>
                        <a href="{{ route('register') }}"
                           class="list-link"> Sign Up
                            </a>
                    </li>
                        </ul>
                    </div>

                    <!-- Column 2 - Solution -->
                    <div class="flex-item3">
                        <div class="section-heading">Solution</div>
                        <ul class="list-reset">
                             <!-- <li><a href="{{ url('/how-it-works') }}"
                                     class="list-link">How it works?</a>
                            </li> -->
                       

                            <li><a href="{{ url('/price-plan') }}"
                                    class="list-link">Price
                                    Plan</a></li>
                            <li><a href="{{ url('/faq') }}"
                                    class="list-link">FAQ</a>
                            </li>
                            <li><a href="{{ url('/blogs') }}"
                                    class="list-link">Blog</a>
                            </li>
                        
                        </ul>
                    </div>
                    <!-- Column 3 - Integration -->
                    <!-- <div class="flex-item2">
                        <div class="section-heading">Industries</div>
                        <ul class="list-reset">
                            <li><a href="{{ url('/merchant-cash-advance') }}"
                                     class="list-link">Merchant
                                    Cash Advance</a></li>
                            <li><a href="{{ url('/real-estate-mortgage-intelligence') }}"
                                     class="list-link">Real
                                    Estate & Mortgage</a></li>
                            <li><a href="{{ url('/debt-consolidation') }}"
                                   class="list-link">Debt
                                    Consolidation </a></li>
                            <li><a href="{{ url('/insurance') }}"
                                   class="list-link">Insurance
                                    Sales </a></li>
                            <li><a href="{{ url('/auto-warranty') }}"
                                   class="list-link">Auto
                                    Warranty / Loan Services</a></li>
                            <li><a href="{{ url('/payday-loans') }}"
                                     class="list-link">Payday
                                    Loans / Short-Term Lending</a></li>
                        </ul>
                    </div> -->

                  
                      <div class="flex-item-custom">
                        <div class="section-heading">Use Cases</div>
                        <ul class="list-reset">
                           
                            <li><a href="{{ url('/ai-answering') }}"
                                     class="list-link">AI Answering</a></li>
                            <li><a href="{{ url('/ai-receptionist') }}"
                                   class="list-link">AI Receptionist</a></li>
                            <li><a href="{{ url('/reduce-appointment-no-shows') }}"
                                   class="list-link">Reduce Appt. No-Shows</a></li>
                            <li><a href="{{ url('/customer-services') }}"
                                   class="list-link">Customer Services</a></li>
                            <li><a href="{{ url('/order-taker') }}"
                                     class="list-link">
                                    Order Taker</a></li>
                            <li><a href="{{ url('/ai-voice-recall-reminder-to-patients') }}"
                                     class="list-link">
                                    Patient Recall Reminder</a></li>
                            <li><a href="{{ url('/fill-last-minute-appointments') }}"
                                     class="list-link">
                                   Fill Last Minute Appointment</a></li>
                            
                        </ul>
                    </div>

             

                       <div class="flex-item2">
                        <div class="section-heading">Industries</div>
                        <ul class="list-reset">
                           
                            <li><a href="{{ url('/real-estate-mortgage-intelligence') }}"
                                     class="list-link">Real
                                    Estate & Mortgage</a></li>
                            <li><a href="{{ url('/technology') }}"
                                   class="list-link">Technology</a></li>
                            <li><a href="{{ url('/healthcare') }}"
                                   class="list-link">Healthcare</a></li>
                            <li><a href="{{ url('/financial-services') }}"
                                   class="list-link">Financial Services</a></li>
                            <li><a href="{{ url('/fitness-wellness') }}"
                                     class="list-link">
                                    Fitness & Wellness</a></li>
                            <li><a href="{{ url('/education') }}"
                                     class="list-link">Education</a></li>
                            <li><a href="{{ url('/retail') }}"
                                     class="list-link">Retail</a></li>
                        </ul>
                    </div>

                    <!-- Column 4 - Why  -->
                    <!-- <div class="flex-item-custom">
                        <h3 class="section-heading"></h3>
                        <ul class="list-reset">
                            <li><a href="{{ url('/tax-resolution') }}"
                                     class="list-link">Tax
                                    Resolution Services</a></li>
                            <li><a href="{{ url('/ecommerce-financing') }}"
                                    class="list-link">E-commerce
                                    Financing</a></li>
                            <li><a href="{{ url('/collections') }}"
                                   class="list-link">Collections
                                    (1st Party / 3rd Party)</a></li>
                            <li><a href="{{ url('/home-renovation') }}"
                                     class="list-link">Home
                                    Renovation Financing</a></li>
                            <li><a href="{{ url('/private-banking') }}"
                                   class="list-link">Private
                                    Banking & Wealth Advisory</a></li>
                            <li><a href="{{ url('/ai-call-analytics-real-estate') }}"
                                   class="list-link">AI Call Analytics for Real Estate </a></li>
<li><a href="{{ url('/best-ai-call-scoring-tool') }}"
                                   class="list-link">Best AI Call Scoring & Analytics Platform  </a></li>
                                       <li><a href="{{ url('/call-center-quality-assurance-software') }}"
                                   class="list-link">Call Center Quality Assurance Software </a></li>
                        </ul>
                    </div>-->

                </div> 

                <!-- Bottom Bar -->
                <div class="footer-item footer-bottom">
                    <div class="flex-column-wrapper">
                        <!-- First row will stack on mobile/tablet -->
                        <div class="flex-row-wrap">

                            <div class="flex:1 1 300px; min-w-[200px] text-left sm:text-left">
                               {{ config('app.site') }}  © 2025. All Rights Reserved.
                            </div>

                            <!-- Links -->
                            <div class="flex:1 1 300px; min-w-[200px] text-center sm:text-center">
                                <a href="{{ url('/terms-services') }}"> Terms & Agreement &nbsp; | &nbsp;</a><a
                                    href="{{ url('/privacy-policy') }}"> Privacy Policy</a>
                            </div>

                            <!-- Powered By -->
                            <div class="flex:1 1 300px; min-w-[200px] text-right sm:text-left">
                                Powered by {{ config('app.site') }}
                            </div>
                        </div>
                    </div>
                </div>

                <script src="https://analytics.ahrefs.com/analytics.js" data-key="+vF1/QdkB1kiOJc7F1Q5tQ" async></script>
            </footer>

            <!-- ==================== Footer End Here ==================== -->


        </div>
    </div>

<script src="{{ asset('web/assets/js/combined.min.js') }}"></script>

<script>
if (window.gsap) {
    gsap.config({ nullTargetWarn: false });

    const _to = gsap.to;
    const _set = gsap.set;
    const _from = gsap.from;

    function safeTarget(target) {
        if (!target) return null;
        if (typeof target === "string" && target.trim() === "") return null;
        const el = document.querySelectorAll(target);
        return el.length ? el : null;
    }

    gsap.to = function(target, vars) {
        const el = safeTarget(target);
        if (!el) return;
        return _to(el, vars);
    };

    gsap.set = function(target, vars) {
        const el = safeTarget(target);
        if (!el) return;
        return _set(el, vars);
    };

    gsap.from = function(target, vars) {
        const el = safeTarget(target);
        if (!el) return;
        return _from(el, vars);
    };
}

document.addEventListener("DOMContentLoaded", function() {
    document.body.style.visibility = "visible";
});
</script>



<script>
document.querySelectorAll(".megamenu-li > a").forEach(link => {
  link.addEventListener("click", function(e) {
    e.preventDefault();
    const menu = this.parentElement.querySelector(".solutions-megamenu");
    const isOpen = menu.classList.contains("open");

    document.querySelectorAll(".solutions-megamenu").forEach(m => {
      m.classList.remove("open");
      m.style.display = "none";
      m.style.opacity = "0";
      m.style.visibility = "hidden";
    });

    if (!isOpen) {
      menu.classList.add("open");
      menu.style.display = "block";
      setTimeout(() => {
        menu.style.opacity = "1";
        menu.style.visibility = "visible";
      }, 10);
    }
  });
});

document.addEventListener("click", e => {
  if (!e.target.closest(".megamenu-li")) {
    document.querySelectorAll(".solutions-megamenu").forEach(menu => {
      menu.classList.remove("open");
      menu.style.display = "none";
      menu.style.opacity = "0";
      menu.style.visibility = "hidden";
    });
  }
});

// Scoped tab switching
document.querySelectorAll(".solutions-megamenu").forEach(menu => {
  const tabLinks = menu.querySelectorAll(".tab-link");
  const tabContents = menu.querySelectorAll(".tab-content");

  tabLinks.forEach(btn => {
    btn.addEventListener("click", function() {
      tabLinks.forEach(b => b.classList.remove("active"));
      tabContents.forEach(c => c.classList.remove("active"));
      this.classList.add("active");
      menu.querySelector(`#${this.dataset.tab}`).classList.add("active");
    });
  });
});
</script>




@if (config('app.site') == 'CallChex')
<script>
  window.$zoho = window.$zoho || {};
  $zoho.salesiq = $zoho.salesiq || { ready: function () {} };

  window.addEventListener('scroll', function loadZohoScriptOnce() {
    if (document.getElementById('zsiqscript')) return;

    var d = document.createElement('script');
    d.type = 'text/javascript';
    d.defer = true;
    d.id = 'zsiqscript';
    d.src = 'https://salesiq.zohopublic.com/widget?wc=siqaf904c42cbd3bbf3d606ba6e1277c253baf90114e472fd2a97e740ac51c56edca2adb4fb258ba429c952700823565c4c';
    document.body.appendChild(d);

    window.removeEventListener('scroll', loadZohoScriptOnce);
  });
</script>



   <?php /* ?>
<div class="calendly-inline-widget" data-url="https://calendly.com/rohitwanchoo/new-meeting?hide_event_type_details=1&hide_gdpr_banner=1" style="min-width:320px;height:700px;"></div>
<script type="text/javascript" src="https://assets.calendly.com/assets/external/widget.js" async></script>

<?php */ ?>



@endif

@stack('scripts')


</body>


</html>
