@extends('website.layout')


@section('meta')
    <title>{{ config('app.site') }} Pricing Plans | Scalable AI Call Monitoring</title>
    <meta name="description" content="Explore {{ config('app.site') }}’s pricing tiers for B2B lead prospecting, email lookup, and data accuracy tools. Pay only for what you need.">

    <meta name="keywords" content="Leadmine pay as you go plan, Affordable AI answering service, price for AI call routing in small business">

    {{-- Open Graph --}}
    <meta property="og:title" content="{{ config('app.site') }} Pricing Plans | Scalable AI Call Monitoring">
    <meta property="og:description" content="Explore {{ config('app.site') }}’s pricing tiers for B2B lead prospecting, email lookup, and data accuracy tools. Pay only for what you need.">
    <meta property="og:image" content="{{ asset('assets/images/favicon-two.webp') }}">
    <meta property="og:type" content="website">
    <meta property="og:url" content="{{ url()->current() }}">

    {{-- Twitter / X --}}
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="{{ config('app.site') }} Pricing Plans | Scalable AI Call Monitoring">
    <meta name="twitter:description" content="Explore {{ config('app.site') }}’s pricing tiers for B2B lead prospecting, email lookup, and data accuracy tools. Pay only for what you need.">
    <meta name="twitter:image" content="{{ asset('assets/images/favicon-two.webp') }}">
@endsection



@section('content')

<style>
.custom-section-padding {
    padding: 50px 0;
}

.custom-pricing-padding {
    padding: 100px 0;
}

.heading-privacy-title {
  font-size: 32px;
  font-weight: 500;
}

.visually-hidden {
    position: absolute;
    width: 1px;
    height: 1px;
    padding: 0;
    margin: -1px;
    overflow: hidden;
    clip: rect(0, 0, 0, 0);
    white-space: nowrap;
    border: 0;
}

 .tw-mb-1{
 font-size: clamp(1.125rem, 1.2rem + 0.722vw, 1.5rem);
 }


.pricing-plan-one .col-xl-4 {
  display: flex;
}

.pricing-plan-one .position-relative {
  flex: 1;
  border-radius: 15px; 
  border: 1px solid #e5e7eb; 
  transition: all 0.3s ease;
  height: 100%;
}


.pricing-plan-one .position-relative:hover {
  transform: translateY(-6px);
  box-shadow: 0 8px 20px rgba(0, 0, 0, 0.08);
  border-color: #0d6efd; 
}


.pricing-plan-one .tw-ps-205 {
  padding-left: 1rem; 
}


@media (max-width: 767px) {
  .pricing-plan-one .position-relative {
    border-radius: 10px;
  }
}

</style>

<div id="smooth-wrapper">


 <div id="smooth-content bg-light">
  <!-- ==================== Breadcrumb Start Here ==================== -->
  <section class="section-bg-two mb-0 custom-section-padding">
    <div class="container">
      <div class="row justify-content-center">
        <div class="col-lg-8">
          <div class="text-center">
            <span class="tw-mb-4">
              <img src="{{asset('web/assets/images/favicon-two.webp')}}" alt="Favicon Two">
            </span>
            <h1 class="visually-hidden">Pricing Package</h1>
            <h3 class="mb-0 splitTextStyleOne text-capitalize heading-privacy-title">
              Pricing Package
            </h3>
          
          </div>
        </div>
      </div>
    </div>
  </section>
  <!-- ==================== Breadcrumb End Here ==================== -->

  <!-- ================== Pricing Plan one Start ====================== -->
  <section class="pricing-plan-one custom-pricing-padding mb-4">
    <div class="container">
      <div class="row gy-4">

        <!-- Pay As You Go -->
        <div class="col-xl-6 col-sm-6" data-aos="fade-up" data-aos-duration="600">
          <div class="position-relative bg-white tw-px-7 tw-py-16 hover-border-main-600">
            <div class="tw-ps-205">
              <h3 class="tw-mb-1">Pay As You Go (PAYG)</h3>
              <p class="text-neutral-500">For individuals & quick trials</p>
              <span class="d-block tw-h-px bg-neutral-200 tw-my-6"></span>
              <h3 class="tw-mb-1">$0.20 /minute</h3>
              <p class="text-neutral-600">Great to get started with the AI Voice Agent</p>
              <a href="{{ route('register') }}" class="btn btn-main hover-style-one d-flex align-items-center justify-content-center tw-gap-5 tw-px-13 tw-rounded-md tw-py-6 fw-bold mt-3">
                <span class="button__label">Get Started</span>
              </a>

              <!-- <div class="tw-mt-10">
                <h5 class="fw-semibold mb-3">Features Included</h5>
                <div class="d-flex align-items-center tw-gap-305 mb-2">
                  <i class="text-gradient-teal ph-bold ph-check"></i>
                  <span>Supports 14 languages</span>
                </div>
              </div> -->
            </div>
          </div>
        </div>
        

        <!-- Agent Lite -->
        <div class="col-xl-6 col-sm-6" data-aos="fade-up" data-aos-duration="800">
          <div class="position-relative bg-white tw-px-7 tw-py-16 hover-border-main-600">
            <div class="tw-ps-205">
              <h3 class="tw-mb-1">Agent Lite <span class="badge bg-main-50 text-main-600 ms-2">Recommended</span></h3>
              <p class="text-neutral-500">For small teams</p>
              <span class="d-block tw-h-px bg-neutral-200 tw-my-6"></span>
              <h3 class="tw-mb-1">$99 /month</h3>
              <p class="text-neutral-600">Automate simple tasks & post-call workflows</p>
              <a href="{{ route('register') }}" class="btn btn-main hover-style-one d-flex align-items-center justify-content-center tw-gap-5 tw-px-13 tw-rounded-md tw-py-6 fw-bold mt-3">
                <span class="button__label">Get Started</span>
              </a>

              <div class="tw-mt-10">
                <h5 class="fw-semibold mb-3">Everything in PAYG &</h5>
                <ul class="list-unstyled tw-gap-305">
                  <li class="d-flex align-items-center mb-2"><i class="text-gradient-teal ph-bold ph-check"></i><span class="ms-2">Collect data</span></li>
                  <li class="d-flex align-items-center mb-2"><i class="text-gradient-teal ph-bold ph-check"></i><span class="ms-2">Schedule appointments</span></li>
                  <li class="d-flex align-items-center mb-2"><i class="text-gradient-teal ph-bold ph-check"></i><span class="ms-2">Send SMS</span></li>
                  <li class="d-flex align-items-center mb-2"><i class="text-gradient-teal ph-bold ph-check"></i><span class="ms-2">Assign disposition codes</span></li>
                  <li class="d-flex align-items-center mb-2"><i class="text-gradient-teal ph-bold ph-check"></i><span class="ms-2">Transfer calls</span></li>
                  <li class="d-flex align-items-center mb-2"><i class="text-gradient-teal ph-bold ph-check"></i><span class="ms-2">1 Knowledge base per account</span></li>
                  <li class="d-flex align-items-center mb-2"><i class="text-gradient-teal ph-bold ph-check"></i><span class="ms-2">API & webhook support</span></li>
                  <li class="d-flex align-items-center mb-2"><i class="text-gradient-teal ph-bold ph-check"></i><span class="ms-2">Integration support</span></li>
                  <li class="d-flex align-items-center mb-2"><i class="text-gradient-teal ph-bold ph-check"></i><span class="ms-2">CRM logging</span></li>
                  <li class="d-flex align-items-center"><i class="text-gradient-teal ph-bold ph-check"></i><span class="ms-2">Included minutes: 600</span></li>
                </ul>
              </div>
            </div>
          </div>
        </div>

        <!-- Agent Max -->
        <!-- <div class="col-xl-4 col-sm-6" data-aos="fade-up" data-aos-duration="900">
          <div class="position-relative bg-white tw-px-7 tw-py-16 hover-border-main-600">
            <div class="tw-ps-205">
              <h3 class="tw-mb-1">Agent Max</h3>
              <p class="text-neutral-500">For power users</p>
              <span class="d-block tw-h-px bg-neutral-200 tw-my-6"></span>
              <h3 class="tw-mb-1">$249 /month</h3>
              <p class="text-neutral-600">For teams needing comprehensive automation</p>
              <a href="#" class="btn btn-main hover-style-one d-flex align-items-center justify-content-center tw-gap-5 tw-px-13 tw-rounded-md tw-py-6 fw-bold mt-3">
                <span class="button__label">Get Started</span>
              </a>

              <div class="tw-mt-10">
                <h5 class="fw-semibold mb-3">Everything in Agent Lite &</h5>
                <ul class="list-unstyled tw-gap-305">
                  <li class="d-flex align-items-center mb-2"><i class="text-gradient-teal ph-bold ph-check"></i><span class="ms-2">Multilingual support</span></li>
                  <li class="d-flex align-items-center mb-2"><i class="text-gradient-teal ph-bold ph-check"></i><span class="ms-2">5 Knowledge bases per account</span></li>
                  <li class="d-flex align-items-center mb-2"><i class="text-gradient-teal ph-bold ph-check"></i><span class="ms-2">Voice cloning</span></li>
                  <li class="d-flex align-items-center mb-2"><i class="text-gradient-teal ph-bold ph-check"></i><span class="ms-2">Custom AI actions & MCP (Coming Soon)</span></li>
                  <li class="d-flex align-items-center mb-2"><i class="text-gradient-teal ph-bold ph-check"></i><span class="ms-2">Outbound calling (Coming Soon)</span></li>
                  <li class="d-flex align-items-center"><i class="text-gradient-teal ph-bold ph-check"></i><span class="ms-2">Included minutes: 300</span></li>
                </ul>
              </div>
            </div>
          </div>
        </div> -->
      </div>

      <!-- Calendly Inline Widget -->
      <!-- <div class="calendly-inline-widget mt-5" data-url="https://calendly.com/rohitwanchoo/new-meeting?hide_event_type_details=1&hide_gdpr_banner=1" style="min-width:320px;height:700px;"></div>
      <script type="text/javascript" src="https://assets.calendly.com/assets/external/widget.js" async></script> -->
    </div>
  </section>
  <!-- ================== Pricing Plan one End ====================== -->
</div>




@endsection