@extends('website.layout')

@section('meta')
    <title>Privacy Policy | {{ config('app.site') }} – Data Protection & Security</title>
    <meta name="description" content="Read {{ config('app.site') }}’s privacy policy to learn how we collect, use, and protect your data while ensuring secure, transparent call quality solutions.">
    <meta name="keywords" content="{{ config('app.site') }} privacy policy">

    {{-- Open Graph --}}
    <meta property="og:title" content="Privacy Policy | {{ config('app.site') }} – Data Protection & Security">
    <meta property="og:description" content="Read {{ config('app.site') }}’s privacy policy to learn how we collect, use, and protect your data while ensuring secure, transparent call quality solutions.">
    <meta property="og:image" content="{{ asset('assets/images/logo/favicon-two.png') }}">
    <meta property="og:type" content="website">
    <meta property="og:url" content="{{ url()->current() }}">

    {{-- Twitter / X --}}
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Privacy Policy | {{ config('app.site') }} – Data Protection & Security">
    <meta name="twitter:description" content="Read {{ config('app.site') }}’s privacy policy to learn how we collect, use, and protect your data while ensuring secure, transparent call quality solutions.">
    <meta name="twitter:image" content="{{ asset('assets/images/logo/favicon-two.png') }}">
@endsection


@section('content')

<style>
.custom-heading {
  font-weight: 400;  
  font-size: clamp(1.125rem, 1.2rem + 0.722vw, 1.5rem)
}

.img-height-60 {
  height: 60px;
}

.heading-privacy {
  font-size: 32px;
  font-weight: 500;
}

.sticky-offset-20 {
  top: 20px;
}

.text-align-start {
  text-align: start;
}

.visually-hidden {
    position: absolute;
    width: 1px;
    height: 1px;
    padding: 0;
    margin: -1px;
    overflow: hidden;
    clip: rect(0, 0, 0, 0);
    white-space: nowrap;
    border: 0;
}
.as-h2 {
 font-size:1.5rem;
 }

 .table{
      font-size: clamp(1.125rem, 1.2rem + 0.722vw, 1.5rem);
 }

 .semi-bold {
  font-weight: 600;
}
.fs-24 {
  font-size: 24px;
}


.tab-pane ul {
  list-style-type: disc !important;
  margin-left: 20px !important;
}

.as-h3{
    font-size:1.1rem; 
    font-weight:600;
}


.custom-table-responsive {
    overflow-x: auto;
    max-width: 100%;
}


.custom-cookie-table {
    table-layout: auto;
    word-wrap: break-word;
}


.col-30 {
    width: 30%;
}
.col-70 {
    width: 70%;
}

.cookie-purpose-text {
    vertical-align: top;
    padding: 12px;
    text-align: start;
}

</style>



<div id="smooth-content">
    <!-- Header Section -->
    <section class="section-bg-two mb-0 py-5">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-10 text-center">
                    <div class="mb-4">
                        <img src="web/assets/images/favicon-two.png" alt="Privacy Policy"class="img-fluid img-height-60">
                    </div>
                    <!-- <h3 class="display-5 mb-3">Privacy Policy</h3> -->
                         <h1 class="visually-hidden">Privacy Policy</h1>
                    <h3 class="mb-0 splitTextStyleOne text-capitalize heading-privacy"> Privacy Policy</h3>
                    <p class="lead text-muted">Last updated: 6 November 2025</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Privacy Policy Content -->
    <section class="py-5">
        <div class="container">
            <div class="row g-5">
                <!-- Sidebar Navigation -->
  <div class="col-lg-4">
    <div class="card shadow-sm border-0 sticky-top sticky-offset-20">
        <div class="card-body p-4">
            <h2 class="mb-4 table">Legal</h2>
            <div class="nav flex-column nav-pills" id="legal-tab" role="tablist" aria-orientation="vertical">
                <button class="nav-link text-start mb-2 active" id="terms-tab" data-bs-toggle="pill" data-bs-target="#terms">
                    Terms and Conditions
                </button>
                <button class="nav-link text-start mb-2" id="fair-usage-tab" data-bs-toggle="pill" data-bs-target="#fair-usage">
                    Fair Usage Policy
                </button>
                <button class="nav-link text-start mb-2" id="privacy-tab" data-bs-toggle="pill" data-bs-target="#privacy">
                    Privacy Policy
                </button>
                <button class="nav-link text-start mb-2" id="partner-program-tab" data-bs-toggle="pill" data-bs-target="#partner-program">
                    Integration Partner Program Agreement
                </button>
                <button class="nav-link text-start mb-2" id="applicant-privacy-tab" data-bs-toggle="pill" data-bs-target="#applicant-privacy">
                    Applicant Privacy Notice
                </button>
                <button class="nav-link text-start mb-2" id="cookie-tab" data-bs-toggle="pill" data-bs-target="#cookie">
                    Cookie Notice
                </button>
                <button class="nav-link text-start mb-2" id="refund-tab" data-bs-toggle="pill" data-bs-target="#refund">
                    Refund Policy
                </button>
                <button class="nav-link text-start mb-2" id="disclosure-tab" data-bs-toggle="pill" data-bs-target="#disclosure">
                    Responsible Disclosure Policy
                </button>
                <button class="nav-link text-start mb-2" id="gdpr-tab" data-bs-toggle="pill" data-bs-target="#gdpr">
                    GDPR Compliance
                </button>
                <button class="nav-link text-start mb-2" id="referral-tab" data-bs-toggle="pill" data-bs-target="#referral">
                    Leadmine Referral Program Terms
                </button>
            </div>
        </div>
    </div>
</div>


                <!-- Main Content -->
                <div class="col-lg-8">
                    <div class="card shadow-sm border-0">
                        <div class="card-body p-5">
                            <div class="tab-content" id="privacy-tabContent">
                                <!-- Summary of Key Points -->
                                <div class="tab-pane fade show active" id="terms" role="tabpanel"
                                    aria-labelledby="summary-tab">
                                   <!-- Terms and Conditions (inner content for tab) -->

<p class="semi-bold fs-24">Terms and Conditions</p>
<p><strong>Last Updated on:</strong> 6 November 2025 </p>

<p>These Terms and Conditions are effective on 6 November 2025 if you created your account or accepted or otherwise agreed to them on or after 6 November 2025.</p>

<p>Please click here to view the previous version of the Terms and Conditions. The previous version of the Terms and Conditions is applicable in case you have created your account prior to 06 november 2025 and continue to be on an old Plan.</p>

<p>This online terms and conditions (“Terms and Conditions”), by and between the Customer, as defined under these Terms and Conditions, and SaaS Labs US, Inc., a Delaware corporation with principal office at 355 Bryant Street, #403 San Francisco CA 94107, United States of America ("Leadmine.pro”), together with any and all applicable Order Form(s), purchase orders, schedules, exhibits (collectively, the “Agreement”) constitute a legal and binding agreement between Leadmine.pro and the Customer and set forth the terms pursuant to which the Customer may access and/or use the Site and Services, as defined. Leadmine.pro and Customer may be individually referred to as a “Party”, and collectively as “Parties”.</p>

<p>By clicking on the “Accept” button or checking the checkbox on the signup page when subscribing to the Services, entering into an Order Form or otherwise using and/or permitting any User to access and/or use any of the Services or accessing the Site, Customer: (i) affirms that it has read, agreed and will comply with this Agreement; (ii) affirms that the representative of the Customer is at least eighteen (18) years of age and has the required authority to enter into this Agreement on behalf of the Customer, and to bind the Customer to these Terms and Conditions.</p>

<p>Please note that access to a Leadmine.pro Account is subject to the successful completion of our internal verification process of the Customer, which must be passed before any use of the Service is permitted.</p>

<p><strong>IF YOU DO NOT AGREE TO THESE TERMS AND CONDITIONS, YOU MUST NOT CLICK ACCEPT OR THE CHECKBOX ON THE SIGNUP PAGE OR SIGN THE ORDER FORM, USE ANY OF THE SERVICES, OR ACCESS THE SITE.</strong></p>

<p class="semi-bold fs-24">1. Definitions</p>
<p>“Administrator” means the individual(s) who have been granted the right by Customer to set up the account, have access to control settings, and have greater control over the permissions;</p>
<p>“Affiliate” means any entity that directly or indirectly controls, is controlled by, or is under common control with the subject entity;</p>
<p>"Applicable Law” means any and all law, statute, regulation, rule, ordinance, treaty convention, and/or court or administrative order or ruling of any governing body with jurisdiction over the Service, the Customer, and/or the Customer's use of the Services;</p>
<p>“Authorized User” means individual(s) who are employees, contractors, or agents of the Customer, and have been given access to the Leadmine.pro Account.</p>
<p>“Confidential Information” shall include but is not limited to any and all information, data, ideas, marketing information, marketing methods, customer lists, financial information, and business strategies in any and all forms, formats, and mediums, in writing orally or through other means, whether identified as confidential or not that arises from or relates to a Party, its business, business plans, procedures, finances, owners, officers, employees or agents. A Party’s Confidential Information shall not include information that (a) is or becomes a part of the public through no act or omission of the other Party; (b) was rightfully in the possession of the other Party or was known by it prior to its disclosure; (c) is independently developed by the Receiving Party without the use of any Confidential Information of the other Party; (d) was or is provided by the Disclosing Party to third parties without restriction on disclosure, and (e) is required to be disclosed by law or by request of any government or regulatory authority.</p>
<p>“Customer” means, in the case of an individual accepting this Agreement on behalf of a company or other legal entity, the company or other legal entity on behalf of which such individual is accepting this Agreement or the entity indicated in the Order Form.</p>
<p>“Customer Data” means any data, content, or materials that the Customer, Administrator(s) and Authorized User(s) uploads into, enters into, or submits to the Service including from Third-Party Integrations. For clarification, Customer Data excludes Usage Data.</p>
<p>"Documentation" means Leadmine.pro's user manuals, handbooks, help articles and guides relating to the Site or Service provided by Leadmine.pro to Customer either electronically or in hard copy form.</p>
<p>“Effective Date” means the date on which the Customer subscribes to the Service or the date mentioned in the Order Form;</p>
<p>“Feedback” means any suggestions or idea for modifying the Service or a portion of the Service including without limited to intellectual property rights in any such suggestions or idea;</p>
<p>“Leadmine.pro Account” means the account established by Leadmine.pro and associated with the Customer pursuant to entering this Agreement, or an Order Form.</p>
<p>“Leadmine.pro Number” means the phone number allotted to the Customer;</p>
<p>“Order Form” means the ordering document from Leadmine.pro detailing the Service to be provided to the Customer;</p>
<p>“Plan” means any of the subscription plans made available to the Customer that the Customer may select either via the Leadmine.pro Account or the Site, or by executing an Order Form including Leadmine.pro Numbers, as applicable. The subscription plans can be accessed here.</p>
<p>“Service” means any and all services made available to Customer by Leadmine.pro from time to time under this Agreement.</p>
<p>“Site” is defined as the website www.leadmine.pro (or any other domain used by Leadmine.pro).</p>
<p>“Usage Data” means the data regarding applications utilized with the Service, configurations, log data, and the performance results for the Service.</p>
<p>"Third-Party Products" means any products, content, services, information, websites, Integrations, or other materials that are owned by third parties and are incorporated into or accessible through the Service.</p>

<p class="semi-bold fs-24">2. Services Offered</p>
<p>2.1 Leadmine.pro provides online-based phone solutions and services that include the ability to make, receive, forward voice calls, record and transcribe such calls, and send and receive messages, in each case to/from Leadmine.pro Number to/from a telephone number in accordance with the Plan chosen by the Customer. Leadmine.pro can integrate with various Third-Party Products that are not affiliated with Leadmine.pro. A non-exhaustive description of Leadmine.pro and the Services provided is available on the Site.</p>

<p>2.2 Leadmine.pro is not a 'dial-tone' provider and is not a replacement for any phone lines, whether wired, wireless, or Internet-based. The Service allows you to place outbound calls and messages, national and international; however, selected numbers and services may not be reachable through the Service and Leadmine.pro cannot guarantee that all numbers available worldwide can be called or messaged from the Service and Leadmine.pro Number.</p>

<p>2.3 Leadmine.pro does not support any emergency calls to any type of hospitals, law enforcement agencies, medical care units, or any type of emergency services of any kind, that need to be performed from the Customers' local phone service provider. It is the Customers' responsibility to inform the Authorized Users that it is not possible to support or carry emergency calls using the Service.</p>

<p class="semi-bold fs-24">3. Quality and Maintenance</p>
<p>3.1 Minimum Disruptions. Leadmine.pro shall use reasonable endeavours to provide the Service with minimum disruptions. Leadmine.pro cannot guarantee that the Service will always function without any disruptions, interruptions or delays. Since the Service will be transmitted through public internet lines and the public switched telephone network, there may be power outages or internet service disruptions and the Customer may experience some disruptions that can interfere with quality service. Leadmine.pro does not warrant full availability of any type.</p>

<p>3.2 Support Services. Leadmine.pro will provide standard support services to resolve technical issues with, and answers queries regarding the use of the Service for purchased Service Customers at no additional cost.</p>

<p>3.3 Upgrades. Leadmine.pro may change technical features in order to keep pace with the latest demands and technological developments or to comply with any Applicable Laws without obtaining the Customer’s written pre-approval. Leadmine.pro may also have to repair, improve, and/or upgrade, provide patches, enhancements, or fixes for the Service and this may require Leadmine.pro to restrict, limit, suspend, interfere and/or interrupt the Service at any time in its sole discretion including in the event of an emergency. Leadmine.pro shall endeavor to provide the Customer with advance notice where practicable and carry out such maintenance, where possible, outside of regular business hours.</p>

<p>3.4 Login Details. The Customer acknowledges and agrees that the Customer's Authorized Users' access to the Service is protected by an identification system that requires each User to choose a unique password and username (“Login Details”). It is the responsibility of the Customer and the Authorized User to maintain the confidentiality of the Login Details, and not disclose or share the Login Details with any third party, and that the Login Details are kept private and confidential. Any use of such Login Detail shall therefore be deemed to be made by the Customer and/or its Authorized Users. The Customer and/or its Authorized User is responsible for immediately notifying Leadmine.pro of any Authorized use of the Leadmine.pro Account, or breach of the account's login details to take all necessary steps to prevent or terminate the fraudulent use of the Leadmine.pro account and/or the Service. Leadmine.pro shall not be liable for any loss that the customer may incur as a result of unauthorized use of the Login Details with or without your knowledge.</p>

<p>3.5 Enforcing Security. Actual or attempted unauthorized use of any of the Site or the Service may result in criminal and/or civil prosecution by the appropriate legal and judicial authorities. Leadmine.pro reserves the right to view, monitor, and record activity on the Site and the Service without notice to the fullest extent permitted by applicable law. This right extends to our review of message content, call recordings and details pertaining to claimed violations of our AUP as described herein. Any information obtained by monitoring, reviewing, or recording is subject to review by law enforcement organizations in accordance with our Privacy Policy.</p>

<p class="semi-bold fs-24">4. Intellectual Property and License</p>
<p>4.1 Limited License. Subject to the terms of this Agreement, and the Customer's, Administrator(s) and Authorised User(s) continued and full compliance with the terms of this Agreement, Leadmine.pro grants to Customer, Administrator(s), and Authorized User(s), during the Term, a limited, revocable, nonexclusive, non-transferable right to access and use the Service and the Site solely for its internal business purposes.</p>

<p>4.2 Restrictions. The Customer shall not and cause its Administrator(s) and/or Authorized User(s) to refrain from any unauthorized use, directly or indirectly, including but not limited to:</p>
<ul>
  <li>(a) sublicense, sell, rent, lease, transfer, assign, distribute, or otherwise commercially exploit or make the Service, or any part thereof available to any third party other than Administrator(s) and/or Authorized Users;</li>
  <li>(b) modify, reverse engineer, decompile or disassemble, make derivative works of the Service or any part thereof, and shall not build a similar or competitive product or service;</li>
  <li>(c) permit other third parties to use the Service, including but not limited to shared use via a network connection except under the terms of this Agreement;</li>
  <li>(d) rent, lease, loan, sublicense, distribute or otherwise transfer rights to the Service, or any part thereof available to any third party other than Authorized Users;</li>
  <li>(e) circumvent or disable any technological features or measures in the Service;</li>
  <li>(f) attempt to, or in conjunction with any device, program, or service designed to circumvent technological measures employed to control access to, or the rights in a content file or other work protected by copyright law in any jurisdiction;</li>
  <li>(g) use the Site, Service, or Documentation in any manner or for any purpose that infringes, misappropriates, or otherwise violates any intellectual property right or other right of any person, or that violates any applicable law, regulation, or rule.</li>
</ul>

<p>Leadmine.pro reserves its right to suspend or terminate the license to the Service in the event the Customer and/or Administrator(s) and/or Authorized User(s) is found using the Leadmine.pro Account in violation of Clause 4.2 (Restrictions).</p>

<p>4.3 Leadmine.pro ownership. Customer agrees that Leadmine.pro owns all rights, titles and interests in and to all Intellectual Property rights in the Service, the Site, the Documentation, as well as any content herein, except as otherwise stated (“Leadmine.pro Intellectual Property”). All rights not expressly granted to the Customer are reserved by Leadmine.pro. Leadmine.pro owns the Usage Data derived from the operation of the Service. Nothing contained herein shall prevent Leadmine.pro from utilising the Usage Data for purposes of providing and maintaining, delivering, and/or improving the Service provided that any data so used shall be de-identified and presented in the aggregate so that it will not disclose the identity of Customer to any third party. Leadmine.pro reserves all rights not expressly granted to Customer in this Agreement. Except for the limited rights and licenses expressly granted under this Agreement, nothing in this Agreement grants, by implication, waiver, estoppel, or otherwise, to Customer or any third party, any intellectual property rights or other right, title, or interest in or to the Leadmine.pro Intellectual Property.</p>

<p>4.4 Customer data. Leadmine.pro agrees, as between the Parties, the Customer retains all rights, titles, and interests in and to all Intellectual Property rights in the Customer Data. Customer acknowledges that Leadmine.pro is not responsible for the creation, content, or use of the Customer Data by Customer or any third party. Customer grants Leadmine.pro, its affiliates, and applicable contractors a limited-term license to host, copy, use, transmit, store and display any product integration for the Customer using the Service and the Customer Data as appropriate to provide and ensure proper operation of the Service and associated systems in accordance with the Agreement. If the Customer chooses to use a Third-Party Product with the Service, then the Customer allows the Third-Party Product to access Customer Data as appropriate. Use of any such Third-Party Product are subject to the terms and conditions such Third-Party Product, and Customer warrants that Customer has agreed to such terms independently from their use of Leadmine.pro Site and Service. Customer warrants that it owns or has acquired the necessary licenses to grant Leadmine.pro the above license to use Customer Data.</p>

<p>4.5 Use of Trademarks. The Customer grants Leadmine.pro the right to use and reproduce the Customer's name, logo and trademark to identify Customer as a Leadmine.pro customer on the Site and other marketing materials. In the event, the Customer does not agree with the use of the Customer's name, logo and /or trademark to identify the Customer as a Leadmine.pro customer or that the use of Customer's name, logo and/or trademark is not in line with the Customer's branding or similar guidelines, the Customer shall notify Leadmine.pro at the email address sales@leadmine.pro</p>

<p>4.6 Feedback. All Feedback given by the Customer to Leadmine.pro shall be used without restriction or obligation. All Feedback is provided “as is” and Leadmine.pro will not publicly identify the Customer as the source of Feedback without the Customer’s permission. The Customer has agreed to not treat any Feedback given to Leadmine.pro as Customer's Confidential Information, Intellectual Property or its trade secret, and nothing in this Agreement or in the Parties’ dealings arising out of or related to this Agreement will restrict Leadmine.pro's right to use, profit from, disclose, publish, keep secret or otherwise exploit Feedback, without compensating or crediting the Customer.</p>

<p>4.7 Third-Party Information. Leadmine.pro may disclose, distribute, reference or communicate third-party Information in connection with the Service. Leadmine.pro is not responsible for and does not endorse, sponsor, or review this third-party Information and hereby disclaims all liability for the same.</p>

<p>4.8 Documentation License. Subject to the terms and conditions contained in this Agreement, Leadmine.pro hereby grants the Customer a non-exclusive, non-sublicensable, non-transferable license for Administrator(s) and Authorized User(s) to use the Documentation during the Term solely for your internal business purposes in connection with use of the Site and Service.</p>

<p>4.9 Downloadable Software. Use of the Site and Services may require or include use of downloadable software. Leadmine.pro grants the Customer a non-transferable, non-exclusive, non-assignable, limited right for Administrator(s) and/or Authorized User(s) to use downloadable software we provide as part of the Site and Services in accordance with the End User License Agreement that accompanies such downloadable software. Any Third-Party Products that consist of downloadable software are subject to the terms of such Third-Party Product.</p>

<p class="semi-bold fs-24">5. Acceptable Use Policy and Privacy Policy</p>
<p>5.1 Restricted Activities. The Customer and/or Administrator(s) and/or Authorized User(s) are responsible for any use of Leadmine.pro. Any and all access and use of the Service must be in compliance with the following Acceptable Use Policy (“AUP”). Customer must not and cause its Administrator(s) and/or Authorized Users not to use Leadmine.pro to:</p>
<ul>
  <li>(a) violate any laws, regulations, governmental orders, industry standards, or published policy, or any applicable third-party policy including upstream provider's acceptable use policies, industry code of conduct, or requirement communicated or otherwise made available by Leadmine.pro, telecommunications providers’ requirements or guidance in any applicable jurisdiction including that require (i) consent to be obtained prior to transmitting, recording, collecting or monitoring data or communications or (ii) compliance with opt-out requests for any data or communications;</li>
  <li>(b) violate or infringe on Intellectual Property, privacy or rights of another;</li>
  <li>(c) to transmit or store any content or communications (commercial or otherwise) that is illegal, harmful, unwanted, inappropriate, or objectionable in the recipient's jurisdiction including content or communication which Leadmine.pro determines (i) is false or inaccurate; (ii) is hateful or encourages hatred or violence against individuals or groups; (iii) could endanger public safety, or (iv) the sale or promotion of prohibited substances, prescription medicines or prohibited goods;</li>
  <li>(d) to transmit or store any content or communications that is sexually explicit, pornographic, obscene, or other content which is objectionable in Leadmine.pro's sole discretion;</li>
  <li>(e) to sell, trade, resell or otherwise exploit Leadmine.pro account for any unauthorized commercial purpose;</li>
  <li>(f) stalk, harass, harm another individual or impersonate another individual, misrepresent or falsely identify, engage in spamming, phishing or pharming;</li>
  <li>(g) to engage in fraudulent activity with respect to third parties or otherwise using the Leadmine.pro Account to bypass phone identification systems;</li>
  <li>(h) to engage in spamming or other unsolicited advertising, marketing or other activities in connection with any unsolicited or harassing messages (commercial or otherwise) including but not limited to unsolicited or unwanted phone calls or text messages;</li>
  <li>(i) to engage in unauthorized commercial activities and/or sales and unsolicited marketing or other activities that violate anti-spam laws and regulations including CAN-SPAM Act of 2003, the Telecom Consumer Protection Act of 1991 (“TCPA”) Rules, Do-Not-Call Implementation Act or any other similar or analogous anti-spam, data protection or privacy related legislations in other jurisdictions;</li>
  <li>(j) to use any robot, spider, another automatic device, or manual process to monitor, copy or 'scrape' web pages or the content contained in the website or for any other unauthorized purpose without our prior written consent;</li>
  <li>(k) using any device, software, or routine to interfere or attempt to interfere with the proper working of the Service;</li>
  <li>(l) to decompile, reverse engineer, or disassemble the software or attempting to do so;</li>
  <li>(m) perform automated communications or engage in abusive practices including enabling robocalls, bulk call-in lines, auto-dialing, 'predictive' dialing, or bulk messages in violation of any Applicable Laws including but not limited to TCPA;</li>
  <li>(n) send messages relating to (i) high-risk financial services, including but not limited to payday loans, short term high-interest loans, third-party loans (third party means originating from any party other than the one which will service the loan), student loans, cryptocurrency; (ii) third-party lead generation services that buy, sell or share customer information; (iii) debt collection or forgiveness including but not limited to third-party (i.e., originating from any party other than the one who is owed the debt) debt collection, debt consolidation, debt reduction, credit repair programs; (iv) ‘Get rich quick’ scheme including but not limited to deceptive work from home programs, risk investment opportunities, pyramid schemes; (v) sale, promotion or offering for sale cannabis, CBD or vape products, regardless of whether the messages explicitly contain cannabis terms, images or links to cannabis websites; (vi) sale, promotion or offering for sale prescription drugs; (vii) sale or promotion of gambling including but not limited to casino apps and gambling websites; (viii) sale or promotion or offering for sale firearms or explosives;</li>
  <li>(o) send any communications on behalf of, or purporting to originate on behalf of Leadmine.pro;</li>
  <li>(p) trunk or forward Customer's Leadmine.pro Number to another phone number capable of handling multiple simultaneous calls or text messages;</li>
  <li>(q) violate any term of the Fair Usage Policy.</li>
</ul>

<p>5.2 Privacy Policy. Leadmine.pro complies with its privacy policy, available at privacy-policy/ ("Privacy Policy"), in providing the Site and Service. The Privacy Policy is subject to change as described therein. By accessing, using, and providing information to or through the Site and Service, you acknowledge that you have reviewed and accepted our Privacy Policy, and you consent to all actions taken by us with respect to your information in compliance with the then-current version of our Privacy Policy.</p>

<p>5.3 Messaging and Call Recording Compliances. Notwithstanding anything set forth in this Agreement, and in addition thereto, Customer's use of the messaging feature of the Service, must comply with all consent/opt-in requirements, ongoing consent requirements, opt-out/unsubscribe requirements, and correct identification of sender requirements as mentioned in any and all local laws, regulations, and third-party policies. Further, notwithstanding anything set forth in this Agreement and in addition thereto, Customer's use of the call recording functionality must comply with any and all local laws and regulations including local notice requirements. Further, the Customer shall process any do not call or do not text requests in accordance with the local laws, regulations and third-party policies.</p>

<p>5.4 Breach of AUP. In the event, the Customer breaches any of the terms of the AUP, Leadmine.pro may immediately suspend or terminate all or part of the access of the Service and/or the Agreement and report and share relevant information of any activities deemed illegal or against applicable laws and regulations to the appropriate authorities in accordance with applicable data privacy laws and regulations. In addition to the restrictions mentioned in the AUP, Leadmine.pro reserves the right to impose limits on the Customer's and its Authorized Users' usage of the Service. The Customer acknowledges that Leadmine.pro may, but is not required to, pre-screen any messaging content but Leadmine.pro shall have the right, in their sole discretion, to pre-screen and/or refuse the transmission of any messaging content that violates the AUP and this Agreement.</p>

<p class="semi-bold fs-24">6. Leadmine.pro Phone Numbers</p>
<p>6.1 Allocating Leadmine.pro Numbers. As part of the Service, Leadmine.pro may make available Leadmine.pro Numbers to Customer in multiple countries. Customer acknowledges that the provision of Leadmine.pro Numbers is subject to applicable numbering rules and regulatory practices applicable in the countries where Customer, Administrator(s) and/or Authorized Users are located and the relevant countries from where the Leadmine.pro Number was purchased and these may change or be amended from time to time. Leadmine.pro reserves the right to change the terms related to Leadmine.pro Numbers accordingly, including but not limited to imposing or amending local residency requirements and/or requiring additional user information for continued access to the selected Leadmine.pro Numbers. The Customer can purchase and allocate Leadmine.pro Numbers to their Leadmine.pro Account subject to allocation requirements displayed upon subscription to the Leadmine.pro Numbers. The Customer cannot assign, transfer, rent, or sell any Leadmine.pro Numbers.</p>

<p>6.2 Fixed Cost of Leadmine.pro Numbers. The cost of Leadmine.pro Numbers vary from country to country. Only upon the confirmation of the Customer shall Leadmine.pro procure a Leadmine.pro Number. Once the Leadmine.pro Number is procured, the Customer's Leadmine.pro Account will be charged the fixed cost for the Leadmine.pro Number.</p>

<p>6.3 Suspension of Leadmine.pro Numbers. The Customer is responsible for compliance with any and all Applicable Law and the terms of this Agreement including such applicable allocation requirements. The Customer is responsible for notifying the Administrator(s) and/or Authorized User(s) about the compliance with any and all Applicable Law and the terms of this Agreement. Leadmine.pro reserves the right to suspend or cancel the allocated Leadmine.pro Number in the event of any breach of any Applicable Law and/or the terms of this Agreement without penalty and without prejudice to its rights to claim damages therefore. In addition, Customer shall remain liable for any Fixed Fees incurred as a result of such suspended or cancelled Leadmine.pro Number(s) and may be held liable for the use of the suspended or cancelled Leadmine.pro Number(s) not in compliance with Applicable Laws, and/or the terms of this Agreement.</p>

<p>6.4 Portability. Leadmine.pro provides, at the Customer's written request, provisions for porting in a number or porting out a Leadmine.pro Number according to Applicable Laws and the applicable technical and geographical eligibility conditions. To import a number into the Leadmine.pro Account, the Customer must follow all the steps indicated by Leadmine.pro from time to time and provide all information requested by Leadmine.pro, which must be correct and complete. Leadmine.pro may charge a one-time fix fee for each phone number ported into the Customer's Leadmine.pro Account depending on the type and region of the phone number. If the Customer wishes to export the Leadmine.pro number to another provider, the Customer must have subscribed to a paid plan of the Service. Further, while Leadmine.pro does not charge a one-time fee for exporting a Leadmine.pro Number to another provider, it is the responsibility of the Customer to inquire from their provider about any fees for portability.</p>

<p class="semi-bold fs-24">7. Pricing, Billing and Refund Policy</p>
<p>7.1 Free Trial. Customer may elect to try the Service at no cost (except for any Usage Fees beyond USD 2) for trial period of not more than 14 days, from the Effective Date or such additional trial period as Leadmine.pro may grant Customer on a case-by-case basis in its sole discretion (“Free Trial”). Leadmine.pro reserves the right, at any time, to add any restrictions or limitations to the Free Trial without prior notice to the Customer. Customer may request a current list of restrictions and limitations for Free Trial. Leadmine.pro offers no warranty, or indemnity for Free Trials, and its liability for Free Trials will not exceed USD 100.</p>

<p>7.2 Fixed Fees. Customer may select a Plan on a monthly basis or annual basis either from their Leadmine.pro Account or by entering into an Order Form. The fees to be paid by the Customer that are associated with the Plan selected by the Customer are indicated on the Site (“Fixed Fees”). Any fees associated with Leadmine.pro Numbers, Additional Leadmine.pro Numbers and/or Additional Licenses, any add-on features, any one time fees such as porting fees, or any other charge(s) relating to calling and messaging, shall be deemed Fixed Fees. For clarity, using Leadmine.pro will not incur charges to the Customer's personal voice plan unless calls are redirected to a mobile located in a foreign country. In that case, the operator will charge its standard rates for roaming on inbound calls. Further, if the Customer uses the Service from a device using mobile data connection, then the inbound and outbound calls will use a part of the data allowance as per the personal data plan. Additional Licenses and/or Additional Leadmine.pro Numbers will be invoiced at the same Billing Frequency of either (a) Licenses and/or Leadmine.pro Numbers purchased in the original Plan or (b) the Billing Frequency as mentioned in the Order Form. Such Additional Licenses and Additional Leadmine.pro Numbers shall be invoiced in arrears, on a pro-rata basis, and thereafter, shall be invoiced in advance. Customer may, at any time, remove such User License and/or Leadmine.pro Number, in which case the User License(s) and/or Leadmine.pro Number(s) will be removed from the Customer’s Leadmine.pro Account and not charged upon the next billing cycle. No refund will be given for any removal of a User License and/or Leadmine.pro Number during the ongoing billing cycle.</p>

<p>7.3 Usage Fees. Any fees associated with inbound and outbound calling, and inbound and outbound messaging are not included in the Fixed Fees, and such fees collectively are “Usage Fees”:</p>
<ul>
  <li>(a) Calling Rates. Airtime and other measured usage (“Chargeable Time”) is billed in full-minute increments, and actual airtime and usage are rounded up to the next full-minute increment at the end of each call for billing purposes. Chargeable Time begins for outbound calls when a connection to the number the Customer is trying to reach is established and recorded in Leadmine.pro's systems, and for inbound calls when a signal connection from the caller is established with our facilities. Chargeable Time ends after the call has ended either by the Customer or the person the Customer was speaking with or due to a technical malfunction but not until the call disconnect is recorded in the Leadmine.pro system. For the avoidance of doubt, all outbound calls for which Leadmine.pro receives answer supervision including ring time, shall incur a minimum of one (1) minute of Chargeable Time. Answer supervision can be generated by voicemail systems, private branch exchanges, and interexchange switching equipment; Chargeable Time may include time for Leadmine.pro to recognize that one party has disconnected from the call, time to clear the channels in use, and ring time. Chargeable Time also includes other uses of our facilities including voicemail deposits, retrievals, and call transfers.</li>
  <li>(b) Messaging Rates. Messaging rates are on the basis of per-segment and is rounded up to the next segment increment at the end of each message for billing purposes. One segment equals 160 characters. For example, if the Customer sends 200 characters long message, the Customer will be charged for two segments.</li>
  <li>(c) Credits. The Customer will be required to purchase credits in advance which will be applied toward Usage Fees (“Credits”) and the Customer acknowledges that the Customer will not be billed for Usage Fees in arrears. Credits may not be applied toward Fixed Fees or any other fees. Upon termination of this Agreement for any reason, all unused Credits shall expire in their entirety on the termination date and there shall be no refund of any unused Credits.</li>
</ul>

<p>For the avoidance of doubt, Leadmine.pro may change the Calling Rates and Messaging Rates at any time and will endeavor, but is not required to, to provide notice of such change prior to its implementation. Customers may request the Calling Rates and Messaging Rates currently applicable by sending a request to sales@leadmine.pro. Further, Customers with Included Minutes and Messages feature and Unlimited Inbound Calling feature is subject to Fair Usage Policy which is hereby incorporated by reference into these Terms and Conditions.</p>

<p>7.4 Payment. By providing valid credit or debit card information and/or bank account information ('Payment Method'), the Customer expressly (a) authorizes Leadmine.pro and/or any other company acting as a billing agent for Leadmine.pro to (a) charge the Payment Method for fees corresponding to Fixed Fees at the billing frequency chosen by Customer either while selecting the Plan from the Site or as specified in the relevant Order Form; and (b) for any and all other fees in connection with the Service including purchasing Credits and to continue attempting to charge and/or place holds on such Customer's Payment Method until such amounts are paid in full. The Customer expressly agrees to provide Leadmine.pro with updated Payment Method information upon Leadmine.pro's request and any time the information previously provided is no longer valid. The Customer is solely responsible for maintaining and updating the Payment Method information. Customer shall be solely responsible for the consequences of any expired or incomplete Payment Method information and insufficient funds to pay invoices including charges incurred as a result of such attempts to charge. Unless otherwise stated on the invoice or the Order Form, payment is due in full in advance upon receipt of the invoice. If the Plan selected by the Customer includes a predetermined allotment of services (for example, a promotional addition of Credits for no extra cost), unless otherwise specifically provided as a part of such Plan, any unused allotment of such services from one billing cycle will not carry over to any future billing cycle. The Customer agrees that it shall be responsible for any and all fees, if any, associated with payment of invoices to Leadmine.pro. Leadmine.pro may bill the Customer in a format as Leadmine.pro determines from time to time. Leadmine.pro uses Stripe in the event the Payment Method is a credit or debit card, and the terms can be found here.</p>

<p>7.5 Acceleration and Late Fees. If any charge or fees owed by the Customer under this Agreement is thirty (30) days or more overdue, Leadmine.pro may, without limiting its other rights and remedies, accelerate the Customer's unpaid fee obligations under the Agreement so that all such obligations become immediately due and payable. In addition, the Customer acknowledges and agrees that for any amount(s) that are not paid by the due date, Leadmine.pro may charge a late payment fee equal to 1.5% of the Customer’s outstanding balance per month, or the maximum rate permitted by law, whichever is highest. Leadmine.pro shall be entitled to charge the Customer all costs or fees associated with recovering the outstanding amounts due under the Agreement.</p>

<p>7.6 Taxes. Unless otherwise stated, the pricing does not include taxes, levies, duties, or assessments including value-added, sales, use or withholding taxes assessable by any local, state, or provincial authorities (“Taxes”). The Customer is responsible for paying all applicable Taxes associated with the purchases hereunder.</p>

<p>7.7 Refunds. The Customer is billed in advance on a monthly or annual basis and is non-refundable. There will be no refunds or credits for partial months of non-use of Service, upgrade or downgrade of Plans refund, and decreasing the User License(s) and/or Leadmine.pro Number(s) during a billing cycle. All refund-related requests will be governed by our Refund Policy.</p>

<p class="semi-bold fs-24">8. Protection of Data</p>
<p>Leadmine.pro will take commercially reasonable administrative, physical, and technical safeguards for the protection of the security, confidentiality, and integrity of Customer’s Data, complying in any case with Applicable Laws and regulations as well as any data processing agreement or addendum as concluded between the Parties. Leadmine.pro shall use reasonable efforts to ensure ongoing compliance with Applicable Laws and regulations and ensure the maintenance of a state-of-the-art security infrastructure.</p>

<p>To the extent that Leadmine.pro processes any personal data (as defined by Applicable Law), such personal data is processed in accordance with the terms of a Data Processing Agreement, which is available upon request and required for Customers who process the Personal Data of individuals located in the European Union, United Kingdom, and certain States of the United States, as may be entered into between the Parties.</p>

<p class="semi-bold fs-24">9. Confidentiality</p>
<p>9.1 Obligation of Confidentiality. Each Party ('Receiving Party') shall not, without the other Party's ('Disclosing Party') prior written consent, disclose or permit the disclosure of any Confidential Information provided by the Disclosing Party to the Receiving Party under or in connection with this Agreement, except that the Confidential Information may be disclosed to the Receiving Party's employees, Affiliates, subcontractors or professional advisors to the extent necessary to carry out its duties and obligations under this Agreement. The Parties (including their respective employees and agents) agree to hold each other's Confidential Information in confidence during the Term of this Agreement and for three (3) years thereafter. The Parties further agree not to disclose or make any Confidential Information of the other Party available in any form to any third party other than its employees, Representatives, Affiliates, legal counsel, professional advisors, consultants, accountants on a need-to-know basis or to use it for any purpose other than the implementation of this Agreement.</p>

<p>9.2 Compelled by Law. If the Receiving Party or any of its Representatives is compelled by applicable law to disclose any Confidential Information then, to the extent permitted by applicable law, the Receiving Party shall provide prior notice of such compelled disclosure and reasonable assistance, at the other party's cost if the other party wishes to contest the disclosure.</p>

<p>9.3 Return of Confidential Information. Upon termination or expiration of the Agreement, each Party shall, upon the other Party's instructions, return to the other Party, or destroy, the Confidential Information and any copies thereof.</p>

<p class="semi-bold fs-24">10. Disclaimer</p>
<p>10.1 Customer Warranty. Customer warrants that Customer own all right, title, and interest, including all intellectual property rights, in and to Customer Data and that both the Customer Data and your use of the Site and Service are in compliance with the AUP.</p>

<p>10.2 DISCLAIMER. TO THE FULLEST EXTENT PERMITTED BY LAW, CUSTOMER AGREES THAT THE SERVICES ARE BEING PROVIDED ‘AS IS' AND ‘AS AVAILABLE', AND EXCEPT FOR THE WARRANTIES EXPRESSLY SET FORTH IN THIS AGREEMENT, LEADMINE.PRO MAKES NO OTHER WARRANTIES, EXPRESS OR IMPLIED, INCLUDING THE IMPLIED WARRANTIES OF MERCHANTABILITY, NON-INFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE AND ANY WARRANTIES ARISING FROM A COURSE OF DEALING OR USAGE IN TRADE, TOGETHER WITH SIMILAR WARRANTIES, WHETHER ARISING UNDER ANY LAW OR OTHERWISE. LEADMINE.PRO DOES NOT REPRESENT OR WARRANT THAT THE SITE OR ANY PORTION OF THE SERVICES WILL ALWAYS BE AVAILABLE, ACCESSIBLE, UNINTERRUPTED, TIMELY, SECURE, CONTINUOUS, ERROR-FREE OR WILL OPERATE WITHOUT PACKET LOSS, NOR DOES LEADMINE.PRO WARRANT ANY CONNECTION TO OR TRANSMISSION FROM THE INTERNET, OR ANY QUALITY OF CALLS MADE THROUGH THE SERVICES BEYOND SUCH TERMS AS SET OUT IN THE SLA ANNEXED HERETO. THE CUSTOMER ALSO ACKNOWLEDGES AND AGREES THAT LEADMINE.PRO CANNOT GUARANTEE THAT IP BASED COMMUNICATIONS ARE COMPLETELY SECURE, ERROR OR VIRUS-FREE.</p>

<p class="semi-bold fs-24">11. Limitations of Liability</p>
<p>CUSTOMER AGREES THAT LEADMINE.PRO WILL NOT BE LIABLE FOR ANY (1) USE OF THE SERVICES, (2) LOSS OR LIABILITY RESULTING FROM ACTS OF OR EVENTS BEYOND OUR CONTROL INCLUDING, BUT NOT LIMITED TO ANY ERRORS OR TECHNICAL ISSUES OF ANY DOMAIN NAME REGISTRY OR OTHER THIRD PARTY PROVIDER, (3) DATA NON-DELIVERY, MIS-DELIVERY, CORRUPTION, DESTRUCTION OR OTHER MODIFICATION; (4) OR LOSS OR LIABILITY RESULTING FROM THE UNAUTHORIZED USE OR MISUSE OF YOUR ACCOUNT IDENTIFIER OR PASSWORD.</p>

<p>NEITHER PARTY WILL BE LIABLE FOR ANY INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES OF ANY KIND (INCLUDING LOST PROFITS) OR FOR ANY FINANCIAL OR ECONOMIC LOSS OR FOR LOSS OF PROFITS, LOSS OF BUSINESS, DEPLETION OF GOODWILL OR SIMILAR LOSSES, LOSS OF ANTICIPATED SAVINGS OR LOSS OR CORRUPTION OF DATA OR INFORMATION, REGARDLESS OF THE FORM OF ACTION WHETHER IN CONTRACT, TORT (INCLUDING NEGLIGENCE), OR OTHERWISE, EVEN IF WE HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.</p>

<p>NO EVENT WILL THE COLLECTIVE LIABILITY OF LEADMINE.PRO OR ITS OFFICERS, DIRECTORS, EMPLOYEES, AFFILIATES, AGENTS, LICENSORS, REPRESENTATIVES, ATTORNEYS, AND BUSINESS PARTNERS TO ANY PARTY, REGARDLESS OF THE TYPE OF ACTION WHETHER IN CONTRACT, TORT (INCLUDING NEGLIGENCE), OR OTHERWISE, EXCEED TOTAL AMOUNTS PAID BY CUSTOMER DURING THE TWELVE (12) MONTHS PRIOR TO THE CLAIM GIVING RISE TO SUCH DAMAGES. Any cause of action the Customer may have with respect to its use of the Site and Service must be commenced and provided to Leadmine.pro within one (1) year after the claim or cause of action arises or it shall be deemed waived by Customer.</p>

<p class="semi-bold fs-24">12. Revisions</p>
<p>The materials appearing on the Site may include technical, typographical, or photographic errors. Leadmine.pro does not warrant that any of the materials on the Site are accurate, complete, or current. Leadmine.pro may make changes to the materials contained on the Site at any time without notice. Leadmine.pro however, makes no commitment of any kind to update the materials regularly.</p>

<p class="semi-bold fs-24">13. Assumption of Risk</p>
<p>The Customer uses the Internet solely at its own risk and subject to all applicable local, state, national, and international laws and regulations. While Leadmine.pro has endeavored to create a secure and reliable Service, please be advised that the confidentiality of any communication or material transmitted to/from a Service over the Internet cannot be guaranteed. Accordingly, Leadmine.pro is not responsible for the security of any information transmitted via the Internet, the accuracy of the information contained on the Site, or for the consequences of any reliance on such information. Leadmine.pro shall have no liability for interruptions or omissions in Internet, network or hosting services. The Customer assumes the sole and complete risk of using the Service. Any material downloaded or otherwise obtained through the use of the Service is done at the Customer's own discretion and risk. The Customer will be solely responsible for any damage to its computer system or loss of data that results from the download of any such material.</p>

<p class="semi-bold fs-24">14. Links</p>
<p>The Site may include links to certain website, materials, or content developed by third parties. Leadmine.pro has not reviewed all of the sites linked to its Internet Site and is not responsible for the contents of any such linked site. The inclusion of any link does not imply endorsement by Leadmine.pro of the site. Use of any such linked website is at the Customer's own risk. Leadmine.pro reserves the right in its sole and absolute discretion to discontinue links to any other sites at any time and for any reason.</p>

<p class="semi-bold fs-24">15. Compliance with Laws</p>
<p>The Customer will use the Service in full compliance with all applicable laws and regulations with regard to the use of the Service including, without limitation, US federal laws, individual state laws, international laws and all other laws and regulations concerning privacy, call recording, telemarketing, Internet marketing and the transmission of electronic communications. The Customer will not use the Service in violation of any service agreement that it may have with a third-party telecommunications provider. If necessary and in accordance with applicable law, Leadmine.pro will cooperate with local, state, federal, and/or international government authorities to protect its Site, Materials, Content, Services, Accounts, visitors, customers, its parents, subsidiaries, affiliates and their respective members, managers, directors, officers, employees, stockholders and agents and operational providers, from the unauthorized use of its Site, Materials, Content, Services and Accounts.</p>

<p class="semi-bold fs-24">16. Indemnification</p>
<p>The Customer shall, at its own expense and subject to the limitations set forth in this Clause, indemnify and defend Leadmine.pro and its Affiliates from and against any and all third-party claims arising out of (a) Customer's breach of the terms of this Agreement and accompanying policies, (b) claims of violation of any laws, regulations or rights of a third party by the Customer, (c) claims related to Customer Data and/or claims relating to data transferred to the applications of third parties or (d) claims that arise from the actions of the Customer, Administrators and/or Authorized Users in connection with their use of the Service, and hold Leadmine.pro harmless from and against any and all liability, losses, damages, and costs (including attorneys' fees) or agreed in settlement by Customer resulting from such claims.</p>

<p class="semi-bold fs-24">17. Term and Termination of License</p>
<p>17.1 Term. The term of this Agreement shall begin on the Effective Date and continue until the expiration of the Plan term, or as mentioned in the Order Form, or unless terminated earlier in accordance with the terms of this clause ('Term'). The Term of the Plan starts on the date of subscribing to a Plan or as mentioned in the Order Form and will continue for the duration set forth.</p>

<p>17.2 Automatic Renewals. The Term shall automatically renew for successive periods of the same duration unless either Party provides a notice of non-renewal to the Party no less than thirty (30) days prior to the end of the current period of the Plan Term. For Customers who have signed an Order Form, the Term will automatically renew for additional periods of the same duration unless either Party provides a notice of non-renewal to the other Party no less than forty-five (45) days prior to the end of the current period mentioned in the Order Form. Leadmine.pro will inform Customers of an upcoming automatic renewal period at least fourteen (14) days before such notice period begins.</p>

<p>17.3 Termination. Either Party may terminate this Agreement if the other party (a) fails to cure a material breach of this Agreement within thirty (30) days after notice, (b) ceases operation without a successor, (c) at the written recommendation of a government or regulatory agency following a change in Applicable Law, (d) subject to Applicable Laws, upon the commencement by or against the other Party of insolvency, receivership or bankruptcy proceedings. Leadmine.pro may terminate this Agreement and/or any Order Form at any time and for any reason without any liability whatsoever.</p>

<p>17.4 Effects of Termination or Expiration. Upon termination or expiration of this Agreement or any Order Form, Customer shall cease to have access to and use of the Service at the end of the ongoing billing cycle. Customer shall be liable to pay Leadmine.pro immediately and without further notice, and in any case no later than thirty (30) days thereof, any accrued fees, charges, including any outstanding fees.</p>

<p>17.5 Suspension of Leadmine.pro Account. Leadmine.pro may suspend access to the Service immediately if Customer is in material breach of this Agreement including non-payment of Fees or is using the Services in violation of law or applicable regulations. The suspension will not relieve the Customer of its obligation to pay fees and costs associated with the Leadmine.pro account. Leadmine.pro shall not be responsible for any damages arising from the suspension of the Service.</p>

<p class="semi-bold fs-24">18. Governing Law and Jurisdiction</p>
<p>The Agreement shall be governed in all respect by the laws of the state of Delaware without regard to its conflict of law provisions. If any litigation is validly instituted in connection with this Agreement, the Parties hereby consent to the exclusive personal jurisdiction of the state and federal courts in Delaware and waive any objection as to venue or inconvenient forum. The Parties hereby waive any right to a jury trial of all claims or causes of actions in connection with a dispute related to this Agreement. To the extent permitted by applicable law, the Parties hereby waive their rights to assert any claim as plaintiff or class member in any purported class action, collective action, and other representative proceedings with respect to the Service.</p>

<p class="semi-bold fs-24">19. Waivers</p>
<p>No waiver shall be deemed to have been made by either party unless expressed in writing and signed by the waiving party. Any such written waiver will not constitute a waiver of any prior or future obligations to comply with such term, provision, condition or requirement.</p>

<p class="semi-bold fs-24">20. Assignment and Delegation</p>
<p>This Agreement and the provisions hereof shall be binding upon and inure to the benefit of the parties hereto and their respective successors and permitted assigns, but neither this Agreement nor any of the rights, interests or obligations hereunder shall be assigned by any of the Parties hereto without the prior written consent of the other Party. Provided, however, either Party may assign this Agreement without such consent to a successor in interest.</p>

<p class="semi-bold fs-24">21. No Injunctive Relief</p>
<p>In no event shall the Customer seek or be entitled to rescission, injunctive or other equitable relief, or to enjoin or restrain the operation of the Service, exploitation of any advertising or other materials issued in connection therewith, or exploitation of the Service or any content or other material used or displayed through the Service.</p>

<p class="semi-bold fs-24">22. Miscellaneous</p>
<p>22.1 Notices. Except as set out in this Agreement, notices or other communications must be in English and are deemed to have been fully given when made in writing and delivered via email, and for Leadmine.pro, addressed to sales@leadmine.pro and to Customer at either the physical address or email address associated with the Customer's Leadmine.pro account.</p>

<p>22.2 Independent Contractors. The Parties are independent contractors and have no right to assume or create any obligation or responsibility on behalf of the other party. This Agreement does not create or imply any partnership, agency, or joint venture.</p>

<p>22.3 Force Majeure. Neither Party is liable to the other for any delay or failure to perform hereunder (excluding payment obligations) due to circumstances beyond such Party's reasonable control including acts of God, acts of government, flood, fire, earthquakes, civil unrest, acts of terror, strikes, service disruptions involving hardware, software or power systems not within such party's possession or reasonable control, and denial of service attacks.</p>

<p>22.4 Severability. If any provision of these terms is found to be unenforceable or invalid, that provision will be limited to the minimum extent necessary so that these terms will otherwise remain enforceable and in full force and effect.</p>

<p>22.5 Amendments. Leadmine.pro reserves the right to update or change the terms of this Agreement or any of its policies from time to time, and will endeavour to provide an advance notice to the Customer at the email address associated with the Leadmine.pro Account or via a pop-up on the site. Any use of the Service after the change in the terms of this Agreement or any of its policies will be deemed as Customer's acceptance of such updates.</p>

<p>22.6 Entire Agreement. This Agreement together with any Order Form(s), Purchases, exhibits and/or schedules, constitutes the entire and sole agreement among the parties with respect to the subject matter hereof and supersedes any previous or contemporaneous agreements, negotiations, understandings, or other matters, whether oral or written, with respect to the subject matter thereof.</p>

<p>22.7 No Third-Party Beneficiaries. The parties agree that there will be no third-party beneficiaries to this Agreement.</p>

<p>22.8 Anti-Bribery. Neither party has received or been offered any illegal or improper bribe, kickback, payment, gift, or thing of value from an employee or agent of the other party in connection with this Agreement.</p>

<p>22.9 Export Control. The Service may be subject to export laws and regulations of the United States and other jurisdictions. Leadmine.pro and Customer each represent that it is not named on any U.S. government denied-party list. Customer will not permit any Administrator and/or Authorized User to access or use the Services in a U.S.-embargoed country or region or in violation of any U.S. export law or regulation.</p>

<p>22.10 Early Access and Betas. Leadmine.pro may offer optional Early Access and Betas. Use of Early Access and Betas is permitted only for Customer's internal evaluation during the period designated by Leadmine.pro (or if not designated, a maximum of 14 days). Either Party may terminate Customer's use of Trials and Betas at any time for any reason. Trials and Betas may be inoperable, incomplete, or include features never released. Notwithstanding anything else in this Agreement, Leadmine.pro offers no warranty, indemnity, and is not liable for any loss caused to the Customer.</p>

<p>22.11 Survival. The following clauses will survive termination or expiration of this Agreement: Clause 10 (Disclaimers), Clause 7 (Pricing, Billing and Refund Policy), Clause 11 (Limitation of Liability), Clause 16 (Indemnification), Clause 9 (Confidentiality), Clause 4 (Intellectual Property Rights), Clause 18 (Governing Law and Jurisdiction), Clause 21 (Injunctive Relief) and Clause 8 (Protection of Data) till the time Leadmine.pro has access to Customer Data.</p>

<p class="semi-bold fs-24">SAAS LABS AI SUPPLEMENTARY TERMS</p>
<p>These SaaS Labs AI Terms and Conditions ('AI Terms') form part of the Terms and Conditions and/or the Agreement between the Customer and Leadmine.pro. These AI Terms govern the use of the features of Service available that could be AI-powered or utilize machine learning or similar technologies ('AI Features'). The AI Terms form an integral part of the Terms and Conditions, defined terms used however not defined herein, shall have meaning as defined in the Agreement. In the event of any conflict between the AI Terms, and the Agreement, the terms of AI Terms shall prevail.</p>

<p>BY ACCESSING OR USING THE AI FEATURES, CUSTOMER HEREBY ACKNOWLEDGES THAT IT HAS READ AND UNDERSTOOD THESE AI TERMS AND AGREES TO BE BOUND BY THEM, IN ADDITION TO ANY OTHER TERMS AND CONDITIONS TO WHICH CUSTOMER HAS AGREED. IF THE CUSTOMER DOES NOT AGREE TO THESE AI TERMS, THE CUSTOMER MAY NOT USE THE AI FEATURES.</p>

<p class="semi-bold fs-24">23. Third-Party Processing</p>
<p>While using the AI Features, Leadmine.pro uses technology provided by third-party AI companies, including OpenAI, LLC ('Third Party Processors') and internal proprietary technology.</p>

<p class="semi-bold fs-24">24. Inputs and Outputs</p>
<p>The Customer may upload or process any information through the Service ('Inputs'), and receive output generated by the AI Features based on the Inputs ('Outputs', and together collectively with Inputs, the 'Content'). The Customer is solely responsible for the Input and for ensuring that the Content complies with applicable laws, these AI Terms, the Agreement, and any Third-Party Processors' policies.</p>

<p>The Customer agrees that they will be responsible for Inputs processed by the AI Features as well as the Outputs generated by the AI Features. The Customer is solely responsible for the Input and for ensuring that the Content complies with applicable laws, these AI Terms, the Agreement, and any Third-Party Processors' policies. Further, the AI Features may generate the same or similar Outputs for other customers.</p>

<p>The Customer agrees that the Customer will not include any sensitive personal data including but not limited to racial or ethnic origin, political origins, religious or philosophical beliefs, health data, or data concerning anyone's sex life or sexual orientation in any Inputs for processing by the AI Features.</p>

<p>Leadmine.pro has imposed limits on the usage of the AI Features. The Customer may be informed when the Customer has reached the maximum number of Outputs for the Leadmine.pro Account. In the event the Customer has exhausted their limit for using the AI Features under a Subscription Plan, then further access to the AI Features shall be chargeable or the Customer may be required to upgrade their Plan.</p>

<p class="semi-bold fs-24">25. Customer Acknowledgments</p>
<p>The Customer acknowledges and agrees that:</p>
<ul>
  <li>The Customer is responsible for any such consent from the end-user as per applicable law for using the AI Features and your respective privacy policies should inform any data subject and end user of the processing of their information using artificial intelligence tools;</li>
  <li>AI Features may not generate accurate information and information provided may be out of date. You should independently verify responses or advice provided by AI Features. We do not provide any warranties or guarantees as to the accuracy of any information provided by the AI Features;</li>
  <li>AI Features are subject to modification and alteration, and may contain errors, design flaws, or other issues;</li>
</ul>

<p class="semi-bold fs-24">26. Security</p>
<p>The Customer must implement reasonable and appropriate measures designed to help secure the access to and use of the AI Features. If the Customer discovers any vulnerabilities or breaches related to the use of the AI Features, the Customer must promptly contact us at sales@leadmine.pro and provide details of the vulnerability or breach.</p>

<p class="semi-bold fs-24">27. Disclaimer</p>
<p>IN ADDITION TO THE DISCLAIMER MENTIONED IN THE TERMS AND CONDITIONS, THE AI FEATURES ARE PROVIDED TO CUSTOMER ON AN ‘AS IS' AND ‘AS AVAILABLE' BASIS. LEADMINE.PRO DOES NOT PROVIDE ANY WARRANTY OR GUARANTEE AS TO THE ACCURACY, COMPLETENESS, OR RELIABILITY OF THE OUTPUTS AND DOES NOT ACCEPT ANY LIABILITY OR RESPONSIBILITY ARISING IN ANY WAY FROM THE CUSTOMER'S USE OF THE OUTPUTS OR ANY OMISSIONS OR ERRORS CONTAINED IN THE OUTPUTS. THE CUSTOMER IS ENCOURAGED TO CONDUCT AN INDEPENDENT EVALUATION, INCLUDING A HUMAN REVIEW OF THE OUTPUTS FOR THEIR ACCURACY, COMPLETENESS AND RELIABILITY. THE CUSTOMER UNDERSTANDS AND AGREES THAT THE USE OF THE OUTPUT IS AT THE CUSTOMER'S SOLE RISK. LEADMINE.PRO DOES NOT REPRESENT OR WARRANT THAT THE AI FEATURES WILL BE FREE FROM THIRD-PARTY INTERFERENCE OR OTHERWISE SECURE AND THAT THE OUTPUTS WILL BE FREE OF CONTENT THAT INFRINGES THIRD-PARTY RIGHTS INCLUDING WITHOUT LIMITATION PRIVACY AND INTELLECTUAL PROPERTY RIGHTS.</p>

<p class="semi-bold fs-24">28. Rights to Use</p>
<p>Leadmine.pro may use the Customer's Content to provide and improve the Services, including:</p>
<ul>
  <li>Providing your questions and prompts to Third Party Processors to generate responses;</li>
  <li>Hosting, using, transmitting, storing, and displaying the Output to the Customer to provide the Services including the AI Features and/or to the end-user, as modified, in connection with the Services including the AI Features;</li>
  <li>Understanding your use of AI Features to generally improve the AI Features and Services.</li>
</ul>
<p>We may also need to process, use, or disclose Your Content to comply with applicable laws, enforce these terms and our policies, and to detect and prevent fraud, security, or technical issues.</p>

<p>As between the parties and to the extent permitted under the applicable laws and any Third Party Processors terms, the Customer is the owner of the Content. By submitting, posting, displaying, providing, or otherwise making available any Content on or through the Services, you expressly grant, and you represent and warrant that you have all rights necessary to grant, to us a royalty-free, sublicensable, transferable, perpetual, irrevocable, non-exclusive, worldwide license to use, reproduce, modify, publish, list information regarding, edit, translate, distribute, syndicate, publicly perform, publicly display, and make derivative works of all such Content and your name, voice, and/or likeness as contained in your Content, in whole or in part, and in any form, media or technology, whether now known or hereafter developed, for use in connection with the Services and our (and its successors' and affiliates') business, including without limitation in connection with modifying, improving, and enhancing the AI Features.</p>

<p class="semi-bold fs-24">29. Restricted Use of AI Features</p>
<p>In addition to the restrictions and Acceptable Use Policy in the Agreement, the Customer represents and warrants that the Customer will not and ensure that its Administrator(s) and/or Authorized Users will not use the AI Features to:</p>
<ul>
  <li>(a) Create and generate content that breaches or violates Clause 5 (Acceptable Use Policy) of the Terms and Conditions or any third-party terms, policies, or other agreements, including OpenAI policies found here https://openai.com/policies/usage-policies.</li>
  <li>(b) Reverse assemble, reverse compile, decompile, translate, or otherwise attempt to discover the source code of underlying components of models, algorithms, and systems of the AI Features;</li>
  <li>(c) Use the AI Features to develop foundational models or other large-scale models that compete with Leadmine.pro or third-party processors;</li>
  <li>(d) Mislead anyone that the Content generated is by a human.</li>
</ul>
<p>The customer shall be fully responsible for the use of the AI Features by any Administrator and/or Authorised User. Leadmine.pro may monitor and limit or suspend the Customer's Leadmine.pro Account if Leadmine.pro believes the Customer's usage of the AI Features has the potential to affect the security, operability, or integrity of the Leadmine.pro Service or violates the Terms and Conditions and/or AI Terms and Conditions.</p>

<p>The Customer warrants that in the event Outputs generated by the AI Features include material that would violate this clause, then the Customer will not use, distribute, or publicize those outputs, and will not use them in any way.</p>

                                </div>

                      
<!-- Fair Usage Policy -->
<div class="tab-pane fade" id="fair-usage" role="tabpanel" aria-labelledby="fair-usage-tab">
    <h2 class="mb-4 heading-medium as-h2">Fair Usage Policy</h2>

    <p><strong>1. Introduction</strong></p>
    <p>At <strong>Leadmine.pro</strong>, we are committed to providing high-quality services to all our customers. To ensure a fair, reliable, and consistent experience, we have implemented this Fair Usage Policy. This policy applies to all Leadmine.pro plans with US and CA Routes.</p>

    <p><strong>2. Applicability</strong></p>
    <p>This Fair Usage Policy applies to all Leadmine.pro plans that include US and CA Routes. Each plan includes free calling minutes and messaging, subject to the limits described below. For more information about the Leadmine.pro plans, please refer to our pricing page.</p>

    <p><strong>3. Plan Limits</strong></p>
    <p>Unless otherwise indicated on an Order Form, the following limits apply:</p>
    <ul class="mb-4 ps-4">
        <li><strong>Team Plan:</strong> 500 inbound and outbound SMS segments per user per billing month. Outbound and inbound voice minutes are unlimited, subject to this Fair Usage Policy.</li>
        <li><strong>Pro Plan and Pro Plus Plan:</strong> 1,000 inbound and outbound SMS segments per user per billing month. Outbound and inbound voice minutes are unlimited, subject to this Fair Usage Policy.</li>
        <li><strong>SalesPro Plan:</strong> 1,000 inbound and outbound SMS segments per user per billing month. Outbound and inbound voice minutes are unlimited, subject to this Fair Usage Policy.</li>
    </ul>

    <p><strong>4. Account-Level Calculation</strong></p>
    <p>The inbound and outbound voice minutes and SMS segments are calculated at the account level. For example, if a Customer is on the Team Plan with 10 active users, the total limit will be 5,000 SMS segments per billing month (10 × 500), with unlimited inbound and outbound voice minutes.</p>

    <p><strong>5. Pro-Rata Usage</strong></p>
    <p>Users added mid-month will receive a pro-rated allocation of voice minutes and SMS segments for the remaining days of the billing month.</p>

    <p><strong>6. Expiry of Unused Segments</strong></p>
    <p>Any unused SMS segments will expire at the end of each billing month and will not roll over to the next month.</p>

    <p><strong>7. Availability</strong></p>
    <ul class="mb-4 ps-4">
        <li>Inbound calling is available for all countries except those with rates greater than USD 0.02/min.</li>
        <li>Outbound calling and SMS are available for countries listed in the Pricing Plans or as indicated on the Order Form.</li>
    </ul>

    <p><strong>8. Excess Usage</strong></p>
    <p>If a Customer exceeds the monthly limit, charges for outbound voice minutes and SMS segments will be deducted from the credits in their Leadmine.pro account. Standard rates will apply for all usage beyond the included limits.</p>
    <p>Customers may contact <a href="mailto:sales@leadmine.pro">{{ config('app.email_id') }}</a> for details on voice and SMS rates.</p>

    <p><strong>9. Trunking and Forwarding Restrictions</strong></p>
    <p>Inbound or outbound calls used for Trunking or forwarding from a Leadmine.pro number to another number (including Leadmine.pro numbers) capable of handling multiple simultaneous calls, or to a PBX system, are not covered under unlimited voice minutes. Such calls will incur additional charges from the customer’s account credits.</p>

    <p><strong>10. Restrictions on Unlimited Calling</strong></p>
    <p>Unlimited outbound and inbound calling may not be used for large-scale or automated operations, including but not limited to:</p>
    <ul class="mb-4 ps-4">
        <li>Telephone operators</li>
        <li>Call centers</li>
        <li>Telemarketing professionals</li>
    </ul>
    <p>Leadmine.pro reserves the right to limit, suspend, or terminate usage if abuse or policy violations are detected.</p>

    <p><strong>11. SMS Usage Policy</strong></p>
    <p>The SMS limits under this policy apply only to one-on-one messages. They do not apply to:</p>
    <ul class="mb-4 ps-4">
        <li>Bulk SMS campaigns</li>
        <li>Automated workflow messages</li>
        <li>SMS bots or marketing automation</li>
    </ul>
    <p>Charges for such messages will be deducted at standard rates from the Customer’s account credits.</p>

    <p><strong>12. Billing Method</strong></p>
    <ul class="mb-4 ps-4">
        <li>Voice calls are billed per minute. Even calls lasting less than one minute are billed as one full minute. Partial minutes are rounded up to the nearest full minute.</li>
        <li>SMS messages are billed per segment. One SMS segment equals 160 characters. Longer messages are rounded up to the next segment.</li>
    </ul>

    <p><strong>13. Enforcement and Updates</strong></p>
    <p>Leadmine.pro reserves the right to limit, suspend, or terminate access to the Services if a Customer violates this Fair Usage Policy. The company may amend this policy or the limits mentioned herein at any time without prior notice.</p>

    <p><strong>14. Previous Plans</strong></p>
    <p>If you are currently subscribed to older plans and wish to view the applicable Fair Usage Policy for those, please refer to the previous policy documentation or contact our support team.</p>
</div>


                   <!-- Privacy Policy -->
<div class="tab-pane fade" id="privacy" role="tabpanel" aria-labelledby="privacy-tab">
    <h2 class="mb-4 heading-medium as-h2">Privacy Policy</h2>

    <p>Welcome, and thank you for your interest in SaaS Labs US, Inc, our product leadmine.pro (“leadmine.pro”, “we,” or “us”), our web site at <a href="https://leadmine.pro" target="_blank">https://leadmine.pro</a> (the “Site”), and all related websites, downloadable software, mobile applications (including tablet applications), and other services provided by us and on which a link to this Privacy Policy is displayed, and all other communications with individuals through written or oral means, such as email or phone (collectively, together with the Site, our “Service”).</p>

    <p>This Privacy Policy (“Policy”) describes the information that we gather on or through the Service, how we use and disclose such information, and the steps we take to protect such information. By visiting the Site, or by purchasing or using the Service, you accept the privacy practices described in this Policy.</p>

    <p>This Policy is incorporated into, and is subject to, the leadmine.pro Terms & Conditions. Capitalized terms used but not defined in this Policy have the meaning given to them in the leadmine.pro Terms & Conditions.</p>

    <h3 class="as-h3">Definitions</h3>
    <p><strong>“Client”</strong> means a customer of leadmine.pro.</p>
    <p><strong>“Client Data”</strong> means personal data, reports, addresses, and other files, folders or documents in electronic form that a User of the Service stores within the Service.</p>
    <p><strong>“Personal Data”</strong> means any information relating to an identified or identifiable natural person.</p>
    <p><strong>“Public Area”</strong> means the area of the Site that can be accessed both by Users and Visitors, without needing to log in.</p>
    <p><strong>“Restricted Area”</strong> means the area of the Site that can be accessed only by Users, and where access requires logging in.</p>
    <p><strong>“User”</strong> means an employee, agent, or representative of a Client, who primarily uses the restricted areas of the Site for the purpose of accessing the Service in such capacity.</p>
    <p><strong>“Visitor”</strong> means an individual other than a User, who uses the public area, but has no access to the restricted areas of the Site or Service.</p>

    <h3 class="as-h3">What personal information do we collect?</h3>
    <p>We collect different types of information from or through the Service. The legal bases for leadmine.pro’s processing of Personal Data are primarily that the processing is necessary for providing the Service in accordance with our Terms of Service and that the processing is carried out in leadmine.pro’s legitimate interests, which are further explained in this Policy. We may also process data upon your consent, asking for it as appropriate.</p>

    <h3 class="as-h3">User-provided Information</h3>
    <p>When you use the Service, as a User or as a Visitor, you may provide, and we may collect Personal Data. Examples of Personal Data include name, email address, mobile phone number, and billing information. You may provide us with Personal Data when registering for an account, using the Service, posting Client Data, interacting with other users, or sending customer-service requests.</p>

    <h3 class="as-h3">Information collected by clients</h3>
    <p>A Client or User may store or upload into the Service Client Data. leadmine.pro has no direct relationship with the individuals whose Personal Data it hosts as part of Client Data. Each Client is responsible for providing notice to its customers and third persons concerning how their Personal Data is processed in or through the Service.</p>

    <h3 class="as-h3">Automatically collected information</h3>
    <p>When a User or Visitor uses the Service, we may automatically record certain information from the device using cookies, pixels, or web beacons. This may include IP address, browser type, device type, pages visited, content interacted with, and time spent on the Service.</p>

    <h3 class="as-h3">Integrated services</h3>
    <p>You may be given the option to access or register for the Service through certain third-party services such as Google. By authorizing us to connect with an Integrated Service, you authorize us to access and store your name, email, and profile information according to this Policy.</p>

    <h3 class="as-h3">How do we use your information?</h3>
    <p>We use the information to operate, maintain, enhance, and provide all features of the Service, respond to comments and questions, and provide user support. We also use the data to improve our Service, understand usage trends, and develop new features.</p>

    <h3 class="as-h3">Cookies and tracking technologies</h3>
    <p>We use cookies and similar technologies to personalize the Service, remember user preferences, measure performance, and analyze site traffic and engagement.</p>

    <h3 class="as-h3">Analytics</h3>
    <p>We use Google Analytics to measure and evaluate access to the public area of the Site and to generate reports for site administrators. The data collected is used only to improve performance and usability and is not used to identify individuals.</p>

    <h3 class="as-h3">To whom we disclose information?</h3>
    <p>Except as described in this Policy, we do not intentionally disclose Personal Data or Client Data to third parties without consent. We may share information with service providers, partners, or as required by law. We do not sell Personal Data or Client Data.</p>

    <h3 class="as-h3">Your choices</h3>
    <p>You may access, correct, or delete your Personal Data by contacting <a href="mailto:sales@leadmine.pro">{{ config('app.email_id') }}</a>. You may also opt-out of receiving promotional communications or delete your account data as per applicable data protection laws.</p>

    <h3 class="as-h3">EU Representative</h3>
    <p>We have appointed IT Governance Europe Limited as our EU representative. For GDPR-related queries, email <a href="mailto:sales@leadmine.pro">{{ config('app.email_id') }}</a> with our company name in your message.</p>

    <h3 class="as-h3">How do we protect your information?</h3>
    <p>All credit card transactions are processed through a PCI-compliant gateway (Stripe, Inc). Your personal information is stored on secured networks, accessible only to authorized personnel. All sensitive data is encrypted via TLS/SSL, and 2FA is provided for all accounts. In the event of a data breach, we investigate and notify affected users and authorities within 72 hours.</p>

    <h3 class="as-h3">Third-party Services</h3>
    <p>The Service may contain links or integrations with third-party websites or apps. We are not responsible for their privacy or security practices and recommend reviewing their privacy policies before sharing data.</p>

    <h3 class="as-h3">Data Transfer</h3>
    <p>We may transfer, process, and store Personal Data in the United States or other regions where our service providers operate. When transferring data internationally, we comply with applicable data protection laws such as GDPR.</p>

    <h3 class="as-h3">Data Controller and Data Processor</h3>
    <p>leadmine.pro acts as a data processor on behalf of its Clients regarding Client Data that contains Personal Data. The Client or User is the data controller responsible for determining the purposes and means of processing such Personal Data.</p>

    <h3 class="as-h3">Data Retention</h3>
    <p>We retain Personal Data only for as long as needed to provide the Service or as required by law. Closed account data is deleted within 6 months, backups within 12 months, and transaction records are retained for 10 years.</p>

    <h3 class="as-h3">Third-party Cookies</h3>
    <p>We allow certain third parties to use cookies for analytics and advertising purposes. These parties may collect limited device information to show personalized ads. We do not share identifiable user data with them.</p>

    <h3 class="as-h3">Fair Information Practices</h3>
    <p>In the event of a data breach, we will notify users via email or in-site notification within 7 business days. We adhere to Fair Information Practice principles, ensuring individuals have enforceable rights against data collectors and processors who fail to comply with privacy laws.</p>
</div>



<!-- Integration Partner Program Agreement -->
<div class="tab-pane fade" id="partner-program" role="tabpanel" aria-labelledby="partner-program-tab">
    <h2 class="mb-4 heading-medium as-h2">Integration Partner Program Agreement</h2>

    <p>This Partner Program Agreement (referred to as the “Agreement”) is between SaaS Labs US, Inc. (referred to as “LeadMine.pro” or “SaaS Labs”), a Delaware corporation with its principal place of business at 355, Bryant Street, #403 San Francisco, CA 94107 and Integration Partner identified below in the signatures. By clicking on the “Become a Partner” button while signing up to join the LeadMine.pro Integration Partner Program, the Integration Partner (a) acknowledges that it has agreed and will comply with this Agreement, (b) warrants and represents that its representatives are at least eighteen (18) years of age and (c) has the right, power and authority to enter into this Agreement on behalf of the Integration Partner, and to bind the Partner to this Agreement.</p>

    <p>This Agreement applies to your participation in our LeadMine.pro Integration Partner Program (“Partner Program” or “Program”) as an Integration Partner.</p>

    <p>If the Integration Partner does not agree to these terms, the Integration Partner may not participate in the Program. LeadMine.pro may modify this Agreement at any time by sending you a notice via email.</p>

    <h3 class="as-h3">Program Overview</h3>
    <p><strong>Purpose.</strong> Subject to the terms of this Agreement, the Parties shall engage in certain specified partnering activities which, among other things mutually agreed, may include (a) the development, provision, and support of an integrated offering, (b) the promotion and marketing of one another’s products and services, and/or (c) any other similarly related undertaking as mutually agreed between the Parties. Any such activities shall be set forth in one or more supplements hereto (each, a “Supplement”).</p>
    <p><strong>Generally.</strong> To participate in the Program, the Integration Partner must complete the online registration form and/or enter into this Agreement. If online registration, then the Program shall take effect once LeadMine.pro notifies the approval to participate in the Program via email. LeadMine.pro may accept or reject any registration form at its sole discretion.</p>
    <p>The terms of this Agreement do not authorize the Integration Partner to purchase the LeadMine.pro product directly for commercial use. The purchase of LeadMine.pro product shall be governed under a separate agreement between LeadMine.pro and Integration Partner. For integrated offerings, each Party shall be responsible for providing support (if any) to end users for each Party's product.</p>

    <h3 class="as-h3">Co-Marketing and Promotional Activities</h3>
    <p>Each Party agrees to use commercially reasonable efforts to engage in marketing and promotional activities as mutually decided between the Parties. Both Parties shall approve all co-branded or joint promotional materials in writing before release. Approval shall not be unreasonably withheld and must be provided within five (5) business days of submission.</p>

    <h3 class="as-h3">Confidential Information</h3>
    <p><strong>Definition.</strong> “Confidential Information” means all information disclosed by one party (“Discloser”) to the other (“Recipient”) which is marked as confidential or is of such a nature that a reasonable person would understand it to be confidential. A Party’s Confidential Information shall not include information that (a) is or becomes public through no act or omission of the other Party; (b) was rightfully in the possession of the other Party prior to its disclosure; (c) is independently developed without the use of Confidential Information; (d) is provided by the Discloser to third parties without restriction; or (e) is required to be disclosed by law.</p>
    <p><strong>Obligation.</strong> Each Party shall not, without the other’s prior written consent, disclose any Confidential Information except to employees, affiliates, or advisors as necessary to fulfill obligations under this Agreement. If required by law, the Recipient shall provide prior notice and reasonable assistance at the Discloser’s cost.</p>
    <p><strong>Return/Destruction.</strong> Upon expiration or termination of this Agreement, Recipient shall immediately cease use of, and return or destroy, all Confidential Information.</p>

    <h3 class="as-h3">Intellectual Property</h3>
    <p><strong>Ownership.</strong> Except for express licenses set forth herein, no rights, title, or licenses in any intellectual property are granted. LeadMine.pro retains all ownership rights in its product. The Integration Partner agrees not to copy, rent, sell, or distribute LeadMine.pro products unless expressly authorized.</p>
    <p><strong>Trademark.</strong> Each Party grants the other a non-exclusive, non-transferable right to display logos and trademarks solely for promotional purposes, in accordance with usage guidelines. Each retains ownership of its marks.</p>
    <p><strong>Feedback.</strong> If the Integration Partner provides feedback about the LeadMine.pro product, LeadMine.pro may use it without restriction and without any obligation to attribute or compensate.</p>

    <h3 class="as-h3">Term and Termination</h3>
    <p><strong>Term.</strong> This Agreement is effective as of the Effective Date and continues for one (1) year unless terminated earlier.</p>
    <p><strong>Termination.</strong> Either Party may terminate upon sixty (60) days’ notice, or immediately if the other breaches and fails to cure within thirty (30) days. Either Party may also terminate if the other becomes insolvent or subject to bankruptcy.</p>
    <p><strong>Effect.</strong> Upon termination, all rights and obligations cease except those that by their nature should survive.</p>

    <h3 class="as-h3">Warranties and Disclaimer</h3>
    <p>Each Party represents and warrants it has the authority to enter this Agreement and will protect Confidential Information using industry-standard safeguards.</p>
    <p><strong>Disclaimer.</strong> EXCEPT AS EXPRESSLY PROVIDED, EACH PARTY DISCLAIMS ALL WARRANTIES, INCLUDING IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT.</p>

    <h3 class="as-h3">Indemnification</h3>
    <p>Each Party shall indemnify and hold harmless the other from third-party claims, damages, and expenses arising from breaches or negligence. The Indemnitor will control the defense and settlement of claims, provided no settlement includes admission of liability without the Indemnitee’s consent.</p>

    <h3 class="as-h3">Limitation of Liability</h3>
    <p>EXCEPT FOR INDEMNIFICATION OR GROSS NEGLIGENCE, NEITHER PARTY SHALL BE LIABLE FOR INDIRECT, SPECIAL, OR CONSEQUENTIAL DAMAGES. TOTAL LIABILITY SHALL NOT EXCEED FIVE THOUSAND U.S. DOLLARS ($5,000).</p>

    <h3 class="as-h3">General Terms</h3>
    <p><strong>Compliance with Law.</strong> Each Party shall comply with all applicable laws and regulations.</p>
    <p><strong>Assignment.</strong> Neither Party may assign this Agreement without the other’s written consent, except in connection with a merger or sale of substantially all assets.</p>
    <p><strong>Governing Law.</strong> This Agreement shall be governed by the laws of Delaware, USA. Disputes shall be resolved in the state and federal courts located in Delaware.</p>
    <p><strong>Notices.</strong> Notices must be in writing. If to LeadMine.pro: SaaS Labs US, Inc., Attn: Legal, 355 Bryant Street, #403, San Francisco, CA 94107, <a href="mailto:sales@leadmine.pro">{{ config('app.email_id') }}</a>.</p>
    <p><strong>Entire Agreement.</strong> This Agreement constitutes the entire understanding between the Parties and supersedes all prior communications. No partnership or employment relationship is created by this Agreement.</p>
    <p><strong>Force Majeure.</strong> Neither Party shall be liable for delays due to causes beyond their control, including natural disasters, war, or government actions.</p>
    <p><strong>Relationship of the Parties.</strong> The Parties are independent contractors, not agents or partners.</p>
    <p><strong>Export.</strong> Integration Partner agrees to comply with all relevant U.S. and foreign export laws when using the LeadMine.pro product and confirms it is not located in any prohibited country.</p>
</div>


<!-- When and With Whom Do We Share? -->
<div class="tab-pane fade" id="applicant-privacy" role="tabpanel" aria-labelledby="applicant-privacy-tab">
    <h2 class="mb-4 heading-medium as-h2">When and With Whom Do We Share Your Personal Information?</h2>
    <p class="mb-4">
        We may share your personal information only as necessary to evaluate your application during the recruitment process. 
        We do not sell your information to others and only disclose it in the specific situations described below.
    </p>

    <h3 class="mb-3 custom-heading">Our Affiliates</h3>
    <p class="mb-4">
        We may share your personal information with our Affiliates to facilitate the recruitment process and manage 
        your application across different entities of SaaS Labs. Affiliates include our parent company, subsidiaries, 
        joint ventures, or other entities under common control with us.
    </p>

    <h3 class="mb-3 custom-heading">Service Providers</h3>
    <p class="mb-4">
        We may engage third-party service providers who perform specific recruitment-related services on our behalf. 
        These providers may process your information only to perform tasks such as receiving applications, managing 
        applicant tracking systems, conducting background checks, and supporting recruitment operations.
    </p>

    <h3 class="mb-3 custom-heading">Legal Requirements</h3>
    <p class="mb-4">
        We may disclose your personal information when authorized by law or required to comply with a legal obligation, 
        legal process, or request from public or government authorities. We may also share information as necessary to 
        protect and defend our rights.
    </p>

    <h3 class="mb-3 custom-heading">Merger or Acquisition</h3>
    <p class="mb-4">
        If SaaS Labs merges with, is acquired by, or transfers its assets to another company, your personal information 
        may be transferred as part of that transaction. The acquiring company will be required to respect this Privacy Notice.
    </p>

    <h3 class="mb-3 custom-heading">Professional Advisors</h3>
    <p class="mb-4">
        We may share your information with professional advisors such as lawyers, accountants, auditors, or consultants 
        who provide legal, financial, or compliance services.
    </p>

    <h3 class="mb-3 custom-heading">By Consent</h3>
    <p class="mb-4">
        We may share your personal information with other third parties if you have provided your explicit consent to do so. 
        You may choose to withdraw your consent at any time by contacting us at 
        <a href="mailto:sales@leadmine.pro">{{ config('app.email_id') }}</a>.
    </p>

    <h3 class="mb-3 custom-heading">Your Employer, Previous Employers, or References</h3>
    <p>
        During the recruitment process, we may contact and share relevant personal information with your current or 
        previous employers, references, or educational institutions to verify your employment history, education, 
        and professional qualifications.
    </p>
</div>

                              <!-- Cookies and Tracking Technologies -->
<div class="tab-pane fade" id="cookie" role="tabpanel" aria-labelledby="cookie-tab">
    <h2 class="mb-4 heading-medium as-h2">Do We Use Cookies and Other Tracking Technologies?</h2>
    <p class="mb-4">
        This Cookie Notice explains how SaaS Labs US, Inc. (“SaaS Labs”, “LeadMine.pro”, “we”, “us”, or “our”) uses cookies and similar technologies to recognize you when you visit our website <a href="https://www.leadmine.pro" target="_blank">www.leadmine.pro</a>. 
        It helps us provide you with a better experience while browsing our website and allows us to improve our site. Please read this Cookie Notice together with our Privacy Policy.
    </p>

    <h3 class="mb-3 custom-heading">What is this Notice for?</h3>
    <p class="mb-4">
        This Cookie Notice explains what to expect when you visit our website with respect to our use of cookies and similar technologies. It describes:
        <ul>
            <li>What cookies are</li>
            <li>Which cookies we use on our website</li>
            <li>How we use cookies</li>
            <li>How you can control or change your browser settings</li>
            <li>Changes to this Cookie Notice</li>
            <li>How to contact us</li>
        </ul>
        By engaging with our website, you confirm that you have read and understood this Cookie Notice.
    </p>

    <h3 class="mb-3 custom-heading">What are Cookies?</h3>
    <p class="mb-4">
        Cookies are small data files placed on your browser or device when you visit a website. When you revisit the same website, cookies allow it to recognize your device and preferences. 
        Cookies set by the website owner (SaaS Labs) are known as “first-party cookies,” and cookies set by third parties are called “third-party cookies.” 
        Third-party cookies enable additional features like analytics, advertising, or interactive content across websites.
    </p>

    <h3 class="mb-3 custom-heading">Cookies We Use</h3>
    <p class="mb-4">
        We may use the following types of cookies:
    </p>

<div class="table-responsive mb-4 custom-table-responsive">
    <table class="table table-bordered align-middle w-100 custom-cookie-table">
        <thead class="table-light text-center">
            <tr>
                <th class="col-30">Type of Cookie</th>
                <th class="col-70">Purpose</th>
            </tr>
        </thead>

        <tbody>
            <tr>
                <td>Strictly Necessary Cookies</td>
                <td class="cookie-purpose-text">
                    These cookies are required for the operation of our website and to provide services available through it. 
                    They are essential for site security, session management, and navigation.
                </td>
            </tr>
            <tr>
                <td>Performance Cookies</td>
                <td class="cookie-purpose-text">
                    These cookies help us count visitors, understand how users navigate our website, and improve site performance. 
                    All collected data is aggregated and anonymous.
                </td>
            </tr>
            <tr>
                <td>Functionality Cookies</td>
                <td class="cookie-purpose-text">
                    These cookies remember returning visitors, preferences, and personalized features to enhance your browsing experience.
                </td>
            </tr>
            <tr>
                <td>Targeting Cookies</td>
                <td class="cookie-purpose-text">
                    These cookies are set by our advertising partners to deliver relevant marketing campaigns based on your activity on our website.
                </td>
            </tr>
        </tbody>
    </table>
</div>

<h3 class="mb-3 custom-heading">How Do We Use Cookies?</h3>
<p class="mb-4">
    We use cookies to operate and secure our website (strictly necessary cookies) and, if required by law, with your permission, 
    to personalize content, analyze site traffic, and improve our marketing effectiveness. We may share cookie data with advertising 
    partners who may combine it with other information you’ve provided or that they have collected from your use of their services. 
    You can withdraw your consent at any time.
</p>

<h3 class="mb-3 custom-heading">Other Tracking Technologies</h3>
<p class="mb-4">
    In addition to cookies, we may use web beacons, tracking pixels, or clear GIFs—tiny graphics files that help us understand engagement 
    on our website, improve performance, and measure marketing campaign success.
</p>

<h3 class="mb-3 custom-heading">How Can You Control Cookies?</h3>
<p class="mb-4">
    Except for strictly necessary cookies, you can manage or reject cookies at any time using our Cookie Management Tool or through your browser settings.
    Most browsers allow you to control cookies. Please note that blocking all cookies (including necessary ones) may affect your ability to access some parts of our website.
</p>

<p class="mb-3">
    For more details on managing cookies, visit <a href="https://www.allaboutcookies.org" target="_blank">allaboutcookies.org</a>, 
    or check settings for popular browsers:
</p>
<ul>
    <li>Google Chrome</li>
    <li>Microsoft Edge</li>
    <li>Mozilla Firefox</li>
    <li>Apple Safari</li>
</ul>
<p class="mb-3">
    To opt out of Google Analytics tracking, visit 
    <a href="http://tools.google.com/dlpage/gaoptout" target="_blank">tools.google.com/dlpage/gaoptout</a>.
</p>

<h3 class="mb-3 custom-heading">Contact Information</h3>
<p class="mb-4">
    If you have questions or feedback about our use of cookies or other tracking technologies, please contact us at 
    <a href="mailto:sales@leadmine.pro">{{ config('app.email_id') }}</a>.
</p>

<h3 class="mb-3 custom-heading">Changes to This Notice</h3>
<p class="mb-0">
    We may update this Cookie Notice from time to time. Any changes will be posted on this page with an updated “Last Updated” date. 
    Please check this Notice periodically for updates. <br>
    <strong>Last Updated: 11-11-2025</strong>
</p>

</div>


                        <!-- Refund Policy -->
<div class="tab-pane fade" id="refund" role="tabpanel" aria-labelledby="refund-tab">
    <h2 class="mb-4 heading-medium as-h2">Refund Policy</h2>
    <p class="mb-4">
        Upon account cancellation, you don't get a refund for your past payments. Your card is not charged from the next billing cycle. 
        If you remove a user from your account, the new downgraded plan is applicable from the next billing cycle.
    </p>

    <p class="mb-4">
        In case of an account upgrade (when a new number or team member is added), you are not charged the full amount, 
        but only the prorated amount for the remaining days of the billing cycle. For example, if your billing cycle is from 
        the 1st of every month and you add a new member on the 15th, you will be charged only 50% for this new member.
    </p>

    <p class="mb-4">
        This refund policy is applicable to all past payments including: subscription fees, calling credits, call costs, texting 
        (SMS & MMS) costs, fax costs, porting fees, and any other custom engineering fees.
    </p>

    <h3 class="mb-3 custom-heading">Refund requests are accepted only under the following cases:</h3>
    <ul class="mb-4 ps-4">
        <li>1) Duplicate payment</li>
        <li>2) Charges made by mistake after account cancellation</li>
    </ul>
</div>


                            <!-- Responsible Disclosure Policy -->
<div class="tab-pane fade" id="disclosure" role="tabpanel" aria-labelledby="disclosure-tab">
    <h2 class="mb-4 heading-medium as-h2">Responsible Disclosure Policy</h2>
    <p class="mb-4">
        At SaaS Labs US, Inc. (hereinafter, "SaaS Labs"), ensuring the safety and security of our customer's data and the reliability of our products are of utmost importance to us. Therefore, we strive to design and create products with the highest levels of security and reliability. Despite our best efforts, our products and services may still contain vulnerabilities and errors due to their highly complex and sophisticated nature.
    </p>

    <h3 class="mb-3 custom-heading">Purpose</h3>
    <p class="mb-4">
        This policy outlines SaaS Lab's methods for identifying and addressing potential vulnerabilities and errors in its products. It encourages external parties to report any issues they may encounter while using our products so that we can promptly investigate and resolve them. SaaS Lab encourages customers, users, researchers, partners, and anyone else who interacts with SaaS Labs' products to report any identified vulnerabilities or errors with such products.
    </p>

    <h3 class="mb-3 custom-heading">Submitting a Report</h3>
    <p class="mb-4">
        The preferred method of contacting SaaS Labs regarding vulnerabilities and errors is sending your report to 
        <a href="mailto:sales@leadmine.pro">{{ config('app.email_id') }}</a>. Please include the following details with your report:
    </p>
    <ul class="mb-4 list-disc ps-4">
        <li>Description of the location and potential impact of the exposure</li>
        <li>A detailed description of the steps required to reproduce the vulnerability (POC scripts, screenshots, and compressed screen captures are all helpful to us)</li>
        <li>Your name/handle and a link for recognition in our Hall of Fame</li>
    </ul>

    <p class="mb-4">
        Please be assured that providing your name and contact information with your report is entirely optional and at your discretion. SaaS Labs values all reports that are submitted, whether anonymously or with name and contact information. Rest assured that SaaS Labs is committed to respecting your privacy. In the event that you do choose to submit your name and contact information, SaaS Labs will only use such information to reach out to you if any clarification on the details of your report is necessary and to include your name in the Hall of Fame.
    </p>

    <h3 class="mb-3 custom-heading">What to Expect</h3>
    <p class="mb-4">
        SaaS Labs will endeavour to acknowledge the receipt of your report within three (3) working days of submission. You will be kept informed of our progress and completion of any remediation actions pursuant to your report. SaaS Labs will also work with you to understand and resolve the vulnerability quickly.
    </p>

    <p class="mb-4">By submitting a report, you acknowledge and agree to the following terms:</p>
    <ul class="mb-4 list-disc ps-4">
        <li>SaaS Labs reserves the right to use your report for any relevant purpose, including but not limited to correcting any vulnerabilities and errors that are reported and deemed necessary by SaaS Labs.</li>
        <li>If you propose any changes or improvements to a SaaS Labs product or service in your report, you are assigning all ownership and usage rights of those proposals to SaaS Labs.</li>
    </ul>

    <h3 class="mb-3 custom-heading">Guidelines for Responsible Disclosure</h3>

    <h4 class="mb-2">Scope</h4>
    <ul class="mb-4 list-disc ps-4">
        <li>*.saaslabs.co</li>
        <li>*.leadmine.pro</li>
      
    </ul>

    <h4 class="mb-2">Out-of-Scope Vulnerabilities</h4>
    <p class="mb-4">
        Any services hosted by third-party providers and services are excluded from the scope.
    </p>
    <p class="mb-4">
        In the interest of the safety of SaaS Labs's users, staff, the Internet at large, and you as a security researcher, the following test types are excluded:
    </p>
    <ul class="mb-4 list-disc ps-4">
        <li>Denial of service</li>
        <li>Spamming emails or messages</li>
        <li>Social engineering (including phishing) of SaaS Labs staff or contractors or SaaS Labs subsidiaries' staff</li>
        <li>Any physical attempts against Leadmine.pro property or data centres</li>
        <li>Content spoofing / text injection</li>
        <li>Self-XSS [to be valid, cross-site scripting issues must be exploitable in reflected, stored or DOM-based types]</li>
        <li>Logout and other instances of low-severity Cross-Site Request Forgery</li>
        <li>Open redirects with low-security impact (exceptions are those cases where the impact is higher such as stealing oauth tokens)</li>
        <li>Missing http security headers</li>
        <li>Missing cookie flags on non-sensitive cookies</li>
        <li>Password and account recovery policies, such as reset link expiration or password complexity</li>
        <li>Invalid or missing SPF (Sender Policy Framework) records (Incomplete or missing SPF/DKIM)</li>
        <li>SSL/TLS best practices</li>
        <li>Clickjacking/UI redressing with no practical security impact</li>
        <li>Username / email enumeration via Login Page or Forgot Password Page error</li>
    </ul>

    <h3 class="mb-3 custom-heading">Modification of Messages</h3>
    <p class="mb-4">
        If you have any clarifications to make, contact us at 
        <a href="mailto:sales@leadmine.pro">{{ config('app.email_id') }}</a>.
    </p>

    <h3 class="mb-3 custom-heading">Rules</h3>
    <p class="mb-3">You will not:</p>
    <ul class="mb-4 list-disc ps-4">
        <li>Exploit or use the discovered vulnerabilities and/or errors, except for reporting to SaaS Labs</li>
        <li>Conduct testing/research of systems with the intention of harming SaaS Labs, its customers, employees, partners or suppliers</li>
        <li>Use, misuse, delete, alter or destroy any data related to the vulnerability and/or error discovered</li>
        <li>Conduct social engineering, spamming, phishing, denial-of-service or resource-exhaustion attacks</li>
        <li>Test the physical security of any property or building of SaaS Labs</li>
        <li>Breach any applicable laws or regulations in connection with your interaction with SaaS Labs' products that lead to your report</li>
        <li>Disclose to any third party any information related to your report, the vulnerabilities and/or errors reported, and the fact that vulnerabilities and/or errors have been reported to SaaS Labs</li>
        <li>Demand any reward or benefit, financial or otherwise for disclosing any vulnerabilities</li>
    </ul>

    <p class="mb-3">You will:</p>
    <ul class="mb-4 list-disc ps-4">
        <li>Make every effort to avoid privacy violations, degradation of user experience, disruption to production systems, and destruction of data during security testing</li>
        <li>Perform research only within the scope set out above</li>
        <li>Keep any information you receive or collect about SaaS Labs, its customers or any of their visitors, or employees or agents in connection with this policy ("Confidential Information") confidential</li>
    </ul>

    <p class="mb-4">
        If you follow SaaS Labs Responsible Disclosure Policy when reporting an issue, then SaaS Labs will:
    </p>
    <ul class="mb-4 list-disc ps-4">
        <li>Not pursue or support any legal action related to your research</li>
        <li>If you are the first to report the issue and we make a code or configuration change based on the issue</li>
    </ul>

    <p class="mb-4">
        SaaS Labs reserves the right to modify or amend any terms of this Policy at any time without any notice.
    </p>

    <h3 class="mb-3 custom-heading">Hall of Fame</h3>
    <p class="mb-4">
        At SaaS Labs, we use our Hall of Fame program to recognize people who have responsibly shared one or more security vulnerabilities in our products, enabling us to serve our customers better. Please refer to the Security Hall of Fame for details. Decision to include you in the Hall of Fame is at the sole discretion of SaaS Labs.
    </p>
</div>


                              <!-- GDPR Compliance -->
<div class="tab-pane fade" id="gdpr" role="tabpanel" aria-labelledby="gdpr-tab">
    <h2 class="mb-4 heading-medium as-h2">GDPR Compliance</h2>

    <h3 class="mb-3 custom-heading">Introduction</h3>
    <p class="mb-4">
        The European Union’s General Data Protection Regulation (GDPR) represents the most comprehensive overhaul of data privacy legislation in decades, which took effect on May 25, 2018. This regulation establishes a modern framework for data protection that addresses the realities of today’s digital landscape, where personal information flows across borders and through complex technological systems. The GDPR introduces enhanced individual rights, stricter accountability requirements for organizations, and significant penalties for non-compliance, all designed to give people greater control over their personal data.
    </p>

    <h3 class="mb-3 custom-heading">Our Commitment</h3>
    <p class="mb-4">
        At LeadMine.pro, we take data privacy very seriously. We have built our data protection program around the principle that protecting personal data is not just a legal requirement, but a fundamental responsibility to our Customers whose data flows through our platform. Our approach emphasizes transparency, security, and accountability at every stage of data handling.
    </p>
    <p class="mb-4">
        We do not own, control, or direct the use of any of the Customer Data stored or processed by a Customer or Authorized User via the Service. LeadMine.pro operates as a data processor under the GDPR framework, meaning we handle personal data exclusively on behalf of our Customers who serve as data controllers. As a processor, we do not make independent decisions about why or how personal data is processed – these determinations rest with our controller, Customers. We recognize that as a processor serving Customers across multiple jurisdictions, including the EU and UK, we must maintain the highest standards of data protection to support our controller Customers’ compliance obligations.
    </p>

    <h3 class="mb-3 custom-heading">Preparation and Implementation</h3>
    <p class="mb-3"><strong>Policies and Procedures:</strong> Our data protection framework has been structured to address GDPR requirements:</p>
    <ul class="mb-4">
        <li>Data Processing Addendums: We have Data Processing Addendums available on request that clearly define our role as a processor, specify the types of data we handle, outline security measures, and establish procedures for data subject requests and breach notifications.</li>
        <li>Incident Response: We maintain 24/7 monitoring and rapid response capabilities to detect, assess, and report any data breaches to affected controllers within the required timeframes.</li>
        <li>Data Retention: We have clear procedures for retaining the Customer Data within the timeframes as mentioned in the Privacy Policy/Notice.</li>
        <li>International Transfers: When data crosses borders, we ensure appropriate safeguards are in place, including using Standard Contractual Clauses as the transfer mechanism.</li>
    </ul>

    <p class="mb-3"><strong>Controller Support Systems:</strong> We have built tools and processes specifically designed to help our Data Controller Customers to meet their GDPR obligations:</p>
    <ul class="mb-4">
        <li>Data Subject Request Assistance: Our platform includes features that help data controllers locate, export, modify, or delete personal data in response to requests that they may receive from data subjects.</li>
        <li>Data Protection Impact Assessment Support: When data controllers conduct Data Protection Impact Assessments, we can assist by providing technical information about our processing activities and security measures.</li>
        <li>Privacy Controls: To help ensure that sensitive information is protected, we have implemented two key features: Pause Transcription and Redaction Settings. 
            In Pause Transcription, the data controller can pause the transcription if the call recording is paused to ensure no audio data is transcribed. 
            In Redaction Settings, a data controller can hide sensitive information from the call transcriptions, and there are three options: 
            (i) Credit Card Protection, (ii) Personal Information Protection, and (iii) Strict Redaction.
        </li>
    </ul>

    <p class="mb-3"><strong>Sub-Processor Management:</strong> Any third parties we engage to assist with data processing are carefully vetted and bound by the same data protection standards we maintain. We enter into Data Processing Addendums with the sub-processors, including Standard Contractual Clauses. Data Controllers are notified of the addition of sub-processor relationships via email, and have the right to object within the timeframes mentioned in the Data Processing Addendum.</p>

    <p class="mb-4"><strong>Privacy by Design Implementation:</strong> Our product development process now includes data protection impact assessments for new features that involve high-risk processing including AI Features. This ensures data protection considerations are built into our systems from the ground up rather than added as an afterthought.</p>

    <h3 class="mb-3 custom-heading">Data Subject Rights Support</h3>
    <p class="mb-4">
        As a data processor, LeadMine.pro assists data controllers in fulfilling their obligations to respond to data subject requests. We provide technical and administrative support to help data controllers address requests as provided in GDPR.
    </p>
    <p class="mb-4">
        Please note that LeadMine.pro, as a data processor, does not directly handle data subject requests. All such requests are directed to the relevant data controller. We assist data controllers in fulfilling their obligations to respond to these requests.
    </p>

    <h3 class="mb-3 custom-heading">International Data Transfer</h3>
    <p class="mb-4">
        LeadMine.pro is based and hosted in the United States, and all call recordings and related personal data are stored in US-based data centers that employ industry-standard security measures to protect the Customer’s Data. As our processing infrastructure is located outside the European Economic Area, we ensure that appropriate safeguards are implemented for all international data transfers, including the use of Standard Contractual Clauses.
    </p>

    <h3 class="mb-3 custom-heading">Technical and Organizational Measures</h3>
    <p class="mb-4">
        LeadMine.pro maintains a comprehensive security and governance framework that protects Customer Data through multiple layers of technical and organizational measures. Our security infrastructure employs current TLS encryption standards for all data transmissions, industry-standard encryption for data at rest, role-based access controls that limit personnel access on a need-to-know basis for their job functions, and continuous monitoring systems that detect unusual access patterns and potential security threats.
    </p>
    <p class="mb-4">
        All processing activities and our GDPR obligations are overseen by our Data Protection Officer, who monitors compliance, provides GDPR guidance, and serves as our primary contact for data protection matters. Every employee with access to personal data undergoes background checks, signs employment agreements with confidentiality clauses, acknowledges Security, Compliance, and Privacy policies on an annual basis, and participates in comprehensive GDPR training programs with regular refresher sessions.
    </p>
    <p class="mb-4">
        For more information on our technical and organizational measures, please visit the LeadMine.pro Trust Center.
    </p>

    <h3 class="mb-3 custom-heading">Contact Information</h3>
    <p>
        If you have any questions about this Statement, or our privacy or security practices, please contact us:<br>
        <strong>Email:</strong> {{ config('app.email_id') }}
    </p>
</div>

                            
<!-- Referral Program Terms -->
<div class="tab-pane fade" id="referral" role="tabpanel" aria-labelledby="referral-tab">
  <h2 class="mb-4 heading-medium as-h2">Leadmine.pro Referral Program Terms</h2>

  <p>These Leadmine.pro Referral Program Terms (hereinafter, the “Referral Terms”) govern your participation in the Leadmine.pro Referral Program. These Referral Terms are subject to and governed by the Leadmine.pro Terms and Conditions or any other MSA entered between the referring party (referred to as “You” or “Referrer”), and SaaS Labs US, Inc. (referred to as “Leadmine.pro” or “SaaS Labs”).</p>

  <p>Leadmine.pro and the Referrer together are referred to as “Parties” and singularly as “Party”.</p>

  <p>Leadmine.pro reserves the right, at its sole discretion, to prohibit any Referrer and Referee from participating or further participating in any aspect of the Leadmine.pro Referral Program if Leadmine.pro deems or suspects that such Referrer and Referee has engaged in or has attempted to engage in any of the following activities: (a) acting in violation of the Terms of the Leadmine.pro Customer Referral Program or the Leadmine.pro Terms and Conditions; (b) damaging, tampering with, or corrupting the operation of the Leadmine.pro Referral Program; (c) any conduct or activity of the Referrer deemed in the sole discretion of Leadmine.pro to be generally inconsistent with the intended operation of the Leadmine.pro Referral Program. Leadmine.pro shall be the sole determiner in cases of suspected abuse, fraud, or breach of these Terms or intent of these Terms.</p>

  <h3 class="sub-heading mt-4 mb-3">1. Definitions</h3>
  <p><strong>“Affiliate”</strong> means any entity existing from time to time that directly or indirectly controls, is controlled by, or is under common control with the subject entity.</p>
  <p><strong>“Customer”</strong> means the Referee that has entered into a valid agreement with Leadmine.pro to procure the Service originating through the Referral Link.</p>
  <p><strong>“Eligible Subscription Plan”</strong> means a paid subscription with Leadmine.pro on the Team Plan or above that is active and in good standing for a minimum of ninety (90) days from the initial sign-up and subscribed on the List Price.</p>
  <p><strong>“Referrer”</strong> refers to existing customers of Leadmine.pro with a primary place of business in any territory that is a business, entity, or other individuals with a valid tax ID number, and has an active Leadmine.pro account in good standing for a minimum of ninety (90) days from the initial sign-up.</p>
  <p><strong>“Referee”</strong> refers to the lead referred by the Referrer with a primary place of business in any territory that is a business, entity, or other individuals with a valid tax ID, and does not include Ineligible Referral.</p>
  <p><strong>“Referral Link”</strong> means the unique URL which is provided by Leadmine.pro to the Referrer.</p>
  <p><strong>“Services”</strong> means the Leadmine.pro services generally sold by Leadmine.pro and further described here: <a href="https://www.leadmine.pro" target="_blank">www.leadmine.pro</a>.</p>

  <h3 class="sub-heading mt-4 mb-3">2. Overview of the Program</h3>
  <p>2.1 The Referrer and the Referee are eligible to receive a promotional gift card (“Gift Card”) only if the Referee clicks on the Referral Link to create a Leadmine.pro account that complies with the Leadmine.pro Terms and Conditions, and subscribes to an Eligible Subscription Plan.</p>
  <p>2.2 Ineligible Referral includes leads (a) who were customers of Leadmine.pro before the referral; (b) leads that are in Leadmine.pro’s active sales pipeline at the time of the referral or were in the process sixty (60) days before the referral submission; (c) leads which are the Referrer itself or an entity that the Referrer owns or is employed in; (d) an Affiliate of the Referrer or the Referrer is an Affiliate of the lead; and (e) leads that create a Leadmine.pro account without using the Referral Link.</p>
  <p>2.3 Once verified, the Referrer shall receive a Gift Card worth (a) USD 100 if the Referee subscribes to a monthly Eligible Subscription Plan or (b) USD 200 if the Referee subscribes to an annual Eligible Subscription Plan. The maximum value that can be earned per user per month will be USD 2,500.</p>
  <p>2.4 The Referee shall receive a Gift Card worth (a) USD 50 for monthly plans or (b) USD 100 for annual plans after verification. Both Referrer and Referee accounts must be active and in good standing.</p>
  <p>2.5 The Gift Card will be sent to the registered email address associated with the Leadmine.pro account and will remain valid for six (6) months from the date of issue.</p>
  <p>2.6 Referrers must not post Referral Links on adult, obscene, defamatory, or illegal websites, or spam channels. Any such violation may result in termination of participation.</p>
  <p>2.7 In case of multiple Referral Links, only the Referrer associated with the link used for signup will be eligible for rewards.</p>

  <h3 class="sub-heading mt-4 mb-3">3. Term and Termination</h3>
  <p>The term of the Referral Terms begins when the Referrer shares or the Referee uses the Referral Link. Leadmine.pro reserves the right to terminate participation at any time with written notice. Only referrals made before termination will be processed.</p>

  <h3 class="sub-heading mt-4 mb-3">4. Trademarks</h3>
  <p>Each Party retains all rights to its own trademarks and logos. Referrer may not use Leadmine.pro’s trademarks without prior written consent.</p>

  <h3 class="sub-heading mt-4 mb-3">5. Indemnification</h3>
  <p>The Referrer agrees to indemnify and hold harmless Leadmine.pro, its affiliates, directors, officers, and employees against all liabilities, damages, and costs arising out of Referrer’s participation in the Leadmine.pro Referral Program or breach of these Referral Terms.</p>

  <h3 class="sub-heading mt-4 mb-3">6. Disclaimers; Limitation of Liability</h3>
  <p>Each Party disclaims all express or implied warranties, including but not limited to non-infringement, merchantability, and fitness for a purpose. Leadmine.pro does not guarantee any results from the Referral Program. In no event will either Party be liable for indirect, incidental, or consequential damages arising out of this Agreement.</p>

  <h3 class="sub-heading mt-4 mb-3">7. General</h3>
  <p>This Agreement shall be governed by the laws of the State of Delaware, USA. Leadmine.pro may update these terms from time to time. The Parties are independent contractors, and nothing herein creates a partnership or agency. Notices must be sent to <a href="mailto:sales@leadmine.pro">{{ config('app.email_id') }}</a>.</p>
</div>

<style>
  #referral {
    font-family: "Inter", "Roboto", sans-serif;
    color: #333;
    line-height: 1.6;
  }

  #referral h2,
  #referral h3 {
    font-family: "Poppins", "Inter", sans-serif;
    font-weight: 600;
    color: #1b1c4d;
    font-size: 1.5rem;
  }

  #referral p {
    font-size: 1rem;
    margin-bottom: 1rem;
  }

  #referral a {
    color: #007bff;
    text-decoration: underline;
  }
</style>



                           
                            </div>
                        </div>    
                    </div> 
                </div> 
            </div>  
        </div>  
    </section>
 </div>  
 @endsection 