@extends('website.layout')

@section('meta')
    <title>Real Estate & Mortgage AI Intelligence | {{ config('app.site') }}</title>

    <meta name="description" content="Boost real estate and mortgage workflows with AI intelligence - automate lead calls, client follow-ups, and customer communication with ease.">

    <meta name="keywords" content="AI real estate automation, mortgage AI solutions, AI lead calls for real estate, client follow-up automation, real estate communication AI">

    {{-- Open Graph --}}
    <meta property="og:title" content="Real Estate & Mortgage AI Intelligence | {{ config('app.site') }}">
    <meta property="og:description" content="Boost real estate and mortgage workflows with AI intelligence - automate lead calls, client follow-ups, and customer communication with ease.">
    <meta property="og:image" content="{{ asset('web/assets/images/real-estate-service-hero-ab.webp') }}">
    <meta property="og:type" content="website">
    <meta property="og:url" content="{{ url()->current() }}">

    {{-- Twitter / X --}}
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Real Estate & Mortgage AI Intelligence | {{ config('app.site') }}">
    <meta name="twitter:description" content="Boost real estate and mortgage workflows with AI intelligence - automate lead calls, client follow-ups, and customer communication with ease.">
    <meta name="twitter:image" content="{{ asset('web/assets/images/real-estate-service-hero-ab.webp') }}">

@endsection



 @section('content')
<style>
.custom-img {
  margin-top: 180px;
}

 .paragraph-style {
  font-weight: 400;
  font-size: 18px;
}

.custom-heading {
  font-weight: 400;  
}

.max-width-40 {
  max-width: 40%;
}

@media (max-width: 768px) {
  .custom-img {
    margin-top: 50px;
  }
}
.pt-40 {
  padding-top: 40px;
}
.img-auto-warranty {
  max-height: 500px;
  width: 100%;
  object-fit: contain;
}

.img-deal-maxwidth{
  max-width: 35%;
}
.custom-padding-100 {
  padding: 100px 0;
}
.img-pitch-maxwidth {
  max-width: 30%;
}
.visually-hidden {
    position: absolute;
    width: 1px;
    height: 1px;
    padding: 0;
    margin: -1px;
    overflow: hidden;
    clip: rect(0, 0, 0, 0);
    white-space: nowrap;
    border: 0;
}
.as-h2 {
 font-size: clamp(1.5rem, 0.5569rem + 1.444vw, 1.875rem);
 }

.tw-mb-1{
 font-size: clamp(1.125rem, 1.2rem + 0.722vw, 1.5rem);
 }
</style>
 <!-- <section class="section-bg-two pb-50 overflow-hidden pt-40">
     <div class="container max-w-1290-px">
         <div class="row gy-5 align-items-center justify-content-center text-center">
             <div class="col-xl-12">
                 <div>
                     <div class="mx-auto tw-mb-12">
                          <h1 class="visually-hidden">Real Estate & Mortgage Intelligence</h1>
                         <h3 class="splitTextStyleOne text-heading heading-medium">
                             Real Estate & Mortgage Intelligence
                         </h3>
                         <p class="text-neutral-500 tw-mt-2 splitTextStyleOne max-w-770-px tw-text-lg mx-auto">
                             With real-time dashboards and performance scorecards, managers get a clear view of which
                             agents are driving deals—and who needs coaching.
                         </p>
                         <div class="tw-mt-2" data-aos="fade-up" data-aos-anchor-placement="top-bottom"
                             data-aos-duration="900">
                             <a href="{{ route('register') }}"
                                 class="hover--translate-y-1 active--translate-y-scale-9 btn button--stroke tw-gap-5 group active--translate-y-2 tw-rounded-xl text-capitalize tw-px-8 tw-py-505 fw-medium btn-main hover-style-one"
                                 data-block="button">
                                 <span class="button__flair"></span>
                                 <span class="button__label">Get started</span>
                             </a>
                         </div>
                     </div>
                 </div>
             </div>
         </div>
     </div>
 </section> -->
<section class="hero-section">
  <div class="hero-container">
    <div class="hero-left">
      <h1>
        <span>Double Your Property</span>
        <span>Bookings in Half the Time</span>
      </h1>
      <p>
        Effortlessly connect with and engage your clients using outreach dialers, workflow automations, 
        and actionable AI insights — all in LeadMine.pro.
      </p>
      <div class="hero-badges">
        <span><i class="fa fa-check-circle"></i> No credit card required</span>
        <span><i class="fa fa-check-circle"></i> 14 days of LeadMine.pro AI on us</span>
      </div>
    </div>

  <div class="hero-right">
  <div class="hero-img-wrapper">
    <img src="web/assets/images/real-estate-service-hero-ab.webp" alt="AI real estate virtual assistant scheduling property meetings">

    <div class="agent-status">
      <div class="status-text">Available</div>
    </div>

    <div class="chat-box main">
      “May I schedule a meeting to discuss your property needs and goals?
      How does next week sound?”
    </div>


        
      </div>
    </div>
  </div>
</section>


<style>
.hero-right {
  margin-left: 2px;
}

.hero-img-wrapper {
  margin-left: 30px;
  position: relative;
}


.chat-box.main {
margin-left: 40px; background: #3b82f6; color: white; padding: 25px 25px; border-radius: 18px; max-width: 340px;
}

.hero-section {
  background: linear-gradient(180deg, #ffe3df 0%, #fff5f3 100%);
  padding: 90px 0;
  font-family: "Inter", sans-serif;
}


.hero-container {
  max-width: 1250px;
  margin: auto;
  display: flex;
  align-items: center;
  justify-content: space-between;
  gap: 70px;
  flex-wrap: wrap;
}


.hero-left {
  flex: 1 1 520px;
}


.hero-left h1 {
  font-size: 40px;
  line-height: 1.25;
  color: #1c2250;
  font-weight: 800;
  margin-bottom: 25px;
  max-width: 480px;
  white-space: normal;
}

.hero-left h1 span {
  display: block;
}

.hero-left p {
  font-size: 18px;
  line-height: 1.7;
  color: #2b2b2b;
  margin-bottom: 35px;
  max-width: 500px;
}


.hero-badges {
  display: flex;
  flex-wrap: wrap;
  gap: 20px;
  font-size: 16px;
  color: #1c2250;
}

.hero-badges i {
  color: #3774f8;
  margin-right: 6px;
}


.hero-right {
  flex: 1 1 550px;
  display: flex;
  justify-content: flex-start; 
  position: relative;
}

.hero-img-wrapper {
  position: relative;
  border-radius: 20px;
  overflow: hidden;
  width: 100%;
  max-width: 540px;
  box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
}

.hero-img-wrapper img {
  width: 100%;
  display: block;
  object-fit: cover;
}

/* Agent Status */
.agent-status {
  position: absolute;
  top: 20px;
  left: 20px;
  display: flex;
  align-items: center;
  background: #fff;
  border-radius: 50px;
  padding: 4px 10px 4px 4px;
  box-shadow: 0 2px 8px rgba(0,0,0,0.15);
}

.agent-status img {
  width: 32px;
  height: 32px;
  border-radius: 50%;
  margin-right: 6px;
}

.status-text {
  background: #e7f9ed;
  color: #0e8a4a;
  font-size: 13px;
  font-weight: 600;
  border-radius: 6px;
  padding: 3px 8px;
}

/* Chat bubbles */
.chat-box {
  position: absolute;
  font-size: 15px;
  line-height: 1.45;
  border-radius: 16px;
  padding: 16px 18px;
  max-width: 310px;
  box-shadow: 0 6px 12px rgba(0,0,0,0.12);
}

.chat-box.main {
  background: #3774f8;
  color: #fff;
  bottom: 110px;
  left: -35px;
}

.chat-box.reply {
  background: #fff;
  color: #000;
  bottom: 40px;
  right: 40px;
}

/* Responsive */
@media (max-width: 992px) {
  .hero-container {
    flex-direction: column;
    text-align: center;
  }

  .hero-left h1 {
    font-size: 34px;
    max-width: 100%;
  }

  .hero-left p {
    margin: 0 auto 30px;
  }

  .hero-badges {
    justify-content: center;
  }

  .hero-img-wrapper {
    margin-top: 40px;
  }

  .chat-box.main,
  .chat-box.reply {
    position: static;
    margin: 10px auto;
    display: block;
  }
}
</style>

<section class="about-two py-50 position-relative z-1 overflow-hidden">
  <img src="web/assets/images/bg/mash-gradient-bg3.webp" alt="Gradient" class="position-absolute tw-start-0 top-0 z-n1">

  <div class="container">
    <div class="row gy-4 flex-wrap-reverse">
      <div class="col-lg-6">
        <img src="web/assets/images/thumbs/real-estate.webp" alt="real-estate" loading="lazy" class="custom-img img-auto-warranty">
      </div>

      <div class="col-lg-6">
        <div class="ps-xl-5">
          <div class="tw-mb-6">
            <h2 class="tw-mb-2 line-clamp-2 font-caveat text-crm heading-medium as-h2">
              Attributes for Real Estate & Mortgage
            </h2>
            <p class="splitTextStyleOne text-neutral-500 tw-mt-2 max-w-570-px paragraph-style">
              Prioritize high-quality leads and empower your agents with AI-driven insights throughout
              the sales process.
            </p>
          </div>

          <div class="accordion common-accordion" id="accordionExample">

            <!-- Scale client outreach -->
            <div class="accordion-item tw-px-40-px tw-rounded-xl section-bg-one border-0 tw-mb-6">
              <h3 class="accordion-header">
                <button class="accordion-button tw-py-6 shadow-none px-0 bg-transparent h5" 
                        type="button" data-bs-toggle="collapse" data-bs-target="#scaleOutreach" 
                        aria-expanded="true" aria-controls="scaleOutreach">
                  📞 Scale client outreach with flexible dialers
                </button>
              </h3>
              <div id="scaleOutreach" class="accordion-collapse collapse show" data-bs-parent="#accordionExample">
                <div class="accordion-body ps-0 pt-0 pe-0 tw-pb-6">
                  <p class="text-neutral-500 mb-3">
                    Auto-dial client lists, skip answering machines, and connect with 3x more clients in half the time using Leadmine’s Auto, Dynamic, and Predictive Dialers — perfect for warm and cold lead lists alike.
                  </p>
                  <a href="{{ route('register') }}" class="btn btn-primary btn-sm">Start Free Trial</a>
                </div>
              </div>
            </div>

            <!-- Have more meaningful prospecting conversations -->
            <div class="accordion-item tw-px-40-px tw-rounded-xl section-bg-one border-0 tw-mb-6">
              <h3 class="accordion-header">
                <button class="accordion-button tw-py-6 shadow-none px-0 bg-transparent h5 collapsed" 
                        type="button" data-bs-toggle="collapse" data-bs-target="#prospectingConversations" 
                        aria-expanded="false" aria-controls="prospectingConversations">
                  💬 Have more meaningful prospecting conversations
                </button>
              </h3>
              <div id="prospectingConversations" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                <div class="accordion-body ps-0 pt-0 pe-0 tw-pb-6">
                  <p class="text-neutral-500 mb-3">
                    Get contextual AI suggestions for objection handling on live calls. Automate follow-ups with one-click voicemails and call outcome-based SMS workflows. More meaningful prospecting, stronger pipeline for your property listings.
                  </p>
                  <a href="{{ route('register') }}" class="btn btn-primary btn-sm">Start Free Trial</a>
                </div>
              </div>
            </div>

            <!-- Monitor and assist your agents in real-time -->
            <div class="accordion-item tw-px-40-px tw-rounded-xl section-bg-one border-0 tw-mb-6">
              <h3 class="accordion-header">
                <button class="accordion-button tw-py-6 shadow-none px-0 bg-transparent h5 collapsed" 
                        type="button" data-bs-toggle="collapse" data-bs-target="#monitorAgents" 
                        aria-expanded="false" aria-controls="monitorAgents">
                  🎧 Monitor and assist your agents in real-time
                </button>
              </h3>
              <div id="monitorAgents" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                <div class="accordion-body ps-0 pt-0 pe-0 tw-pb-6">
                  <p class="text-neutral-500 mb-3">
                    Monitor live calls without being in the same room. Whisper suggestions to your reps discreetly, or jump in to assist on high-value property deals.
                  </p>
                  <a href="{{ route('register') }}" class="btn btn-primary btn-sm">Start Free Trial</a>
                </div>
              </div>
            </div>

            <!-- Identify coaching gaps with AI call scoring -->
            <div class="accordion-item tw-px-40-px tw-rounded-xl section-bg-one border-0 tw-mb-6">
              <h3 class="accordion-header">
                <button class="accordion-button tw-py-6 shadow-none px-0 bg-transparent h5 collapsed" 
                        type="button" data-bs-toggle="collapse" data-bs-target="#aiCallScoring" 
                        aria-expanded="false" aria-controls="aiCallScoring">
                  🧠 Get actionable insights on agent performance using AI
                </button>
              </h3>
              <div id="aiCallScoring" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                <div class="accordion-body ps-0 pt-0 pe-0 tw-pb-6">
                  <p class="text-neutral-500 mb-3">
                    Get actionable insights to drive coaching wins. Quickly review conversations with automatic call scores, customer sentiment analysis, key topics, and action items to share contextual feedback and upskill your reps.
                  </p>
                  <a href="{{ route('register') }}" class="btn btn-primary btn-sm">Start Free Trial</a>
                </div>
              </div>
            </div>

          </div> <!-- /accordion -->

        </div>
      </div>

    </div>
  </div>
</section>



    
        <!-- ================== Driven section Start ====================== -->
        <section class="py-50">
            <div class="container">
                <div class="">
                    <img src="web/assets/images/thumbs/driven-img.webp" alt="driven-img" loading="lazy">
                    <div class="max-w-780-px text-center mx-auto tw-mb-13">
                        <h3 class="splitTextStyleOne text-heading text-capitalize text-capitalize heading-medium">
                            Driven your business today next level by {{ config('app.site') }}
                        </h3>
                        <div class="d-flex align-items-center tw-gap-4 justify-content-center tw-mt-10">
                            <a href="{{ route('register') }}" class="hover--translate-y-1 active--translate-y-scale-9 btn button--stroke tw-gap-5 group active--translate-y-2 tw-rounded-xl text-capitalize tw-px-8 tw-py-505 fw-medium btn btn-main hover-style-one" data-block="button">
                                <span class="button__flair"></span>
                                <span class="button__label">get started </span>
                            </a>

                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- ================== Driven section End ====================== -->



 <!-- ================== Pricing Plan one End ====================== -->



 @endsection