@extends('website.layout')

@section('meta')
    <title>AI Technology Solutions & Automation | {{ config('app.site') }}</title>

    <meta name="description" content="Discover {{ config('app.site') }}’s AI technology solutions and automation tools that streamline customer communication, boost efficiency, and enhance overall business operations.">

    <meta name="keywords" content="AI technology solutions, business automation tools, AI communication automation, workflow automation AI, customer engagement technology">

    {{-- Open Graph --}}
    <meta property="og:title" content="AI Technology Solutions & Automation | {{ config('app.site') }}">
    <meta property="og:description" content="Discover {{ config('app.site') }}’s AI technology solutions and automation tools that streamline customer communication, boost efficiency, and enhance overall business operations.">
    <meta property="og:image" content="{{ asset('web/assets/images/tech.webp') }}">
    <meta property="og:type" content="website">
    <meta property="og:url" content="{{ url()->current() }}">

    {{-- Twitter / X --}}
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="AI Technology Solutions & Automation | {{ config('app.site') }}">
    <meta name="twitter:description" content="Discover {{ config('app.site') }}’s AI technology solutions and automation tools that streamline customer communication, boost efficiency, and enhance overall business operations.">
    <meta name="twitter:image" content="{{ asset('web/assets/images/tech.webp') }}">
    
@endsection




 @section('content')
<style>
.custom-img {
  margin-top: 180px;
}

 .paragraph-style {
  font-weight: 400;
  font-size: 18px;
}

.custom-heading {
  font-weight: 400;  
}

.max-width-40 {
  max-width: 40%;
}

@media (max-width: 768px) {
  .custom-img {
    margin-top: 50px;
  }
}
.pt-40 {
  padding-top: 40px;
}
.img-auto-warranty {
  max-height: 500px;
  width: 100%;
  object-fit: contain;
}

.img-deal-maxwidth{
  max-width: 35%;
}
.custom-padding-100 {
  padding: 100px 0;
}
.img-pitch-maxwidth {
  max-width: 30%;
}
.visually-hidden {
    position: absolute;
    width: 1px;
    height: 1px;
    padding: 0;
    margin: -1px;
    overflow: hidden;
    clip: rect(0, 0, 0, 0);
    white-space: nowrap;
    border: 0;
}
.as-h2 {
 font-size: clamp(1.5rem, 0.5569rem + 1.444vw, 1.875rem);
 }

.tw-mb-1{
 font-size: clamp(1.125rem, 1.2rem + 0.722vw, 1.5rem);
 }
</style>
 <!-- <section class="section-bg-two pb-50 overflow-hidden pt-40">
     <div class="container max-w-1290-px">
         <div class="row gy-5 align-items-center justify-content-center text-center">
             <div class="col-xl-12">
                 <div>
                     <div class="mx-auto tw-mb-12">
                          <h1 class="visually-hidden">Real Estate & Mortgage Intelligence</h1>
                         <h3 class="splitTextStyleOne text-heading heading-medium">
                             Real Estate & Mortgage Intelligence
                         </h3>
                         <p class="text-neutral-500 tw-mt-2 splitTextStyleOne max-w-770-px tw-text-lg mx-auto">
                             With real-time dashboards and performance scorecards, managers get a clear view of which
                             agents are driving deals—and who needs coaching.
                         </p>
                         <div class="tw-mt-2" data-aos="fade-up" data-aos-anchor-placement="top-bottom"
                             data-aos-duration="900">
                             <a href="{{ route('register') }}"
                                 class="hover--translate-y-1 active--translate-y-scale-9 btn button--stroke tw-gap-5 group active--translate-y-2 tw-rounded-xl text-capitalize tw-px-8 tw-py-505 fw-medium btn-main hover-style-one"
                                 data-block="button">
                                 <span class="button__flair"></span>
                                 <span class="button__label">Get started</span>
                             </a>
                         </div>
                     </div>
                 </div>
             </div>
         </div>
     </div>
 </section> -->
<section class="hero-section">
  <div class="hero-container">
    <div class="hero-left">
      <h1>
        Modern Platform for Rapidly Evolving Tech Teams
      </h1>
      <p>
        Upgrade your customer communications with a flexible platform that grows with your business. Bring your team together, integrate with your tech stack to access customer information, set up workflows, and train your team with AI.
      </p>
      <div class="hero-badges">
        <span><i class="fa fa-check-circle"></i> No credit card required</span>
        <span><i class="fa fa-check-circle"></i> 14 days of AI tools on us</span>
      </div>
    </div>

    <div class="hero-right">
      <div class="hero-image-wrapper">
        <img src="web/assets/images/tech.webp" alt="Modern AI platform for tech teams managing customer communication">

    
      </div>
    </div>
  </div>
</section>

<style>
.hero-section {
  background: linear-gradient(180deg, #f2f4ff 0%, #ffffff 100%);
  padding: 100px 0;
  font-family: "Inter", sans-serif;
}

.hero-container {
  max-width: 1250px;
  margin: auto;
  display: flex;
  align-items: center;
  justify-content: space-between;
  flex-wrap: wrap;
  gap: 70px;
}

.hero-left {
  flex: 1 1 520px;
}

.hero-left h1 {
  font-size: 46px;
  font-weight: 800;
  color: #1b1f3b;
  line-height: 1.25;
  margin-bottom: 25px;
  max-width: 500px;
}

.hero-left p {
  font-size: 18px;
  line-height: 1.7;
  color: #2b2b2b;
  margin-bottom: 35px;
  max-width: 520px;
  font-family: "Poppins", sans-serif; 
}

.hero-badges {
  display: flex;
  flex-wrap: wrap;
  gap: 20px;
  font-size: 16px;
  color: #1b1f3b;
}

.hero-badges i {
  color: #3b82f6;
  margin-right: 8px;
}

/* Right Side */
.hero-right {
  flex: 1 1 520px;
  display: flex;
  justify-content: center;
  position: relative;
}

.hero-image-wrapper {
  position: relative;
  width: 100%;
  max-width: 540px;
  border-radius: 20px;
  overflow: hidden;
  box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
}

.hero-image-wrapper img {
  width: 100%;
  display: block;
  object-fit: cover;
}

/* Agent Card */
.agent-card {
  position: absolute;
  top: 30px;
  left: 30px;
  background: #fff;
  border-radius: 16px;
  box-shadow: 0 6px 18px rgba(0, 0, 0, 0.1);
  padding: 16px 18px;
  max-width: 280px;
  border: 1px solid #e5e9ff;
}

.agent-card h4 {
  font-size: 15px;
  font-weight: 700;
  color: #1c2250;
  margin-bottom: 10px;
}

.agent-tabs {
  display: flex;
  gap: 6px;
  margin-bottom: 10px;
}

.agent-tabs .tab {
  flex: 1;
  font-size: 13px;
  text-align: center;
  padding: 6px 0;
  border-radius: 6px;
  background: #eef1ff;
  color: #4a4e74;
  font-weight: 600;
}

.agent-tabs .tab.active {
  background: #3b82f6;
  color: #fff;
}

.agent-message {
  font-size: 14px;
  color: #2b2b2b;
  background: #f9faff;
  padding: 12px;
  border-radius: 10px;
  line-height: 1.5;
  margin-bottom: 10px;
}

.agent-feedback {
  display: flex;
  justify-content: space-between;
  font-size: 13px;
  color: #3b82f6;
  font-weight: 600;
}

/* Responsive */
@media (max-width: 992px) {
  .hero-container {
    flex-direction: column;
    text-align: center;
  }

  .hero-left h1 {
    font-size: 36px;
    max-width: 100%;
  }

  .hero-left p {
    margin: 0 auto 30px;
  }

  .hero-badges {
    justify-content: center;
  }

  .hero-image-wrapper {
    margin-top: 40px;
  }

  .agent-card {
    position: static;
    margin: 20px auto 0;
  }
}

.secure-section {
  background: linear-gradient(180deg, #f2f4ff 0%, #ffffff 100%);
  padding: 100px 0;
  font-family: "Poppins", sans-serif; 
}

.secure-container {
  max-width: 1250px;
  margin: auto;
  display: flex;
  align-items: center;
  justify-content: space-between;
  flex-wrap: wrap;
  gap: 70px;
}

.secure-left {
  flex: 1 1 520px;
}

.secure-left h1 {
  font-size: 42px;
  font-weight: 800;
  color: #1b1f3b;
  line-height: 1.25;
  margin-bottom: 25px;
  max-width: 500px;
}

.secure-left p {
  font-size: 18px;
  line-height: 1.8;
  color: #2b2b2b;
  margin: 20px 0 30px 0; 
  max-width: 520px;
}

.secure-badges {
  display: flex;
  flex-wrap: wrap;
  gap: 20px;
  font-size: 16px;
  color: #1b1f3b;
}

.secure-badges i {
  color: #3b82f6;
  margin-right: 8px;
}

/* Right Side */
.secure-right {
  flex: 1 1 520px;
  display: flex;
  justify-content: center;
  position: relative;
}

.secure-image-wrapper {
  position: relative;
  width: 100%;
  max-width: 540px;
  border-radius: 20px;
  overflow: hidden;
  box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
  background: #fff;
}

.secure-image-wrapper img {
  width: 100%;
  display: block;
  object-fit: cover;
}


@media (max-width: 992px) {
  .secure-container {
    flex-direction: column;
    text-align: center;
  }

  .secure-left h1 {
    font-size: 34px;
    max-width: 100%;
  }

  .secure-left p {
    margin: 20px auto 30px; 
  }

  .secure-badges {
    justify-content: center;
  }

  .secure-image-wrapper {
    margin-top: 40px;
  }
}

</style>

<section class="toolkit-section py-5">
  <div class="container">
    <h4 class="text-center mb-5 fw-bold">Platform designed to accelerate your growth</h4>

    <div class="toolkit-grid">
      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-chart-line"></i></div>
        <h4>AI Analytics</h4>
        <p>Assess every customer call with instant, AI-generated intelligence and derive actionable insights.</p>
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-link"></i></div>
        <h4>CRM Integrations</h4>
        <p>No more app-switching with seamless integrations into popular CRM and Helpdesk tools.</p>
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-phone"></i></div>
        <h4>IVR</h4>
        <p>Set up an interactive menu. Allow digit-based customer inputs to route calls to respective teams.</p>
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-user-shield"></i></div>
        <h4>Roles and Permissions</h4>
        <p>Set up roles, control user access, and limit it to key functions. Prevent accidental data changes.</p>
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-route"></i></div>
        <h4>Intelligent Routing</h4>
        <p>Automatically route calls to the customer's contact owner in the CRM.</p>
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-user-clock"></i></div>
        <h4>Agent Availability</h4>
        <p>Monitor your team’s status and see the real-time availability of your agents in one place.</p>
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-headset"></i></div>
        <h4>After Call Work</h4>
        <p>Clearly mark the outcome of a call with call disposition. Let AI take care of the manual note-taking.</p>
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-phone-volume"></i></div>
        <h4>Dialers</h4>
        <p>Upload contact lists & automate number dialing. Connect agents only when the call is answered.</p>
      </div>
    </div>
  </div>
</section>

<!-- Font Awesome -->
<script src="https://kit.fontawesome.com/a2d9a67a2b.js" crossorigin="anonymous"></script>

<style>
.toolkit-section {
  background: #f7f7f9; 
  font-family: 'Poppins', sans-serif;
}

.toolkit-grid {
  display: grid;
  grid-template-columns: repeat(auto-fit, minmax(270px, 1fr));
  gap: 25px;
}

.toolkit-item {
  background: #fff;
  border: 1px solid #e5e7eb;
  border-radius: 12px;
  padding: 28px 24px;
  box-shadow: 0 4px 12px rgba(0,0,0,0.04);
  transition: all 0.3s ease;
  cursor: pointer;
}

.toolkit-item:hover {
  border-color: #3b82f6;
  box-shadow: 0 8px 22px rgba(59,130,246,0.1);
  transform: translateY(-4px);
}


.toolkit-item .icon {
  font-size: 30px;
  color: #0a5bff;
  margin-bottom: 18px;
}


.toolkit-item h4 {
  font-size: 18px;
  font-weight: 600;
  margin-bottom: 10px;
  color: #000;
}

.toolkit-item p {
  font-size: 15px;
  color: #444;
  line-height: 1.6;
}

@media (max-width: 768px) {
  .toolkit-item {
    padding: 22px 18px;
  }
}
</style>


<section class="secure-section">
  <div class="secure-container">
    <!-- Left Text -->
    <div class="secure-left">
      <h3>Secure and Compliant</h3>
      <p>
        We safeguard your data with enterprise-grade security policies including, but not limited to, single sign-on (SSO), two-factor authentication (2FA), AES 256 encryption, and role-based access controls. Leadmine.pro also complies with industry standards such as SOC 2 Type 2, GDPR, ISO 27001, HIPAA, and PCI-DSS.
      </p>
      <div class="secure-badges">
        <span><i class="fa fa-lock"></i> AES 256 Encryption</span>
        <span><i class="fa fa-shield"></i> SOC 2 Type 2 Compliant</span>
      </div>
    </div>

    <!-- Right Image -->
    <div class="secure-right">
      <div class="secure-image-wrapper">
        <img src="web/assets/images/secure.webp" alt="Secure and compliant data protection system with encryption">
      </div>
    </div>
  </div>
</section>


    
      <section class="integrations-section">
  <div class="container">
    <h2 class="section-title">Fits seamlessly into your tech stack</h2>

    <div class="integration-logos">
      <div class="logo-box">
        <img src="web/assets/images/hubspot.svg" alt="HubSpot">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/salesforce.svg" alt="Salesforce">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/pipedrive.svg" alt="Pipedrive">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/slack.svg" alt="Slack">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/intercom.svg" alt="Intercom">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/zendesk-icon.svg" alt="Zendesk">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/zoho.svg" alt="Zoho">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/outreach.webp" alt="Outreach">
      </div>
    </div>

    <div class="btn-wrapper">
      <a href="{{ route('register') }}" class="view-btn">Start free trial</a>
    </div>
  </div>
</section>


<style>
.integrations-section {
  text-align: center;
  padding: 80px 20px;
  background-color: #fff;
}

.integrations-section .section-title {
  font-size: 32px;
  font-weight: 700;
  color: #0b0c2a;
  margin-bottom: 50px;
}

.integration-logos {
  display: flex;
  flex-wrap: wrap;
  justify-content: center;
  gap: 25px;
  margin-bottom: 50px;
}

.logo-box {
  width: 140px;
  height: 140px;
  background: #fff;
  border-radius: 20px;
  box-shadow: 0 0 0 1px #e5e7eb;
  display: flex;
  align-items: center;
  justify-content: center;
  transition: all 0.3s ease;
}

.logo-box img {
  width: 60px;
  height: auto;
  transition: transform 0.3s ease;
}

.logo-box:hover {
  transform: translateY(-8px);
  box-shadow: 0 8px 25px rgba(0, 0, 0, 0.08);
}

.logo-box:hover img {
  transform: scale(1.1);
}

.view-btn {
  display: inline-block;
  background-color: #0052ff;
  color: #fff;
  font-weight: 600;
  padding: 14px 28px;
  border-radius: 8px;
  text-decoration: none;
  transition: background 0.3s ease;
}

.view-btn:hover {
  background-color: #003ed6;
}

.btn-wrapper {
  margin-top: 20px;
}
</style>


 <!-- ================== Pricing Plan one End ====================== -->



 @endsection