@extends('website.layout')

@section('meta')
    <title>Terms of Service | {{ config('app.site') }} – Platform Rules & Policies</title>
    <meta name="description" content="Review {{ config('app.site') }}’s terms to understand our service rules, platform policies, and agreements for using our AI-driven call quality solutions.">
    <meta name="keywords" content="{{ config('app.site') }} terms of service">

    {{-- Open Graph --}}
    <meta property="og:title" content="Terms of Service | {{ config('app.site') }} – Platform Rules & Policies">
    <meta property="og:description" content="Review {{ config('app.site') }}’s terms to understand our service rules, platform policies, and agreements for using our AI-driven call quality solutions.">
    <meta property="og:image" content="{{ asset('assets/images/logo/favicon-two.png') }}">
    <meta property="og:type" content="website">
    <meta property="og:url" content="{{ url()->current() }}">

    {{-- Twitter / X --}}
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Terms of Service | {{ config('app.site') }} – Platform Rules & Policies">
    <meta name="twitter:description" content="Review {{ config('app.site') }}’s terms to understand our service rules, platform policies, and agreements for using our AI-driven call quality solutions.">
    <meta name="twitter:image" content="{{ asset('assets/images/logo/favicon-two.png') }}">
@endsection


@section('content')

<style>
.as-h2 {
 font-size: clamp(1.5rem, 0.5569rem + 1.444vw, 1.875rem);
 }

 .table{
      font-size: clamp(1.125rem, 1.2rem + 0.722vw, 1.5rem);
 }

 .tw-mb-5{
     font-size: clamp(1rem, 0.769rem + 0.6813vw, 1.25rem);
 }


.terms-section h1 {
    font-size: 28px !important;     
    line-height: 1.3;
}

.terms-section h2 {
    font-size: 22px;      
    margin-bottom: 10px;
}

.terms-section h3 {
    font-size: 18px;     
    margin-bottom: 8px;
}

.terms-section p {
    font-size: 15px;
    line-height: 1.6;
}


ul.mb-4 {
    list-style-type: disc !important;
    list-style-position: outside !important;
    padding-left: 20px !important;
}

#v-pills-privacy h4 {
    font-size: 20px !important;     
    line-height: 1.3;
}

#v-pills-privacy h5 {
    font-size: 17px !important;  
    line-height: 1.3;
}

</style>

<style>
    .cookie-table {
        table-layout: auto !important;
        width: 100% !important;
        white-space: normal !important;
        word-break: break-word !important;
    }
    .cookie-table th, 
    .cookie-table td {
        white-space: normal !important;
        word-break: break-word !important;
        max-width: 250px;
    }

    .cookie-table td:last-child {
        white-space: normal !important;
        word-break: break-word !important;
    }

    .table-responsive {
        overflow-x: auto;
    }

    ul.ps-4{
    list-style-type: disc !important;
    list-style-position: outside !important;
    padding-left: 20px !important;
    }

    .favicon{
        height: 60px;
    }

    .as-h1{
        font-size:32px;
        font-weight:500;
    }

    .sticky-top{
        top: 20px;
    }

    .as-h2{
      font-size:20px;
    }

    .as-h4{
      font-size:18px;
    }

    .list{
        margin-bottom:2px;
    }

    .as-bold{
        font-size:22px;
    }

    .bold{
        font-size:24px;
    }
</style>


<div id="smooth-content">
    <!-- ==================== Breadcrumb Start Here ==================== -->
    <section class="section-bg-two mb-0 py-5">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-10 text-center">
                    <div class="mb-4">
                        <img src="web/assets/images/favicon-two.png" alt="Favicon" class="img-fluid favicon">
                    </div>
                    <h1 class="mb-3 text-capitalize as-h1">Terms and Agreement</h1>
                    <p class="lead text-muted">Last updated:14 November 2025</p>
                </div>
            </div>
        </div>
    </section>
    <!-- ==================== Breadcrumb End Here ==================== -->

    <!-- ================== Terms and Conditions Start ====================== -->
    <section class="py-5">
        <div class="container">
            <div class="row g-5">
              <div class="col-lg-4">
  <div class="card shadow-sm border-0 sticky-top">
    <div class="card-body p-4">
      <h2 class="mb-4 as-h2">Legal</h2>
     
      <div class="nav flex-column nav-pills" id="v-pills-tab" role="tablist" aria-orientation="vertical">
        
        <button class="nav-link active text-start mb-2" id="v-pills-terms-tab" data-bs-toggle="pill" data-bs-target="#v-pills-terms">
          Terms and Conditions
        </button>
        <button class="nav-link text-start mb-2" id="v-pills-fairusage-tab" data-bs-toggle="pill" data-bs-target="#v-pills-fairusage">
          Fair Usage Policy
        </button>
        <button class="nav-link text-start mb-2" id="v-pills-privacy-tab" data-bs-toggle="pill" data-bs-target="#v-pills-privacy">
          Privacy Policy
        </button>
        <button class="nav-link text-start mb-2" id="v-pills-partner-tab" data-bs-toggle="pill" data-bs-target="#v-pills-partner">
          Integration Partner Program Agreement
        </button>
        <button class="nav-link text-start mb-2" id="v-pills-applicant-tab" data-bs-toggle="pill" data-bs-target="#v-pills-applicant">
          Applicant Privacy Notice
        </button>
        <button class="nav-link text-start mb-2" id="v-pills-cookie-tab" data-bs-toggle="pill" data-bs-target="#v-pills-cookie">
          Cookie Notice
        </button>
        <button class="nav-link text-start mb-2" id="v-pills-refund-tab" data-bs-toggle="pill" data-bs-target="#v-pills-refund">
          Refund Policy
        </button>
        <button class="nav-link text-start mb-2" id="v-pills-disclosure-tab" data-bs-toggle="pill" data-bs-target="#v-pills-disclosure">
          Responsible Disclosure Policy
        </button>
        <button class="nav-link text-start mb-2" id="v-pills-gdpr-tab" data-bs-toggle="pill" data-bs-target="#v-pills-gdpr">
          GDPR Compliance
        </button>
        <button class="nav-link text-start mb-2" id="v-pills-referral-tab" data-bs-toggle="pill" data-bs-target="#v-pills-referral">
          Leadmine.pro Referral Program Terms
        </button>
      </div>
    </div>
  </div>
</div>

                <div class="col-lg-8">
                    <div class="card shadow-sm border-0">
                        <div class="card-body p-4 p-lg-5">
                            <div class="tab-content terms-section" id="v-pills-tabContent">
                       
                                <div class="tab-pane fade show active" id="v-pills-terms" role="tabpanel" aria-labelledby="v-pills-terms-tab">
                                    <h2 class="mb-4 as-h2">Agreement to Our Legal Terms</h2>
                                    <p class="mb-4">We are leadmine.pro, doing business ("Company", "we," "us," "our"), a company registered in New York.</p>

                                    <p class="mb-4">You can contact us by phone at  {{ config('app.phone_number') }}, email at {{ config('app.email_id') }}, or by mail to {{ config('app.address') }}.</p>

                                    <p class="mb-4">These Legal Terms constitute a legally binding agreement made between you, whether personally or on behalf of an entity ("you"), concerning your access to and use of the Services. You agree that by accessing the Services, you have read, understood, and agreed to be bound by all of these Legal Terms. IF YOU DO NOT AGREE WITH ALL OF THESE LEGAL TERMS, THEN YOU ARE EXPRESSLY PROHIBITED FROM USING THE SERVICES AND YOU MUST DISCONTINUE USE IMMEDIATELY.</p>

                                    <p class="mb-4">Supplemental terms and conditions or documents that may be posted on the Services from time to time are hereby expressly incorporated herein by reference. We reserve the right, in our sole discretion, to make changes or modifications to these Legal Terms at any time and for any reason. We will alert you about any changes by updating the "Last updated" date of these Legal Terms, and you waive any right to receive specific notice of each such change. It is your responsibility to periodically review these Legal Terms to stay informed of updates. You will be subject to, and will be deemed to have been made aware of and to have accepted, the changes in any revised Legal Terms by your continued use of the Services after the date such revised Legal Terms are posted.</p>

                                    <p class="mb-4">The Services are intended for users who are at least 18 years old. Persons under the age of 18 are not permitted to use or register for the Services.</p>

                                    <p>We recommend that you print a copy of these Legal Terms for your records.</p>
                              

<h2>Terms and Conditions</h2>
<p><strong>Last Updated on:</strong> 13 November 2025</p>

<p>These Terms and Conditions are effective on 13 November 2025 if you created your account or accepted or otherwise agreed to them on or after 13 November 2025.</p>

<p>Please click here to view the previous version of the Terms and Conditions. The previous version of the Terms and Conditions is applicable in case you have created your account prior to 01 August 2023 and continue to be on an old Plan.</p>

<p>This online terms and conditions ("Terms and Conditions"), by and between the Customer, as defined under these Terms and Conditions, and leadmine.pro, a Delaware corporation with principal office at 355 Bryant Street, #403 San Francisco CA 94107, United States of America ("leadmine.pro"), together with any and all applicable Order Form(s), purchase orders, schedules, exhibits (collectively, the "Agreement") constitute a legal and binding agreement between leadmine.pro and the Customer and set forth the terms pursuant to which the Customer may access and/or use the Site and Services, as defined. leadmine.pro and Customer may be individually referred to as a "Party", and collectively as "Parties".</p>

<p>By clicking on the "Accept" button or checking the checkbox on the signup page when subscribing to the Services, entering into an Order Form or otherwise using and/or permitting any User to access and/or use any of the Services or accessing the Site, Customer : (i) affirms that it has read, agreed and will comply with this Agreement; (ii) affirms that the representative of the Customer is at least eighteen (18) years of age and has the required authority to enter into this Agreement on behalf of the Customer, and to bind the Customer to these Terms and Conditions.</p>

<p>Please note that access to a leadmine.pro Account is subject to the successful completion of our internal verification process of the Customer, which must be passed before any use of the Service is permitted.</p>

<p><strong>IF YOU DO NOT AGREE TO THESE TERMS AND CONDITIONS, YOU MUST NOT CLICK ACCEPT OR THE CHECKBOX ON THE SIGNUP PAGE OR SIGN THE ORDER FORM, USE ANY OF THE SERVICES, OR ACCESS THE SITE.</strong></p>

<h2>1. Definitions</h2>
<p><strong>"Administrator"</strong> means the individual(s) who have been granted the right by Customer to set up the account, have access to control settings, and have greater control over the permissions;</p>

<p><strong>"Affiliate"</strong> means any entity that directly or indirectly controls is controlled by, or is under common control with the subject entity;</p>

<p><strong>"Applicable Law"</strong> means any and all law, statute, regulation, rule, ordinance, treaty convention, and/or court or administrative order or ruling of any governing body with jurisdiction over the Service, the Customer, and/or the Customer's use of the Services;</p>

<p><strong>"Authorized User"</strong> means individual(s) who are employees, contractors, or agents of the Customer, and have been given access to the leadmine.pro Account.</p>

<p><strong>"Confidential Information"</strong> shall include but is not limited to any and all information... (same content continues fully)</p>

<p>"Customer" means, in the case of an individual accepting this Agreement on behalf of a company or other legal entity, the company or other legal entity on behalf of which such individual is accepting this Agreement or the entity indicated in the Order Form.</p>

<p>"Customer Data" means any data, content, or materials that the Customer, Administrator(s) and Authorized User(s) uploads into, enters into, or submits to the Service including from Third-Party Integrations. For clarification, Customer Data excludes Usage Data.</p>

<p>"Documentation" means leadmine.pro's user manuals, handbooks, help articles and guides relating to the Site or Service provided by leadmine.pro to Customer either electronically or in hard copy form.</p>

<p>"Effective Date" means the date on which the Customer subscribes to the Service or the date mentioned in the Order Form;</p>

<p>"Feedback" means any suggestions or idea for modifying the Service or a portion of the Service including without limited to intellectual property rights in any such suggestions or idea;</p>

<p>"leadmine.pro Account" means the account established by leadmine.pro and associated with the Customer pursuant to entering this Agreement, or an Order Form.</p>

<p>"leadmine.pro Number" means the phone number allotted to the Customer;</p>

<p>"Order Form" means the ordering document from leadmine.pro detailing the Service to be provided to the Customer</p>

<p>"Plan" means any of the subscription plans made available to the Customer that the Customer may select either via the leadmine.pro Account or the Site, or by executing an Order Form including leadmine.pro Numbers, as applicable. The subscription plans can be accessed here.</p>

<p>"Service" means any and all services made available to Customer by leadmine.pro from time to time under this Agreement.</p>

<p>"Site" is defined as the website www.leadmine.pro</p>

<p>"Usage Data" means the data regarding applications utilized with the Service, configurations, log data, and the performance results for the Service.</p>

<p>"Third-Party Products" means any products, content, services, information, websites, Integrations, or other materials that are owned by third parties and are incorporated into or accessible through the Service.</p>

<h2>2. Services Offered</h2>

<p>2.1 leadmine.pro provides online-based phone solutions and services that include the ability to make, receive, forward voice calls, record and transcribe such calls, and send and receive messages, in each case to/from leadmine.pro Number from to/ a telephone number in accordance with the Plan chosen by the Customer. leadmine.pro can integrate with various Third-Party Products that are not affiliated with leadmine.pro. A non-exhaustive description of leadmine.pro and the Services provided is available on the Site.</p>

<p>2.2 leadmine.pro is not a 'dial-tone' provider and is not a replacement for any phone lines, whether wired, wireless, or Internet-based. The Service allows you to place outbound calls and messages, national and international, however, selected numbers and services may not be reachable through the Service and leadmine.pro cannot guarantee that all numbers available worldwide can be called or messaged from the Service and leadmine.pro Number.</p>

<p>2.3 leadmine.pro does not support any emergency calls to any type of hospitals, law enforcement agencies, medical care units, or any type of emergency services of any kind, that need to be performed from the Customers' local phone service provider. It is the Customers' responsibility to inform the Authorized Users that it is not possible to support or carry emergency calls using the Service.</p>

<h2>3. Quality and Maintenance</h2>

<p>3.1 Minimum Disruptions. leadmine.pro shall use reasonable endeavours to provide the Service with minimum disruptions. leadmine.pro cannot guarantee that the Service will always function without any disruptions, interruptions or delays. Since the Service will be transmitted through public internet lines and the public switched telephone network, there may be power outages of internet service disruptions and the Customer may experience some disruptions that can interfere with quality service. leadmine.pro does not warrant full availability of any type.</p>

<p>3.2 Support Services. leadmine.pro will provide standard support services to resolve technical issues with, and answers queries regarding the use of the Service for purchased Service Customers at no additional cost.</p>

<p>3.3 Upgrades. leadmine.pro may change technical features in order to keep pace with the latest demands and technological developments or to comply with any Applicable Laws without obtaining the Customer's written pre-approval. leadmine.pro may also have to repair, improve, and/or upgrade, provide patches, enhancements, or fixes for the Service and this may require us to restrict, limit, suspend, interfere and/or interrupt the Service at any time in our sole discretion including in the event of an emergency. leadmine.pro shall endeavor to provide the Customer will advance notice where practicable and carry out such maintenance, where possible, outside of regular business hours.</p>

<p>3.4 Login Details. The Customer acknowledges and agrees that the Customer's Authorized Users' access to the Service is protected by an identification system that requires each User to choose a unique password and username ("Login Details"). It is the responsibility of the Customer and the Authorized User to maintain the confidentiality of the Login Details, and not disclose or share the Login Details with any third party, and that the Login Details are kept private and confidential. Any use of such Login Detail shall therefore be deemed to be made by the Customer and/or its Authorized Users. The Customer and/or its Authorized User is responsible for immediately notifying leadmine.pro of any Authorized use of the leadmine.pro Account, or breach of the leadmine.pro account's login details to take all necessary steps to prevent or terminate the fraudulent use of the leadmine.pro account and/or the Service. leadmine.pro shall not be liable for any loss that the customer may incur as a result of unauthorized use of the Login Details with or without your knowledge.</p>

<p>3.5 Enforcing Security. Actual or attempted unauthorized use of any of the Site or the Service may result in criminal and/or civil prosecution by the appropriate legal and judicial authorities. leadmine.pro reserves the right to view, monitor, and record activity on the Site and the Service without notice to the fullest extent permitted by applicable law. This right extends to our review of message content, call recordings and details pertaining to claimed violations of our AUP as described herein. Any information obtained by monitoring, reviewing, or recording is subject to review by law enforcement organizations in accordance with our Privacy Policy.</p>

<h2>4. Intellectual Property and License</h2>

<p>4.1 Limited License. Subject to the terms of this Agreement, and the Customer's, Administrator(s) and Authorised User(s) continued and full compliance with the terms of this Agreement, leadmine.pro grants to Customer, Administrator(s) , and Authorized User(s), during the Term, a limited, revocable, nonexclusive, non-transferable and right to access and use the Service and the Site solely for its internal business purposes.</p>

<p>4.2 Restrictions. The Customer shall not and cause its Administrator (s) and/or Authorized User(s) to refrain from any unauthorized use, directly on indirectly, including but not limited to:</p>

<p>(a) sublicense, sell, rent, lease, transfer, assign, distribute, or otherwise commercially exploit or make the Service, or any part thereof available to any third party other than Administrator(s) and/or Authorized Users;</p>

<p>(b) modify, reverse engineer, decompile or disassemble, make derivative works of the Service or any party thereof, and shall not build a similar or competitive product or service;</p>

<p>(c) permit other third parties to use the Service, including but not limited to shared use via a network connection except under the terms of this Agreement;</p>

<p>(d) rent, lease, loan, sublicense, distribute or otherwise transfer rights to the Service, or any party thereof available to any third party other than Authorized Users;</p>

<p>(e) circumvent or disable any technological features or measures in the Service;</p>

<p>(f) attempt to, or in conjunction with any device, program, or service designed to circumvent technological measures employed to control access to, or the rights in a content file or other work protected by copyright law in any jurisdiction.</p>

<p>(g) use the Site, Service, or Documentation in any manner or for any purpose that infringes, misappropriates, or otherwise violates any intellectual property right or other right of any person, or that violates any applicable law, regulation, or rule.</p>

<p>leadmine.pro reserves its right to suspend or terminate the license to the Service in the event the Customer and/or Administrator(s) and/or Authorized User(s) is found using the leadmine.pro Account in violation of Clause 4.2 (Restrictions).</p>

<p>4.3 leadmine.pro ownership. Customer agrees that leadmine.pro owns all rights, titles and interests in and to all Intellectual Property rights in the Service, the Site, the Documentation, as well as any content herein, except as otherwise stated ("leadmine.pro Intellectual Property"). All rights not expressly granted to the Customer are reserved by leadmine.pro. leadmine.pro owns the Usage Data derived from the operation of the Service. Nothing contained herein shall prevent leadmine.pro from utilising the Usage Data for purposes of providing and maintaining, delivering, and/or improving the Service provided that any data so used shall be de-identified and presented in the aggregate so that it will not disclose the identity of Customer to any third party. leadmine.pro reserves all rights not expressly granted to Customer in this Agreement. Except for the limited rights and licenses expressly granted under this Agreement, nothing in this Agreement grants, by implication, waiver, estoppel, or otherwise, to Customer or any third party, any intellectual property rights or other right, title, or interest in or to the leadmine.pro Intellectual Property</p>

<p>4.4 Customer data. leadmine.pro agrees, as between the Parties, the Customer retains all rights, titles, and interests in and to all Intellectual Property rights in the Customer Data. Customer acknowledges that leadmine.pro is not responsible for the creation, content, or use of the Customer Data by Customer or any third party. Customer grants leadmine.pro, its affiliates, and applicable contractors a limited-term license to host, copy, use, transmit, store and display any product integration for the Customer using the Service and the Customer Data as appropriate to provide and ensure proper operation of the Service and associated systems in accordance with the Agreement. If the Customer chooses to use a Third-Party Product with the Service, then the Customer allows the Third-Party Product to access Customer Data as appropriate. Use of any such Third-Party Product are subject to the terms and conditions such Third-Party Product, and Customer warrants that Customer has agreed to such terms independently from their use of leadmine.pro Site and Service Customer warrants that it owns or has acquired the necessary licenses to grant leadmine.pro the above license to use Customer Data.</p>

<p>4.5 Use of Trademarks. The Customer grants leadmine.pro the right to use and reproduce the Customer's name, logo and trademark to identify Customer as a leadmine.pro customer on the Site and other marketing materials. In the event, the Customer does not agree with the use of the Customer's name, logo and /or trademark to identify the Customer as a leadmine.pro customer or that the use of Customer's name, logo and/or trademark is not in line with the Customer's branding or similar guidelines, the Customer shall notify leadmine.pro at the email address sales@leadmine.pro.</p>

<p>4.6 Feedback. All Feedback given by the Customer to leadmine.pro shall be used without restriction or obligation. All Feedback is provided "as is" and leadmine.pro will not publicly identify the Customer as the source of Feedback without the Customer's permission. The Customer has agreed to not treat any Feedback given to leadmine.pro as Customer's Confidential Information, Intellectual Property or its trade secret, and nothing in this Agreement or in the Parties' dealings arising out of or related to this Agreement will restrict leadmine.pro's right to use, profit from, disclose, publish, keep secret or otherwise exploit Feedback, without compensating or crediting the Customer.</p>

<p>4.7 Third-Party Information. leadmine.pro may disclose, distribute, reference or communicate third-party Information in connection with the Service. leadmine.pro is not responsible for and does not endorse, sponsor, or review this third-party Information and hereby disclaims all liability for the same.</p>

<p>4.8 Documentation License. Subject to the terms and conditions contained in this Agreement, leadmine.pro hereby grants the Customer a non-exclusive, non-sublicensable, non-transferable license for Administrator(s) and Authorized User(s) to use the Documentation during the Term solely for your internal business purposes in connection with use of the Site and Service.</p>

<p>4.9 Downloadable Software. Use of the Site and Services may require or include use of downloadable software. leadmine.pro grants the Customer a non-transferable, non-exclusive, non-assignable, limited right for Administrator (s) and/or Authorized User(s) to use downloadable software we provide as part of the Site and Services in accordance with the End User License Agreement that accompanies such downloadable software. Any Third-Party Products that consist of downloadable software are subject to the terms of such Third-Party Product.</p>

<h2>5. Acceptable Use Policy and Privacy Policy</h2>

<p>5.1 Restricted Activities. The Customer and/or Administrator(s) and/or Authorized User(s) are responsible for any use of leadmine.pro. Any and all access and use of the Service must be in compliance with the following Acceptable Use Policy ("AUP"). Customer must not and cause its Administrator(s) and/or Authorized Users not to use leadmine.pro to:</p>

<p>(a) violate any laws, regulations, governmental orders, industry standards, or published policy, or any applicable third-party policy including upstream provider's acceptable use policies, industry code of conduct, or requirement communicated or otherwise made available by leadmine.pro, telecommunications providers' requirements or guidance in any applicable jurisdiction including that require (i) consent to be obtained prior to transmitting, recording, collecting or monitoring data or communications or (ii) compliance with opt-out requests for any data or communications;</p>

<p>(b) violate or infringe on Intellectual Property, privacy or rights of another;</p>

<p>(c) to transmit or store any content or communications (commercial or otherwise) that is illegal, harmful, unwanted, inappropriate, or objectionable in the recipient's jurisdiction including content or communication which leadmine.pro determines (i) is false or inaccurate; (ii) is hateful or encourages hatred or violence against individuals or groups; (iii) could endanger public safety, or (iv) the sale or promotion of prohibited substances, prescription medicines or prohibited goods;</p>

<p>(d) to transmit or store any content or communications that is sexually explicit, pornographic, obscene, or other content which is objectionable in leadmine.pro's sole discretion;</p>

<p>(e) to sell, trade, resell or otherwise exploit leadmine.pro account for any unauthorized commercial purpose;</p>

<p>(f) stalk, harass, harm another individual or impersonate another individual, misrepresent or falsely identify, engage in spamming, phishing or pharming;</p>

<p>(g) to engage in fraudulent activity with respect to third parties or otherwise using the leadmine.pro Account to bypass phone identification systems;</p>

<p>(h) to engage in spamming or other unsolicited advertising, marketing or other activities in connection with any unsolicited or harassing messages (commercial or otherwise) including but not limited to unsolicited or unwanted phone calls or text messages;</p>

<p>(i) to engage in unauthorized commercial activities and/or sales and unsolicited marketing or other activities that violate anti-spam laws and regulations including CAN-SPAM Act of 2003, the Telecom Consumer Protection Act of 1991 ("TCPA") Rules, Do-Not-Call Implementation Act or any other similar or analogous anti-spam, data protection or privacy related legislations in other jurisdictions;</p>

<p>(j) to use any robot, spider, another automatic device, or manual process to monitor, copy or 'scrape' web pages or the content contained in the website or for any other unauthorized purpose without our prior written consent;</p>

<p>(k) using any device, software, or routine to interfere or attempt to interfere with the proper working of the Service;</p>

<p>(l) to decompile, reverse engineer, or disassemble the software or attempting to do so;</p>

<p>(m) perform automated communications or engage in abusive practices including enabling robocalls, bulk call-in lines, auto-dialing, 'predictive' dialing, or bulk messages in violation of any Applicable Laws including but not limited to TCPA;</p>

<p>(n) send messages relating to (i) high-risk financial services, including but not limited to payday loans, short term high-interest loans, third-party loans (third party means originating from any party other than the one which will service the loan), student loans, cryptocurrency; (ii) third-party lead generation services that buy, sell or share customer information; (iii) debt collection or forgiveness including but not limited to third-party (i.e., originating from any party other than the one who is owed the debt) debt collection, debt consolidation, debt reduction, credit repair programs; (iv) 'Get rich quick' scheme including but not limited to deceptive work from home programs, risk investment opportunities, pyramid schemes; (v) sale, promotion or offering for sale cannabis, CBD or vape products, regardless of whether the messages explicitly contain cannabis terms, images or links to cannabis websites; (vi) sale, promotion or offering for sale prescription drugs; (vii) sale or promotion of gambling including but not limited to casino apps and gambling websites; (viii) sale or promotion or offering for sale firearms or explosives;</p>

<p>(o) send any communications on behalf of, or purporting to originate on behalf of leadmine.pro;</p>

<p>(p) trunk or forward Customer's leadmine.pro Number to another phone number capable of handling multiple simultaneous calls or text messages;</p>

<p>(q) violate any term of the Fair Usage Policy.</p>

<p>5.2 Privacy Policy. leadmine.pro complies with its privacy policy, available at privacy-policy/ ("Privacy Policy"), in providing the Site and Service. The Privacy Policy is subject to change as described therein. By accessing, using, and providing information to or through the Site and Service, you acknowledge that you have reviewed and accepted our Privacy Policy, and you consent to all actions taken by us with respect to your information in compliance with the then-current version of our Privacy Policy.</p>

<p>5.3 Messaging and Call Recording Compliances. Notwithstanding anything set forth in this Agreement, and in addition thereto, Customer's use of the messaging feature of the Service, must comply with all consent/opt-in requirements, ongoing consent requirements, opt-out/unsubscribe requirements, and correct identification of sender requirements as mentioned in any and all local laws, regulations, and third-party policies. Further, notwithstanding anything set forth in this Agreement and in addition thereto, Customer's use of the call recording functionality must comply with any and all local laws and regulations including local notice requirements. Further, the Customer shall process any do not call or do not text requests in accordance with the local laws, regulations and third-party policies.</p>

<p>5.4 Breach of AUP. In the event, the Customer breaches any of the terms of the AUP, leadmine.pro may immediately suspend or terminate all or part of the access of the Service and/or the Agreement and report and share relevant information of any activities deemed illegal or against applicable laws and regulations to the appropriate authorities in accordance with applicable data privacy laws and regulations. In addition to the restrictions mentioned in the AUP, leadmine.pro reserves the right to impose limits on the Customer's and its Authorized Users' usage of the Service. The Customer acknowledges that leadmine.pro may, but is not required to, pre-screen any messaging content but leadmine.pro shall have the right, in their sole discretion, to pre-screen and/or refuse the transmission of any messaging content that violates the AUP and this Agreement.</p>

<h2>6. leadmine.pro Phone Numbers</h2>

<p>6.1 Allocating leadmine.pro Numbers. As part of the Service, leadmine.pro may make available leadmine.pro Numbers to Customer in multiple countries. Customer acknowledges that the provision of leadmine.pro Numbers is subject to applicable numbering rules and regulatory practices applicable in the countries where Customer, Administrator(s) and/or Authorized Users are located and the relevant countries from where the leadmine.pro Number was purchased and these may change or be amended from time to time. leadmine.pro reserves the right to change the terms related to leadmine.pro Numbers accordingly, including but not limited to imposing or amending local residency requirements and/or requiring additional user information for continued access to the selected leadmine.pro Numbers. The Customer can purchase and allocate leadmine.pro Numbers to their leadmine.pro Account subject to allocation requirements displayed upon subscription to the leadmine.pro Numbers. The Customer cannot assign, transfer, rent, or sell any leadmine.pro Numbers.</p>

<p>6.2 Fixed Cost of leadmine.pro Numbers. The cost of leadmine.pro Numbers vary from country to country. Only upon the confirmation of the Customer shall leadmine.pro procure a leadmine.pro Number. Once the leadmine.pro Number is procured, the Customer's leadmine.pro Account will be charged the fixed cost for the leadmine.pro Number.</p>

<p>6.3 Suspension of leadmine.pro Numbers. The Customer is responsible for compliance with any and all Applicable Law and the terms of this Agreement including such applicable allocation requirements. The Customer is responsible for notifying the Administrator(s) and/or Authorized User(s) about the compliance with any and all Applicable Law and the terms of this Agreement. leadmine.pro reserves the right to suspend or cancel the allocated leadmine.pro Number in the event of any breach of any Applicable Law and/or the terms of this Agreement without penalty and without prejudice to its rights to claim damages therefore. In addition, Customer shall remain liable for any Fixed Fees incurred as a result of such suspended or cancelled leadmine.pro Number(s) and may be held liable for the use of the suspended or cancelled leadmine.pro Number(s) not in compliance with Applicable Laws, and/or the terms of this Agreement.</p>

<p>6.4 Portability. leadmine.pro provides, at the Customer's written request, provisions for porting in a number or porting out a leadmine.pro Number according to Applicable Laws and the applicable technical and geographical eligibility conditions. To import a number into the leadmine.pro Account, the Customer must follow all the steps indicated by leadmine.pro from time to time and provide all information requested by leadmine.pro, which must be correct and complete. leadmine.pro may charge a one-time fix fee for each phone number ported into the Customer's leadmine.pro Account depending on the type and region of the phone number. If the Customer wishes to export the leadmine.pro number to another provider, the Customer must have subscribed to a paid plan of the Service. Further, while leadmine.pro does not charge a one-time fee for exporting a leadmine.pro Number to another provider, it is the responsibility of the Customer to inquire from their provider about any fees for portability.</p>

    <h2>7. Pricing, Billing and Refund Policy</h2>

    <h3>7.1 Free Trial</h3>
    <p>
        Customer may elect to try the Service at no cost (except for any Usage Fees beyond USD 2) for trial period of not more than 14 days, 
        from the Effective Date or such additional trial period as leadmine.pro may grant Customer on a case-by-case basis in its sole 
        discretion ("Free Trial"). leadmine.pro reserves the right, at any time, to add any restrictions or limitations to the Free Trial 
        without prior notice to the Customer. Customer may request a current list of restrictions and limitations for Free Trial. 
        leadmine.pro offers no warranty, or indemnity for Free Trials, and its liability for Free Trials will not exceed USD 100.
    </p>

    <h3>7.2 Fixed Fees</h3>
    <p>
        Customer may select a Plan on a monthly basis or annual basis either from their leadmine.pro Account or by entering into an Order 
        Form. The fees to be paid by the Customer that are associated with the Plan selected are indicated on the Site ("Fixed Fees"). 
        Any fees associated with leadmine.pro Numbers, Additional Numbers, Additional Licenses, add-on features, one-time fees such as 
        porting fees, or any other charge(s) relating to calling and messaging, are deemed Fixed Fees.
    </p>

    <p>
        Using leadmine.pro will not incur charges to the Customer's personal voice plan unless calls are redirected to a mobile in a foreign 
        country. Data usage during calls on mobile networks will use customer's mobile data plan. Additional Licenses and/or numbers will be 
        invoiced at the same Billing Frequency and pro-rated accordingly. No refund will be given for any removal of License/Number during 
        a billing cycle.
    </p>

    <h3>7.3 Usage Fees</h3>
    <p>Any fees associated with calling and messaging not included in Fixed Fees are “Usage Fees”:</p>

    <p><strong>(a) Calling Rates.</strong> Airtime is billed in full-minute increments. Chargeable Time begins when connection is established 
        and ends when disconnect is recorded. Voicemail connections, ring time, transfers, deposits, and retrievals are included.
    </p>

    <p><strong>(b) Messaging Rates.</strong> Messaging is charged per 160-character segment. A 200-character message is billed as 2 segments.</p>

    <p><strong>(c) Credits.</strong> Customer must purchase Credits for Usage Fees. Credits cannot be used for Fixed Fees. 
        Unused Credits expire upon termination of Agreement.
    </p>

    <p>
        leadmine.pro may change Calling/Messaging Rates anytime. Customers may request current rates via sales@leadmine.pro.
    </p>

    <h3>7.4 Payment</h3>
    <p>
        By providing a Payment Method, Customer authorizes leadmine.pro to charge for all fees including Fixed Fees and Credits. 
        Customer must update payment details when requested. All payments are due in advance unless otherwise stated. 
        Unused plan benefits do not carry over. Stripe terms apply for card payments.
    </p>

    <h3>7.5 Acceleration and Late Fees</h3>
    <p>
        If any fee is 30+ days overdue, leadmine.pro may accelerate all unpaid obligations to be immediately due. 
        Late fee is 1.5% monthly or maximum allowed by law. Customer will bear all recovery costs.
    </p>

    <h3>7.6 Taxes</h3>
    <p>
        Prices exclude taxes unless stated. Customer is responsible for all applicable taxes.
    </p>

    <h3>7.7 Refunds</h3>
    <p>
        Billing occurs in advance and is non-refundable. No refund for partial months, plan changes, or license reductions. 
        All refunds follow the Refund Policy.
    </p>


    <!-- SECTION 8 -->
    <h2>8. Protection of Data</h2>
    <p>
        leadmine.pro will take commercially reasonable administrative, physical, and technical safeguards to protect Customer Data in 
        compliance with Applicable Laws. Personal data is processed under a Data Processing Agreement where required.
    </p>

    <!-- SECTION 9 -->
    <h2>9. Confidentiality</h2>

    <h3>9.1 Obligation of Confidentiality</h3>
    <p>
        Each Receiving Party shall not disclose Confidential Information without prior written consent, except to employees, affiliates, 
        subcontractors, or advisors who require access. Confidentiality survives 3 years after termination.
    </p>

    <h3>9.2 Compelled by Law</h3>
    <p>
        If legally compelled to disclose information, Receiving Party will give prior notice where legally allowed.
    </p>

    <h3>9.3 Return of Confidential Information</h3>
    <p>
        Upon termination, Parties must return or destroy Confidential Information.
    </p>

    <!-- SECTION 10 -->
    <h2>10. Disclaimer</h2>

    <h3>10.1 Customer Warranty</h3>
    <p>
        Customer warrants ownership of Customer Data and compliance with the AUP.
    </p>

    <h3>10.2 Disclaimer</h3>
    <p>
        Services are provided “AS IS” and “AS AVAILABLE”. leadmine.pro disclaims all warranties including merchantability, non-infringement, 
        fitness for purpose, uptime guarantees, error-free operation, virus-free communications, and call quality.
    </p>

    <!-- SECTION 11 -->
    <h2>11. Limitations of Liability</h2>
    <p>
        leadmine.pro is not liable for misuse, system issues, data loss, unauthorized access, or beyond-control events. 
        No party is liable for indirect, incidental, or consequential damages including lost profits or business loss.
    </p>

    <p>
        Maximum liability is limited to the amount paid by Customer in the previous 12 months. Claims must be initiated within 1 year.
    </p>

    <!-- SECTION 12 -->
    <h2>12. Revisions</h2>
    <p>
        Materials on the Site may include errors. leadmine.pro may update content anytime without obligation to maintain accuracy.
    </p>

    <!-- SECTION 13 -->
    <h2>13. Assumption of Risk</h2>
    <p>
        Customer uses the Internet at their own risk. leadmine.pro is not liable for security of Internet transmissions or network outages. 
        Downloads are at customer’s own risk.
    </p>

    <!-- SECTION 14 -->
    <h2>14. Links</h2>
    <p>
        leadmine.pro is not responsible for third-party links or content. Use of external sites is at customer’s risk.
    </p>

    <!-- SECTION 15 -->
    <h2>15. Compliance with Laws</h2>
    <p>
        Customer must comply with all applicable laws including privacy, call recording, telemarketing, and electronic communication laws. 
        leadmine.pro will cooperate with authorities when required.
    </p>

    <!-- SECTION 16 -->
    <h2>16. Indemnification</h2>
    <p>
        Customer must indemnify leadmine.pro from claims arising due to Customer breach, unlawful use, Customer Data issues, or actions of 
        Users/Administrators.
    </p>

    <!-- SECTION 17 -->
    <h2>17. Term and Termination of License</h2>

    <h3>17.1 Term</h3>
    <p>
        Agreement begins on Effective Date and continues until Plan expiration or earlier termination.
    </p>

    <h3>17.2 Automatic Renewals</h3>
    <p>
        Plans auto-renew unless non-renewal notice is given (30 days for plans, 45 days for Order Form Customers).
    </p>

    <h3>17.3 Termination</h3>
    <p>
        Either Party may terminate for breach, insolvency, regulatory recommendation, or ceasing operations. 
        leadmine.pro may terminate anytime.
    </p>

    <h3>17.4 Effects of Termination</h3>
    <p>
        Customer loses access and must pay all outstanding fees within 30 days.
    </p>

    <h3>17.5 Suspension</h3>
    <p>
        leadmine.pro may suspend service for non-payment or legal violations. Suspension does not waive fees owed.
    </p>

    <!-- SECTION 18 -->
    <h2>18. Governing Law and Jurisdiction</h2>
    <p>
        Agreement is governed by Delaware law. Disputes fall under Delaware court jurisdiction. 
        Class-action and jury-trial rights are waived.
    </p>

    <!-- SECTION 19 -->
    <h2>19. Waivers</h2>
    <p>
        Waivers must be in writing. A waiver does not extend to future obligations.
    </p>

    <!-- SECTION 20 -->
    <h2>20. Assignment and Delegation</h2>
    <p>
        Agreement binds permitted successors. No assignment allowed without written consent except to a successor in interest.
    </p>


  <h2>21. No Injunctive Relief</h2>
    <p>
        In no event shall the Customer seek or be entitled to rescission, injunctive or other equitable relief, 
        or to enjoin or restrain the operation of the Service, exploitation of any advertising or other materials 
        issued in connection therewith, or exploitation of the Service or any content or other material used or 
        displayed through the Service.
    </p>

    <h2>22. Miscellaneous</h2>

    <h3>22.1 Notices</h3>
    <p>
        Except as set out in this Agreement, notices or other communications must be in English and are deemed 
        to have been fully given when made in writing and delivered via email, and for leadmine.pro, addressed 
        to sales@leadmine.pro and to Customer at either the physical address or email associated with the 
        Customer's leadmine.pro account.
    </p>

    <h3>22.2 Independent Contractors</h3>
    <p>
        The Parties are independent contractors and have no right to assume or create any obligation on behalf 
        of the other party. This Agreement does not create a partnership, agency, or joint venture.
    </p>

    <h3>22.3 Force Majeure</h3>
    <p>
        Neither Party is liable for delay or failure to perform (excluding payment obligations) due to 
        circumstances beyond reasonable control including acts of God, government, fire, flood, civil unrest, 
        terrorism, strikes, service disruptions, and denial-of-service attacks.
    </p>

    <h3>22.4 Severability</h3>
    <p>
        If any provision is found unenforceable, that provision will be limited to the minimum extent necessary 
        so that the remaining terms remain in full force.
    </p>

    <h3>22.5 Amendments</h3>
    <p>
        leadmine.pro may update this Agreement or its policies anytime and will attempt to notify Customer via 
        email or site pop-up. Continued use after changes constitutes acceptance.
    </p>

    <h3>22.6 Entire Agreement</h3>
    <p>
        This Agreement, Order Forms, Purchases, and schedules constitute the entire agreement and supersede all 
        prior agreements, negotiations, or understandings.
    </p>

    <h3>22.7 No Third-Party Beneficiaries</h3>
    <p>
        The Parties agree there are no third-party beneficiaries to this Agreement.
    </p>

    <h3>22.8 Anti-Bribery</h3>
    <p>
        Neither party has received or been offered any illegal bribe, kickback, gift, or thing of value in 
        connection with this Agreement.
    </p>

    <h3>22.9 Export Control</h3>
    <p>
        The Service may be subject to export laws. Customer agrees not to use the Service in embargoed regions 
        or in violation of U.S. export regulations.
    </p>

    <h3>22.10 Early Access and Betas</h3>
    <p>
        leadmine.pro may offer optional Early Access and Betas for evaluation only. They may be incomplete, 
        unstable, or withdrawn without notice. No warranties or indemnities apply.
    </p>

    <h3>22.11 Survival</h3>
    <p>
        Specific clauses including Disclaimers, Billing, Liability, Indemnification, Confidentiality, IP Rights, 
        Governing Law, and Injunctive Relief will survive termination.
    </p>

    <h2>SaaS Labs AI Supplementary Terms</h2>
    <p>
        These AI Terms govern the use of AI-powered features. In case of conflict, AI Terms override the main 
        Agreement. Use of AI Features constitutes acceptance of these AI Terms.
    </p>

    <h3>23. Third-Party Processing</h3>
    <p>
        AI Features use technology from third-party AI companies including OpenAI and proprietary systems.
    </p>

    <h3>24. Inputs and Outputs</h3>
    <p>
        Customer may upload Inputs and receive Outputs from AI Features. Customer is solely responsible for 
        ensuring compliance with laws and policies. Outputs may be similar for multiple customers. Sensitive 
        data must not be included in Inputs. Usage limits may apply.
    </p>

    <h3>25. Customer Acknowledgments</h3>
    <p>
        Customer acknowledges responsibility for required consents, AI inaccuracy, need for independent 
        verification, and that AI Features may contain errors or change over time.
    </p>

    <h3>26. Security</h3>
    <p>
        Customer must implement reasonable security for AI Feature usage and report vulnerabilities to 
        sales@leadmine.pro.
    </p>

    <h3>27. Disclaimer</h3>
    <p>
        AI Features are provided “AS IS”. leadmine.pro makes no warranties regarding accuracy, reliability, or 
        security of Outputs. Customer must independently verify Outputs and use them at their own risk.
    </p>

    <h3>28. Rights to Use</h3>
    <p>
        leadmine.pro may use Content to provide and improve Services. Customer grants a royalty-free, 
        sublicensable, transferable, perpetual license to use Content for operation and improvement of AI 
        Features, subject to applicable laws.
    </p>

    <h3>29. Restricted Use of AI Features</h3>
    <p>
        Customer agrees not to use AI Features to violate AUP, reverse engineer models, develop competing AI, 
        mislead users, or distribute prohibited Outputs. leadmine.pro may monitor usage and suspend accounts for 
        violations.
    </p>
</div>


<!-- Our Services -->
 <div class="tab-pane fade" id="v-pills-fairusage" role="tabpanel" aria-labelledby="v-pills-fairusage-tab">
  <h3 class="mt-2 mb-6 as-h2">Fair Usage Policy</h3>


<p class="mb-4">
At LeadMine.pro, we are committed to providing high-quality services to all of our customers. To ensure that we can continue offering a fair, reliable, and consistent experience, we have implemented this Fair Usage Policy. This Fair Usage Policy applies to all LeadMine.pro Plans with US and CA Routes.
</p>

<p class="mb-4">
1. Each LeadMine.pro plan includes free calling minutes and messaging. These free calling minutes and messaging are subject to the Fair Usage Policy. The Fair Usage Policy depends on the Customer’s Subscription Plan. For more information on the LeadMine.pro plans, please refer here.
</p>

<p class="mb-3">2. Unless otherwise indicated on an Order Form:</p>
<ul class="mb-4 ps-4">
  <li class="list"><b>Team Plan:</b> The Customer has a limit of five hundred (500) inbound and outbound SMS segments per user for each billing month. The outbound voice minutes and inbound voice minutes are unlimited per user for each billing month, subject to this Fair Usage Policy;</li>
  <li class="list"><b>Pro Plan and Pro Plus Plan:</b> The Customer has a limit of one thousand (1,000) inbound and outbound SMS segments per user for each billing month. The outbound voice minutes and inbound voice minutes are unlimited per user for each billing month, subject to this Fair Usage Policy;</li>
  <li class="list"><b>SalesPro Plan:</b> The Customer has a limit of one thousand (1,000) inbound and outbound SMS segments per user for each billing month. The outbound voice minutes and inbound voice minutes are unlimited per user for each billing month, subject to this Fair Usage Policy.</li>
</ul>

<p class="mb-4">
3. The inbound and outbound voice minutes and SMS segments will be calculated on an account level. For example, for a Customer that is on the Team Plan with 10 active users, the Customer’s limit for calling will be 5,000 SMS segments with unlimited outbound voice calling and inbound voice calling for each billing month.
</p>

<p class="mb-4">
4. Any user who is added in the middle of a billing month will get inbound and outbound voice minutes and SMS segments that are part of the LeadMine.pro plans for the remaining days of the first billing month on a pro-rata basis.
</p>

<p class="mb-4">
5. Any unused SMS segments shall expire at the end of each billing month and will not roll over to subsequent billing months.
</p>

<p class="mb-4">
6. Inbound calling is available for all countries except those with call rates greater than USD 0.02/mins. The outbound calling and SMS feature is available for the countries mentioned in the Pricing Plans or as indicated in the Order Form only.
</p>

<p class="mb-4">
7. In the event a Customer exceeds the monthly limit as mentioned above, then the charges for outbound voice minutes and SMS segments will be deducted from the credits added to their LeadMine.pro account. Further, the standard rates for each voice minute and SMS segment will apply in excess of the monthly limit. The Customer may request <a href="mailto:sales@leadmine.pro">sales@leadmine.pro</a> to get more information on the voice minutes and SMS rates.
</p>

<p class="mb-4">
8. Any inbound and outbound calling used for Trunking or forwarding calls from a LeadMine.pro phone number to another phone number, including a LeadMine.pro phone number, that is capable of handling multiple simultaneous calls, or to a private branch exchange or a key system, will not be covered under the outbound and inbound voice minutes. The charges for such usage will be deducted from the credits added to a Customer’s LeadMine.pro account.
</p>

<p class="mb-4">
9. For any unlimited outbound and inbound calling, it may not be used for scaled telephone uses including but not limited to telephone operators, call centers, and/or telemarketing professionals. LeadMine.pro reserves the right to place limits on the unlimited outbound and/or inbound voice minutes if there is any violation of this Fair Usage Policy or abuse of the unlimited outbound and/or inbound voice minutes. In the event a Customer exceeds the limits placed on the outbound and/or inbound voice minutes, then the charges for calling will be deducted from the credits added to their LeadMine.pro account.
</p>

<p class="mb-4">
10. The SMS limit under this Fair Usage Policy shall apply to one-on-one messaging and will not apply to any other messaging, including but not limited to bulk SMS or SMS sent via workflow automation, and SMS bots. The standard rates for such SMS that are not included in the SMS limit under this Fair Usage Policy shall apply, and the charges will be deducted from the credits added to a Customer’s LeadMine.pro account.
</p>

<p class="mb-4">
11. The inbound and outbound voice minutes are charged on a per-minute basis. This means that even calls with a duration of 0 minutes will be billed for a minimum of 1 minute. For calls exceeding 0 minutes, any partial minutes used will be rounded up to the nearest full minute for billing purposes.
</p>

<p class="mb-4">
12. SMS are charged on a per-segment basis. Each SMS segment is equal to 160 characters. Any SMS exceeding a single segment will be rounded up to the nearest whole segment for billing purposes.
</p>

<p class="mb-4">
13. LeadMine.pro reserves the right to limit, suspend, or terminate the Customer’s access to the Service in the event the Customer is found in violation of the Fair Usage Policy. LeadMine.pro also reserves the right to amend any term of the Fair Usage Policy, including the limits mentioned above, at any time without notice.
</p>

<p class="mb-4">
If you are currently subscribed to previous plans and wish to see the fair usage policy applicable to the previous plans, please refer here.
</p>

</div>

<!-- Intellectual Property Rights -->
<div class="tab-pane fade" id="v-pills-privacy" role="tabpanel" aria-labelledby="v-pills-privacy-tab">
 <div class="container">
    <h2 class="mb-4 fw-bold">Privacy Policy</h2>
    <p>Welcome, and thank you for your interest in SaaS Labs US, Inc, our product <strong>LeadMine.pro</strong> (“LeadMine.pro,” “we,” or “us”), our website at 
      <a href="https://leadmine.pro" target="_blank">https://leadmine.pro</a> (the “Site”), and all related websites, downloadable software, mobile applications 
      (including tablet applications), and other services provided by us and on which a link to this Privacy Policy is displayed, and all other communications 
      with individuals through written or oral means, such as email or phone (collectively, together with the Site, our “Service”).
    </p>

    <p>This Privacy Policy (“Policy”) describes the information that we gather on or through the Service, how we use and disclose such information, and the steps 
      we take to protect such information. By visiting the Site, or by purchasing or using the Service, you accept the privacy practices described in this Policy.
    </p>

    <p>This Policy is incorporated into, and is subject to, the LeadMine.pro Terms & Conditions. Capitalized terms used but not defined in this Policy have the 
      meaning given to them in the LeadMine.pro Terms & Conditions.</p>

    <h4 class="mt-5 fw-bold">Definitions</h4>
    <ul>
      <li><strong>Client</strong> means a customer of LeadMine.pro.</li>
      </br>
      <li><strong>Client Data</strong> means personal data, reports, addresses, and other files, folders or documents in electronic form that a User of the Service stores within the Service.</li>
      </br>
      <li><strong>Personal Data</strong> means any information relating to an identified or identifiable natural person.</li>
      </br>
      <li><strong>Public Area</strong> means the area of the Site that can be accessed both by Users and Visitors, without needing to log in.</li>
      </br>
      <li><strong>Restricted Area</strong> means the area of the Site that can be accessed only by Users, and where access requires logging in.</li>
       </br>
      <li><strong>User</strong> means an employee, agent, or representative of a Client, who primarily uses the restricted areas of the Site for the purpose of accessing the Service in such capacity.</li>
       </br>
      <li><strong>Visitor</strong> means an individual other than a User, who uses the public area, but has no access to the restricted areas of the Site or Service.</li>
    </ul>

    <h4 class="mt-5 fw-bold">What personal information do we collect?</h4>
    <p>We collect different types of information from or through the Service. The legal bases for LeadMine.pro's processing of Personal Data are primarily that 
      the processing is necessary for providing the Service in accordance with our Terms of Service and that the processing is carried out in LeadMine.pro's legitimate interests.</p>

    <h5 class="fw-bold mt-4">User-provided Information</h5>
    <p>When you use the Service, as a User or as a Visitor, you may provide, and we may collect Personal Data. Examples include your name, email address, mobile number, and billing information.</p>

    <h5 class="fw-bold mt-4">Information collected by clients</h5>
    <p>A Client or User may store or upload into the Service Client Data. LeadMine.pro has no direct relationship with the individuals whose Personal Data it hosts as part of Client Data.</p>

    <h5 class="fw-bold mt-4">Automatically collected information</h5>
    <p>We may automatically record certain information such as IP address, browser type, visited pages, and timestamps using cookies, pixels, or web beacons.</p>

    <h5 class="fw-bold mt-4">Integrated services</h5>
    <p>You may access or register for the Service using an Integrated Service (like Google). LeadMine.pro's use and transfer of any personal data received from 
      Google APIs will adhere to Google’s API Services User Data Policy, including the Limited Use requirements.</p>

    <h5 class="fw-bold mt-4">Information from other sources</h5>
    <p>We may obtain information, including Personal Data, from third-party sources such as partners, advertisers, and Integrated Services.</p>

    <h4 class="mt-5 fw-bold">How do we use your information?</h4>
    <ul>
      <li>To operate, maintain, and improve the Service and provide customer support.</li>
      <li>To understand usage trends and enhance the Service.</li>
      <li>To contact Users or Visitors regarding administrative or promotional updates.</li>
      <li>To personalize the Service, monitor analytics, and display relevant content.</li>
      <li>To analyze website traffic using tools like Google Analytics.</li>
    </ul>

    <h4 class="mt-5 fw-bold">To whom we disclose information</h4>
    <p>LeadMine.pro does not sell your Personal Data or Client Data. Disclosure may occur in the following cases:</p>
    <ul>
      <li><strong>Service Providers (Sub Processors):</strong> Trusted vendors for hosting, development, or maintenance.</li>
      <li><strong>Partners:</strong> Authorized LeadMine.pro partners assisting with sales or support.</li>
      <li><strong>Legal Requirements:</strong> When required by law or to protect our rights.</li>
      <li><strong>Change of Ownership:</strong> During mergers, acquisitions, or similar events under confidentiality obligations.</li>
    </ul>

    <h4 class="mt-5 fw-bold">Your choices</h4>
    <p>You may access, correct, or delete your personal data by contacting us at 
      <a href="mailto:sales@leadmine.pro">sales@leadmine.pro</a>.
      If you receive promotional emails, you may unsubscribe using the link provided or by emailing us directly.
    </p>

    <p>LeadMine.pro has no direct relationship with a Client’s customers or third parties whose Personal Data it processes on behalf of a Client. 
      Such individuals should contact the relevant Client directly.</p>

    <h4 class="mt-5 fw-bold">How do we protect your information?</h4>
    <p>All transactions are handled through a PCI-compliant gateway (Stripe, Inc). Data is secured through TLS/SSL encryption and restricted network access. 
      LeadMine.pro also supports 2-factor authentication for enhanced security. In case of a data breach, we will promptly investigate and take necessary measures.</p>


    <h3 class="fw-bold mb-4">Third-party Services</h3>
    <p>The Service may contain features or links to websites and services provided by third parties. Any information you provide on third-party sites or services is provided directly to the operators of such services and is subject to those operators' policies, if any, governing privacy and security, even if accessed through the Service. We are not responsible for the content or privacy and security practices and policies of third-party sites or services to which links or access are provided through the Service. We encourage you to learn about third parties' privacy and security policies before providing them with information.</p>

    <h4 class="mt-5 fw-bold">Google</h4>
    <p>Google's advertising requirements can be summed up by Google's Advertising Principles. They are put in place to provide a positive experience for users. 
      <a href="https://support.google.com/adwordspolicy/answer/1316548?hl=en" target="_blank">https://support.google.com/adwordspolicy/answer/1316548?hl=en</a>
    </p>
    <p>We have not enabled Google AdSense on our site and we don't plan to do so in the future.</p>

    <p>If you use Chrome Extensions or Google add-ons developed by <strong>LeadMine.pro</strong>, we may collect data such as your name, email address, through connecting to your Google Account (with your consent). This information won't be displayed to the public nor is it ever shared without your explicit consent. As of today, we don't use login or signup based on your Google Account.</p>

    <h4 class="mt-5 fw-bold">Data Transfer</h4>
    <p>We may transfer, process and store Personal Data we collect through the Services in centralized databases and with service providers located in the US. The US may not have the same data protection framework as the country from which you may be using the Services. When we transfer Personal Data to the US, we will protect it as described in this Privacy Policy and Terms of Service.</p>

    <p>The Service is hosted in the United States. If you choose to use the service from the EU or other regions of the world with laws governing data collection and use that may differ from US law, then please note that you may be transferring your Client Data and Personal Data outside of those regions to the United States for storage and processing by our service providers. We will comply with GDPR requirements providing adequate protection for the transfer of personal information from Europe to the US. Also, we may transfer your data to the US, the EEA, or other countries or regions deemed by the European Commission to provide adequate protection of personal data in connection with storage and processing of data, fulfilling your requests, and operating the Service.</p>

    <h4 class="mt-5 fw-bold">Data Controller and Data Processor</h4>
    <p><strong>LeadMine.pro</strong> does not own, control or direct the use of any of the Client Data stored or processed by a Client or User via the Service. Only the Client or Users are entitled to access, retrieve and direct the use of such Client Data. LeadMine.pro is largely unaware of what Client Data is actually being stored or made available by a Client or User to the Service and does not directly access such Client Data except as authorized by the Client, or as necessary to provide Services to the Client and its Users.</p>

    <p>Because LeadMine.pro does not collect or determine the use of any Personal Data contained in the Client Data and because it does not determine the purposes for which such Personal Data is collected, the means of collecting such Personal Data, or the uses of such Personal Data, LeadMine.pro is not acting in the capacity of data controller in terms of the European Union's General Data Protection Regulation (Regulation (EU) 2016/679, "GDPR") and does not have the associated responsibilities under the GDPR. LeadMine.pro should be considered only as a processor on behalf of its Clients and Users as to any Client Data containing Personal Data that is subject to the requirements of the GDPR. Except as provided in this Privacy Policy, LeadMine.pro does not independently cause Client Data containing Personal Data stored in connection with the Services to be transferred or otherwise made available to third parties, except to third party subcontractors who may process such data on behalf of LeadMine.pro in connection with LeadMine.pro's provision of Services to Clients. Such actions are performed or authorized only by the applicable Client or User.</p>

    <p>The Client or the User is the data controller under the Regulation for any Client Data containing Personal Data, meaning that such party controls the manner such Personal Data is collected and used as well as the determination of the purposes and means of the processing of such Personal Data.</p>

    <p>LeadMine.pro is not responsible for the content of the Personal Data contained in the Client Data or other information stored on its servers (or its subcontractors' servers) at the discretion of the Client or User nor is LeadMine.pro responsible for the manner in which the Client or User collects, handles disclosure, distributes or otherwise processes such information.</p>

    <h4 class="mt-5 fw-bold">Data Retention</h4>
    <p>We only retain the Personal Data collected from a User for as long as the User's account is active or otherwise for a limited period of time as long as we need it to fulfill the purposes for which we have initially collected it, unless otherwise required by law. We will retain and use information as necessary to comply with our legal obligations, resolve disputes, and enforce our agreements as follows:</p>
    <ul>
      <li>The contents of closed accounts are deleted within 6 months of the date of closure.</li>
      <li>Backups are kept for 12 months.</li>
      <li>Information on legal transactions between Client and LeadMine.pro is retained for a period of 10 years.</li>
    </ul>

    <h4 class="mt-5 fw-bold">Third-party Cookies</h4>
    <p>We allow third parties with which we have a separate agreement to use cookies and other technologies to collect information about your use of the Site. These third parties include (1) business partners, which collect information when you view or interact with one of their advertisements on the Site; and (2) advertising networks, which collect information about your interests when you view or interact with one of their advertisements.</p>

    <p>The information gathered by these third parties is used to make predictions about your interests or preferences so that they can display advertisements or promotional material on this Site and on other sites across the Internet tailored to your apparent interests. The business partners and advertising networks that serve interest-based advertisements on the Services have limited access to a small amount of information about your profile and your device, which is necessary to serve you advertisements that are tailored to your apparent interests. It is possible that they may reuse this small amount of information on other sites or services.</p>

    <p>We do not share with these third parties any information that would readily identify you (such as email address); however, these third parties may have access to information about your device (such as IP or MAC address). We do not have access to, or control over, the technologies that these third parties may use to collect information about your interests, and the information practices of these third parties are not covered by this Privacy Policy. Other than as discussed in this document, we have no control over these third parties.</p>

    <h5 class="fw-bold mt-4">The Following Types of Cookies Are Used in the Site:</h5>
    <ul>
      <li><strong>Strictly necessary/essential cookies:</strong> These cookies are essential in order to enable you to move around the website and use its features, such as accessing secure areas of the website. Without these cookies, services you have asked for cannot be provided.</li>
      <li><strong>Functionality cookies:</strong> These cookies allow the website to remember choices you make (such as your username, language, or region) and provide enhanced, more personal features.</li>
      <li><strong>Behaviourally targeted advertising cookies:</strong> These cookies are used to deliver adverts more relevant to you and your interests. They also limit the number of times you see an advertisement and help measure the effectiveness of advertising campaigns.</li>
    </ul>

    <h4 class="mt-5 fw-bold">Fair Information Practices</h4>
    <p>The Fair Information Practices Principles form the backbone of privacy law in the United States and the concepts they include have played a significant role in the development of data protection laws around the globe. Understanding the Fair Information Practice Principles and how they should be implemented is critical to comply with the various privacy laws that protect personal information

In order to be in line with Fair Information Practices we will take the following responsive action, should a data breach occur: We will notify you via email or via in-site notification whitin 7 business days. We also agree to the Individual Redress Principle which requires that individuals have the right to legally pursue enforceable rights against data collectors and processors who fail to adhere to the law. This principle requires not only that individuals have enforceable rights against data users, but also that individuals have recourse to courts or government agencies to investigate and/or prosecute non-compliance by data processors.

  </div>          

</div>

<!-- User Representations -->
<div class="tab-pane fade" id="v-pills-partner" role="tabpanel" aria-labelledby="v-pills-partner-tab">
    <h2 class="mb-4 as-h2">Integration Partner Program Agreement</h2>

    <p>This Partner Program Agreement (referred to as the “Agreement”) is between SaaS Labs US, Inc.
        (referred to as “<strong>Leadmine.pro</strong>” or “SaaS Labs”), a Delaware corporation with its
        principal place of business at 355, Bryant Street, #403 San Francisco, CA 94107 and Integration Partner
        identified below in the signatures.</p>

    <p>By clicking on the “Become a Partner” button while signing up to join the
        <strong>Leadmine.pro Integration Partner Program</strong>, the Integration Partner:</p>

    <ul class="mb-4 ps-4">
        <li>(a) acknowledges that it has agreed and will comply with this Agreement,</li>
        <li>(b) warrants and represents that its representatives are at least eighteen (18) years of age, and</li>
        <li>(c) has the authority to enter and bind the Partner to this Agreement.</li>
    </ul>

    <p>This Agreement applies to your participation in our <strong>Leadmine.pro Integration Partner Program</strong>
        (“Partner Program” or “Program”) as an Integration Partner.</p>

    <p>If the Integration Partner does not agree to these terms, the Integration Partner may not participate in the Program.
        <strong>Leadmine.pro</strong> may modify this Agreement at any time by sending a notice via email.</p>

    <h2 class="mt-5 mb-3 as-h2">Program Overview</h2>

    <p><strong>Purpose.</strong> Subject to the terms of this Agreement, the Parties shall engage in certain specified
        partnering activities which may include:</p>

    <ul class="ps-4">
        <li>(a) development, provision, and support of an integrated offering,</li>
        <li>(b) promotion and marketing of each other’s products/services,</li>
        <li>(c) other mutually agreed activities.</li>
    </ul>

    <p><strong>Generally.</strong> To participate, the Integration Partner must register online or enter into this Agreement.
        The Program shall take effect once <strong>Leadmine.pro</strong> approves participation via email.
        Leadmine.pro may accept or reject any application at its sole discretion.</p>

    <p>This Agreement does not authorize the Integration Partner to purchase the <strong>Leadmine.pro</strong> product
        directly for commercial use. Any purchase will be governed under a separate agreement.</p>

    <h2 class="mt-5 mb-3 as-h2">Co-Marketing & Promotional Activities</h2>

    <p>Each Party agrees to engage in mutually decided marketing and promotional activities.
        Co-branded materials require approval before release. Upon expiration, neither Party is obligated
        to promote the other without permission.</p>

    <h2 class="mt-5 mb-3 as-h2">Confidential Information</h2>

    <p><strong>Definition.</strong> Confidential Information includes data marked confidential or that a reasonable person
        would consider confidential.</p>

    <p><strong>Obligation.</strong> Recipient shall not disclose Confidential Information without written consent except to
        employees or affiliates who need it for obligations under this Agreement.</p>

    <p><strong>Return/Destruction.</strong> Upon termination, Confidential Information must be returned or destroyed.</p>

    <h2 class="mt-5 mb-3 as-h2">Intellectual Property</h2>

    <p>This Agreement does not transfer any intellectual property rights.</p>

    <p><strong>Leadmine.pro</strong> retains ownership of its product. Integration Partner may not copy, lease, sell,
        distribute, or create derivative works of the Leadmine.pro product without permission.</p>

    <p>Each Party grants the other limited trademark usage rights for promotional purposes during the Term.</p>

    <h2 class="mt-5 mb-3 as-h2">Term & Termination</h2>

    <p>Agreement remains effective for one (1) year unless terminated earlier.</p>

    <p>Either Party may terminate upon 60 days’ notice, or immediately for breach not cured within 30 days.</p>
 
    <h2 class="mt-5 mb-3 as-h2">Warranties & Disclaimer</h2>

    <p>Each Party represents that it has the authority to enter this Agreement and will protect Confidential Information.</p>

    <p><strong>DISCLAIMER:</strong> Except as stated here, all warranties are disclaimed, including implied warranties of 
        merchantability and fitness for a particular purpose.</p>

    <h2 class="mt-5 mb-3 as-h2">Indemnification</h2>

    <p>Each Party shall indemnify the other for claims arising from breach, negligence, or misconduct.</p>

    <h2 class="mt-5 mb-3 as-h2">Limitation of Liability</h2>

    <p>Neither Party shall be liable for indirect, special, punitive, or consequential damages.</p>

    <p>Maximum liability is limited to <strong>$5,000 USD</strong>.</p>

  <h2 class="mt-5 mb-3 as-h2">General Terms</h2>

<ol class="ps-4">
    <li class="mb-3">
        <strong>Compliance with Law.</strong> 
        Each Party shall comply with all federal, state, and local rules, laws, regulations, and orders applicable to this Agreement and its performance hereunder.
    </li>

    <li class="mb-3">
        <strong>Assignment.</strong> 
        Neither Party will assign, delegate, or otherwise transfer its rights or obligations under this Agreement without prior written consent of the other Party. 
        However, either Party may assign this Agreement in connection with a merger, acquisition, or sale of all or substantially all of its assets, provided such assignment is not to a competitor. 
        Any assignment in violation of this clause is null and void.
    </li>

    <li class="mb-3">
        <strong>Governing Law, Jurisdiction, and Venue.</strong> 
        This Agreement shall be governed by the laws of the State of Delaware and the United States. 
        Any dispute shall be resolved exclusively in the state or federal courts located in Delaware.
    </li>

    <li class="mb-3">
        <strong>Notices.</strong> 
        All notices must be in writing.  
        If to <strong>Leadmine.pro</strong>, notices must be sent to:<br>
        SaaS Labs US, Inc., Attn: Legal, 355 Bryant Street, #403, San Francisco CA 94107,  
        <a href="mailto:sales@leadmine.pro">sales@leadmine.pro</a>.  
        If to the Partner, notices may be sent to the Partner’s email address on file.  
        Either Party may update its notice address by providing notice to the other Party.
    </li>

    <li class="mb-3">
        <strong>Entire Agreement.</strong> 
        This Agreement is the complete and exclusive understanding between the Parties, superseding all prior agreements or communications. 
        No agency, partnership, or joint venture is created by this Agreement, and you have no authority to bind <strong>Leadmine.pro</strong>.
    </li>

    <li class="mb-3">
        <strong>Survival.</strong> 
        The following sections survive termination: Indemnification, Governing Law, Intellectual Property Rights, Confidential Information, Limitation of Liability, and General Terms.
    </li>

    <li class="mb-3">
        <strong>Waivers and Severability.</strong> 
        Failure to enforce any right does not constitute a waiver. 
        If any provision is unenforceable, it will be modified minimally so the rest of the Agreement remains effective.
    </li>

    <li class="mb-3">
        <strong>Force Majeure.</strong> 
        Neither Party is liable for delays or failures caused by events beyond reasonable control, including strikes, war, terrorism, riots, utility failures, or natural disasters.
    </li>

    <li class="mb-3">
        <strong>Relationship of the Parties.</strong> 
        The Parties are independent contractors, not partners, agents, or joint venturers. 
        This Agreement does not restrict either Party from entering into agreements with others.
    </li>

    <li class="mb-3">
        <strong>Export.</strong> 
        Integration Partner agrees to comply with all U.S. and foreign export/import laws when using the <strong>Leadmine.pro</strong> product. 
        The Partner represents that it is not on any restricted U.S. government list and will not access or use the product in violation of export restrictions.
    </li>
</ol>

</div>


<!-- Applicant Privacy Notice -->
<div class="tab-pane fade" id="v-pills-applicant" role="tabpanel" aria-labelledby="v-pills-applicant-tab">

  <h1>Applicant Privacy Notice</h1>
</br>
  <p><strong>Last Updated:</strong> 14 December 2025</p>

  <p>This Privacy Notice for Applicants describes how SaaS Labs US, Inc. and its subsidiaries (collectively, “SaaS Labs,” “we,” “us,” and “our”) collect, use, and share personal information during the recruitment process.</p>

  </br>
  <h2>What is this Notice for?</h2>
  <p>This Privacy Notice tells you what to expect when we collect and use personal information about you, including the following:</p>

  <ul>
    <li>How we obtain your personal information;</li>
    <li>How we use your personal information;</li>
    <li>How and why we share your personal information with others;</li>
    <li>How long we store your personal information;</li>
    <li>Your rights;</li>
    <li>Where we may transfer your personal information;</li>
    <li>How we keep your personal information secure;</li>
    <li>Changes to this Privacy Notice; and</li>
    <li>Further questions and how to make a complaint.</li>
  </ul>

  </br>
  <h2>What do you need to do?</h2>
  <p>Please read this Privacy Notice carefully to understand how we control and process your personal information. By engaging with us, you confirm that you have read and understood this Privacy Notice.</p>

  <p><strong>Feedback?</strong> If you have any feedback on this Privacy Notice, please let us know at: <a href="mailto:sales@leadmine.pro">sales@leadmine.pro</a></p>

  <p><strong>Not Applicable.</strong> Please note that this Privacy Notice does not apply to (i) personal information about employees, contractors, or customers or to personal information that SaaS Labs collects for other purposes, which is subject to separate privacy notices, or (ii) any third-party websites and applications that you may use to submit a job application, which is governed by the applicable terms and policies of the third party.</p>

  <p>If you are offered and accept a role at SaaS Labs, your personal information collected during the recruiting process will become part of your employee file and will be governed by the SaaS Labs’ Employee Privacy Notice, a copy of which will be provided when you are on-boarded as an employee.</p>

  <h2>INFORMATION THAT WE COLLECT</h2>

  <p>We may collect your personal information from sources that include the following:</p>

  <ul>
    <li><strong>Information provided by you:</strong> You may voluntarily provide us with your personal information through an online job portal or internal database or by contacting us by email or other means;</li>
    <li><strong>Information collected from other individuals:</strong> We may collect your personal information from other individuals, such as our internal employee referral program, or from your references during the recruitment process including current or past employer and/or colleagues;</li>
    <li><strong>Information from public sources:</strong> We may collect personal information you submit in public forums, such as information made publicly available on a personal webpage, or public platforms such as LinkedIn or job portals;</li>
    <li><strong>Information from other third parties:</strong> We may collect information from external third parties, such as background information provided, contractors, consultants, and recruitment agencies.</li>
  </ul>

  <p>We, or the third parties on our behalf, may collect the following personal information during the applicant recruitment process:</p>

  <ul>
    <li><strong>Identification and contact details:</strong> This includes information such as your name with title, home and/or postal address, email address, telephone number, and other contact information, your gender, date of birth, nationality, and national identifiers</li>
    <li><strong>Employment History:</strong> This includes your resume, CV, cover letter, and/or job application that may contain information about your education, previous job titles and duties;</li>
    <li><strong>Diversity and Inclusion:</strong> Where allowed or required by law, this includes information such as ethnicity, gender identity, veteran status, or any disability or accommodation request during the recruitment process;</li>
    <li><strong>Educational Information:</strong> This includes degrees awarded transcripts, and other information in support of the job application;</li>
    <li><strong>Assessments and Presentations:</strong> For certain roles, we may collect information from an assessment of your skills where you may be requested to perform an assignment or present during the recruitment process. This may be recorded and shared with the relevant internal teams for recruitment purposes;</li>
    <li><strong>Work Permit:</strong> If required, this includes information that would let us know if you are authorized to work for us or one of the affiliates;</li>
    <li><strong>Reference Information:</strong> This includes contact details including name, phone number, email address, and job title of the references, information that we receive from a background check, and information provided by other third parties;</li>
    <li><strong>Background Check:</strong> To the extent permitted by law, we may choose to conduct a background check that will include verification of education, job history, references, and criminal records history;</li>
    <li><strong>Other Information:</strong> This includes any other information you may provide voluntarily at any time during phone screening phone calls, email exchanges, and interviews.</li>
  </ul>

  <h2>LEGAL BASIS FOR PROCESSING</h2>

  <ul>
    <li><strong>Consent:</strong> We may request your consent to process your personal information. You can withdraw your consent at any time by emailing <a href="mailto:sales@leadmine.pro">sales@leadmine.pro</a>.</li>
    <li><strong>Legitimate Interest:</strong> We may process your personal information for legitimate interests, including conducting, managing, and completing the recruitment process, and hiring candidates against open roles in SaaS Labs.</li>
    <li><strong>Legal Obligation:</strong> In certain situations, we may have a legal obligation to process your personal information. Further, we may need to process your personal information to defend our rights and legal claims.</li>
  </ul>

  <h2>HOW WE USE YOUR INFORMATION</h2>

  <ul>
    <li>To evaluate your application with respect to the role you have applied for;</li>
    <li>To fulfil a referral request when you are referred for a role with SaaS Labs by a SaaS Labs employee using our referral process;</li>
    <li>To communicate and inform you of the recruitment process and the status of your application;</li>
    <li>For compliance with any procedures, laws, and regulations that apply to us;</li>
    <li>For conducting background verification checks;</li>
    <li>To operate, evaluate, and improve the recruitment system, our application tracking, and recruitment activities;</li>
    <li>For conducting general business operations relating to accounting, recordkeeping, employment and legal functions;</li>
    <li>To establish, exercise, or defend against legal claims;</li>
    <li>To understand and improve our recruitment process.</li>
  </ul>

  <h2>DISCLOSING YOUR INFORMATION</h2>

  <p>We may share your personal information only as necessary to evaluate your application. We do not sell your information to others or share it except as described below:</p>

  <ul>
    <li><strong>Our Affiliates:</strong> We may share your personal information with our Affiliates to facilitate the recruitment process;</li>
    <li><strong>Service Providers:</strong> We may engage service providers to perform certain functions related to the recruitment process including receiving the application, receiving the resume, running the internal applicant tracking system, or performing background checks. These service providers shall use your personal information to provide the services;</li>
    <li><strong>Legal Requirement:</strong> We may disclose your personal information when authorized by law or as necessary to comply with a legal process. We may disclose personal information when required to protect and defend our rights;</li>
    <li><strong>Merger or Acquisition:</strong> If we merge or all our assets get acquired, then the personal information held by us will be one of the transferred assets;</li>
    <li><strong>Professional advisors:</strong> We may share your personal information with professional advisors such as lawyers, accountants, and auditors;</li>
    <li><strong>By Consent:</strong> We may share your personal information with any third party with your consent, and you may choose not to share or withdraw your consent at a later point in time.</li>
    <li><strong>Your employer/previous employers or references:</strong> We may be required to share your personal information when we contact your previous or current employer or references, or other organizations to verify your employment history, education, or your references.</li>
  </ul>

  <h2>HOW LONG WE RETAIN YOUR INFORMATION</h2>

  <p>We keep your personal information for no longer than necessary for the purposes for which it was obtained, and/or as required to comply with applicable laws and to establish, exercise or defend our legal rights.</p>

  <p>If SaaS Labs hires you, your personal information collected during the recruitment process will become part of your employee record, and may be used to administer the employment relationship and for related reporting and recordkeeping purposes. SaaS Labs will retain this application information for the entire duration of your employment relationship with SaaS Labs, and for as long thereafter as permitted or required by applicable law.</p>

  <p>If you would like to opt-out from SaaS Labs’ policy of retaining your information for the purposes of considering you for other suitable openings, please email <a href="mailto:sales@leadmine.pro">sales@leadmine.pro</a>.</p>

  <h2>HOW DO WE SECURE YOUR INFORMATION</h2>

  <p>Our top priority is to maintain the security of the information that we collect, use, and process in accordance with this Privacy Notice. We have taken industry-standard measures that maintain the security, integrity, and confidentiality of your personal information.</p>


  <p>You may also raise complaints with the statutory regulator in your jurisdiction. A list of contact details for the EEA data protection authorities is available here, and the U.K. authority is available here.</p>

  <h2>CHANGES TO THIS NOTICE</h2>

  <p>We may update this Privacy Notice from time to time. Any changes we make will be posted on this page. Please check this Notice periodically for updates.</p>

  <h2>INFORMATION FOR EEA AND U.K. APPLICANTS</h2>

  <p>The following information supplements this Privacy Notice with respect to our processing of the European Economic Area, and U.K. personal information. In the event of any conflict or inconsistency between this section and the rest of the Privacy Notice, this section shall govern and prevail with regard to the processing of EEA, and U.K. personal information.</p>

  <h3>Data Controller:</h3>
  <p>SaaS Labs with whom you are interacting is the controller of information collected within the scope of this Notice. In some cases, the local SaaS Labs entity will be the data controller. On some occasions, more than one SaaS Labs entity may process your personal information as independent controllers.</p>

  <h3>Legal Basis for Processing:</h3>
  <p>Please refer to the section ‘Legal Basis for Processing’ above on which we rely for the collection, processing, and use of your personal information.</p>

  <h3>Your Privacy Rights:</h3>
  <ul>
    <li>Right of access to your personal information. You can get access to a copy of your personal information and/or confirmation as to whether your personal information is being processed by us;</li>
    <li>Object to automated decision-making of your application; Presently, no automated decisions making with respect to your personal information takes place. Should this change, we will inform you about such automated decision making. You will also have the right to seek human intervention, and to contest the decision;</li>
    <li>Right to update your personal information we hold about you;</li>
    <li>Right to delete your information that we hold about you where there is no good reason for us to continue to process it;</li>
    <li>Right to restrict the processing of your personal information. This enables you to ask us to suspend the processing of personal information about you;</li>
    <li>Right to data portability of your personal information to another party;</li>
    <li>Object to processing your personal information where we rely on legitimate interest to process your personal information. Further, in case we ask for your consent to processing, you are free to refuse to give consent and/or you can withdraw your consent at any time without detriment.</li>
  </ul>

  <p>You may have the right to lodge a complaint with a supervisory authority in the country where you reside. The contact details for data supervisory authorities in the EEA are available here, and the U.K. here.</p>

  <p>We do not retaliate against any applicant who exercises their privacy rights.</p>

  <p>If you want to review, verify, correct, transfer, or request the erasure of your personal information, object to the processing of your personal information, or would like further information in relation to these rights, please contact us at <a href="mailto:sales@leadmine.pro">sales@leadmine.pro</a>.</p>

  <p>We will consider all requests and provide our responses within a reasonable period, and in any event within thirty (30) days of your request unless we request for an extension or are legally entitled to a longer period. Please note that certain personal information may be exempt from such requests in certain circumstances, for example if we need to keep using the information to comply with our own legal obligations or to establish, exercise or defend legal claims. If an exception applies, we will tell you this. We may request that you provide us with information necessary to confirm your identity before responding to any request.</p>

  <h3>International Transfers:</h3>
  <p>SaaS Labs is headquartered in the United States, and we have affiliates, operations and service providers in the United States and throughout the world. We and our service providers may transfer your personal information to, or access it from countries other than the one in which you are located. We have taken steps to ensure that your personal information receives an adequate level of protection where it is processed.</p>

  <p>Intra-group international transfers will be to countries where SaaS Labs entities are located, including the United States. The transfer of your personal information outside the EEA and the U.K. to the SaaS Labs group members located in third countries which do not offer an adequate level of protection in comparison with the EEA, or U.K. privacy standards are based on the EU Standard Contractual Clauses and/or the U.K. International Data Transfer Addendum, as applicable.</p>

  <h3>Data Protection Officer and EU Representative:</h3>
  <p>We have appointed IT Governance Europe Limited to act as our EU representative. To contact, please email <a href="mailto:sales@leadmine.pro">sales@leadmine.pro</a>.</p>

  <h2>INFORMATION FOR CALIFORNIA APPLICANTS</h2>

  <p>Pursuant to the California Consumer Privacy Act (“CCPA”), this section applies to certain personal information collected about you who are California residents and supplements the rest of our Notice above. This section does not apply to:</p>

  <ul>
    <li>Information about Applicants who are not California residents;</li>
    <li>Information about SaaS Labs’ employees who are based in California;</li>
  </ul>

  <p>In the event of a conflict between the terms of this section, and the rest of the Privacy Notice (except the ‘Information for EEA and U.K. Applicants), this section shall take precedence for California residents.</p>

  <h3>Categories of Information we collect:</h3>
  <p>Please refer to the section “Information that we collect” which contains the details of the categories of personal information that we collect. SaaS Labs does not sell or share personal information with third parties for purposes outside of that mentioned in this Privacy Notice.</p>

  <h3>Business Purposes for which information may be used:</h3>
  <p>Please refer to the section “How we use your Information” which contains the details of the different business purposes for which we process your personal information.</p>

  <h3>Parties with whom information may be shared:</h3>
  <p>Please refer to the section “Disclosing your Information” which contains the details on the third parties to with whom we may share your personal information.</p>

  <h3>Your California Privacy Rights:</h3>

  <ul>
    <li>Right of access to your personal information. You can get access to a copy of your personal information and/or confirmation as to whether your personal information is being processed by us;</li>
    <li>Right to know the personal information we store about you including the details of why we are processing it;</li>
    <li>Right to rectification or update any or all of your personal information that is inaccurate, incomplete or outdated;</li>
    <li>Right to delete your information that we hold about you where there is no good reason for us to continue to process it. Please note that we may be prevented from deleting any or all of your personal information where certain exception may apply.</li>
    <li>Right to limit processing of sensitive personal information that may hold about you.</li>
  </ul>

  <p>We do not retaliate against any Applicant who exercises their privacy rights.</p>

  <p>If you want to review, verify, correct, transfer or request erasure of your personal information, object to the processing of your personal information, or would like further information in relation to these rights, please contact us at <a href="mailto:sales@leadmine.pro">sales@leadmine.pro</a>.</p>

  <p>We will consider all requests and provide our responses within a reasonable period, and in any event within forty-five (45) days of your request unless we request for an extension or are legally entitled to a longer period. Please note that certain personal information may be exempt from such requests in certain circumstances, for example if we need to keep using the information to comply with our own legal obligations or to establish, exercise or defend legal claims. If an exception applies, we will tell you this. We may request that you provide us with information necessary to confirm your identity before responding to any request.</p>



</div>


                             <!-- Cookie Notice -->
<div class="tab-pane fade" id="v-pills-cookie" role="tabpanel" aria-labelledby="v-pills-cookie-tab">
    <h2 class="mb-4 fw-bold as-bold">Cookie Notice</h2>
    <p><strong>Last Updated: 14 November 2025</strong></p>

    <p>This Cookie Notice explains how SaaS Labs US, Inc. (“SaaS Labs”, “LeadMine.pro”, “we”, “us”, and “our”) use cookies and similar technologies to recognise you when you visit our website <strong>www.leadmine.pro</strong>. This helps us provide you with a good experience and also allows us to improve our website. Please read this together with our Privacy Policy.</p>

    <h3 class="mt-4 mb-3 as-h2">What is this Notice for?</h3>
    <p>This Cookie Notice tells you what to expect when you visit our website with respect to our use of Cookies and Similar Technologies. This Notice explains:</p>

    <ul class="ps-4">
        <li>1. What are Cookies?</li>
        </br>
        <li>2. The cookies that we use on our website</li>
        </br>
        <li>3. How we use cookies on our website</li>
        </br>
        <li>4. How to control Cookies & change browser settings</li>
        </br>
        <li>5. Changes to this Cookie Notice</li>
        </br>
        <li>6. How to contact us</li>
    </ul>

    </br>
    <p><strong>Feedback?</strong> Email us at <a href="mailto:sales@leadmine.pro" class="text-primary">sales@leadmine.pro</a>.</p>

    <h3 class="mt-4 mb-3 as-h2">What is a Cookie?</h3>
    <p>A cookie is a small data file placed on your browser or mobile device when you visit a website. Cookies allow a site to recognize your browser or mobile device and store information such as preferences.</p>

    <p>Cookies set by us are “First-Party Cookies”. Cookies set by third parties are “Third-Party Cookies”. These allow functionalities like analytics, advertising, and interactive tools.</p>

    <h3 class="mt-4 mb-3 as-h2">Cookies Used</h3>
    <p>We may use the following types of cookies:</p>

    <!-- STRICTLY NECESSARY COOKIES -->
    <h4 class="mt-4 mb-3 as-h4">Strictly Necessary Cookies</h4>
    <div class="table-responsive">
      <table class="table table-bordered table-striped align-middle cookie-table">
            <thead class="table-light">
                <tr>
                    <th>Cookies</th>
                    <th>Hostname</th>
                    <th>Party</th>
                    <th>Type of Cookie</th>
                    <th>Duration</th>
                </tr>
            </thead>
            <tbody>
                <tr><td>PHPSESSID</td><td>leadmine.pro</td><td>First Party</td><td>Strictly Necessary</td><td>364 days</td></tr>
                <tr><td>intercom-device-id-xxxxxxxxxxxx</td><td>leadmine.pro</td><td>First Party</td><td>Strictly Necessary</td><td>270 days</td></tr>
                <tr><td>poptin_old_user</td><td>leadmine.pro</td><td>First Party</td><td>Strictly Necessary</td><td>1 day</td></tr>
                <tr><td>OptanonAlertBoxClosed</td><td>.leadmine.pro</td><td>First Party</td><td>Strictly Necessary</td><td>365 days</td></tr>
                <tr><td>intercom-session-xxxxxxxxxxxx</td><td>leadmine.pro</td><td>First Party</td><td>Strictly Necessary</td><td>6 days</td></tr>
            </tbody>
        </table>
    </div>

    <!-- PERFORMANCE COOKIES -->
    <h4 class="mt-4 mb-3 as-h4">Performance Cookies</h4>
    <div class="table-responsive">
       <table class="table table-bordered table-striped align-middle cookie-table">
            <thead class="table-light">
                <tr>
                    <th>Cookies</th>
                    <th>Hostname</th>
                    <th>Party</th>
                    <th>Type of Cookie</th>
                    <th>Duration</th>
                </tr>
            </thead>
            <tbody>
                <tr><td>utm_medium</td><td>leadmine.pro</td><td>First Party</td><td>Performance</td><td>0 days</td></tr>
                <tr><td>_vwo_sn</td><td>leadmine.pro</td><td>First Party</td><td>Performance</td><td>0 days</td></tr>
                <tr><td>_vis_opt_s</td><td>leadmine.pro</td><td>First Party</td><td>Performance</td><td>99 days</td></tr>
                <tr><td>_clsk</td><td>leadmine.pro</td><td>First Party</td><td>Performance</td><td>0 days</td></tr>
                <tr><td>_uetvid</td><td>leadmine.pro</td><td>First Party</td><td>Performance</td><td>389 days</td></tr>
               
            </tbody>
        </table>
    </div>

    <!-- FUNCTIONALITY COOKIES -->
    <h4 class="mt-4 mb-3 as-h4">Functionality Cookies</h4>
    <div class="table-responsive">
        <table class="table table-bordered table-striped align-middle cookie-table">
            <thead class="table-light">
                <tr>
                    <th>Cookies</th>
                    <th>Hostname</th>
                    <th>Party</th>
                    <th>Type of Cookie</th>
                    <th>Duration</th>
                </tr>
            </thead>
            <tbody>
                <tr><td>MR</td><td>c.clarity.ms</td><td>Third Party</td><td>Functional</td><td>6 days</td></tr>
                <tr><td>ANONCHK</td><td>c.clarity.ms</td><td>Third Party</td><td>Functional</td><td>0 days</td></tr>
               
            </tbody>
        </table>
    </div>

    <!-- TARGETING COOKIES -->
    <h4 class="mt-4 mb-3 as-h4">Targeting Cookies</h4>
    <div class="table-responsive">
        <table class="table table-bordered table-striped align-middle cookie-table">
            <thead class="table-light">
                <tr>
                    <th>Cookies</th>
                    <th>Hostname</th>
                    <th>Party</th>
                    <th>Type of Cookie</th>
                    <th>Duration</th>
                </tr>
            </thead>
            <tbody>
                <tr><td>lidc</td><td>linkedin.com</td><td>Third Party</td><td>Targeting</td><td>0 days</td></tr>
                <tr><td>VISITOR_PRIVACY_METADATA</td><td>youtube.com</td><td>Third Party</td><td>Targeting</td><td>179 days</td></tr>
                
            </tbody>
        </table>
    </div>

    <h3 class="mt-4 mb-3 as-h2">How Do We Use Cookies?</h3>
    <p>We use cookies to operate our website, personalize content, analyze traffic, and share data with our advertising partners. You may withdraw consent at any time.</p>

    <h3 class="mt-4 mb-3 as-h2">Other Tracking Technologies</h3>
    <p>We may also use web beacons (“tracking pixels”) to understand user activity, traffic flow, and engagement.</p>

    <h3 class="mt-4 mb-3 as-h2">Controlling Cookies & Settings</h3>
    <p>You may control cookies using our Cookie Management Tool or browser settings. Blocking cookies may affect website functionality.</p>

    <p>Browser guides:</p>
    <ul class="ps-4">
        <li>Google Chrome</li>
        <li>Microsoft Edge</li>
        <li>Mozilla Firefox</li>
        <li>Safari</li>
    </ul>

    <p>Google Analytics Opt-Out: <a href="http://tools.google.com/dlpage/gaoptout" target="_blank">Google Tool</a></p>

    <h3 class="mt-4 mb-3 as-h2">Contact Information</h3>
    <p>Email: <a href="mailto:sales@leadmine.pro" class="text-primary">sales@leadmine.pro</a></p>

    <h3 class="mt-4 mb-3 as-h2">Changes to This Notice</h3>
    <p>We may update this Cookie Notice from time to time. Updates will be posted on this page.</p>
</div>




<!-- Refund Policy -->
<div class="tab-pane fade" id="v-pills-refund" role="tabpanel" aria-labelledby="v-pills-refund-tab">
    <h2 class="mb-4 as-h2">Refund Policy</h2>

    <p class="mb-4">
        Upon account cancellation, you don't get refund for your past payments. Your card is not charged from the next billing cycle. 
        If you remove a user from your account, the new downgraded plan is applicable from the next billing cycle.
    </p>

    <p class="mb-4">
        In case of an account upgrade (new number or new team member added), you are not charged the full amount,
        but only the prorated amount for the remaining days of the billing cycle.
        For example, if your billing cycle is from the 1st of every month and you added a new member on the 15th,
        then you will be charged only 50% for this new member.
    </p>

    <p class="mb-4">
        This refund policy is applicable to all past payments including: subscription fees, calling credits,
        call costs, texting (SMS & MMS) costs, fax costs, porting fees, and any other custom engineering fees.
    </p>

    <h3 class="mt-5 mb-3 as-h2">Refund requests are accepted only in the following cases:</h3>
    <ul class="mb-4 ps-4">
        <li class="list">1. Duplicate payment</li>
        <li class="list">2. Charges made by mistake after account cancellation</li>
    </ul>

    <div class="alert alert-info">
        <p class="mb-0">
            <strong>Note:</strong> This refund policy applies to all transactions made on LeadMine.pro.
        </p>
    </div>
</div>


<!-- Responsible Disclosure Policy -->
<div class="tab-pane fade" id="v-pills-disclosure" role="tabpanel" aria-labelledby="v-pills-disclosure-tab">
    <h2 class="mb-4 as-h2">Responsible Disclosure Policy</h2>

    <p>
        At SaaS Labs US, Inc. (“SaaS Labs”), ensuring the safety and security of our customers' data and the reliability of our products—including <strong>Leadmine.pro</strong>—is of utmost importance to us. Despite best efforts, complex systems may still contain vulnerabilities.
    </p>

    <h3 class="mt-4 as-h4">Purpose</h3>
    <p>
        This policy outlines SaaS Labs' methods for identifying and addressing potential vulnerabilities. It encourages all users, researchers, partners, and anyone interacting with <strong>Leadmine.pro</strong> to report any issues responsibly.
    </p>

    <h3 class="mt-4 as-h4">Submitting a Report</h3>
    <p>
        The preferred method to report vulnerabilities is via email at:
        <strong>sales@leadmine.pro</strong>
    </p>
    <p>Please include:</p>

    <ul class="ps-4">
        <li>Description of location and potential impact.</li>
        <li>Steps to reproduce (POC scripts, screenshots, recordings, etc.).</li>
        <li>Your name/handle (optional) for recognition in our Hall of Fame.</li>
    </ul>

    <p>
        Providing your name is optional. If shared, it will only be used to contact you for clarification and to list you in our Hall of Fame.
    </p>

    <h3 class="mt-4 as-h4">What to Expect</h3>
    <p>
        SaaS Labs will acknowledge your report within three (3) working days and keep you informed of remediation progress. We will work with you to understand and resolve the issue quickly.
    </p>

    <h3 class="mt-4 as-h4">Terms</h3>
    <p>By submitting a report, you agree that:</p>

    <ul class="ps-4">
        <li>SaaS Labs may use your report to improve systems.</li>
        <li>Any improvement suggestions are assigned to SaaS Labs.</li>
    </ul>

    <h3 class="mt-4 as-h4">Scope</h3>

    <ul class="ps-4">
    
        <li>*.leadmine.pro</li>
        <li>app.leadmine.pro</li>
    </ul>

    <h3 class="mt-4 as-h4">Out-of-Scope Vulnerabilities</h3>
    <ul class="ps-4">
        <li>Third-party hosted services.</li>
        <li>Denial of service.</li>
        <li>Spam or message flooding.</li>
        <li>Social engineering of SaaS Labs or Leadmine.pro staff.</li>
        <li>Any physical security tests on Leadmine.pro properties or data centers.</li>
        <li>Content spoofing / text injection.</li>
        <li>Self-XSS.</li>
        <li>Low-severity CSRF issues.</li>
        <li>Low-impact open redirects.</li>
        <li>Missing HTTP security headers.</li>
        <li>Missing cookie flags on non-sensitive cookies.</li>
        <li>Password/account recovery policy weaknesses.</li>
        <li>Invalid SPF, DKIM records.</li>
        <li>SSL/TLS best-practice gaps.</li>
        <li>Clickjacking/UI redressing without impact.</li>
        <li>Username/email enumeration via login/reset pages.</li>
    </ul>

    <p>If you need clarifications, contact us at <strong>sales@leadmine.pro</strong>.</p>

    <h3 class="mt-4 as-h4">Rules</h3>
    <p>You must NOT:</p>
    <ul class="ps-4">
        <li>Exploit vulnerabilities beyond what is required for reporting.</li>
        <li>Perform harmful testing.</li>
        <li>Delete/alter/destroy any data.</li>
        <li>Conduct phishing, social engineering, or spam attacks.</li>
        <li>Test physical security of SaaS Labs or Leadmine.pro.</li>
        <li>Break any applicable laws.</li>
        <li>Disclose vulnerabilities to third parties.</li>
        <li>Demand rewards for disclosing vulnerabilities.</li>
    </ul>

    <p>You MUST:</p>
    <ul class="ps-4">
        <li>Avoid violating privacy or disrupting systems.</li>
        <li>Stay within the defined scope.</li>
        <li>Keep all collected information confidential.</li>
    </ul>

    <h3 class="mt-4 as-h4">If You Follow the Policy</h3>
    <ul class="ps-4">
        <li>SaaS Labs will not pursue legal action for your research.</li>
        <li>You may be recognized in our Hall of Fame (if first reporter).</li>
    </ul>

    <p>SaaS Labs may update this policy at any time without notice.</p>

    <h3 class="mt-4 as-h4">Hall of Fame</h3>
    <p>
        SaaS Labs recognizes contributors in our Hall of Fame who responsibly report security issues. Inclusion is at the sole discretion of SaaS Labs.
    </p>

</div>


<!-- GDPR Compliance HTML Updated for Leadmine.pro -->
<div class="tab-pane fade" id="v-pills-gdpr" role="tabpanel" aria-labelledby="v-pills-gdpr-tab">
    <h2 class="mb-4 fw-bold bold">GDPR Compliance</h2>

    <h3 class="mt-4 mb-3 as-h2">INTRODUCTION</h3>
    <p>The European Union’s General Data Protection Regulation (GDPR) represents the most comprehensive overhaul of data privacy legislation in decades, which took effect on May 25, 2018. This regulation establishes a modern framework for data protection that addresses the realities of today’s digital landscape, where personal information flows across borders and through complex technological systems. The GDPR introduces enhanced individual rights, stricter accountability requirements for organizations, and significant penalties for non-compliance, all designed to give people greater control over their personal data.</p>

    <h3 class="mt-4 mb-3 as-h2">OUR COMMITMENT</h3>
    <p>At <strong>Leadmine.pro</strong>, we take data privacy very seriously. We have built our data protection program around the principle that protecting personal data is not just a legal requirement, but a fundamental responsibility to our Customers whose data flows through our platform. Our approach emphasizes transparency, security, and accountability at every stage of data handling.</p>

    <p>We do not own, control, or direct the use of any of the Customer Data stored or processed by a Customer or Authorized User via the Service. <strong>Leadmine.pro</strong> operates as a data processor under the GDPR framework, meaning we handle personal data exclusively on behalf of our Customers who serve as data controllers. As a processor, we do not make independent decisions about why or how personal data is processed – these determinations rest with our controller Customers.</p>

    <p>We recognize that as a processor serving Customers across multiple jurisdictions, including the EU and UK, we must maintain the highest standards of data protection to support our controller Customers’ compliance obligations.</p>

    <h3 class="mt-4 mb-3 as-h2">PREPARATION AND IMPLEMENTATION</h3>

    <h4 class="mt-3 mb-2 as-h4">Policies and Procedures</h4>
    <ul class="ps-4">
        <li>Data Processing Addendums: Available on request, clearly defining our processor role, security measures, and procedures.</li>
        <li>Incident Response: 24/7 monitoring and rapid breach notifications.</li>
        <li>Data Retention: Customer Data is retained per our Privacy Policy/Notice.</li>
        <li>International Transfers: Standard Contractual Clauses used for cross‑border transfers.</li>
    </ul>

    <h4 class="mt-3 mb-2 as-h4">Controller Support Systems</h4>
    <ul class="ps-4">
        <li>Data Subject Request Assistance: Tools to locate, export, modify, or delete personal data.</li>
        <li>Data Protection Impact Assessment Support.</li>
        <li>Privacy Controls including Pause Transcription and Redaction Settings.</li>
    </ul>

    <h4 class="mt-3 mb-2 as-h4">Sub‑Processor Management</h4>
    <ul class="ps-4">
        <li>All third‑party processors are vetted and bound by strict DPAs.</li>
        <li>Controllers are notified of sub‑processor additions with a right to object.</li>
    </ul>

    <h4 class="mt-3 mb-2 as-h4">Privacy by Design</h4>
    <ul class="ps-4">
        <li>GDPR considerations built into all new features, including AI‑based capabilities.</li>
    </ul>

    <h3 class="mt-4 mb-3 as-h2">DATA SUBJECT RIGHTS SUPPORT</h3>
    <p>As a data processor, <strong>Leadmine.pro</strong> assists data controllers in fulfilling their obligations to respond to data subject requests. We provide technical and administrative support to help data controllers address requests under GDPR.</p>

    <p>Please note that <strong>Leadmine.pro</strong> does not directly handle data subject requests. All such requests must be directed to the relevant data controller.</p>

    <h3 class="mt-4 mb-3 as-h2">INTERNATIONAL DATA TRANSFER</h3>
    <p><strong>Leadmine.pro</strong> is based and hosted in the United States, and all call recordings and related personal data are stored in secure US‑based data centers. We implement appropriate safeguards including Standard Contractual Clauses for international transfers.</p>

    <h3 class="mt-4 mb-3 as-h2">TECHNICAL AND ORGANIZATIONAL MEASURES</h3>
    <ul class="ps-4">
        <li>TLS encryption for data in transit.</li>
        <li>Industry‑standard encryption for data at rest.</li>
        <li>Role‑based access controls.</li>
        <li>Continuous monitoring for unusual access patterns.</li>
        <li>Data Protection Officer oversight and employee GDPR training.</li>
    </ul>

    <p>For more information on our technical and organizational measures, please visit the Leadmine.pro Trust Center.</p>

    <h3 class="mt-4 mb-3 as-h2">CONTACT INFORMATION</h3>
    <p>If you have any questions about this GDPR Statement or our privacy/security practices, please contact us:</p>
    <p><strong>Email:</strong> sales@leadmine.pro</p>
</div>





<!-- LeadMine.pro Referral Program Terms -->
<div class="tab-pane fade" id="v-pills-referral" role="tabpanel" aria-labelledby="v-pills-referral-tab">
    <h2>LeadMine.pro Referral Program Terms</h2>
    <p>These LeadMine.pro Referral Program Terms (hereinafter, the “Referral Terms”) govern your participation in the LeadMine.pro Referral Program. These Referral Terms are subject to and governed by the LeadMine.pro Terms and Conditions or any other MSA entered between the referring party (referred to as “You” or “Referrer”), and SaaS Labs US, Inc. (referred to as “LeadMine.pro” or “SaaS Labs”).</p>

    <p>LeadMine.pro and the Referrer together are referred to as “Parties” and singularly as “Party”.</p>

    <p>LeadMine.pro reserves the right, at its sole discretion, to prohibit any Referrer and Referee from participating or further participating in any aspect of the LeadMine.pro Referral Program if LeadMine.pro deems or suspects that such Referrer and Referee has engaged in or attempted to engage in any of the following activities:</p>

    <ul>
        <li>• Acting in violation of the Terms of the LeadMine.pro Customer Referral Program or LeadMine.pro Terms and Conditions.</li>
        <li>• Damaging, tampering with or corrupting the operation of the LeadMine.pro Referral Program.</li>
        <li>• Any conduct or activity of the Referrer deemed in the sole discretion of LeadMine.pro to be inconsistent with the intended operation of the LeadMine.pro Referral Program.</li>
    </ul>

    <p>LeadMine.pro shall be the sole determiner in cases of suspected abuse, fraud, or breach of these Terms.</p>

    <h3>1. Definitions</h3>
    <ul>
        <li><strong>Affiliate:</strong> Any entity that controls, is controlled by, or is under common control with the subject entity.</li>
        <li><strong>Customer:</strong> The Referee who enters into a valid agreement with LeadMine.pro to procure the Service via the Referral Link.</li>
        <li><strong>Eligible Subscription Plan:</strong> A paid subscription with LeadMine.pro on the Team Plan or above, active for at least ninety (90) days from sign-up.</li>
        <li><strong>Ineligible Referral:</strong> Leads defined in Clause 2.2.</li>
        <li><strong>Referrer:</strong> Existing customers of LeadMine.pro with a valid tax ID and an active LeadMine.pro account in good standing for at least ninety (90) days.</li>
        <li><strong>Referee:</strong> A valid lead referred by the Referrer, not including Ineligible Referrals.</li>
        <li><strong>Referral Link:</strong> The unique URL provided by LeadMine.pro to the Referrer.</li>
        <li><strong>Services:</strong> LeadMine.pro services sold via www.leadmine.pro.</li>
    </ul>
</br>

    <h3>2. Overview of the Program</h3>
    <ul>
        <li>• Referrer and Referee receive Gift Cards only if the Referee uses the Referral Link to create a LeadMine.pro account and signs up for an Eligible Subscription Plan.</li>
        <li>• Ineligible Referrals include:
            <ul>
                <li>a) Existing customers of LeadMine.pro before referral.</li>
                <li>b) Leads already in LeadMine.pro’s sales pipeline or in process 60 days prior.</li>
                <li>c) The Referrer itself, its owned entities, or employer.</li>
                <li>d) Affiliates of the Referrer.</li>
                <li>e) Leads creating a LeadMine.pro account without using the Referral Link.</li>
            </ul>
        </li>
        <li>• Gift Card amounts for Referrer:
            <ul>
                <li>a) USD 100 for monthly plan signup.</li>
                <li>b) USD 200 for annual plan signup.</li>
            </ul>
        </li>
        <li>• Gift Card amounts for Referee:
            <ul>
                <li>a) USD 50 for monthly plan signup.</li>
                <li>b) USD 100 for annual plan signup.</li>
            </ul>
        </li>
        <li>• Gift Cards valid for six (6) months from date of issue.</li>
        <li>• All Gift Cards sent to the registered email address linked to the LeadMine.pro account.</li>
        <li>• Taxes applicable and responsibility of Referrer/Referee.</li>
        <li>• Referrer shall not post Referral Link on adult, obscene, defamatory, or illegal sites, or use it for spam.</li>
        <li>• If multiple Referral Links are received, only the one used during signup qualifies.</li>
    </ul>

    </br>
    <h3>3. Term and Termination</h3>
    <p>The Term begins when the Referrer shares the Referral Link or when Referee signs up using it, and continues until either Party terminates or the Referrer/Referee ceases to be a customer. LeadMine.pro may terminate participation at any time with written email notice. Only referrals submitted before termination will be processed.</p>

    </br>

    <h3>4. Trademarks</h3>
    <p>Each Party owns its trademarks. Referrer may not display LeadMine.pro trademarks to promote Referral Links.</p>

    </br>

    <h3>5. Indemnification</h3>
    <p>The Referrer will defend and indemnify LeadMine.pro, its affiliates, directors, officers, and employees against all claims arising out of participation or breach of the Referral Terms.</p>

    </br>

    <h3>6. Disclaimers; Limitation of Liability</h3>
    <p>Program is provided “as is”. Neither Party is liable for consequential damages. Total liability is limited to the amount paid to the Referrer in the three months prior to the first claim.</p>

    </br>

    <h3>7. General</h3>
    <p>This Agreement is governed by the laws of Delaware, USA. LeadMine.pro may modify terms from time to time. Notices must be sent to <strong>sales@leadmine.pro</strong>. Agreement cannot be assigned without consent.</p>
</div>


                         


                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- ================== Privacy Policy End ====================== -->



</div>
@endsection
