@extends('website.layout')

@section('meta')


 <title>@yield('seo_title', config('app.site') . ' | AI Call Monitoring Software for Better Calls')</title>
    <meta name="description" content="@yield('seo_description', 'Learn how ' . config('app.site') . '’s AI call monitoring software improves team performance with real-time insights, call scoring, and easy-to-use coaching tools.')">
    <meta name="keywords" content="@yield('seo_keywords', 'AI-powered customer service, 24/7 AI answering service, call center solutions, ' . config('app.site') . ', Cost-efficient customer support with AI')">

    <meta property="og:title" content="@yield('seo_title', config('app.site') . ' | AI Call Monitoring Software for Better Calls')">
    <meta property="og:description" content="@yield('seo_description', 'Learn how ' . config('app.site') . '’s AI call monitoring software improves team performance with real-time insights, call scoring, and easy-to-use coaching tools.')">
    
@endsection



@section('content')
<script src="https://cdn.jsdelivr.net/npm/swiper@9/swiper-bundle.min.js"></script>

<link rel="preload"
      as="image"
      href="{{ asset('web/assets/images/contactHero.webp') }}"
      fetchpriority="high"
      type="image/webp">


<style>
.accordion-button .accordion-arrow {
  transition: transform 0.3s ease;
  font-size: 1rem;
  margin-left: auto;
}

.accordion-button:not(.collapsed) .accordion-arrow {
  transform: rotate(180deg);
}

.section-padding-y {
    padding: 110px 0;
}

.custom-heading {
    font-size: clamp(1.75rem, 5vw, 2.5rem);
    font-weight: 600;
    line-height: 1.3;
}

.custom-paragraph {
    color: #dcdcdc;
    font-size: 1rem;
    margin-top: 1.5rem;
    max-width: 388px;
}

.spacing-group {
    gap: 1.5rem;
    margin-top: 0.5rem;
    margin-bottom: 34px;
}

.custom-btn-stroke {
    padding: 0.75rem 2.5rem;
    border: 2px solid #00B2FF;
    background-color: transparent;
    color: #00B2FF;
    transition: all 0.3s ease;
}

.custom-dashboard-img {
    max-width: 100%;
    border-radius: 12px;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
}

.custom-section-spacing {
    margin-top: -100px;
    padding-bottom: 50px;
}

.custom-perspective {
    perspective: 100px;
}

.custom-feature-heading {
    perspective: 100px;
    font-size: clamp(1.5rem, 3vw, 1.75rem);
}

.custom-features {
    font-size: clamp(1.5rem, 3vw, 1.75rem);
}

.custom-subheading {
    perspective: 100px;
    margin-bottom: 15px;
}

.custom-subheading-text {
    text-align: start;
    font-size: clamp(1.25rem, 2.5vw, 1.75rem);
}

.custom-responsive-paragraph {
    perspective: 100px;
    line-height: 1.6;
    font-size: clamp(1rem, 1.25vw, 1.1rem);
}

.custom-centered-title {
    display: block;
    text-align: center;
    font-size: clamp(1.5rem, 3vw, 1.75rem);
}

.custom-centered-paragraph {
    display: block;
    text-align: center;
}

.custom-feature-item {
    gap: 26px;
    margin-bottom: 10px;
}

.custom-feature-description {
    line-height: 1.55em;
    max-width: 400px;
}

.custom-padding-50 {
    padding: 50px 0;
}

.custom-gradient-bg {
    background: linear-gradient(0deg, #6767a8 0%, rgba(145, 145, 208, 0) 100%);
}

.custom-font-responsive-sm {
    font-size: clamp(0.9rem, 1.1vw, 1rem);
}

.custom-margin-top-30 {
    margin-top: 30px;
}

.custom-header {
  font-weight: 400;  
}

.custom-goal-heading {
  font-weight: 400;
  font-size: clamp(1rem, 2.5vw, 1.5rem); 
  line-height: 1.3;
  margin-top: 1rem;     
  margin-bottom: 0.75rem;
}

.accordion-btn-style {
  font-weight: 500;
  font-size: clamp(1rem, 1.25vw, 1.1rem);
}

.orchid-bg {
  background-color: orchid;
}

.half-width {
  width: 50%;
}

.max-width-40 {
  max-width: 40%;
}

.beige-bg {
  background-color: beige;
}

.cadetblue-bg {
  background-color: cadetblue;
}

.burlywood-bg {
  background-color: burlywood;
}

.mt-minus-10 {
  margin-top: -10px;
}

.custom-box-style {
  min-height: 320px;
  padding: 40px;
}

.heading-responsive-medium {
  font-size: clamp(0.9rem, 2vw, 1.25rem);
  font-weight: 600;
}

.text-small-responsive {
  font-size: clamp(0.8rem, 1.5vw, 1rem);
}

.img-rating-responsive {
  width: clamp(80px, 12vw, 120px);
}

.paragraph-responsive {
  font-size: clamp(0.9rem, 1.5vw, 1.1rem);
  line-height: 1.6;
}

.section-poppins {
  font-family: 'Poppins', sans-serif;
}

.feature-title {
  font-size: clamp(1rem, 0.769rem + 0.6813vw, 1.25rem);
  font-weight: 400; 
  line-height: 1.4; 
  margin: 0;
}


.small-heading {
  font-size: clamp(1.5rem, 0.5569rem + 1.444vw, 1.875rem);
  line-height: 1.4; 
}

.as-tag {
  font-size: clamp(1.125rem, 1.2rem + 0.722vw, 1.5rem) !important;
     line-height: 1.2;
    font-weight: 700;
}

.as-tag1 {
  font-size: clamp(0.9rem, 2vw, 1.25rem) !important;
  font-weight: 600;
}

.as-sub {
    font-weight: 500;
    font-size: clamp(1rem, 2.5vw, 1.5rem) !important;
    line-height: 1.3;
}

.custom-dashboard-img {
  width: 100%;
  max-width: 400px; 
  height: auto;
  transform: scale(1.1);
  transition: transform 0.3s ease-in-out;
}

@media (max-width: 991px) {
  .custom-dashboard-img {
    max-width: 100%;
    transform: none;
  }
}


.hero-subtitle {
  font-size: 2.2rem;
  line-height: 1.3;
}


.hero-desc {
  font-size: 1.05rem;
}


.hero-btn {
  transition: 0.3s ease;
  background-color: transparent;
  color: #00B2FF;
}

.hero-btn:hover {
  background-color: #00B2FF !important;
  color: #fff !important;
  transform: translateY(-3px) scale(1.05);
}

</style>

<!-- ============================== Top Features Section start ============================== -->
<div class="bg-white border-top border-neutral-100 tw-py-4 common-shadow-one">
    <div class="container">
        <div class="top-features-slider overflow-hidden left-right-gradient position-relative">
            <div class="d-flex align-items-center tw-gap-4">
                <span>
                    <img src="web/assets/images/icons/chart-icon.svg" alt="chart-icon">
                </span>
                <span class="text-heading fw-medium tw-text-base">Perfect solution for success</span>
            </div>
            <div class="d-flex align-items-center tw-gap-4">
                <span>
                    <img src="web/assets/images/icons/chart-icon.svg" alt="chart-icon">
                </span>
                <span class="text-heading fw-medium tw-text-base">Excellence in tailored IT Services</span>
            </div>
            <div class="d-flex align-items-center tw-gap-4">
                <span>
                    <img src="web/assets/images/icons/chart-icon.svg" alt="chart-icon">
                </span>
                <span class="text-heading fw-medium tw-text-base">Elevate your brand ai-coach</span>
            </div>
            <div class="d-flex align-items-center tw-gap-4">
                <span>
                    <img src="web/assets/images/icons/chart-icon.svg" alt="chart-icon">
                </span>
                <span class="text-heading fw-medium tw-text-base">Achieve business goals solution</span>
            </div>
            <div class="d-flex align-items-center tw-gap-4">
                <span>
                    <img src="web/assets/images/icons/chart-icon.svg" alt="chart-icon">
                </span>
                <span class="text-heading fw-medium tw-text-base">Innovation in every presence</span>
            </div>
        </div>
    </div>
</div>



<!-- ============================== Top Features Section end ============================== -->
<section class="position-relative z-2 gradient-bg-two section-poppins hero-section">
  <div class="position-relative section-padding-y">
    <div class="container">

      <div class="swiper heroSwiper">
        <div class="swiper-wrapper">

          <!-- ========== Slide 1 ========== -->
          <div class="swiper-slide">
            <div class="row gy-4 align-items-center">
              <div class="col-lg-6">
                <h1 class="splitTextStyleOne text-white text-capitalize tw-leading-none custom-heading">
                  AI Receptionist
                </h1>

                <h2 class="fw-bold mb-3 text-yellow hero-subtitle">
                  ‍Unload Your Staff Burden
                </h2>

                <p class="text-white mb-4 hero-desc">
                  Overburdened staff miss calls, lose patient trust, and struggle to keep up.
                  With AI Receptionist, your phone is always answered — even after hours.
                  Let your team focus on care, not calls. No more missed opportunities.
                </p>

                <div class="d-flex align-items-center flex-wrap spacing-group">
                  <a href="{{ route('register') }}"
                    class="btn btn-main button--stroke rounded-pill fw-semibold custom-btn-stroke hero-btn">
                    Get Started
                  </a>
                </div>
              </div>

          <div class="col-xl-6 col-lg-6 col-md-12 text-center">
             <img
                 src="{{ asset('web/assets/images/contactHero.webp') }}"
                 alt="AI Call Analytics dashboard"
                 class="hero-image custom-dashboard-img"
                 fetchpriority="high"
                 width="720"
                 height="460">

              </div>
            </div>
          </div>

          <!-- ========== Slide 2 ========== -->
          <div class="swiper-slide">
            <div class="row gy-4 align-items-center">
              <div class="col-lg-6">
                <h2 class="splitTextStyleOne text-white text-capitalize tw-leading-none custom-heading">
                  AI Answering
                </h2>

                <h2 class="fw-bold mb-3 text-yellow hero-subtitle">
                  Unload Your Employee Burden
                </h2>

                <p class="text-white mb-4 hero-desc">
                  Transform your business with 24/7 AI phone assistance.
                  Build a centralized knowledge base that grows with your business
                  and never loses institutional knowledge when staff leave.
                </p>

                <div class="d-flex align-items-center flex-wrap spacing-group">
                  <a href="{{ route('register') }}"
                    class="btn btn-main button--stroke rounded-pill fw-semibold custom-btn-stroke hero-btn">
                    Get Started
                  </a>
                </div>
              </div>

              <div class="col-xl-6 col-lg-6 col-md-12 text-center">
                <img src="{{ asset('web/assets/images/bg/ai.jpg') }}" alt="AI Call Analytics dashboard"
                  class="hero-image custom-dashboard-img">
              </div>
            </div>
          </div>

          <!-- ========== Slide 3 ========== -->
          <div class="swiper-slide">
            <div class="row gy-4 align-items-center">
              <div class="col-lg-6">
                <h2 class="splitTextStyleOne text-white text-capitalize tw-leading-none custom-heading">
                  Supercharge Phone Support
                </h2>

                <h2 class="fw-bold mb-3 text-yellow hero-subtitle">
                  with AI Voice Agents
                </h2>

                <p class="text-white mb-4 hero-desc">
                  Eliminate outsourcing failures with native-quality AI agents that speak 50+ languages,
                  provide instant responses, and deliver real-time sentiment insights to transform your customer experience.
                </p>

                <div class="d-flex align-items-center flex-wrap spacing-group">
                  <a href="{{ route('register') }}"
                    class="btn btn-main button--stroke rounded-pill fw-semibold custom-btn-stroke hero-btn">
                    Get Started
                  </a>
                </div>
              </div>

              <div class="col-xl-6 col-lg-6 col-md-12 text-center">
                <img src="{{ asset('web/assets/images/bg/home-financial-services.webp') }}" alt="AI Call Analytics dashboard"
                  class="hero-image custom-dashboard-img">
              </div>
            </div>
          </div>

        </div>

        <div class="swiper-pagination mt-3"></div>
      </div>

    </div>
  </div>
</section>


<!-- ========== SwiperJS Script ========== -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />
<script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
<script>
  var swiper = new Swiper(".heroSwiper", {
    loop: true,
    autoplay: {
      delay: 5000,
      disableOnInteraction: false,
    },
    speed: 1000,
    pagination: {
      el: ".swiper-pagination",
      clickable: true,
    },
  });
</script>




<!-- ============================= Banner Section End ============================== -->

<section class="switch-section py-5">
  <div class="container text-center">
    <div class="tw-mb-13 text-center">
      <span
        class="tw-py-1 tw-px-705 bg-main-50 text-main-600 tw-text-sm fw-bold text-capitalize rounded-pill tw-mb-205">
        Why {{ config('app.site') }}?
      </span>

      <h2 class="splitTextStyleOne custom-perspective">
        <div class="split-line custom-centered-title">
          Customer Service Challenges Companies Face
        </div>
      </h2>

      <p class="text-gray-600 tw-max-w-[700px] mx-auto mt-3">
        Traditional customer support struggles with efficiency, cost, and consistency. These challenges directly impact
        customer satisfaction and business growth.
      </p>
    </div>

    <div class="row g-4">
      <!-- Card 1 -->
      <div class="col-md-4">
        <div class="switch-card">
          <img src="web/assets/images/call.svg" alt="Long Wait Times" class="icon">
          <h5>Long Wait Times</h5>
          <p>
            Customers wait 5–15 minutes on average, leading to frustration and abandoned calls.
          </p>
        </div>
      </div>

      <!-- Card 2 -->
      <div class="col-md-4">
        <div class="switch-card">
          <img src="web/assets/images/chart.svg" alt="High Operational Costs" class="icon">
          <h5>High Operational Costs</h5>
          <p>
            Hiring, training, and maintaining large support teams is expensive and time-consuming.
          </p>
        </div>
      </div>

      <!-- Card 3 -->
      <div class="col-md-4">
        <div class="switch-card">
          <img src="web/assets/images/thumbs-down.svg" alt="Inconsistent Service Quality" class="icon">
          <h5>Inconsistent Service Quality</h5>
          <p>
            Verbal orders on the phone can lead to mistakes — especially with accents, background noise, or fast talkers.
          </p>
        </div>
      </div>

      <!-- Card 4 -->
      <div class="col-md-4">
        <div class="switch-card">
          <img src="web/assets/images/time.svg" alt="Limited Availability" class="icon">
          <h5>Limited Availability</h5>
          <p>
            Traditional support operates during business hours, missing global customer needs.
          </p>
        </div>
      </div>

      <!-- Card 5 -->
      <div class="col-md-4">
        <div class="switch-card">
          <img src="web/assets/images/User.svg" alt="High Employee Turnover" class="icon">
          <h5>High Employee Turnover</h5>
          <p>
            Support roles have a 75% annual turnover rate, causing constant training and knowledge loss.
          </p>
        </div>
      </div>

      <!-- Card 6 -->
      <div class="col-md-4">
        <div class="switch-card">
          <img src="web/assets/images/block.svg" alt="Failed Outsourcing Attempts" class="icon">
          <h5>Failed Outsourcing Attempts</h5>
          <p>
            Companies outsource phone support to reduce costs but often get poor service, language barriers, and disconnected customer experiences.
          </p>
        </div>
      </div>
    </div>

    <!-- CTA -->
<div class="text-center mt-5 ready-section">
  🚀 Ready to eliminate these challenges?
  <a href="{{ route('register') }}" class="ready-link">
    Try Leadmine.pro Today
  </a>
</div>

  </div>
</section>



<style>
.ready-section {
  font-family: 'Poppins', sans-serif;
  font-size: 1.1rem;
}


.ready-link {
  color: #0d6efd;
  text-decoration: none;
  font-weight: 600;
  transition: 0.3s ease;
}

.ready-link:hover {
  text-decoration: underline;
}


.switch-section {
  background: #fff;
}

.switch-card {
  background: #fff;
  border: 1px solid #e6e6e6;
  border-radius: 16px;
  padding: 40px 25px;
  height: 100%;
  text-align: left;
  transition: all 0.3s ease;
}

.switch-card:hover {
  box-shadow: 0 8px 20px rgba(0, 0, 0, 0.05);
  transform: translateY(-3px);
}

.switch-card .icon {
  width: 60px;
  height: 60px;
  background: #f0f4ff;
  border-radius: 12px;
  padding: 10px;
  margin-bottom: 20px;
}

.switch-card h5 {
  font-weight: 700;
  color: #0b1b4f;
  margin-bottom: 15px;
  font-size: 1.15rem;
}

.switch-card p {
  color: #4f5b7d;
  font-size: 0.95rem;
  line-height: 1.6;
}


.callchex-section {
  background: #fff;
}
.info-card {
  background: #fff;
  border-radius: 12px;
  padding: 25px;
  box-shadow: 0 2px 8px rgba(0,0,0,0.08);
  height: 100%;
  text-align: center;
  transition: all 0.3s ease;
}
.info-card:hover {
  box-shadow: 0 6px 16px rgba(0,0,0,0.12);
  transform: translateY(-4px);
}
.info-title {
  font-family: 'Poppins', sans-serif;
  font-weight: 600;
  font-size: 1.1rem;
  margin-bottom: 12px;
  background: linear-gradient(90deg, #e91e63, #3f51b5);
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
}
.info-text {
  font-family: 'Jost', sans-serif;
  font-size: 0.95rem;
  color: #444;
  line-height: 1.6;
}



.business-section {
  background-color: #f7f8fa;
}

.nav-tabs {
  border-bottom: none !important;
}


.business-heading {
  font-weight: 700;
  font-size: 2.2rem;
  color: #1b1c4d;
  line-height: 1.3;
}


.business-tabs {
  border-bottom: 1px solid #dce0e5 !important;
}


.business-img {
  max-width: 90%;
}


.nav-tabs .nav-link {
  font-weight: 600;
  font-size: 1.05rem;
  color: #2e2e48;
  border: none;
  background: none;
  margin: 0 12px;
  padding: 10px 5px;
  position: relative;
}

.nav-tabs .nav-link.active {
  color: #1b1c4d;
  font-weight: 700;
}

.nav-tabs .nav-link.active::after {
  content: "";
  position: absolute;
  bottom: 0;
  left: 0;
  right: 0;
  height: 3px;
  background-color: #4154f1;
  border-radius: 2px;
}

.tab-content h5 {
  color: #1b1c4d;
  font-size: 1.1rem;
  font-weight: 500;
  margin-bottom: 20px;
  line-height: 1.6;
}

.tab-content ul {
  padding-left: 0;
  list-style: none;
}

.tab-content ul li {
  position: relative;
  padding-left: 28px;
  margin-bottom: 12px;
  font-size: 1rem;
  color: #3d3d5c;
  line-height: 1.7;
}

.tab-content ul li::before {
  content: "✔";
  position: absolute;
  left: 0;
  top: 0;
  color: #4154f1;
  font-size: 1rem;
}

.tab-content strong {
  font-weight: 700;
  color: #1b1c4d;
}



.impact-section {
    background-color: #fff;
}


.impact-heading {
    font-size: 2.2rem;
    font-family: 'Poppins', sans-serif;
}


.impact-subtext {
    max-width: 800px;
    margin: 0 auto;
    font-size: 1.1rem;
    font-family: 'Jost', sans-serif;
}


.impact-stats-row {
    font-family: 'Jost', sans-serif;
}


.impact-number {
    color: #1351d8;
    font-size: 3rem;
    font-weight: 700;
}

.impact-stat-text {
    font-size: 1rem;
}
</style>



<!-- =============================== Offer section end ============================== -->

<section class="services py-50 position-relative z-1 gradient-bg-two">
  <img src="web/assets/images/shapes/rope-shape.png" alt="Rope" loading="lazy"
    class="position-absolute tw-start-0 tw-ms-80-px tw-mt-16 top-0 z-n1">
  <img src="web/assets/images/shapes/matherboard-shape.png" alt="Shape" loading="lazy"
    class="position-absolute top-0 tw-start-0 tw-mt-160-px tw-ms-128-px d-lg-block d-none z-n1 opacity-1">

  <div class="container max-w-1552-px">
    <div class="max-w-672-px text-center mx-auto tw-mb-12">
      <div class="bg-white-06 tw-py-3 tw-px-305 rounded-pill text-white fw-normal text-capitalize tw-leading-none d-inline-flex align-items-center tw-gap-2 tw-mb-405 min-w-max"
        data-aos="fade-up" data-aos-anchor-placement="top-bottom" data-aos-duration="600">
        <span class="tw-w-205 tw-h-205 bg-yellow rounded-circle"></span>
        Discover Leadmine's Features
      </div>

      <h2 class="splitTextStyleOne text-white custom-perspective">
        <div class="split-line custom-centered-title">
          Drive Real <span class="font-dm-serif fw-normal">Results for Your Business</span>
        </div>
      </h2>

      <p class="text-neutral-300 tw-mt-5 splitTextStyleOne max-w-570-px mx-auto custom-perspective">
        <div class="split-line text-white custom-centered-paragraph">
          Our AI phone support delivers immediate, quantifiable improvements across customer experience, operational efficiency, and business metrics.
        </div>
      </p>
    </div>

    <div class="service-slider swiper">
      <div class="swiper-wrapper">
        <!-- Feature 1 -->
        <div class="swiper-slide tw-pb-105" data-aos="fade-up" data-aos-duration="600">
          <div class="square-bg-shape position-relative tw-rounded-2xl z-1 animation-item tw-h-424-px">
            <div
              class="service-item bg-white hover-bg-main-600 group tw-py-16 tw-ps-10 tw-pe-4 tw-rounded-2xl h-100 d-flex flex-column justify-content-center">
              <span class="tw-mb-13">
                <!-- Stopwatch icon (speed) -->
                <img src="web/assets/images/icons/service-icon1.svg" alt="Faster Response Icon">
              </span>
              <div>
                <h3 class="group-hover-text-white as-tag">80% Faster Response</h3>
                <p class="group-hover-text-white tw-mt-3 line-clamp-2">
                  Instant AI responses eliminate wait times for customers, improving satisfaction and retention.
                </p>
              </div>
            </div>
          </div>
        </div>

        <!-- Feature 2 -->
        <div class="swiper-slide tw-pb-105" data-aos="fade-up" data-aos-duration="700">
          <div class="square-bg-shape position-relative tw-rounded-2xl z-1 animation-item tw-h-424-px">
            <div
              class="service-item bg-white hover-bg-main-600 group tw-py-16 tw-ps-10 tw-pe-4 tw-rounded-2xl h-100 d-flex flex-column justify-content-center">
              <span class="tw-mb-13">
                <!-- Coin/Money icon (cost) -->
                <img src="web/assets/images/icons/service-icon3.svg" alt="24/7 Availability Icon">
              </span>
              <div>
                <h3 class="group-hover-text-white as-tag">70% Cost Reduction</h3>
                <p class="group-hover-text-white tw-mt-3 line-clamp-2">
                  Reduce operational costs significantly by automating customer support with AI.
                </p>
              </div>
            </div>
          </div>
        </div>

        <!-- Feature 3 -->
        <div class="swiper-slide tw-pb-105" data-aos="fade-up" data-aos-duration="800">
          <div class="square-bg-shape position-relative tw-rounded-2xl z-1 animation-item tw-h-424-px">
            <div
              class="service-item bg-white hover-bg-main-600 group tw-py-16 tw-ps-10 tw-pe-4 tw-rounded-2xl h-100 d-flex flex-column justify-content-center">
              <span class="tw-mb-13">
                <!-- Clock icon (availability) -->
                
                 <img src="web/assets/images/icons/service-icon2.svg" alt="Cost Reduction Icon">
              </span>
              <div>
                <h3 class="group-hover-text-white as-tag">24/7 Availability</h3>
                <p class="group-hover-text-white tw-mt-3 line-clamp-2">
                  Never miss a customer call again — your AI assistant is always ready, day or night.
                </p>
              </div>
            </div>
          </div>
        </div>

        <!-- Feature 4 -->
        <div class="swiper-slide tw-pb-105" data-aos="fade-up" data-aos-duration="900">
          <div class="square-bg-shape position-relative tw-rounded-2xl z-1 animation-item tw-h-424-px">
            <div
              class="service-item bg-white hover-bg-main-600 group tw-py-16 tw-ps-10 tw-pe-4 tw-rounded-2xl h-100 d-flex flex-column justify-content-center">
              <span class="tw-mb-13">
                <!-- Globe icon (multi-language) -->
                <img src="web/assets/images/icons/service-icon4.svg" alt="Language Support Icon">
              </span>
              <div>
                <h3 class="group-hover-text-white as-tag">Multi-Language Support</h3>
                <p class="group-hover-text-white tw-mt-3 line-clamp-2">
                  Native-level support in 50+ languages and dialects ensures seamless communication worldwide.
                </p>
              </div>
            </div>
          </div>
        </div>

        <!-- Feature 5 -->
        <div class="swiper-slide tw-pb-105" data-aos="fade-up" data-aos-duration="1000">
          <div class="square-bg-shape position-relative tw-rounded-2xl z-1 animation-item tw-h-424-px">
            <div
              class="service-item bg-white hover-bg-main-600 group tw-py-16 tw-ps-10 tw-pe-4 tw-rounded-2xl h-100 d-flex flex-column justify-content-center">
              <span class="tw-mb-13">
                <!-- Shield/check icon (consistency) -->
                <img src="web/assets/images/icons/service-icon1.svg" alt="Consistency Icon">
              </span>
              <div>
                <h3 class="group-hover-text-white as-tag">100% Consistency</h3>
                <p class="group-hover-text-white tw-mt-3 line-clamp-2">
                  Every customer receives the same high-quality experience — no human variability.
                </p>
              </div>
            </div>
          </div>
        </div>

        <!-- Feature 6 -->
        <div class="swiper-slide tw-pb-105" data-aos="fade-up" data-aos-duration="1100">
          <div class="square-bg-shape position-relative tw-rounded-2xl z-1 animation-item tw-h-424-px">
            <div
              class="service-item bg-white hover-bg-main-600 group tw-py-16 tw-ps-10 tw-pe-4 tw-rounded-2xl h-100 d-flex flex-column justify-content-center">
              <span class="tw-mb-13">
                <!-- Growth icon (scalability, repeated globe-like icon for balance) -->
                <img src="web/assets/images/icons/service-icon4.svg" alt="Scalability Icon">
              </span>
              <div>
                <h3 class="group-hover-text-white as-tag">Instant Scalability</h3>
                <p class="group-hover-text-white tw-mt-3 line-clamp-2">
                  Handle unlimited calls simultaneously — grow your operations instantly without new hires.
                </p>
              </div>
            </div>
          </div>
        </div>
      </div>

      <!-- Pagination -->
      <div
        class="service-slider-pagination pagination-style-two d-flex align-items-center justify-content-center tw-mt-605 swiper-pagination-clickable swiper-pagination-bullets swiper-pagination-horizontal">
      </div>
    </div>

    <!-- CTA -->
    <div class="text-center tw-mt-10">
      <a href="{{ route('register') }}"
        class="btn btn-warning px-5 py-3 fw-semibold rounded-pill text-dark hover-bg-main-600 hover-text-white">
        Get Started Now
      </a>
    </div>
  </div>
</section>


<!-- Business Communication Section -->
<section class="section-lg py-5 business-section">
  <div class="container">

    <!-- Heading -->
    <div class="text-center mb-5">
      <h2 class="business-heading">
        Purpose-built to serve your <br> business communication needs
      </h2>
    </div>

    <!-- Tabs -->
    <ul class="nav nav-tabs justify-content-center border-0 business-tabs" id="businessTabs" role="tablist">
      <li class="nav-item" role="presentation">
        <button class="nav-link active" id="real-estate-tab" data-bs-toggle="tab" data-bs-target="#real-estate" type="button" role="tab">Real estate</button>
      </li>
      <li class="nav-item" role="presentation">
        <button class="nav-link" id="healthcare-tab" data-bs-toggle="tab" data-bs-target="#healthcare" type="button" role="tab">Healthcare</button>
      </li>
      <li class="nav-item" role="presentation">
        <button class="nav-link" id="education-tab" data-bs-toggle="tab" data-bs-target="#education" type="button" role="tab">Education</button>
      </li>
      <li class="nav-item" role="presentation">
        <button class="nav-link" id="finance-tab" data-bs-toggle="tab" data-bs-target="#finance" type="button" role="tab">Financial services</button>
      </li>
      <li class="nav-item" role="presentation">
        <button class="nav-link" id="retail-tab" data-bs-toggle="tab" data-bs-target="#retail" type="button" role="tab">Retail & e-commerce</button>
      </li>
    </ul>

    <!-- Tab Content -->
    <div class="tab-content mt-5 bg-neutral-50" id="businessTabsContent">

      <!-- Real Estate -->
      <div class="tab-pane fade show active" id="real-estate" role="tabpanel">
        <div class="row align-items-center">
          <div class="col-lg-6">
            <h5>Optimize agent-customer interactions and drive deal success with an integrated customer communication platform.</h5>
            <ul>
              <li>Turn every property inquiry into a lead, even during non-business hours with <strong>AI agents.</strong></li>
              <li>Equip agents with <strong>powerful automations</strong> and <strong>real-time insights</strong> for faster deal conversions.</li>
              <li>Drive meaningful customer interactions with <strong>intelligent call routing</strong> and AI-powered insights.</li>
              <li>Track conversations on a <strong>single platform</strong> that can integrate with 100+ popular business tools.</li>
            </ul>
          </div>
          <div class="col-lg-6 text-center">
            <img src="web/assets/images/bg/home-real-estate.webp" alt="AI Call Analytics for Real Estate" class="img-fluid rounded-3 business-img">
          </div>
        </div>
      </div>

      <!-- Healthcare -->
      <div class="tab-pane fade" id="healthcare" role="tabpanel">
        <div class="row align-items-center">
          <div class="col-lg-6">
            <h5>Create the ideal patient experience with a reliable and secure Voice & SMS communications platform.</h5>
            <ul>
              <li>Answer patient inquiries 24/7 with AI agents and route complex queries to human experts.</li>
              <li>Manage patient communications effectively using advanced call management.</li>
              <li>Track and maximize team performance through analytics and AI-powered coaching insights.</li>
              <li>Ensure patient data security with HIPAA-compliant business communications.</li>
            </ul>
          </div>
          <div class="col-lg-6 text-center">
            <img src="web/assets/images/bg/home-healthcare.webp" alt="Healthcare Communication" class="img-fluid rounded-3 business-img">
          </div>
        </div>
      </div>

      <!-- Education -->
      <div class="tab-pane fade" id="education" role="tabpanel">
        <div class="row align-items-center">
          <div class="col-lg-6">
            <h5>Empower your faculty and students with an advanced platform for seamless communication.</h5>
            <ul>
              <li>Handle class schedule and enrollment inquiries 24/7 with AI agents.</li>
              <li>Scale your communications with automated processes and advanced workflows.</li>
              <li>Build a personalized learner experience with intelligent call routing, IVR, and SMS bots.</li>
              <li>Drive student engagement with conversation intelligence from every interaction.</li>
            </ul>
          </div>
          <div class="col-lg-6 text-center">
            <img src="web/assets/images/bg/home-education.webp" alt="Education AI Platform" class="img-fluid rounded-3 business-img">
          </div>
        </div>
      </div>

      <!-- Financial Services -->
      <div class="tab-pane fade" id="finance" role="tabpanel">
        <div class="row align-items-center">
          <div class="col-lg-6">
            <h5>Drive personalized and secure client experiences across voice & SMS channels with AI.</h5>
            <ul>
              <li>Handle policy and claim inquiries 24/7 and reduce wait times with AI agents.</li>
              <li>Link agents with clients with efficient inbound and outbound communications.</li>
              <li>Resolve client issues more effectively by leveraging AI-based conversation insights.</li>
              <li>Safeguard data privacy with top-tier industry security and encryption.</li>
            </ul>
          </div>
          <div class="col-lg-6 text-center">
            <img src="web/assets/images/bg/home-financial-services.webp" alt="Finance AI Communication" class="img-fluid rounded-3 business-img">
          </div>
        </div>
      </div>

      <!-- Retail -->
      <div class="tab-pane fade" id="retail" role="tabpanel">
        <div class="row align-items-start">
          <div class="col-lg-6 mt-4">
            <h5>Create superior customer experiences with integrated voice and SMS communications.</h5>
            <ul>
              <li>Connect with customers on their preferred channels — phone, SMS, and WhatsApp inbox.</li>
              <li>Accelerate query resolution with powerful inbound call management.</li>
              <li>Deliver real-time, AI-powered guidance to agents for better call handling.</li>
            </ul>
          </div>
          <div class="col-lg-6 text-center">
            <img src="web/assets/images/bg/ecommerce.webp" alt="Retail AI Communication" class="img-fluid rounded-3 business-img">
          </div>
        </div>
      </div>

    </div>
  </div>
</section>


<!-- Proven Impact Section -->
<section class="callchex-section py-50 impact-section">
  <div class="container max-w-1200-px">
    
    <!-- Heading -->
    <div class="text-center mb-5">
      <h2 class="fw-bold impact-heading">
        Proven Impact. Real Results
      </h2>
      <p class="lead text-muted mt-3 impact-subtext">
        Voice AI takes precise orders—no more misheard items or missed customizations.
      </p>
    </div>

    <!-- Stats -->
    <div class="row text-center justify-content-center impact-stats-row">
      <div class="col-lg-3 col-md-6 mb-4">
        <h3 class="impact-number">90%</h3>
        <p class="text-muted impact-stat-text">Fewer missed calls and callbacks</p>
      </div>

      <div class="col-lg-3 col-md-6 mb-4">
        <h3 class="impact-number">70%</h3>
        <p class="text-muted impact-stat-text">Less repetitive inquiries for staff</p>
      </div>

      <div class="col-lg-3 col-md-6 mb-4">
        <h3 class="impact-number">40%</h3>
        <p class="text-muted impact-stat-text">Boost in appointment bookings</p>
      </div>

      <div class="col-lg-3 col-md-6 mb-4">
        <h3 class="impact-number">75%</h3>
        <p class="text-muted impact-stat-text">Savings on reception staffing costs</p>
      </div>
    </div>

  </div>
</section>





<!-- ================== About Features section Start ====================== -->
<section class="about-features py-120 section-bg-two">
    <div class="container">
        <div class="d-flex align-items-center justify-content-between flex-wrap tw-gap-6 tw-mb-12">
            <div class="max-w-532-px">
                <h3 class="splitTextStyleOne text-capitalize as-h5">
                    Let Humans Focus on What AI Can't Do
                </h3>
            </div>
            <div data-aos="fade-up" data-aos-anchor-placement="top-bottom" data-aos-duration="800">
                <p class="splitTextStyleOne max-w-490-px fw-medium tw-ps-5 border-start border-app-landing border-2">
                    While AI handles routine inquiries perfectly, your team can focus on creative problem-solving, relationship building, and strategic thinking that truly drives your business forward.
                </p>
            </div>
        </div>

        <div class="row gy-4">
            <!-- 1 -->
            <div class="col-xl-3 col-sm-6" data-aos="fade-up" data-aos-anchor-placement="top-bottom" data-aos-duration="600">
                <div class="tw-rounded-2xl bg-white bg-hover-app-landing tw-py-14 tw-px-7 border border-neutral-200 group animation-item tw-transition tw-duration-200 h-100">
                    <span class="tw-w-92-px tw-h-92-px rounded-circle d-flex align-items-center justify-content-center common-shadow-fifteen tw-mb-11">
                        <img src="web/assets/images/icons/about-features-icon1.svg" alt="Boost Productivity Icon" class="group-hover-item-text-invert tw-transition tw-duration-200 animate__heartBeat">
                    </span>
                    <h5 class="splitTextStyleOne tw-mb-7 group-hover-text-white tw-transition tw-duration-200 as-h5">
                        Boost Productivity
                    </h5>
                    <p class="splitTextStyleOne group-hover-text-white fw-medium tw-transition tw-duration-200">
                        Free your team from repetitive questions so they can focus on complex tasks that drive business growth.
                    </p>
                </div>
            </div>

            <!-- 2 -->
            <div class="col-xl-3 col-sm-6" data-aos="fade-up" data-aos-anchor-placement="top-bottom" data-aos-duration="800">
                <div class="tw-rounded-2xl bg-white bg-hover-app-landing tw-py-14 tw-px-7 border border-neutral-200 group animation-item tw-transition tw-duration-200 h-100">
                    <span class="tw-w-92-px tw-h-92-px rounded-circle d-flex align-items-center justify-content-center common-shadow-fifteen tw-mb-11">
                        <img src="web/assets/images/icons/about-features-icon2.svg" alt="Reduce Costs Icon" class="group-hover-item-text-invert tw-transition tw-duration-200 animate__heartBeat">
                    </span>
                    <h5 class="splitTextStyleOne tw-mb-7 group-hover-text-white tw-transition tw-duration-200 as-h5">
                        Reduce Costs
                    </h5>
                    <p class="splitTextStyleOne group-hover-text-white fw-medium tw-transition tw-duration-200">
                        Eliminate the need for round-the-clock staffing while providing better customer service than ever before.
                    </p>
                </div>
            </div>

            <!-- 3 -->
            <div class="col-xl-3 col-sm-6" data-aos="fade-up" data-aos-anchor-placement="top-bottom" data-aos-duration="1000">
                <div class="tw-rounded-2xl bg-white bg-hover-app-landing tw-py-14 tw-px-7 border border-neutral-200 group animation-item tw-transition tw-duration-200 h-100">
                    <span class="tw-w-92-px tw-h-92-px rounded-circle d-flex align-items-center justify-content-center common-shadow-fifteen tw-mb-11">
                        <img src="web/assets/images/icons/about-features-icon3.svg" alt="Improve Satisfaction Icon" class="group-hover-item-text-invert tw-transition tw-duration-200 animate__heartBeat">
                    </span>
                    <h5 class="splitTextStyleOne tw-mb-7 group-hover-text-white tw-transition tw-duration-200 as-h5">
                        Improve Satisfaction
                    </h5>
                    <p class="splitTextStyleOne group-hover-text-white fw-medium tw-transition tw-duration-200">
                        Customers love getting instant, accurate answers. Build loyalty with consistent, helpful service.
                    </p>
                </div>
            </div>

            <!-- 4 -->
            <div class="col-xl-3 col-sm-6" data-aos="fade-up" data-aos-anchor-placement="top-bottom" data-aos-duration="1200">
                <div class="tw-rounded-2xl bg-white bg-hover-app-landing tw-py-14 tw-px-7 border border-neutral-200 group animation-item tw-transition tw-duration-200 h-100">
                    <span class="tw-w-92-px tw-h-92-px rounded-circle d-flex align-items-center justify-content-center common-shadow-fifteen tw-mb-11">
                        <img src="web/assets/images/icons/about-features-icon4.svg" alt="Scale Effortlessly Icon" class="group-hover-item-text-invert tw-transition tw-duration-200 animate__heartBeat">
                    </span>
                    <h5 class="splitTextStyleOne tw-mb-7 group-hover-text-white tw-transition tw-duration-200 as-h5">
                        Scale Effortlessly
                    </h5>
                    <p class="splitTextStyleOne group-hover-text-white fw-medium tw-transition tw-duration-200">
                        Handle thousands of calls simultaneously without hiring additional staff or compromising quality.
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>




<!-- ============================ Testimonials section start ============================= -->
<section class="testimonials py-50 bg-neutral-50 position-relative z-1">
    <img src="web/assets/images/shapes/faq-bg.png" alt="faq-bg" loading="lazy" class="position-absolute tw-start-0 top-0 w-100 h-100 z-n1">

    <div class="container">
        <div class="max-w-602-px mx-auto text-center tw-mb-15 mt-minus-10">
            <h2 class="splitTextStyleOne  tw-leading-104 tw-mb-9 d-flex gap-2 custom-features">
                What Our Clients Say About Us
            </h2>
        </div>

        <div class="swiper testimonials-five-slider swiper-initialized swiper-horizontal swiper-backface-hidden">
            <div class="swiper-wrapper">

                <!-- Slide 1 -->
                <div class="swiper-slide h-auto">
                    <div class="common-shadow-ten tw-rounded-2xl tw-p-4 bg-white h-100 d-flex flex-column animation-item  custom-box-style">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <p class="tw-mb-2 text-capitalize heading-responsive-medium as-tag1">Edgard Uzcategui</p>
                                <span class="fw-medium text-small-responsive">Septic LLC</span>
                            </div>
                            <div>
                                <img src="web/assets/images/icons/ratings.svg" alt="Star Rating" class="img-rating-responsive">
                            </div>
                        </div>
                        <p class="custom-goal-heading as-sub">
                            Achieved goals ahead of schedule with Leadmine Pro
                        </p>
                        <p class="text-neutral-600 paragraph-responsive">
                            Thanks to Leadmine Pro’s strategic guidance and ongoing support, we expanded our
                            business faster than planned — and saved significant costs!
                        </p>
                    </div>
                </div>

                <!-- Slide 2 -->
                <div class="swiper-slide h-auto">
                    <div class="common-shadow-ten tw-rounded-2xl tw-p-4 bg-white h-100 d-flex flex-column animation-item custom-box-style">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <p class="tw-mb-2 text-capitalize heading-responsive-medium as-tag1">Priya Desai</p>
                                <span class="fw-medium text-small-responsive">LeadSync Solutions</span>
                            </div>
                            <div>
                                <img src="web/assets/images/icons/ratings.svg" alt="Star Rating" class="img-rating-responsive">
                            </div>
                        </div>
                        <p class="custom-goal-heading as-sub">
                            Call quality went up — complaints went down
                        </p>
                        <p class="text-neutral-600 paragraph-responsive">
                            We finally understand what’s happening on our calls. The insights from
                            Leadmine Pro are game-changing for both coaching and compliance.
                        </p>
                    </div>
                </div>

                <!-- Slide 3 -->
                <div class="swiper-slide h-auto">
                    <div class="common-shadow-ten tw-rounded-2xl tw-p-4 bg-white h-100 d-flex flex-column animation-item custom-box-style">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <p class="tw-mb-2 text-capitalize heading-responsive-medium as-tag1">Marcus Boyd</p>
                                <span class="fw-medium text-small-responsive">BrightTouch Communications</span>
                            </div>
                            <div>
                                <img src="web/assets/images/icons/ratings.svg" alt="Star Rating" class="img-rating-responsive">
                            </div>
                        </div>
                        <p class="custom-goal-heading as-sub">
                            Performance insights that actually make sense
                        </p>
                        <p class="text-neutral-600 paragraph-responsive">
                            Our agents feel more confident, and sales have improved just weeks after adopting this AI
                            call scoring software from Leadmine Pro.
                        </p>
                    </div>
                </div>

                <!-- Slide 4 -->
                <div class="swiper-slide h-auto">
                    <div class="common-shadow-ten tw-rounded-2xl tw-p-4 bg-white h-100 d-flex flex-column animation-item custom-box-style">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <p class="tw-mb-2 text-capitalize heading-responsive-medium as-tag1">Nandita Rao</p>
                                <span class="fw-medium text-small-responsive">NextVoice Contact Center</span>
                            </div>
                            <div>
                                <img src="web/assets/images/icons/ratings.svg" alt="Star Rating" class="img-rating-responsive">
                            </div>
                        </div>
                        <p class="custom-goal-heading as-sub">
                            Took the guesswork out of coaching
                        </p>
                        <p class="text-neutral-600 paragraph-responsive">
                            We don’t just coach better now – we coach faster and with purpose. That’s made a real
                            difference with Leadmine Pro.
                        </p>
                    </div>
                </div>

                <!-- Slide 5 -->
                <div class="swiper-slide h-auto">
                    <div class="common-shadow-ten tw-rounded-2xl tw-p-4 bg-white h-100 d-flex flex-column animation-item custom-box-style">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <p class="tw-mb-2 text-capitalize heading-responsive-medium as-tag1">Jorge Martinez</p>
                                <span class="fw-medium text-small-responsive">SalesNova Team</span>
                            </div>
                            <div>
                                <img src="web/assets/images/icons/ratings.svg" alt="Star Rating" class="img-rating-responsive">
                            </div>
                        </div>
                        <p class="custom-goal-heading as-sub">
                            Best call scoring software for call centers
                        </p>
                        <p class="text-neutral-600 paragraph-responsive">
                            It’s like having a real-time manager for every agent – without micromanaging anyone.
                            Leadmine Pro makes that possible.
                        </p>
                    </div>
                </div>

                <!-- Slide 6 -->
                <div class="swiper-slide h-auto">
                    <div class="common-shadow-ten tw-rounded-2xl tw-p-4 bg-white h-100 d-flex flex-column animation-item custom-box-style">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <p class="tw-mb-2 text-capitalize heading-responsive-medium as-tag1">Emily Chen</p>
                                <span class="fw-medium text-small-responsive">Pulse360 Sales Team</span>
                            </div>
                            <div>
                                <img src="web/assets/images/icons/ratings.svg" alt="Star Rating" class="img-rating-responsive">
                            </div>
                        </div>
                        <p class="custom-goal-heading as-sub">
                            Improved productivity without burning out our reps
                        </p>
                        <p class="text-neutral-600 paragraph-responsive">
                            Leadmine Pro helped us find coaching moments instantly, which meant less
                            pressure on supervisors – and better feedback for reps.
                        </p>
                    </div>
                </div>

                <!-- Slide 7 -->
                <div class="swiper-slide h-auto">
                    <div class="common-shadow-ten tw-rounded-2xl tw-p-4 bg-white h-100 d-flex flex-column animation-item custom-box-style">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <p class="tw-mb-2 text-capitalize heading-responsive-medium as-tag1">Aarav Mehta</p>
                                <span class="fw-medium text-small-responsive">TalkRight Tech</span>
                            </div>
                            <div>
                                <img src="web/assets/images/icons/ratings.svg" alt="Star Rating" class="img-rating-responsive">
                            </div>
                        </div>
                        <p class="custom-goal-heading as-sub">
                            From chaos to clarity
                        </p>
                        <p class="text-neutral-600 paragraph-responsive">
                            Before Leadmine Pro, we were just hoping agents did well. Now, we know who’s
                            doing what – and why, thanks to the AI call scoring software.
                        </p>
                    </div>
                </div>

            </div>

            <!-- Pagination -->
            <div
                class="testimonials-five-slider-pagination pagination-style-four d-flex align-items-center justify-content-center tw-gap-6 tw-mt-15 tw-pb-3 swiper-pagination-clickable swiper-pagination-bullets swiper-pagination-horizontal">
                <span class="swiper-pagination-bullet"></span>
                <span class="swiper-pagination-bullet swiper-pagination-bullet-active"></span>
                <span class="swiper-pagination-bullet"></span>
                <span class="swiper-pagination-bullet"></span>
            </div>
        </div>
    </div>
</section>


<!-- ============================ Testimonials section End ============================= -->

<!-- <script>
  const serviceSwiper = new Swiper('.service-slider', {
    loop: true,
    speed: 1000, // smooth transition in ms (1.2 seconds)
    autoplay: {
      delay: 5000, // wait 5 seconds before moving to next
      disableOnInteraction: false,
    },
    pagination: {
      el: '.service-slider-pagination',
      clickable: true,
    },
  });
</script> -->





@endsection