<?php

use App\Http\Controllers\FrontendRegisterController;
use Illuminate\Http\Request;
use App\Http\Controllers\Blogs\BlogController;

/*
  |--------------------------------------------------------------------------
  | Web Routes
  |--------------------------------------------------------------------------
  |
  | Here is where you can register web routes for your application. These
  | routes are loaded by the RouteServiceProvider within a group which
  | contains the "web" middleware group. Now create something great!
  |
 */



Route::get('/', 'HomeController@index');

Route::get('/price-plan', 'HomeController@pricePlanNew');
Route::get('/price-plan-new', 'HomeController@pricePlan');
Route::get('/contact-us', 'HomeController@contactUs');
Route::get('/about-us', 'HomeController@aboutUs');
Route::get('/privacy-policy', 'HomeController@policy');
Route::get('/terms-services', 'HomeController@terms');
Route::get('/blogs', 'HomeController@blogs');
Route::get('/blog-detail', 'HomeController@blogdetail');


Route::get('/faq', 'HomeController@faq');
Route::get('/real-estate-mortgage-intelligence', 'HomeController@realestate');
Route::get('/technology', 'HomeController@tech');
Route::get('/healthcare', 'HomeController@healthcare');
Route::get('/financial-services', 'HomeController@financial');
Route::get('/fitness-wellness', 'HomeController@fitness');
Route::get('/education', 'HomeController@education');
Route::get('/retail', 'HomeController@retail');
Route::get('/ai-answering', 'HomeController@aianswering');
Route::get('/ai-receptionist', 'HomeController@aireceptionist');
Route::get('/reduce-appointment-no-shows', 'HomeController@reduceappointment');
Route::get('/customer-services', 'HomeController@customerservice');
Route::get('/order-taker', 'HomeController@ordertaker');
Route::get('/ai-voice-recall-reminder-to-patients', 'HomeController@recall');
Route::get('/fill-last-minute-appointments', 'HomeController@lastappointment');
Route::get('/all-industries', 'HomeController@industry');



Route::post('/save-contact', 'ContactUsController@store')->name('save-contact');





Route::get('/login', 'ApiLoginController@index')->name("login");
Route::post('/', 'ApiLoginController@apilogin');
Route::get('/otp', 'ApiLoginController@otp');
Route::post('/otp', 'ApiLoginController@otp');
Route::get('/auth/google/redirect', 'ApiLoginController@redirectToGoogle');
Route::get('/auth/google/callback', 'ApiLoginController@handleGoogleCallback');
Route::get('/login1', 'ApiLoginController@index1');
Route::get('/mobile-otp', 'ApiLoginController@Six');
Route::get('/google-otp', 'ApiLoginController@Google')->name('google-otp.form');
Route::post('/verify-google-otp', 'ApiLoginController@verifyGoogleOtp')->name('google-otp.verify');


Route::get('logout', 'ApiLoginController@logout');
Route::get('/allow-google-auth', 'ApiLoginController@GoogleAuth');
Route::post('/allow-google-auth', 'ApiLoginController@GoogleAuth');
//Route::get('/register', 'ApiLoginController@register')->name('register');
Route::post('/store', 'ApiLoginController@store');
//mobile otp register
Route::post('/send-mobile-otp', 'ApiLoginController@SendMobileOtp');
Route::post('/verify-mobile-otp', 'ApiLoginController@verifyMobileOtp')->name('mobiles-otp.verify');


//sms api receiveing from external
Route::any('receive-sms', 'ApiSmsController@smsResponse');

//pusher api with basic auth
Route::get('push-event/{api_key}/{platform}/{from}/{to}/{event?}', 'PusherController@index');


Route::group(['middleware' => 'session'], function () {
    Route::get('forgot-password', 'AdminController@forgotPassword');
    Route::get('resetPassword', 'AdminController@resetPassword');

    Route::post('/switch-client/{clientId}', 'ApiLoginController@switchClient');
    Route::post('image-update', 'AdminController@updateImage');

    Route::get('checkEmail', 'AdminController@checkEmail');



    Route::get('/profile', 'ApiUserController@userProfile');
   Route::post('/profile1', 'ApiUserController@changePassword');

Route::get('/profile1', 'ApiUserController@userProfile1');
    // Profile phone verify
    Route::post('/submit-phone', 'PhoneVerificationController@submitPhone')->name('submit.phone');
    Route::get('/edit-phone', 'PhoneVerificationController@editPhone')->name('edit.phone');
    Route::get('/resend-otp', 'PhoneVerificationController@resendOtp')->name('resend.otp');
    Route::post('/verify-phone', 'PhoneVerificationController@verifyPhone')->name('verify.phone');
    Route::post('/close-modal',  'PhoneVerificationController@closeModal')->name('close.modal');
   Route::post('/profile/update-google-auth', 'ProfileController@updateGoogleAuthenticator')
        ->name('profile.update-google-auth');

    Route::post('/verify-google-auth', 'ProfileController@verifyGoogleAuthenticator')
        ->name('profile.verify-google_otp');
    Route::post('/profile/update-two-factor', 'ProfileController@updateTwoFactor')
        ->name('profile.update-two-factor');
    /* Route::get('/profile', function () {
      return view('users.profile');
      })->name('profile'); */
  Route::post('/profile/change-email', 'ProfileController@changeEmail')->name('profile.change-email');
    Route::post('/profile/verify-otp', 'ProfileController@verifyOtp')->name('profile.verify-otp');
    Route::post('/profile', 'ApiUserController@changePassword');

    Route::post('/updateProfile', 'ApiUserController@updateProfile');
    Route::post('/updateTimezone', 'ApiUserController@updateTimezone');

    Route::post('/deleteVoiceMail', 'ApiUserController@deleteVoiceMail');
    Route::get('/profile/edit-voicemail/{voicemail_id}', 'ApiUserController@editVoiceMail');

    Route::post('/profile/edit-voicemail/{voicemail_id}', 'ApiUserController@updateVoiceMail');
    Route::get('/profile/edit-voiceai/{voicemail_id}', 'ApiUserController@editVoiceAi');
    Route::get('/deleteVoiceAi/{id}/{voicemail_id}', 'ApiUserController@deleteVoiceAi');
    Route::get('/user/{id}/{client_id}/user-activity', 'ApiUserController@userActivity');

    Route::get('/assignable-roles/{id}', [
        'as' => 'assignableRoles',
        'uses' => 'ApiExtensionController@getAssignableRoles'
    ]);
    Route::post('/save-user-roles', [
        'as' => 'saveUserRoles',
        'uses' => 'ApiExtensionController@saveUserRoles'
    ]);

    Route::post('/hangup-conferencce', [
        'as' => 'hangupConferences',
        'uses' => 'ApiExtensionController@hangupConferences'
    ]);



    //Reporting
    Route::get('/report', 'ApiReportController@getReport');
    Route::post('/report', 'ApiReportController@getReport');
    Route::get('/live-call', 'ApiReportController@getLiveCall');
    Route::get('/live-call-api', 'ApiReportController@getLiveCallReact');
    Route::get('/live-call-react', 'ApiReportController@getLiveCallReactView');
    Route::get('/call-matrix-report/{referenceId}', 'ApiReportController@getcdrmatrixview');
    Route::post('/call-matrix-report/{id}', 'ApiReportController@getcdrmatrixreportProcess');
    Route::get('/spoofing-report', 'ApiReportController@getSpoofReport');
    Route::post('/spoofing-report', 'ApiReportController@getSpoofReport');
    Route::get('/report/call-data-ai', 'ApiReportController@getCallDataReport')->name('cdr-report.index');


    Route::post('/live-call', 'ApiReportController@getLiveCall');
    Route::get('/transfer-report', 'ApiReportController@getTransferReport');
    Route::post('/transfer-report', 'ApiReportController@getTransferReport');
    Route::get('/report/{number}', 'ApiReportController@getReportByNumber');
    Route::get('/call-report/{lead_id}', 'ApiReportController@getReportByLeadId');
    Route::post('/listen-call', 'ApiReportController@listenCall');
    Route::post('/barge-call', 'ApiReportController@bargeCall');

    //press1 campaign

    Route::get('/press1-campaign', 'Press1CampaignReportController@getReport');
    Route::post('/press1-campaign', 'Press1CampaignReportController@getReport');
    Route::get('/findAllDtmf/{id}', 'Press1CampaignReportController@findAllDtmf');


    //login history

    Route::get('/login-history', 'ApiReportController@loginHistory');
    Route::post('/login-history', 'ApiReportController@loginHistory');



    //Dialler
    //Route::any('start-dialing', 'ApiDialerController@index');

    Route::any('start-dialing-new', 'ApiDialerController@indexStartDialingNew');
    Route::any('start-dialing', 'ApiDialerController@indexStartDialingNew');

    Route::post('/update/dialer-mode', 'ApiDialerController@changeDialerModeExtension');


    Route::any('dialer-new', 'ApiDialerController@indexDemo');

    Route::post('/call-number', 'ApiDialerController@callNumber');
    Route::post('/hang-up', 'ApiDialerController@hangUp');
    Route::post('/warm-call-transfer', 'ApiDialerController@warmCallTransfer');
    Route::post('/check-line-details', 'ApiDialerController@checkLineDetails');
    Route::post('/check-extension-live', 'ApiDialerController@checkExtensionLiveDetails');
    Route::post('/merge-call-with-transfer', 'ApiDialerController@mergeCallWithTransfer');
    Route::post('/leave-conference', 'ApiDialerController@leaveConference');





    Route::post('/dtmf', 'ApiDialerController@dtmf');
    Route::post('/voicemail-drop', 'ApiDialerController@voicemailDrop');
    Route::post('/get-lead', 'ApiDialerController@getLead');
    Route::post('/save-disposition', 'ApiDialerController@saveDisposition');
    Route::post('/redial-call', 'ApiDialerController@redialCall');

    Route::post('/lead/{leadId}', [
        'as' => 'updateLeadData',
        'uses' => 'ApiDialerController@updateLeadData'
    ]);

    Route::post('/notes/{leadId}', [
        'as' => 'showNotesData',
        'uses' => 'ApiDialerController@showNotesData'
    ]);


    Route::get('/get-csrf-token', 'ApiDialerController@getCsrfToken');
    Route::get('/hopper-count/{campaignId}', 'ApiDialerController@getHopperCount');

    Route::post('add-new-lead-pd', 'ApiDialerController@add_new_lead_pd');
    Route::post('webphone/switch-access', "ApiDialerController@switchSoftphoneUse");
    Route::get('webphone', "ApiDialerController@openWebPhone");

    //Route::post('/send-to-crm', 'ApiDialerController@sendToCrm');
    Route::any('sendToCrm', 'ApiDidController@sendToCrmUser');

    Route::get('send-to-crm-post', 'ApiDidController@sendToCrmUserPost');


    //Group
    Route::get('/extension-group', 'ApiExtensionController@getGroup');
    Route::get('/mapExtensionGroup', 'ApiExtensionController@mapExtensionGroup');

    Route::post('extension-group', 'ApiExtensionController@storeExtensionGroup');
    Route::get('/addGroup/{title}/{extensions}', 'ApiExtensionController@addGroup');

    Route::get('/deleteExtensionGroup/{id}', 'ApiExtensionController@deleteExtensionGroup');
    Route::get('/updateGroupStatus/{id}/{status}', 'ApiExtensionController@updateGroupStatus');

    //marketing campaignscr
    Route::get('marketing-campaigns', 'ApiMarketingCampaignController@index');
    Route::post('marketing-campaigns', 'ApiMarketingCampaignController@addNew');
    Route::get('marketing-campaign/{id}', 'ApiMarketingCampaignController@show');
    Route::get('/updateMarketingStatus/{id}/{status}', 'ApiMarketingCampaignController@updateGroupStatus');

    // marketing campaign schedule
    Route::get('marketing-campaign/{id}/schedules', 'MarketingCampaignScheduleController@index');
    Route::get('marketing-campaign-schedule/{id}', 'MarketingCampaignScheduleController@show');
    Route::post('marketing-campaign-schedule/{id}', 'MarketingCampaignScheduleController@update');
    Route::get('marketing-campaign/{campaignId}/schedule/{scheduleId}/logs', 'MarketingCampaignScheduleController@getLogs');
    Route::post('marketing-campaign/{campaignId}/schedule/{scheduleId}/log/{logId}/retry', 'MarketingCampaignScheduleController@retryLog');

    Route::get('findListHeader/{list_id}', 'MarketingCampaignScheduleController@findListHeader');
    Route::post('add-marketing-schedule', ['as' => 'addMarketingSchedule', 'uses' => 'MarketingCampaignScheduleController@addMarketingSchedule']);
    Route::post('add-marketing-schedule-sms', ['as' => 'addMarketingScheduleSMS', 'uses' => 'MarketingCampaignScheduleController@addMarketingScheduleSMS']);
    Route::post('/deleteSchedule', ['as' => 'deleteSchedule', 'uses' => 'MarketingCampaignScheduleController@deleteSchedule']);
    Route::post('/abortSchedule', ['as' => 'abortSchedule', 'uses' => 'MarketingCampaignScheduleController@abortSchedule']);




    //Campaign
    Route::get('/campaign', 'ApiCampaignController@getCampaign');
    Route::post('/campaign', 'ApiCampaignController@getCampaign');
    Route::get('/get-campaign', 'ApiCampaignController@getCampaign_copy');


    Route::get('/add-campaign', 'ApiCampaignController@storeCampaign');
    Route::post('/add-campaign', 'ApiCampaignController@storeCampaign');
    Route::get('/campaign/{id}', 'ApiCampaignController@showEditCampaign');
    Route::post('/campaign/{id}', 'ApiCampaignController@editCampaign');
    Route::get('copy-campaign/{id}', 'ApiCampaignController@copyCampaign');
    Route::get('/campaign/{list}/{id}', 'ApiCampaignController@getCampaignList');
    Route::post('/campaign/{list}/{id}', 'ApiCampaignController@recycleListDisposition');
    Route::get('/deleteCampaign/{id}', 'ApiCampaignController@deleteCampaign');
    Route::get('/listDisposition/{list_id}', 'ApiCampaignController@listDisposition');
    Route::get('/reload-hopper/{campaign}', [
        'as' => 'reloadHopper',
        'uses' => 'ApiCampaignController@reloadHopper'
    ]);
    Route::get('/campaignAddGroup/{title}/{extensions}', 'ApiCampaignController@addGroup');
    Route::get('/updateCampaignStatus/{id}/{status}', 'ApiCampaignController@updateCampaignStatus');
    Route::get('/campaign-health/{campaignId}', 'ApiCampaignController@campaignHealth');
    Route::get('/updateCampaignHopper/{id}/{status}', 'ApiCampaignController@updateCampaignHopper');
    Route::get('/campaign-types', 'ApiCampaignController@getCampaignTypes');
    Route::get('/campaign-types-table', 'ApiCampaignController@getCampaignTypesTable');
    Route::post('/campaign-type/update-status', 'ApiCampaignController@updateCampaignTypeStatus');


    //show upload history
    Route::get('/show-upload-history', 'ShowHistoryController@showHistory');

    //Campaign Type
    Route::get('campaign-type', 'ApiCampaignTypeController@index');
    Route::post('campaign-type', 'ApiCampaignTypeController@create');
    Route::get('/campaign-type/{id}', 'ApiCampaignTypeController@show');
    Route::post('campaign-type/{id}', 'ApiCampaignTypeController@update');
    Route::get('delete-campaign-type/{id}', 'ApiCampaignTypeController@delete');
    //crm_lists
    Route::get('crm-list', 'ApiCrmListController@index');
    Route::post('crm-list', 'ApiCrmListController@create');
    Route::get('/crm-list/{id}', 'ApiCrmListController@show');
    Route::post('crm-list/{id}', 'ApiCrmListController@update');
    Route::get('delete-crm-list/{id}', 'ApiCrmListController@delete');
    //sip_channel_provider
    Route::get('sip-channel-provider', 'ApiSipChannelController@index');
    Route::post('sip-channel-provider', 'ApiSipChannelController@create');
    Route::get('/sip-channel-provider/{id}', 'ApiSipChannelController@show');
    Route::post('sip-channel-provider/{id}', 'ApiSipChannelController@update');
    Route::get('delete-sip-channel-provider/{id}', 'ApiSipChannelController@delete');


    //extension
    Route::get('/extension', 'ApiExtensionController@getExtension')->name('extension.index');
    Route::post('/extension', 'ApiExtensionController@changePasswordAgent');
    Route::get('/add-extension', 'ApiExtensionController@index');

    //TODO: Remove this endpoint after verifying, i think it is not in use.
    Route::post('/add-extension', 'ApiExtensionController@storeExtension');

    Route::get('/extension/{id}', 'ApiExtensionController@editExtension');
    Route::post('/extension/{id}', 'ApiExtensionController@storeExtension');
    Route::get('/deleteExtension/{extension}', 'ApiExtensionController@deleteExtension');
    Route::get('checkExtension/{extension_name}', 'ApiExtensionController@checkExtension');
    Route::get('checkAltExtension/{alt_extension_name}', 'ApiExtensionController@checkAltExtension');
    Route::post('updateEmail', 'ApiExtensionController@updateEmail');
    Route::get('/extension/{id}/modal', 'ApiExtensionController@showModal');




    // Created by : Pankaj
    Route::post('save-edit-extension', 'ApiExtensionController@saveEditExtension');
    Route::post('new-extension-save', 'ApiExtensionController@saveNewExtension');

    //disposition
    Route::get('disposition', 'ApiDispositionController@getDisposition');
    Route::post('disposition', 'ApiDispositionController@getDisposition');
    Route::post('disposition', 'ApiDispositionController@storeDisposition');
    Route::get('/editDisposition/{id}', 'ApiDispositionController@editDisposition');
    Route::get('/deleteDisposition/{id}', 'ApiDispositionController@deleteDisposition');
    Route::get('/addDisposition/{title}/{d_type}/{enable_sms}', 'ApiDispositionController@addDisposition');
    Route::get('/updateDispositionStatus/{id}/{status}', 'ApiDispositionController@updateDispositionStatus');


    //Label
    Route::get('label', 'ApiLabelController@getLabel');
    Route::post('label', 'ApiLabelController@storeLabel');
    Route::get('/label/{id}', 'ApiLabelController@editLabel');
    Route::get('/deleteLabel/{id}', 'ApiLabelController@deleteLabel');
    Route::post('/update/displayorder', 'ApiLabelController@updateDisplayOrder');
    Route::get('/updateLabelStatus/{id}/{status}', 'ApiLabelController@updateLabelStatus');

    //DNC

    Route::get('ivr-log', 'Press1CampaignReportController@getIvrLog');
    Route::post('ivr-log', 'Press1CampaignReportController@getIvrLog');


    Route::get('dnc', 'ApiDncController@getDNC');
    Route::post('dnc', 'ApiDncController@storeDNC');
    Route::get('/editDnc/{id}', 'ApiDncController@editDnc');
    Route::get('/deleteDnc/{id}', 'ApiDncController@deleteDnc');
    // routes/web.php
    Route::get('/dnc/search', 'ApiDncController@searchDNC')->name('dnc.search');



    // exclude number
    Route::get('exclude-from-list', 'ApiExcludeNumberController@getExcludeNumber');
    Route::post('exclude-from-list', 'ApiExcludeNumberController@storeExcludeNumber');
    Route::get('/deleteExcludeNo/{id}/{campaign}', 'ApiExcludeNumberController@deleteExcludeNo');
    Route::get('/editExcludeNumber/{id}/{campaign}', 'ApiExcludeNumberController@editExcludeNumber');

    //API
    Route::get('/api-data', 'ApiApiController@getApiList');
    Route::get('add-api', 'ApiApiController@storeApi');
    Route::post('add-api', 'ApiApiController@storeApi');
    Route::get('edit-api/{id}', 'ApiApiController@editApi');
    Route::post('edit-api/{id}', 'ApiApiController@edit_save');
    Route::get('copy-api/{id}', 'ApiApiController@copyApi');
    Route::get('/deleteApi/{id}', 'ApiApiController@deleteApi');

    //logo setting
    Route::get('logo-setting', 'ApiLogoSetting@index');
    Route::post('logo-setting', 'ApiLogoSetting@updateEmailSetting');
    Route::post('logo-upload', 'ApiLogoSetting@imageUploadPost')->name('logo.upload.post');
    Route::post('profile-voice', 'ApiUserController@voiceMail')->name('voice.mail.post');
    Route::post('profile-voice-ai', 'ApiUserController@voiceAi')->name('voice.ai.post');



    //lists
    Route::get('list ', 'ApiListController@getListList');
    Route::post('list', 'ApiListController@storeList');
    Route::get('list/{id}/content', 'ApiListController@getListContent');
    Route::get('list-data/{id}/content', 'ApiListController@getListContentView');

    Route::get('/editList/{id}/{campaign}', 'ApiListController@editList');
    Route::post('/editList/{id}/{campaign}', 'ApiListController@editList');
    Route::get('/deleteListData/{id}/{campaign}', 'ApiListController@deleteListData');
    Route::get('/updateList/{id}/{status}', 'ApiListController@updateList');
    Route::get('/updateListStatus/{id}/{status}', 'ApiListController@updateListStatus');
    Route::get('/updateCampaignList/{campaign_id}/{list_id}/{status}/{check_url}', 'ApiListController@updateCampaignList');


    Route::get('lead', 'ApiListController@searchLeads');
    Route::post('lead', 'ApiListController@searchLeadColumn');
    Route::get('searchListHeader/{list_id}', 'ApiListController@searchListHeader');
    Route::get('searchLeadColumn/{list_id}/{header_column}/{header_value}', 'ApiListController@searchLeadColumn');

    Route::get('lead-activity', 'ApiListController@showLeadActivityPage');
    Route::get('lead-data/{id?}/{number}', 'ApiListController@showEditLeadDataPage');
    Route::post('update-lead-data', 'ApiListController@updateLeadData');

    Route::get('recycle-rule', 'ApiRecycleController@getRecycleList');
    Route::post('recycle-rule', 'ApiRecycleController@searchRecycleRule');
    Route::get('add-recycle', 'ApiRecycleController@storeRecycle');
    Route::post('add-recycle', 'ApiRecycleController@storeRecycle');
    Route::get('recycle-rule/{list_id}/{disposition_id}', 'ApiRecycleController@findRecycleListDelete');
    Route::get('edit-recycle/{id}', 'ApiRecycleController@editRecycleRule');
    Route::post('edit-recycle/{id}', 'ApiRecycleController@editRecycleRule');
    Route::get('/deleteRecycleRule/{id}', 'ApiRecycleController@deleteRecycleRule');

    // sms
    Route::get('inbox', 'ApiSmsController@getSms');
    Route::post('sendSms', 'ApiSmsController@sendSms');
    Route::get('sendSms', 'ApiSmsController@sendSms');

    Route::get('/editSms/{id}', 'ApiSmsController@editSms');
    Route::get('openSmsDetails', 'ApiSmsController@openSmsDetails');
    Route::get('recentSmsList', 'ApiSmsController@recentSmsList');

    //sms templete
    Route::get('sms-templete', 'ApiSmsTempleteController@getSmsTemplete');
    Route::get('/add-sms-templete', 'ApiSmsTempleteController@storeSmsTemplete');
    Route::post('/add-sms-templete', 'ApiSmsTempleteController@storeSmsTemplete');
    Route::post('/editSmsTemplete/{id}', 'ApiSmsTempleteController@storeSmsTemplete');
    Route::get('/editSmsTemplete/{id}', 'ApiSmsTempleteController@editSmsTemplete');
    Route::get('/deleteSmsTemplete/{id}/{status}', 'ApiSmsTempleteController@deleteSmsTemplete');

    Route::get('/sms-template-delete/{id}', 'ApiSmsTempleteController@delete');


    Route::get('add-admin', 'AdminController@index');
    Route::post('add-admin', 'AdminController@addAdmin');

    // fax
    Route::any('/fax-list', 'ApiFaxController@getFax');
    Route::any('/fax-list/{id}', 'ApiFaxController@getFaxPdf');

    Route::get('send-fax', 'ApiFaxController@addFax');
    Route::post('save-fax', 'ApiFaxController@saveFax');
    Route::post('sendFaxGet', 'ApiFaxController@sendFaxGet');

    Route::any('receive-fax', 'ApiFaxController@receiveFax');
    Route::any('sending-failed-fax', 'ApiFaxController@sendingFailedFax');

    //callback
    Route::get('/callback', 'APiCallBackController@getCallBack');
    Route::post('/callback/reminder', 'APiCallBackController@getReminderCallBacks');
    Route::post('/callback', 'APiCallBackController@getCallBack');
    Route::post('callback/edit', 'APiCallBackController@editCallback');
    Route::get('callback-reminder/stop', "APiCallBackController@stopReminder");
    Route::get('callback-reminder/show', "APiCallBackController@showReminder");
    Route::get('callback-reminder/status', "APiCallBackController@getReminderStatus");

    // ivr
    Route::get('ivr', 'ApiIvrController@getIvr');
    Route::post('ivr', 'ApiIvrController@storeIvr');
    Route::get('/editIvr/{id}', 'ApiIvrController@editIvr');
    Route::get('/edit-ivr/{id?}', 'ApiIvrController@editIvrForm');
    Route::get('/deleteIvr/{id}/{ivr_id}', 'ApiIvrController@deleteIvr');
    Route::post('/get-voice-name-on-lanugage', 'ApiIvrController@getVoiceNameOnLanugage');
    Route::post('/get-audio-on-text', 'GoogleClientController@getAudioOnText');

    Route::post('/save-recorded-audio', 'ApiIvrController@saveRecordedAudio');


    // ringless voice template

    Route::get('ringless-voice', 'Ringless\RinglessVoiceController@index')->name('ringless.voice.index');
    Route::post('ringless-voice', 'Ringless\RinglessVoiceController@storeIvr');
    Route::get('/editIvr/{id}', 'ApiIvrController@editIvr');
    Route::get('/edit-ringless-voice/{id?}', 'Ringless\RinglessVoiceController@editIvrForm');
    Route::get('/deleteRinglessVoice/{id}/{ivr_id}', 'Ringless\RinglessVoiceController@deleteRinglessVoice');
    Route::post('/get-voice-name-on-lanugage', 'ApiIvrController@getVoiceNameOnLanugage');
    Route::post('/get-audio-on-text', 'GoogleClientController@getAudioOnText');

    Route::post('/save-recorded-audio', 'ApiIvrController@saveRecordedAudio');


    //audio message

    Route::get('audio-message', 'AudioMessageController@index');
    Route::post('audio-message', 'AudioMessageController@storeAudioMessage');

    Route::get('/edit-audio-message/{id?}', 'AudioMessageController@editIvrForm');






    // ivr menu
    Route::get('ivr-menu/{id?}', 'ApiIvrMenuController@getIvrMenu');
    Route::get('/deleteIvrMenu/{id}', 'ApiIvrMenuController@deleteIvrMenu');
    Route::post('edit-ivr-menu', 'ApiIvrMenuController@editIvrMenu');

    Route::get('add-ivr-menu', 'ApiIvrMenuController@storeIvrMenu');
    Route::post('add-ivr-menu', 'ApiIvrMenuController@storeIvrMenu');
    Route::get('edit-ivr-menu/{id}', 'ApiIvrMenuController@editIvrMenu');
    Route::get('/checkDestType/{dest_id}', 'ApiIvrMenuController@checkDestType');

    //Did
    Route::get('did', 'ApiDidController@getListList');
    Route::post('did', 'ApiDidController@getListList');
    Route::get('add-did', 'ApiDidController@addDid');
    Route::post('did/saveDid', 'ApiDidController@storeDid');
    Route::get('edit-did/{id}', 'ApiDidController@editList');
    Route::post('did/saveEditDid', 'ApiDidController@saveEditDid');
    Route::get('deleteDidData/{id}', 'ApiDidController@deleteDidData');
    Route::post('did/uploadDid', 'ApiDidController@upload');


    Route::get('listdid', 'ApiDidController@getListDid');
    Route::get('listdid/{cid}/{sid}/{npa}/{nxx}', 'ApiDidController@getDIDForSale');

    Route::get('call-timings-listing', 'ApiDidController@showOfficeHours');
    Route::get('did/call-timings/{dept_id?}', 'ApiDidController@showOfficeHoursForm');
    Route::post('did/save-call-timings', 'ApiDidController@saveOfficeHours');

    Route::get('holidays/{id?}', 'ApiDidController@showHolidays');
    Route::post('did/save-holiday', 'ApiDidController@saveHoliday');
    Route::get('did/delete-holiday/{id}', 'ApiDidController@deleteHoliday');

    Route::get('show-buy-did', 'ApiDidController@showBuyDidPage');
    Route::get('show-buy-did-plivo', 'ApiDidController@showBuyDidPagePlivo');
    Route::get('show-buy-did-telnyx', 'ApiDidController@showBuyDidPageTelnyx');
    Route::get('show-buy-did-twilio', 'ApiDidController@showBuyDidPageTwilio');


    Route::post('get-did-list-from-sale', 'ApiDidController@getDidListFromSale');
    Route::post('get-did-list-from-plivo', 'ApiDidController@getDidListFromPlivo');
    Route::post('get-did-list-from-telnyx', 'ApiDidController@getDidListFromTelnyx');
    Route::post('get-did-list-from-twilio', 'ApiDidController@getDidListFromTwilio');


    Route::post('buy-did', 'ApiDidController@buyDid');
    Route::post('buy-did-plivo', 'ApiDidController@buyDidPlivo');
    Route::post('buy-did-telnyx', 'ApiDidController@buyDidTelnyx');
    Route::post('buy-did-twilio', 'ApiDidController@buyDidTwilio');

    //buy no area code
    Route::get('show-buy-did-areacode', 'BuyNoAreaCodeController@index');
    Route::post('get-did-list-for-areacode', 'BuyNoAreaCodeController@getDidListForAreaCode');
    Route::post('buy-did-arecode', 'BuyNoAreaCodeController@buyDidAreacode');


    Route::post('/save-recorded-audio-announcements', 'ApiDidController@saveRecordedAudio');
   //prospects

    Route::get('prospects', 'ProspectsController@index');
    Route::get('prospects-initial-data', 'ProspectsController@ProspectsInitialData');

    // ring group
    Route::get('ring-group', 'ApiRingGroupController@getRingGroup');
    Route::post('ring-group', 'ApiRingGroupController@storeRingGroup');
    Route::get('/editRingGroup/{id}', 'ApiRingGroupController@editRingGroup');
    Route::get('/deleteRingGroup/{id}', 'ApiRingGroupController@deleteRingGroup');
    Route::get('/mapExtensionRingGroup', 'ApiRingGroupController@mapExtensionRingGroup');



    Route::get('/mailbox', 'ApiMailboxController@getMailbox');
    Route::post('/mailbox', 'ApiMailboxController@getMailbox');
    Route::get('/deleteMailbox/{id}', 'ApiMailboxController@deleteMailbox');
    Route::delete('deleteAll', 'ApiMailboxController@deleteAll');
    Route::get('/statusMailBox/{status}/{id}', 'ApiMailboxController@statusMailBox');

    // Dashboard
    Route::any('/ajax_call_report', 'ApiDashboardController@getCallDetail');
    Route::post('/change-session-value-for-timezone', 'ApiDashboardController@setSessionValue');

    Route::any('/sms-counts', 'ApiDashboardController@getSmsCounts');
    Route::any('/sms-counts-unread', 'ApiDashboardController@getSmsCountsunread');
    Route::any('/sms-counts-unread-ai', 'OpenAiController@getSmsCountsunread');
    Route::any('/send-sms-ai', 'OpenAiController@sendSms');


    Route::any('/get-call-chart-data', 'ApiDashboardController@getCdrChartData');
    Route::get('/dashboard', 'ApiDashboardController@index');
    Route::post('/dashboard', 'ApiDashboardController@index');
    Route::get('/dashboard-new', 'ApiDashboardController@dashboardNew');
    Route::get('/dashboard-crm','ApiDashboardController@dashboardNewCrm');
    // Route::post('/dashboard', 'ApiSmsController@sendSms');
    Route::post('/set-dashboard-toggle', 'ApiDashboardController@setDashboardToggle');


    //smtp setting
    Route::get('smtps', 'ApiSmtpSetting@index');
    Route::get('smtp', 'ApiSmtpSetting@showNew');
    Route::post('smtp', 'ApiSmtpSetting@addNew');
    Route::get('copy-smtp/{id}', 'ApiSmtpSetting@copySmtp');
    Route::get('/updateSmtpStatus/{id}/{status}', 'ApiSmtpSetting@updateSmtpStatus');

    Route::get('/smtp/{id}', 'ApiSmtpSetting@show')->name("smtp.edit");
    Route::post('/smtp/{id}', 'ApiSmtpSetting@update');
    Route::get('/smtp-delete/{id}', 'ApiSmtpSetting@delete');
    Route::post('/checkSMTPSetting', 'ApiSmtpSetting@checkSMTPSetting');

    //sms setting
    Route::get('sms-settings', 'SmsSettingController@index');
    Route::get('setting-sms',  'SmsSettingController@showNew');
    Route::post('setting-sms', 'SmsSettingController@addNew');
    Route::get('/setting-sms/{id}', 'SmsSettingController@show')->name("sms-setting.edit");
    Route::post('/setting-sms/{id}', 'SmsSettingController@update');
    Route::post('/sms-delete/{id}', 'SmsSettingController@delete');
    Route::post('/checkSMSSetting', 'SmsSettingController@checkSMSSetting');








    // ip setting
    Route::get('ip-setting', 'ApiIpSettingController@getIpSetting');
    Route::post('ip-approve-whitelist', 'ApiIpSettingController@approveWhitelist');
    Route::post('ip-reject-whitelist', 'ApiIpSettingController@rejectWhitelist');

    Route::get('whitelist-ip', 'ApiIpSettingController@whitelistIp');
    Route::post('whitelist-ip', 'ApiIpSettingController@whitelistIpSave');
    Route::post('query-whitelist', 'ApiIpSettingController@queryWhitelist');

    //conferencing
    Route::get('conferencing', 'ApiConferencingController@getConferencing');
    Route::post('conferencing', 'ApiConferencingController@storeConferencing');
    Route::post('conferencing/save-recorded-audio', 'ApiConferencingController@saveRecordedAudio');
    Route::get('/editConferencing/{id}', 'ApiConferencingController@editConferencing');
    Route::get('/deleteConferencing/{id}', 'ApiConferencingController@deleteConferencing');

    //Billing
    Route::get('invoice', 'InvoiceController@index');
    Route::get('invoice/{orderId}', 'InvoiceController@show');
    Route::get('invoice/pdf/{orderId}', 'InvoiceController@generatePdf');

    // send email report
    Route::get('sendCronEmailCalls', 'ApiCronSendReportController@sendCronEmailCalls');
    Route::get('/country/{country_id}', 'InheritApiController@getState');


    //notification
    Route::any('get-notification', 'InheritApiController@getNotification');
    Route::get('extension_live', 'ApiLabelController@getLiveExtension');
    Route::get('deleteExtLiv/{id}', 'ApiLabelController@deleteExtLiv');
    Route::any('get-notification-counts', 'InheritApiController@getNotificationCounts');

    //clients
    Route::get('clients', 'ClientController@index');
    Route::get('/client/{id}', 'ClientController@show');
    Route::post('client/manual-subscription', 'ClientController@performManualSubscription');
    Route::post('client/credit-wallet', 'ClientController@creditWallet');
    Route::post('/client/{id}', 'ClientController@update');
    Route::get('client', 'ClientController@showNew');
    Route::post('client', 'ClientController@addNew');

    //Route::post('client/save-sms-provider', 'ClientController@storeSMSProvider');


    //email-templates
    Route::get('email-templates', 'EmailTempleteController@index');
    Route::get('email-template', 'EmailTempleteController@showNew');
    Route::post('email-template', 'EmailTempleteController@addNew');
    Route::get('/email-template/{id}', 'EmailTempleteController@show');
    Route::post('/email-template/{id}', 'EmailTempleteController@update');
    Route::get('check-email', 'EmailTempleteController@checkMail');

    Route::get('/email-template-delete/{id}', 'EmailTempleteController@delete');
    Route::get('/deleteEmailTemplete/{id}/{status}', 'EmailTempleteController@deleteEmailTemplete');

    Route::get('/updateEmailTemplateStatus/{id}/{status}', 'EmailTempleteController@updateEmailTemplateStatus');


    //send email
    Route::get('send-mail', 'AdminController@sendMail');
    Route::post('send-mail', 'MailController@sendMail')->name('mail');

    // Route for load sms template record
    Route::post('messaging_modal_box_data', 'ApiSmsController@load_message_popup');
    Route::post('messaging_modal_sms_template_review', 'ApiSmsController@load_popup_sms_preview');
    Route::post('messaging_modal_sms_template_review_crm', 'ApiSmsController@load_popup_sms_preview_crm');

    Route::post('send_sms_dialer', 'ApiSmsController@send_sms_dialer');


    //mail controller
    Route::get('email', 'MailController@email');

    Route::get('mailer/', 'MailController@mailer');
    Route::post('mailer/', 'MailController@email');
    Route::post('send-email/generic', 'MailController@email');
    Route::post('send-email/generic-attachment', 'MailController@sendEmailGenericAttachment');


    Route::post('openMailModal', 'MailController@openMailModal');
    Route::post('change-disposition', 'ApiListController@changeDisposition');

    Route::get('/getTemplate/{id}/{list_id}/{lead_id}', 'MailController@getTemplate');
    Route::get('/getLabelValue/{label_id}/{list_id}/{lead_id}', 'MailController@getLabelValue');
    Route::get('/getSenderValue/{sender_id}', 'MailController@getSenderValue');
    Route::get('checkEmail/{email}', 'ApiExtensionController@checkEmail');

    //Coupons
    Route::get('coupons', 'ApiCouponsController@index');
    Route::get('coupon-detail/{id?}', 'ApiCouponsController@detail');
    Route::post('coupon-edit', 'ApiCouponsController@edit');

    // Show user packages
    Route::get('user-packages', 'ApiUserPackagesController@getUsersByClientId');
    Route::post('/user-package/update/{packageKey}', 'ApiUserPackagesController@updateUserPackage');
    Route::post('/user-package/delete/{packageKey}', 'ApiUserPackagesController@deleteUserPackage');

    //client Plans
    Route::get('active-plans', 'ClientPackageController@activePlans');
    Route::get('plan-history', 'ClientPackageController@planHistory');
    Route::get('packages', 'ClientPackageController@upgradePlan');

    //wallet
    Route::get('wallet/transactions', 'WalletController@getWalletTransactions');

    //cart
    Route::get('cart', 'CartController@getCartItems');
    Route::get('cart/count', 'CartController@getCartCount');
    Route::post('cart/add/{packageName}', 'CartController@addToCart');
    Route::post('cart/update/{cartId}', 'CartController@updateCart');
    Route::post('cart/delete/{cartId}', 'CartController@deleteCart');
    //api logs
    Route::get('api-logs-data', 'ApiLogsController@getApilogs');
    Route::post('api-logs-data', 'ApiLogsController@getLog');

    // Route::post('api-logs', 'ApiLogsController@getLog');


    //sms ai
    Route::any('/sms-ai', 'OpenAiController@demo');
    Route::get('/sms-ai-setting', 'OpenAiController@index');
    Route::post('/sms-ai-setting', 'OpenAiController@add');
    Route::get('/flush-cache', 'OpenAiController@flushCache');

    Route::post('/delete-message-ai', 'OpenAiController@delete');

    //chat ai

    Route::any('/chat-ai', 'ChatAiController@demo');

    Route::any('/chat-msg-ai', 'ChatAiController@sendSms');

    Route::any('/chat-counts-unread-ai', 'ChatAiController@getChatCountsunread');

    Route::any('/send-text-to-ai', 'ChatAiController@sendTextToAi');

    Route::get('/chat-ai-setting', 'ChatAiController@index');
    Route::post('/chat-ai-setting', 'ChatAiController@add');
    Route::get('/flush-cache-chat', 'ChatAiController@flushCache');








    Route::group(['middleware' => ["auth.superadmin"]], function () {
        //subscription packages
        Route::get('super/packages', 'PackageController@index');
        Route::get('super/package', 'PackageController@showNew');
        Route::post('super/package', 'PackageController@addNew');
        Route::get('super/package/{key}', 'PackageController@show');
        Route::post('super/package/{key}', 'PackageController@update');
        Route::get('super/package/copy/{key}', 'PackageController@copy');
        Route::post('super/package/copy/{key}', 'PackageController@addNew');
        Route::get('super/package/view/{key}', 'PackageController@view');

        Route::get('super/package/rate/add', 'PackageController@addRate');
        Route::post('super/package/rate/add', 'PackageController@addNewRate');
        Route::get('super/package/rate/{key}', 'PackageController@rate');


        Route::get('super/package/rate/edit/{id}', 'PackageController@editShow');
        Route::post('super/package/rate/edit/{id}', 'PackageController@updateRate');



        //modules
        Route::get('super/modules', 'ModulesController@index');
        Route::get('super/module',  'ModulesController@showNew');
        Route::post('super/module', 'ModulesController@addNew');
        Route::get('super/module/{key}', 'ModulesController@show');
        Route::post('super/module/{key}', 'ModulesController@update');
        Route::get('super/components', 'ModuleComponentController@index');
    });
Route::prefix('admin/blogs')->group(function () {

    Route::get('/', [BlogController::class, 'index'])->name('blogs.index');

    Route::get('/create', [BlogController::class, 'create'])->name('blogs.create');

    Route::get('/{blog}', [BlogController::class, 'show'])->name('blogs.show');

    Route::post('/', [BlogController::class, 'store'])->name('blogs.store');

    Route::get('/tag/{id}', [BlogController::class, 'tag'])->name('blogs.tag');

    Route::get('/{id}/edit', [BlogController::class, 'edit'])->name('blogs.edit');

    Route::put('/{id}', [BlogController::class, 'update'])->name('blogs.update');

    Route::delete('/{id}', [BlogController::class, 'destroy'])->name('blogs.destroy');

    Route::get('/restore/{id}', [BlogController::class, 'restore'])->name('blogs.restore');

    Route::post('/upload-image', [BlogController::class, 'uploadImage'])->name('blogs.upload-image');

    Route::put('/{id}/status', [BlogController::class, 'toggleStatus'])->name('blogs.toggle-status');

    Route::get('/load', [BlogController::class, 'loadMoreBlogs'])->name('blogs.load');
});

    //Stripe
    Route::get('payment-method-list', 'PaymentController@showPaymentMethodList');
    Route::get('edit-payment-method', 'PaymentController@editPaymentMethod');
    Route::post('stripe/save-card', 'PaymentController@saveCard');
    Route::get('update-payment-method/{id}', 'PaymentController@updatePaymentMethod');
    Route::post('stripe/update-card', 'PaymentController@updateCard');
    Route::get('delete-payment-method/{id}', 'PaymentController@deletePaymentMethod');
    Route::get('recharge', 'PaymentController@recharge');
    Route::post('user/auto-recharge-update', 'PaymentController@updateAutoRechargeFrontend');
    Route::post('stripe/create-customer-payment-method', 'StripeController@createStripeCustomerPaymentMethod');
    Route::post('stripe/attach-customer-and-payment-method', 'StripeController@attachCustomerAndPaymentMethod');
    Route::post('pay', 'StripeController@pay');
    Route::post('set-default-payment-method', 'PaymentController@setDefaultPaymentMethod');
    Route::get('get-default-payment-method', 'PaymentController@getDefaultPaymentMethod');
    Route::get('checkout', 'PaymentController@checkout');
    Route::post('checkout', 'StripeController@processCheckout');
    Route::post('checkout/subscription', 'StripeController@processSubscriptionCheckout');

    // AI calling Subscription
    Route::get('buy-subscription-rz', 'PaymentController@buySubscriptionRZ');

    // razoarpay
    Route::post('/razorpay-create-order-recharge', 'RazorpayController@createOrderRecharge');
    Route::post('/razorpay-verify-order-recharge', 'RazorpayController@verifyOrderRecharge');
    Route::post('/razorpay-create-subscription', 'RazorpayController@createSubscription');
    Route::post('/razorpay-verify-subscription', 'RazorpayController@verifySubscription');
    Route::post('/razorpay-create-auto-recharge-mandate', 'RazorpayController@createAutoRechargeMandate');
    Route::post('/razorpay-verify-auto-recharge-mandate', 'RazorpayController@verifyAutoRechargeMandate');
    Route::post('/razorpay-trigger-auto-recharge', 'RazorpayController@triggerAutoRecharge');

    //opening questions
    Route::get('opening-questions/hide', "OpeningQuestionsController@doNotShow");
    Route::get('opening-questions/hide/permanently', "OpeningQuestionsController@hideQuestionsPermanently");
    Route::get('opening-questions/show/permanently', "OpeningQuestionsController@showQuestionsPermanently");
    Route::get('flash-panel', "OpeningQuestionsController@flashPanel");

    //super admin links
    Route::get('/super-admins', 'SuperAdminController@index');
    Route::get('/super-admin/{id}', 'SuperAdminController@show');
    Route::post('/super-admin/{id}', 'SuperAdminController@update');

    Route::get('contact-book', 'ApiContactsController@getCompanyUsers');

    //Chat application
    Route::post('/favorites', 'MessagesController@getFavorites')->name('favorites');
    Route::get('/search', 'MessagesController@search')->name('search');
    Route::post('/idInfo', 'MessagesController@idFetchData');
    Route::post('/shared', 'MessagesController@sharedPhotos')->name('shared');
    Route::post('/fetchMessages', 'MessagesController@fetch')->name('fetch.messages');
    Route::post('/sendMessage', 'MessagesController@send')->name('send.message');
    Route::post('/updateContacts', 'MessagesController@updateContactItem')->name('contacts.update');
    Route::post('/makeSeen', 'MessagesController@seen')->name('messages.seen');
    Route::get('/getContacts', 'MessagesController@getContacts')->name('contacts.get');
    Route::get('/chat', 'MessagesController@index');
    Route::post('/chat/auth', 'MessagesController@pusherAuth')->name('pusher.auth');
    Route::post('/setActiveStatus', 'MessagesController@setActiveStatus')->name('activeStatus.set');
    Route::post('/updateSettings', 'MessagesController@updateSettings')->name('avatar.update');
    Route::post('/star', 'MessagesController@favorite')->name('star');
    Route::post('/deleteConversation', 'MessagesController@deleteConversation')->name('conversation.delete');
    Route::get('/download/{fileName}', 'MessagesController@download');
    Route::get('/chat/{id}', 'MessagesController@index')->name('user');

    //TODO: need to work on group chat functionality
    Route::get('/group/{id}', 'MessagesController@index')->name('group');


    //SIP Gateways
    Route::get('sip-gateways', 'SipGatewaysController@index');
    Route::get('sip-gateway', 'SipGatewaysController@add');
    Route::post('sip-gateway', 'SipGatewaysController@create');
    Route::get('sip-gateway/{id}', 'SipGatewaysController@edit');
    Route::post('sip-gateway/{id}', 'SipGatewaysController@saveEdit')->name('sip.gateways');
    Route::get('sip-gateway-delete/{id}', 'SipGatewaysController@delete');

    Route::get('/tariff-label/{id}', 'TariffLabelController@show');
    Route::post('/tariff-label/{id}', 'TariffLabelController@update');
    Route::get('/delete-tariff-label/{id}', 'TariffLabelController@delete');

    //Tariff Label
    Route::get('tariff-labels', 'TariffLabelController@index');
    Route::post('tariff-labels', 'TariffLabelController@create');
    Route::get('/tariff-label/{id}', 'TariffLabelController@show');
    Route::post('/tariff-label/{id}', 'TariffLabelController@update');
    Route::get('/delete-tariff-label/{id}', 'TariffLabelController@delete');

    //Tariff Label Values
    Route::get('tariff-label-values', 'TariffLabelValuesController@index');
    Route::get('tariff-label-value', 'TariffLabelValuesController@create');
    Route::post('tariff-label-value', 'TariffLabelValuesController@addNew');
    Route::get('/tariff-label-value/{id}', 'TariffLabelValuesController@show');
    Route::post('/tariff-label-value/{id}', 'TariffLabelValuesController@update');
    Route::get('/delete-tariff-label-value/{id}', 'TariffLabelValuesController@delete');

    //Allowed IPs
    Route::get('allowed-ips', 'AllowedIpController@index');
    Route::post('allowed-ips', 'AllowedIpController@create');
    Route::get('/allowed-ip/{id}', 'AllowedIpController@show');
    Route::post('/allowed-ip/{id}', 'AllowedIpController@update');
    Route::get('/delete-allowed-ip/{id}', 'AllowedIpController@delete');
    Route::get('/updateAllowedIpStatus/{id}/{status}', 'AllowedIpController@updateAllowedIpStatus');

    //voip configuration
    Route::get('voip-configurations', 'VoipConfigurationController@index');
    Route::get('voip-configuration', 'VoipConfigurationController@create');
    Route::post('voip-configuration', 'VoipConfigurationController@addNew');
    Route::get('/voip-configuration/{id}', 'VoipConfigurationController@show');
    Route::post('/voip-configuration/{id}', 'VoipConfigurationController@update');
    Route::get('/delete-voip-configuration/{id}', 'VoipConfigurationController@delete');

    //Custom Field Label
    Route::get('custom-field-labels', 'CustomFieldLabelController@index');
    Route::post('custom-field-labels', 'CustomFieldLabelController@create');
    Route::get('/custom-field-label/{id}', 'CustomFieldLabelController@show');
    Route::post('/custom-field-label/{id}', 'CustomFieldLabelController@update');
    Route::get('/delete-custom-field-label/{id}', 'CustomFieldLabelController@delete');


    //Custom Field Label Values
    Route::get('custom-fields-values', 'CustomFieldLabelsValuesController@index');
    Route::post('custom-fields-values', 'CustomFieldLabelsValuesController@create');
    Route::get('/custom-field-value/{id}', 'CustomFieldLabelsValuesController@show');
    Route::post('/custom-field-value/{id}', 'CustomFieldLabelsValuesController@update');
    Route::get('/getCustomFieldValue/{id}', 'CustomFieldLabelsValuesController@getCustomFieldValue');
    Route::get('/delete-custom-field-value/{id}', 'CustomFieldLabelsValuesController@delete');

    //cli report

    Route::get('cli-report', 'CliReportController@index');
    Route::post('cli-report', 'CliReportController@index');

    Route::get('cli-report-manually/{phone_number}', 'CliReportController@callManually');
    Route::get('cli-report-manually-cnam/{phone_number}/{did_value}', 'CliReportController@callManuallyCNAM');

    Route::get('find-cli-report/{phone_number}', 'CliReportController@findCliReport');

    Route::get('/cli-report/fetch_data', 'CliReportController@fetch_data');
    /* Ringless Voicemail*/
    //campaign
    Route::get('ringless-campaigns', 'Ringless\RinglessCampaignController@index');
    Route::get('ringless/campaign/add', 'Ringless\RinglessCampaignController@storeCampaign');
    Route::post('ringless/campaign/add', 'Ringless\RinglessCampaignController@postStoreCampaign');
    Route::get('ringless/campaign/edit/{id}', 'Ringless\RinglessCampaignController@showEditCampaign');
    Route::post('ringless/campaign/edit/{id}', 'Ringless\RinglessCampaignController@editCampaign');
    Route::get('ringless/campaign/delete/{id}', 'Ringless\RinglessCampaignController@deleteCampaign');
    Route::get('ringless/campaign/update-status/{id}/{status}', 'Ringless\RinglessCampaignController@updateCampaignStatus');
    Route::get('ringless/campaign/copy/{id}', 'Ringless\RinglessCampaignController@copyCampaign');
    //list

    /*Route::get('ringless/list ', 'Ringless\RinglessListController@index');
    Route::post('ringless/list ', 'Ringless\RinglessListController@storeList');
    Route::get('ringless/list/edit/{id}/{campaign}', 'Ringless\RinglessListController@editList');
    Route::post('ringless/list/edit/{id}/{campaign}', 'Ringless\RinglessListController@editList');
    Route::get('ringless/list/delete/{id}/{campaign}', 'Ringless\RinglessListController@deleteListData');
    Route::get('ringless/list/delete/{id}/{campaign}', 'Ringless\RinglessListController@deleteListData');
    Route::get('ringless/list/updateStatus/{id}/{status}', 'Ringless\RinglessListController@updateListStatus');
    Route::get('ringless/list/{id}/content', 'Ringless\RinglessListController@getListContent');*/

    //ringless lists
    Route::get('ringless-lists', 'Ringless\RinglessListController@list');
    Route::post('ringless-lists ', 'Ringless\RinglessListController@create');
    Route::get('/ringless/list/edit/{id}/{campaign}', 'Ringless\RinglessListController@show');
    Route::post('/ringless/list/update/{id}', 'Ringless\RinglessListController@update');
    Route::get('/ringless/list/update-status/{id}/{status}', 'Ringless\RinglessListController@updateStatus');

    Route::get('ringless/list/delete/{id}', 'Ringless\RinglessListController@delete');
    Route::get('ringless/list/recycle/{id}', 'Ringless\RinglessListController@recycle');

    //reports
    Route::get('ringless-report', 'Ringless\RinglessCallReportController@index');
    Route::post('ringless-report', 'Ringless\RinglessCallReportController@getReport');
    //billing
    Route::get('ringless-recharge ', 'Ringless\RinglessRechargeController@index');
    Route::post('ringless-recharge ', 'Ringless\RinglessRechargeController@Recharge');

    Route::get('ringless-payment-method', 'Ringless\RinglessPaymentMethodController@index');
    Route::get('ringless/add-payment-method', 'Ringless\RinglessPaymentMethodController@addPaymentMethod');
    Route::post('ringless/stripe/save-card', 'Ringless\RinglessPaymentMethodController@saveCard');
    Route::get('ringless/edit-payment-method/{id}', 'Ringless\RinglessPaymentMethodController@editPaymentMethod');
    Route::get('ringless/stripe/delete-payment-method/{id}', 'Ringless\RinglessPaymentMethodController@deletePaymentMethod');
    Route::post('ringless/stripe/update-card', 'Ringless\RinglessPaymentMethodController@updateCard');
    Route::get('ringless-wallet-transactions', 'Ringless\RinglessWalletController@getWalletTransactions');
    Route::get('ringless-wallet-amount', 'Ringless\RinglessWalletController@getWalletAmount');
    Route::get('rvm-cdr-log', 'Ringless\RvmCdrLogController@index');
    Route::post('rvm-cdr-log', 'Ringless\RvmCdrLogController@index');

    /* Close Ringless Voicemail*/
    /* Sip Trunk*/
    //trunking reports
    Route::get('trunking-call-report ', 'Sip_trunk\TrunkingCallReportController@index');
    Route::post('trunking-call-report ', 'Sip_trunk\TrunkingCallReportController@getReport');
    //billing
    Route::get('trunking-recharge ', 'Sip_trunk\TrunkingRechargeController@index');
    Route::post('trunking-recharge ', 'Sip_trunk\TrunkingRechargeController@Recharge');

    Route::get('trunking-payment-method', 'Sip_trunk\TrunkingPaymentMethodController@index');
    Route::get('trunking/add-payment-method', 'Sip_trunk\TrunkingPaymentMethodController@addPaymentMethod');
    Route::post('trunking/stripe/save-card', 'Sip_trunk\TrunkingPaymentMethodController@saveCard');
    Route::get('trunking/edit-payment-method/{id}', 'Sip_trunk\TrunkingPaymentMethodController@editPaymentMethod');
    Route::get('trunking/stripe/delete-payment-method/{id}', 'Sip_trunk\TrunkingPaymentMethodController@deletePaymentMethod');
    Route::post('trunking/stripe/update-card', 'Sip_trunk\TrunkingPaymentMethodController@updateCard');
    Route::get('trunking-balance', 'Sip_trunk\TrunkingBalanceController@getBalance');
    Route::get('trunking-wallet-transactions', 'Sip_trunk\TrunkingWalletController@getWalletTransactions');


    /* Close Sip Trunk*/
    //schedule
    Route::get('schedule', 'ScheduleController@index');
    Route::post('save-schedule', 'ScheduleController@store')->name('save.schedule');
    Route::get('delete-schedule/{id}', 'ScheduleController@deleteSchedule');

    //marketing campaign
    Route::get('drip-campaigns', 'CrmDripCampaignController@index');
    Route::get('drip-campaigns/add', 'CrmDripCampaignController@add');
    Route::post('drip-campaigns/add', 'CrmDripCampaignController@addNew');
    Route::get('drip-campaigns/edit/{id}', 'CrmDripCampaignController@show');
    Route::post('drip-campaigns/edit/{id}', 'CrmDripCampaignController@update');
    Route::get('/updateDripStatus/{id}/{status}', 'CrmDripCampaignController@updateDripStatus');

    Route::post('add-drip-schedule', ['as' => 'addDripSchedule', 'uses' => 'DripCampaignScheduleController@addDripSchedule']);


    /* Contact CRM */
    //ai-setting
    Route::get('ai-setting/users-cli-name', 'AiSetting\UsersCliNameController@index');
    Route::get('ai-setting/list-sms', 'AiSetting\SmsListController@index');
    Route::get('ai-setting/delete-sms-list', 'AiSetting\DeleteSmsListController@index');
    Route::get('ai-setting/delete-sms', 'AiSetting\DeleteSmsListController@delete');


    //send email

    Route::get('openEmailModal', 'MailController@openEmailModal');
    Route::get('/getTemplate-crm/{id}/{list_id}/{lead_id}', 'MailController@getTemplateCRM');
    Route::get('/getLabelValue-crm/{label_id}/{list_id}/{lead_id}', 'MailController@getLabelValueCRM');

    Route::get('send-email-crm/generic', 'MailController@sendEmailGenericCRM');

    Route::get('/signed-application-crm/{id}/{list_id}/{lead_id}', 'MailController@getSignedApplicationCRM');
    Route::get('/signed-application-pdf-crm/{id}/{list_id}/{lead_id}', 'MailController@getSignedApplicationCRMPDF');









    //lenders

    Route::get('/lenders', 'LenderController@index')->name('lenders.index');
    Route::get('/lender/add', 'LenderController@showNew');
    Route::post('/lender/add', 'LenderController@add');
    Route::get('/lender/{id}/edit', 'LenderController@show');
    Route::post('/lender/{id}/edit', 'LenderController@update');
    Route::get('/lender/profile', 'LenderController@profile');
    Route::delete('/lender/{id}', 'LenderController@delete')->name('lender.delete');
    Route::get('/changeLenderStatus/{id}/{status}', 'LenderController@changeLenderStatus');
    Route::get('/lender/master-sheet', 'LenderController@MasterSheet');
    Route::get('/lender/{id}/modal', 'LenderController@showModal');


    //lead status
    Route::get('/lead-status', 'LeadsStatusController@index');
    Route::post('/lead-status', 'LeadsStatusController@add');
    Route::post('/lead-status/edit', 'LeadsStatusController@update')->name('leadstatus.update');
    Route::post('/update-lead-status/displayorder', 'LeadsStatusController@updateDisplayOrder');

    Route::get('/lead-status/{id}', 'LeadsStatusController@delete')->name('leadstatus.delete');
    Route::get('/changeLeadStatus/{id}/{status}', 'LeadsStatusController@changeLeadStatus');
    Route::get('/changeViewOnLeadStatus/{id}/{status}', 'LeadsStatusController@changeViewOnLeadStatus');
    //Document Types
    Route::get('/document-types', 'DocumentTypeController@index');
    Route::post('/document-types', 'DocumentTypeController@add');
    Route::post('/document-types/edit', 'DocumentTypeController@update')->name('documenttype.update');
    Route::get('/document-types/{id}', 'DocumentTypeController@delete')->name('documenttype.delete');
    Route::get('/changeDocumentTypeStatus/{id}/{status}', 'DocumentTypeController@changeDocumentTypeStatus');
    //document uploaded
    Route::get('documents', 'DocumentController@list');
    Route::get('document/{id}', 'DocumentController@index');
    Route::post('document/{id}', 'DocumentController@index');
    Route::post('/type-value/post', 'DocumentController@store');

    Route::get('/document-delete/{id}', 'DocumentController@delete')->name('document.delete');
    Route::post('/document', 'DocumentController@update')->name('document.update');

    //Labels
    Route::get('/crm-labels', 'CrmLabelController@index');
    Route::post('/crm-labels', 'CrmLabelController@add');
    Route::post('/crm-labels/edit', 'CrmLabelController@update')->name('label.update');
    Route::post('/crm-update/displayorder', 'CrmLabelController@updateDisplayOrder');

    Route::get('/crm-labels/{id}', 'CrmLabelController@delete')->name('label.delete');
    Route::get('/crm-changeLabelStatus/{id}/{status}', 'CrmLabelController@changeLabelStatus');
    Route::get('/crm-changeViewOnLead/{id}/{status}', 'CrmLabelController@changeViewOnLead');


    //leads
    Route::get('/send-data-on-webhook/{lead_id}', 'LeadsController@sendDataOnWebhook');

    Route::get('/leads-old/', 'LeadsController@index');
    Route::post('/leads-old/', 'LeadsController@index');
    Route::get('/leads/', 'LeadsController@indexNew');
    Route::post('/leads/', 'LeadsController@indexNew');
    Route::get('/sub-leads/', 'LeadsController@indexSubLeadsNew');
    Route::post('/sub-leads/', 'LeadsController@indexSubLeadsNew');
    Route::get('/sub-leads-old/', 'LeadsController@indexSubLeads');
    Route::post('/sub-leads-old/', 'LeadsController@indexSubLeads');
    Route::get('/leads/leadRecords', 'LeadsController@leadRecords');
    Route::get('/leads/add', 'LeadsController@addShow');
    Route::post('/leads/add', 'LeadsController@add');
    Route::post('/leads/import', 'LeadsController@import');
    Route::get('/leads/{id}/edit', 'LeadsController@editShow');
    Route::post('/update/lead-status', 'LeadsController@updateByLeadStatus');
    Route::post('/leads/{id}/edit', 'LeadsController@update');
    Route::get('/deleteLead/{id}', 'LeadsController@delete');
    Route::get('/leads/view', 'LeadsController@view');
    Route::get('/lead/addLead', 'LeadsController@addLead');
    // Route::post('/leadStatusFilter', 'LeadsController@leadStatusFilter');
    Route::post('/submitLenderStatus', 'LeadsController@submitLenderStatus');
    Route::get('lender/notes/add', 'LeadsController@addNotes');
    Route::post('lender/edit-notes', 'LeadsController@editNotes');
    Route::get('/leads/copy/{id}', 'LeadsController@copy');
    Route::post('leads/add/opener', 'LeadsController@addOpener');
    Route::post('leads/add/closer', 'LeadsController@addCloser');
    // Route::get('/leads/copy/{id}', 'LeadsController@copy');
    Route::get('leads/fcs-data/{id}', 'FcsController@index');
    Route::post('leads/fcs-data/{id}', 'FcsController@store');
    Route::get('eligible-lender/{lead_id}/{bank_id}', 'FcsController@EligibleLender')->name('eligible-lender');
    Route::post('lender-matrix/{lead_id}/{bank_id}', 'FcsController@LenderList');
    Route::post('/leads/addTask', 'LeadsController@addTask');
    Route::get('/leads/reminder/{lead_id}', 'LeadsController@Reminder');
    Route::get('/leads/reminder/delete/{lead_id}/{id}', 'LeadsController@deleteTask');
    Route::post('/merchant-add', 'LeadsController@createMerchant');

    //Lead Source
    Route::get('/lead-source', 'LeadSourceController@index');
    Route::post('/lead-source', 'LeadSourceController@add');
    Route::post('/lead-sources/edit', 'LeadSourceController@update')->name('leadsource.update');

    //crm dashboard
    Route::get('show-dashboard', 'CrmDashboardController@showDashboard');

    Route::get('crm-dashboard', 'CrmDashboardController@view');
    Route::post('crm-dashboard', 'CrmDashboardController@view');
    // Route::get('crm-dashboard-index', 'CrmDashboardController@index');
    // Route::get('crm-dashboard-index-new', 'CrmDashboardController@indexNew');
    Route::get('crm-dashboard-new', 'CrmDashboardController@viewNew');
    Route::post('crm-dashboard-new', 'CrmDashboardController@viewNew');
    // routes/web.php or routes/api.php
    Route::get('/lead-status-chart', 'CrmDashboardController@getLeadStatusChart')->name('lead-status.chart');

    //notifications
    Route::get('notification/add', 'NotificationController@addNotes');
    Route::get('lead-source-log/add', 'NotificationController@addLogForLeadSource');
    //email templates

    Route::get('/crm-email-templates', 'CrmEmailTemplateController@index');
    Route::get('/crm-email-template/add', 'CrmEmailTemplateController@showNew');
    Route::post('/crm-email-template/add', 'CrmEmailTemplateController@add');
    Route::get('/crm-email-template/{id}/edit', 'CrmEmailTemplateController@show');
    Route::post('/crm-email-template/{id}/edit', 'CrmEmailTemplateController@update');
    Route::get('/crm-changeEmailTemplateStatus/{id}/{status}', 'CrmEmailTemplateController@changeEmailTemplateStatus');
    Route::get('/crm-email-template-delete/{id}', 'CrmEmailTemplateController@delete')->name('crm-email-template.delete');
    //crm sms templates
    Route::get('/crm-sms-templates', 'CrmSmsTemplateController@index');
    Route::get('/crm-sms-template/add', 'CrmSmsTemplateController@showNew');
    Route::post('/crm-sms-template/add', 'CrmSmsTemplateController@add');
    Route::get('/crm-sms-template/{id}/edit', 'CrmSmsTemplateController@show');
    Route::post('/crm-sms-template/{id}/edit', 'CrmSmsTemplateController@update');
    Route::get('/crm-changeSmsTemplateStatus/{id}/{status}', 'CrmSmsTemplateController@changeSmsTemplateStatus');
    Route::get('/crm-sms-template-delete/{id}', 'CrmSmsTemplateController@delete');

    //crm system setting
    Route::get('/crm-system-setting', 'CrmSystemSettingController@index');
    Route::post('/crm-system-setting', 'CrmSystemSettingController@add')->name('System.add');
    Route::post('/crm-system-setting/edit', 'CrmSystemSettingController@update')->name('System.update');

    ////custom templates

    Route::get('/crm-custom-templates', 'CrmCustomTemplateController@index');
    Route::get('/crm-custom-template/add', 'CrmCustomTemplateController@showNew');
    Route::post('/crm-custom-template/add', 'CrmCustomTemplateController@add');
    Route::get('/crm-custom-template/{id}/edit', 'CrmCustomTemplateController@show');
    Route::post('/crm-custom-template/{id}/edit', 'CrmCustomTemplateController@update');
    Route::get('/crm-changeCustomTemplateStatus/{id}/{status}', 'CrmCustomTemplateController@changeCustomTemplateStatus');
    Route::get('/crm-custom-template-delete/{id}', 'CrmCustomTemplateController@delete')->name('crm-custom-template.delete');

    //crm email setting
    Route::get('/crm-email-setting', 'CrmEmailSettingController@index');
    Route::post('/crm-email-setting', 'CrmEmailSettingController@add');
    Route::post('/checkcrmSMTPSetting', 'CrmEmailSettingController@checkCrmSMTPSetting');
    Route::post('/crm-email-setting/edit', 'CrmEmailSettingController@update')->name('Smtp.update');

    /* Close Contact CRM */

    /* SMS AI*/

    Route::get('sms-ai-campaign', 'SmsAi\SmsAiCampaignController@list');
    Route::get('/smsai/campaign/add', 'SmsAi\SmsAiCampaignController@create');
    Route::post('/smsai/campaign/add', 'SmsAi\SmsAiCampaignController@add');
    Route::get('/smsai/campaign/view/{id}', 'SmsAi\SmsAiCampaignController@show');
    Route::post('/smsai/campaign/update/{id}', 'SmsAi\SmsAiCampaignController@update');
    Route::get('smsai/campaign/update-status/{id}/{status}', 'SmsAi\SmsAiCampaignController@updateCampaignStatus');
    Route::get('smsai/campaign/copy/{id}', 'SmsAi\SmsAiCampaignController@copyCampaign');
    Route::get('smsai/campaign/delete/{id}', 'SmsAi\SmsAiCampaignController@deleteCampaign');



    //smsai lists
    Route::get('sms-ai-lists', 'SmsAi\SmsAiListController@list');
    Route::post('sms-ai-lists', 'SmsAi\SmsAiListController@create');
    Route::get('/smsai/list/edit/{id}/{campaign}', 'SmsAi\SmsAiListController@show');
    Route::post('/smsai/list/update/{id}', 'SmsAi\SmsAiListController@update');
    Route::get('/smsai/list/update-status/{id}/{status}', 'SmsAi\SmsAiListController@updateStatus');

    Route::get('smsai/list/delete/{id}', 'SmsAi\SmsAiListController@delete');
    Route::get('smsai/list/recycle/{id}', 'SmsAi\SmsAiListController@recycle');
    //billing
    Route::get('sms-ai-recharge', 'SmsAi\SmsAiRechargeController@index');
    Route::post('sms-ai-recharge', 'SmsAi\SmsAiRechargeController@Recharge');
    Route::get('sms-ai-payment-method', 'SmsAi\SmsAiPaymentMethodController@index');
    Route::get('sms-ai/add-payment-method', 'SmsAi\SmsAiPaymentMethodController@addPaymentMethod');
    Route::post('sms-ai/stripe/save-card', 'SmsAi\SmsAiPaymentMethodController@saveCard');
    Route::get('sms-ai/edit-payment-method/{id}', 'SmsAi\SmsAiPaymentMethodController@editPaymentMethod');
    Route::get('sms-ai/stripe/delete-payment-method/{id}', 'SmsAi\SmsAiPaymentMethodController@deletePaymentMethod');
    Route::post('sms-ai/stripe/update-card', 'SmsAi\SmsAiPaymentMethodController@updateCard');
    Route::get('sms-ai-wallet-transactions', 'SmsAi\SmsAiWalletController@getWalletTransactions');
    Route::get('sms-ai-wallet-amount', 'SmsAi\SmsAiWalletController@getWalletAmount');

    #reports


    Route::get('/sms-ai-report', 'SmsAi\SmsAiReportController@index');
    Route::get('/sms-ai-report/view', 'SmsAi\SmsAiReportController@view');
    Route::any('/sms-counts-unread-ai-report', 'SmsAi\SmsAiReportController@getSmsCountsunread');
    Route::post('/delete-message-ai-report', 'SmsAi\SmsAiReportController@delete');
    #sms-ai-daily-report
    Route::get('/sms-ai-daily-report/', 'SmsAi\SmsAiDailyReportController@index');
    Route::post('/sms-ai-daily-report/', 'SmsAi\SmsAiDailyReportController@index');




    #sms ai templates

    Route::get('sms-ai-templates', 'SmsAi\SmsAiTemplatesController@list');
    Route::get('/smsai/template/add', 'SmsAi\SmsAiTemplatesController@create');
    Route::post('/smsai/template/add', 'SmsAi\SmsAiTemplatesController@add');
    Route::get('/smsai/template/view/{id}', 'SmsAi\SmsAiTemplatesController@show');

    Route::post('/smsai/template/update/{id}', 'SmsAi\SmsAiTemplatesController@update');
    Route::get('/smsai/template/update-status/{id}/{status}', 'SmsAi\SmsAiTemplatesController@updateStatus');
    Route::get('smsai/template/delete/{id}', 'SmsAi\SmsAiTemplatesController@delete');











    /* Close SMS AI*/
    // Prompt CRUD
    Route::any('/prompts', 'PromptController@index')->name('prompts.index');
    Route::any('/prompts/create', 'PromptController@create')->name('prompts.create');
    Route::post('/prompts/store', 'PromptController@store')->name('prompts.store');
    Route::any('/prompts/edit/{id}', 'PromptController@edit')->name('prompts.edit');
    Route::any('/prompts/show/{id}', 'PromptController@show')->name('prompts.show');
    Route::post('/prompts/update/{id}', 'PromptController@update')->name('prompts.update');
    Route::post('/prompts/delete/{id}', 'PromptController@destroy')->name('prompts.destroy');
    Route::post('/prompts/save-functions/{id}', 'PromptController@saveFunctions')->name('prompts.saveFunctions');
    Route::post('/prompts/voice-preview', 'PromptController@voicePreview');
   Route::post('/prompts/process-voice-interaction', 'PromptController@processVoiceInteraction')->name('prompts.processVoiceInteraction');
   Route::post('/prompts/log-client-event', 'PromptController@logClientEvent')->name('prompts.logClientEvent');

    // google access token
    Route::get('/google/oauth', 'GoogleAuthController@init')->name('google.oauth');;
    Route::get('/google/oauth/access-token/callback', 'GoogleAuthController@callback');

    #ringless voicemail drop api report

    Route::get('/ringless-voicemail-report/', 'RinglessVoicemailReportController@index');
    Route::post('/ringless-voicemail-report/', 'RinglessVoicemailReportController@index');
    // save fcm token
    Route::post('/save-fcm-token', 'FCMController@saveFcmToken')->name('fcm.saveFcmToken');
    Route::get('/test-notification', 'FCMController@sendTestNotificationView');
    Route::post('/send-test-notification', 'FCMController@sendTestNotification')->name('notification.test');

    // Leadmine Pro new registration
    Route::get('/leadmine-pro-new-register', [FrontendRegisterController::class, 'index'])->name('leadminepro.index');

});

Route::post('/type-value-merchant/post', 'DocumentController@storeMerchant');


Route::get('/voice-audio', 'GoogleClientController@voiceAudio');
Route::get('/voice-ai-user-extension', 'VoiceAiExtensionUserController@voiceAudio');


Route::any('receiver-fax', 'ApiFaxController@receiverFax');
Route::any('receiver-fax-ring', 'ApiFaxController@receiverFaxRing');
Route::post('start-dialing/upload', 'MailController@upload')->name('start-dialing.upload');

//voicemail api receiveing from external
Route::get('voice-mail-receiveing', 'ApiSmsController@voiceMailReceiver');

Route::get('extension-live-call-status', 'ApiSmsController@gextensionLiveCallStatus');


//conferenceing

Route::get('live-conference', 'LiveConferenceController@index');
Route::get('recording-conference', 'RecordingConferenceController@index');

//Lead Source Config
Route::get('lead-source-configs', 'LeadSourceConfigController@index');
Route::get('lead-source-config', 'LeadSourceConfigController@showNew');
Route::post('lead-source-config', 'LeadSourceConfigController@addNew');
Route::get('getLeadHeader/{list_id}', 'LeadSourceConfigController@getLeadHeader');
Route::get('deleteLeadConfig/{api_key}', 'LeadSourceConfigController@deleteLeadConfig');

//sms api receiveing from external
Route::get('insertLeadSource', 'LeadSourceConfigController@insertLeadSource');

//add did
Route::get('findDefaultDid/{default_did}', 'ApiDidController@findDefaultDid');

Route::post('call-lead', "ApiListController@callLead");
Route::post('live-call-activity', "ApiListController@liveCallActivity");

//forgot password
Route::get('send-email-to-forgot-password', 'ApiUserController@sendEmailToForgotPasswor');
Route::get('forgot-password/{token}', 'ForgotPasswordController@index');
Route::post('forgot-password/{token}', 'ForgotPasswordController@changePassword');

Route::post('inbound-call-popup', 'InboundCallPopupController@index');
Route::post('forgot-password', 'ApiUserController@forgotPassword');

Route::get('verify-token/{token}', 'ApiUserController@verifyToken')->name('verify-token');
Route::post('resetPasswordUser', 'ApiUserController@resetPasswordUser');
Route::post('forgot-password-mobile', 'ApiUserController@forgotPasswordMobile');
Route::post('verify-token-mobile/{otp_id}', 'ApiUserController@verifyTokenMobile');
Route::post('resetPasswordUserMobile', 'ApiUserController@resetPasswordUserMobile');
Route::post('resend-otp', 'ApiUserController@resendOtp');



//voice templete

Route::get('voice-templete', 'VoiceTempleteController@getVoiceTemplete');
Route::get('/add-voice-templete', 'VoiceTempleteController@storeVoiceTemplete');
Route::post('/add-voice-templete', 'VoiceTempleteController@storeVoiceTemplete');
Route::post('/editVoiceTemplete/{id}', 'VoiceTempleteController@storeVoiceTemplete');
Route::get('/editVoiceTemplete/{id}', 'VoiceTempleteController@editVoiceTemplete');
Route::get('/deleteVoiceTemplate/{id}/{status}', 'VoiceTempleteController@deleteVoiceTemplate');
Route::get('/voice-template-delete/{id}', 'VoiceTempleteController@delete');

//count list

Route::get('count-list', 'DialerAllCountController@list');
Route::post('count-list', 'DialerAllCountController@list');

#hubspot

Route::get('/campaign/list/contact/{list_id}', 'HubspotController@getContactInAList');

//merchant url


Route::get('/merchant/customer/app/index/{client_id}/{lead_id}/{unique_url}', 'MerchantController@index')->name('merchant.personalinfo');

Route::get('/merchant/customer/app/document/index/{client_id}/{lead_id}/{unique_url}', 'MerchantDocumentController@indexDocument')->name('merchant.document');
Route::post('/merchant/customer/app/document/index/{client_id}/{lead_id}/{unique_url}', 'MerchantDocumentController@indexDocument');


Route::post('/merchant/customer/app/index/{client_id}/{lead_id}/{unique_url}', 'MerchantController@index');




Route::post('/types/post', 'MerchantController@store');


Route::get('/signed-application-crm/{id}/{list_id}/{lead_id}/{parent_id}', 'MailController@getSignedApplicationCRMMerchant');
Route::get('/signed-application-pdf-crm/{id}/{list_id}/{lead_id}/{parent_id}', 'MailController@getSignedApplicationCRMPDFMerchant');
Route::get('generate-pdf', 'PdfgenerateController@generatePDF');

//affiliate link url


Route::get('/affiliate/customer/user/app/index/{client_id}/{extension_number}/{unique_url}', 'AffiliateController@index')->name('affiliate.index');
Route::post('/affiliate/customer/user/app/index/{client_id}/{extension_number}/{unique_url}', 'AffiliateController@personalInfo')->name('affiliate.store');
Route::get(
    '/affiliate/customer/user/app/documents/{client_id}/{extension_number}/{unique_url}',
    'AffiliateController@showDocuments'
)->name('affiliate.documents');


//http://localhost:8090/affiliate/customer/user/app/index/3/38080/H9fT0ug5wsE5CNoySHpXNyh5jRqyZIceAw1



//mailbox
Route::get('/mailbox-login', 'MailboxController@userMailSelect');
Route::get('/mailbox-data', 'MailboxController@index')->name('mailbox.index');
Route::post('/user-send-email', 'MailboxController@sendEmail');
Route::post('/delete-email', 'MailboxController@deleteEmail')->name('delete.email');
Route::post('/star-email', 'MailboxController@starEmail');
Route::post('/unstar-email', 'MailboxController@unstarEmail');
Route::get('/mailbox-data-zoho', 'MailboxController@MailboxDataZoho');
Route::get('/gmail/logout', 'MailboxController@gmailLogout')->name('gmail.logout');

Route::get('auth/redirect', 'OutlookController@redirectToProvider')->name('auth.redirect');
Route::get('auth/callback', 'OutlookController@handleProviderCallback')->name('auth.callback');
Route::get('outlook/mails', 'OutlookController@listMails')->name('outlook.mails');
Route::post('outlook-send-email',  'OutlookController@sendMail')->name('outlook.send.email');
Route::get('/box', 'MailboxController@box');
Route::get('oauth/zoho/callback', 'ZohoController@getZohoAccessToken')->name('oauth.zoho.callback');
Route::get('oauth/zoho/redirect', 'ZohoController@redirectToZoho')->name('oauth.zoho.redirect');
Route::get('zoho/emails', 'ZohoController@getZohoEmails')->name('zoho.emails');
Route::post('zoho-send-email',  'ZohoController@sendZohoEmail')->name('zoho.send.email');





Route::get('auth/google', 'MailboxController@googlepage');
// Route::get('auth/google/callback', 'MailboxController@googlecallback');


// lender api setting

Route::get('lender-api-label-setting', 'LenderApiLabelSettingController@index');
Route::post('lender-api-label-setting', 'LenderApiLabelSettingController@save');



#pdf reader code
Route::get('pdf-reader-setting', 'PdfReaderSettingController@index');
Route::post('pdf-reader-setting', 'PdfReaderSettingController@update');
Route::post('pdf/uploadDid', 'PdfReaderSettingController@upload');

// New merchant route
Route::group(['middleware' => ["redirect.merchant"]], function () {
    Route::get('merchant-login', 'MerchantLoginController@index')->name('merchant.login');
    Route::post('merchant-login', 'MerchantLoginController@apilogin');
});
Route::group(['middleware' => ["auth.merchant"]], function () {
    Route::get('merchant-logout', 'MerchantLoginController@logout')->name('merchant.logout');

    Route::get('/merchant-dashboard/customer/app/index/{client_id}/{lead_id}/{unique_url}', 'MerchantController@index')
        ->name("merchant.index");
    Route::get('/merchant-dashboard/customer/app/document/index/{client_id}/{lead_id}/{unique_url}', 'MerchantDocumentController@indexDocument');
    Route::post('/merchant-dashboard/customer/app/document/index/{client_id}/{lead_id}/{unique_url}', 'MerchantDocumentController@indexDocument');
    Route::post('/merchant-dashboard/customer/app/index/{client_id}/{lead_id}/{unique_url}', 'MerchantController@index');
    Route::post('/merchant-dashboard/types/post', 'MerchantController@store');
    Route::get('/merchant-dashboard/signed-application-crm/{id}/{list_id}/{lead_id}/{parent_id}', 'MailController@getSignedApplicationCRMMerchant');
    Route::get('/merchant-dashboard/signed-application-pdf-crm/{id}/{list_id}/{lead_id}/{parent_id}', 'MailController@getSignedApplicationCRMPDFMerchant');
    Route::get('/merchant-dashboard/generate-pdf', 'PdfgenerateController@generatePDF');
});


Route::get('/payment-test', function () {
    return view('payment-test');
});

Route::post('/test/create-upi-autopay', 'TestController@createUpiAutopay');

Route::post('/test/trigger-auto-recharge', 'TestController@triggerAutoRecharge');

// 1. Register Page + Submit
Route::get('/register', [FrontendRegisterController::class, 'showRegisterForm'])
    ->name('register');

Route::post('/register', [FrontendRegisterController::class, 'store'])
    ->name('frontend.register.store');
// 2. OTP Page + Verification (Email → Mobile → Redirect)
Route::get('/verify-otp', [FrontendRegisterController::class, 'verifyOtp'])->name('frontend.verify_otp');
Route::post('/verifyBothOtps', [FrontendRegisterController::class, 'verifyBothOtps'])->name('frontend.verifyBothOtps');
// 3. Resend Both OTPs (email or mobile)
Route::post('/otp/resend', [FrontendRegisterController::class, 'resendOtp'])->name('frontend.resend_otp');
Route::get('/thank-you', [FrontendRegisterController::class, 'thankYou'])->name('frontend.thank_you');


Route::prefix('blogs')->group(function () {
    Route::get('/', [BlogController::class, 'publicIndex'])->name('blogs.public.index');
    Route::get('/{slug}', [BlogController::class, 'publicShow'])->name('blogs.public.show');
});
Route::prefix('blog/tags')->group(function () {
    Route::get('{slug}', [BlogController::class, 'show_blogbytag'])->name('blogs.tags');
});

Route::prefix('blog/category')->group(function () {
    Route::get('{slug}', [BlogController::class, 'show_blog_industry_wise'])->name('blogs.industry');
});
Route::get('/load-blogs_byindustry', [BlogController::class, 'fetch_blog_industry_wise']);

Route::get('/load-blogs_bytags', [BlogController::class, 'fetchBlogs_bytags']);
Route::get('/load-more-blogs', [BlogController::class, 'fetchBlogs']);

Route::get('/search-blogs', [BlogController::class, 'searchBlogs'])->name('blogs.search');