<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.4/jquery.min.js"></script>
  <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
 
                <style>
                        
                    @media (max-width: 767px) {
  .fixed .multinav {
    position: fixed;
    width: 270px;
    padding-bottom: 0;
    height: calc(100% - 145px); } }
#chat-box-body {
  z-index: 9998;
  position: relative; }
#chat-box-body #chat-circle {
    position: fixed;
    bottom: 50px;
    right: 50px;
    cursor: pointer;
    box-shadow: 0px 3px 16px 0px rgba(0, 0, 0, 0.2), 0 3px 1px -2px rgba(0, 0, 0, 0.2), 0 1px 5px 0 rgba(0, 0, 0, 0.12);
    transform: scale(1); }
  #chat-box-body.show .chat-box {
    display: block; }
  #chat-box-body.show #chat-circle {
    z-index: 0;
    transform: scale(0); }

.btn#my-btn {
  background: white;
  padding-top: 13px;
  padding-bottom: 12px;
  border-radius: 15px;
  padding-right: 40px;
  padding-left: 40px;
  color: #5865C3; }

#chat-overlay {
  background: rgba(255, 255, 255, 0.1);
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  border-radius: 15px;
  display: none; }

.mx-10 {
  margin-left: 20px !important;
 }
.chat-box {
  height: 73%;
  background: #ffffff;
  position: fixed;
  right: 30px;
  bottom: 15px;
  width: 350px;
  max-width: 85vw;
  /*max-height: 100vh;*/
  border-radius: 15px;
  -webkit-box-shadow: 0 0 30px 0 rgba(82, 63, 105, 0.2);
  box-shadow: 0 0 30px 0 rgba(82, 63, 105, 0.2); }

.chat-box-toggle {
  cursor: pointer; }

.chat-box-body {
  position: relative;
  /*height: 370px;*/
  border-bottom: 1px solid #ebedf3;
  border-top: 1px solid #ebedf3;
  overflow: hidden; }

.chat-box-body:after {
  content: "";
  background-image: url("data:image/svg+xml;base64,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");
  opacity: 0.1;
  top: 0;
  left: 0;
  bottom: 0;
  right: 0;
  height: 100%;
  position: absolute;
  z-index: -1; }

#chat-input {
  background: #ffffff;
  width: 100%;
  position: relative;
  height: 47px;
  padding-top: 10px;
  padding-right: 50px;
  padding-bottom: 10px;
  padding-left: 15px;
  border: none;
  resize: none;
  outline: none;
  color: #172b4c;
  border-top: none;
  border-bottom-right-radius: 15px;
  border-bottom-left-radius: 15px;
  overflow: hidden; }



.chat-submit {
  position: absolute;
  bottom: 6px;
  right: 10px;
  background: transparent;
  box-shadow: none;
  border: none;
  border-radius: 15px;
  color: #5A5EB9;
  width: 35px;
  height: 35px; }
  .chat-submit:focus {
    outline: none; }

.chat-logs {
  padding: 15px;
  height: 500px;
  overflow-y: scroll; }
  .chat-logs::-webkit-scrollbar-track {
  -webkit-box-shadow: inset 0 0 6px rgba(0, 0, 0, 0.3);
  background-color: #F5F5F5; }

.chat-logs::-webkit-scrollbar {
  width: 5px;
  background-color: #F5F5F5; }

.chat-logs::-webkit-scrollbar-thumb {
  background-color: #2196f3; }

@media only screen and (max-width: 500px) {
  .chat-logs {
    height: 40vh; } }
.chat-msg.user div > .msg-avatar img {
  border-radius: 15px;
  float: left; }

.chat-msg.self div > .msg-avatar img {
  border-radius: 15px;
  float: right; }
  .chat-msg.self div > .mx-10 {
  float: right; }
.cm-msg-text {
  background: #f3f6f9;
  padding: 10px 15px 10px 15px;
  color: #666;
  max-width: 75%;
  float: left;
  margin-top: 10px;
  position: relative;
  margin-bottom: 20px;
  border-radius: 15px; }

.chat-msg {
  clear: both;
margin-bottom:10px; }
 
.chat-msg.self > .cm-msg-text {
  float: right;
  background: #2196f3;
  color: white;
}
.cm-msg-button > ul > li {
  list-style: none;
  float: left;
  width: 50%; }

.cm-msg-button {
  clear: both;
  margin-bottom: 70px; }
  .chat-msg.user div > .msg-avatar img {
    border-radius: 15px;
    float: left;
}
.avatar-lg {
    width: 48px;
    height: 48px;
    line-height: 48px;
    font-size: 1.286rem;
}
.avatar {
    position: relative;
    display: inline-block;
    width: 36px;
    height: 36px;
    line-height: 36px;
    text-align: center;
    text-transform: uppercase;
    border-radius: 15px;
}
.chat-msg.self div > .msg-avatar img {
    border-radius: 15px;
    float: right;
}

img {
    max-width: 100%;
}
.btn-danger-light {
    background-color: #fedfdf;
    border-color: #fedfdf;
    color: #FF5C5C;
}

.messages {
  margin-top: 0px;
  display: flex;
  flex-direction: column;
  clear: both;
}

.message {
  border-radius: 20px;
  padding: 2px 15px;
  margin-top: 2px;
  margin-right:10px;
  margin-bottom: 2px;
  display: inline-block;
}

.yours {
  align-items: flex-start;
}

.yours .message {
  margin-right:0%;
  background-color: #eee;
  position: relative;
  background: #f3f6f9;
  opacity: 0.8;
  font-size: 12px;
  font-weight: 600;
  color: black;
  padding: 10px 15px 10px 15px;
}

.yours .message.last:before {
  content: "";
  position: absolute;
  z-index: 0;
  bottom: 0;
  left: -7px;
  height: 20px;
  width: 20px;
  background: #e41c1c;
  opacity: -0.2;
  border-bottom-right-radius: 15px;
  padding: 10px 15px 10px 15px;
}




.mine .message {
    float: right;
  background: #2196f3;
  color: white;
  padding: 10px 15px 10px 15px;
  margin-left:30%
 
}

.mine .message.last:before {
  content: "";
  position: absolute;
  z-index: 0;
  bottom: 0;
  right: -8px;
  height: 20px;
  width: 20px;
  /*background: linear-gradient(to bottom, #00D0EA 0%, #0085D1 100%);*/
  background: #5cb85c;
  opacity: -0.2;
  background-attachment: fixed;
  border-bottom-left-radius: 15px;
  
}

.mine .message.last:after {
  content: "";
  position: absolute;
  z-index: 1;
  bottom: 0;
  width: 10px;
  height: 20px;
  background: black;
  border-bottom-left-radius: 10px;
}
.min-w-200 {
  min-width: 200px !important; } 
  .dropdown-menu {
  box-shadow: none;
  border-color: #cccccc; }
  .dropdown-menu.scale-up {
    box-shadow: 0 3px 12px rgba(0, 0, 0, 0.05);
    -webkit-box-shadow: 0 3px 12px rgba(0, 0, 0, 0.05);
    -moz-box-shadow: 0 3px 12px rgba(0, 0, 0, 0.05);
    border-color: rgba(0, 0, 0, 0.13);
    display: inline-block;
    -webkit-transition: all .3s ease;
    transition: all .3s ease;
    -webkit-transform: scale(0);
    transform: scale(0);
    transform-origin: right 0; }
  .dropdown-menu > li > a {
    color: gray; }
    .dropdown-menu > li > a > i {
      margin-right: 10px; }
  .dropdown-menu > .divider {
    background-color: #cccccc; }
    .btn-sm 
                          {position: absolute;
        bottom: 6px;
        right: 10px;
        box-shadow: none;
        border: none;
        border-radius: 15px;
        width: 35px;
        height: 35px;"}
        .waves-effect {
  position: relative;
  cursor: pointer;
  display: inline-block;
  overflow: hidden;
  user-select: none;
  -webkit-tap-highlight-color: transparent;
  vertical-align: middle;
  z-index: 1;
  transition: .3s ease-out; }
  .waves-circle {
  transform: translateZ(0);
  -webkit-mask-image: -webkit-radial-gradient(circle, white 100%, black 100%); }

.waves-input-wrapper {
  border-radius: 0.2em;
  vertical-align: bottom; }
  .waves-input-wrapper .waves-button-input {
    position: relative;
    top: 0;
    left: 0;
    z-index: 1; }

.waves-circle {
  text-align: center;
  width: 2.5em;
  height: 2.5em;
  line-height: 2.5em;
  border-radius: 50%;
  -webkit-mask-image: none; }
        .w-40 {
  width: 40px !important; }
  .h-40 {
  height: 40px !important; }
  .l-h-45 {
  line-height: 3.2142857143rem!important; }
  .fs-22 {
  font-size: 1.5714285714rem!important; }
  .btn-circle {
  width: 45px;
  height: 45px;
  line-height: 45px;
  padding: 0;
  border-radius: 100%; }
  .btn-danger-light {
    background-color: #fedfdf;
    border-color: #fedfdf;
    color: #FF5C5C;}
    .p-15 {
  padding: 15px !important; }
 




 
</style>	

<style>
.chat-box-header {
    padding: 4px 10px !important;  
    min-height: 35px !important;              
}
.chat-box-header .fs-18 {
    font-size: 15px;             
}




.chat-logs {
  border-radius: 20px;
  padding: 15px;
  max-height: 450px;
  overflow-y: auto;
}


.chat-logs table {
  width: 100%;
  border-collapse: collapse;
}

.chat-logs table tbody tr {
  display: flex;
  flex-direction: column;
  background: transparent;
  margin-bottom: 15px;
  position: relative;
}


.mailbox-name {
  display: flex;
  align-items: center;
  font-size: 14px;
  font-weight: 600;
  color: #555;
  margin-bottom: 5px;
}

.mailbox-name::before {
  content: "👤";
  display: inline-flex;
  align-items: center;
  justify-content: center;
  font-size: 16px;
  margin-right: 6px;
}


.mailbox-subject {
  display: inline-block;
  padding: 10px 14px;
  border-radius: 18px;
  max-width: 70%;
  word-wrap: break-word;
  text-decoration: none;
  font-size: 14px;
  margin-bottom: 5px;
}


.chat-logs table tbody tr:nth-child(odd) .mailbox-subject {
  background: #e7e9f3;
  color: #333;
  border-bottom-left-radius: 0;
  align-self: flex-start;
}


.chat-logs table tbody tr:nth-child(even) .mailbox-subject {
  background: #007bff;
  color: #fff;
  border-bottom-right-radius: 0;
  align-self: flex-end;
}


.mailbox-date {
  font-size: 11px;
  color: #888;
  margin-top: 3px;
  align-self: flex-end;
}


.mailbox-subject:hover {
  opacity: 0.9;
  cursor: default;
}


.mailbox-subject, .mailbox-name {
  transition: all 0.2s ease-in-out;
}
.chat-logs table,
.chat-logs table tr,
.chat-logs table td,
.chat-logs table th {
  border: none !important;
}

.chat-logs table.table-hover tbody tr:hover {
  background: transparent !important;
}

.chat-logs table.table-striped tbody tr:nth-of-type(odd) {
  background: transparent !important;
}







.chat-box-body.container_sms_ {
  position: relative;
  height: 400px; 
  overflow-y: auto;
  display: flex;
  flex-direction: column;
  justify-content: flex-end;
  background: #f9f9f9;
  padding: 10px;
}


#contact_form_sms_data {
  position: sticky;
  bottom: 0;
  background: #fff;
  border-top: 1px solid #ddd;
  padding: 8px 10px;
  display: flex;
  align-items: center;
  gap: 8px;
}


#contact_form_sms_data input.new_data_message {
  flex: 1;
  border-radius: 20px;
  padding: 6px 12px;
  border: 1px solid #ccc;
}


#contact_form_sms_data button {
  border-radius: 50%;
  padding: 6px 10px;
}



.dropdown-menu {
  background: #fff;
  border: none;
  border-radius: 16px;
  box-shadow: 0 4px 16px rgba(0, 0, 0, 0.08);
  padding: 8px 0;
  min-width: 200px;
  overflow: hidden;
}


.dropdown-item {
  display: flex;
  align-items: center;
  gap: 10px;
  padding: 10px 18px;
  color: #333;
  font-size: 15px;
  font-weight: 500;
  transition: background 0.2s ease, color 0.2s ease;
  text-decoration: none;
}


.dropdown-item .icon-Color {
  font-size: 16px;
  color: #007bff; 
}


.dropdown-item:hover {
  background: #f5f7fa;
  color: #007bff;
  text-decoration: none;
}


.dropdown-item:active {
  background: #e8f0fe;
  color: #0056d2;
}



.chat-logs {
  border-radius: 10px;
  padding: 0;
  max-height: 450px;
  overflow-y: auto;
  background: #fff;
  font-family: "Inter", sans-serif;
  box-shadow: 0 2px 6px rgba(0, 0, 0, 0.05);
  margin-top: -6px;
}

.sms-list {
  display: flex;
  flex-direction: column;
}

.sms-item {
  display: flex;
  align-items: center;
  justify-content: space-between;
  padding: 12px 16px;
  border-bottom: 1px solid #f0f0f0;
  cursor: pointer;
  transition: background 0.2s ease-in-out;
}

.sms-item:hover {
  background: #f9f9f9;
}

.sms-avatar {
  width: 42px;
  height: 42px;
  border-radius: 50%;
  color: #fff;
  display: flex;
  align-items: center;
  justify-content: center;
  font-weight: 600;
  font-size: 16px;
  margin-right: 12px;
  flex-shrink: 0;
}

.sms-content {
  flex-grow: 1;
  overflow: hidden;
}

.sms-name {
  font-weight: 600;
  font-size: 14px;
  color: #222;
  margin: 0;
  white-space: nowrap;
  overflow: hidden;
  text-overflow: ellipsis;
}

.sms-text {
  font-size: 13px;
  color: #666;
  margin: 3px 0 0 0;
  white-space: nowrap;
  overflow: hidden;
  text-overflow: ellipsis;
}

.sms-time {
  font-size: 12px;
  color: #888;
  white-space: nowrap;
  margin-left: 8px;
  margin-top: -4px;
   
}

.start-chat-wrapper {
  position: absolute;
  bottom: 20px;
  right: 20px;
  z-index: 10;
}

.start-chat-btn {
  background-color: #1976D2;
  color: #fff;
  border: none;
  border-radius: 50px;
  padding: 10px 18px;
  font-size: 14px;
  font-weight: 600;
  font-family: "Inter", sans-serif;
  box-shadow: 0 2px 6px rgba(0, 0, 0, 0.15);
  cursor: pointer;
  display: flex;
  align-items: center;
  gap: 10px;
  transition: background 0.3s ease;
}

.start-chat-btn:hover {
  background-color: #1565C0;
}

.chat-icon {
  width: 18px;
  height: 18px;
  fill: white;
}


@media (min-width: 1600px) {
  .chat-box {
    max-height: 580px !important;
    height: auto !important;      
  }

  .chat-logs {
    max-height: 380px !important;  
  }

  .start-chat-wrapper {
    position: absolute !important;  
    bottom: 35px !important;
    right: 18px !important;
    z-index: 10 !important;
  }
}


@media (max-width: 767px) {
  .chat-box {
    margin-left: auto !important;
    margin-right: auto !important;
    float: none !important;
  }
}

</style>

</head>
<body>
    
<div id="smsAndChat">
    <div class="wrapper show_nev-red1">
        <div class="chat-box"style="margin-right:40px;">
        
     

              <div class="chat-box-header p-15 d-flex justify-content-between align-items-center"  id="mainHeader">

  <div class="btn-group w-100"
       style="display: flex; align-items: center; justify-content: space-between;
              background: #fff;
              padding: 12px 18px; height: 68px; border-radius: 0;">

    <!-- Left: User Icon & Dropdown -->
    <div style="display: flex; align-items: center; gap: 12px; margin-left: -8px;">
      <button class="waves-effect waves-circle btn btn-circle btn-primary rounded-circle"
              type="button" data-toggle="dropdown"
              style="width: 42px; height: 42px; display:flex; align-items:center; justify-content:center;">
        <i class="fas fa-user-plus" style="font-size: 16px;"></i>
      </button>

      <div class="dropdown-menu min-w-200">
        <a class="dropdown-item" href="#" id="msg" onclick="openNew()" style="padding-left: 25px;">
          <span class="icon-Color me-9"></span>
          New Message
        </a>
      </div>

      <!-- Hidden Div (unchanged) -->
      <div id="hiddenDiv" style="display:none;">
        <button class="btn btn-secondary btn-sm" id="back" value="Back">
          <i class="fa fa-backward" aria-hidden="true"></i> Back
        </button>
      </div>
    </div>

    <!-- Center: Title -->
    <div class="flex-grow-1 text-center">
      <div class="text-dark fw-semibold" style="font-size: 17px;">Messages</div>
    </div>

    <!-- Right: Close Button -->
    <a id="chat-box-toggle" href="#"
       style="width: 42px; height: 42px; background-color: #ffe6e6; border-radius: 50%;
              display: flex; align-items: center; justify-content: center;
              text-decoration: none; margin-right: -8px;">
      <i class="fa fa-times" aria-hidden="true" style="color:#ff3b3b; font-size: 16px;"></i>
    </a>
  </div>

</div>
               
             
                                    
       
            <div class="chat-box-body"id="hiddenAfterSms">
                <div class="chat-box-overlay">   
                </div>
    
  <div class="chat-logs" style="height: 390px !important;">
    <div class="sms-list">

      <!-- SMS 1 -->
    <?php $__currentLoopData = $sms_list->data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $sms_data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
  <?php
    $did = preg_replace('/\D/', '', $sms_data->did); // remove non-digits

        if (strlen($did) == 10) {
            // Format as (XXX) XXX-XXXX
            $formattedDid = '(' . substr($did, 0, 3) . ') ' . substr($did, 3, 3) . '-' . substr($did, 6);
        } elseif (strlen($did) == 11 && substr($did, 0, 1) == '1') {
            // Format as +1 XXX-XXX-XXXX
                $formattedDid = '+1 (' . substr($did, 1, 3) . ') ' . substr($did, 4, 3) . '-' . substr($did, 7);
        } else {
            // Keep original if unrecognized
            $formattedDid = $sms_data->did;
        }
        ?>
      <!-- SMS 1 -->
<div class="sms-item" onclick="openDiv1('<?php echo e($sms_data->number); ?>', '<?php echo e($sms_data->did); ?>');">
        <div class="sms-avatar" style="background-color: #7E57C2;">C</div>
        <div class="sms-content">
          <p class="sms-name"><?php echo e($formattedDid); ?></p>
          <p class="sms-text"><?php
            $sms_detail = strlen($sms_data->message) > 50 ? substr($sms_data->message, 0, 50)."..." : $sms_data->message;
            echo $sms_detail; ?></p>
        </div>
        <!-- <div class="sms-time"><?php echo e(($sms_data->date)); ?></div> -->
  <div class="sms-time">
    <?php
        $smsDate = \Carbon\Carbon::parse($sms_data->date);
    ?>

    <?php if($smsDate->isToday()): ?>
        <?php echo e($smsDate->format('g:i A')); ?>

    <?php else: ?>
        <?php echo e($smsDate->format('l')); ?>

    <?php endif; ?>
</div>


      </div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

   


      

    </div>
   </div>

<div class="start-chat-wrapper">
 <button class="start-chat-btn" data-target="#newMessage">
  <svg class="chat-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
    <path fill="white" d="M4 2h16c1.1 0 2 .9 2 2v14c0 1.1-.9 2-2 2H6l-4 4V4c0-1.1.9-2 2-2z"/>
  </svg>
  <span>Start Chat</span>
</button>
</div>


                                 
            </div>




          <!-- SMS Header -->
<div class="chat-box-header p-15 d-flex justify-content-between align-items-center" id="smsHeader"
     style="display: none;">

  <div class="btn-group w-100"
       style="display: flex; align-items: center; justify-content: space-between;
              background: #fff;
              padding: 12px 18px; height: 68px; border-radius: 0;">

    <!-- Left: User Icon & Dropdown -->
    <div style="display: flex; align-items: center; gap: 12px; margin-left: -8px;">
      <button class="waves-effect waves-circle btn btn-circle btn-primary rounded-circle"
              type="button" data-toggle="dropdown"
              style="width: 42px; height: 42px; display:flex; align-items:center; justify-content:center;">
        <i class="fas fa-user-plus" style="font-size: 16px;"></i>
      </button>

      <div class="dropdown-menu min-w-200">
        <a class="dropdown-item" href="#" id="msg" onclick="openNew()" style="padding-left: 25px;">
          <span class="icon-Color me-9"></span>
          New Message
        </a>
      </div>
    </div>

    <!-- Center: Title (Phone Number) -->
    <div class="flex-grow-1 text-center">
      <div class="text-dark fw-semibold" style="font-size: 17px;">+1 (902) 441-2385</div>
    </div>

    <!-- Right: Close Button -->
    <a id="chat-box-toggle-sms" href="#"
       style="width: 42px; height: 42px; background-color: #ffe6e6; border-radius: 50%;
              display: flex; align-items: center; justify-content: center;
              text-decoration: none; margin-right: -8px;">
      <i class="fa fa-times" aria-hidden="true" style="color:#ff3b3b; font-size: 16px;"></i>
    </a>

  </div>
</div>


       
           <div id="contact_form_sms_data" class="chat-input" style="display:none;">

  <!-- Chat display div -->
  <div id="show" style="padding:12px 16px; background:#fff; height:360px; overflow-y:auto; border-radius:8px;"></div>

  <!-- Message Input Section -->
  <div style="display:flex; flex-direction:column; padding:10px; border-top:1px solid #ddd; background:#fff;">

<div id="filePreview" style="
    display: flex; 
    gap: 8px; 
    flex-wrap: wrap; 
    margin-bottom: 8px; 
    width: 100% !important;
    overflow-x: auto;
"></div>


      <div style="display:flex; align-items:center;">
          <!-- Hidden File Input -->
          <input type="file" id="fileInput" style="display:none;" multiple>

          <!-- Attachment Button -->
          <button onclick="document.getElementById('fileInput').click()" style="
              width:36px;
              height:36px;
              background:#f3f6f9;
              border:none;
              border-radius:10px;
              display:flex;
              align-items:center;
              justify-content:center;
              font-size:18px;
              margin-right:8px;
              cursor:pointer;
              box-shadow:0 1px 2px rgba(0,0,0,0.1);
          ">
              📎
          </button>

          <!-- Input Field -->
          <input type="text" placeholder="Send a message..." id="messageInput" style="
              flex:1;
              padding:10px 14px;
              border-radius:18px;
              border:1px solid #ccc;
              outline:none;
              font-size:14px;
          ">

          <!-- Send Button -->
          <button style="
              width:36px;
              height:36px;
              background:#007bff;
              border:none;
              border-radius:50%;
              display:flex;
              align-items:center;
              justify-content:center;
              color:#fff;
              font-size:16px;
              margin-left:8px;
              cursor:pointer;
              box-shadow:0 1px 2px rgba(0,0,0,0.2);
          " onclick="sendMessage()">
              ➤
          </button>
      </div>
  </div>
</div>




          <div class="chat-box-body" id="newMessage" style="display:none; position:absolute; top:0; left:0; right:0; bottom:0; background:#fff; z-index:1000;">

<div class="chat-box-header d-flex align-items-center justify-content-between p-2" 
     id="newMessageHeader" 
     style="border-bottom:1px solid #ccc;">

    <!-- Back Button -->
    <button id="backNewMsg" 
           class="btn btn-secondary" style="height:30px; min-width:40px; font-size:14px; display:flex; align-items:center; justify-content:center; padding:0 8px;">
       <i class="fa fa-backward" style="margin-right:6px;"></i>
    </button>

    <!-- Title -->
    <div style="flex:1; text-align:center; font-weight:600; font-size:16px;">
        New Message
    </div>

    <!-- Cross Button -->
    <a id="chat-box-toggle-new" href="#"
       style="width:32px; height:32px; display:flex; align-items:center; justify-content:center; background-color:#ffe6e6; border-radius:50%; text-decoration:none; box-shadow:0 2px 6px rgba(0,0,0,0.1);">
        <i class="fa fa-times" style="color:#ff3b3b; font-size:16px;"></i>
    </a>

</div>



  <div class="chat-box-overlay"></div>
  <div class="chat-logs">

    <div class="chat-msg user">
      <div>
        <?php if(empty($sms_number_list)): ?>
          <span style="font-size: 16px;color: red;font-weight: bold;">
            You don't have any number assigned for sending text message. Please contact your admin.
          </span>
        <?php endif; ?>

        <?php if(!empty($sms_number_list)): ?>
        <div class="message-form-container p-3 bg-white w-100">

      

          <!-- Form -->
          <div id="contact-form" role="form"> 
            <!-- From -->
            <div class="form-group mb-2">
              <label class="form-label">From</label>                                    
              <select class="form-control" name="did" id="new_from">
                <option value="">From</option>
              
                <?php $__currentLoopData = $sms_number_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $did): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <!-- <?php
        $cli = preg_replace('/\D/', '', $did->cli); // Remove any non-digit characters
        $countryCode = '';
        $number = '';

        // If number length > 10, assume it has a country code
        if (strlen($cli) > 10) {
            $countryCode = '+' . substr($cli, 0, strlen($cli) - 10);
            $number = substr($cli, -10);
        } else {
            $number = $cli;
        }

        // Format as (999) 999-9999
        $formattedNumber = '(' . substr($number, 0, 3) . ') ' . substr($number, 3, 3) . '-' . substr($number, 6);

        // Combine with country code if it exists
        $formattedCLI = $countryCode ? $countryCode . ' ' . $formattedNumber : $formattedNumber;
    ?> -->
<?php
    $cli = preg_replace('/\D/', '', $did->cli); // Remove any non-digit characters
    $countryCode = '';
    $number = '';

    // If number length > 10, assume it has a country code
    if (strlen($cli) > 10) {
        $countryCode = '+' . substr($cli, 0, strlen($cli) - 10);
        $number = substr($cli, -10);
    } else {
        $number = $cli;
    }

    // Format as (999) 999-9999
    $formattedNumber = '(' . substr($number, 0, 3) . ') ' . substr($number, 3, 3) . '-' . substr($number, 6);

    // Combine with country code if it exists
    $formattedCLI = $countryCode ? $countryCode . ' ' . $formattedNumber : $formattedNumber;

    // If role is system admin, append VoIP provider
    $formattedOutput = $formattedCLI;

    if (Session::get('role') === 'system_administrator') {
        $voipProvider = $did->voip_provider ?? 'N/A'; // Replace 'voip_provider' with your actual column name
        $formattedOutput .= ' (' . $voipProvider . ')';
    }
?>



    <option value="<?php echo e($did->cli); ?>"><?php echo e($formattedOutput); ?></option>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

              </select>
            </div>

          

           
<!-- To -->
<div class="form-group mb-3">
  <label class="form-label">To</label>
  <div style="display: flex;">
    <div class="flag-dropdown" id="country_code_sms">
      <div class="selected" id="selected-flag">
        <img src="https://flagcdn.com/w40/sg.png" class="flag-icon" />
        <span>+65</span>
         <span class="dropdown-arrow"></span>

      </div>
      <input type="hidden" id="country_code_sms" value="+1"> <!-- default -->
      <div class="options" id="flag-options">
        <div data-code="+91" data-flag="in"><img src="https://flagcdn.com/w40/in.png" class="flag-icon" /> +91</div>
        <div data-code="+63" data-flag="ph"><img src="https://flagcdn.com/w40/ph.png" class="flag-icon" /> +63</div>
        <div data-code="+60" data-flag="my"><img src="https://flagcdn.com/w40/my.png" class="flag-icon" /> +60</div>
        <div data-code="+66" data-flag="th"><img src="https://flagcdn.com/w40/th.png" class="flag-icon" /> +66</div>
        <div data-code="+1" data-flag="us"><img src="https://flagcdn.com/w40/us.png" class="flag-icon" /> +1</div>
        <div data-code="+65" data-flag="sg"><img src="https://flagcdn.com/w40/sg.png" class="flag-icon" /> +65</div>
      </div>
    </div>

    <input type="text" class="form-control"
      name="number" id="new_to" autocomplete="off" placeholder="Recipient number"
      style="border-top-left-radius: 0; border-bottom-left-radius: 0;">
  </div>
</div>

            <!-- Message -->
            <div class="form-group mb-3">
              <label class="form-label">Message</label>
              <textarea maxlength="160" rows="5" class="form-control" name="message" id="new_message" autocomplete="off"></textarea>
              <small><span id="rchars">160</span> Character(s) Remaining</small>
            </div>                                               
          </div>

          <div class="form-group">
                    <label class="form-label">File</label>
                   <div class="custom-file-wrapper">
                        <input type="file" class="custom-file-input" name="sms_file" id="sms_file"
                            accept="image/*,application/pdf,video/*">
                    </div>
                </div>

          


<style>
.custom-file-wrapper {
  position: relative;
  width: 100%;
  max-width: 400px;
}

.custom-file-input {
  padding: 8px 12px;
  border: 1px solid #ccc;
  border-radius: 6px;
  font-size: 14px;
  cursor: pointer;
  background-color: #fff;
  color: #333;
  width: 100%;
  appearance: none;
}

.custom-file-input::-webkit-file-upload-button {
  background: #007bff;
  color: white;
  border: none;
  padding: 6px 12px;
  border-radius: 4px;
  font-weight: 500;
  cursor: pointer;
}

.custom-file-input::file-selector-button {
  background: #007bff;
  color: white;
  border: none;
  padding: 6px 12px;
  border-radius: 4px;
  font-weight: 500;
  cursor: pointer;
}

.flag-dropdown {
  position: relative;
  width: 95px;
  font-family: sans-serif;
  border: 1px solid #ccc;
  border-radius: 4px 0 0 4px;
  cursor: pointer;
}

.selected {
  display: flex;
  align-items: center;
  padding: 6px;
}

.flag-icon {
  width: 20px;
  height: 20px;
  object-fit: cover;
  margin-right: 6px;
  border-radius: 4px;
}

.options {
  position: absolute;
  top: 100%;
  left: 0;
  width: 100%;
  border: 1px solid #ccc;
  background: white;
  display: none;
  z-index: 10;
  max-height: 200px;
  overflow-y: auto;
}

.options div {
  display: flex;
  align-items: center;
  padding: 6px;
}

.options div:hover {
  background-color: #f0f0f0;
}

.dropdown-arrow {
  margin-left: auto;
  width: 0;
  height: 0;
  border-left: 5px solid transparent;
  border-right: 5px solid transparent;
  border-top: 6px solid #555;
}

#newMessage {
  display: flex;
  flex-direction: column;
  position: absolute;
  top: 0;
  bottom: 0;
  width: 360px;             
  background-color: #fff;
  box-shadow: 0 0 15px rgba(0,0,0,0.25);
  border-radius: 16px;
  overflow: hidden;
  transform: translateX(-10px);
}

#newMessageHeader {
  flex-shrink: 0;
  display: flex;
  align-items: center;
  justify-content: space-between;
  height: 72px;
  padding: 12px 16px;
  border-bottom: 1px solid #ccc;
  border-top-left-radius: 16px;
  border-top-right-radius: 16px;
  background-color: #fff;
  z-index: 10;
}


#newMessage .chat-logs {
  flex: 1;
  overflow-y: hidden !important;
  padding: 8px 20px 12px !important;
  height: calc(100vh - 310px) !important;
  background-color: #fff;
  min-height: 0;
  border-radius: 4px;
  box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08); 
  border: 1px solid #e0e0e0;
}

#newMessage .form-actions {
  flex-shrink: 0;
  background-color: #fff;
  padding: 10px 12px;
  display: flex;
  justify-content: space-between;
  gap: 10px;
  border-top: 1px solid #ccc;
  margin-top: auto;     
}


.form-actions .btn-primary,
.form-actions .btn-secondary {
  flex: 1;
  font-weight: 400 !important;
  font-size: 1.2rem;
  padding: 6px 16px;
  border-radius: 5px;
}

.btn-primary {
  background-color: #1890ff !important;
  border-color: #1890ff !important;
  color: #fff !important;
}
.btn-primary:hover {
  background-color: #147dd6 !important;
  border-color: #147dd6 !important;
}

.btn-secondary {
  background-color: #c0c6d2 !important;
  border-color: #c0c6d2 !important;
  color: #000 !important;
}
.btn-secondary:hover {
  background-color: #a6acb8 !important;
  border-color: #a6acb8 !important;
}


#newMessage .form-group {
  margin-bottom: 8px !important;
}
#newMessage label.form-label {
  margin-bottom: 4px !important;
  font-weight: 500;
}


</style>

        </div>
        <?php endif; ?>
      </div>
    </div>
  </div>

      <!-- Footer Buttons -->
<div class="form-actions">

  
  <!-- Submit Button -->
  <button class="btn btn-primary w-50"
      <?php if($client['sms'] == 1): ?> id="sendNewSmsSubmit" <?php endif; ?>
      type="submit" value="SEND">
       📤 Send Message
  </button>

  <!-- Cancel Button -->
  <button type="button" class="btn btn-secondary w-50"
      onclick="document.getElementById('newMessage').style.display='none'">
      ❌ Cancel
  </button>
</div>

</div>
               <div class="form-group" id="loading" style="display: none;">
                                                <div class="col-sm-12">
                                                        <button style="font-size: 15px;" type="button" id="btnFetch" class="spinner-button btn btn-primary send-button" disabled=""><i class="fa fa-circle-o-notch fa-spin"></i> loading...</button>

                                                </div>
                                                </div>
                </div><!--chat-log -->
              
            </div>
       
        </div>
          
	</div>     
 </div>  
 <script src="<?php echo e(asset('assets/js/pages/chat-popup.js')); ?>"></script>
 
 <script src="https://cdn.jsdelivr.net/npm/imask"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.30.0/moment.min.js"></script>

<script>
      var phoneInput = document.getElementById('new_to');
    var phoneMask = new IMask(phoneInput, {
        mask: '(000) 000-0000'
    }); 
    </script>
<script>
     $(document).ready(function() {
      
        $(".send-button").click(function()
        {
          
        message = $(".new_data_message").val();
        sms_number = $("#sms_number").val();
        sms_did = $("#sms_did").val();
        sms_id = $("#sms_id").val();

        if(message !='')
        {
            $("#btnFetchSms").show();
            var created_date = moment.utc().format('YYYY-MM-DD HH:mm:ss');
            var jqXhr = $.ajax
            ({
                url: 'sendSms',
                type: 'get',
                dataType: "json",
                data: { 'from': sms_did, 'to': sms_number, 'message': message, 'created_date':created_date }
            });
            jqXhr.done(function (data) 
            {
                $('#right_new_msg').hide();
                id=sms_id;
                openDiv(sms_number, sms_did,sms_id);
                  if (data.success == 'true') 
                  {
                      var div_close = "alert-success";
                      $("#btnFetchSms").html('<i class="fa fa-check" aria-hidden="true"></i> Message Sent...');
                      setTimeout(function() {
                      $("#btnFetchSms").hide();  
                      }, 3000);
                      $("#new_to").val('');
                      $("#new_data_message").val('');

                      $("#to_data").text('');
                      $("#new_from_data").text('');
                      $("#message_data").text('');
                  } else 
                  {
                      $("#message_response").html('<div class="alert alert-danger alert-dismissible"><button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button><h4><i class="icon fa fa-check"></i> Alert!</h4>'+data.message+'</div>');
                      var div_close = "alert-danger";
                      $('#left_box').hide();
                  }
            $("." + div_close).delay(4000).slideUp(1000, function () 
            {
                $(this).alert('close');
            });
          });
        }
});
});
     function openNew() {
$("#hiddenAfterSms").hide();
$("#Message").hide();
$("#container_sms_").hide();
$("#contact_form_sms_data").hide();
$("#newMessage").show();
$("#hiddenDiv").show();
     }
 
     function openDiv(number, did,id) {
    $("#loading_sms_"+id).show();

    $("#contact_form_sms_data").show();
    $("#hiddenDiv").show(); 
    $("#unread").hide();
    $(".container_sms_").html("");
     $("#container_sms_").show();
    $("#hiddenAfterSms").hide();
        var did=did;
        var number=number;
    $.ajax({
        url: 'openSmsDetails',
        data: { 'from': did, 'to': number },
        type: 'get',
        success: function (response) {
        reverse_data =  response;
        $("#btnFetchSms").hide();
        $("#loading_sms_"+id).hide();
        $("#" + number + '_' + did).removeAttr("style");
        var ele = document.getElementById('container_sms_');
            ele.innerHTML = ele.innerHTML + '<input type="hidden" value="'+number+'" id="sms_number" name="number" /> ';
            ele.innerHTML = ele.innerHTML + '<input type="hidden" value="'+did+'" id="sms_did" name="did" /> ';
            ele.innerHTML = ele.innerHTML + '<input type="hidden" value="'+id+'" id="sms_id" name="id" /> ';

    for (var i = 0; i < reverse_data.length; i++) {
        var obj = reverse_data[i];
    // Assuming 'number' contains the phone number as a string

var fDid = String(did);

// Use a regular expression to format the phone number as (999) 999-9999
var formattedDid = fDid.replace(/(\d{2})(\d{3})(\d{3})(\d{4})/, '+$1($2) $3-$4');
// Now, 'formattedPhoneNumber' contains the formatted phone number

        if (obj.type == 'incoming') {
            ele.innerHTML = ele.innerHTML + ' <div class="chat-msg user"><div class="d-flex align-items-center"><span class="msg-avatar"><img src="assets/images/avatar-simple.webp" class="avatar avatar-lg"></span><div class="mx-10"><a href="#" class="text-dark hover-primary fw-bold"><i style="color:green;" class="fa fa-arrow-down" aria-hidden="true"></i>' + formattedDid + '</a><p class="text-muted fs-12 mb-0">' + obj.date + '</p></div></div><div class="yours messages"><div class="message">' + obj.message + '</div></div>';
        }
        var phoneNumber = String(number);

// Use a regular expression to format the phone number as (999) 999-9999
var formattedPhoneNumber = phoneNumber.replace(/(\d{2})(\d{3})(\d{3})(\d{4})/, '+$1($2) $3-$4');
        if (obj.type == 'outgoing') {
            ele.innerHTML = ele.innerHTML + '<div class="chat-msg self"><div class="d-flex align-items-center"><span class="msg-avatar"><img src="assets/images/avatar-simple.webp" class="avatar avatar-lg"></span><div class="mx-10"><a href="#" class="text-dark hover-primary fw-bold"><i style="color:green;" class="fa fa-arrow-up" aria-hidden="true"></i>You<br>' + formattedPhoneNumber + '</a><p class="text-muted fs-12 mb-0">' + obj.date + '</p></div></div><div class="mine messages"><div class="message">' + obj.message + '</div></div>';
        }
        // alert(obj.id);
    }

   // ele.innerHTML = ele.innerHTML + '';
}
});
} 
function openNavSMS() {
        $("#divCallCtrl").hide();
        $("#divCallCtrlSMS").show();
        $("#divCallCtrlFAX").hide();

        $("#dash-dailer").removeClass("dash-dailer");
        $("#dash-dailer").addClass("dash-dailer1");
        $("#dialer-key-wrapper").removeClass("dialer-key-wrapper");
        $("#dialer-key-wrapper").addClass("dialer-key-wrapper1");
        $("#show_nev").hide();
        $("#show_nev1").hide();
        $("#show_nev2").hide();
        $("#show_nev3").hide();
        $("#show_nevsms").hide();

        $.ajax({
                    url: 'recentSmsList',
                    type: 'get',
                    dataType: "json",
                    success: function (response_data) {
                        $('#hiddenAfterSms').html("");
                        var res_length = Object.keys(response_data.data).length
                        if (res_length > 0) {
                            $('#hiddenAfterSms').html("");
                            var elem = document.getElementById('hiddenAfterSms');
                            for (var i = 0; i < res_length; i++) {
                                var obj = response_data.data[i];
                                if (obj.status == '0') {
                                    status = 'unread';
                                } else {
                                    status = '';
                                }
                                var localTime = moment.utc(obj.date).local();
                                var created_date = localTime.format('YYYY-MM-DD HH:mm');
                                elem.innerHTML = elem.innerHTML + '<div class="row"><div class="col-lg-12"><div class="media1" <?php if($client['sms'] == 1): ?> onclick="openDiv('+ obj.number +','+ obj.did +','+ obj.id +');" <?php endif; ?> style="color: whitesmoke;font-size: 15px;cursor:pointer;margin: 5px 1px 0px 0px;"><a class="pull-left" style="padding-right: 10px;padding-left: 0px;padding-top:0px;" href="#"><img class="media-object img-circle img-chat" src="https://bootdey.com/img/Content/avatar/avatar6.png" alt=""></a><div class="media-body"><h4 class="media-heading" style="font-size: 15px;margin-top: 0px;">'+ obj.number +'<span class="small pull-right">' + created_date + '</span></h4><p>' + obj.message + '</p></div><p class="label label-danger" id="unread" style="margin-left: 53px;margin-top: 0px;">'+status+'</p></div></div></div><div class="form-group" id="loading_sms_'+obj.id+'" style="display: none;"><div class="col-sm-12"><button style="font-size: 20px;margin-left: 80px;" type="button"  class="spinner-button btn btn-pri" disabled=""><i class="fa fa-circle-o-notch fa-spin"></i> </button></div></div><div class="container_sms_" id="container_sms_'+obj.id+'" style="display: none;"></div><hr style="margin-top: 0px;margin-bottom: 0px;">';
                            }
                        }
                        $('#left_box').hide();
                    }
                });
    }
    $("#back").click(function(){
        $("#show_text").hide();
        $("#hiddenDiv").hide();
        $("#btnFetchSms").html("");
        $("#btnFetchSms").html('<i class="fa fa-circle-o-notch fa-spin"></i> loading...');
        $("#btnFetchSms").show();
        $("#hiddenAfterSms").show();
        $("#container_sms_").hide();
        $("#contact_form_sms_data").hide();
        $("#newMessage").hide();

        })
     
    </script>
<script>
   .done(function (data) {    
                $.ajax({
                    url: 'recentSmsList',
                    type: 'get',
                    dataType: "json",
                    success: function (response_data) {
                        $('#hiddenAfterSms').html("");
                        var res_length = Object.keys(response_data.data).length
                        if (res_length > 0) {
                            $('#hiddenAfterSms').html("");
                            var elem = document.getElementById('hiddenAfterSms');
                            for (var i = 0; i < res_length; i++) {
                                var obj = response_data.data[i];
                                if (obj.status == '0') {
                                    status = 'unread';
                                } else {
                                    status = '';
                                }
                                var localTime = moment.utc(obj.date).local();
                                var created_date = localTime.format('YYYY-MM-DD HH:mm');
                                elem.innerHTML = elem.innerHTML + '<div class="row"><div class="col-lg-12"><div class="media1" <?php if($client['sms'] == 1): ?> onclick="openDiv('+ obj.number +','+ obj.did +','+ obj.id +');" <?php endif; ?> style="color: whitesmoke;font-size: 15px;cursor:pointer;margin: 5px 1px 0px 0px;"><a class="pull-left" style="padding-right: 10px;padding-left: 0px;padding-top:0px;" href="#"><img class="media-object img-circle img-chat" src="https://bootdey.com/img/Content/avatar/avatar6.png" alt=""></a><div class="media-body"><h4 class="media-heading" style="font-size: 15px;margin-top: 0px;">'+ obj.number +'<span class="small pull-right">' + created_date + '</span></h4><p>' + obj.message + '</p></div><p class="label label-danger" id="unread" style="margin-left: 53px;margin-top: 0px;">'+status+'</p></div></div></div>  <div class="form-group" id="loading_sms_'+obj.id+'" style="display: none;"><div class="col-sm-12"><button style="font-size: 20px;margin-left: 80px;" type="button"  class="spinner-button btn btn-pri" disabled=""><i class="fa fa-circle-o-notch fa-spin"></i> </button></div></div><div class="container_sms_" id="container_sms_'+obj.id+'" style="display: none;"></div><hr style="margin-top: 0px;margin-bottom: 0px;">';
                            }
                        }
                        $('#left_box').hide();
                    }
                });
            })
   
       </script>



<script>
document.getElementById("chat-box-toggle").addEventListener("click", function(e) {
    e.preventDefault();

    const smsPanel = document.getElementById("send-sms");
    smsPanel.style.display = "none";
});
</script>


<script>
function openNew() {
  document.getElementById('newMessage').style.display = 'block';
  document.getElementById('mainHeader').style.display = 'none'; 
}

document.getElementById('backNewMsg').addEventListener('click', function() {
  document.getElementById('newMessage').style.display = 'none';
  document.getElementById('mainHeader').style.display = 'flex';
});

document.getElementById('chat-box-toggle-new').addEventListener('click', function() {
  document.getElementById('newMessage').style.display = 'none';
  document.getElementById('mainHeader').style.display = 'flex';
});

</script>

<script>
// function openDiv(num, id, index) {
//   hideAllSections();
//   document.getElementById("smsHeader").style.display = "block"; 
//   document.getElementById("contact_form_sms_data").style.display = "block"; 
// }
function openDiv11(number, did) {
    // Format number cleanly
     hideAllSections();

    let formatted = did.replace(/\D/g, "");
    if (formatted.length === 11 && formatted.startsWith("1")) {
        formatted = "+1 (" + formatted.substring(1, 4) + ") " + formatted.substring(4, 7) + "-" + formatted.substring(7);
    } else if (formatted.length === 10) {
        formatted = "(" + formatted.substring(0, 3) + ") " + formatted.substring(3, 6) + "-" + formatted.substring(6);
    }

    // Show the header and chat container
    document.getElementById("smsHeader").style.display = "block";
    document.getElementById("contact_form_sms_data").style.display = "block";

    // ✅ Update header with the clicked number
    document.querySelector("#smsHeader .text-dark").innerText = formatted;

    // ✅ Clear previous chat
    let ele = document.getElementById("show");
    ele.innerHTML = "";

    // TODO: replace below with AJAX call to get chat by number
    // For now use dummy data:
    // Fetch real chat data via AJAX instead of dummy response
    // $.ajax({
    //     url: 'openSmsDetails',
    //     type: 'get',
    //     data: { from: did, to: number },
    //     success: function (response) {
    //         // Clear old messages
    //         $("#chat_messages").html("");

    //         // ✅ Use dynamic response (must be array of objects)
    //         // Example expected format:
    //         // [
    //         //   { date: "2025-10-13T15:19:00", type: "outgoing", message: "Hello", mms_url: "" },
    //         //   { date: "2025-10-14T06:41:00", type: "incoming", message: "Hi there", mms_url: "" }
    //         // ]
    //         const chatData = response;

    //         // ✅ Loop through each message just like before
    //         chatData.forEach(function (msg) {
    //             let msgHtml = "";

    //             if (msg.type === "outgoing") {
    //                 msgHtml = `
    //                     <div class="message outgoing">
    //                         <div class="msg-text">${msg.message || ''}</div>
    //                         <div class="msg-time">${msg.date ? moment(msg.date).format("MMM D, h:mm A") : ''}</div>
    //                     </div>
    //                 `;
    //             } else {
    //                 msgHtml = `
    //                     <div class="message incoming">
    //                         <div class="msg-text">${msg.message || ''}</div>
    //                         <div class="msg-time">${msg.date ? moment(msg.date).format("MMM D, h:mm A") : ''}</div>
    //                     </div>
    //                 `;
    //             }

    //             // ✅ Append to chat container
    //             $("#chat_messages").append(msgHtml);
    //         });

    //         // Auto-scroll to bottom
    //         $("#chat_messages").scrollTop($("#chat_messages")[0].scrollHeight);
    //     },
    //     error: function (xhr, status, error) {
    //         console.error("Error fetching chat:", error);
    //         $("#chat_messages").html("<p style='color:red;'>Failed to load messages.</p>");
    //     }
    // });

    // Function to show image if present
    function getImageTag(url) {
        if (!url) return "";
        return '<div><img src="' + url + '" style="width:180px; border-radius:12px; margin-top:8px;"></div>';
    }

    // Loop messages
    for (var i = 0; i < response.length; i++) {
        var obj = response[i];
        const dateObj = new Date(obj.date);
        const options = {
            weekday: "long",
            hour: "numeric",
            minute: "numeric",
            hour12: true,
        };
        const formattedDate = dateObj.toLocaleString("en-US", options);

        ele.innerHTML +=
            '<div style="text-align:center; font-size:12px; color:#888; margin:10px 0;">' + formattedDate + "</div>";

        if (obj.type === "incoming") {
            ele.innerHTML +=
                '<div style="display:flex; justify-content:flex-start; margin:6px 0;">' +
                '<div style="max-width:75%; background:#f3f6f9; color:#000; border-radius:18px; border-top-left-radius:0; padding:8px 12px; box-shadow:0 1px 3px rgba(0,0,0,0.1);">' +
                obj.message +
                getImageTag(obj.mms_url) +
                "</div></div>";
        } else {
            ele.innerHTML +=
                '<div style="display:flex; justify-content:flex-end; margin:6px 0;">' +
                '<div style="max-width:75%; background:#007bff; color:#fff; border-radius:18px; border-top-right-radius:0; padding:8px 12px; box-shadow:0 1px 3px rgba(0,0,0,0.1); text-align:left;">' +
                obj.message +
                getImageTag(obj.mms_url) +
                "</div></div>";
        }
    }
}
function openDiv1(number, did) {
      hideAllSections();
let digits = number.replace(/\D/g, "");
let countryCode = "";

if (digits.length > 10) {
    countryCode = "+" + digits.slice(0, digits.length - 10);
    digits = digits.slice(-10);
}

let formatted = `(${digits.substring(0,3)}) ${digits.substring(3,6)}-${digits.substring(6)}`;
if (countryCode) formatted = `${countryCode} ${formatted}`;

console.log(formatted);


    // Show the header and chat container
    document.getElementById("smsHeader").style.display = "block";
    document.getElementById("contact_form_sms_data").style.display = "block";

    // ✅ Update header with the clicked number
    document.querySelector("#smsHeader .text-dark").innerText = formatted;

    // ✅ Clear previous chat
    let ele = document.getElementById("show");
    ele.innerHTML = "";

    $.ajax({
        url: "openSmsDetails",
        data: { from: did, to: number },
        type: "get",
        success: function (response) {
            $("#" + number + "_" + did).removeAttr("style");
            var ele = document.getElementById("show");
            ele.innerHTML = "";

            let lastDate = "";

            for (var i = 0; i < response.length; i++) {
                var obj = response[i];
                console.log("PDF URL:", obj.mms_url);

                if (obj.date !== lastDate) {
                    // Convert timestamp to Date object
                    const dateObj = new Date(obj.date);

                    // Format: Day + Time (Friday 8:19 PM)
                    const options = {
                        weekday: "long",
                        hour: "numeric",
                        minute: "numeric",
                        hour12: true,
                    };
                    const formattedDate = dateObj.toLocaleString(
                        "en-US",
                        options
                    );

                    ele.innerHTML +=
                        '<div style="text-align:center; font-size:12px; color:#888; margin:10px 0;">' +
                        formattedDate +
                        "</div>";
                    lastDate = obj.date;
                }

                // === Incoming Message (Left, Light Gray #f3f6f9) ===
                if (obj.type == "incoming") {
                    var formattedNumber = formatPhoneNumber(obj.number);

                    if (obj.sms_type == 1) {
                        ele.innerHTML +=
                            '<div class="chat-msg user" style="display:flex; justify-content:flex-start; margin:6px 0;">' +
                            '<div style="max-width:75%; background:#f3f6f9; color:#000; border-radius:18px; border-top-left-radius:0; padding:8px 12px; box-shadow:0 1px 3px rgba(0,0,0,0.1);">' +
                            obj.message +
                            getImageTag(obj.mms_url) +
                            "</div></div>";
                    } else {
                        ele.innerHTML +=
                            '<div class="chat-msg user" style="display:flex; justify-content:flex-start; margin:6px 0;">' +
                            '<div style="max-width:75%; background:#f3f6f9; color:#000; border-radius:18px; border-top-left-radius:0; padding:8px 12px; box-shadow:0 1px 3px rgba(0,0,0,0.1);">' +
                            obj.message +
                            "</div></div>";
                    }
                }

                // === Outgoing Message (Right, Blue #007bff) ===
                if (obj.type == "outgoing") {
                    var formattedNumber = formatPhoneNumber(obj.number);

                    if (obj.sms_type == 1) {
                        ele.innerHTML +=
                            '<div class="chat-msg self" style="display:flex; justify-content:flex-end; margin:6px 0;">' +
                            '<div style="max-width:75%; background:#007bff; color:#fff; border-radius:18px; border-top-right-radius:0; padding:8px 12px; box-shadow:0 1px 3px rgba(0,0,0,0.1); text-align:left;">' +
                            obj.message +
                            getImageTag(obj.mms_url) +
                            "</div></div>";
                    } else {
                        ele.innerHTML +=
                            '<div class="chat-msg self" style="display:flex; justify-content:flex-end; margin:6px 0;">' +
                            '<div style="max-width:75%; background:#007bff; color:#fff; border-radius:18px; border-top-right-radius:0; padding:8px 12px; box-shadow:0 1px 3px rgba(0,0,0,0.1); text-align:left;">' +
                            obj.message +
                            "</div></div>";
                    }
                }
            }
        },
    });

    function getImageTag(mms_url) {
        // Check if the URL ends with '.pdf'
        if (mms_url.toLowerCase().endsWith(".pdf")) {
            // If it's a PDF, return the image tag for the PDF icon
            return '<img src="assets/images/pdf.png"style="height:30px;width:30px;">';
        } else {
            // Otherwise, return an empty string
            return '<img src="' + mms_url + '"style="height:80px;width:80px;">';
        }
    }
}

function formatPhoneNumber(phoneNumber) {
    var cleaned = ("" + phoneNumber).replace(/\D/g, ""); // Remove non-digit characters
    var countryCode = cleaned.slice(0, cleaned.length - 10); // Extract front digits (country code)
    var last10Digits = cleaned.slice(-10); // Get the last 10 digits

    // Add '+' before the country code and format the last 10 digits with parentheses and dashes
    return (
        "+" +
        countryCode +
        " (" +
        last10Digits.replace(/(\d{3})(\d{3})(\d{4})/, "$1) $2-$3")
    );
}


function openNew() {
  hideAllSections();
  document.getElementById("newMessage").style.display = "block";
}

function closeNewMessage() {
  hideAllSections();
  document.getElementById("mainHeader").style.display = "block";
  document.getElementById("hiddenAfterSms").style.display = "block";
  fixMainHeaderLayout();
}

document.getElementById("chat-box-toggle-sms").addEventListener("click", function(e) {
  e.preventDefault();
  hideAllSections();
  document.getElementById("mainHeader").style.display = "block";
  document.getElementById("hiddenAfterSms").style.display = "block";
  fixMainHeaderLayout();
});

document.getElementById("backNewMsg").addEventListener("click", closeNewMessage);
document.getElementById("chat-box-toggle-new").addEventListener("click", closeNewMessage);


function hideAllSections() {
  ["smsHeader","mainHeader","newMessage","hiddenAfterSms","contact_form_sms_data"]
    .forEach(id => {
      const el = document.getElementById(id);
      if (el) el.style.display = "none";
    });
}


function fixMainHeaderLayout() {
  const btnGroup = document.querySelector("#mainHeader .btn-group");
  if (btnGroup) {
    btnGroup.style.display = "flex";
    btnGroup.style.alignItems = "center";
    btnGroup.style.justifyContent = "space-between";
    btnGroup.style.padding = "12px 18px";
    btnGroup.style.height = "68px";
    btnGroup.style.background = "#fff";
    btnGroup.style.borderRadius = "0";
  }
}
</script>



<script>
 const dropdown = document.querySelector('.flag-dropdown');
const selected = document.getElementById('selected-flag');
const options = document.getElementById('flag-options');

selected.addEventListener('click', () => {
  dropdown.classList.toggle('open');
  options.style.display = options.style.display === 'block' ? 'none' : 'block';
});

options.querySelectorAll('div').forEach(option => {
  option.addEventListener('click', () => {
    const flag = option.getAttribute('data-flag');
    const code = option.getAttribute('data-code');
    selected.innerHTML = `
      <img src="https://flagcdn.com/w40/${flag}.png" class="flag-icon" />
      <span>${code}</span>
      <span class="dropdown-arrow"></span>
    `;
    options.style.display = 'none';
    dropdown.classList.remove('open');
  });
});
</script>

<script>
document.querySelectorAll('.start-chat-btn').forEach(function(btn) {
  btn.addEventListener('click', function() {
    const targetId = btn.getAttribute('data-target');
    const targetEl = document.querySelector(targetId);
    if (targetEl) {
      targetEl.style.display = 'block';
    }
  });
});
</script>


    
 

<script>
    var response = [
        {
            date: "2025-10-13T15:19:00",
            type: "outgoing",
            message: "hlo test",
            mms_url: "",
        },
        {
            date: "2025-10-14T06:41:00",
            type: "incoming",
            message: "test sms with video",
       
        },
    ];

    function getImageTag(url) {
        if (!url) return "";
        return '<div><img src="' + url + '" style="width:180px; border-radius:12px; margin-top:8px;"></div>';
    }

    var ele = document.getElementById("show");
    ele.innerHTML = "";

    for (var i = 0; i < response.length; i++) {
        var obj = response[i];

    
        const dateObj = new Date(obj.date);
        const options = {
            weekday: "long",
            hour: "numeric",
            minute: "numeric",
            hour12: true,
        };
        const formattedDate = dateObj.toLocaleString("en-US", options);
        ele.innerHTML += '<div style="text-align:center; font-size:12px; color:#888; margin:10px 0;">' + formattedDate + '</div>';

    
        if (obj.type === "incoming") {
            ele.innerHTML +=
                '<div style="display:flex; justify-content:flex-start; margin:6px 0;">' +
                '<div style="max-width:75%; background:#f3f6f9; color:#000; border-radius:18px; border-top-left-radius:0; padding:8px 12px; box-shadow:0 1px 3px rgba(0,0,0,0.1);">' +
                obj.message +
                getImageTag(obj.mms_url) +
                "</div></div>";
        } else {
            ele.innerHTML +=
                '<div style="display:flex; justify-content:flex-end; margin:6px 0;">' +
                '<div style="max-width:75%; background:#007bff; color:#fff; border-radius:18px; border-top-right-radius:0; padding:8px 12px; box-shadow:0 1px 3px rgba(0,0,0,0.1); text-align:left;">' +
                obj.message +
                getImageTag(obj.mms_url) +
                "</div></div>";
        }
    }
</script>


<script>
  const fileInput = document.getElementById('fileInput');
  const filePreview = document.getElementById('filePreview');

 fileInput.addEventListener('change', () => {
    filePreview.innerHTML = ''; // Clear previous previews

    Array.from(fileInput.files).forEach(file => {
       const fileDiv = document.createElement('div');
       fileDiv.style.display = 'flex';
       fileDiv.style.alignItems = 'center';
       fileDiv.style.justifyContent = 'space-between'; 
       fileDiv.style.padding = '6px 10px';
       fileDiv.style.background = '#f1f1f1';
       fileDiv.style.borderRadius = '12px';
       fileDiv.style.fontSize = '14px';
       fileDiv.style.width = '100%'; 
       fileDiv.style.boxSizing = 'border-box'; 


        // Create clickable link for the file
        const fileLink = document.createElement('a');
        fileLink.textContent = file.name;
        fileLink.style.marginRight = '6px';
        fileLink.style.textDecoration = 'none';
        fileLink.style.color = '#333';
        fileLink.href = URL.createObjectURL(file); // Create Blob URL
        fileLink.target = '_blank'; // Open in new tab/window

        // Remove button
        const removeBtn = document.createElement('button');
        removeBtn.textContent = '✖';
        removeBtn.style.border = 'none';
        removeBtn.style.background = 'transparent';
        removeBtn.style.cursor = 'pointer';
        removeBtn.style.fontSize = '12px';
        removeBtn.onclick = () => {
            const dt = new DataTransfer();
            Array.from(fileInput.files)
                .filter(f => f !== file)
                .forEach(f => dt.items.add(f));
            fileInput.files = dt.files;
            fileDiv.remove();
        };

        fileDiv.appendChild(fileLink);
        fileDiv.appendChild(removeBtn);
        filePreview.appendChild(fileDiv);
    });
});


  function sendMessage() {
      const message = document.getElementById('messageInput').value;
      if (!message && fileInput.files.length === 0) return;

      const showDiv = document.getElementById('show');
      const msgDiv = document.createElement('div');
      msgDiv.style.marginBottom = '8px';
      msgDiv.style.padding = '6px 10px';
      msgDiv.style.background = '#dcf8c6';
      msgDiv.style.borderRadius = '12px';
      msgDiv.style.display = 'inline-block';

      msgDiv.textContent = message ? message : '';

      // Append file names if any
      if (fileInput.files.length > 0) {
          const filesList = document.createElement('div');
          filesList.style.marginTop = '4px';
          Array.from(fileInput.files).forEach(f => {
              const fSpan = document.createElement('div');
              fSpan.textContent = f.name;
              fSpan.style.fontSize = '12px';
              fSpan.style.color = '#555';
              filesList.appendChild(fSpan);
          });
          msgDiv.appendChild(filesList);
      }

      showDiv.appendChild(msgDiv);
      showDiv.scrollTop = showDiv.scrollHeight;

      // Clear input and preview
      document.getElementById('messageInput').value = '';
      fileInput.value = '';
      filePreview.innerHTML = '';
  }
</script>



</body>

</html>
<?php /**PATH /var/www/html/leadmine/leadmine_pro/resources/views/dialer/sms.blade.php ENDPATH**/ ?>