<?php $__env->startSection('meta'); ?>
<title>AI Solutions for Financial Services Automation | <?php echo e(config('app.site')); ?></title>

<meta name="description" content="Enhance your financial services automation with AI for client calls, reminders, support, and secure customer engagement that drives results.">

<meta name="keywords" content="AI for financial services, finance automation, AI customer engagement, automated client communication">


<meta property="og:title" content="AI Solutions for Financial Services Automation | <?php echo e(config('app.site')); ?>">
<meta property="og:description" content="Enhance your financial services automation with AI for client calls, reminders, support, and secure customer engagement that drives results.">
<meta property="og:image" content="<?php echo e(asset('web/assets/images/financial.webp')); ?>">
<meta property="og:type" content="website">
<meta property="og:url" content="<?php echo e(url()->current()); ?>">


<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="AI Solutions for Financial Services Automation | <?php echo e(config('app.site')); ?>">
<meta name="twitter:description" content="Enhance your financial services automation with AI for client calls, reminders, support, and secure customer engagement that drives results.">
<meta name="twitter:image" content="<?php echo e(asset('web/assets/images/financial.webp')); ?>">

<?php $__env->stopSection(); ?>







 <?php $__env->startSection('content'); ?>
<style>
.custom-img {
  margin-top: 180px;
}

.as-tag1 {
  font-size: clamp(0.9rem, 2vw, 1.25rem) !important;
  font-weight: 600;
}


 .paragraph-style {
  font-weight: 400;
  font-size: 18px;
}

.custom-heading {
  font-weight: 400;  
}

.max-width-40 {
  max-width: 40%;
}

@media (max-width: 768px) {
  .custom-img {
    margin-top: 50px;
  }
}
.pt-40 {
  padding-top: 40px;
}
.img-auto-warranty {
  max-height: 500px;
  width: 100%;
  object-fit: contain;
}

.img-deal-maxwidth{
  max-width: 35%;
}
.custom-padding-100 {
  padding: 100px 0;
}
.img-pitch-maxwidth {
  max-width: 30%;
}
.visually-hidden {
    position: absolute;
    width: 1px;
    height: 1px;
    padding: 0;
    margin: -1px;
    overflow: hidden;
    clip: rect(0, 0, 0, 0);
    white-space: nowrap;
    border: 0;
}
.as-h2 {
 font-size: clamp(1.5rem, 0.5569rem + 1.444vw, 1.875rem);
 }

.tw-mb-1{
 font-size: clamp(1.125rem, 1.2rem + 0.722vw, 1.5rem);
 }
</style>
 <!-- <section class="section-bg-two pb-50 overflow-hidden pt-40">
     <div class="container max-w-1290-px">
         <div class="row gy-5 align-items-center justify-content-center text-center">
             <div class="col-xl-12">
                 <div>
                     <div class="mx-auto tw-mb-12">
                          <h1 class="visually-hidden">Real Estate & Mortgage Intelligence</h1>
                         <h3 class="splitTextStyleOne text-heading heading-medium">
                             Real Estate & Mortgage Intelligence
                         </h3>
                         <p class="text-neutral-500 tw-mt-2 splitTextStyleOne max-w-770-px tw-text-lg mx-auto">
                             With real-time dashboards and performance scorecards, managers get a clear view of which
                             agents are driving deals—and who needs coaching.
                         </p>
                         <div class="tw-mt-2" data-aos="fade-up" data-aos-anchor-placement="top-bottom"
                             data-aos-duration="900">
                             <a href="<?php echo e(route('register')); ?>"
                                 class="hover--translate-y-1 active--translate-y-scale-9 btn button--stroke tw-gap-5 group active--translate-y-2 tw-rounded-xl text-capitalize tw-px-8 tw-py-505 fw-medium btn-main hover-style-one"
                                 data-block="button">
                                 <span class="button__flair"></span>
                                 <span class="button__label">Get started</span>
                             </a>
                         </div>
                     </div>
                 </div>
             </div>
         </div>
     </div>
 </section> -->
<section class="hero-section">
  <div class="hero-container">
    <div class="hero-left">
       <h1>Secure Customer Communication Across Voice & SMS</h1>
         <p>
      Build customer trust through timely communications. Foster relationships with quick replies and boost agent efficiency using AI.
      </p>
      <div class="hero-badges">
      <span><i class="fa fa-check-circle"></i> No credit card required</span>
        <span><i class="fa fa-check-circle"></i> 14 days of <?php echo e(config('app.site')); ?> AI on us</span>
      </div>
    </div>

    <div class="hero-right">
      <div class="hero-image-wrapper">
        <img src="web/assets/images/financial.webp" alt="Secure AI communication platform for customer voice and SMS support">

    
      </div>
    </div>
  </div>
</section>

<style>
.hero-section {
 background: linear-gradient(180deg, rgba(72, 240, 175, .3882352941) 16.14%, rgba(154, 255, 216, .14) 100%);
  padding: 100px 0;
  font-family: "Inter", sans-serif;
}

.hero-container {
  max-width: 1250px;
  margin: auto;
  display: flex;
  align-items: center;
  justify-content: space-between;
  flex-wrap: wrap;
  gap: 70px;
}

.hero-left {
  flex: 1 1 520px;
}

.hero-left h1 {
  font-size: 40px;
  font-weight: 700;
  color: #1b1f3b;
  line-height: 1.25;
  margin-bottom: 25px;
  max-width: 500px;
}

.hero-left p {
  font-size: 18px;
  line-height: 1.7;
  color: #2b2b2b;
  margin-bottom: 35px;
  max-width: 520px;
  font-family: "Poppins", sans-serif; 
}

.hero-badges {
  display: flex;
  flex-wrap: wrap;
  gap: 20px;
  font-size: 16px;
  color: #1b1f3b;
}

.hero-badges i {
  color: #3b82f6;
  margin-right: 8px;
}

/* Right Side */
.hero-right {
  flex: 1 1 520px;
  display: flex;
  justify-content: center;
  position: relative;
}

.hero-image-wrapper {
  position: relative;
  width: 100%;
  max-width: 540px;
  border-radius: 20px;
  overflow: hidden;
  box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
}

.hero-image-wrapper img {
  width: 100%;
  display: block;
  object-fit: cover;
}

/* Agent Card */
.agent-card {
  position: absolute;
  top: 30px;
  left: 30px;
  background: #fff;
  border-radius: 16px;
  box-shadow: 0 6px 18px rgba(0, 0, 0, 0.1);
  padding: 16px 18px;
  max-width: 280px;
  border: 1px solid #e5e9ff;
}

.agent-card h4 {
  font-size: 15px;
  font-weight: 700;
  color: #1c2250;
  margin-bottom: 10px;
}

.agent-tabs {
  display: flex;
  gap: 6px;
  margin-bottom: 10px;
}

.agent-tabs .tab {
  flex: 1;
  font-size: 13px;
  text-align: center;
  padding: 6px 0;
  border-radius: 6px;
  background: #eef1ff;
  color: #4a4e74;
  font-weight: 600;
}

.agent-tabs .tab.active {
  background: #3b82f6;
  color: #fff;
}

.agent-message {
  font-size: 14px;
  color: #2b2b2b;
  background: #f9faff;
  padding: 12px;
  border-radius: 10px;
  line-height: 1.5;
  margin-bottom: 10px;
}

.agent-feedback {
  display: flex;
  justify-content: space-between;
  font-size: 13px;
  color: #3b82f6;
  font-weight: 600;
}

/* Responsive */
@media (max-width: 992px) {
  .hero-container {
    flex-direction: column;
    text-align: center;
  }

  .hero-left h1 {
    font-size: 36px;
    max-width: 100%;
  }

  .hero-left p {
    margin: 0 auto 30px;
  }

  .hero-badges {
    justify-content: center;
  }

  .hero-image-wrapper {
    margin-top: 40px;
  }

  .agent-card {
    position: static;
    margin: 20px auto 0;
  }
}

.secure-section {
  background: linear-gradient(180deg, #f2f4ff 0%, #ffffff 100%);
  padding: 100px 0;
  font-family: "Poppins", sans-serif; 
}

.secure-container {
  max-width: 1250px;
  margin: auto;
  display: flex;
  align-items: center;
  justify-content: space-between;
  flex-wrap: wrap;
  gap: 70px;
}

.secure-left {
  flex: 1 1 520px;
}

.secure-left h1 {
  font-size: 42px;
  font-weight: 800;
  color: #1b1f3b;
  line-height: 1.25;
  margin-bottom: 25px;
  max-width: 500px;
}

.secure-left p {
  font-size: 18px;
  line-height: 1.8;
  color: #2b2b2b;
  margin: 20px 0 30px 0; 
  max-width: 520px;
}

.secure-badges {
  display: flex;
  flex-wrap: wrap;
  gap: 20px;
  font-size: 16px;
  color: #1b1f3b;
}

.secure-badges i {
  color: #3b82f6;
  margin-right: 8px;
}

/* Right Side */
.secure-right {
  flex: 1 1 520px;
  display: flex;
  justify-content: center;
  position: relative;
}

.secure-image-wrapper {
  position: relative;
  width: 100%;
  max-width: 540px;
  border-radius: 20px;
  overflow: hidden;
  box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
  background: #fff;
}

.secure-image-wrapper img {
  width: 100%;
  display: block;
  object-fit: cover;
}


@media (max-width: 992px) {
  .secure-container {
    flex-direction: column;
    text-align: center;
  }

  .secure-left h1 {
    font-size: 34px;
    max-width: 100%;
  }

  .secure-left p {
    margin: 20px auto 30px; 
  }

  .secure-badges {
    justify-content: center;
  }

  .secure-image-wrapper {
    margin-top: 40px;
  }
}

</style>

<section class="toolkit-section py-5 bg-white">
  <div class="container">
    <h4 class="text-center mb-5 fw-bold">Drive financial success with advanced communication tools</h4>

    <div class="toolkit-grid">
      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-clipboard-check"></i></div>
        <h4>Automated Logging</h4>
        <p>Minimize manual tasks with automatic data logging post-call.</p>
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-layer-group"></i></div>
        <h4>Unified Workspace</h4>
        <p>Manage conversations, calls, and meetings all in one place with Leadmine.pro.</p>
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-route"></i></div>
        <h4>IVR Intelligent Routing</h4>
        <p>Direct customers to the correct department or agent with Leadmine's IVR system.</p>
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-chalkboard-user"></i></div>
        <h4>Rapid Onboarding via iQ Coaching</h4>
        <p>Quick onboarding with AI-powered call coaching, real-time monitoring, and interactive support features.</p>
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-link"></i></div>
        <h4>Seamless CRM Integration</h4>
        <p>Eliminate the hassle of switching between platforms with 100+ CRM integrations.</p>
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-chart-line"></i></div>
        <h4>Team Performance Analytics</h4>
        <p>Track team activity with Leadmine.pro, using advanced analytics for trend identification, call quality assurance, and effective deal closures.</p>
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-face-smile"></i></div>
        <h4>Sentiment Analysis</h4>
        <p>Use AI to understand customer moods from their voice and speech.</p>
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-calendar-check"></i></div>
        <h4>Smart Appointment Scheduling</h4>
        <p>Navigate appointments effortlessly with our advanced scheduler.</p>
      </div>
    </div>
  </div>
</section>

<!-- Font Awesome -->
<script src="https://kit.fontawesome.com/a2d9a67a2b.js" crossorigin="anonymous"></script>

<style>
.toolkit-section {
  background: #f7f7f9; 
  font-family: 'Poppins', sans-serif;
}

.toolkit-grid {
  display: grid;
  grid-template-columns: repeat(auto-fit, minmax(270px, 1fr));
  gap: 25px;
}

.toolkit-item {
  background: #fff;
  border: 1px solid #e5e7eb;
  border-radius: 12px;
  padding: 28px 24px;
  box-shadow: 0 4px 12px rgba(0,0,0,0.04);
  transition: all 0.3s ease;
  cursor: pointer;
}

.toolkit-item:hover {
  border-color: #3b82f6;
  box-shadow: 0 8px 22px rgba(59,130,246,0.1);
  transform: translateY(-4px);
}

.toolkit-item .icon {
  font-size: 30px;
  color: #0a5bff;
  margin-bottom: 18px;
}

.toolkit-item h4 {
  font-size: 18px;
  font-weight: 600;
  margin-bottom: 10px;
  color: #000;
}

.toolkit-item p {
  font-size: 15px;
  color: #444;
  line-height: 1.6;
}

@media (max-width: 768px) {
  .toolkit-item {
    padding: 22px 18px;
  }
}

.about-two {
  background-color: #f5fbf6;
}
</style>


<section class="about-two py-50 position-relative z-1 overflow-hidden">
  <img src="web/assets/images/bg/mash-gradient-bg3.webp" alt="Gradient" class="position-absolute tw-start-0 top-0 z-n1">

  <div class="container">
    <div class="row gy-4 flex-wrap-reverse">
      <div class="col-lg-6">
        <img src="web/assets/images/fine.webp" alt="banking" loading="lazy" class="custom-img img-auto-warranty">
      </div>
      

      <div class="col-lg-6">
        <div class="ps-xl-5">
          <div class="tw-mb-6">
            <h2 class="tw-mb-2 font-caveat text-crm heading-medium as-h2">
              Empower every banking interaction with AI-driven communication
            </h2>
            <p class="splitTextStyleOne text-neutral-500 tw-mt-2 max-w-570-px paragraph-style">
              Revolutionize your financial services with secure, intelligent, and customer-focused communication tools that streamline operations and build trust.
            </p>
          </div>

          <div class="accordion common-accordion" id="accordionBanking">

            <!-- Security built into every communication layer -->
            <div class="accordion-item tw-px-40-px tw-rounded-xl section-bg-one bg-white border-0 tw-mb-6">
              <h3 class="accordion-header">
                <button class="accordion-button tw-py-6 shadow-none px-0 bg-transparent h5" 
                        type="button" data-bs-toggle="collapse" data-bs-target="#securityLayer" 
                        aria-expanded="true" aria-controls="securityLayer">
                  🔒 Security built into every communication layer
                </button>
              </h3>
              <div id="securityLayer" class="accordion-collapse collapse show" data-bs-parent="#accordionBanking">
                <div class="accordion-body ps-0 pt-0 pe-0 tw-pb-6">
                  <p class="text-neutral-500 mb-3">
                    With Leadmine.pro, you can ensure GDPR compliance and robust security. This helps you cultivate trust with clients by safeguarding financial data effectively with strict data access controls.
                  </p>
                  <a href="#" class="btn btn-primary btn-sm">Start Free Trial</a>
                </div>
              </div>
            </div>

            <!-- On-the-go banking solutions -->
            <div class="accordion-item tw-px-40-px tw-rounded-xl section-bg-one bg-white border-0 tw-mb-6">
              <h3 class="accordion-header">
                <button class="accordion-button tw-py-6 shadow-none px-0 bg-transparent h5 collapsed" 
                        type="button" data-bs-toggle="collapse" data-bs-target="#bankingSolutions" 
                        aria-expanded="false" aria-controls="bankingSolutions">
                  📱 On-the-go banking solutions
                </button>
              </h3>
              <div id="bankingSolutions" class="accordion-collapse collapse" data-bs-parent="#accordionBanking">
                <div class="accordion-body ps-0 pt-0 pe-0 tw-pb-6">
                  <p class="text-neutral-500 mb-3">
                    Leverage Leadmine.pro's mobile and web app to drive sales, deliver service, and provide secure assistance across all channels. Empower agents to work remotely for uninterrupted client interactions.
                  </p>
                  <a href="#" class="btn btn-primary btn-sm">Start Free Trial</a>
                </div>
              </div>
            </div>

            <!-- Transform insurance through intelligent solutions -->
            <div class="accordion-item tw-px-40-px tw-rounded-xl section-bg-one bg-white border-0 tw-mb-6">
              <h3 class="accordion-header">
                <button class="accordion-button tw-py-6 shadow-none px-0 bg-transparent h5 collapsed" 
                        type="button" data-bs-toggle="collapse" data-bs-target="#insuranceSolutions" 
                        aria-expanded="false" aria-controls="insuranceSolutions">
                  💼 Transform insurance through intelligent solutions
                </button>
              </h3>
              <div id="insuranceSolutions" class="accordion-collapse collapse" data-bs-parent="#accordionBanking">
                <div class="accordion-body ps-0 pt-0 pe-0 tw-pb-6">
                  <p class="text-neutral-500 mb-3">
                    Empower frontline employees to provide real-time support, prioritize requests through intelligent call routing, and speed up claims processing, all while protecting customers from future risks.
                  </p>
                  <a href="#" class="btn btn-primary btn-sm">Start Free Trial</a>
                </div>
              </div>
            </div>

            <!-- Detailed insights into every client exchange -->
            <div class="accordion-item tw-px-40-px tw-rounded-xl section-bg-one bg-white border-0 tw-mb-6">
              <h3 class="accordion-header">
                <button class="accordion-button tw-py-6 shadow-none px-0 bg-transparent h5 collapsed" 
                        type="button" data-bs-toggle="collapse" data-bs-target="#clientInsights" 
                        aria-expanded="false" aria-controls="clientInsights">
                  📊 Detailed insights into every client exchange
                </button>
              </h3>
              <div id="clientInsights" class="accordion-collapse collapse" data-bs-parent="#accordionBanking">
                <div class="accordion-body ps-0 pt-0 pe-0 tw-pb-6">
                  <p class="text-neutral-500 mb-3">
                    Enable transparent client communications across digital channels. Comprehensive call and message insights empower agents to proactively build trust and deliver top-notch banking and investment solutions.
                  </p>
                  <a href="#" class="btn btn-primary btn-sm">Start Free Trial</a>
                </div>
              </div>
            </div>

          </div> <!-- /accordion -->

        </div>
      </div>

    </div>
  </div>
</section>



<!-- Font Awesome -->
<script src="https://kit.fontawesome.com/a2d9a67a2b.js" crossorigin="anonymous"></script>

<style>
.toolkit-section {
  background: #f7f7f9; 
  font-family: 'Poppins', sans-serif;
}

.toolkit-grid {
  display: grid;
  grid-template-columns: repeat(auto-fit, minmax(270px, 1fr));
  gap: 25px;
}

.toolkit-item {
  background: #fff;
  border: 1px solid #e5e7eb;
  border-radius: 12px;
  padding: 28px 24px;
  box-shadow: 0 4px 12px rgba(0,0,0,0.04);
  transition: all 0.3s ease;
  cursor: pointer;
}

.toolkit-item:hover {
  border-color: #3b82f6;
  box-shadow: 0 8px 22px rgba(59,130,246,0.1);
  transform: translateY(-4px);
}


.toolkit-item .icon {
  font-size: 30px;
  color: #0a5bff;
  margin-bottom: 18px;
}


.toolkit-item h4 {
  font-size: 18px;
  font-weight: 600;
  margin-bottom: 10px;
  color: #000;
}

.toolkit-item p {
  font-size: 15px;
  color: #444;
  line-height: 1.6;
}

@media (max-width: 768px) {
  .toolkit-item {
    padding: 22px 18px;
  }
}
</style>


<!-- ============================ Testimonials section start ============================= -->
<section class="testimonials py-50 bg-neutral-50 position-relative z-1">
    <img src="web/assets/images/shapes/faq-bg.png" alt="faq-bg" loading="lazy" class="position-absolute tw-start-0 top-0 w-100 h-100 z-n1">

    <div class="container">
        <div class="max-w-602-px mx-auto text-center tw-mb-15 mt-minus-10">
            <h3 class="splitTextStyleOne  tw-leading-104 tw-mb-9 d-flex gap-2 custom-features">
                What Our Clients Say About Us
            </h3>
        </div>

        <div class="swiper testimonials-five-slider swiper-initialized swiper-horizontal swiper-backface-hidden">
            <div class="swiper-wrapper">

                <!-- Slide 1 -->
                <div class="swiper-slide h-auto">
                    <div class="common-shadow-ten tw-rounded-2xl tw-p-4 bg-white h-100 d-flex flex-column animation-item  custom-box-style">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <p class="tw-mb-2 text-capitalize heading-responsive-medium as-tag1">Edgard Uzcategui</p>
                                <span class="fw-medium text-small-responsive">Septic LLC</span>
                            </div>
                            <div>
                                <img src="web/assets/images/icons/ratings.svg" alt="Star Rating" class="img-rating-responsive">
                            </div>
                        </div>
                        <p class="custom-goal-heading as-sub">
                            Achieved goals ahead of schedule with Leadmine Pro
                        </p>
                        <p class="text-neutral-600 paragraph-responsive">
                            Thanks to Leadmine Pro’s strategic guidance and ongoing support, we expanded our
                            business faster than planned — and saved significant costs!
                        </p>
                    </div>
                </div>

                <!-- Slide 2 -->
                <div class="swiper-slide h-auto">
                    <div class="common-shadow-ten tw-rounded-2xl tw-p-4 bg-white h-100 d-flex flex-column animation-item custom-box-style">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <p class="tw-mb-2 text-capitalize heading-responsive-medium as-tag1">Priya Desai</p>
                                <span class="fw-medium text-small-responsive">LeadSync Solutions</span>
                            </div>
                            <div>
                                <img src="web/assets/images/icons/ratings.svg" alt="Star Rating" class="img-rating-responsive">
                            </div>
                        </div>
                        <p class="custom-goal-heading as-sub">
                            Call quality went up — complaints went down
                        </p>
                        <p class="text-neutral-600 paragraph-responsive">
                            We finally understand what’s happening on our calls. The insights from
                            Leadmine Pro are game-changing for both coaching and compliance.
                        </p>
                    </div>
                </div>

                <!-- Slide 3 -->
                <div class="swiper-slide h-auto">
                    <div class="common-shadow-ten tw-rounded-2xl tw-p-4 bg-white h-100 d-flex flex-column animation-item custom-box-style">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <p class="tw-mb-2 text-capitalize heading-responsive-medium as-tag1">Marcus Boyd</p>
                                <span class="fw-medium text-small-responsive">BrightTouch Communications</span>
                            </div>
                            <div>
                                <img src="web/assets/images/icons/ratings.svg" alt="Star Rating" class="img-rating-responsive">
                            </div>
                        </div>
                        <p class="custom-goal-heading as-sub">
                            Performance insights that actually make sense
                        </p>
                        <p class="text-neutral-600 paragraph-responsive">
                            Our agents feel more confident, and sales have improved just weeks after adopting this AI
                            call scoring software from Leadmine Pro.
                        </p>
                    </div>
                </div>

                <!-- Slide 4 -->
                <div class="swiper-slide h-auto">
                    <div class="common-shadow-ten tw-rounded-2xl tw-p-4 bg-white h-100 d-flex flex-column animation-item custom-box-style">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <p class="tw-mb-2 text-capitalize heading-responsive-medium as-tag1">Nandita Rao</p>
                                <span class="fw-medium text-small-responsive">NextVoice Contact Center</span>
                            </div>
                            <div>
                                <img src="web/assets/images/icons/ratings.svg" alt="Star Rating" class="img-rating-responsive">
                            </div>
                        </div>
                        <p class="custom-goal-heading as-sub">
                            Took the guesswork out of coaching
                        </p>
                        <p class="text-neutral-600 paragraph-responsive">
                            We don’t just coach better now – we coach faster and with purpose. That’s made a real
                            difference with Leadmine Pro.
                        </p>
                    </div>
                </div>

                <!-- Slide 5 -->
                <div class="swiper-slide h-auto">
                    <div class="common-shadow-ten tw-rounded-2xl tw-p-4 bg-white h-100 d-flex flex-column animation-item custom-box-style">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <p class="tw-mb-2 text-capitalize heading-responsive-medium as-tag1">Jorge Martinez</p>
                                <span class="fw-medium text-small-responsive">SalesNova Team</span>
                            </div>
                            <div>
                                <img src="web/assets/images/icons/ratings.svg" alt="Star Rating" class="img-rating-responsive">
                            </div>
                        </div>
                        <p class="custom-goal-heading as-sub">
                            Best call scoring software for call centers
                        </p>
                        <p class="text-neutral-600 paragraph-responsive">
                            It’s like having a real-time manager for every agent – without micromanaging anyone.
                            Leadmine Pro makes that possible.
                        </p>
                    </div>
                </div>

                <!-- Slide 6 -->
                <div class="swiper-slide h-auto">
                    <div class="common-shadow-ten tw-rounded-2xl tw-p-4 bg-white h-100 d-flex flex-column animation-item custom-box-style">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <p class="tw-mb-2 text-capitalize heading-responsive-medium as-tag1">Emily Chen</p>
                                <span class="fw-medium text-small-responsive">Pulse360 Sales Team</span>
                            </div>
                            <div>
                                <img src="web/assets/images/icons/ratings.svg" alt="Star Rating" class="img-rating-responsive">
                            </div>
                        </div>
                        <p class="custom-goal-heading as-sub">
                            Improved productivity without burning out our reps
                        </p>
                        <p class="text-neutral-600 paragraph-responsive">
                            Leadmine Pro helped us find coaching moments instantly, which meant less
                            pressure on supervisors – and better feedback for reps.
                        </p>
                    </div>
                </div>

                <!-- Slide 7 -->
                <div class="swiper-slide h-auto">
                    <div class="common-shadow-ten tw-rounded-2xl tw-p-4 bg-white h-100 d-flex flex-column animation-item custom-box-style">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <p class="tw-mb-2 text-capitalize heading-responsive-medium as-tag1">Aarav Mehta</p>
                                <span class="fw-medium text-small-responsive">TalkRight Tech</span>
                            </div>
                            <div>
                                <img src="web/assets/images/icons/ratings.svg" alt="Star Rating" class="img-rating-responsive">
                            </div>
                        </div>
                        <p class="custom-goal-heading as-sub">
                            From chaos to clarity
                        </p>
                        <p class="text-neutral-600 paragraph-responsive">
                            Before Leadmine Pro, we were just hoping agents did well. Now, we know who’s
                            doing what – and why, thanks to the AI call scoring software.
                        </p>
                    </div>
                </div>

            </div>

            <!-- Pagination -->
            <div
                class="testimonials-five-slider-pagination pagination-style-four d-flex align-items-center justify-content-center tw-gap-6 tw-mt-15 tw-pb-3 swiper-pagination-clickable swiper-pagination-bullets swiper-pagination-horizontal">
                <span class="swiper-pagination-bullet"></span>
                <span class="swiper-pagination-bullet swiper-pagination-bullet-active"></span>
                <span class="swiper-pagination-bullet"></span>
                <span class="swiper-pagination-bullet"></span>
            </div>
        </div>
    </div>
</section>


    <!-- ================== Driven section Start ====================== -->
        <section class="py-50">
            <div class="container">
                <div class="">
                    <img src="web/assets/images/thumbs/driven-img.webp" alt="driven-img" loading="lazy">
                    <div class="max-w-780-px text-center mx-auto tw-mb-13">
                        <h3 class="splitTextStyleOne text-heading text-capitalize text-capitalize heading-medium">
                            Driven your business today next level by <?php echo e(config('app.site')); ?>

                        </h3>
                        <div class="d-flex align-items-center tw-gap-4 justify-content-center tw-mt-10">
                            <a href="<?php echo e(route('register')); ?>" class="hover--translate-y-1 active--translate-y-scale-9 btn button--stroke tw-gap-5 group active--translate-y-2 tw-rounded-xl text-capitalize tw-px-8 tw-py-505 fw-medium btn btn-main hover-style-one" data-block="button">
                                <span class="button__flair"></span>
                                <span class="button__label">get started </span>
                            </a>

                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- ================== Driven section End ====================== -->



 <?php $__env->stopSection(); ?>
<?php echo $__env->make('website.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/leadmine/leadmine_pro/resources/views/website/financial-services.blade.php ENDPATH**/ ?>