<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
  <title><?php echo e(config('app.site')); ?> Login | Access Your Voice AI Dashboard Login</title>
  <meta name="description" content="Securely login to <?php echo e(config('app.site')); ?> and manage your voice AI automation, call workflows, leads, and customer communication from one dashboard.">
  
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">

    <link rel="stylesheet" href="<?php echo e(asset('assets/css/vendors_css.css')); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<style>.alert {
            margin-bottom:15px;
            position: relative;
            padding-right: 3rem;
            border-radius:8px;
            font-size:14px;
           }
   .alert .btn-close {
    position: absolute;
    top: 50%;
    right: 1rem;
    transform: translateY(-50%);
    padding: 0.5rem;
    }
 .alert-success{background:#d4edda;color:#155724;}
        .alert-danger{background:#f8d7da;color:#721c24;}</style>
    <style>
       /* ===== Background ===== */
body {
    background: #f6f7fb;
    height: 100vh;
    display: flex;
    align-items: center;
    justify-content: center;
}

//* Reset */
* {margin:0; padding:0; box-sizing:border-box; font-family:'Segoe UI', sans-serif;}

/* Page */
.login-page {
    position: relative;
    height: 100vh;
    background: #f6f7fb;
    display: flex;
    align-items: center;
    justify-content: center;
    overflow: hidden;
}


.login-shapes .login-left-shape {
    position: absolute;
    top: 0;
    left: 0;
}
.login-shapes .login-left-shape img {
    max-width: 100%;
    height: auto;
}


.login-shapes .login-right-shape {
    position: absolute;
    bottom: 0;
    right: 0;
}
.login-shapes .login-right-shape img {
     max-width: 100%;
    height: auto;
}



.login-card {
    background: #fff;
    padding: 40px;
    border-radius: 14px;
    width: 100%;
    max-width: 480px;
    box-shadow: 0 8px 25px rgba(0,0,0,0.15);
    text-align: center;
    z-index: 1;
    max-height: none;
    display: flex;
    flex-direction: column;
    justify-content: space-between;
}

.login-card.login-form-card {
    height: auto;
    max-height: none;
    padding: 30px 25px;
    display: flex;
    flex-direction: column;
    justify-content: flex-start;
}



/* Headings */
.login-card h2 {
    color: #1b1b4f;
    margin-top: 0;
    margin-bottom: 5px;
    font-size: 26px;
    font-weight: bold;
}
.login-card p {
    font-size: 14px;
    color: #555;
    margin-top: 0;
    margin-bottom: 15px;
}

.new-user {
    margin-top: 6px;
    margin-bottom: 1px;
}

.forgot-password {
    margin-top: 5px;
    margin-bottom: 10px;
}

.input-box {
    position: relative;
    margin-bottom: 18px;
}


.input-box input {
    width: 100%;
    padding: 12px 40px 12px 38px;
    border-radius: 8px;
    border: 1px solid #ccc;
    font-size: 15px;
    outline: none;
}

.input-box > i:not(.toggle-eye) {
    position: absolute;
    left: 12px;
    top: 50%;
    transform: translateY(-50%);
    font-size: 15px;
    color: #777;
}

.input-box .toggle-eye {
    position: absolute;
    top: 50%;
    right: 12px;
    transform: translateY(-50%);
    cursor: pointer;
    color: #555;
    font-size: 16px;
}


.login-btn {
    width: 100%;
    padding: 12px;
    background: #E41F07 !important;
    color: #fff;
    font-weight: 600;
    font-size: 15px;
    border: none;
    border-radius: 6px;
    cursor: pointer;
    transition: background .3s ease;
}
.login-btn:hover {
    background: #c62828;
}

/* Forgot password */
.forgot-password {
    font-size: 13px;
    color: #0b3a6f;
    text-decoration: none;
}
.forgot-password:hover {
    text-decoration: underline;
}

/* Social login */
.social-login {
    margin-top: 20px;
}
.social-login p {
    font-size: 14px;
    margin-bottom: 10px;
}
.social-icons {
    display: flex;
    justify-content: center;
    gap: 12px;
}
.social-icons a {
    flex: 1;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
    height: 42px;
    border-radius: 6px;
    font-size: 14px;
    font-weight: 500;
    text-decoration: none;
}
.social-icons a.facebook {
    background: #3b5998;
    color: #fff;
}
.social-icons a.google {
    background: #fff;
    color: #000;
    border: 1px solid #ddd;
}
.social-icons a.google img {
    width: 20px;
    height: 20px;
}
.social-icons a.twitter {
    background: #000;
    color: #fff;
}


.alert-danger {
    display: flex;
    align-items: center;
    gap: 8px;
    background-color: #ff5252 !important;
    color: #fff !important;
    border: none;
    border-radius: 8px;
    padding: 6px 10px;
    font-size: 13px;
    box-shadow: 0 2px 6px rgba(0,0,0,0.15);
    width: 100%;
    margin: 2px 0 10px 0;
}


/* .login-form-card {
    min-height: 580px;
    height: auto !important;
} */



.alert-danger .close {
    order: -1;
    font-size: 20px;
    line-height: 1;
    margin-right: 6px;
    color: #000 !important;
    opacity: 0.9;
}

.alert-danger .close:hover {
    opacity: 1;
}


.card .alert-danger {
    position: relative !important;
    top: auto !important;
    margin-top: 0 !important;
    margin-bottom: 12px !important;
}



/* #mobile {
    width: 100%;
    padding: 10px 14px;
    border: 1px solid #ccc;
    border-radius: 6px;
    font-size: 14px;
    outline: none;
    transition: border-color 0.2s ease-in-out, box-shadow 0.2s ease-in-out;
}

#mobile:focus {
    border-color: #007bff;
    box-shadow: 0 0 4px rgba(0, 123, 255, 0.4);
} */

#mobileHint {
    color: #888;
    font-size: 12px;
}


#country_code,
#mobile {
    padding: 10px 14px;
    border: 1px solid #ccc;
    border-radius: 6px;
    font-size: 14px;
    outline: none;
    transition: border-color 0.2s ease-in-out, box-shadow 0.2s ease-in-out;
}

#country_code {
    flex: 0.3;
    background-color: white;
    appearance: none;
    -webkit-appearance: none;
    -moz-appearance: none;
    background-image: url("data:image/svg+xml;utf8,<svg fill='black' height='20' viewBox='0 0 24 24' width='20' xmlns='http://www.w3.org/2000/svg'><path d='M7 10l5 5 5-5z'/></svg>");
    background-repeat: no-repeat;
    background-position: right 10px center;
    background-size: 14px;
}

#mobile {
    flex: 0.7;
}

#country_code:focus,
#mobile:focus {
    border-color: #007bff;
    box-shadow: 0 0 4px rgba(0, 123, 255, 0.4);
}


.login-btn {
    margin-top: 10px;
    margin-bottom: 10px;
}


.mb-3.mt-3 {
    margin-top: 10px !important;
    margin-bottom: 10px !important;
}


.form-check-input {
    transform: scale(1.3);
    margin-right: 5px;
}

.login-form-card {
    height: 650px;
}

.forgot-password-card {
    height: 420px !important;
}





        .login-btn{
            width:100%;
            padding:12px;
            background:linear-gradient(to right,#00294d,#0b3a6f);
            color:white;
            font-weight:bold;
            font-size:14px;
            border:none;
            border-radius:8px;
            margin-top:10px;
            cursor:pointer;
            transition:background .3s ease;
        }
        .login-btn:hover{background:linear-gradient(to right,#001f3a,#082d54);}
        .social-login{margin-top:25px;}
        .social-login p{font-size:14px;color:#666;margin-bottom:12px;}
        /* .social-icons{display:flex;justify-content:center;gap:18px;}
        .social-icons a{
            width:42px;height:42px;border-radius:50%;
            display:flex;align-items:center;justify-content:center;
            font-size:18px;color:#fff;text-decoration:none;
        }
        .facebook{background:#3b5998;}
        .google{background:#dd4b39;}
        .twitter{background:#1da1f2;} */



        .forgot-password{text-align:right;font-size:13px;margin-top:-15px;margin-bottom:15px;}
        .forgot-password a{color:#0b3a6f;text-decoration:none;}
        .forgot-password a:hover{text-decoration:underline;}
        @media(max-width:500px){
            .login-card{padding:30px 20px;border-radius:20px;}
        }
    </style>

<style>

@media (max-width: 991px) {
    body {
        padding: 20px;
    }

    .login-card {
        max-width: 500px;
        padding: 30px 25px;
    }

    .login-card h2 {
        font-size: 22px;
    }

    .login-card p {
        font-size: 13px;
    }

    .input-box input {
        font-size: 14px !important;
        padding: 10px 40px 10px 35px !important;
    }

    .login-btn {
        font-size: 13px;
        padding: 10px;
    }

    .social-icons a {
        width: 38px;
        height: 38px;
        font-size: 16px;
    }
}


@media (max-width: 575px) {
    body {
        background: #f5f6fa;
        padding: 15px;
    }

    .login-card {
        width: 100%;
        max-width: 100%;
        border-radius: 18px;
        padding: 25px 18px;
        box-shadow: 0 12px 25px rgba(0, 0, 0, 0.15);
    }

    .login-card h2 {
        font-size: 20px;
    }

    .login-card p {
        font-size: 12px;
    }

    .input-box {
        max-width: 100% !important;
    }

    .input-box input {
        font-size: 14px !important;
        padding: 10px 40px 10px 32px !important;
    }

    .input-box .toggle-eye {
        right: 12px !important;
    }

    .login-btn {
        font-size: 14px;
        padding: 10px;
    }

    .social-login p {
        font-size: 12px;
    }

    .social-icons {
        gap: 12px;
    }

    .social-icons a {
        width: 34px;
        height: 34px;
        font-size: 14px;
    }
}

@media (max-width: 360px) {
    .login-card {
        padding: 20px 15px;
    }

    .login-card h2 {
        font-size: 18px;
    }

    .input-box input {
        font-size: 13px !important;
        padding: 9px 35px 9px 30px !important;
    }

    .login-btn {
        font-size: 13px;
        padding: 9px;
    }
}




@media (max-width: 1024px) {
    .login-shapes .login-left-shape,
    .login-shapes .login-right-shape {
        display: none;
    }
}

@media (max-width: 768px) {
    .login-shapes .login-left-shape,
    .login-shapes .login-right-shape {
        display: none;
    }

    body, .login-page {
        height: auto;
        display: block;
        padding: 20px 15px;
        overflow: auto;
    }

    .login-card {
        margin: 20px auto;
    }

}

</style>
<style>
#screenOverlay {
    position: fixed;
    inset: 0;
    background: rgba(0, 0, 0, 0.4);
    z-index: 999999;
    display: none;
}

#screenOverlay.active {
    display: block;
}

#screenOverlay .loader-wrapper {
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%) translateY(20px);
}

.loader {
    border: 6px solid #f3f3f3;
    border-top: 6px solid #3498db;
    border-radius: 50%;
    width: 55px;
    height: 55px;
    animation: spin 1s linear infinite;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

</style>


</head>
<body class="hold-transition theme-primary bg-img">

  <div class="alert alert-danger"  style="display: none"></div>
    <div class="alert alert-success"  style="display: none"></div>
<div class="login-card login-form-card">

    <!-- Background Shapes -->
<div class="login-shapes">
    <!-- Left Purple Shape -->
    <div class="login-left-shape">
        <img src="assets/images/auth-bg/shape-01.png" alt="Shape Left">
    </div>
    <!-- Right Orange Shape -->
    <div class="login-right-shape">
        <img src="assets/images/auth-bg/shape-02.png" alt="Shape Right">
    </div>
</div>


<?php if(session('success')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <?php echo e(session('success')); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
<?php endif; ?>

<?php if(session('message') || session('error-title') || $errors->any()): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        
        <?php if(session('error-title')): ?>
            <strong><?php echo e(session('error-title')); ?></strong><br>
        <?php endif; ?>

        
        <?php if(session('message')): ?>
            <?php echo e(session('message')); ?><br>
        <?php endif; ?>

        
        <?php if($errors->any()): ?>
            <ul class="mb-0">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        <?php endif; ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
<?php endif; ?>


    <span id="mobileError"></span>
    <div id="mobileOtpContainer"></div>
    <div id="errorMessage"></div>
    <span id="mobileError1" style="color:red;"></span>
    <span id="email_status" style="color:red;"></span>

  <div class="text-center mb-1" style="margin-top:-25px">
                <img src="<?php echo e(url('/')); ?><?php echo e(config('app.logo')); ?>?v=<?php echo e(time()); ?>" alt="Logo"
                    class="img-fluid" style="max-width: 320px;">
            </div>

<h2>Login</h2>
<p id="sign" style="margin-top: 0;">Sign in to start your session.</p>







    <!-- Normal Login -->
    <div class="showdiv">
        <form action="<?php echo e(url('/')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <div class="input-box">
                <i class="fas fa-user"></i>
                <input id="email" type="text" name="email" placeholder="Email" autocomplete="email">
            </div>


<div class="input-box">
      <i class="fas fa-lock"></i>
    <input id="password" type="password" name="password" placeholder="Password" autocomplete="current-password">
    <i class="fas fa-eye-slash toggle-eye" onclick="togglePassword('password', this)"></i>
</div>



 <div class="captcha-wrapper">
    <?php echo NoCaptcha::display(); ?>

    <?php if($errors->has('g-recaptcha-response')): ?>
        <span class="text-danger"><?php echo e($errors->first('g-recaptcha-response')); ?></span>
    <?php endif; ?>
</div>



            <div class="forgot-password mt-2">


    <div class="d-flex justify-content-between align-items-center mb-3">
        <div class="form-check">
            <input class="form-check-input" type="checkbox" id="remember" checked>
            <label class="form-check-label" for="remember">Remember Me</label>
        </div>
        <a href="#" id="forgot_pass" style="color: #E41F07 !important;">Forgot Password?</a>
    </div>



                <a href="#" id="login" style="display:none;">Login</a>
            </div>

            <button type="submit" class="login-btn mb-12">SIGN IN</button>

<div class="mb-3 mt-3 new-user">
  <p style="margin: 0; display: flex; align-items: center;">
    <strong>New on our platform?</strong>
    <a href="<?php echo e(route('register')); ?>" id="register" style="margin-left: 7px; font-weight: bold;">Register</a>
  </p>
</div>





     <div class="social-login mb-2">
    <p>Or sign in with</p>
    <div class="social-icons">
        <a href="#" class="facebook"><i class="fab fa-facebook-f"></i></a>
        <a href="<?php echo e(url('auth/google/redirect')); ?>" class="google">
            <img src="https://developers.google.com/identity/images/g-logo.png" alt="Google">
        </a>
        <a href="#" class="twitter"><i class="fab fa-x-twitter"></i></a>
    </div>
</div>


   <div class="text-center text-muted large mt-4">
                Copyright &copy; 2025 - <?php echo e(config('app.site')); ?>

            </div>

        </form>
    </div>
</div>

<div class="login-card forgot-password-card" style="display:none;">

  <div class="text-center mb-1" style="margin-top:-35px">
                <img src="<?php echo e(url('/')); ?><?php echo e(config('app.logo')); ?>?v=<?php echo e(time()); ?>" alt="Logo"
                    class="img-fluid" style="max-width: 300px;">
            </div>

    <!-- Background Shapes -->
<div class="login-shapes">
    <!-- Left Purple Shape -->
    <div class="login-left-shape">
        <img src="assets/images/auth-bg/shape-01.png" alt="Shape Left">
    </div>
    <!-- Right Orange Shape -->
    <div class="login-right-shape">
        <img src="assets/images/auth-bg/shape-02.png" alt="Shape Right">
    </div>
</div>

    <!-- <p id="forgot" style="display:none;">Forgot Password</p> -->
    <h2 id="forgot" style="display:none;">Forgot Password</h2>

    <!-- <div class="form-check" id="radio_buttons" style="display:none;">
        <input class="form-check-input" type="radio" value="1" name="myRadios" id="emailOption" checked>
        <label class="form-check-label" for="emailOption">Email</label>
        <input class="form-check-input" type="radio" value="2" name="myRadios" id="mobileOption">
        <label class="form-check-label" for="mobileOption">Mobile</label>
    </div> -->
<!-- Radio Buttons -->

<div class="form-check" id="radio_buttons"
     style="display: none; padding: 10px 40px;" data-toggle="buttons">

    <label class="form-check-label" for="emailOption" style="margin-right: 30px;">
        <input class="form-check-input" type="radio" value="1" name="myRadios" id="emailOption" style="cursor: pointer;" checked>
        Email
    </label>

    <label class="form-check-label" for="mobileOption">
        <input class="form-check-input" type="radio" value="2" name="myRadios" id="mobileOption" style="cursor: pointer;">
        Mobile
    </label>
</div>

  <!-- Forgot Password Email -->
<div class="hidediv" style="display:none; min-height: 400px !important;">
    <form id="resetPasswordForm">
        <?php echo csrf_field(); ?>
        <div class="input-box">
            <i class="fa fa-envelope"></i>
            <input id="form_email" type="email" name="email" placeholder="Email Id" required>
        </div>
        <span id="email_status_msg" style="color:red;"></span>
        <button type="submit" id="submitButton" class="login-btn" style="background: #E41F07 !important;">Submit</button>
    </form>

    <!-- Login link for going back -->
    <div style="margin-top: 12px; text-align: center;">
        <h6>Return to<a id="login" href="<?php echo e(url('/login')); ?>" class="hover-warning text-bold">
            <i class="ion ion-log-in"></i> Login
</a></h6>
    </div>

      <div class="text-center text-muted large mt-3">
           Copyright &copy; 2025 - <?php echo e(config('app.site')); ?>

        </div>

</div>

<!-- Forgot Password Mobile -->
<span id="mobile_status_msg" style="color:red;"></span>
<div class="showdivMob" style="display:none; min-height: 400px !important;">
    <form id="forgotPasswordMobile">
        <?php echo csrf_field(); ?>
        <div style="display:flex; gap:10px; align-items:center;">
            <!-- Flag dropdown -->
            <div class="flag-dropdown" id="country_code" style="flex:0 0 30%; position:relative;">
                <div class="selected" id="selected-flag">
                    <img src="https://flagcdn.com/w40/sg.png" class="flag-icon" />
                    <span>+65</span>
                    <span class="dropdown-arrow"></span>
                </div>
                      <input type="hidden" id="country_code" value="+1"> <!-- default -->

                <div class="options" id="flag-options">
                    <div data-code="+91" data-flag="in"><img src="https://flagcdn.com/w40/in.png" class="flag-icon" /> +91</div>
                    <div data-code="+63" data-flag="ph"><img src="https://flagcdn.com/w40/ph.png" class="flag-icon" /> +63</div>
                    <div data-code="+60" data-flag="my"><img src="https://flagcdn.com/w40/my.png" class="flag-icon" /> +60</div>
                    <div data-code="+66" data-flag="th"><img src="https://flagcdn.com/w40/th.png" class="flag-icon" /> +66</div>
                    <div data-code="+1" data-flag="us"><img src="https://flagcdn.com/w40/us.png" class="flag-icon" /> +1</div>
                    <div data-code="+65" data-flag="sg"><img src="https://flagcdn.com/w40/sg.png" class="flag-icon" /> +65</div>
                </div>
            </div>

            <!-- Mobile input -->
            <input type="text" name="mobile" id="mobile" placeholder="(___) ___-____" required style="flex:1; padding:8px; border-radius:4px; border:1px solid #ccc;">
        </div>

        <small id="mobileHint" style="color:#888;">Hint: Please enter a 10-digit mobile number.</small>

        <button type="submit" id="mobileSubmit" class="login-btn mt-3" style="margin-top:10px; width:100%;">Submit</button>
    </form>

    <!-- Login link for going back -->
    <div style="margin-top: 12px; text-align: center;">
        <h6>Return to <a id="login" href="<?php echo e(url('/login')); ?>" class="hover-warning text-bold">
             Login
        </a></h6>
    </div>

      <div class="text-center text-muted large mt-3">
           Copyright &copy; 2025 - <?php echo e(config('app.site')); ?>

        </div>

</div>



<style>
.flag-dropdown {
    font-family: sans-serif;
    border: 1px solid #ccc;
    border-radius: 4px 0 0 4px;
    cursor: pointer;
    background: #fff;
    max-width: 90px !important;

}

.selected {
    display: flex;
    align-items: center;
    padding: 6px 8px;
}

.flag-icon {
    width: 20px;
    height: 20px;
    object-fit: cover;
    margin-right: 6px;
    border-radius: 4px;

}

.options {
    display: none;
    position: absolute;
    top: 100%;
    left: 0;
    width: 100%;
    border: 1px solid #ccc;
    background: white;
    max-height: 200px;
    overflow-y: auto;
    z-index: 10;
    align-items: center;
}

/* .options div {
    display: flex;
    align-items: center;
    padding: 6px 8px;
} */
.options div {
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 6px 10px;
}

.options div:hover {
    background-color: #f0f0f0;
}

.flag-dropdown {
    flex: 0 0 25%;
    position: relative;
}

.flag-dropdown .selected {
    display: flex;
    align-items: center;
    padding: 6px 4px;
    height: 20px;
    box-sizing: border-box;
}

#mobile {
    height: 40px;
    padding: 6px 8px;
    box-sizing: border-box;
}

.dropdown-arrow {
    margin-left: auto;

}
</style>
<!-- Overlay with loader -->
<div id="screenOverlay">
      <div class="loader-wrapper">
    <div class="loader"></div>
    </div>
</div>

</div>
 <?php echo NoCaptcha::renderJs(); ?>


<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="<?php echo e(asset('assets/js/vendors.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/pages/chat-popup.js')); ?>"></script>
<script src="<?php echo e(asset('assets/icons/feather-icons/feather.min.js')); ?>"></script>
<script src="https://cdn.jsdelivr.net/npm/imask"></script>
<script>$(document).on('click', '#flag-options div', function() {
    const code = $(this).data('code'); // e.g. +91
    const flag = $(this).data('flag'); // e.g. in

    // set hidden input for SMS
    $('#country_code').val(code);

    // optional: visually show selected flag somewhere
    $('#selected-flag-display').html(`<img src="https://flagcdn.com/w40/${flag}.png" class="flag-icon" /> ${code}`);

    console.log("Selected Country Code:", code);
});
</script>
<script>

    $(".hidediv").hide();
    $("#login").hide();
    $(".showdivMob").hide();


    $("#forgot_pass").click(function () {

        $(".showdiv").hide();
        $(".hidediv").show();
        $("#login").show();
        $("#forgot_pass").hide();
        $("#radio_buttons").show();
        $("#forgot").show();
        $("#sign").hide();



    });
    $("#mobilebtn").click(function () {
        $(".showdivMob").show();
        $(".hidediv").hide();
        $("#emailbtn").show();
        $("#mobilebtn").hide();
    });

    $("#emailbtn").click(function () {
        $(".showdivMob").hide();
        $(".hidediv").show();
        $("#emailbtn").hide();
        $("#mobilebtn").show();
    });
    $("#login").click(function () {
        $(".showdiv").show();
        $(".hidediv").hide();
        $("#login").hide();
        $("#forgot_pass").show();
        $("#radio_buttons").hide();
        $(".showdivMob").hide();
        $("#forgot").hide();
        $("#sign").show();

    });
    $(document).ready(function() {
    // Your jQuery code here
    $(".hidediv").hide();
    $(".showdivMob").hide();

    // Handle change event for login radio buttons
    $("input[name='myRadios']").change(function() {
        var selectedValue = $(this).val();
        if (selectedValue === "1") { // Login using email
            $(".hidediv").show();
            $(".showdivMob").hide();
        } else if (selectedValue === "2") { // Login using mobile
            $(".hidediv").hide();
            $(".showdivMob").show();
        }
    });
});


    $(document).ready(function()
    {
        // Function to validate the email format
        function isValidEmail(email)
        {
            // Regular expression to check for a valid email format
            var emailPattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            return emailPattern.test(email);
        }

        // Listen to the "input" event on the email input field
        $("#form_email").on('input', function() {
            var emailInput = $(this);
            var emailValue = emailInput.val().trim();
            var errorMessageElement = $("#email_status_msg");

            // Check if the email input is empty
            if (emailValue === '') {
                errorMessageElement.html('');
                setTimeout(function () {
                    errorMessageElement.empty();
            }, 3000);
                return;
            }

            // Check if the email input matches the email format
            if (!isValidEmail(emailValue)) {
                var errorMessage = '<div style="color:red;">Please enter a valid email address.</div>';
                errorMessageElement.html(errorMessage);
                setTimeout(function () {
                    errorMessageElement.empty();
            }, 3000);

            } else {
                errorMessageElement.html('');
            }
        });

        // Submit the form when the "Submit" button is clicked
        $("#submitButton").click(function(event) {
            event.preventDefault();

            var emailInput = $("#form_email");
            var emailValue = emailInput.val().trim();
            var errorMessageElement = $("#email_status");
            var messageElement = $("#email_status_msg");
   // Clear any previous messages
            messageElement.empty();
            // Check if the email input is empty
            if (emailValue === '') {
                        var errorMessage = '<div style="color:red;">Please enter your email address.</div>';
                        messageElement.html(errorMessage);
                        setTimeout(function () {
                        messageElement.empty();
            }, 3000);
                return;
            }

            // Check if the email input matches the email format
            if (!isValidEmail(emailValue)) {
                            var errorMessage = '<div style="color:red;">Please enter a valid email address.</div>';
                        messageElement.html(errorMessage);
                        setTimeout(function () {
                        messageElement.empty();
            }, 3000);
                return;
            }

            // Disable the submit button to prevent multiple submissions
            $(this).prop('disabled', true);
            $("#screenOverlay").fadeIn(300); // <--- smooth fade-in effect
            // Perform AJAX request to submit the form
            $.ajax({
                url: "<?php echo e(url('forgot-password')); ?>",
                method: "POST",
                data: {
                    _token: $('meta[name="csrf-token"]').attr('content'),
                    email: emailValue
                },
                success: function(response) {
                    console.log(response); // Add this line to log the response data
                      $("#screenOverlay").fadeOut(300);
                    var messageElement = $("#email_status_msg");

                    // Clear any previous messages
                    messageElement.empty();

                    // Check if the response contains the "error" property indicating an invalid mobile number
                    if (response.error === 'InvalidEmail') {
                        var errorMessage = '<div style="color:red;">This Email is not registered. Please try it with a different email.</div>';
                        messageElement.html(errorMessage);
                        setTimeout(function () {
                        messageElement.empty();
            }, 3000);

                    }        // Case 2: Other API/server-level error message (like SendGrid issue)
            else if (response.error) {
                var errorMessage = `<div style="color:red;">${response.error}</div>`;
                messageElement.html(errorMessage);
                setTimeout(function () {
                    messageElement.empty();
                }, 4000);
            }
                    else {
                        // Show success message
                        var successMessage = '<div style="color:green;">Password reset link has been sent to your mail. Please check your inbox for further instructions.</div>';
                        messageElement.html(successMessage);
                        setTimeout(function () {
                        messageElement.empty();
            }, 3000);

                    }

                    // Enable the submit button back
                    $("#submitButton").prop('disabled', false);
                },
                error: function(xhr, status, error) {
                    console.error(error); // Add this line to log any errors
                    var messageElement = $("#email_status");

                    // Clear any previous messages
                    messageElement.empty();

                    // Show error message
                    var errorMessage = '<div style="color:red;">An error occurred. Please try again later.</div>';
                    messageElement.html(errorMessage);
                    setTimeout(function () {
                        messageElement.empty();
            }, 3000);


                    // Enable the submit button back
                    $("#submitButton").prop('disabled', false);
                       $("#screenOverlay").fadeOut(300); // <--- smooth fade-in effect
                }
            });
        });
        $("#form_email").focus(function() {
            var messageElement = $("#email_status");
            messageElement.empty();
        });
    });





    $(document).ready(function () {
    console.log("Document ready function is running");

    // Initialize IMask for the mobile input
    var mobile = document.getElementById('mobile');
    var phoneMask = new IMask(mobile, {
        mask: '(000) 000-0000'
    });

    // Submit the form when the "Submit" button is clicked
    $("#mobileSubmit").click(function (event) {
        event.preventDefault();

        // Get the unformatted value using IMask's method
        var unformattedMobileValue = phoneMask.unmaskedValue;

        var errorMessageElement = $("#mobile_status_msg");
        var country_code = $("#country_code").val();

        // Check if the mobile input is empty
        if (unformattedMobileValue === '') {
            errorMessageElement.html('<div class="alert alert-danger">Please enter your mobile number.</div>');
            setTimeout(function () {
                errorMessageElement.empty();
            }, 3000);

            return;
        }

        // Disable the submit button to prevent multiple submissions
        $(this).prop('disabled', true);

        // Perform AJAX request to submit the form
        $.ajax({
            url: "<?php echo e(url('forgot-password-mobile')); ?>",
            method: "POST",
            data: {
                _token: $('meta[name="csrf-token"]').attr('content'),
                mobile: unformattedMobileValue,
                country_code: country_code
            },
            success: function (response) {
                console.log(response);
                var messageElement = $("#mobile_status_msg");

                // Clear any previous messages
                messageElement.empty();

                // Check if the response contains the "error" property indicating an invalid mobile number
                if (response.error === 'InvalidMobileNumber') {
                    var errorMessage = '<div class="alert alert-danger">This Mobile number is not registered. Please try it with a different number.</div>';
                    messageElement.html(errorMessage);
                    setTimeout(function () {
                        messageElement.empty();
            }, 3000);

                } else if (response.redirect_url) {
        messageElement.html('<div class="alert alert-success">OTP sent. Redirecting...</div>');

        setTimeout(function () {
            window.location.href = response.redirect_url;
        }, 1000);
    } else {
        messageElement.html('<div class="alert alert-danger">Something went wrong. Please try again.</div>');
        $("#mobileSubmit").prop('disabled', false);
    }
                // Enable the submit button back
                $("#mobileSubmit").prop('disabled', false);
            },
            error: function (xhr, status, error) {
                console.error(error);
                var messageElement = $("#mobile_status_msg");

                // Clear any previous messages
                messageElement.empty();

                // Show error message
                var errorMessage = '<div class="alert alert-danger">An error occurred. Please try again later.</div>';
                messageElement.html(errorMessage);

                // Enable the submit button back
                $("#mobileSubmit").prop('disabled', false);
            }
        });
    });

    // Clear error messages on focus
    $("#mobile").focus(function () {
        var messageElement = $("#mobileError");
        messageElement.empty();
    });
});



    // Removing sipML credentials & settings
    localStorage.removeItem("org.doubango.identity.display_name");
    localStorage.removeItem("org.doubango.identity.impi");
    localStorage.removeItem("org.doubango.identity.impu");
    localStorage.removeItem("org.doubango.identity.password");
    localStorage.removeItem("org.doubango.identity.realm");
    localStorage.removeItem("org.doubango.expert.websocket_server_url");
    localStorage.removeItem("org.doubango.expert.disable_video");
    localStorage.removeItem("org.doubango.expert.enable_rtcweb_breaker");
    localStorage.removeItem("org.doubango.expert.sip_outboundproxy_url");
    localStorage.removeItem("org.doubango.expert.ice_servers");
    localStorage.removeItem("org.doubango.expert.bandwidth");
    localStorage.removeItem("org.doubango.expert.video_size");
    localStorage.removeItem("org.doubango.expert.disable_early_ims");
    localStorage.removeItem("org.doubango.expert.disable_debug");
    localStorage.removeItem("org.doubango.expert.enable_media_caching");
    localStorage.removeItem("org.doubango.expert.disable_callbtn_options");

</script>


<script>
function togglePassword(fieldId, icon) {
    const field = document.getElementById(fieldId);
    if (field.type === "password") {
        field.type = "text";
        icon.classList.remove("fa-eye-slash");
        icon.classList.add("fa-eye");
    } else {
        field.type = "password";
        icon.classList.remove("fa-eye");
        icon.classList.add("fa-eye-slash");
    }
}
</script>

<script>
// Show forgot password
document.getElementById('forgot_pass').addEventListener('click', function(e) {
    e.preventDefault();

    // Hide login card
    document.querySelector('.login-form-card').style.display = 'none';

    // Show forgot password card
    const forgotCard = document.querySelector('.forgot-password-card');
    forgotCard.style.display = 'block';

    // Show email form by default
    forgotCard.querySelector('.hidediv').style.display = 'block';
    forgotCard.querySelector('.showdivMob').style.display = 'none';
});
</script>

<script>
document.addEventListener("DOMContentLoaded", function () {
    document.querySelectorAll(".alert-danger .close").forEach(function (btn) {
        btn.addEventListener("click", function () {
            this.parentElement.style.display = "none";
        });
    });
});
</script>

<script>
const dropdown = document.getElementById('country_code');
const selected = document.getElementById('selected-flag');
const options = document.getElementById('flag-options');

selected.addEventListener('click', () => {
    options.style.display = options.style.display === 'block' ? 'none' : 'block';
});

options.querySelectorAll('div').forEach(option => {
    option.addEventListener('click', () => {
        const flag = option.getAttribute('data-flag');
        const code = option.getAttribute('data-code');

        // Update only image + code, arrow already in HTML
        selected.innerHTML = `
            <img src="https://flagcdn.com/w40/${flag}.png" class="flag-icon" />
            <span>${code}</span>
            <span class="dropdown-arrow"></span> <!-- keep only 1 -->
        `;

        options.style.display = 'none';
    });
});

</script>


</body>
</html>
<?php /**PATH /var/www/html/leadmine/leadmine_pro/resources/views/login/login.blade.php ENDPATH**/ ?>