<?php $__env->startSection('meta'); ?>
    <title>Contact Us | <?php echo e(config('app.site')); ?> Support & Sales Assistance</title>
    <meta name="description" content="Get in touch with <?php echo e(config('app.site')); ?> for sales, support, and partnership inquiries. We’re here to help you grow.">

     <meta name="keywords" content="AI call service help, Business enquiry LeadMine, AI solutions support">

    
    <meta property="og:title" content="Contact Us | <?php echo e(config('app.site')); ?> Support & Sales Assistance">
    <meta property="og:description" content="Get in touch with <?php echo e(config('app.site')); ?> for sales, support, and partnership inquiries. We’re here to help you grow.">
    <meta property="og:image" content="<?php echo e(asset('assets/images/thumbs/contact.webp')); ?>">
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?php echo e(url()->current()); ?>">

    
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Contact Us | <?php echo e(config('app.site')); ?> Support & Sales Assistance">
    <meta name="twitter:description" content="Get in touch with <?php echo e(config('app.site')); ?> for sales, support, and partnership inquiries. We’re here to help you grow.">
    <meta name="twitter:image" content="<?php echo e(asset('assets/images/thumbs/contact.webp')); ?>">
<?php $__env->stopSection(); ?>




<?php $__env->startSection('content'); ?>


<style>
/* Background + Container */
.contact-section {
    background: linear-gradient(to right, #dbe9f4, #e3f2f4);
    padding: 60px 20px;
}
.contact-card {
    max-width: 1100px;
    margin: 0 auto;
    background: white;
    border-radius: 20px;
    display: flex;
    overflow: hidden;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
    flex-wrap: wrap;
}

/* Form Section */
.form-side {
    flex: 1 1 60%;
    padding: 50px;
}
.form-side h2 {
    font-size: 26px;
    color: #2c3e50;
    margin-bottom: 30px;
}
.form-group {
    margin-bottom: 25px;
}
.form-group label {
    display: block;
    margin-bottom: 8px;
    font-weight: 600;
    color: #444;
}
.form-group input,
.form-group textarea {
    width: 100%;
    padding: 12px 16px;
    border: 1px solid #ccc;
    border-radius: 8px;
    font-size: 15px;
}
textarea {
    resize: vertical;
}
.captcha-wrapper {
    margin-bottom: 20px;
}
.submit-btn {
    background-color: #2c3e50;
    color: white;
    padding: 14px 28px;
    border: none;
    border-radius: 8px;
    font-weight: 600;
    font-size: 16px;
    cursor: pointer;
    transition: 0.3s;
}
.submit-btn:hover {
    background-color: #1f2a38;
}

/* Contact Info Section */
.info-side {
    flex: 1 1 40%;
    background-color: #2c3e74;
    color: white;
    padding: 50px;
    display: flex;
    flex-direction: column;
    justify-content: center;
}
.info-side h2 {
    font-size: 22px;
    margin-bottom: 15px;
}
.info-side p,
.info-side .info-item {
    font-size: 16px;
    margin-bottom: 18px;
}
.info-item i {
    margin-right: 10px;
    color: #aadfff;
}

.visually-hidden {
    position: absolute;
    width: 1px;
    height: 1px;
    padding: 0;
    margin: -1px;
    overflow: hidden;
    clip: rect(0, 0, 0, 0);
    white-space: nowrap;
    border: 0;
}

/* Responsive */
@media (max-width: 768px) {
    .form-side, .info-side {
        padding: 30px;
        flex: 1 1 100%;
    }
}


.cc-wrapper {
  display: flex;
  gap: 8px;
}

.cc-select {
  max-width: 120px;
}


#country_code {
    width: auto;
    min-width: 200px;
    background-color: #fff !important;
    cursor: pointer;
    padding-right: 28px !important;
    appearance: none;
    -webkit-appearance: none;
    -moz-appearance: none;
    background-image: url("data:image/svg+xml;utf8,<svg fill='black' height='12' viewBox='0 0 20 20' width='12' xmlns='http://www.w3.org/2000/svg'><path d='M5.516 7.548l4.484 4.485 4.484-4.485L16 8.548l-6 6-6-6z'/></svg>");
    background-repeat: no-repeat;
    background-position: right 8px center;
    background-size: 12px;
    height: 42px;
}

.phone-wrapper {
    position: relative;
    display: inline-block;
}


#selected_code {
    position: absolute;
    left: 10px;
    top: 0;
    bottom: 0;                    
    display: flex;
    align-items: center;
    font-weight: 600;
    padding-right: 12px;           
    border-right: 1px solid #ccc;  
}


#phone {
    width: 350px;
    height: 42px;
    padding-left: 75px !important;  
}

#phone::placeholder {
    color: #6c757d;
}

#phone::-webkit-input-placeholder {
    color: #6c757d;
}


</style>



<section class="contact-section">
    <div class="contact-card">
        <!-- Contact Form -->
        <div class="form-side">
            <h1 class="visually-hidden">Send Us a Message</h1>
            <h2>Send Us a Message</h2>

            <!-- Display Success Message -->
            <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?php echo e(session('success')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
            <?php endif; ?>

            <!-- Display Error Message -->
            <?php if(session('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <?php echo e(session('error')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
            <?php endif; ?>

            <!-- Display Validation Errors -->
            <?php if($errors->any()): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <ul class="mb-0">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
            <?php endif; ?>

            <form action="<?php echo e(route('save-contact')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="form-group">
                    <label for="name">Name <span class="text-danger">*</span></label>
                    <input type="text" name="name" id="name" placeholder="John Doe" value="<?php echo e(old('name')); ?>" required>
                </div>

                <div class="form-group">
                    <label for="email">Email <span class="text-danger">*</span></label>
                    <input type="email" name="email" id="email" placeholder="you@example.com" value="<?php echo e(old('email')); ?>" required>
                </div>
                 <!-- <div class="form-group">
                    <label for="phone">Phone <span class="text-danger">*</span></label>

                 <div class="cc-wrapper">
                    <select name="country_code" id="country_code" class="form-control cc-select">
                        <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($c['code']); ?>">
                                <?php echo e($c['flag']); ?> +<?php echo e($c['code']); ?> (<?php echo e($c['name']); ?>)
                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <input type="tel"
                            name="phone"
                            id="phone"
                            class="form-control"
                            placeholder="(123) 456-7890"
                            maxlength="14" value="<?php echo e(old('phone')); ?>"
                            required>
                    </div>
                </div> -->

      <div class="form-group">
    <div class="cc-wrapper">

        <!-- COUNTRY CODE WRAPPER -->
        <div class="cc-box">
            <label for="country_code">Country Code <span class="text-danger">*</span></label>
           <select name="country_code" id="country_code" class="form-control cc-select">
             <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> 
             <option value="<?php echo e($c['code']); ?>" data-code="+<?php echo e($c['code']); ?>"   <?php echo e($c['code'] == 1 ? 'selected' : ''); ?>> <?php echo e($c['name']); ?> <?php echo e($c['flag']); ?> </option>
             <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> </select>
        </div>

        <!-- PHONE WRAPPER -->
      <div class="phone-box">
    <label for="phone">Phone <span class="text-danger">*</span></label>

    <div class="phone-wrapper">
        <span id="selected_code">+<?php echo e($countries[0]['code']); ?></span>

        <input type="tel"
            name="phone"
            id="phone"
            class="form-control"
            placeholder="Phone"
            maxlength="14"
            value="<?php echo e(old('phone')); ?>"
            required>
    </div>
</div>

    </div>
</div>

                <div class="form-group">
                    <label for="message">Message <span class="text-danger">*</span></label>
                    <textarea name="message" id="message" rows="4" placeholder="Your message here..." required><?php echo e(old('message')); ?></textarea>
                </div>

                <div class="captcha-wrapper">
                    <?php echo NoCaptcha::display(); ?>

                </div>

                <button type="submit" class="submit-btn">Submit Message</button>
            </form>
        </div>

        <!-- Contact Info -->
        <div class="info-side">
            <h2>Get in Touch</h2>
            <p>We’d love to hear from you. Contact us via:</p>
            <div class="info-item"><i>📞</i><?php echo e(config('app.phone_number')); ?></div>
            <div class="info-item"><i>📧</i><?php echo e(config('app.email_id')); ?></div>
        </div>
    </div>

</section>

<?php echo NoCaptcha::renderJs(); ?>



<script>
document.addEventListener("DOMContentLoaded", function () {
    const select = document.getElementById("country_code");
    const code = select.options[select.selectedIndex].getAttribute("data-code");
    document.getElementById("selected_code").textContent = code;
});

document.getElementById("country_code").addEventListener("change", function () {
    let code = this.options[this.selectedIndex].getAttribute("data-code");
    document.getElementById("selected_code").textContent = code;
});
</script>


<script>
document.getElementById('phone').addEventListener('input', function (e) {
    let value = e.target.value.replace(/\D/g, ''); 

  
    if (value.length > 10) {
        value = value.slice(0, 10);
    }

   
    let formatted = value;

    if (value.length > 0) {
        formatted = '(' + value.slice(0, 3);
    }
    if (value.length >= 4) {
        formatted += ') ' + value.slice(3, 6);
    }
    if (value.length >= 7) {
        formatted += '-' + value.slice(6, 10);
    }

    e.target.value = formatted;
});
</script>






<?php $__env->startPush('scripts'); ?>
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "ContactPage",
  "mainEntity": {
    "@type": "Organization",
    "name": "<?php echo e(config('app.site')); ?>",
    "url": "<?php echo e(url('/')); ?>",
    "email": "<?php echo e(config('app.email_id')); ?>",
    "telephone": "<?php echo e(config('app.phone_number')); ?>",
    "contactPoint": {
      "@type": "ContactPoint",
      "telephone": "<?php echo e(config('app.phone_number')); ?>",
      "contactType": "Customer Support",
      "email": "<?php echo e(config('app.email_id')); ?>",
      "availableLanguage": "English",
      "areaServed": "IN"
    }
  }
}
</script>
<?php $__env->stopPush(); ?>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('website.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/leadmine/leadmine_pro/resources/views/website/contact-us.blade.php ENDPATH**/ ?>