<?php $__env->startSection('meta'); ?>
<title>AI Order Taker Software | Automated Order Management</title>

<meta name="description" content="Boost sales and efficiency with an AI order taker that handles customer orders, calls, and confirmations automatically without manual effort.">

<meta name="keywords" content="AI order taker, automated order management, AI order processing, voice order automation">


<meta property="og:title" content="AI Order Taker Software | Automated Order Management">
<meta property="og:description" content="Boost sales and efficiency with an AI order taker that handles customer orders, calls, and confirmations automatically without manual effort.">
<meta property="og:image" content="<?php echo e(asset('web/assets/images/order.webp')); ?>">
<meta property="og:type" content="website">
<meta property="og:url" content="<?php echo e(url()->current()); ?>">


<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="AI Order Taker Software | Automated Order Management">
<meta name="twitter:description" content="Boost sales and efficiency with an AI order taker that handles customer orders, calls, and confirmations automatically without manual effort.">
<meta name="twitter:image" content="<?php echo e(asset('web/assets/images/order.webp')); ?>">

<?php $__env->stopSection(); ?>








 <?php $__env->startSection('content'); ?>
<style>
.custom-img {
  margin-top: 180px;
}

 .paragraph-style {
  font-weight: 400;
  font-size: 18px;
}

.custom-heading {
  font-weight: 400;  
}

.max-width-40 {
  max-width: 40%;
}

@media (max-width: 768px) {
  .custom-img {
    margin-top: 50px;
  }
}
.pt-40 {
  padding-top: 40px;
}
.img-auto-warranty {
  max-height: 500px;
  width: 100%;
  object-fit: contain;
}

.img-deal-maxwidth{
  max-width: 35%;
}
.custom-padding-100 {
  padding: 100px 0;
}
.img-pitch-maxwidth {
  max-width: 30%;
}
.visually-hidden {
    position: absolute;
    width: 1px;
    height: 1px;
    padding: 0;
    margin: -1px;
    overflow: hidden;
    clip: rect(0, 0, 0, 0);
    white-space: nowrap;
    border: 0;
}
.as-h2 {
 font-size: clamp(1.5rem, 0.5569rem + 1.444vw, 1.875rem);
 }

.tw-mb-1{
 font-size: clamp(1.125rem, 1.2rem + 0.722vw, 1.5rem);
 }
</style>
 <!-- <section class="section-bg-two pb-50 overflow-hidden pt-40">
     <div class="container max-w-1290-px">
         <div class="row gy-5 align-items-center justify-content-center text-center">
             <div class="col-xl-12">
                 <div>
                     <div class="mx-auto tw-mb-12">
                          <h1 class="visually-hidden">Real Estate & Mortgage Intelligence</h1>
                         <h3 class="splitTextStyleOne text-heading heading-medium">
                             Real Estate & Mortgage Intelligence
                         </h3>
                         <p class="text-neutral-500 tw-mt-2 splitTextStyleOne max-w-770-px tw-text-lg mx-auto">
                             With real-time dashboards and performance scorecards, managers get a clear view of which
                             agents are driving deals—and who needs coaching.
                         </p>
                         <div class="tw-mt-2" data-aos="fade-up" data-aos-anchor-placement="top-bottom"
                             data-aos-duration="900">
                             <a href="<?php echo e(route('register')); ?>"
                                 class="hover--translate-y-1 active--translate-y-scale-9 btn button--stroke tw-gap-5 group active--translate-y-2 tw-rounded-xl text-capitalize tw-px-8 tw-py-505 fw-medium btn-main hover-style-one"
                                 data-block="button">
                                 <span class="button__flair"></span>
                                 <span class="button__label">Get started</span>
                             </a>
                         </div>
                     </div>
                 </div>
             </div>
         </div>
     </div>
 </section> -->
<section class="hero-section">
  <div class="hero-container">
    <div class="hero-left">
      <h1 class="text-white">
         AI Voice ‍Restaurant Order Taker
      </h1>
      <p class="text-white">
       Never Miss an Order. Let AI Handle the Calls. Limited staff? Busy kitchen? Your team should focus on food — let AI take accurate phone orders, upsell every time, and answer with a consistent, friendly voice 24/7.
      <div class="hero-badges">
        <span class="text-white"><i class="fa fa-check-circle"></i> No credit card required</span>
        <span class="text-white"><i class="fa fa-check-circle"></i> 14 days of AI tools on us</span>
      </div>
    </div>

    <div class="hero-right mb-6">
      <div class="hero-image-wrapper">
        <img src="web/assets/images/order.webp" alt="AI voice assistant taking restaurant orders through phone calls">

    
      </div>
    </div>
  </div>
</section>

<style>
.hero-section {
 background: linear-gradient(103deg, #160A33 28.21%, #261258 58.12%, #4B23B0 84.04%, #9677E4 105.97%, #CABBF2 131.89%);
  padding: 100px 0;
  font-family: "Inter", sans-serif;
}

.hero-container {
  max-width: 1250px;
  margin: auto;
  display: flex;
  align-items: center;
  justify-content: space-between;
  flex-wrap: wrap;
  gap: 70px;
}

.hero-left {
  flex: 1 1 520px;
}

.hero-left h1 {
  font-size: 42px;
  font-weight: 800;
  color: #1b1f3b;
  line-height: 1.25;
  margin-bottom: 25px;
  max-width: 500px;
}

.hero-left p {
  font-size: 18px;
  line-height: 1.7;
  color: #2b2b2b;
  margin-bottom: 35px;
  max-width: 520px;
  font-family: "Poppins", sans-serif; 
}

.hero-badges {
  display: flex;
  flex-wrap: wrap;
  gap: 20px;
  font-size: 16px;
  color: #1b1f3b;
}

.hero-badges i {
  color: #3b82f6;
  margin-right: 8px;
}

/* Right Side */
.hero-right {
  flex: 1 1 520px;
  display: flex;
  justify-content: center;
  position: relative;
}

.hero-image-wrapper {
  position: relative;
  width: 100%;
  max-width: 540px;
  border-radius: 20px;
  overflow: hidden;
  box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
}

.hero-image-wrapper img {
  width: 100%;
  display: block;
  object-fit: cover;
}

/* Agent Card */
.agent-card {
  position: absolute;
  top: 30px;
  left: 30px;
  background: #fff;
  border-radius: 16px;
  box-shadow: 0 6px 18px rgba(0, 0, 0, 0.1);
  padding: 16px 18px;
  max-width: 280px;
  border: 1px solid #e5e9ff;
}

.agent-card h4 {
  font-size: 15px;
  font-weight: 700;
  color: #1c2250;
  margin-bottom: 10px;
}

.agent-tabs {
  display: flex;
  gap: 6px;
  margin-bottom: 10px;
}

.agent-tabs .tab {
  flex: 1;
  font-size: 13px;
  text-align: center;
  padding: 6px 0;
  border-radius: 6px;
  background: #eef1ff;
  color: #4a4e74;
  font-weight: 600;
}

.agent-tabs .tab.active {
  background: #3b82f6;
  color: #fff;
}

.agent-message {
  font-size: 14px;
  color: #2b2b2b;
  background: #f9faff;
  padding: 12px;
  border-radius: 10px;
  line-height: 1.5;
  margin-bottom: 10px;
}

.agent-feedback {
  display: flex;
  justify-content: space-between;
  font-size: 13px;
  color: #3b82f6;
  font-weight: 600;
}

/* Responsive */
@media (max-width: 992px) {
  .hero-container {
    flex-direction: column;
    text-align: center;
  }

  .hero-left h1 {
    font-size: 36px;
    max-width: 100%;
  }

  .hero-left p {
    margin: 0 auto 30px;
  }

  .hero-badges {
    justify-content: center;
  }

  .hero-image-wrapper {
    margin-top: 40px;
  }

  .agent-card {
    position: static;
    margin: 20px auto 0;
  }
}

.secure-section {
  background: linear-gradient(180deg, #f2f4ff 0%, #ffffff 100%);
  padding: 100px 0;
  font-family: "Poppins", sans-serif; 
}

.secure-container {
  max-width: 1250px;
  margin: auto;
  display: flex;
  align-items: center;
  justify-content: space-between;
  flex-wrap: wrap;
  gap: 70px;
}

.secure-left {
  flex: 1 1 520px;
}

.secure-left h1 {
  font-size: 42px;
  font-weight: 800;
  color: #1b1f3b;
  line-height: 1.25;
  margin-bottom: 25px;
  max-width: 500px;
}

.secure-left p {
  font-size: 18px;
  line-height: 1.8;
  color: #2b2b2b;
  margin: 20px 0 30px 0; 
  max-width: 520px;
}

.secure-badges {
  display: flex;
  flex-wrap: wrap;
  gap: 20px;
  font-size: 16px;
  color: #1b1f3b;
}

.secure-badges i {
  color: #3b82f6;
  margin-right: 8px;
}

/* Right Side */
.secure-right {
  flex: 1 1 520px;
  display: flex;
  justify-content: center;
  position: relative;
}

.secure-image-wrapper {
  position: relative;
  width: 100%;
  max-width: 540px;
  border-radius: 20px;
  overflow: hidden;
  box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
  background: #fff;
}

.secure-image-wrapper img {
  width: 100%;
  display: block;
  object-fit: cover;
}


@media (max-width: 992px) {
  .secure-container {
    flex-direction: column;
    text-align: center;
  }

  .secure-left h1 {
    font-size: 34px;
    max-width: 100%;
  }

  .secure-left p {
    margin: 20px auto 30px; 
  }

  .secure-badges {
    justify-content: center;
  }

  .secure-image-wrapper {
    margin-top: 40px;
  }
}

</style>



<section class="toolkit-section py-5">
  <div class="container text-center">
    <h4 class="fw-bold mb-3">Human-like AI agents, built right into your business</h4>
    <p class="mb-5">
     Leadmine.pro ensures smooth data flow and collaboration.
    </p>

    <div class="toolkit-grid">
      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-bolt"></i></div>
        <h4>Boost Productivity</h4>
        <p>Free your team from repetitive questions so they can focus on complex tasks that drive business growth.</p>
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-dollar-sign"></i></div>
        <h4>Reduce Costs</h4>
        <p>Eliminate the need for round-the-clock staffing while providing better customer service than ever before.</p>
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-smile"></i></div>
        <h4>Improve Satisfaction</h4>
        <p>Customers love getting instant, accurate answers. Build loyalty with consistent, helpful service.</p>
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-layer-group"></i></div>
        <h4>Scale Effortlessly</h4>
        <p>Handle thousands of calls simultaneously without hiring additional staff or compromising quality.</p>
      </div>
    </div>
  </div>
</section>


<!-- Font Awesome -->
<script src="https://kit.fontawesome.com/a2d9a67a2b.js" crossorigin="anonymous"></script>

<style>
.toolkit-section {
  background: #f7f7f9; 
  font-family: 'Poppins', sans-serif;
}

.toolkit-grid {
  display: grid;
  grid-template-columns: repeat(auto-fit, minmax(270px, 1fr));
  gap: 25px;
}

.toolkit-item {
  background: #fff;
  border: 1px solid #e5e7eb;
  border-radius: 12px;
  padding: 28px 24px;
  box-shadow: 0 4px 12px rgba(0,0,0,0.04);
  transition: all 0.3s ease;
  cursor: pointer;
}

.toolkit-item:hover {
  border-color: #3b82f6;
  box-shadow: 0 8px 22px rgba(59,130,246,0.1);
  transform: translateY(-4px);
}


.toolkit-item .icon {
  font-size: 30px;
  color: #0a5bff;
  margin-bottom: 18px;
}


.toolkit-item h4 {
  font-size: 18px;
  font-weight: 600;
  margin-bottom: 10px;
  color: #000;
}

.toolkit-item p {
  font-size: 15px;
  color: #444;
  line-height: 1.6;
}

@media (max-width: 768px) {
  .toolkit-item {
    padding: 22px 18px;
  }
}
</style>



  <section class="integrations-section">
  <div class="container">
    <h2 class="section-title">Fits seamlessly into your tech stack</h2>

    <div class="integration-logos">
      <div class="logo-box">
        <img src="web/assets/images/hubspot.svg" alt="HubSpot">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/salesforce.svg" alt="Salesforce">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/pipedrive.svg" alt="Pipedrive">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/slack.svg" alt="Slack">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/intercom.svg" alt="Intercom">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/zendesk-icon.svg" alt="Zendesk">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/zoho.svg" alt="Zoho">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/outreach.webp" alt="Outreach">
      </div>
    </div>

    <!-- <div class="btn-wrapper">
      <a href="<?php echo e(route('register')); ?>" class="view-btn">Start free trial</a>
    </div> -->
  </div>
</section>


<style>
.integrations-section {
  text-align: center;
  padding: 80px 20px;
  background-color: #fff;
}

.integrations-section .section-title {
  font-size: 32px;
  font-weight: 700;
  color: #0b0c2a;
  margin-bottom: 50px;
}

.integration-logos {
  display: flex;
  flex-wrap: wrap;
  justify-content: center;
  gap: 25px;
  margin-bottom: 50px;
}

.logo-box {
  width: 140px;
  height: 140px;
  background: #fff;
  border-radius: 20px;
  box-shadow: 0 0 0 1px #e5e7eb;
  display: flex;
  align-items: center;
  justify-content: center;
  transition: all 0.3s ease;
}

.logo-box img {
  width: 60px;
  height: auto;
  transition: transform 0.3s ease;
}

.logo-box:hover {
  transform: translateY(-8px);
  box-shadow: 0 8px 25px rgba(0, 0, 0, 0.08);
}

.logo-box:hover img {
  transform: scale(1.1);
}

.view-btn {
  display: inline-block;
  background-color: #0052ff;
  color: #fff;
  font-weight: 600;
  padding: 14px 28px;
  border-radius: 8px;
  text-decoration: none;
  transition: background 0.3s ease;
}

.view-btn:hover {
  background-color: #003ed6;
}

.btn-wrapper {
  margin-top: 20px;
}



#ai-coach .splitTextStyleOne.custom-centered-title,
#ai-coach .custom-header.small-heading {
    font-weight: 700; 
}


#ai-coach .splitTextStyleOne.custom-centered-title {
    font-size: 1.5rem; 
    line-height: 1.2;
}

#ai-coach .custom-header.small-heading {
    font-size: 1.06rem;  
    line-height: 1.4;
}

</style>


 


<section class="cancellation-section">
  <div class="content">
    <div class="text-side">
      <h2>Why Outsourcing Order-Taking Fails</h2>
      <p class="sub-text">
        Many restaurant owners try to outsource phone ordering to offshore call centers in countries like India or the Philippines — 
        but that often creates more problems than it solves.
      </p>

      <ul class="features">
        <li>
          <span class="icon">🗣️</span>
          <div>
            <h4>Language & Accent Barriers</h4>
            <p>Customers struggle to understand agents — especially in local dialects or slangs.</p>
          </div>
        </li>
        <li>
          <span class="icon">📋</span>
          <div>
            <h4>Lack of Menu Knowledge</h4>
            <p>Outsourced agents aren’t trained on your menu.</p>
          </div>
        </li>
        <li>
          <span class="icon">💼</span>
          <div>
            <h4>Zero Ownership or Brand Representation</h4>
            <p>Outsourced agents treat your brand like a transaction.</p>
          </div>
        </li>
        <li>
          <span class="icon">⏰</span>
          <div>
            <h4>Still Not 24/7</h4>
            <p>Many offshore centers work fixed shifts. If they log off, you miss calls again.</p>
          </div>
        </li>
      </ul>

      <a href="<?php echo e(route('register')); ?>" class="btn">Learn More</a>
    </div>

    <div class="image-side">
      <img src="web/assets/images/taker.webp" alt="Order Taking Issues" />
    </div>
  </div>
</section>

<style>
.cancellation-section {
  background: #f8f9fb;
  padding: 80px 5%;
  font-family: "Poppins", sans-serif;
  margin-top: -20px !important;
}

.cancellation-section .content {
  display: flex;
  align-items: flex-start;
  justify-content: space-between;
  gap: 60px;
  max-width: 1200px;
  margin: 0 auto;
}

.cancellation-section .text-side {
  flex: 1;
}

.cancellation-section h2 {
  font-size: 42px;
  font-weight: 700;
  margin-bottom: 12px;
  color: #111;
}

.cancellation-section .sub-text {
  color: #555;
  font-size: 17px;
  line-height: 1.6;
  margin-bottom: 40px;
}

.cancellation-section .features {
  list-style: none;
  margin: 0;
  padding: 0;
  display: flex;
  flex-direction: column;
  gap: 25px;
}

.cancellation-section .features li {
  display: flex;
  align-items: flex-start;
  gap: 15px;
}

.cancellation-section .features .icon {
  font-size: 22px;
  color: #0b6cff;
  background: rgba(11, 108, 255, 0.1);
  border-radius: 50%;
  width: 42px;
  height: 42px;
  display: flex;
  align-items: center;
  justify-content: center;
}

.cancellation-section .features h4 {
  margin: 0;
  font-size: 18px;
  font-weight: 600;
  color: #222;
}

.cancellation-section .features p {
  margin: 4px 0 0;
  color: #666;
  font-size: 15px;
  line-height: 1.5;
}

.cancellation-section .btn {
  display: inline-block;
  margin-top: 40px;
  padding: 12px 26px;
  background: #0b6cff;
  color: #fff;
  font-weight: 600;
  border-radius: 30px;
  text-decoration: none;
  transition: 0.3s;
}

.cancellation-section .btn:hover {
  background: #0456cc;
}

.cancellation-section .image-side {
  flex: 0 0 40%;
  text-align: center;
}

.cancellation-section .image-side img {
  width: 100%;
  max-width: 400px;
  border-radius: 12px;
  box-shadow: 0 6px 20px rgba(0, 0, 0, 0.08);
}

/* Responsive */
@media (max-width: 900px) {
  .cancellation-section .content {
    flex-direction: column;
    text-align: left;
  }
  .cancellation-section .image-side {
    order: -1;
    margin-bottom: 30px;
  }
}


.section-bg-white {
  background-color: #fff;
}


.impact-heading {
  font-size: 2.2rem;
  font-family: 'Poppins', sans-serif;
}


.impact-subtitle {
  max-width: 800px;
  margin: 0 auto;
  font-size: 1.1rem;
  font-family: 'Jost', sans-serif;
}


.stats-row {
  font-family: 'Jost', sans-serif;
}


.stat-number {
  color: #1351d8;
  font-size: 2.5rem;
  font-weight: 700;
}


.stat-text {
  font-size: 1rem;
}

</style>






<!-- Proven Impact Section -->
<section class="callchex-section py-50 section-bg-white">
  <div class="container max-w-1200-px">
    <!-- Heading -->
    <div class="text-center mb-5">
      <h2 class="fw-bold impact-heading">
        Proven Impact. Real Results
      </h2>
      <p class="lead text-muted mt-3 impact-subtitle">
        Voice AI takes precise orders—no more misheard items or missed customizations.
      </p>
    </div>

    <!-- Stats -->
    <div class="row text-center justify-content-center stats-row">
      <div class="col-lg-3 col-md-6 mb-4">
        <h3 class="stat-number">40%</h3>
        <p class="text-muted stat-text">No more lost orders during peak hours</p>
      </div>

      <div class="col-lg-3 col-md-6 mb-4">
        <h3 class="stat-number">25%</h3>
        <p class="text-muted stat-text">Higher average order value</p>
      </div>

      <div class="col-lg-3 col-md-6 mb-4">
        <h3 class="stat-number">2+ Hrs/Day</h3>
        <p class="text-muted stat-text">Saved on manual phone handling</p>
      </div>

      <div class="col-lg-3 col-md-6 mb-4">
        <h3 class="stat-number">60%</h3>
        <p class="text-muted stat-text">Lower order errors</p>
      </div>
    </div>
  </div>
</section>





<!-- ============================ Testimonials section start ============================= -->
<section class="testimonials py-50 bg-neutral-50 position-relative z-1">
    <img src="web/assets/images/shapes/faq-bg.png" alt="faq-bg" loading="lazy" class="position-absolute tw-start-0 top-0 w-100 h-100 z-n1">

    <div class="container">
        <div class="max-w-602-px mx-auto text-center tw-mb-15 mt-minus-10">
            <h3 class="splitTextStyleOne  tw-leading-104 tw-mb-9 d-flex gap-2 custom-features">
                What Our Clients Say About Us
            </h3>
        </div>

        <div class="swiper testimonials-five-slider swiper-initialized swiper-horizontal swiper-backface-hidden">
            <div class="swiper-wrapper">

                <!-- Slide 1 -->
                <div class="swiper-slide h-auto">
                    <div class="common-shadow-ten tw-rounded-2xl tw-p-4 bg-white h-100 d-flex flex-column animation-item  custom-box-style">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <p class="tw-mb-2 text-capitalize heading-responsive-medium as-tag1">Edgard Uzcategui</p>
                                <span class="fw-medium text-small-responsive">Septic LLC</span>
                            </div>
                            <div>
                                <img src="web/assets/images/icons/ratings.svg" alt="Star Rating" class="img-rating-responsive">
                            </div>
                        </div>
                        <p class="custom-goal-heading as-sub">
                            Achieved goals ahead of schedule with Leadmine Pro
                        </p>
                        <p class="text-neutral-600 paragraph-responsive">
                            Thanks to Leadmine Pro’s strategic guidance and ongoing support, we expanded our
                            business faster than planned — and saved significant costs!
                        </p>
                    </div>
                </div>

                <!-- Slide 2 -->
                <div class="swiper-slide h-auto">
                    <div class="common-shadow-ten tw-rounded-2xl tw-p-4 bg-white h-100 d-flex flex-column animation-item custom-box-style">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <p class="tw-mb-2 text-capitalize heading-responsive-medium as-tag1">Priya Desai</p>
                                <span class="fw-medium text-small-responsive">LeadSync Solutions</span>
                            </div>
                            <div>
                                <img src="web/assets/images/icons/ratings.svg" alt="Star Rating" class="img-rating-responsive">
                            </div>
                        </div>
                        <p class="custom-goal-heading as-sub">
                            Call quality went up — complaints went down
                        </p>
                        <p class="text-neutral-600 paragraph-responsive">
                            We finally understand what’s happening on our calls. The insights from
                            Leadmine Pro are game-changing for both coaching and compliance.
                        </p>
                    </div>
                </div>

                <!-- Slide 3 -->
                <div class="swiper-slide h-auto">
                    <div class="common-shadow-ten tw-rounded-2xl tw-p-4 bg-white h-100 d-flex flex-column animation-item custom-box-style">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <p class="tw-mb-2 text-capitalize heading-responsive-medium as-tag1">Marcus Boyd</p>
                                <span class="fw-medium text-small-responsive">BrightTouch Communications</span>
                            </div>
                            <div>
                                <img src="web/assets/images/icons/ratings.svg" alt="Star Rating" class="img-rating-responsive">
                            </div>
                        </div>
                        <p class="custom-goal-heading as-sub">
                            Performance insights that actually make sense
                        </p>
                        <p class="text-neutral-600 paragraph-responsive">
                            Our agents feel more confident, and sales have improved just weeks after adopting this AI
                            call scoring software from Leadmine Pro.
                        </p>
                    </div>
                </div>

                <!-- Slide 4 -->
                <div class="swiper-slide h-auto">
                    <div class="common-shadow-ten tw-rounded-2xl tw-p-4 bg-white h-100 d-flex flex-column animation-item custom-box-style">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <p class="tw-mb-2 text-capitalize heading-responsive-medium as-tag1">Nandita Rao</p>
                                <span class="fw-medium text-small-responsive">NextVoice Contact Center</span>
                            </div>
                            <div>
                                <img src="web/assets/images/icons/ratings.svg" alt="Star Rating" class="img-rating-responsive">
                            </div>
                        </div>
                        <p class="custom-goal-heading as-sub">
                            Took the guesswork out of coaching
                        </p>
                        <p class="text-neutral-600 paragraph-responsive">
                            We don’t just coach better now – we coach faster and with purpose. That’s made a real
                            difference with Leadmine Pro.
                        </p>
                    </div>
                </div>

                <!-- Slide 5 -->
                <div class="swiper-slide h-auto">
                    <div class="common-shadow-ten tw-rounded-2xl tw-p-4 bg-white h-100 d-flex flex-column animation-item custom-box-style">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <p class="tw-mb-2 text-capitalize heading-responsive-medium as-tag1">Jorge Martinez</p>
                                <span class="fw-medium text-small-responsive">SalesNova Team</span>
                            </div>
                            <div>
                                <img src="web/assets/images/icons/ratings.svg" alt="Star Rating" class="img-rating-responsive">
                            </div>
                        </div>
                        <p class="custom-goal-heading as-sub">
                            Best call scoring software for call centers
                        </p>
                        <p class="text-neutral-600 paragraph-responsive">
                            It’s like having a real-time manager for every agent – without micromanaging anyone.
                            Leadmine Pro makes that possible.
                        </p>
                    </div>
                </div>

                <!-- Slide 6 -->
                <div class="swiper-slide h-auto">
                    <div class="common-shadow-ten tw-rounded-2xl tw-p-4 bg-white h-100 d-flex flex-column animation-item custom-box-style">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <p class="tw-mb-2 text-capitalize heading-responsive-medium as-tag1">Emily Chen</p>
                                <span class="fw-medium text-small-responsive">Pulse360 Sales Team</span>
                            </div>
                            <div>
                                <img src="web/assets/images/icons/ratings.svg" alt="Star Rating" class="img-rating-responsive">
                            </div>
                        </div>
                        <p class="custom-goal-heading as-sub">
                            Improved productivity without burning out our reps
                        </p>
                        <p class="text-neutral-600 paragraph-responsive">
                            Leadmine Pro helped us find coaching moments instantly, which meant less
                            pressure on supervisors – and better feedback for reps.
                        </p>
                    </div>
                </div>

                <!-- Slide 7 -->
                <div class="swiper-slide h-auto">
                    <div class="common-shadow-ten tw-rounded-2xl tw-p-4 bg-white h-100 d-flex flex-column animation-item custom-box-style">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <p class="tw-mb-2 text-capitalize heading-responsive-medium as-tag1">Aarav Mehta</p>
                                <span class="fw-medium text-small-responsive">TalkRight Tech</span>
                            </div>
                            <div>
                                <img src="web/assets/images/icons/ratings.svg" alt="Star Rating" class="img-rating-responsive">
                            </div>
                        </div>
                        <p class="custom-goal-heading as-sub">
                            From chaos to clarity
                        </p>
                        <p class="text-neutral-600 paragraph-responsive">
                            Before Leadmine Pro, we were just hoping agents did well. Now, we know who’s
                            doing what – and why, thanks to the AI call scoring software.
                        </p>
                    </div>
                </div>

            </div>

            <!-- Pagination -->
            <div
                class="testimonials-five-slider-pagination pagination-style-four d-flex align-items-center justify-content-center tw-gap-6 tw-mt-15 tw-pb-3 swiper-pagination-clickable swiper-pagination-bullets swiper-pagination-horizontal">
                <span class="swiper-pagination-bullet"></span>
                <span class="swiper-pagination-bullet swiper-pagination-bullet-active"></span>
                <span class="swiper-pagination-bullet"></span>
                <span class="swiper-pagination-bullet"></span>
            </div>
        </div>
    </div>
</section>

 


 <?php $__env->stopSection(); ?>
<?php echo $__env->make('website.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/leadmine/leadmine_pro/resources/views/website/order-taker.blade.php ENDPATH**/ ?>