<?php $__env->startSection('title', 'Subscriptions'); ?>

<?php $__env->startSection('content'); ?>
<style>
  .badge
{font-size: 1rem;
    font-style: normal;
    font-weight: 400;
    font-family: "IBM Plex Sans", sans-serif;
    line-height: 1.5;}
    .table > tbody > tr > td, .table > tbody > tr > th {
     padding: 0.5rem; 
    vertical-align: middle;
}
  </style>
<!-- Main content -->
        <section class="content">

      <div class="row">
        
        <div class="col-12">
          <div class="box">
             <div class="box-body">   
              <h4 class="box-title text-info mb-0"><i class="fa fa-list fa-sx"></i> User Packages</h4> 
                 <hr class="my-15">    
              <div class="table-responsive">
                <table id="tickets"  class="table mt-0 table-hover no-wrap" >
                  <thead>
                    <tr>
                    <th>#</th>
                                    <th>Name</th>
                                    <th>Role</th>
                                    <th>Available Package</th>

                            </tr>
                  </thead>
                  <tbody>
                  <?php $__currentLoopData = $userPackages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $userPackage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($key+1); ?></td>
                                        <td><?php echo e($userPackage->first_name); ?> <?php echo e($userPackage->last_name); ?></td>
                                        <td><?php echo e($userPackage->role); ?></td>
                                        <td>
                                            <?php if( $userPackage->package_key ): ?> 
                                                <select class="form-control package-control-selected" name="package" data-client="<?php echo e($userPackage->client_id); ?>" data-user="<?php echo e($userPackage->user_id); ?>">
                                                    <?php
                                                        $earlier = new DateTime(date("Y-m-d"));
                                                        $later = new DateTime($userPackage->end_time);
                                                        $diff = $later->diff($earlier)->format("%a");
                                                    ?>
                                                    <option value="<?php echo e($userPackage->package_key); ?>"><?php echo e($userPackage->package_name); ?> – <?php echo e($diff); ?> Days remaining</option> 
                                                    <option name ="package" value="<?php echo e($userPackage->package_key); ?>">Remove Package</option>
                                                </select>
                                            <?php else: ?>
                                                <select class="form-select package-control-select" name="package" data-client="<?php echo e($userPackage->client_id); ?>" data-user="<?php echo e($userPackage->user_id); ?>">
                                                    <option value="#">Assign package</option>
                                                    <?php $__currentLoopData = $availablePackages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $availablePackage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php $availableSlot = $availablePackage->quantity - count((array)$availablePackage->assigned);
                                                        $earlier = new DateTime(date("Y-m-d"));
                                                        $later = new DateTime($availablePackage->end_time);
                                                        $diff = $later->diff($earlier)->format("%a");
                                                        ?>
                                                                <option name ="package" value="<?php echo e($availablePackage->package_key); ?>"><?php echo e($availablePackage->package_name); ?> (<?php echo e($availableSlot); ?>) – <?php echo e($diff); ?> Days remaining</option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>               
                  </tbody>
                </table>
              
                    </div><!-- /.box-body -->
            

              </div>
     
            </div>
          </div>
        </div>
      </div>
      <!-- /.row -->
   
      <!-- Button trigger modal -->



 
        </div>
    </section>
 
    <script src="https://code.jquery.com/jquery-3.7.0.js" integrity="sha256-JlqSTELeR4TLqP0OG9dxM7yDPqX1ox/HfgiSLBj8+kM=" crossorigin="anonymous"></script>

    <script type="text/javascript">
    $(document).ready(function() {
        

        $(document).on('change', '.package-control-select', function(){
            var package_key = this.value;
            if ( package_key != "#" ){
                var client_id = $(this).data('client');
                var user_id = $(this).data('user');
                var csrf_token = $('meta[name="csrf-token"]').attr('content');
                $.ajax({
                    url: '/user-package/update/' + package_key,
                    type: 'POST',
                    data: {
                        user_id: user_id,
                        client_id: client_id,
                        _token: csrf_token 
                    },
                    dataType:"json",
                    success: function (response)
                    {
                        toastr.success(response);
                        location.reload();
                    }
                });
            }
        });

        $(document).on('change', '.package-control-selected', function(){
            var package_key = this.value;
                var client_id = $(this).data('client');
                var user_id = $(this).data('user');
                var csrf_token = $('meta[name="csrf-token"]').attr('content');

                $.ajax({
                    url: '/user-package/delete/' + package_key,
                    type: 'POST',
                    data: {
                        user_id: user_id,
                        client_id: client_id,
                        _token: csrf_token 

                    },
                    dataType:"json",
                    success: function (response)
                    {
                        toastr.success(response);
                        location.reload();
                    }
                });
        });
    });
    </script>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/leadmine/leadmine_pro/resources/views/subscriptions/user-packages.blade.php ENDPATH**/ ?>