 

<?php $__env->startSection('meta'); ?>
   <title>Fitness & Wellness Automation Solutions | <?php echo e(config('app.site')); ?></title>
<meta name="description" content="Boost fitness and wellness business growth with AI automation. Manage bookings, reminders, member engagement, and retention effortlessly with <?php echo e(config('app.site')); ?>.">

<meta name="keywords" content="Fitness call automation, Automated class booking, Gym booking assistant">


<meta property="og:title" content="Fitness & Wellness Automation Solutions | <?php echo e(config('app.site')); ?>">
<meta property="og:description" content="Boost fitness and wellness business growth with AI automation. Manage bookings, reminders, member engagement, and retention effortlessly with <?php echo e(config('app.site')); ?>.">
<meta property="og:image" content="<?php echo e(asset('web/assets/images/wellness.webp')); ?>">
<meta property="og:type" content="website">
<meta property="og:url" content="<?php echo e(url()->current()); ?>">


<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Fitness & Wellness Automation Solutions | <?php echo e(config('app.site')); ?>">
<meta name="twitter:description" content="Boost fitness and wellness business growth with AI automation. Manage bookings, reminders, member engagement, and retention effortlessly with <?php echo e(config('app.site')); ?>.">
<meta name="twitter:image" content="<?php echo e(asset('web/assets/images/wellness.webp')); ?>">

<?php $__env->stopSection(); ?>







 <?php $__env->startSection('content'); ?>
<style>
.custom-img {
  margin-top: 180px;
}

 .paragraph-style {
  font-weight: 400;
  font-size: 18px;
}

.custom-heading {
  font-weight: 400;  
}

.max-width-40 {
  max-width: 40%;
}

@media (max-width: 768px) {
  .custom-img {
    margin-top: 50px;
  }
}
.pt-40 {
  padding-top: 40px;
}
.img-auto-warranty {
  max-height: 500px;
  width: 100%;
  object-fit: contain;
}

.img-deal-maxwidth{
  max-width: 35%;
}
.custom-padding-100 {
  padding: 100px 0;
}
.img-pitch-maxwidth {
  max-width: 30%;
}
.visually-hidden {
    position: absolute;
    width: 1px;
    height: 1px;
    padding: 0;
    margin: -1px;
    overflow: hidden;
    clip: rect(0, 0, 0, 0);
    white-space: nowrap;
    border: 0;
}
.as-h2 {
 font-size: clamp(1.5rem, 0.5569rem + 1.444vw, 1.875rem);
 }

.tw-mb-1{
 font-size: clamp(1.125rem, 1.2rem + 0.722vw, 1.5rem);
 }
</style>
 <!-- <section class="section-bg-two pb-50 overflow-hidden pt-40">
     <div class="container max-w-1290-px">
         <div class="row gy-5 align-items-center justify-content-center text-center">
             <div class="col-xl-12">
                 <div>
                     <div class="mx-auto tw-mb-12">
                          <h1 class="visually-hidden">Real Estate & Mortgage Intelligence</h1>
                         <h3 class="splitTextStyleOne text-heading heading-medium">
                             Real Estate & Mortgage Intelligence
                         </h3>
                         <p class="text-neutral-500 tw-mt-2 splitTextStyleOne max-w-770-px tw-text-lg mx-auto">
                             With real-time dashboards and performance scorecards, managers get a clear view of which
                             agents are driving deals—and who needs coaching.
                         </p>
                         <div class="tw-mt-2" data-aos="fade-up" data-aos-anchor-placement="top-bottom"
                             data-aos-duration="900">
                             <a href="<?php echo e(route('register')); ?>"
                                 class="hover--translate-y-1 active--translate-y-scale-9 btn button--stroke tw-gap-5 group active--translate-y-2 tw-rounded-xl text-capitalize tw-px-8 tw-py-505 fw-medium btn-main hover-style-one"
                                 data-block="button">
                                 <span class="button__flair"></span>
                                 <span class="button__label">Get started</span>
                             </a>
                         </div>
                     </div>
                 </div>
             </div>
         </div>
     </div>
 </section> -->
<section class="hero-section">
  <div class="hero-container">
    <div class="hero-left">
       <h1>Get, Set, Grow Your Fitness Business</h1>
         <p>
     Scale outreach, skyrocket bookings, grow memberships, and deliver great client experiences with Leadmine.pro.
      </p>
      <div class="hero-badges">
      <span><i class="fa fa-check-circle"></i> No credit card required</span>
        <span><i class="fa fa-check-circle"></i> 14 days of <?php echo e(config('app.site')); ?> AI on us</span>
      </div>
    </div>

    <div class="hero-right">
      <div class="hero-image-wrapper">
        <img src="web/assets/images/wellness.webp" alt="AI platform helping fitness businesses grow memberships and bookings">

    
      </div>
    </div>
  </div>
</section>

<style>
.hero-section {
background: linear-gradient(180deg, rgba(255, 229, 154, .3803921569) 0, #ffffd5 100%);
  padding: 100px 0;
  font-family: "Inter", sans-serif;
}

.hero-container {
  max-width: 1250px;
  margin: auto;
  display: flex;
  align-items: center;
  justify-content: space-between;
  flex-wrap: wrap;
  gap: 70px;
}

.hero-left {
  flex: 1 1 520px;
}

.hero-left h1 {
  font-size: 40px;
  font-weight: 700;
  color: #1b1f3b;
  line-height: 1.25;
  margin-bottom: 25px;
  max-width: 500px;
}

.hero-left p {
  font-size: 18px;
  line-height: 1.7;
  color: #2b2b2b;
  margin-bottom: 35px;
  max-width: 520px;
  font-family: "Poppins", sans-serif; 
}

.hero-badges {
  display: flex;
  flex-wrap: wrap;
  gap: 20px;
  font-size: 16px;
  color: #1b1f3b;
}

.hero-badges i {
  color: #3b82f6;
  margin-right: 8px;
}

/* Right Side */
.hero-right {
  flex: 1 1 520px;
  display: flex;
  justify-content: center;
  position: relative;
}

.hero-image-wrapper {
  position: relative;
  width: 100%;
  max-width: 540px;
  border-radius: 20px;
  overflow: hidden;
  box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
}

.hero-image-wrapper img {
  width: 100%;
  display: block;
  object-fit: cover;
}

/* Agent Card */
.agent-card {
  position: absolute;
  top: 30px;
  left: 30px;
  background: #fff;
  border-radius: 16px;
  box-shadow: 0 6px 18px rgba(0, 0, 0, 0.1);
  padding: 16px 18px;
  max-width: 280px;
  border: 1px solid #e5e9ff;
}

.agent-card h4 {
  font-size: 15px;
  font-weight: 700;
  color: #1c2250;
  margin-bottom: 10px;
}

.agent-tabs {
  display: flex;
  gap: 6px;
  margin-bottom: 10px;
}

.agent-tabs .tab {
  flex: 1;
  font-size: 13px;
  text-align: center;
  padding: 6px 0;
  border-radius: 6px;
  background: #eef1ff;
  color: #4a4e74;
  font-weight: 600;
}

.agent-tabs .tab.active {
  background: #3b82f6;
  color: #fff;
}

.agent-message {
  font-size: 14px;
  color: #2b2b2b;
  background: #f9faff;
  padding: 12px;
  border-radius: 10px;
  line-height: 1.5;
  margin-bottom: 10px;
}

.agent-feedback {
  display: flex;
  justify-content: space-between;
  font-size: 13px;
  color: #3b82f6;
  font-weight: 600;
}

/* Responsive */
@media (max-width: 992px) {
  .hero-container {
    flex-direction: column;
    text-align: center;
  }

  .hero-left h1 {
    font-size: 36px;
    max-width: 100%;
  }

  .hero-left p {
    margin: 0 auto 30px;
  }

  .hero-badges {
    justify-content: center;
  }

  .hero-image-wrapper {
    margin-top: 40px;
  }

  .agent-card {
    position: static;
    margin: 20px auto 0;
  }
}

.secure-section {
  background: linear-gradient(180deg, #f2f4ff 0%, #ffffff 100%);
  padding: 100px 0;
  font-family: "Poppins", sans-serif; 
}

.secure-container {
  max-width: 1250px;
  margin: auto;
  display: flex;
  align-items: center;
  justify-content: space-between;
  flex-wrap: wrap;
  gap: 70px;
}

.secure-left {
  flex: 1 1 520px;
}

.secure-left h1 {
  font-size: 42px;
  font-weight: 800;
  color: #1b1f3b;
  line-height: 1.25;
  margin-bottom: 25px;
  max-width: 500px;
}

.secure-left p {
  font-size: 18px;
  line-height: 1.8;
  color: #2b2b2b;
  margin: 20px 0 30px 0; 
  max-width: 520px;
}

.secure-badges {
  display: flex;
  flex-wrap: wrap;
  gap: 20px;
  font-size: 16px;
  color: #1b1f3b;
}

.secure-badges i {
  color: #3b82f6;
  margin-right: 8px;
}

/* Right Side */
.secure-right {
  flex: 1 1 520px;
  display: flex;
  justify-content: center;
  position: relative;
}

.secure-image-wrapper {
  position: relative;
  width: 100%;
  max-width: 540px;
  border-radius: 20px;
  overflow: hidden;
  box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
  background: #fff;
}

.secure-image-wrapper img {
  width: 100%;
  display: block;
  object-fit: cover;
}


@media (max-width: 992px) {
  .secure-container {
    flex-direction: column;
    text-align: center;
  }

  .secure-left h1 {
    font-size: 34px;
    max-width: 100%;
  }

  .secure-left p {
    margin: 20px auto 30px; 
  }

  .secure-badges {
    justify-content: center;
  }

  .secure-image-wrapper {
    margin-top: 40px;
  }
}

</style>
<section class="toolkit-section py-5 bg-white">
  <div class="container">
    <h4 class="text-center mb-5 fw-bold">Because fitness studio management software is good, but it’s missing…</h4>

    <div class="toolkit-grid">

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-phone"></i></div>
        <h4>Seamless Integrations</h4>
        <p>Get local and toll-free business phone numbers to handle bookings and make client calls.</p>
      
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-route"></i></div>
        <h4>Intelligent Call Routing & IVR</h4>
        <p>Set up routing sequences and multi-level menus to connect inbound calls to the right teams.</p>
       
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-shield-halved"></i></div>
        <h4>HIPAA Compliance</h4>
        <p>Grow memberships with automated text messages for follow-ups, updates, and promotions.</p>
       
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-headset"></i></div>
        <h4>Sales Dialer</h4>
        <p>Skip answering machines and reach more leads with auto, dynamic, and predictive dialers.</p>
       
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-link"></i></div>
        <h4>Click-to-Call CRM Integrations</h4>
        <p>No more switching tools. Call potential clients directly from HubSpot, Pipedrive, or your CRM.</p>
       
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-chart-line"></i></div>
        <h4>Real-time Assist & Conversation Intelligence</h4>
        <p>Get live cues and script suggestions on calls. Unlock insights with AI call analytics, sentiment tracking, and scores.</p>
       
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-message"></i></div>
        <h4>SMS Copilot & Saved Replies</h4>
        <p>Craft engaging text messages with AI rephrasing and tone analysis. Respond quickly with pre-saved templates.</p>
        
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-envelope-open-text"></i></div>
        <h4>Bulk SMS Campaigns</h4>
        <p>Scale marketing efforts across studio locations and re-engage lost leads with targeted texts.</p>
       
      </div>

    </div>
  </div>
</section>

<!-- Font Awesome -->
<script src="https://kit.fontawesome.com/a2d9a67a2b.js" crossorigin="anonymous"></script>

<style>
.toolkit-section {
  background: #f7f7f9; 
  font-family: 'Poppins', sans-serif;
}

.toolkit-grid {
  display: grid;
  grid-template-columns: repeat(auto-fit, minmax(270px, 1fr));
  gap: 25px;
}

.toolkit-item {
  background: #fff;
  border: 1px solid #e5e7eb;
  border-radius: 12px;
  padding: 28px 24px;
  box-shadow: 0 4px 12px rgba(0,0,0,0.04);
  transition: all 0.3s ease;
  cursor: pointer;
  text-align: left;
}

.toolkit-item:hover {
  border-color: #3b82f6;
  box-shadow: 0 8px 22px rgba(59,130,246,0.1);
  transform: translateY(-4px);
}

.toolkit-item .icon {
  font-size: 30px;
  color: #0a5bff;
  margin-bottom: 18px;
}

.toolkit-item h4 {
  font-size: 18px;
  font-weight: 600;
  margin-bottom: 10px;
  color: #000;
}

.toolkit-item p {
  font-size: 15px;
  color: #444;
  line-height: 1.6;
  margin-bottom: 10px;
}

.learn-more {
  color: #0a5bff;
  font-weight: 500;
  font-size: 14px;
  text-decoration: none;
  transition: color 0.2s ease;
}

.learn-more:hover {
  color: #0044cc;
  text-decoration: underline;
}

@media (max-width: 768px) {
  .toolkit-item {
    padding: 22px 18px;
  }
}
</style>


<!-- ================== Driven section Start ====================== -->

<!-- ================== Driven section Start ====================== -->

<h2 class="main-heading text-center mb-4 mt-2">
  Scale outreach campaigns to win more clients every day
</h2>

<section class="ai-section py-5">
  <div class="container">

    <h3 class="sub-heading text-center mb-2">
      Instantly call leads who fill a booking form on your website
    </h3>

    <!-- Section 1 -->
    <div class="row align-items-center mb-5 custom-gap-fix">
      <div class="col-lg-6">
        <p class="section-text">
          Instantly connect with leads who fill your booking form using <?php echo e(config('app.site')); ?>. Never miss a hot lead—reach more clients with bulk SMS campaigns and let AI help you re-engage lost leads through targeted messages.
        </p>
        <ul class="section-list">
          <li>Instant call triggers for form submissions</li>
          <li>Bulk SMS campaigns to reach more clients</li>
          <li>AI re-engagement for inactive leads</li>
          <li>Faster responses to high-intent prospects</li>
        </ul>
        <!-- <a href="https://leadmine.pro" class="section-link">
          🔗 Learn more about Leadmine.pro Outreach Tools
        </a> -->
      </div>

      <div class="col-lg-6 text-center">
        <img src="<?php echo e(asset('web/assets/images/gym.webp')); ?>" 
             alt="AI-powered lead follow-up and SMS campaigns"
             class="img-fluid section-img">
      </div>
    </div>

    <!-- Section 2 -->
    <h3 class="sub-heading text-center mb-2">
      Connect clients to the right teams to skyrocket bookings
    </h3>
    <div class="row align-items-center mb-5 flex-row-reverse">
      <div class="col-lg-6">
        <p class="section-text">
          <?php echo e(config('app.site')); ?> makes it simple for clients to reach the right person at the right time. Offer local or toll-free numbers, set up IVRs, and route calls directly from your CRM to the right studio or team.
        </p>
        <ul class="section-list">
          <li>Dedicated local or toll-free numbers</li>
          <li>Smart call routing and IVR setup</li>
          <li>Click-to-call directly from your CRM</li>
          <li>Faster connections, more bookings</li>
        </ul>
        <!-- <a href="https://leadmine.pro" class="section-link">
          🔗 Explore Leadmine.pro Call Routing
        </a> -->
      </div>
      <div class="col-lg-6 text-center">
        <img src="<?php echo e(asset('web/assets/images/gym1.webp')); ?>" 
             alt="AI-powered call routing for studio and team bookings"
             class="img-fluid section-img">
      </div>
    </div>

    <!-- Section 3 -->
    <h3 class="sub-heading text-center mb-2">
      Grow memberships with real-time assist & SMS follow-ups
    </h3>
    <div class="row align-items-center mb-5 custom-gap-fix">
      <div class="col-lg-6">
        <p class="section-text">
          Have better conversations with <?php echo e(config('app.site')); ?>’s real-time cues and smart scripts. Automatically send schedule updates, membership details, and offers to clients. Get AI insights from every call to improve performance.
        </p>
        <ul class="section-list">
          <li>Real-time assist with AI suggestions</li>
          <li>Automated SMS for schedules & promotions</li>
          <li>AI call analytics to replicate winning calls</li>
          <li>Faster follow-ups and higher retention</li>
        </ul>
        <!-- <a href="https://leadmine.pro" class="section-link">
          🔗 Discover Real-Time Assist by Leadmine.pro
        </a> -->
      </div>
      <div class="col-lg-6 text-center">
        <img src="<?php echo e(asset('web/assets/images/gym2.webp')); ?>" 
             alt="Real-time assist and AI call insights for membership growth"
             class="img-fluid section-img">
      </div>
    </div>

    <!-- Section 4 -->
    <h3 class="sub-heading text-center mb-3">
      Keep clients engaged & happy with omni-channel support
    </h3>
    <div class="row align-items-center mb-4 flex-row-reverse">
      <div class="col-lg-6">
        <p class="section-text">
          Give your clients seamless communication with <?php echo e(config('app.site')); ?>. Use dedicated numbers for support and billing, enable IVRs for quick routing, and reply faster with saved SMS templates.
        </p>
        <ul class="section-list">
          <li>Local & toll-free support numbers</li>
          <li>IVRs and routing for faster resolutions</li>
          <li>Saved SMS templates for instant replies</li>
          <li>Happier clients with proactive communication</li>
        </ul>
        <!-- <a href="https://leadmine.pro" class="section-link">
          🔗 Learn more about Omni-Channel Support
        </a> -->
      </div>
      <div class="col-lg-6 text-center">
        <img src="<?php echo e(asset('web/assets/images/gym3.webp')); ?>" 
             alt="Omni-channel AI support and customer engagement"
             class="img-fluid section-img">
      </div>
    </div>

    <div class="text-center mt-4">
      <a href="<?php echo e(route('register')); ?>" class="btn btn-primary px-4 py-2 rounded-pill">Start Free Trial</a>
    </div>

  </div>
</section>

<!-- ================== Driven section End ====================== -->


<!-- ================== Driven section End ====================== -->


<!-- CSS -->
<style>
.main-heading {
  font-size: 2.2rem;
  font-weight: 700;
  color: #000; 
}

.ai-section {
  background: #0b1a33;
  color: #fff;
  padding: 50px 0;
}

.sub-heading {
  font-size: 1.4rem;
  font-weight: 600;
  margin-bottom: 6px; 
}

.section-text {
  font-size: 1rem;
  line-height: 1.6;
  margin-bottom: 8px;
  max-width: 440px;  
  text-align: left; 
}


.section-list {
  padding-left: 18px;
  margin-bottom: 8px;
}

.section-list li {
  margin-bottom: 5px;
  list-style: disc;
}

.section-link {
  color: #4e9eff;
  font-weight: 600;
  text-decoration: none;
}

.section-link:hover {
  text-decoration: underline;
}


.section-img {
  max-width: 390px;
  width: 100%;
  height: auto;
  border-radius: 6px;
  box-shadow: 0 3px 12px rgba(0,0,0,0.25);
  margin: 0 auto;
}


.row.align-items-center {
  display: flex;
  justify-content: space-between;  
  align-items: center;
  margin: 0;  
}



.row.align-items-center .col-lg-6 {
  flex: 0 0 auto;
  width: 50%;
  max-width: 50%;
  padding: 0 15px;  
}


.custom-gap-fix .col-lg-6:first-child {
  padding-left: 200px !important;
}


@media (max-width: 991px) {
  .custom-gap-fix .col-lg-6:first-child {
    padding-left: 0 !important;
  }
}




.row.align-items-center.flex-row-reverse {
  flex-direction: row-reverse;
}


@media (max-width: 991px) {
  .row.align-items-center,
  .row.align-items-center.flex-row-reverse {
    flex-direction: column;
  }

  .row.align-items-center .col-lg-6 {
    width: 100%;
    max-width: 100%;
    padding: 0;  
  }

  .section-img {
    margin-top: 12px;
    max-width: 100%;
  }
}

/* Tablet only (768px - 991px) */
@media (min-width: 768px) and (max-width: 991px) {
  .section-img {
    max-width: 65%;
    margin: 15px auto;
    display: block;
  }

  .section-text {
    max-width: 80%;
    margin: 0 auto 12px;
    font-size: 0.95rem;
    line-height: 1.5;
    text-align: center;
  }

  .section-list {
    max-width: 80%;
    margin: 0 auto 12px;
    padding-left: 0;
    list-style-position: inside;
    text-align: center; 
  }

  .section-list li {
    display: block;
    text-align: center;
    margin: 6px 0;
  }

  .section-link {
    display: block;
    text-align: center;
    margin-top: 10px;
    font-size: 0.95rem;
    word-break: break-word;
  }

  .sub-heading {
    font-size: 1.2rem;
    text-align: center;
    margin-bottom: 10px;
  }

  .main-heading {
    font-size: 1.8rem;
    text-align: center;
    margin-bottom: 12px;
  }

}


</style>




<!-- Font Awesome -->
<script src="https://kit.fontawesome.com/a2d9a67a2b.js" crossorigin="anonymous"></script>

<style>
.toolkit-section {
  background: #f7f7f9; 
  font-family: 'Poppins', sans-serif;
}

.toolkit-grid {
  display: grid;
  grid-template-columns: repeat(auto-fit, minmax(270px, 1fr));
  gap: 25px;
}

.toolkit-item {
  background: #fff;
  border: 1px solid #e5e7eb;
  border-radius: 12px;
  padding: 28px 24px;
  box-shadow: 0 4px 12px rgba(0,0,0,0.04);
  transition: all 0.3s ease;
  cursor: pointer;
}

.toolkit-item:hover {
  border-color: #3b82f6;
  box-shadow: 0 8px 22px rgba(59,130,246,0.1);
  transform: translateY(-4px);
}


.toolkit-item .icon {
  font-size: 30px;
  color: #0a5bff;
  margin-bottom: 18px;
}


.toolkit-item h4 {
  font-size: 18px;
  font-weight: 600;
  margin-bottom: 10px;
  color: #000;
}

.toolkit-item p {
  font-size: 15px;
  color: #444;
  line-height: 1.6;
}

@media (max-width: 768px) {
  .toolkit-item {
    padding: 22px 18px;
  }
}
</style>


<section class="faq-two py-50 bg-aliceblue">
  <div class="container">
    <div class="row gy-4">
      <div class="col-lg-12 d-flex">
        <div class="m-auto">
          <h2 class="visually-hidden">Frequently Asked Questions</h2>
          <h3 class="splitTextStyleOne text-heading text-capitalize heading-medium">
            Frequently Asked Questions
          </h3>
        </div>
      </div>

      <div class="col-lg-12">
        <div class="ps-xl-5">
          <div class="accordion common-accordion style-two arrow-bg-orange" id="accordionExample">

            <!-- Q1 -->
            <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-blue border-0 mb-0"
              data-aos="fade-up">
              <h3 class="accordion-header d-flex align-items-center justify-content-between tw-gap-3">
                <button class="accordion-button shadow-none p-0 line-clamp-3 bg-transparent h5"
                  type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne"
                  aria-expanded="true" aria-controls="collapseOne">
                  What is <?php echo e(config('app.site')); ?>?
                </button>
              </h3>
              <div id="collapseOne" class="accordion-collapse collapse show"
                data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 tw-leading-212 heading-medium">
                    <?php echo e(config('app.site')); ?> is an AI-powered call management platform that helps automate phone answering, analyze conversations, and deliver 24/7 customer support without overloading your team.
                  </p>
                </div>
              </div>
            </div>

            <!-- Q2 -->
            <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-blue border-0 mb-0"
              data-aos="fade-up">
              <h3 class="accordion-header d-flex align-items-center justify-content-between tw-gap-3">
                <button class="accordion-button shadow-none p-0 line-clamp-3 bg-transparent h5 collapsed"
                  type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo"
                  aria-expanded="false" aria-controls="collapseTwo">
                  How does the AI Receptionist work in <?php echo e(config('app.site')); ?>?
                </button>
              </h3>
              <div id="collapseTwo" class="accordion-collapse collapse"
                data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 tw-leading-212 heading-medium">
                    The AI Receptionist in <?php echo e(config('app.site')); ?> instantly answers incoming calls — even after hours — to schedule appointments, take messages, and route calls intelligently so you never miss an opportunity.
                  </p>
                </div>
              </div>
            </div>

            <!-- Q3 -->
            <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-blue border-0 mb-0"
              data-aos="fade-up">
              <h3 class="accordion-header d-flex align-items-center justify-content-between tw-gap-3">
                <button class="accordion-button shadow-none p-0 line-clamp-3 bg-transparent h5 collapsed"
                  type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree"
                  aria-expanded="false" aria-controls="collapseThree">
                  How does <?php echo e(config('app.site')); ?> reduce staff workload?
                </button>
              </h3>
              <div id="collapseThree" class="accordion-collapse collapse"
                data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 tw-leading-212 heading-medium">
                    By handling repetitive calls and inquiries, <?php echo e(config('app.site')); ?> frees your staff from constant interruptions so they can focus on meaningful work while AI handles the rest.
                  </p>
                </div>
              </div>
            </div>

            <!-- Q4 -->
            <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-transparent border-0 mb-0"
              data-aos="fade-up">
              <h3 class="accordion-header d-flex align-items-center justify-content-between tw-gap-3">
                <button class="accordion-button shadow-none p-0 line-clamp-3 bg-transparent h5 collapsed"
                  type="button" data-bs-toggle="collapse" data-bs-target="#collapseFour"
                  aria-expanded="false" aria-controls="collapseFour">
                  What is the AI Call Analytics dashboard?
                </button>
              </h3>
              <div id="collapseFour" class="accordion-collapse collapse"
                data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 tw-leading-212 heading-medium">
                    <?php echo e(config('app.site')); ?> includes a powerful AI Call Analytics dashboard that monitors every conversation, tracks sentiment, evaluates call outcomes, and gives you clear insights into customer experience and team performance.
                  </p>
                </div>
              </div>
            </div>

            <!-- Q5 -->
            <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-transparent border-0 mb-0"
              data-aos="fade-up">
              <h3 class="accordion-header d-flex align-items-center justify-content-between tw-gap-3">
                <button class="accordion-button shadow-none p-0 line-clamp-3 bg-transparent h5 collapsed"
                  type="button" data-bs-toggle="collapse" data-bs-target="#collapseFive"
                  aria-expanded="false" aria-controls="collapseFive">
                  Can <?php echo e(config('app.site')); ?> answer calls in multiple languages?
                </button>
              </h3>
              <div id="collapseFive" class="accordion-collapse collapse"
                data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 tw-leading-212 heading-medium">
                    Yes! The AI Voice Agents in <?php echo e(config('app.site')); ?> can speak and understand over 50 languages, providing natural, human-like communication for global customers.
                  </p>
                </div>
              </div>
            </div>

            <!-- Q6 -->
            <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-transparent border-0 mb-0"
              data-aos="fade-up">
              <h3 class="accordion-header d-flex align-items-center justify-content-between tw-gap-3">
                <button class="accordion-button shadow-none p-0 line-clamp-3 bg-transparent h5 collapsed"
                  type="button" data-bs-toggle="collapse" data-bs-target="#collapseSix"
                  aria-expanded="false" aria-controls="collapseSix">
                  Does <?php echo e(config('app.site')); ?> handle after-hours calls?
                </button>
              </h3>
              <div id="collapseSix" class="accordion-collapse collapse"
                data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 tw-leading-212 heading-medium">
                    Absolutely. <?php echo e(config('app.site')); ?>’s AI Receptionist works 24/7 — answering calls, capturing details, and ensuring follow-ups so you never miss an opportunity, even outside business hours.
                  </p>
                </div>
              </div>
            </div>

            <!-- Q7 -->
            <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-transparent border-0 mb-0"
              data-aos="fade-up">
              <h3 class="accordion-header d-flex align-items-center justify-content-between tw-gap-3">
                <button class="accordion-button shadow-none p-0 line-clamp-3 bg-transparent h5 collapsed"
                  type="button" data-bs-toggle="collapse" data-bs-target="#collapseSeven"
                  aria-expanded="false" aria-controls="collapseSeven">
                  How does <?php echo e(config('app.site')); ?> improve customer experience?
                </button>
              </h3>
              <div id="collapseSeven" class="accordion-collapse collapse"
                data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 tw-leading-212 heading-medium">
                    <?php echo e(config('app.site')); ?> analyzes tone, intent, and satisfaction in real time to give you actionable insights — helping your business deliver faster, smarter, and more empathetic phone support.
                  </p>
                </div>
              </div>
            </div>

            <!-- Q8 -->
            <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-transparent border-0 mb-0"
              data-aos="fade-up">
              <h3 class="accordion-header d-flex align-items-center justify-content-between tw-gap-3">
                <button class="accordion-button shadow-none p-0 line-clamp-3 bg-transparent h5 collapsed"
                  type="button" data-bs-toggle="collapse" data-bs-target="#collapseEight"
                  aria-expanded="false" aria-controls="collapseEight">
                  Do I need technical knowledge to use <?php echo e(config('app.site')); ?>?
                </button>
              </h3>
              <div id="collapseEight" class="accordion-collapse collapse"
                data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 tw-leading-212 heading-medium">
                    Not at all. <?php echo e(config('app.site')); ?> is designed to work out-of-the-box with your existing phone system or CRM — no coding or technical setup required.
                  </p>
                </div>
              </div>
            </div>

            <!-- Q9 -->
            <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-transparent border-0 mb-0"
              data-aos="fade-up">
              <h3 class="accordion-header d-flex align-items-center justify-content-between tw-gap-3">
                <button class="accordion-button shadow-none p-0 line-clamp-3 bg-transparent h5 collapsed"
                  type="button" data-bs-toggle="collapse" data-bs-target="#collapseNine"
                  aria-expanded="false" aria-controls="collapseNine">
                  Is my call data secure with <?php echo e(config('app.site')); ?>?
                </button>
              </h3>
              <div id="collapseNine" class="accordion-collapse collapse"
                data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 tw-leading-212 heading-medium">
                    Yes, security is a top priority. <?php echo e(config('app.site')); ?> uses end-to-end encryption and strict compliance protocols to keep your business and customer data safe.
                  </p>
                </div>
              </div>
            </div>

            <!-- Q10 -->
            <div class="accordion-item tw-py-8 tw-px-40-px tw-rounded-xl bg-transparent border-0 mb-0"
              data-aos="fade-up">
              <h3 class="accordion-header d-flex align-items-center justify-content-between tw-gap-3">
                <button class="accordion-button shadow-none p-0 line-clamp-3 bg-transparent h5 collapsed"
                  type="button" data-bs-toggle="collapse" data-bs-target="#collapseTen"
                  aria-expanded="false" aria-controls="collapseTen">
                  Can <?php echo e(config('app.site')); ?> help train my team?
                </button>
              </h3>
              <div id="collapseTen" class="accordion-collapse collapse"
                data-bs-parent="#accordionExample">
                <div class="accordion-body p-0 tw-mt-605 max-w-620-px">
                  <p class="text-neutral-500 tw-leading-212 heading-medium">
                    Definitely. <?php echo e(config('app.site')); ?> identifies performance patterns from real calls and provides insights that make employee training faster, smarter, and data-driven.
                  </p>
                </div>
              </div>
            </div>

          </div>
        </div>
      </div>
    </div>
  </div>
</section>


  <section class="py-50">
    <div class="container">
        <div class="text-center">
            <h3 class="main-heading text-capitalize mb-4">
              Transform Every Call Into a Growth Opportunity?
            </h3>
            <p class="max-w-780-px mx-auto tw-mb-6">
             Empower your team with Leadmine.pro — the AI-driven platform that analyzes every call, scores leads automatically, and helps you close deals faster.
            </p>

            <div class="d-flex flex-column align-items-center">
                <p class="fw-semibold tw-mb-4">
                    🔥 Don’t wait — start transforming your calls today. 
                    <a href="<?php echo e(route('register')); ?>"
                       class="btn btn-main hover-style-one tw-rounded-xl tw-px-4 tw-py-2 fw-medium text-capitalize ms-2">
                        👉 Get Started Now
                    </a>
                </p>
                  <p class="fw-semibold mt-3">Follow us on <a href="https://www.instagram.com/leadmine.pro/">Instagram</a>🔥</p>
                <p class="fw-semibold mt-3">Connect with us on <a href="https://www.linkedin.com/in/leadminepro/">LinkedIn</a>🔥</p>
            </div>
        </div>
    </div>
</section>



 <?php $__env->stopSection(); ?>
<?php echo $__env->make('website.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/leadmine/leadmine_pro/resources/views/website/fitness.blade.php ENDPATH**/ ?>