
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<!-- Firebase setup -->
<script type="module">
    import {
        initializeApp
    } from "https://www.gstatic.com/firebasejs/12.4.0/firebase-app.js";
    import {
        getMessaging,
        getToken,
        onMessage
    } from "https://www.gstatic.com/firebasejs/12.4.0/firebase-messaging.js";

    const firebaseConfig = {
        apiKey: "AIzaSyAEcO9dgmtSKCYupxlFyaPoCI_4ktzk6eQ",
        authDomain: "dialer-phonify-app.firebaseapp.com",
        projectId: "dialer-phonify-app",
        storageBucket: "dialer-phonify-app.firebasestorage.app",
        messagingSenderId: "984571065396",
        appId: "1:984571065396:web:835c27fbe50614499cc661",
        measurementId: "G-C6NKCY623V"
    };

    const app = initializeApp(firebaseConfig);
    const messaging = getMessaging(app);
    window.firebaseMessaging = messaging;

    // Base notification display logic
    onMessage(messaging, (payload) => {
        const {
            title = "Notification", body = "", icon = "/icon.png"
        } = payload.notification || {};

        if (Notification.permission === "granted") {
            new Notification(title, {
                body,
                icon
            });
        }

        Swal.mixin({
            toast: true,
            position: "top-end",
            showConfirmButton: false,
            timer: 5000,
            timerProgressBar: true,
        }).fire({
            icon: "info",
            title,
            text: body,
        });
    });
</script>

<script>
    async function requestPermissionAndRegister() {
        const messaging = window.firebaseMessaging;
        if (!messaging) return;

        const result = await Notification.requestPermission();
        if (result === "granted") {
            const {
                getToken
            } = await import("https://www.gstatic.com/firebasejs/12.4.0/firebase-messaging.js");
            const token = await getToken(messaging, {
                vapidKey: "BD91ljvvaDwT_NJSTecj8TTZ6_OG9WJm_gFmBtThaW0SMPK6gnir5YLFiRQTc0iN_qSFQTLpaI8Muw7XkS4FoXE",
            });
            if (token) {
                await fetch("/save-fcm-token", {
                    method: "POST",
                    headers: {
                        "Content-Type": "application/json",
                        "X-CSRF-TOKEN": document.querySelector('meta[name=\"csrf-token\"]').getAttribute(
                            "content"),
                    },
                    body: JSON.stringify({
                        token
                    }),
                });
                Swal.fire({
                    toast: true,
                    icon: "success",
                    position: "top-end",
                    title: "Notifications enabled",
                    timer: 2500,
                    showConfirmButton: false,
                });
            }
        } else {
            Swal.fire({
                toast: true,
                icon: "info",
                position: "top-end",
                title: "Enable notifications",
                text: "Click the lock icon in the browser and allow notifications.",
                timer: 6000,
                showConfirmButton: false,
            });
        }
    }

    // Check permission status on load
    document.addEventListener("DOMContentLoaded", () => {
        const state = Notification.permission;

        if (state === "default" || state === "denied") {
            const Toast = Swal.mixin({
                toast: true,
                position: "top-end",
                showConfirmButton: true,
                confirmButtonText: "Allow Notifications",
                showCancelButton: false,
                icon: "info",
            });

            Toast.fire({
                title: "Notifications are disabled",
                text: "Click below to enable notifications for alerts and updates.",
            }).then(async (result) => {
                if (result.isConfirmed) {
                    await requestPermissionAndRegister();
                }
            });
        }
    });

    // Register service worker
    if ("serviceWorker" in navigator) {
        navigator.serviceWorker.register("/firebase-messaging-sw.js")
            .then(() => console.log("Firebase service worker registered"));
    }
</script>
<?php /**PATH /var/www/html/leadmine/leadmine_pro/resources/views/layouts/push-notification.blade.php ENDPATH**/ ?>