<?php $__env->startSection('meta'); ?>
   <title>Retail Automation & Customer Engagement | <?php echo e(config('app.site')); ?></title>
<meta name="description" content="Boost retail sales with AI-driven automation. Improve customer engagement, streamline operations, and enhance store performance with <?php echo e(config('app.site')); ?>.">

<meta name="keywords" content="Retail customer support automation, AI retail solutions, AI product enquiry support">


<meta property="og:title" content="Retail Automation & Customer Engagement | <?php echo e(config('app.site')); ?>">
<meta property="og:description" content="Boost retail sales with AI-driven automation. Improve customer engagement, streamline operations, and enhance store performance with <?php echo e(config('app.site')); ?>.">
<meta property="og:image" content="<?php echo e(asset('web/assets/images/retail.webp')); ?>">
<meta property="og:type" content="website">
<meta property="og:url" content="<?php echo e(url()->current()); ?>">


<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Retail Automation & Customer Engagement | <?php echo e(config('app.site')); ?>">
<meta name="twitter:description" content="Boost retail sales with AI-driven automation. Improve customer engagement, streamline operations, and enhance store performance with <?php echo e(config('app.site')); ?>.">
<meta name="twitter:image" content="<?php echo e(asset('web/assets/images/retail.webp')); ?>">

<?php $__env->stopSection(); ?>








 <?php $__env->startSection('content'); ?>
<style>
.custom-img {
  margin-top: 180px;
}

 .paragraph-style {
  font-weight: 400;
  font-size: 18px;
}

.custom-heading {
  font-weight: 400;  
}

.max-width-40 {
  max-width: 40%;
}

@media (max-width: 768px) {
  .custom-img {
    margin-top: 50px;
  }
}
.pt-40 {
  padding-top: 40px;
}
.img-auto-warranty {
  max-height: 500px;
  width: 100%;
  object-fit: contain;
}

.img-deal-maxwidth{
  max-width: 35%;
}
.custom-padding-100 {
  padding: 100px 0;
}
.img-pitch-maxwidth {
  max-width: 30%;
}
.visually-hidden {
    position: absolute;
    width: 1px;
    height: 1px;
    padding: 0;
    margin: -1px;
    overflow: hidden;
    clip: rect(0, 0, 0, 0);
    white-space: nowrap;
    border: 0;
}
.as-h2 {
 font-size: clamp(1.5rem, 0.5569rem + 1.444vw, 1.875rem);
 }

.tw-mb-1{
 font-size: clamp(1.125rem, 1.2rem + 0.722vw, 1.5rem);
 }
</style>
 <!-- <section class="section-bg-two pb-50 overflow-hidden pt-40">
     <div class="container max-w-1290-px">
         <div class="row gy-5 align-items-center justify-content-center text-center">
             <div class="col-xl-12">
                 <div>
                     <div class="mx-auto tw-mb-12">
                          <h1 class="visually-hidden">Real Estate & Mortgage Intelligence</h1>
                         <h3 class="splitTextStyleOne text-heading heading-medium">
                             Real Estate & Mortgage Intelligence
                         </h3>
                         <p class="text-neutral-500 tw-mt-2 splitTextStyleOne max-w-770-px tw-text-lg mx-auto">
                             With real-time dashboards and performance scorecards, managers get a clear view of which
                             agents are driving deals—and who needs coaching.
                         </p>
                         <div class="tw-mt-2" data-aos="fade-up" data-aos-anchor-placement="top-bottom"
                             data-aos-duration="900">
                             <a href="<?php echo e(route('register')); ?>"
                                 class="hover--translate-y-1 active--translate-y-scale-9 btn button--stroke tw-gap-5 group active--translate-y-2 tw-rounded-xl text-capitalize tw-px-8 tw-py-505 fw-medium btn-main hover-style-one"
                                 data-block="button">
                                 <span class="button__flair"></span>
                                 <span class="button__label">Get started</span>
                             </a>
                         </div>
                     </div>
                 </div>
             </div>
         </div>
     </div>
 </section> -->
<section class="hero-section">
  <div class="hero-container">
    <div class="hero-left">
       <h1>Deliver Better Customer Experiences Anytime, Anywhere</h1>
         <p>
      Connect Leadmine.pro with your e-commerce tools to get a unified view of customer interactions. Deliver personalized customer service anytime, anywhere with advanced AI.
      </p>
      <div class="hero-badges">
      <span><i class="fa fa-check-circle"></i> No credit card required</span>
        <span><i class="fa fa-check-circle"></i> 14 days of <?php echo e(config('app.site')); ?> AI on us</span>
      </div>
    </div>

    <div class="hero-right">
      <div class="hero-image-wrapper">
        <img src="web/assets/images/retail.webp" alt="E-commerce customer service automation with AI calls and messaging">

    
      </div>
    </div>
  </div>
</section>

<style>
.hero-section {
  background: linear-gradient(rgba(255, 229, 154, 0.38) 0px, rgb(255, 255, 213) 100%);
  padding: 100px 0;
  font-family: "Inter", sans-serif;
}

.hero-container {
  max-width: 1250px;
  margin: auto;
  display: flex;
  align-items: center;
  justify-content: space-between;
  flex-wrap: wrap;
  gap: 70px;
}

.hero-left {
  flex: 1 1 520px;
}

.hero-left h1 {
  font-size: 40px;
  font-weight: 700;
  color: #1b1f3b;
  line-height: 1.25;
  margin-bottom: 25px;
  max-width: 500px;
}

.hero-left p {
  font-size: 18px;
  line-height: 1.7;
  color: #2b2b2b;
  margin-bottom: 35px;
  max-width: 520px;
  font-family: "Poppins", sans-serif; 
}

.hero-badges {
  display: flex;
  flex-wrap: wrap;
  gap: 20px;
  font-size: 16px;
  color: #1b1f3b;
}

.hero-badges i {
  color: #3b82f6;
  margin-right: 8px;
}

/* Right Side */
.hero-right {
  flex: 1 1 520px;
  display: flex;
  justify-content: center;
  position: relative;
}

.hero-image-wrapper {
  position: relative;
  width: 100%;
  max-width: 540px;
  border-radius: 20px;
  overflow: hidden;
  box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
}

.hero-image-wrapper img {
  width: 100%;
  display: block;
  object-fit: cover;
}

/* Agent Card */
.agent-card {
  position: absolute;
  top: 30px;
  left: 30px;
  background: #fff;
  border-radius: 16px;
  box-shadow: 0 6px 18px rgba(0, 0, 0, 0.1);
  padding: 16px 18px;
  max-width: 280px;
  border: 1px solid #e5e9ff;
}

.agent-card h4 {
  font-size: 15px;
  font-weight: 700;
  color: #1c2250;
  margin-bottom: 10px;
}

.agent-tabs {
  display: flex;
  gap: 6px;
  margin-bottom: 10px;
}

.agent-tabs .tab {
  flex: 1;
  font-size: 13px;
  text-align: center;
  padding: 6px 0;
  border-radius: 6px;
  background: #eef1ff;
  color: #4a4e74;
  font-weight: 600;
}

.agent-tabs .tab.active {
  background: #3b82f6;
  color: #fff;
}

.agent-message {
  font-size: 14px;
  color: #2b2b2b;
  background: #f9faff;
  padding: 12px;
  border-radius: 10px;
  line-height: 1.5;
  margin-bottom: 10px;
}

.agent-feedback {
  display: flex;
  justify-content: space-between;
  font-size: 13px;
  color: #3b82f6;
  font-weight: 600;
}

/* Responsive */
@media (max-width: 992px) {
  .hero-container {
    flex-direction: column;
    text-align: center;
  }

  .hero-left h1 {
    font-size: 36px;
    max-width: 100%;
  }

  .hero-left p {
    margin: 0 auto 30px;
  }

  .hero-badges {
    justify-content: center;
  }

  .hero-image-wrapper {
    margin-top: 40px;
  }

  .agent-card {
    position: static;
    margin: 20px auto 0;
  }
}

.secure-section {
  background: linear-gradient(180deg, #f2f4ff 0%, #ffffff 100%);
  padding: 100px 0;
  font-family: "Poppins", sans-serif; 
}

.secure-container {
  max-width: 1250px;
  margin: auto;
  display: flex;
  align-items: center;
  justify-content: space-between;
  flex-wrap: wrap;
  gap: 70px;
}

.secure-left {
  flex: 1 1 520px;
}

.secure-left h1 {
  font-size: 42px;
  font-weight: 800;
  color: #1b1f3b;
  line-height: 1.25;
  margin-bottom: 25px;
  max-width: 500px;
}

.secure-left p {
  font-size: 18px;
  line-height: 1.8;
  color: #2b2b2b;
  margin: 20px 0 30px 0; 
  max-width: 520px;
}

.secure-badges {
  display: flex;
  flex-wrap: wrap;
  gap: 20px;
  font-size: 16px;
  color: #1b1f3b;
}

.secure-badges i {
  color: #3b82f6;
  margin-right: 8px;
}

/* Right Side */
.secure-right {
  flex: 1 1 520px;
  display: flex;
  justify-content: center;
  position: relative;
}

.secure-image-wrapper {
  position: relative;
  width: 100%;
  max-width: 540px;
  border-radius: 20px;
  overflow: hidden;
  box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
  background: #fff;
}

.secure-image-wrapper img {
  width: 100%;
  display: block;
  object-fit: cover;
}


@media (max-width: 992px) {
  .secure-container {
    flex-direction: column;
    text-align: center;
  }

  .secure-left h1 {
    font-size: 34px;
    max-width: 100%;
  }

  .secure-left p {
    margin: 20px auto 30px; 
  }

  .secure-badges {
    justify-content: center;
  }

  .secure-image-wrapper {
    margin-top: 40px;
  }
}

</style>
<section class="toolkit-section py-5 bg-white">
  <div class="container">
    <h4 class="text-center mb-5 fw-bold">Features to get excited about</h4>

    <div class="toolkit-grid">

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-tty"></i></div>
        <h4>IVR</h4>
        <p>Set up IVR and quickly guide shoppers to purchase products or utilize coupons on the first interaction itself.</p>
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-route"></i></div>
        <h4>Intelligent Routing</h4>
        <p>Smartly route calls to the right expert and quickly resolve queries.</p>
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-robot"></i></div>
        <h4>AI Analysis</h4>
        <p>Recognize customer intent, track and analyze patterns with AI call and sentiment analysis.</p>
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-star-half-stroke"></i></div>
        <h4>Call Scores</h4>
        <p>Detect agent performance with AI-powered call scoring to coach your team and deliver superior caller experiences.</p>
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-clipboard-check"></i></div>
        <h4>After-Call Work</h4>
        <p>Automate after-call work with call disposition & automated note-taking.</p>
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-phone-volume"></i></div>
        <h4>Call Recording</h4>
        <p>Access call recordings to resurface customer conversations and gain insights.</p>
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-phone-forwarded"></i></div>
        <h4>Call Forwarding</h4>
        <p>Never let any consumer call go unnoticed with call forwarding. Forward calls to another number or voicemail.</p>
      </div>

      <div class="toolkit-item">
        <div class="icon"><i class="fa-solid fa-link"></i></div>
        <h4>CRM Integration</h4>
        <p>Integrate customer data across your tech stack with 100+ integrations using Leadmine.pro.</p>
      </div>

    </div>
  </div>
</section>




<!-- Font Awesome -->
<script src="https://kit.fontawesome.com/a2d9a67a2b.js" crossorigin="anonymous"></script>

<style>
.toolkit-section {
  background: #f7f7f9; 
  font-family: 'Poppins', sans-serif;
}

.toolkit-grid {
  display: grid;
  grid-template-columns: repeat(auto-fit, minmax(270px, 1fr));
  gap: 25px;
}

.toolkit-item {
  background: #fff;
  border: 1px solid #e5e7eb;
  border-radius: 12px;
  padding: 28px 24px;
  box-shadow: 0 4px 12px rgba(0,0,0,0.04);
  transition: all 0.3s ease;
  cursor: pointer;
  text-align: left;
}

.toolkit-item:hover {
  border-color: #3b82f6;
  box-shadow: 0 8px 22px rgba(59,130,246,0.1);
  transform: translateY(-4px);
}

.toolkit-item .icon {
  font-size: 30px;
  color: #0a5bff;
  margin-bottom: 18px;
}

.toolkit-item h4 {
  font-size: 18px;
  font-weight: 600;
  margin-bottom: 10px;
  color: #000;
}

.toolkit-item p {
  font-size: 15px;
  color: #444;
  line-height: 1.6;
  margin-bottom: 10px;
}

.learn-more {
  color: #0a5bff;
  font-weight: 500;
  font-size: 14px;
  text-decoration: none;
  transition: color 0.2s ease;
}

.learn-more:hover {
  color: #0044cc;
  text-decoration: underline;
}

@media (max-width: 768px) {
  .toolkit-item {
    padding: 22px 18px;
  }
}
</style>


<!-- ================== Driven section Start ====================== -->

<h2 class="main-heading text-center mb-4 mt-2">
  Purpose-built for the retail & e-commerce industry
</h2>

<section class="ai-section py-5">
  <div class="container">

    <!-- Section 1 -->
    <h3 class="sub-heading text-center mb-3">
      Optimized support
    </h3>
    <div class="row align-items-center mb-5 custom-gap-fix">
      <div class="col-lg-6">
        <p class="section-text">
          Gain insight into team performance by tracking KPIs such as calls per agent, average handling times, and call scores. Get a consolidated view of buyer records and purchase histories with seamless integrations.
        </p>
        <ul class="section-list">
          <li>Track KPIs — calls per agent, handling times, and scores</li>
          <li>Consolidated buyer data with CRM integrations</li>
          <li>Access old conversations & call recordings easily</li>
          <li>Monitor key topics in calls using AI-powered moments</li>
        </ul>
      </div>
      <div class="col-lg-6 text-center">
        <img src="<?php echo e(asset('web/assets/images/retail4.webp')); ?>" 
             alt="Retail analytics and customer support insights"
             class="img-fluid section-img">
      </div>
    </div>

    <!-- Section 2 -->
    <h3 class="sub-heading text-center mb-3">
      Automation & alerts
    </h3>
    <div class="row align-items-center mb-5 flex-row-reverse">
      <div class="col-lg-6">
        <p class="section-text">
          Set up SMS workflows to send automated alerts based on CRM notifications. Receive AI-powered call summaries and action items for timely follow-ups and improved buyer management with SMS automation and bots.
        </p>
        <ul class="section-list">
          <li>Automated SMS alerts from CRM notifications</li>
          <li>AI call summaries and action items</li>
          <li>Buyer management with SMS automation & bots</li>
          <li>Auto-log customer data to minimize manual errors</li>
        </ul>
      </div>
      <div class="col-lg-6 text-center">
        <img src="<?php echo e(asset('web/assets/images/retail1.webp')); ?>" 
             alt="Retail automation and CRM alerts"
             class="img-fluid section-img">
      </div>
    </div>

    <!-- Section 3 -->
    <h3 class="sub-heading text-center mb-3">
      Security
    </h3>
    <div class="row align-items-center mb-5 custom-gap-fix">
      <div class="col-lg-6">
        <p class="section-text">
          Secure customer and business data with top-tier encryption. Protect calls, meetings, and messages, and manage access securely through single sign-on and role-based permissions.
        </p>
        <ul class="section-list">
          <li>Advanced data encryption for complete privacy</li>
          <li>Protection across calls, meetings, and texts</li>
          <li>Single sign-on for secure authentication</li>
          <li>Role-based access permissions</li>
        </ul>
      </div>
      <div class="col-lg-6 text-center">
        <img src="<?php echo e(asset('web/assets/images/retail2.webp')); ?>" 
             alt="Retail data security and encryption"
             class="img-fluid section-img">
      </div>
    </div>

    <!-- Section 4 -->
    <h3 class="sub-heading text-center mb-3">
      Data & insights
    </h3>
    <div class="row align-items-center mb-4 flex-row-reverse">
      <div class="col-lg-6">
        <p class="section-text">
          Gain real-time insights into team and customer performance. Review call analytics, revisit conversations, and monitor topics that matter most to your business using AI-powered insights.
        </p>
        <ul class="section-list">
          <li>Track team KPIs and call performance</li>
          <li>Access buyer records and purchase histories</li>
          <li>Revisit conversations and call summaries</li>
          <li>Use AI moments to identify key discussion points</li>
        </ul>
      </div>
      <div class="col-lg-6 text-center">
        <img src="<?php echo e(asset('web/assets/images/funding.webp')); ?>" 
             alt="Retail data analytics and performance tracking"
             class="img-fluid section-img">
      </div>
    </div>

    <div class="text-center mt-4">
      <a href="https://leadmine.pro" class="btn btn-primary px-4 py-2 rounded-pill">Start Free Trial</a>
    </div>

  </div>
</section>





<!-- CSS -->
<style>
.main-heading {
  font-size: 2.2rem;
  font-weight: 700;
  color: #000; 
}

.ai-section {
  background: #0b1a33;
  color: #fff;
  padding: 50px 0;
}

.sub-heading {
  font-size: 1.4rem;
  font-weight: 600;
  margin-bottom: 6px; 
}

.section-text {
  font-size: 1rem;
  line-height: 1.6;
  margin-bottom: 8px;
  max-width: 440px;  
  text-align: left; 
}


.section-list {
  padding-left: 18px;
  margin-bottom: 8px;
}

.section-list li {
  margin-bottom: 5px;
  list-style: disc;
}

.section-link {
  color: #4e9eff;
  font-weight: 600;
  text-decoration: none;
}

.section-link:hover {
  text-decoration: underline;
}


.section-img {
  max-width: 390px;
  width: 100%;
  height: auto;
  border-radius: 6px;
  box-shadow: 0 3px 12px rgba(0,0,0,0.25);
  margin: 0 auto;
}


.row.align-items-center {
  display: flex;
  justify-content: space-between;  
  align-items: center;
  margin: 0;  
}



.row.align-items-center .col-lg-6 {
  flex: 0 0 auto;
  width: 50%;
  max-width: 50%;
  padding: 0 15px;  
}


.custom-gap-fix .col-lg-6:first-child {
  padding-left: 200px !important;
}


@media (max-width: 991px) {
  .custom-gap-fix .col-lg-6:first-child {
    padding-left: 0 !important;
  }
}




.row.align-items-center.flex-row-reverse {
  flex-direction: row-reverse;
}


@media (max-width: 991px) {
  .row.align-items-center,
  .row.align-items-center.flex-row-reverse {
    flex-direction: column;
  }

  .row.align-items-center .col-lg-6 {
    width: 100%;
    max-width: 100%;
    padding: 0;  
  }

  .section-img {
    margin-top: 12px;
    max-width: 100%;
  }
}

/* Tablet only (768px - 991px) */
@media (min-width: 768px) and (max-width: 991px) {
  .section-img {
    max-width: 65%;
    margin: 15px auto;
    display: block;
  }

  .section-text {
    max-width: 80%;
    margin: 0 auto 12px;
    font-size: 0.95rem;
    line-height: 1.5;
    text-align: center;
  }

  .section-list {
    max-width: 80%;
    margin: 0 auto 12px;
    padding-left: 0;
    list-style-position: inside;
    text-align: center; 
  }

  .section-list li {
    display: block;
    text-align: center;
    margin: 6px 0;
  }

  .section-link {
    display: block;
    text-align: center;
    margin-top: 10px;
    font-size: 0.95rem;
    word-break: break-word;
  }

  .sub-heading {
    font-size: 1.2rem;
    text-align: center;
    margin-bottom: 10px;
  }

  .main-heading {
    font-size: 1.8rem;
    text-align: center;
    margin-bottom: 12px;
  }

}


</style>




<!-- Font Awesome -->
<script src="https://kit.fontawesome.com/a2d9a67a2b.js" crossorigin="anonymous"></script>

<style>
.toolkit-section {
  background: #f7f7f9; 
  font-family: 'Poppins', sans-serif;
}

.toolkit-grid {
  display: grid;
  grid-template-columns: repeat(auto-fit, minmax(270px, 1fr));
  gap: 25px;
}

.toolkit-item {
  background: #fff;
  border: 1px solid #e5e7eb;
  border-radius: 12px;
  padding: 28px 24px;
  box-shadow: 0 4px 12px rgba(0,0,0,0.04);
  transition: all 0.3s ease;
  cursor: pointer;
}

.toolkit-item:hover {
  border-color: #3b82f6;
  box-shadow: 0 8px 22px rgba(59,130,246,0.1);
  transform: translateY(-4px);
}


.toolkit-item .icon {
  font-size: 30px;
  color: #0a5bff;
  margin-bottom: 18px;
}


.toolkit-item h4 {
  font-size: 18px;
  font-weight: 600;
  margin-bottom: 10px;
  color: #000;
}

.toolkit-item p {
  font-size: 15px;
  color: #444;
  line-height: 1.6;
}

@media (max-width: 768px) {
  .toolkit-item {
    padding: 22px 18px;
  }
}
</style>


<!-- ================== About Features section Start ====================== -->
<section class="about-features py-120 section-bg-two">
    <div class="container">
        <div class="d-flex align-items-center justify-content-between flex-wrap tw-gap-6 tw-mb-12">
            <div class="max-w-532-px">
                <h4 class="splitTextStyleOne text-capitalize as-h5">
                    Why retail and e-commerce businesses trust Leadmine.pro
                </h4>
            </div>
            <div data-aos="fade-up" data-aos-anchor-placement="top-bottom" data-aos-duration="800">
                <p class="splitTextStyleOne max-w-490-px fw-medium tw-ps-5 border-start border-app-landing border-2">
                    Empower your business with AI-driven communication tools that optimize every customer interaction, enhance team performance, and deliver exceptional shopping experiences.
                </p>
            </div>
        </div>

        <div class="row gy-4">
            <!-- 1 -->
            <div class="col-xl-3 col-sm-6" data-aos="fade-up" data-aos-anchor-placement="top-bottom" data-aos-duration="600">
                <div class="tw-rounded-2xl bg-white bg-hover-app-landing tw-py-14 tw-px-7 border border-neutral-200 group animation-item tw-transition tw-duration-200 h-100">
                    <span class="tw-w-92-px tw-h-92-px rounded-circle d-flex align-items-center justify-content-center common-shadow-fifteen tw-mb-11">
                        <img src="web/assets/images/icons/about-features-icon1.svg" alt="Reduced Resolution Times Icon" class="group-hover-item-text-invert tw-transition tw-duration-200 animate__heartBeat">
                    </span>
                    <h5 class="splitTextStyleOne tw-mb-7 group-hover-text-white tw-transition tw-duration-200 as-h5">
                        Reduced Resolution Times
                    </h5>
                    <p class="splitTextStyleOne group-hover-text-white fw-medium tw-transition tw-duration-200">
                        Transfer customers to the right agent with intelligent call routing. Resolve queries in the first call and deliver a delightful experience.
                    </p>
                </div>
            </div>

            <!-- 2 -->
            <div class="col-xl-3 col-sm-6" data-aos="fade-up" data-aos-anchor-placement="top-bottom" data-aos-duration="800">
                <div class="tw-rounded-2xl bg-white bg-hover-app-landing tw-py-14 tw-px-7 border border-neutral-200 group animation-item tw-transition tw-duration-200 h-100">
                    <span class="tw-w-92-px tw-h-92-px rounded-circle d-flex align-items-center justify-content-center common-shadow-fifteen tw-mb-11">
                        <img src="web/assets/images/icons/about-features-icon2.svg" alt="Auto-synced Data Icon" class="group-hover-item-text-invert tw-transition tw-duration-200 animate__heartBeat">
                    </span>
                    <h5 class="splitTextStyleOne tw-mb-7 group-hover-text-white tw-transition tw-duration-200 as-h5">
                        Auto-synced Data & Customer History
                    </h5>
                    <p class="splitTextStyleOne group-hover-text-white fw-medium tw-transition tw-duration-200">
                        Save time and personalize communications by accessing customer history across your existing tech stack.
                    </p>
                </div>
            </div>

            <!-- 3 -->
            <div class="col-xl-3 col-sm-6" data-aos="fade-up" data-aos-anchor-placement="top-bottom" data-aos-duration="1000">
                <div class="tw-rounded-2xl bg-white bg-hover-app-landing tw-py-14 tw-px-7 border border-neutral-200 group animation-item tw-transition tw-duration-200 h-100">
                    <span class="tw-w-92-px tw-h-92-px rounded-circle d-flex align-items-center justify-content-center common-shadow-fifteen tw-mb-11">
                        <img src="web/assets/images/icons/about-features-icon3.svg" alt="Advanced Analytics Icon" class="group-hover-item-text-invert tw-transition tw-duration-200 animate__heartBeat">
                    </span>
                    <h5 class="splitTextStyleOne tw-mb-7 group-hover-text-white tw-transition tw-duration-200 as-h5">
                        Advanced Analytics
                    </h5>
                    <p class="splitTextStyleOne group-hover-text-white fw-medium tw-transition tw-duration-200">
                        Track every conversation in a comprehensive dashboard, understand call volumes, and make data-driven decisions.
                    </p>
                </div>
            </div>

            <!-- 4 -->
            <div class="col-xl-3 col-sm-6" data-aos="fade-up" data-aos-anchor-placement="top-bottom" data-aos-duration="1200">
                <div class="tw-rounded-2xl bg-white bg-hover-app-landing tw-py-14 tw-px-7 border border-neutral-200 group animation-item tw-transition tw-duration-200 h-100">
                    <span class="tw-w-92-px tw-h-92-px rounded-circle d-flex align-items-center justify-content-center common-shadow-fifteen tw-mb-11">
                        <img src="web/assets/images/icons/about-features-icon4.svg" alt="AI-powered Insights Icon" class="group-hover-item-text-invert tw-transition tw-duration-200 animate__heartBeat">
                    </span>
                    <h5 class="splitTextStyleOne tw-mb-7 group-hover-text-white tw-transition tw-duration-200 as-h5">
                        AI-powered Insights & Coaching
                    </h5>
                    <p class="splitTextStyleOne group-hover-text-white fw-medium tw-transition tw-duration-200">
                        Onboard and upskill team members with AI-driven call coaching. Ensure 5-star customer service with real-time sentiment and performance analysis.
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- ================== About Features section End ====================== -->



  <section class="integrations-section">
  <div class="container">
    <h2 class="section-title">Fits seamlessly into your tech stack</h2>

    <div class="integration-logos">
      <div class="logo-box">
        <img src="web/assets/images/hubspot.svg" alt="HubSpot">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/salesforce.svg" alt="Salesforce">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/pipedrive.svg" alt="Pipedrive">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/slack.svg" alt="Slack">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/intercom.svg" alt="Intercom">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/zendesk-icon.svg" alt="Zendesk">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/zoho.svg" alt="Zoho">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/outreach.webp" alt="Outreach">
      </div>
    </div>

    <div class="btn-wrapper">
      <a href="<?php echo e(route('register')); ?>" class="view-btn">Start free trial</a>
    </div>
  </div>
</section>


<style>
.integrations-section {
  text-align: center;
  padding: 80px 20px;
  background-color: #fff;
}

.integrations-section .section-title {
  font-size: 32px;
  font-weight: 700;
  color: #0b0c2a;
  margin-bottom: 50px;
}

.integration-logos {
  display: flex;
  flex-wrap: wrap;
  justify-content: center;
  gap: 25px;
  margin-bottom: 50px;
}

.logo-box {
  width: 140px;
  height: 140px;
  background: #fff;
  border-radius: 20px;
  box-shadow: 0 0 0 1px #e5e7eb;
  display: flex;
  align-items: center;
  justify-content: center;
  transition: all 0.3s ease;
}

.logo-box img {
  width: 60px;
  height: auto;
  transition: transform 0.3s ease;
}

.logo-box:hover {
  transform: translateY(-8px);
  box-shadow: 0 8px 25px rgba(0, 0, 0, 0.08);
}

.logo-box:hover img {
  transform: scale(1.1);
}

.view-btn {
  display: inline-block;
  background-color: #0052ff;
  color: #fff;
  font-weight: 600;
  padding: 14px 28px;
  border-radius: 8px;
  text-decoration: none;
  transition: background 0.3s ease;
}

.view-btn:hover {
  background-color: #003ed6;
}

.btn-wrapper {
  margin-top: 20px;
}
</style>



 <?php $__env->stopSection(); ?>
<?php echo $__env->make('website.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/leadmine/leadmine_pro/resources/views/website/retail.blade.php ENDPATH**/ ?>