<?php $__env->startSection('meta'); ?>
    <title><?php echo e(config('app.site')); ?> India Pricing | Affordable Business Telephony</title>
    <meta name="description" content="LeadMine India pricing — ₹5,000/month subscription unlocks CRM, call recording, analytics & more. Call charges at just ₹6/min. Start free.">
    <meta name="keywords" content="LeadMine India pricing, business telephony India, inbound outbound calling India, CRM India, call recording software India, call center software India">

    
    <meta property="og:title" content="<?php echo e(config('app.site')); ?> India Pricing | Affordable Business Telephony">
    <meta property="og:description" content="₹5,000/month subscription + ₹6/min call charges. Full telephony, CRM, call recording & analytics for Indian businesses.">
    <meta property="og:image" content="<?php echo e(asset('assets/images/favicon-two.webp')); ?>">
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?php echo e(url()->current()); ?>">

    
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="<?php echo e(config('app.site')); ?> India Pricing | Affordable Business Telephony">
    <meta name="twitter:description" content="₹5,000/month subscription + ₹6/min call charges. Full telephony, CRM, call recording & analytics for Indian businesses.">
    <meta name="twitter:image" content="<?php echo e(asset('assets/images/favicon-two.webp')); ?>">
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>

<style>
/* Hide the shared "Ready to Add AI Voice" CTA on this page */
.footer-five { display: none; }

/* ===== Base ===== */
.custom-section-padding { padding: 50px 0; }
.heading-privacy-title { font-size: 32px; font-weight: 500; }
.visually-hidden { position: absolute; width: 1px; height: 1px; padding: 0; margin: -1px; overflow: hidden; clip: rect(0,0,0,0); white-space: nowrap; border: 0; }

/* ===== Hero subtitle ===== */
.in-hero-sub { font-size: 17px; max-width: 640px; margin: 0 auto; color: #6b7280; }
.in-hero-sub strong { color: #111827; }

/* ===== How It Works banner ===== */
.in-how-banner { background: #eff6ff; border: 1px solid #bfdbfe; border-radius: 12px; padding: 28px 32px; margin-top: 36px; }
.in-how-banner p { margin: 0; font-size: 15px; color: #1e3a5f; line-height: 1.7; }
.in-how-banner strong { color: #1e40af; }

/* ===== Section helpers ===== */
.in-section { padding: 70px 0; }
.in-section-alt { background: #f8fafc; padding: 70px 0; }
.in-section-title { font-size: 28px; font-weight: 600; color: #111827; margin-bottom: 12px; }
.in-section-subtitle { font-size: 16px; color: #6b7280; max-width: 640px; margin: 0 auto 40px; }
.in-divider { height: 1px; background: #e5e7eb; margin: 24px 0; }
.in-micro-copy { font-size: 13px; color: #6b7280; margin-top: 6px; }

/* ===== Pricing cards ===== */
.in-pricing-card { background: #fff; border-radius: 16px; border: 1px solid #e5e7eb; padding: 40px 32px; transition: all 0.3s ease; height: 100%; display: flex; flex-direction: column; }
.in-pricing-card:hover { transform: translateY(-6px); box-shadow: 0 12px 32px rgba(0,0,0,0.08); }
.in-pricing-card.in-recommended { border: 2px solid #0d6efd; position: relative; box-shadow: 0 8px 30px rgba(13,110,253,0.12); }
.in-pricing-card.in-basic { border: 1px solid #e5e7eb; }

.in-pricing-badge { display: inline-block; font-size: 12px; font-weight: 700; padding: 5px 14px; border-radius: 20px; text-transform: uppercase; letter-spacing: 0.5px; }
.in-badge-rec { background: #0d6efd; color: #fff; }
.in-badge-basic { background: #f3f4f6; color: #6b7280; }
.in-badge-offer { background: #dc2626; color: #fff; animation: in-pulse 2s ease-in-out infinite; }
@keyframes in-pulse { 0%,100% { opacity: 1; } 50% { opacity: 0.85; } }

/* Discount pricing */
.in-price-original { font-size: 20px; color: #9ca3af; text-decoration: line-through; font-weight: 500; margin-bottom: 2px; }
.in-price-save { display: inline-block; background: #dcfce7; color: #166534; font-size: 13px; font-weight: 600; padding: 4px 12px; border-radius: 6px; margin-top: 8px; }

.in-plan-name { font-size: 22px; font-weight: 700; color: #111827; margin: 12px 0 4px; }
.in-plan-tagline { font-size: 14px; color: #6b7280; margin-bottom: 0; }

.in-price-amount { font-size: 44px; font-weight: 700; color: #111827; line-height: 1.2; }
.in-price-currency { font-size: 24px; vertical-align: super; }
.in-price-period { font-size: 16px; font-weight: 400; color: #6b7280; }

/* Feature rows inside cards */
.in-feature-item { display: flex; align-items: flex-start; gap: 10px; margin-bottom: 11px; font-size: 14.5px; color: #374151; }
.in-feature-item i { font-size: 15px; margin-top: 3px; flex-shrink: 0; }
.in-feature-item .fa-check-circle { color: #10b981; }
.in-feature-item .fa-times-circle { color: #ef4444; }
.in-feature-item .fa-minus-circle { color: #d1d5db; }
.in-feature-item span.in-dim { color: #9ca3af; }

.in-card-footer { margin-top: auto; }

/* ===== Call charge explainer ===== */
.in-call-box { background: #fff; border: 1px solid #e5e7eb; border-radius: 14px; padding: 32px 28px; text-align: center; }
.in-call-box h4 { font-size: 18px; font-weight: 600; color: #111827; margin-bottom: 6px; }
.in-call-box .in-rate { font-size: 36px; font-weight: 700; color: #0d6efd; }
.in-call-box .in-rate-sub { font-size: 14px; color: #6b7280; }
.in-call-pills { display: flex; flex-wrap: wrap; gap: 10px; justify-content: center; margin-top: 16px; }
.in-call-pill { background: #f0fdf4; border: 1px solid #bbf7d0; border-radius: 8px; padding: 8px 16px; font-size: 13px; color: #166534; font-weight: 500; }

/* ===== Comparison table ===== */
.in-compare-table { width: 100%; border-collapse: separate; border-spacing: 0; border-radius: 12px; overflow: hidden; border: 1px solid #e5e7eb; background: #fff; }
.in-compare-table thead th { background: #f8fafc; padding: 16px 20px; font-size: 15px; font-weight: 700; color: #111827; text-align: center; border-bottom: 2px solid #e5e7eb; }
.in-compare-table thead th:first-child { text-align: left; }
.in-compare-table thead th.in-th-rec { background: #eff6ff; color: #1e40af; }
.in-compare-table tbody td { padding: 14px 20px; font-size: 14px; color: #374151; border-bottom: 1px solid #f3f4f6; text-align: center; vertical-align: middle; }
.in-compare-table tbody td:first-child { text-align: left; font-weight: 500; color: #111827; }
.in-compare-table tbody tr:last-child td { border-bottom: none; }
.in-compare-table .in-check { color: #10b981; font-size: 17px; }
.in-compare-table .in-cross { color: #ef4444; font-size: 17px; }
.in-compare-table .in-limited { color: #f59e0b; font-size: 13px; font-weight: 500; }

/* ===== Why section ===== */
.in-why-item { display: flex; gap: 16px; margin-bottom: 24px; }
.in-why-item .num { width: 36px; height: 36px; border-radius: 50%; background: #eff6ff; color: #2563eb; display: flex; align-items: center; justify-content: center; font-weight: 700; font-size: 15px; flex-shrink: 0; }
.in-why-item h5 { font-size: 16px; font-weight: 600; color: #111827; margin-bottom: 4px; }
.in-why-item p { font-size: 14px; color: #6b7280; margin: 0; line-height: 1.5; }

/* ===== FAQ ===== */
.in-faq-item { background: #fff; border: 1px solid #e5e7eb; border-radius: 12px; margin-bottom: 12px; overflow: hidden; }
.in-faq-question { padding: 18px 24px; font-size: 16px; font-weight: 600; color: #111827; cursor: pointer; display: flex; justify-content: space-between; align-items: center; background: none; border: none; width: 100%; text-align: left; }
.in-faq-question:hover { background: #f9fafb; }
.in-faq-question i { transition: transform 0.3s ease; color: #6b7280; }
.in-faq-question.active i { transform: rotate(180deg); }
.in-faq-answer { padding: 0 24px 18px; font-size: 14px; color: #6b7280; line-height: 1.7; display: none; }
.in-faq-answer.active { display: block; }

/* ===== CTA ===== */
.in-cta-section { background: linear-gradient(135deg, #1e40af, #3b82f6); padding: 60px 0; color: #fff; }
.in-cta-section h3 { font-size: 28px; font-weight: 600; margin-bottom: 12px; }
.in-cta-section p { font-size: 16px; opacity: 0.9; margin-bottom: 28px; }
.in-btn-white { background: #fff; color: #1e40af; border: none; padding: 12px 28px; border-radius: 8px; font-weight: 600; font-size: 15px; text-decoration: none; display: inline-block; transition: all 0.3s ease; }
.in-btn-white:hover { background: #f0f4ff; color: #1e40af; transform: translateY(-2px); }
.in-btn-outline-white { background: transparent; color: #fff; border: 2px solid rgba(255,255,255,0.5); padding: 10px 28px; border-radius: 8px; font-weight: 600; font-size: 15px; text-decoration: none; display: inline-block; transition: all 0.3s ease; }
.in-btn-outline-white:hover { border-color: #fff; background: rgba(255,255,255,0.1); color: #fff; transform: translateY(-2px); }

/* ===== Trust badges ===== */
.in-trust-badges { display: flex; gap: 32px; justify-content: center; flex-wrap: wrap; margin-top: 32px; }
.in-trust-badge { display: flex; align-items: center; gap: 8px; font-size: 14px; color: #374151; }
.in-trust-badge i { color: #10b981; font-size: 16px; }

/* ===== Sales one-liner strip ===== */
.in-oneliner { background: #fefce8; border: 1px solid #fde68a; border-radius: 10px; padding: 18px 24px; text-align: center; font-size: 15px; color: #92400e; font-weight: 500; line-height: 1.6; }

/* ===== Responsive ===== */
@media (max-width: 991px) {
    .in-compare-table { font-size: 13px; }
    .in-compare-table thead th, .in-compare-table tbody td { padding: 12px 14px; }
}
@media (max-width: 767px) {
    .in-pricing-card { padding: 28px 20px; }
    .in-price-amount { font-size: 36px; }
    .in-section, .in-section-alt { padding: 50px 0; }
    .in-section-title { font-size: 24px; }
    .in-how-banner { padding: 20px; }
    .in-compare-table thead th, .in-compare-table tbody td { padding: 10px 10px; font-size: 12.5px; }
}
</style>

<div id="smooth-wrapper">
<div id="smooth-content bg-light">

<!-- ==================== Hero Section ==================== -->
<section class="section-bg-two mb-0 custom-section-padding">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-9">
                <div class="text-center">
                    <span class="tw-mb-4">
                        <img src="<?php echo e(asset('web/assets/images/favicon-two.webp')); ?>" alt="LeadMine">
                    </span>
                    <h1 class="visually-hidden">LeadMine India Pricing</h1>
                    <h3 class="mb-3 splitTextStyleOne text-capitalize heading-privacy-title">
                        Simple Pricing. Powerful Platform.
                    </h3>
                    <p class="in-hero-sub">
                        Make calls at <strong>₹6/minute</strong>. Unlock the full business platform for <strong>₹5,000/month</strong>.<br>
                        Subscription is for platform access. Call charges are usage-based.
                    </p>

                    <!-- How it works banner -->
                    <div class="in-how-banner text-start" data-aos="fade-up" data-aos-duration="600">
                        <p>
                            <strong><i class="fa-solid fa-circle-info me-1"></i> How pricing works:</strong><br>
                            <strong>Call charges (₹6/min)</strong> apply to everyone — with or without a subscription. This is your usage cost for inbound and outbound calls.<br>
                            <strong>Subscription (₹5,000/month)</strong> unlocks the full platform — dashboard, CRM, reports, recordings, team management, and analytics. Without it, you get basic calling only.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- ==================== Two Plan Cards ==================== -->
<section class="in-section">
    <div class="container">

        <!-- One-liner -->
        <div class="row justify-content-center mb-5">
            <div class="col-lg-9">
                <div class="in-oneliner" data-aos="fade-up" data-aos-duration="400">
                    Without subscription you can make calls. With subscription you run a call business.
                </div>
            </div>
        </div>

        <div class="row gy-4 justify-content-center">

            <!-- ===== PLAN A: Without Subscription ===== -->
            <div class="col-lg-5 col-md-6" data-aos="fade-up" data-aos-duration="600">
                <div class="in-pricing-card in-basic">
                    <div class="text-center">
                        <span class="in-pricing-badge in-badge-basic">Basic</span>
                        <h4 class="in-plan-name">Without Subscription</h4>
                        <p class="in-plan-tagline">For testing or very small usage</p>
                        <div class="in-divider"></div>
                        <div class="in-price-amount">
                            <span class="in-price-currency">₹</span>0
                            <span class="in-price-period">/month</span>
                        </div>
                        <p class="in-micro-copy">Only pay ₹6/min for calls you make</p>
                    </div>

                    <div class="in-divider"></div>

                    <div>
                        <p style="font-size:13px; font-weight:600; color:#6b7280; text-transform:uppercase; letter-spacing:0.5px; margin-bottom:14px;">What you get</p>
                        <div class="in-feature-item"><i class="fa-solid fa-check-circle"></i><span>Inbound & Outbound Calls</span></div>
                        <div class="in-feature-item"><i class="fa-solid fa-check-circle"></i><span>Basic Dialler Access</span></div>
                        <div class="in-feature-item"><i class="fa-solid fa-minus-circle"></i><span class="in-dim">Limited Dashboard — basic view only</span></div>
                        <div class="in-feature-item"><i class="fa-solid fa-times-circle"></i><span class="in-dim">No Call Recording or Recording Files</span></div>
                        <div class="in-feature-item"><i class="fa-solid fa-times-circle"></i><span class="in-dim">No Advanced Reports</span></div>
                        <div class="in-feature-item"><i class="fa-solid fa-times-circle"></i><span class="in-dim">No CRM or Lead Management</span></div>
                        <div class="in-feature-item"><i class="fa-solid fa-times-circle"></i><span class="in-dim">No Team / Multi-Agent Management</span></div>
                        <div class="in-feature-item"><i class="fa-solid fa-times-circle"></i><span class="in-dim">No Analytics or Performance Metrics</span></div>
                        <div class="in-feature-item"><i class="fa-solid fa-minus-circle"></i><span class="in-dim">Email Support Only</span></div>
                    </div>

                    <div class="in-card-footer">
                        <div class="in-divider"></div>
                        <a href="<?php echo e(route('register')); ?>" class="btn btn-outline-secondary d-flex align-items-center justify-content-center tw-rounded-md tw-py-6 fw-bold" style="border-radius:8px;">
                            <span>Try Basic</span>
                        </a>
                        <p class="in-micro-copy mt-2 text-center">Good for quick trials only</p>
                    </div>
                </div>
            </div>

            <!-- ===== PLAN B: With Subscription (Recommended) ===== -->
            <div class="col-lg-5 col-md-6" data-aos="fade-up" data-aos-duration="800">
                <div class="in-pricing-card in-recommended">
                    <div class="text-center">
                        <span class="in-pricing-badge in-badge-offer">Limited-Time Offer</span>
                        <span class="in-pricing-badge in-badge-rec ms-1">Recommended for Business</span>
                        <h4 class="in-plan-name">With Subscription</h4>
                        <p class="in-plan-tagline">For serious companies & call centres</p>
                        <div class="in-divider"></div>
                        <div class="in-price-original">₹7,500 /month</div>
                        <div class="in-price-amount">
                            <span class="in-price-currency">₹</span>5,000
                            <span class="in-price-period">/month</span>
                        </div>
                        <p class="in-micro-copy">Now only ₹5,000/month — originally ₹7,500/month</p>
                        <span class="in-price-save">You save ₹2,500 every month</span>
                    </div>

                    <div class="in-divider"></div>

                    <div>
                        <p style="font-size:13px; font-weight:600; color:#1e40af; text-transform:uppercase; letter-spacing:0.5px; margin-bottom:14px;">Everything unlocked</p>
                        <div class="in-feature-item"><i class="fa-solid fa-check-circle"></i><span>Inbound & Outbound Calls</span></div>
                        <div class="in-feature-item"><i class="fa-solid fa-check-circle"></i><span>Full Dashboard — real-time live view</span></div>
                        <div class="in-feature-item"><i class="fa-solid fa-check-circle"></i><span>Complete Call Recording & Storage</span></div>
                        <div class="in-feature-item"><i class="fa-solid fa-check-circle"></i><span>Advanced Reports & Data Export</span></div>
                        <div class="in-feature-item"><i class="fa-solid fa-check-circle"></i><span>CRM & Lead Management</span></div>
                        <div class="in-feature-item"><i class="fa-solid fa-check-circle"></i><span>Multi-Agent & Team Management</span></div>
                        <div class="in-feature-item"><i class="fa-solid fa-check-circle"></i><span>Analytics & Performance Metrics</span></div>
                        <div class="in-feature-item"><i class="fa-solid fa-check-circle"></i><span>User Roles & Permissions</span></div>
                        <div class="in-feature-item"><i class="fa-solid fa-check-circle"></i><span>Priority Support</span></div>
                    </div>

                    <div class="in-card-footer">
                        <div class="in-divider"></div>
                        <a href="<?php echo e(route('register')); ?>" class="btn btn-main hover-style-one d-flex align-items-center justify-content-center tw-gap-5 tw-px-13 tw-rounded-md tw-py-6 fw-bold">
                            <span class="button__label">Start Free Trial</span>
                        </a>
                        <p class="in-micro-copy mt-2 text-center">No credit card required. Cancel anytime.</p>
                    </div>
                </div>
            </div>

        </div>

        <!-- Call Charges Explainer -->
        <div class="row justify-content-center mt-5">
            <div class="col-lg-10">
                <div class="in-call-box" data-aos="fade-up" data-aos-duration="600">
                    <h4><i class="fa-solid fa-phone me-2" style="color:#0d6efd;"></i>Call Charges — Same for Both Plans</h4>
                    <div class="in-rate">₹6 <span style="font-size:18px; font-weight:400; color:#6b7280;">/minute</span></div>
                    <p class="in-rate-sub">You will be charged ₹6 for every minute of call usage — inbound or outbound.</p>
                    <div class="in-call-pills">
                        <span class="in-call-pill"><i class="fa-solid fa-check me-1"></i> No hidden charges</span>
                        <span class="in-call-pill"><i class="fa-solid fa-check me-1"></i> Pay only for what you use</span>
                        <span class="in-call-pill"><i class="fa-solid fa-check me-1"></i> Prepaid wallet model</span>
                        <span class="in-call-pill"><i class="fa-solid fa-check me-1"></i> Auto-recharge available</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Trust Badges -->
        <div class="in-trust-badges mt-4" data-aos="fade-up" data-aos-duration="600">
            <div class="in-trust-badge"><i class="fa-solid fa-shield-halved"></i> Secure Payments</div>
            <div class="in-trust-badge"><i class="fa-solid fa-lock"></i> Data Encrypted</div>
            <div class="in-trust-badge"><i class="fa-solid fa-headset"></i> Dedicated Support</div>
            <div class="in-trust-badge"><i class="fa-solid fa-indian-rupee-sign"></i> INR Billing</div>
        </div>
    </div>
</section>

<!-- ==================== Comparison Table ==================== -->
<section class="in-section-alt">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="in-section-title">Side-by-Side Comparison</h2>
            <p class="in-section-subtitle">See exactly what you get with and without a subscription. Same call rate, very different platform experience.</p>
        </div>

        <div class="row justify-content-center">
            <div class="col-lg-10" data-aos="fade-up" data-aos-duration="600">
                <div class="table-responsive">
                    <table class="in-compare-table">
                        <thead>
                            <tr>
                                <th style="width:40%;">Feature</th>
                                <th style="width:30%;">Without Subscription<br><small style="font-weight:400; color:#6b7280;">₹0/month</small></th>
                                <th class="in-th-rec" style="width:30%;">With Subscription<br><small style="font-weight:400; text-decoration:line-through; color:#9ca3af;">₹7,500</small> <small style="font-weight:600;">₹5,000/month</small></th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>Inbound & Outbound Calls</td>
                                <td><i class="fa-solid fa-check-circle in-check"></i></td>
                                <td><i class="fa-solid fa-check-circle in-check"></i></td>
                            </tr>
                            <tr>
                                <td>Call Rate</td>
                                <td>₹6/min</td>
                                <td>₹6/min</td>
                            </tr>
                            <tr>
                                <td>Dashboard Access</td>
                                <td><span class="in-limited">Limited</span></td>
                                <td><i class="fa-solid fa-check-circle in-check"></i> Full Real-time</td>
                            </tr>
                            <tr>
                                <td>Call Recording & Storage</td>
                                <td><i class="fa-solid fa-xmark in-cross"></i></td>
                                <td><i class="fa-solid fa-check-circle in-check"></i> Unlimited</td>
                            </tr>
                            <tr>
                                <td>Call Reports & Export</td>
                                <td><i class="fa-solid fa-xmark in-cross"></i></td>
                                <td><i class="fa-solid fa-check-circle in-check"></i> Advanced</td>
                            </tr>
                            <tr>
                                <td>CRM & Lead Management</td>
                                <td><i class="fa-solid fa-xmark in-cross"></i></td>
                                <td><i class="fa-solid fa-check-circle in-check"></i></td>
                            </tr>
                            <tr>
                                <td>Multi-Agent / Team Management</td>
                                <td><i class="fa-solid fa-xmark in-cross"></i></td>
                                <td><i class="fa-solid fa-check-circle in-check"></i></td>
                            </tr>
                            <tr>
                                <td>User Roles & Permissions</td>
                                <td><i class="fa-solid fa-xmark in-cross"></i></td>
                                <td><i class="fa-solid fa-check-circle in-check"></i></td>
                            </tr>
                            <tr>
                                <td>Analytics & Performance Metrics</td>
                                <td><i class="fa-solid fa-xmark in-cross"></i></td>
                                <td><i class="fa-solid fa-check-circle in-check"></i></td>
                            </tr>
                            <tr>
                                <td>Support</td>
                                <td>Email Only</td>
                                <td><i class="fa-solid fa-check-circle in-check"></i> Priority</td>
                            </tr>
                            <tr>
                                <td>Best For</td>
                                <td style="color:#6b7280;">Testing / personal use</td>
                                <td style="color:#1e40af; font-weight:600;">Businesses & call centres</td>
                            </tr>
                        </tbody>
                    </table>
                </div>

                <div class="text-center mt-4">
                    <a href="<?php echo e(route('register')); ?>" class="btn btn-main hover-style-one align-items-center justify-content-center tw-gap-5 tw-px-13 tw-rounded-md tw-py-6 fw-bold" style="display:inline-flex;">
                        <span class="button__label">Upgrade to Subscription — Unlock Full Features</span>
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- ==================== What ₹5,000/month Unlocks ==================== -->
<section class="in-section">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="in-section-title">What ₹5,000/month Unlocks for Your Business</h2>
            <p class="in-section-subtitle">The subscription gives you the tools to manage, track, and grow your calling operations — not just make calls.</p>
        </div>

        <div class="row gy-4">
            <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-duration="600">
                <div style="background:#fff; border-radius:12px; padding:28px 24px; border:1px solid #e5e7eb; height:100%; transition:all 0.3s ease;">
                    <div style="width:48px; height:48px; border-radius:10px; background:#eff6ff; display:flex; align-items:center; justify-content:center; margin-bottom:16px;"><i class="fa-solid fa-phone-volume" style="font-size:20px; color:#2563eb;"></i></div>
                    <h5 style="font-size:17px; font-weight:600; color:#111827; margin-bottom:8px;">Inbound & Outbound Telephony</h5>
                    <p style="font-size:14px; color:#6b7280; margin:0; line-height:1.5;">Handle all incoming and outgoing calls from one platform. Smart routing sends each call to the right agent.</p>
                </div>
            </div>
            <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-duration="700">
                <div style="background:#fff; border-radius:12px; padding:28px 24px; border:1px solid #e5e7eb; height:100%; transition:all 0.3s ease;">
                    <div style="width:48px; height:48px; border-radius:10px; background:#eff6ff; display:flex; align-items:center; justify-content:center; margin-bottom:16px;"><i class="fa-solid fa-chart-line" style="font-size:20px; color:#2563eb;"></i></div>
                    <h5 style="font-size:17px; font-weight:600; color:#111827; margin-bottom:8px;">Real-time Dashboard</h5>
                    <p style="font-size:14px; color:#6b7280; margin:0; line-height:1.5;">See live call activity, agent status, and queue performance as it happens. Make decisions in real-time.</p>
                </div>
            </div>
            <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-duration="800">
                <div style="background:#fff; border-radius:12px; padding:28px 24px; border:1px solid #e5e7eb; height:100%; transition:all 0.3s ease;">
                    <div style="width:48px; height:48px; border-radius:10px; background:#eff6ff; display:flex; align-items:center; justify-content:center; margin-bottom:16px;"><i class="fa-solid fa-file-lines" style="font-size:20px; color:#2563eb;"></i></div>
                    <h5 style="font-size:17px; font-weight:600; color:#111827; margin-bottom:8px;">Detailed Call Reports</h5>
                    <p style="font-size:14px; color:#6b7280; margin:0; line-height:1.5;">Get reports on call volume, duration, outcomes, and agent performance. Export data anytime you need it.</p>
                </div>
            </div>
            <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-duration="600">
                <div style="background:#fff; border-radius:12px; padding:28px 24px; border:1px solid #e5e7eb; height:100%; transition:all 0.3s ease;">
                    <div style="width:48px; height:48px; border-radius:10px; background:#eff6ff; display:flex; align-items:center; justify-content:center; margin-bottom:16px;"><i class="fa-solid fa-circle-play" style="font-size:20px; color:#2563eb;"></i></div>
                    <h5 style="font-size:17px; font-weight:600; color:#111827; margin-bottom:8px;">Call Recording & Files</h5>
                    <p style="font-size:14px; color:#6b7280; margin:0; line-height:1.5;">Every call recorded and stored. Play back, download, or share recordings for training and quality compliance.</p>
                </div>
            </div>
            <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-duration="700">
                <div style="background:#fff; border-radius:12px; padding:28px 24px; border:1px solid #e5e7eb; height:100%; transition:all 0.3s ease;">
                    <div style="width:48px; height:48px; border-radius:10px; background:#eff6ff; display:flex; align-items:center; justify-content:center; margin-bottom:16px;"><i class="fa-solid fa-address-book" style="font-size:20px; color:#2563eb;"></i></div>
                    <h5 style="font-size:17px; font-weight:600; color:#111827; margin-bottom:8px;">CRM & Lead Management</h5>
                    <p style="font-size:14px; color:#6b7280; margin:0; line-height:1.5;">Built-in CRM to manage leads, contacts, and pipelines. Keep all your sales and support data in one place.</p>
                </div>
            </div>
            <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-duration="800">
                <div style="background:#fff; border-radius:12px; padding:28px 24px; border:1px solid #e5e7eb; height:100%; transition:all 0.3s ease;">
                    <div style="width:48px; height:48px; border-radius:10px; background:#eff6ff; display:flex; align-items:center; justify-content:center; margin-bottom:16px;"><i class="fa-solid fa-users-gear" style="font-size:20px; color:#2563eb;"></i></div>
                    <h5 style="font-size:17px; font-weight:600; color:#111827; margin-bottom:8px;">Team & User Management</h5>
                    <p style="font-size:14px; color:#6b7280; margin:0; line-height:1.5;">Add agents, set roles, assign permissions, and track individual performance across your entire team.</p>
                </div>
            </div>
            <div class="col-lg-4 col-md-6 offset-lg-4" data-aos="fade-up" data-aos-duration="600">
                <div style="background:#fff; border-radius:12px; padding:28px 24px; border:1px solid #e5e7eb; height:100%; transition:all 0.3s ease;">
                    <div style="width:48px; height:48px; border-radius:10px; background:#eff6ff; display:flex; align-items:center; justify-content:center; margin-bottom:16px;"><i class="fa-solid fa-gauge-high" style="font-size:20px; color:#2563eb;"></i></div>
                    <h5 style="font-size:17px; font-weight:600; color:#111827; margin-bottom:8px;">Analytics & Performance Metrics</h5>
                    <p style="font-size:14px; color:#6b7280; margin:0; line-height:1.5;">Track handle time, first-call resolution, abandon rate, and efficiency scores to improve your operations.</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- ==================== Why Choose LeadMine for India ==================== -->
<section class="in-section-alt">
    <div class="container">
        <div class="row align-items-center gy-5">
            <div class="col-lg-5" data-aos="fade-right" data-aos-duration="600">
                <h2 class="in-section-title mb-3">Why Choose LeadMine for India?</h2>
                <p style="font-size: 15px; color: #6b7280; line-height: 1.7;">
                    Built for the Indian market with INR billing, local telephony, and pricing that makes enterprise-grade tools accessible to every business.
                </p>
                <p style="font-size: 15px; color: #374151; line-height: 1.7; font-weight:500;">
                    ₹5,000/month unlocks the full system — dashboard, CRM, recordings, reports, analytics, and team management. Everything you need to run and grow a professional calling operation.
                </p>
            </div>
            <div class="col-lg-7" data-aos="fade-left" data-aos-duration="600">
                <div class="in-why-item">
                    <div class="num">1</div>
                    <div>
                        <h5>Priced for Indian Businesses</h5>
                        <p>Full platform at ₹5,000/month — a fraction of what international alternatives charge for similar features.</p>
                    </div>
                </div>
                <div class="in-why-item">
                    <div class="num">2</div>
                    <div>
                        <h5>No Lock-in, No Surprises</h5>
                        <p>Month-to-month billing. No contracts, no setup fees, no hidden charges. Cancel anytime from your account.</p>
                    </div>
                </div>
                <div class="in-why-item">
                    <div class="num">3</div>
                    <div>
                        <h5>Transparent ₹6/min Call Rate</h5>
                        <p>Same flat rate for inbound and outbound. No peak-hour pricing, no per-number charges, no minimum commitments.</p>
                    </div>
                </div>
                <div class="in-why-item">
                    <div class="num">4</div>
                    <div>
                        <h5>Local Support & Fast Onboarding</h5>
                        <p>Dedicated support during Indian business hours. Get set up and running without delays.</p>
                    </div>
                </div>
                <div class="in-why-item">
                    <div class="num">5</div>
                    <div>
                        <h5>Secure & Compliant</h5>
                        <p>Encryption at rest and in transit. Built to meet Indian business and data protection requirements.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- ==================== FAQs ==================== -->
<section class="in-section">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="in-section-title">Frequently Asked Questions</h2>
            <p class="in-section-subtitle">Everything you need to know about the subscription, call charges, and how pricing works.</p>
        </div>

        <div class="row justify-content-center">
            <div class="col-lg-8">

                <div class="in-faq-item">
                    <button class="in-faq-question" onclick="toggleFaq(this)">
                        Why do I need a subscription if I can already make calls?
                        <i class="fa-solid fa-chevron-down"></i>
                    </button>
                    <div class="in-faq-answer">
                        Without a subscription, you can make and receive calls — but that's about it. The subscription unlocks the full business platform: real-time dashboard, call recordings, detailed reports, CRM, team management, and analytics. If you're running a business or managing a team, the subscription is what turns basic calling into a professional operation.
                    </div>
                </div>

                <div class="in-faq-item">
                    <button class="in-faq-question" onclick="toggleFaq(this)">
                        Can I use LeadMine without a subscription?
                        <i class="fa-solid fa-chevron-down"></i>
                    </button>
                    <div class="in-faq-answer">
                        Yes. You can sign up and make calls at ₹6/minute without subscribing. However, you'll only have access to the basic dialler and a limited dashboard. Features like call recording, reports, CRM, team management, and analytics are only available with the ₹5,000/month subscription.
                    </div>
                </div>

                <div class="in-faq-item">
                    <button class="in-faq-question" onclick="toggleFaq(this)">
                        What exactly do I miss without a subscription?
                        <i class="fa-solid fa-chevron-down"></i>
                    </button>
                    <div class="in-faq-answer">
                        Without a subscription, you do not get: call recordings & recording files, detailed call reports, CRM & lead management, multi-agent team management, user roles & permissions, analytics & performance metrics, or priority support. The non-subscription mode is suitable for quick testing or individual trial use — not for running a business.
                    </div>
                </div>

                <div class="in-faq-item">
                    <button class="in-faq-question" onclick="toggleFaq(this)">
                        What does the ₹5,000/month subscription include?
                        <i class="fa-solid fa-chevron-down"></i>
                    </button>
                    <div class="in-faq-answer">
                        The subscription gives you full access to the LeadMine platform: real-time dashboard, complete call recording & storage, advanced call reports with export, built-in CRM & lead management, multi-user team management with roles, analytics & performance tracking, and priority support. Call charges (₹6/minute) are billed separately based on usage.
                    </div>
                </div>

                <div class="in-faq-item">
                    <button class="in-faq-question" onclick="toggleFaq(this)">
                        How are call charges calculated?
                        <i class="fa-solid fa-chevron-down"></i>
                    </button>
                    <div class="in-faq-answer">
                        Call charges are ₹6 per minute for both inbound and outbound calls. This applies whether or not you have a subscription. Charges are deducted from your prepaid wallet balance in real-time. You only pay for the minutes you actually use.
                    </div>
                </div>

                <div class="in-faq-item">
                    <button class="in-faq-question" onclick="toggleFaq(this)">
                        Are there any hidden fees or setup charges?
                        <i class="fa-solid fa-chevron-down"></i>
                    </button>
                    <div class="in-faq-answer">
                        No. There are no hidden fees, no setup charges, and no long-term contracts. You pay ₹5,000/month for the platform and ₹6/minute for calls. That's it — no surprises.
                    </div>
                </div>

                <div class="in-faq-item">
                    <button class="in-faq-question" onclick="toggleFaq(this)">
                        How does billing work?
                        <i class="fa-solid fa-chevron-down"></i>
                    </button>
                    <div class="in-faq-answer">
                        The ₹5,000 subscription is billed at the start of each month. Call charges work on a prepaid wallet model — add balance to your wallet, and charges are deducted in real-time as you make or receive calls. Auto-recharge is available to keep your service running without interruption.
                    </div>
                </div>

                <div class="in-faq-item">
                    <button class="in-faq-question" onclick="toggleFaq(this)">
                        What payment methods do you accept?
                        <i class="fa-solid fa-chevron-down"></i>
                    </button>
                    <div class="in-faq-answer">
                        We accept UPI, net banking, debit cards, credit cards, and Razorpay-supported wallets. All transactions are processed in INR.
                    </div>
                </div>

                <div class="in-faq-item">
                    <button class="in-faq-question" onclick="toggleFaq(this)">
                        Can I cancel my subscription anytime?
                        <i class="fa-solid fa-chevron-down"></i>
                    </button>
                    <div class="in-faq-answer">
                        Yes. It's month-to-month. Cancel anytime from your account settings — no penalties, no exit fees, no questions. Your remaining wallet balance stays available for call usage even after cancellation.
                    </div>
                </div>

                <div class="in-faq-item">
                    <button class="in-faq-question" onclick="toggleFaq(this)">
                        Do you offer volume discounts?
                        <i class="fa-solid fa-chevron-down"></i>
                    </button>
                    <div class="in-faq-answer">
                        Yes. If you have a large team or expect high call volumes, contact our sales team for custom pricing. We offer volume-based discounts on both subscription and call charges.
                    </div>
                </div>

            </div>
        </div>
    </div>
</section>

<!-- ==================== CTA ==================== -->
<section class="in-cta-section">
    <div class="container text-center">
        <h3>Stop Just Making Calls. Start Running a Call Business.</h3>
        <p>₹5,000/month unlocks the full system — dashboard, CRM, recordings, reports, analytics & team management.</p>
        <div class="d-flex justify-content-center gap-3 flex-wrap">
            <a href="<?php echo e(route('register')); ?>" class="in-btn-white">Start Free Trial</a>
            <a href="<?php echo e(url('/contact-us')); ?>" class="in-btn-outline-white">Contact Sales</a>
        </div>
    </div>
</section>

</div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
function toggleFaq(btn) {
    var answer = btn.nextElementSibling;
    var isActive = btn.classList.contains('active');

    document.querySelectorAll('.in-faq-question').forEach(function(q) {
        q.classList.remove('active');
        q.nextElementSibling.classList.remove('active');
    });

    if (!isActive) {
        btn.classList.add('active');
        answer.classList.add('active');
    }
}
</script>
<?php $__env->stopPush(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('website.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/leadmine/leadmine_pro/resources/views/website/price-plan-new.blade.php ENDPATH**/ ?>