<?php $__env->startSection('meta'); ?>
<title>AI Solutions for All Industries | <?php echo e(config('app.site')); ?> Automation</title>

<meta name="description" content="Discover AI automation solutions for all industries — streamline calls, reminders, customer engagement, and workflows with smart voice technology.">

<meta name="keywords" content="AI solutions for all industries, automation for all industries, voice AI solutions, business automation tools, AI customer engagement">


<meta property="og:title" content="AI Solutions for All Industries | <?php echo e(config('app.site')); ?> Automation">
<meta property="og:description" content="Discover AI automation solutions for all industries — streamline calls, reminders, customer engagement, and workflows with smart voice technology.">
<meta property="og:image" content="<?php echo e(asset('web/assets/images/ai-recep.webp')); ?>">
<meta property="og:type" content="website">
<meta property="og:url" content="<?php echo e(url()->current()); ?>">


<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="AI Solutions for All Industries | <?php echo e(config('app.site')); ?> Automation">
<meta name="twitter:description" content="Discover AI automation solutions for all industries — streamline calls, reminders, customer engagement, and workflows with smart voice technology.">
<meta name="twitter:image" content="<?php echo e(asset('web/assets/images/ai-recep.webp')); ?>">

<?php $__env->stopSection(); ?>






<link
  rel="stylesheet"
  href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css"
/>





 <?php $__env->startSection('content'); ?>
<style>
.custom-img {
  margin-top: 180px;
}

 .paragraph-style {
  font-weight: 400;
  font-size: 18px;
}

.custom-heading {
  font-weight: 400;  
}

.max-width-40 {
  max-width: 40%;
}

@media (max-width: 768px) {
  .custom-img {
    margin-top: 50px;
  }
}
.pt-40 {
  padding-top: 40px;
}
.img-auto-warranty {
  max-height: 500px;
  width: 100%;
  object-fit: contain;
}

.img-deal-maxwidth{
  max-width: 35%;
}
.custom-padding-100 {
  padding: 100px 0;
}
.img-pitch-maxwidth {
  max-width: 30%;
}
.visually-hidden {
    position: absolute;
    width: 1px;
    height: 1px;
    padding: 0;
    margin: -1px;
    overflow: hidden;
    clip: rect(0, 0, 0, 0);
    white-space: nowrap;
    border: 0;
}
.as-h2 {
 font-size: clamp(1.5rem, 0.5569rem + 1.444vw, 1.875rem);
 }

.tw-mb-1{
 font-size: clamp(1.125rem, 1.2rem + 0.722vw, 1.5rem);
 }
</style>
 <!-- <section class="section-bg-two pb-50 overflow-hidden pt-40">
     <div class="container max-w-1290-px">
         <div class="row gy-5 align-items-center justify-content-center text-center">
             <div class="col-xl-12">
                 <div>
                     <div class="mx-auto tw-mb-12">
                          <h1 class="visually-hidden">Real Estate & Mortgage Intelligence</h1>
                         <h3 class="splitTextStyleOne text-heading heading-medium">
                             Real Estate & Mortgage Intelligence
                         </h3>
                         <p class="text-neutral-500 tw-mt-2 splitTextStyleOne max-w-770-px tw-text-lg mx-auto">
                             With real-time dashboards and performance scorecards, managers get a clear view of which
                             agents are driving deals—and who needs coaching.
                         </p>
                         <div class="tw-mt-2" data-aos="fade-up" data-aos-anchor-placement="top-bottom"
                             data-aos-duration="900">
                             <a href="<?php echo e(route('register')); ?>"
                                 class="hover--translate-y-1 active--translate-y-scale-9 btn button--stroke tw-gap-5 group active--translate-y-2 tw-rounded-xl text-capitalize tw-px-8 tw-py-505 fw-medium btn-main hover-style-one"
                                 data-block="button">
                                 <span class="button__flair"></span>
                                 <span class="button__label">Get started</span>
                             </a>
                         </div>
                     </div>
                 </div>
             </div>
         </div>
     </div>
 </section> -->
<section class="hero-section">
  <div class="hero-content">
    <h1>
      The Customer Communication <br />Platform Built for Every <span class="gradient-text">Industry </span>
   
    </h1>
    <p>
   The modern communication platform designed to meet the unique needs of your industry. Boost your <br />
   communication workflows and set new customer experience benchmarks.
    </p>
    <a href="<?php echo e(route('register')); ?>" class="cta-btn">Get Started</a>
  </div>

  <div class="wave-left"></div>
<div class="wave-bottom"></div>
</section>

<style>
.hero-section {
  position: relative;
  overflow: hidden;
 background: linear-gradient(135deg, #0c1234 0%, #1c1e52 30%, #26185a 60%, #4b23b0 90%, #6f3de9 100%);
  min-height: 70vh;
  display: flex;
  align-items: center;
  justify-content: center;
  text-align: center;
  font-family: "Inter", sans-serif;
  padding: 80px 20px;
}


.hero-section::before {
  content: "";
  position: absolute;
  inset: 0;
  background: 
  linear-gradient(rgba(255,255,255,0.05) 1px, transparent 1px),
  linear-gradient(90deg, rgba(255,255,255,0.05) 1px, transparent 1px);
  background-size: 80px 80px;
  z-index: 0;
}


.hero-section::after {
  content: "";
  position: absolute;
  top: -100px;
  left: -200px;
  width: 600px;
  height: 600px;
  background: radial-gradient(circle at center, rgba(0, 183, 255, 0.2) 0%, transparent 70%);
  border-radius: 50%;
  z-index: 0;
  filter: blur(60px);
}


.hero-section .wave-left,
.hero-section .wave-bottom {
  position: absolute;
  width: 600px;
  height: 600px;
  border-radius: 50%;
  filter: blur(60px);
  z-index: 1;
  pointer-events: none;
}

.hero-section .wave-left {
  top: 0;
  left: 0;
  background: radial-gradient(circle at center, rgba(0, 255, 183, 0.4) 0%, transparent 70%);
}

.hero-section .wave-bottom {
  bottom: 0;
  right: 0;
  background: radial-gradient(circle at center, rgba(160, 80, 255, 0.4) 0%, transparent 70%);
}

.hero-content {
  position: relative;
  z-index: 2;
  color: #fff;
  max-width: 850px;
}

.hero-content h1 {
  font-size: 44px; 
  font-weight: 800;
  line-height: 1.2;
  margin-bottom: 25px;
}

.gradient-text {
  background: linear-gradient(90deg, #00b3ff, #8b6df2);
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
}

.hero-content p {
  font-size: 18px;
  color: #d1d1d1;
  line-height: 1.7;
  margin-bottom: 45px;
}

.cta-btn {
  display: inline-block;
  background: #1760ff;
  color: #fff;
  font-weight: 600;
  font-size: 18px;
  padding: 14px 38px;
  border-radius: 10px;
  text-decoration: none;
  transition: all 0.3s ease;
  box-shadow: 0 4px 15px rgba(23, 96, 255, 0.3);
}

.cta-btn:hover {
  background: #0049e0;
  transform: translateY(-2px);
}

/* Responsive Design */
@media (max-width: 768px) {
  .hero-content h1 {
    font-size: 34px;
  }
  .hero-content p {
    font-size: 16px;
  }
  .cta-btn {
    font-size: 16px;
    padding: 12px 28px;
  }
}



.about-badge {
  font-size: 0.9rem;
}


.icon-size {
  font-size: 2.2rem;
}


.about-img {
  max-width: 100%;
  height: auto;
  border-radius: 12px;
}

.switch-card {
  transition: all 0.3s ease;
}

.switch-card:hover {
  transform: translateY(-4px);
}


.services-section {
  padding: 60px 30px;
  background: #fff;
}

.card-row {
  display: flex;
  justify-content: center;
  gap: 30px;
  margin-bottom: 40px;
  flex-wrap: wrap;
}

.service-card {
  width: 350px;
  padding: 22px;
  border-radius: 16px;
  border: 1px solid #3366ff;
  background: white;
  transition: 0.3s ease-in-out;
}

.service-card:hover {
  transform: translateY(-6px);
  box-shadow: 0px 12px 35px rgba(0,0,0,0.1);
}

.card-image {
  width: 100%;
  border-radius: 12px;
  padding: 20px;
  display: flex;
  justify-content: center;
  margin-bottom: 15px;
}

.card-image img {
  width: 160px;
}

.service-card h3 {
  font-size: 20px;
  margin: 15px 0;
  color: #000;
  font-weight: 700;
}

.service-card p {
  font-size: 15px;
  color: #444;
  line-height: 1.6;
}

.service-card a {
  display: inline-block;
  margin-top: 12px;
  color: #1458ff;
  text-decoration: none;
  font-weight: 600;
}

/* Background Colors Like Image */
.yellow-bg .card-image {
  background: #fff7df;
}

.blue-bg .card-image {
  background: #eaf3ff;
}

.green-bg .card-image {
  background: #eafff2;
}

.white-bg .card-image {
  background: #f7f9ff;
}

</style>



<style>
.switch-section {
  background: #fff;
  font-family: 'Poppins', sans-serif;
}

.about-content p {
  color: #4f5b7d;
  font-size: 1.05rem;
  line-height: 1.8;
  margin-bottom: 1.5rem;
  text-align: justify;
}

.switch-card {
  background: #fff;
  border: 1px solid #e6e6e6;
  border-radius: 16px;
  padding: 28px 22px;
  height: 100%;
  transition: all 0.3s ease;
}

.switch-card:hover {
  box-shadow: 0 8px 20px rgba(0, 0, 0, 0.05);
  transform: translateY(-3px);
}

.switch-card .icon {
  width: 55px;
  height: 55px;
  background: #f0f4ff;
  border-radius: 12px;
  padding: 10px;
  display: flex;
  align-items: center;
  justify-content: center;
}

.switch-card h5 {
  font-weight: 700;
  color: #0b1b4f;
  margin-bottom: 12px;
  font-size: 1.1rem;
}

.switch-card p {
  color: #4f5b7d;
  font-size: 0.95rem;
  line-height: 1.7;
}

.about-img {
  max-width: 100%;
  border-radius: 16px;
  box-shadow: 0 10px 25px rgba(0, 0, 0, 0.05);
  transition: transform 0.4s ease;
}

.about-img:hover {
  transform: scale(1.03);
}

@media (max-width: 992px) {
  .about-content {
    text-align: center;
  }

  .about-content p {
    text-align: center;
  }

  .switch-card {
    text-align: left;
  }

  .about-img {
    margin-top: 30px;
  }
}



.ind-badge {
  font-size: 0.9rem;
}


.icon-size {
  font-size: 2.2rem;
}


.cta-text {
  font-family: 'Poppins', sans-serif;
  font-size: 1.1rem;
}

.cta-link {
  color: #0d6efd;
  text-decoration: none;
  font-weight: 600;
}

.cta-link:hover {
  text-decoration: underline;
}

.services-pagination {
    margin-bottom: 65px !important;
}



</style>


<section class="switch-section py-5">
  <div class="container text-center">
    <div class="tw-mb-13 text-center">
      <span class="tw-py-1 tw-px-705 bg-main-50 text-main-600 tw-text-sm fw-bold text-capitalize rounded-pill tw-mb-205 ind-badge">
        Industries We Serve
      </span>

      <h3 class="splitTextStyleOne custom-perspective">
        <div class="split-line custom-centered-title">
          Transforming Industries Worldwide
        </div>
      </h3>

      <p class="text-gray-600 tw-max-w-[700px] mx-auto mt-3">
        From healthcare to education, <?php echo e(config('app.site')); ?> AI Answering Service is revolutionizing how businesses serve their customers across every sector.
      </p>
    </div>


 <div class="services-section">

  <div class="swiper services-slider">
    <div class="swiper-wrapper">

      <!-- Slide 1 -->
      <div class="swiper-slide">
        <div class="service-card white-bg">
          <div>
            <img src="web/assets/images/software-technology.webp">
          </div>
          <h3>Software and Technology</h3>
          <p>
            Sync Leadmine.pro data across multiple tools to access the latest customer information.
            Customize workflows, troubleshoot queries with AI, and ensure complete data security.
          </p>
          <a href="/technology">Learn More →</a>
        </div>
      </div>

      <!-- Slide 2 -->
      <div class="swiper-slide">
        <div class="service-card white-bg">
          <div>
            <img src="web/assets/images/industry-real-estate.webp">
          </div>
          <h3>Real Estate</h3>
          <p>
            Connect & engage effectively with clients to close more deals. Manage high volumes
            of leads effortlessly, book more appointments, and automate follow-ups.
          </p>
          <a href="/real-estate-mortgage-intelligence">Learn More →</a>
        </div>
      </div>

      <!-- Slide 3 -->
      <div class="swiper-slide">
        <div class="service-card white-bg">
          <div>
            <img src="web/assets/images/financial (2).webp">
          </div>
          <h3>Financial Services</h3>
          <p>
            Build secure and personalized customer experiences for prospects,
            customers, and policyholders across Voice, SMS, and WhatsApp.
          </p>
          <br/>
      
          <a href="/financial-services">Learn More →</a>
        </div>
      </div>

      <!-- Slide 4 -->
      <div class="swiper-slide">
        <div class="service-card yellow-bg">
          <div>
            <img src="web/assets/images/education 2.webp">
          </div>
          <h3>Education Services</h3>
          <p>
            Improve staff-student interactions with SMS bots, call routing, & built-in AI.
            Schedule classes, track data, and provide quick support in learning.
          </p>
          <br/>
        
          <a href="/education">Learn More →</a>
        </div>
      </div>

      <!-- Slide 5 -->
      <div class="swiper-slide">
        <div class="service-card blue-bg">
          <div>
            <img src="web/assets/images/healthcare 2.webp">
          </div>
          <h3>Healthcare Services</h3>
          <p>
            Put your patients first & ensure a safe, secure, personalized communication experience.
          </p>
          <br/>
      
          <a href="/healthcare">Learn More →</a>
        </div>
      </div>

      <!-- Slide 6 -->
      <div class="swiper-slide">
        <div class="service-card green-bg">
          <div>
            <img src="web/assets/images/retail 2.webp">
          </div>
          <h3>Retail</h3>
          <p>
            Deliver the best customer experience, ensure efficient call handling,
            and integrate with your stack to resolve customer queries smartly.
          </p>
          <a href="/retail">Learn More →</a>
        </div>
      </div>

      <!-- Slide 7 -->
      <div class="swiper-slide">
        <div class="service-card green-bg">
          <div>
            <img src="web/assets/images/fitnesss.webp">
          </div>
          <h3>Fitness & Wellness</h3>
          <p>
            Deliver the best customer experience, ensure efficient call handling,
            and integrate with your stack to resolve customer queries smartly.
          </p>
          <a href="/fitness-wellness">Learn More →</a>
        </div>
      </div>

    </div>

    <!-- Pagination dots -->
    <div class="swiper-pagination services-pagination mb-6"></div>
  </div>

</div>


    <!-- CTA -->
    <div class="text-center mt-6 cta-text">
      🚀 Ready to experience the transformation?
      <a href="<?php echo e(route('register')); ?>" class="cta-link">
        Get Started Now
      </a>
    </div>
  </div>
</section>



<style>
.switch-section {
  background: #fff;
}

.switch-card {
  background: #fff;
  border: 1px solid #e6e6e6;
  border-radius: 16px;
  padding: 30px 20px;
  height: 100%;
  text-align: left;
  transition: all 0.3s ease;
}

.switch-card:hover {
  box-shadow: 0 8px 20px rgba(0, 0, 0, 0.05);
  transform: translateY(-3px);
}

.switch-card .icon {
  width: 55px;
  height: 55px;
  background: #f0f4ff;
  border-radius: 12px;
  padding: 10px;
  margin-bottom: 20px;
}

.switch-card h5 {
  font-weight: 700;
  color: #0b1b4f;
  margin-bottom: 12px;
  font-size: 1.05rem;
}

.switch-card p {
  color: #4f5b7d;
  font-size: 0.9rem;
  line-height: 1.6;
}

@media (max-width: 992px) {
  .switch-card {
    padding: 25px 18px;
  }
}

@media (max-width: 768px) {
  .switch-card {
    text-align: center;
  }
  .switch-card .icon {
    margin: 0 auto 15px;
  }
}



.impact-bg {
  background-color: #f8f9fb;
}


.impact-title {
  font-size: 2.2rem;
  font-family: 'Poppins', sans-serif;
}


.impact-subtitle {
  max-width: 800px;
  margin: 0 auto;
  font-size: 1.1rem;
  font-family: 'Jost', sans-serif;
}


.impact-stats-font {
  font-family: 'Jost', sans-serif;
}


.impact-number {
  color: #1351d8;
  font-size: 3rem;
  font-weight: 700;
}


.impact-label {
  font-size: 1rem;
}

</style>

<!-- Proven Impact Section -->
<section class="callchex-section py-50 impact-bg">
  <div class="container max-w-1200-px">
    
   
    <div class="text-center mb-5">
      <h2 class="fw-bold impact-title">
        Every Customer Deserves the Right Information
      </h2>
      <p class="lead text-muted mt-3 impact-subtitle">
        Ensure accurate answers and instant support—anytime they call.
      </p>
    </div>

   
    <div class="row text-center justify-content-center impact-stats-font">
      <div class="col-lg-4 col-md-6 mb-4">
        <h3 class="impact-number">24/7</h3>
        <p class="text-muted impact-label">Availability</p>
      </div>

      <div class="col-lg-4 col-md-6 mb-4">
        <h3 class="impact-number">100%</h3>
        <p class="text-muted impact-label">Consistent Answers</p>
      </div>

      <div class="col-lg-4 col-md-6 mb-4">
        <h3 class="impact-number">100%</h3>
        <p class="text-muted impact-label">Reduced Employee Burden</p>
      </div>
    </div>

  </div>
</section>





<!-- ================== Driven section Start ====================== -->
        <section class="py-50">
            <div class="container">
                <div class="">
                    <img src="web/assets/images/thumbs/driven-img.webp" alt="driven-img" loading="lazy">
                    <div class="max-w-780-px text-center mx-auto tw-mb-13">
                        <h3 class="splitTextStyleOne text-heading text-capitalize text-capitalize heading-medium">
                            Driven your business today next level by <?php echo e(config('app.site')); ?>

                        </h3>
                        <!-- <div class="d-flex align-items-center tw-gap-4 justify-content-center tw-mt-10">
                            <a href="<?php echo e(route('register')); ?>" class="hover--translate-y-1 active--translate-y-scale-9 btn button--stroke tw-gap-5 group active--translate-y-2 tw-rounded-xl text-capitalize tw-px-8 tw-py-505 fw-medium btn btn-main hover-style-one" data-block="button">
                                <span class="button__flair"></span>
                                <span class="button__label">get started </span>
                            </a>

                        </div> -->
                    </div>
                </div>
            </div>
        </section>
        <!-- ================== Driven section End ====================== -->



 <section class="py-50">
    <div class="container">
        <div class="text-center">
            <h3 class="main-heading text-capitalize mb-4">
              Transform Every Call Into a Growth Opportunity?
            </h3>
            <p class="max-w-780-px mx-auto tw-mb-6">
             Empower your team with Leadmine.pro — the AI-driven platform that analyzes every call, scores leads automatically, and helps you close deals faster.
            </p>

            <div class="d-flex flex-column align-items-center">
                <p class="fw-semibold tw-mb-4">
                    🔥 Don’t wait — start transforming your calls today. 
                    <a href="<?php echo e(route('register')); ?>"
                       class="btn btn-main hover-style-one tw-rounded-xl tw-px-4 tw-py-2 fw-medium text-capitalize ms-2">
                        👉 Join Us Now
                    </a>
                </p>
                    <p class="fw-semibold mt-3">Follow us on <a href="https://www.instagram.com/leadmine.pro/">Instagram</a>🔥</p>
                <p class="fw-semibold mt-3">Connect with us on <a href="https://www.linkedin.com/in/leadminepro/">LinkedIn</a>🔥</p>
            </div>
        </div>
    </div>
</section>

<script src="https://cdn.jsdelivr.net/npm/swiper@10/swiper-bundle.min.js"></script>


<script>
var swiper = new Swiper(".services-slider", {
  slidesPerView: 3,
  spaceBetween: 30,
  loop: false,
  grabCursor: true,
  
  pagination: {
    el: ".services-pagination",
    clickable: true,
  },

  breakpoints: {
    0: { slidesPerView: 1 },
    768: { slidesPerView: 2 },
    1200: { slidesPerView: 3 }
  }
});
</script>


 <?php $__env->stopSection(); ?>
<?php echo $__env->make('website.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/leadmine/leadmine_pro/resources/views/website/all-industries.blade.php ENDPATH**/ ?>