 

<?php $__env->startSection('meta'); ?>
<title>AI Healthcare Communication & Patient Engagement Software | <?php echo e(config('app.site')); ?></title>

<meta name="description" content="Automate patient calls, appointment reminders, follow-ups, and support with AI healthcare communication software available 24/7.">

<meta name="keywords" content="AI healthcare communication, patient engagement software, healthcare call automation, AI appointment reminders, AI healthcare support">


<meta property="og:title" content="AI Healthcare Communication & Patient Engagement Software | <?php echo e(config('app.site')); ?>">
<meta property="og:description" content="Automate patient calls, appointment reminders, follow-ups, and support with AI healthcare communication software available 24/7.">
<meta property="og:image" content="<?php echo e(asset('web/assets/images/healthcare.webp')); ?>">
<meta property="og:type" content="website">
<meta property="og:url" content="<?php echo e(url()->current()); ?>">


<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="AI Healthcare Communication & Patient Engagement Software | <?php echo e(config('app.site')); ?>">
<meta name="twitter:description" content="Automate patient calls, appointment reminders, follow-ups, and support with AI healthcare communication software available 24/7.">
<meta name="twitter:image" content="<?php echo e(asset('web/assets/images/healthcare.webp')); ?>">

<?php $__env->stopSection(); ?>






 <?php $__env->startSection('content'); ?>
<style>
.custom-img {
  margin-top: 180px;
}

 .paragraph-style {
  font-weight: 400;
  font-size: 18px;
}

.custom-heading {
  font-weight: 400;  
}

.max-width-40 {
  max-width: 40%;
}

@media (max-width: 768px) {
  .custom-img {
    margin-top: 50px;
  }
}
.pt-40 {
  padding-top: 40px;
}
.img-auto-warranty {
  max-height: 500px;
  width: 100%;
  object-fit: contain;
}

.img-deal-maxwidth{
  max-width: 35%;
}
.custom-padding-100 {
  padding: 100px 0;
}
.img-pitch-maxwidth {
  max-width: 30%;
}
.visually-hidden {
    position: absolute;
    width: 1px;
    height: 1px;
    padding: 0;
    margin: -1px;
    overflow: hidden;
    clip: rect(0, 0, 0, 0);
    white-space: nowrap;
    border: 0;
}
.as-h2 {
 font-size: clamp(1.5rem, 0.5569rem + 1.444vw, 1.875rem);
 }

.tw-mb-1{
 font-size: clamp(1.125rem, 1.2rem + 0.722vw, 1.5rem);
 }
</style>
 <!-- <section class="section-bg-two pb-50 overflow-hidden pt-40">
     <div class="container max-w-1290-px">
         <div class="row gy-5 align-items-center justify-content-center text-center">
             <div class="col-xl-12">
                 <div>
                     <div class="mx-auto tw-mb-12">
                          <h1 class="visually-hidden">Real Estate & Mortgage Intelligence</h1>
                         <h3 class="splitTextStyleOne text-heading heading-medium">
                             Real Estate & Mortgage Intelligence
                         </h3>
                         <p class="text-neutral-500 tw-mt-2 splitTextStyleOne max-w-770-px tw-text-lg mx-auto">
                             With real-time dashboards and performance scorecards, managers get a clear view of which
                             agents are driving deals—and who needs coaching.
                         </p>
                         <div class="tw-mt-2" data-aos="fade-up" data-aos-anchor-placement="top-bottom"
                             data-aos-duration="900">
                             <a href="<?php echo e(route('register')); ?>"
                                 class="hover--translate-y-1 active--translate-y-scale-9 btn button--stroke tw-gap-5 group active--translate-y-2 tw-rounded-xl text-capitalize tw-px-8 tw-py-505 fw-medium btn-main hover-style-one"
                                 data-block="button">
                                 <span class="button__flair"></span>
                                 <span class="button__label">Get started</span>
                             </a>
                         </div>
                     </div>
                 </div>
             </div>
         </div>
     </div>
 </section> -->
<section class="hero-section">
  <div class="hero-container">
    <div class="hero-left">
       <h1>Reliable Healthcare Communication That Scales with You</h1>
         <p>
        Manage high patient call volumes with ease, reduce admin work, and streamline communication — even during peak hours — with <?php echo e(config('app.site')); ?>’s secure and scalable platform.
      </p>
      <div class="hero-badges">
      <span><i class="fa fa-check-circle"></i> No credit card required</span>
        <span><i class="fa fa-check-circle"></i> 14 days of <?php echo e(config('app.site')); ?> AI on us</span>
      </div>
    </div>

    <div class="hero-right">
      <div class="hero-image-wrapper">
        <img src="web/assets/images/healthcare.webp"  alt="AI powered healthcare communication platform for managing patient calls">

    
      </div>
    </div>
  </div>
</section>

<style>
.hero-section {
  background: linear-gradient(180deg, #f2f4ff 0%, #ffffff 100%);
  padding: 100px 0;
  font-family: "Inter", sans-serif;
}

.hero-container {
  max-width: 1250px;
  margin: auto;
  display: flex;
  align-items: center;
  justify-content: space-between;
  flex-wrap: wrap;
  gap: 70px;
}

.hero-left {
  flex: 1 1 520px;
}

.hero-left h1 {
  font-size: 40px;
  font-weight: 700;
  color: #1b1f3b;
  line-height: 1.25;
  margin-bottom: 25px;
  max-width: 500px;
}

.hero-left p {
  font-size: 18px;
  line-height: 1.7;
  color: #2b2b2b;
  margin-bottom: 35px;
  max-width: 520px;
  font-family: "Poppins", sans-serif; 
}

.hero-badges {
  display: flex;
  flex-wrap: wrap;
  gap: 20px;
  font-size: 16px;
  color: #1b1f3b;
}

.hero-badges i {
  color: #3b82f6;
  margin-right: 8px;
}

/* Right Side */
.hero-right {
  flex: 1 1 520px;
  display: flex;
  justify-content: center;
  position: relative;
}

.hero-image-wrapper {
  position: relative;
  width: 100%;
  max-width: 540px;
  border-radius: 20px;
  overflow: hidden;
  box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
}

.hero-image-wrapper img {
  width: 100%;
  display: block;
  object-fit: cover;
}

/* Agent Card */
.agent-card {
  position: absolute;
  top: 30px;
  left: 30px;
  background: #fff;
  border-radius: 16px;
  box-shadow: 0 6px 18px rgba(0, 0, 0, 0.1);
  padding: 16px 18px;
  max-width: 280px;
  border: 1px solid #e5e9ff;
}

.agent-card h4 {
  font-size: 15px;
  font-weight: 700;
  color: #1c2250;
  margin-bottom: 10px;
}

.agent-tabs {
  display: flex;
  gap: 6px;
  margin-bottom: 10px;
}

.agent-tabs .tab {
  flex: 1;
  font-size: 13px;
  text-align: center;
  padding: 6px 0;
  border-radius: 6px;
  background: #eef1ff;
  color: #4a4e74;
  font-weight: 600;
}

.agent-tabs .tab.active {
  background: #3b82f6;
  color: #fff;
}

.agent-message {
  font-size: 14px;
  color: #2b2b2b;
  background: #f9faff;
  padding: 12px;
  border-radius: 10px;
  line-height: 1.5;
  margin-bottom: 10px;
}

.agent-feedback {
  display: flex;
  justify-content: space-between;
  font-size: 13px;
  color: #3b82f6;
  font-weight: 600;
}

/* Responsive */
@media (max-width: 992px) {
  .hero-container {
    flex-direction: column;
    text-align: center;
  }

  .hero-left h1 {
    font-size: 36px;
    max-width: 100%;
  }

  .hero-left p {
    margin: 0 auto 30px;
  }

  .hero-badges {
    justify-content: center;
  }

  .hero-image-wrapper {
    margin-top: 40px;
  }

  .agent-card {
    position: static;
    margin: 20px auto 0;
  }
}

.secure-section {
  background: linear-gradient(180deg, #f2f4ff 0%, #ffffff 100%);
  padding: 100px 0;
  font-family: "Poppins", sans-serif; 
}

.secure-container {
  max-width: 1250px;
  margin: auto;
  display: flex;
  align-items: center;
  justify-content: space-between;
  flex-wrap: wrap;
  gap: 70px;
}

.secure-left {
  flex: 1 1 520px;
}

.secure-left h1 {
  font-size: 42px;
  font-weight: 800;
  color: #1b1f3b;
  line-height: 1.25;
  margin-bottom: 25px;
  max-width: 500px;
}

.secure-left p {
  font-size: 18px;
  line-height: 1.8;
  color: #2b2b2b;
  margin: 20px 0 30px 0; 
  max-width: 520px;
}

.secure-badges {
  display: flex;
  flex-wrap: wrap;
  gap: 20px;
  font-size: 16px;
  color: #1b1f3b;
}

.secure-badges i {
  color: #3b82f6;
  margin-right: 8px;
}

/* Right Side */
.secure-right {
  flex: 1 1 520px;
  display: flex;
  justify-content: center;
  position: relative;
}

.secure-image-wrapper {
  position: relative;
  width: 100%;
  max-width: 540px;
  border-radius: 20px;
  overflow: hidden;
  box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
  background: #fff;
}

.secure-image-wrapper img {
  width: 100%;
  display: block;
  object-fit: cover;
}


@media (max-width: 992px) {
  .secure-container {
    flex-direction: column;
    text-align: center;
  }

  .secure-left h1 {
    font-size: 34px;
    max-width: 100%;
  }

  .secure-left p {
    margin: 20px auto 30px; 
  }

  .secure-badges {
    justify-content: center;
  }

  .secure-image-wrapper {
    margin-top: 40px;
  }
}

.about-two{
  background-color: #f5fbf6;
}
</style>

<section class="about-two py-50 position-relative z-1 overflow-hidden">
  <img src="web/assets/images/bg/mash-gradient-bg3.webp" alt="Gradient" class="position-absolute tw-start-0 top-0 z-n1">

  <div class="container">
    <div class="row gy-4 flex-wrap-reverse">
      <div class="col-lg-6">
        <img src="web/assets/images/bg/home-healthcare.webp" alt="healthcare" loading="lazy" class="custom-img img-auto-warranty">
      </div>

      <div class="col-lg-6">
        <div class="ps-xl-5">
          <div class="tw-mb-6">
            <h2 class="tw-mb-2 font-caveat text-crm heading-medium as-h2">
              Deliver exceptional patient care round the clock
            </h2>
            <p class="splitTextStyleOne text-neutral-500 tw-mt-2 max-w-570-px paragraph-style">
              Empower your healthcare teams with AI-driven tools that streamline communication, automate routine tasks, and enhance every patient interaction.
            </p>
          </div>

          <div class="accordion common-accordion" id="accordionHealthcare">

            <!-- Reduce admin workload for patient engagement -->
            <div class="accordion-item tw-px-40-px tw-rounded-xl section-bg-one bg-white border-0 tw-mb-6">
              <h3 class="accordion-header">
                <button class="accordion-button tw-py-6 shadow-none px-0 bg-transparent h5" 
                        type="button" data-bs-toggle="collapse" data-bs-target="#patientEngagement" 
                        aria-expanded="true" aria-controls="patientEngagement">
                  🩺 Reduce admin workload for patient engagement
                </button>
              </h3>
              <div id="patientEngagement" class="accordion-collapse collapse show" data-bs-parent="#accordionHealthcare">
                <div class="accordion-body ps-0 pt-0 pe-0 tw-pb-6">
                  <p class="text-neutral-500 mb-3">
                    Automate appointment reminders and follow-ups with call and SMS workflows. Connect with patients instantly using Leadmine’s click-to-call and auto-dialer capabilities. Personalize SMS messages with AI suggestions to improve engagement.
                  </p>
                  <a href="#" class="btn btn-primary btn-sm">Start Free Trial</a>
                </div>
              </div>
            </div>

            <!-- Provide 24/7 support for patient inquiries -->
            <div class="accordion-item tw-px-40-px tw-rounded-xl section-bg-one  bg-white border-0 tw-mb-6">
              <h3 class="accordion-header">
                <button class="accordion-button tw-py-6 shadow-none px-0 bg-transparent h5 collapsed" 
                        type="button" data-bs-toggle="collapse" data-bs-target="#patientSupport" 
                        aria-expanded="false" aria-controls="patientSupport">
                  ☎️ Provide 24/7 support for patient inquiries
                </button>
              </h3>
              <div id="patientSupport" class="accordion-collapse collapse" data-bs-parent="#accordionHealthcare">
                <div class="accordion-body ps-0 pt-0 pe-0 tw-pb-6">
                  <p class="text-neutral-500 mb-3">
                    Handle queries efficiently with intelligent call routing and real-time AI suggestions on live calls. Never miss a call — during peak hours or after hours — with AI Voice Agents handling FAQs and booking appointments automatically.
                  </p>
                  <a href="#" class="btn btn-primary btn-sm">Start Free Trial</a>
                </div>
              </div>
            </div>

            <!-- Simplify patient data management -->
            <div class="accordion-item tw-px-40-px tw-rounded-xl section-bg-one  bg-white border-0 tw-mb-6">
              <h3 class="accordion-header">
                <button class="accordion-button tw-py-6 shadow-none px-0 bg-transparent h5 collapsed" 
                        type="button" data-bs-toggle="collapse" data-bs-target="#dataManagement" 
                        aria-expanded="false" aria-controls="dataManagement">
                  💾 Simplify patient data management
                </button>
              </h3>
              <div id="dataManagement" class="accordion-collapse collapse" data-bs-parent="#accordionHealthcare">
                <div class="accordion-body ps-0 pt-0 pe-0 tw-pb-6">
                  <p class="text-neutral-500 mb-3">
                    Leadmine.pro reduces manual work by automatically logging calls, generating AI-powered summaries, and syncing notes directly to your EHR or EMR software. Keep every patient record accurate, organized, and up-to-date — effortlessly.
                  </p>
                  <a href="#" class="btn btn-primary btn-sm">Start Free Trial</a>
                </div>
              </div>
            </div>

            <!-- Coach, monitor, and improve communication with AI -->
            <div class="accordion-item tw-px-40-px tw-rounded-xl section-bg-one   bg-white border-0 tw-mb-6">
              <h3 class="accordion-header">
                <button class="accordion-button tw-py-6 shadow-none px-0 bg-transparent h5 collapsed" 
                        type="button" data-bs-toggle="collapse" data-bs-target="#aiCoaching" 
                        aria-expanded="false" aria-controls="aiCoaching">
                  🤖 Coach, monitor, and improve communication with AI
                </button>
              </h3>
              <div id="aiCoaching" class="accordion-collapse collapse" data-bs-parent="#accordionHealthcare">
                <div class="accordion-body ps-0 pt-0 pe-0 tw-pb-6">
                  <p class="text-neutral-500 mb-3">
                    Monitor live calls, whisper discreet suggestions to your reps, or join patient conversations directly when needed. Use AI call scorecards and sentiment analysis to identify coaching opportunities and enhance communication quality.
                  </p>
                  <a href="#" class="btn btn-primary btn-sm">Start Free Trial</a>
                </div>
              </div>
            </div>

          </div> <!-- /accordion -->

        </div>
      </div>

    </div>
  </div>
</section>


<!-- Font Awesome -->
<script src="https://kit.fontawesome.com/a2d9a67a2b.js" crossorigin="anonymous"></script>

<style>
.toolkit-section {
  background: #f7f7f9; 
  font-family: 'Poppins', sans-serif;
}

.toolkit-grid {
  display: grid;
  grid-template-columns: repeat(auto-fit, minmax(270px, 1fr));
  gap: 25px;
}

.toolkit-item {
  background: #fff;
  border: 1px solid #e5e7eb;
  border-radius: 12px;
  padding: 28px 24px;
  box-shadow: 0 4px 12px rgba(0,0,0,0.04);
  transition: all 0.3s ease;
  cursor: pointer;
}

.toolkit-item:hover {
  border-color: #3b82f6;
  box-shadow: 0 8px 22px rgba(59,130,246,0.1);
  transform: translateY(-4px);
}


.toolkit-item .icon {
  font-size: 30px;
  color: #0a5bff;
  margin-bottom: 18px;
}


.toolkit-item h4 {
  font-size: 18px;
  font-weight: 600;
  margin-bottom: 10px;
  color: #000;
}

.toolkit-item p {
  font-size: 15px;
  color: #444;
  line-height: 1.6;
}

@media (max-width: 768px) {
  .toolkit-item {
    padding: 22px 18px;
  }
}

.secure-section{
  background-color: #d9f8e5 !important;
}
</style>


<section class="secure-section">
  <div class="secure-container">
    <!-- Left Text -->
    <div class="secure-left">
      <h3>Your patient data, safeguarded by the industry best</h3>
      <p>
       Leadmine.pro is trusted by top healthcare providers and telehealth companies, integrates with leading platforms, and is recognized as a G2 Leader in Healthcare Communications.
       With advanced encryption, secure call recording, and strict access controls, you can rest assured knowing your sensitive information is always safeguarded.
      </p>
   
    </div>

    <!-- Right Image -->
    <div class="secure-right">
      <div class="secure-image-wrapper">
        <img src="web/assets/images/secure.webp" alt="Secure and compliant data protection system with encryption">
      </div>
    </div>
  </div>
</section>

<section class="healthcare-section py-60">
  <div class="container">
    <h3 class="text-center fw-bold mb-5 text-dark">Understand Healthcare before you decide</h3>
    <div class="row gy-4">
      <!-- Left Menu -->
      <div class="col-lg-4">
        <div class="list-group healthcare-menu">
          <a href="#" class="list-group-item list-group-item-action active" data-target="#feature1">
            Key features to look for in a healthcare call center platform
          </a>
          <a href="#" class="list-group-item list-group-item-action" data-target="#feature2">
            Use case examples for a healthcare phone system
          </a>
          <a href="#" class="list-group-item list-group-item-action" data-target="#feature3">
            How a healthcare call center helps you improve patient experience
          </a>
          <a href="#" class="list-group-item list-group-item-action" data-target="#feature4">
            How to set up healthcare call center software with LeadMine.pro?
          </a>
        </div>
      </div>

      <!-- Right Content -->
      <div class="col-lg-8">
        <!-- Feature 1 -->
        <div class="healthcare-content active" id="feature1">
          <p>
            When choosing a medical call center platform, you should look for features that enhance operational efficiency and patient experience.
          </p>
          <p>
            Platforms like <b>LeadMine.pro</b> have specially designed solutions for the healthcare industry, ensuring compliance and efficient processes to handle emergencies.
          </p>
          <p>Here are a few features that are essential for operating a medical call center.</p>

          <h5 class="fw-semibold mt-3">HIPAA compliance</h5>
          <p>
            HIPAA compliance is a must-have for any communication tool dealing with medical records. You must ensure that medical records are only accessible on a need-to-know basis and securely encrypted otherwise.
          </p>

          <div class="more-text">
            <p>
              Compromised data security arising out of procedural deficiencies or attacks by bad actors will attract regulatory scrutiny and fines. Investing in a platform with strong data security practices like <b>LeadMine.pro</b> makes economic sense.
            </p>
          </div>

          <a href="#" class="read-more text-primary fw-semibold">Read More</a>
        </div>

        <!-- Feature 2 -->
        <div class="healthcare-content" id="feature2">
          <p>
            <b>LeadMine.pro’s</b> healthcare call center system easily adapts to various healthcare needs. Some use cases of a healthcare phone system platform include:
          </p>
          <h5 class="fw-semibold mt-3">Appointment scheduling and reminders</h5>
          <p>
            <b>LeadMine.pro</b> can pull data from your electronic health record (EHR) systems. This enables automatic appointment scheduling and reminders.
          </p>

             <p>
              <b>LeadMine.pro</b> also provides a web-based appointment scheduling system to further streamline the process both for the patient and the healthcare provider.
            </p>

          <div class="more-text">
         
            <h5 class="fw-semibold mt-3">Follow-up calls</h5>
            <p>
              Automated follow-up calls after treatments or surgeries can boost patient care and ensure patients stay on track with their recovery or treatment plans.
            </p>
          </div>

          <a href="#" class="read-more text-primary fw-semibold">Read More</a>
        </div>

        <!-- Feature 3 -->
        <div class="healthcare-content" id="feature3">
          <p>
            Healthcare call centers are the backbone of patient communication, and getting it right means everything.
          </p>
          <p>
            Most calls you take are from distressed patients, so the experience needs to be frictionless. Improving communication doesn’t just enhance the care you provide — it transforms it.
          </p>

            <p>
    Here’s how <b>LeadMine.pro</b> can make all the difference in driving better outcomes and patient satisfaction.
  </p>

<div class="more-text">

  <h5 class="fw-semibold mt-3">Personalized care</h5>
  <p>
    With <b>LeadMine.pro</b>, you’re not just answering a call — you’re responding with context. Patient records, past interactions, and notes are instantly visible to your team, so agents can greet patients by name and pick up exactly where the last conversation left off.
  </p>

  <h5 class="fw-semibold mt-3">Faster response times</h5>
  <p>
    Reduce patient wait times and eliminate missed calls with intelligent call routing. <b>LeadMine.pro</b> automatically assigns calls to the most available or skilled agent, ensuring that urgent calls are prioritized and patients feel cared for right away.
  </p>

  <h5 class="fw-semibold mt-3">Multi-channel communication</h5>
  <p>
    Go beyond voice — connect with patients over SMS, WhatsApp, and email directly within the same dashboard. <b>LeadMine.pro</b> ensures that every message is tracked, time-stamped, and securely logged for complete visibility.
  </p>

  <h5 class="fw-semibold mt-3">Performance insights</h5>
  <p>
    Track call analytics like response rates, resolution time, and agent performance through smart dashboards. Identify communication gaps and optimize your call flow for a smoother, patient-first experience.
  </p>

  <h5 class="fw-semibold mt-3">Continuous improvement</h5>
  <p>
    Use AI-driven call scoring and feedback tools within <b>LeadMine.pro</b> to coach your agents, refine scripts, and elevate patient communication quality over time.
  </p>
</div>


          <a href="#" class="read-more text-primary fw-semibold">Read More</a>
        </div>

        <!-- Feature 4 -->
        <div class="healthcare-content" id="feature4">
          <p class="fw-semibold mt-3">
            Setting up <b>LeadMine.pro</b> for your healthcare call center software involves the following steps:
            </p>

          <ol class="ps-3">
            <li>
             1. <b>Initial setup:</b> Sign up for a <b>LeadMine.pro</b> account. Choose a plan that fits your healthcare call center’s needs. Follow the setup instructions provided.
            </li>
            <li>
              2. <b>Integration with existing systems:</b> Connect <b>LeadMine.pro</b> with your electronic health records (EHR) and other systems. This ensures seamless data flow and access, improving patient care.
            </li>
            <li>
              3. <b>Configure call routing and IVR:</b> Set up advanced call routing and interactive voice response (IVR). Customize these features to efficiently handle patient calls and direct them appropriately.
            </li>
          </ol>

          <div class="more-text">
            <ol start="4" class="ps-3">
              <li>
               4. <b>Train your team:</b> Ensure your agents understand how to use <b>LeadMine.pro</b> efficiently. Train them on workflows, call handling, and data security practices.
              </li>
              <li>
               5. <b>Monitor & optimize:</b> Regularly review call performance metrics, identify areas for improvement, and refine processes to deliver better patient experiences.
              </li>
            </ol>
          </div>

          <a href="#" class="read-more text-primary fw-semibold">Read More</a>
        </div>
      </div>
    </div>
  </div>
</section>

<style>
  .healthcare-section {
    background: #fafcff;
    font-family: "Inter", "Helvetica Neue", Arial, sans-serif;
  }

  .healthcare-menu .list-group-item {
    border: none;
    background: transparent;
    color: #4a4a4a;
    font-weight: 500;
    font-size: 16px;
    line-height: 1.5;
    padding: 14px 10px;
    border-left: 3px solid transparent;
    transition: all 0.3s ease;
  }

  .healthcare-menu .list-group-item:hover {
    color: #0d6efd;
  }

  .healthcare-menu .list-group-item.active {
    color: #0d6efd;
    font-weight: 600;
    border-left-color: #0d6efd;
    background: #eef4ff;
  }

  .healthcare-content {
    display: none;
    color: #2b2b2b;
    font-size: 17px;
    line-height: 1.8;
    text-align: justify;
  }

  .healthcare-content.active {
    display: block;
  }

  .more-text {
    display: none;
    overflow: hidden;
    transition: all 0.4s ease;
  }

  .read-more {
    cursor: pointer;
    display: inline-block;
    margin-top: 6px;
    font-size: 15px;
    transition: color 0.3s;
  }

  .read-more:hover {
    color: #084fc7;
  }

  h5 {
    color: #111;
    margin-top: 18px;
  }

  ol li {
    margin-bottom: 10px;
  }
</style>

<script>
  // Sidebar tab switch
  document.querySelectorAll(".healthcare-menu a").forEach((tab) => {
    tab.addEventListener("click", function (e) {
      e.preventDefault();
      document.querySelectorAll(".healthcare-menu a").forEach((t) => t.classList.remove("active"));
      this.classList.add("active");

      document.querySelectorAll(".healthcare-content").forEach((c) => c.classList.remove("active"));
      document.querySelector(this.getAttribute("data-target")).classList.add("active");
    });
  });

  // Read More toggle with smooth reveal
  document.querySelectorAll(".read-more").forEach((btn) => {
    btn.addEventListener("click", function (e) {
      e.preventDefault();
      const moreText = this.previousElementSibling;
      if (moreText.style.display === "block") {
        moreText.style.display = "none";
        this.textContent = "Read More";
      } else {
        moreText.style.display = "block";
        this.textContent = "Read Less";
        moreText.style.maxHeight = "1000px";
      }
    });
  });
</script>



    
      <section class="integrations-section">
  <div class="container">
    <h2 class="section-title">Fits seamlessly into your tech stack</h2>

    <div class="integration-logos">
      <div class="logo-box">
        <img src="web/assets/images/hubspot.svg" alt="HubSpot">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/salesforce.svg" alt="Salesforce">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/pipedrive.svg" alt="Pipedrive">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/slack.svg" alt="Slack">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/intercom.svg" alt="Intercom">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/zendesk-icon.svg" alt="Zendesk">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/zoho.svg" alt="Zoho">
      </div>
      <div class="logo-box">
        <img src="web/assets/images/outreach.webp" alt="Outreach">
      </div>
    </div>

    <div class="btn-wrapper">
      <a href="<?php echo e(route('register')); ?>" class="view-btn">Start free trial</a>
    </div>
  </div>
</section>


<style>
.integrations-section {
  text-align: center;
  padding: 80px 20px;
  background-color: #fff;
}

.integrations-section .section-title {
  font-size: 32px;
  font-weight: 700;
  color: #0b0c2a;
  margin-bottom: 50px;
}

.integration-logos {
  display: flex;
  flex-wrap: wrap;
  justify-content: center;
  gap: 25px;
  margin-bottom: 50px;
}

.logo-box {
  width: 140px;
  height: 140px;
  background: #fff;
  border-radius: 20px;
  box-shadow: 0 0 0 1px #e5e7eb;
  display: flex;
  align-items: center;
  justify-content: center;
  transition: all 0.3s ease;
}

.logo-box img {
  width: 60px;
  height: auto;
  transition: transform 0.3s ease;
}

.logo-box:hover {
  transform: translateY(-8px);
  box-shadow: 0 8px 25px rgba(0, 0, 0, 0.08);
}

.logo-box:hover img {
  transform: scale(1.1);
}

.view-btn {
  display: inline-block;
  background-color: #0052ff;
  color: #fff;
  font-weight: 600;
  padding: 14px 28px;
  border-radius: 8px;
  text-decoration: none;
  transition: background 0.3s ease;
}

.view-btn:hover {
  background-color: #003ed6;
}

.btn-wrapper {
  margin-top: 20px;
}
</style>


 <!-- ================== Pricing Plan one End ====================== -->



 <?php $__env->stopSection(); ?>
<?php echo $__env->make('website.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/leadmine/leadmine_pro/resources/views/website/healthcare.blade.php ENDPATH**/ ?>